/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.message.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.event.ThirdMessageWecomEvent;
import com.digiwin.athena.semc.mapper.message.ThirdMessageInfoMapper;
import com.digiwin.athena.semc.proxy.emc.service.EmcService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.AppUserDTO;
import com.digiwin.athena.semc.service.message.ThirdMessageInfoService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdMessageInfoServiceImpl
extends ServiceImpl<ThirdMessageInfoMapper, ThirdMessageInfo>
implements ThirdMessageInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdMessageInfoServiceImpl.class);
    @Resource
    private IamService iamService;
    @Resource
    private EmcService emcService;
    @Resource
    private EnvProperties envProperties;

    public void sendWecom(ThirdMessageWecomEvent event) {
        String userToken = event.getThirdMessageWecomEventDTO().getUserToken();
        JSONObject jsonObject = this.emcService.queryWeComConfig(userToken);
        if (ObjectUtils.isEmpty((Object)jsonObject)) {
            jsonObject = new JSONObject();
            jsonObject.put("appId", (Object)this.envProperties.getWeChatAppId());
            jsonObject.put("corpId", (Object)this.envProperties.getWeChatCorpId());
        }
        String tenantId = event.getThirdMessageWecomEventDTO().getTenantId();
        List newMessageInfoList = event.getThirdMessageWecomEventDTO().getNewMessageInfoList();
        for (ThirdMessageInfo thirdMessageInfo : newMessageInfoList) {
            List appUserList = this.iamService.queryAllVerifyMappingUser(userToken, thirdMessageInfo.getMessageAppCode());
            if (CollectionUtils.isEmpty((Collection)appUserList)) {
                return;
            }
            if (thirdMessageInfo.getMessageOwner().equals("all")) {
                List userIdList = appUserList.stream().map(AppUserDTO::getUserId).collect(Collectors.toList());
                this.sendWecomMessage(jsonObject, thirdMessageInfo, userIdList, tenantId, userToken);
                continue;
            }
            List<String> verifyIdList = Arrays.asList(thirdMessageInfo.getMessageOwner().split(","));
            List userIdList = appUserList.stream().filter(x -> verifyIdList.contains(x.getVerifyUserId())).map(AppUserDTO::getUserId).collect(Collectors.toList());
            this.sendWecomMessage(jsonObject, thirdMessageInfo, userIdList, tenantId, userToken);
        }
    }

    private void sendWecomMessage(JSONObject jsonObject, ThirdMessageInfo thirdMessageInfo, List<String> userIdList, String tenantId, String userToken) {
        if (StringUtils.isBlank((CharSequence)thirdMessageInfo.getMessageUrl()) && StringUtils.isBlank((CharSequence)thirdMessageInfo.getMobileMessageUrl())) {
            this.emcService.sendWeChat(userIdList, thirdMessageInfo.getMessageTitle(), userToken);
        } else if (ObjectUtils.isEmpty((Object)jsonObject) || StringUtils.isBlank((CharSequence)jsonObject.getString("appId")) || StringUtils.isBlank((CharSequence)jsonObject.getString("corpId"))) {
            this.emcService.sendWeChat(userIdList, thirdMessageInfo.getMessageTitle(), userToken);
        } else {
            String agentId = jsonObject.getString("appId");
            String corpId = jsonObject.getString("corpId");
            String redirectUri = this.envProperties.getSemcUrl() + "/semc/router/thirdMessageRouting?appId=" + agentId + "&tenantId=" + tenantId + "&messageAppCode=" + thirdMessageInfo.getMessageAppCode() + "&messageUrl=" + thirdMessageInfo.getMessageUrl() + "&mobileMessageUrl=" + thirdMessageInfo.getMobileMessageUrl();
            log.info("third message send wecom. redirectUri:{}", (Object)redirectUri);
            String encodeRedirectUri = null;
            try {
                encodeRedirectUri = URLEncoder.encode(redirectUri, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("URLEncoder.encode(uri) occur error. uri:{}", (Object)redirectUri, (Object)e);
            }
            String weChatUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + encodeRedirectUri + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + agentId + "#wechat_redirect";
            String text = String.format("<a href=\"%s\">%s</a>", weChatUrl, thirdMessageInfo.getMessageTitle());
            this.emcService.sendWeChat(userIdList, text, userToken);
        }
    }
}

