/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.message.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageListReq;
import com.digiwin.athena.semc.dto.message.ReadThirdMessageReq;
import com.digiwin.athena.semc.dto.message.ReceiveThirdMessageReq;
import com.digiwin.athena.semc.dto.message.SaveThirdMessageConfigReq;
import com.digiwin.athena.semc.dto.message.ThirdMessageListResp;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.message.ThirdMessageAppSort;
import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;
import com.digiwin.athena.semc.entity.message.ThirdMessageInfo;
import com.digiwin.athena.semc.entity.message.ThirdMessageReadInfo;
import com.digiwin.athena.semc.entity.message.ThirdMessageType;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.event.ThirdMessageWecomEvent;
import com.digiwin.athena.semc.event.dto.ThirdMessageWecomEventDTO;
import com.digiwin.athena.semc.mapper.message.ThirdMessageAppSortMapper;
import com.digiwin.athena.semc.mapper.message.ThirdMessageTypeMapper;
import com.digiwin.athena.semc.mapper.message.ThirdSystemMessageMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.AccountDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.AppUserDTO;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.message.ThirdMessageInfoService;
import com.digiwin.athena.semc.service.message.ThirdMessageReadInfoService;
import com.digiwin.athena.semc.service.message.ThirdSystemMessageService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.news.ThirdNewsAnnouncementService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.message.MessageAppNumResp;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import io.vavr.Tuple3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThirdSystemMessageServiceImpl
extends ServiceImpl<ThirdSystemMessageMapper, ThirdMessageConfig>
implements ThirdSystemMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdSystemMessageServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Resource
    ThirdSystemMessageMapper thirdSystemMessageMapper;
    @Autowired
    ThirdMessageInfoService thirdMessageInfoService;
    @Autowired
    ThirdMessageReadInfoService thirdMessageReadInfoService;
    @Autowired
    private TripartiteService tripartiteService;
    @Autowired
    private ESPService espService;
    @Resource
    private IamService iamService;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private MessageSendService messageSendService;
    @Resource
    private ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    private ErpSsoInfoMapper erpSsoInfoMapper;
    @Autowired
    ThirdNewsAnnouncementService thirdNewsAnnouncementService;
    @Resource
    PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private ThirdMessageAppSortMapper thirdMessageAppSortMapper;
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Resource
    private Converter converter;
    @Resource
    private ThirdMessageTypeMapper thirdMessageTypeMapper;
    public static final String ALL_STAFF_CAN_SEE_FLAG = "all";
    public static final int MESSAGE_READ_FLAG_ALL = 0;
    public static final int MESSAGE_READ_FLAG_READ = 1;
    public static final int MESSAGE_READ_FLAG_UNREAD = 2;

    public List<ThirdMessageConfig> queryConfigByAppCode(String appCode, String appId) {
        return this.thirdSystemMessageMapper.queryConfigByAppCode(appCode, appId);
    }

    public PageInfoResp<ThirdMessageConfig> queryMessageConfigPage(QueryThirdMessageConfigReq queryThirdMessageConfigReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryThirdMessageConfigReq.getAppPrimaryId())) {
            condition.eq((Object)"app_primary_id", (Object)queryThirdMessageConfigReq.getAppPrimaryId());
        }
        if (queryThirdMessageConfigReq.getValidStatus() != null) {
            condition.eq((Object)"valid_status", (Object)queryThirdMessageConfigReq.getValidStatus());
        }
        if (queryThirdMessageConfigReq.getAppSource() != null) {
            condition.eq((Object)"app_source", (Object)queryThirdMessageConfigReq.getAppSource());
        }
        if (queryThirdMessageConfigReq.getDataGetType() != null) {
            condition.eq((Object)"data_get_type", (Object)queryThirdMessageConfigReq.getDataGetType());
        }
        ((QueryWrapper)condition.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId())).orderByDesc((Object)"modify_time");
        PageInfoResp pageInfoResp = new PageInfoResp();
        Page pageResult = (Page)this.thirdSystemMessageMapper.selectPage((IPage)new Page((long)queryThirdMessageConfigReq.getPageNum().intValue(), (long)queryThirdMessageConfigReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult == null || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageInfoResp;
        }
        List messageConfigList = pageResult.getRecords();
        this.packageAppCodeName(messageConfigList);
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(queryThirdMessageConfigReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryThirdMessageConfigReq.getPageSize().intValue());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(messageConfigList);
        return pageInfoResp;
    }

    public void packageAppCodeName(List<ThirdMessageConfig> messageConfigList) {
        List csList = messageConfigList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        Map erpInfoMap = this.getErpInfoMap(csList);
        List bsList = messageConfigList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.getSsoInfoMap(bsList);
        Map preInfoMap = this.getPreInfoMap();
        for (ThirdMessageConfig messageConfig : messageConfigList) {
            PreinstalledApplication preinstalledApplication;
            ThirdSsoInfo thirdSsoInfo;
            ErpSsoInfo erpSsoInfo;
            String appName = "";
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(messageConfig.getAppSource()) && null != (erpSsoInfo = (ErpSsoInfo)erpInfoMap.get(Long.parseLong(messageConfig.getAppPrimaryId())))) {
                appName = erpSsoInfo.getName();
            }
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(messageConfig.getAppSource()) && (thirdSsoInfo = (ThirdSsoInfo)thirdSsoInfoMap.get(Long.parseLong(messageConfig.getAppPrimaryId()))) != null) {
                appName = thirdSsoInfo.getAppName();
            }
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(messageConfig.getAppSource()) && null != (preinstalledApplication = (PreinstalledApplication)preInfoMap.get(Long.parseLong(messageConfig.getAppPrimaryId())))) {
                appName = preinstalledApplication.getApplicationName();
            }
            messageConfig.setAppName(appName);
        }
    }

    public Map<Long, PreinstalledApplication> getPreInfoMap() {
        List preinstalledAppList = this.preinstalledApplicationMapper.selectList((Wrapper)new QueryWrapper());
        Map<Long, PreinstalledApplication> preInfoMap = preinstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        return preInfoMap;
    }

    public Map<Long, ErpSsoInfo> getErpInfoMap(List<ThirdMessageConfig> csList) {
        Map<Long, Object> erpInfoMap = new HashMap<Long, ErpSsoInfo>();
        if (CollectionUtils.isEmpty(csList)) {
            return erpInfoMap;
        }
        List thirdFolderIdList = csList.stream().map(ThirdMessageConfig::getAppPrimaryId).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List erpInfoList = this.erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        erpInfoMap = erpInfoList.stream().collect(Collectors.toMap(ErpSsoInfo::getId, Function.identity(), (a, b) -> a));
        return erpInfoMap;
    }

    public Map<Long, ThirdSsoInfo> getSsoInfoMap(List<ThirdMessageConfig> bsList) {
        Map<Long, Object> thirdSsoInfoMap = new HashMap<Long, ThirdSsoInfo>();
        if (CollectionUtils.isEmpty(bsList)) {
            return thirdSsoInfoMap;
        }
        List thirdFolderIdList = bsList.stream().map(ThirdMessageConfig::getAppPrimaryId).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List thirdSsoInfoList = this.thirdSsoInfoMapper.queryThirdListByScope(querySsoListReq);
        thirdSsoInfoMap = thirdSsoInfoList.stream().collect(Collectors.toMap(ThirdSsoInfo::getId, Function.identity(), (a, b) -> a));
        return thirdSsoInfoMap;
    }

    public boolean validMessageConfigExist(SaveThirdMessageConfigReq saveThirdMessageConfigReq) {
        ThirdMessageConfig thirdMessageConfig;
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"app_source", (Object)saveThirdMessageConfigReq.getAppSource());
        condition.eq((Object)"app_primary_id", (Object)saveThirdMessageConfigReq.getAppPrimaryId());
        if (saveThirdMessageConfigReq.getId() != null) {
            condition.ne((Object)"id", (Object)saveThirdMessageConfigReq.getId());
        }
        return (thirdMessageConfig = (ThirdMessageConfig)this.thirdSystemMessageMapper.selectOne((Wrapper)condition)) != null;
    }

    public ThirdMessageConfig saveApplication(SaveThirdMessageConfigReq saveThirdMessageConfigReq) {
        if (saveThirdMessageConfigReq.getId() == null) {
            ThirdMessageConfig thirdMessageConfig = (ThirdMessageConfig)this.converter.convert((Object)saveThirdMessageConfigReq, ThirdMessageConfig.class);
            thirdMessageConfig.setValidStatus(saveThirdMessageConfigReq.getValidStatus());
            this.thirdSystemMessageMapper.insert((Object)thirdMessageConfig);
            return thirdMessageConfig;
        }
        ThirdMessageConfig thirdMessageConfig = (ThirdMessageConfig)this.converter.convert((Object)saveThirdMessageConfigReq, ThirdMessageConfig.class);
        thirdMessageConfig.setValidStatus(saveThirdMessageConfigReq.getValidStatus());
        this.thirdSystemMessageMapper.updateById((Object)thirdMessageConfig);
        return thirdMessageConfig;
    }

    public void receiveMessage(ReceiveThirdMessageReq receiveThirdMessageReq) {
        String userToken;
        Tuple3 tuple3 = this.thirdNewsAnnouncementService.checkAppCode(receiveThirdMessageReq.getAppId(), receiveThirdMessageReq.getAppCode());
        String tenantId = (String)tuple3._2;
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            log.warn("\u63a5\u6536\u5f02\u6784\u7cfb\u7edf\u7684\u6d88\u606f\u63a8\u9001\u79df\u6237id\u4e3a\u7a7a\uff1a{}", tuple3._1);
            return;
        }
        QueryWrapper condition = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"message_app_id", (Object)receiveThirdMessageReq.getAppId())).eq((Object)"tenant_id", (Object)tenantId);
        List thirdMessageInfoList = this.thirdMessageInfoService.list((Wrapper)condition);
        HashMap existMessageMap = CollectionUtils.isNotEmpty((Collection)thirdMessageInfoList) ? thirdMessageInfoList.stream().collect(Collectors.toMap(ThirdMessageInfo::getMessageId, a -> a, (k1, k2) -> k1)) : Maps.newHashMap();
        boolean allSeeFlag = Boolean.FALSE;
        ArrayList verifyUserIdList = Lists.newArrayList();
        ArrayList messageList = Lists.newArrayList();
        ArrayList<ThirdMessageInfo> newMessageInfoList = new ArrayList<ThirdMessageInfo>();
        for (ThirdMessageInfo info : receiveThirdMessageReq.getMessageList()) {
            if (existMessageMap.containsKey(info.getMessageId())) {
                ThirdMessageInfo existInfo = (ThirdMessageInfo)existMessageMap.get(info.getMessageId());
                info.setId(existInfo.getId());
                info.setModifyTime(DateUtils.getNowTime(null));
                if (Constants.MESSAGE_ALL_STAFF_FLAG.equals(info.getMessageAllStaffRead())) {
                    info.setMessageOwner(ALL_STAFF_CAN_SEE_FLAG);
                    allSeeFlag = Boolean.TRUE;
                } else {
                    info.setMessageOwner(existInfo.getMessageOwner().equals(ALL_STAFF_CAN_SEE_FLAG) ? info.getMessageOwner() : existInfo.getMessageOwner() + "," + info.getMessageOwner());
                    verifyUserIdList.addAll(Arrays.asList(info.getMessageOwner().split(",")));
                }
            } else {
                info.setMessageAppCode(receiveThirdMessageReq.getAppCode());
                info.setMessageAppId(receiveThirdMessageReq.getAppId());
                info.setCreateTime(DateUtils.getNowTime(null));
                info.setModifyTime(DateUtils.getNowTime(null));
                if (Constants.MESSAGE_ALL_STAFF_FLAG.equals(info.getMessageAllStaffRead())) {
                    info.setMessageOwner(ALL_STAFF_CAN_SEE_FLAG);
                    allSeeFlag = Boolean.TRUE;
                } else {
                    verifyUserIdList.addAll(Arrays.asList(info.getMessageOwner().split(",")));
                    newMessageInfoList.add(info);
                }
            }
            info.setMessageTitle(info.getMessageTitle());
            info.setMessageContent(info.getMessageContent());
            info.setMessageUrl(info.getMessageUrl());
            info.setTenantId(tenantId);
            messageList.add(info);
        }
        if (CollectionUtils.isNotEmpty((Collection)messageList)) {
            this.thirdMessageInfoService.saveOrUpdateBatch((Collection)messageList);
        }
        Integer sideType = ((ThirdMessageInfo)messageList.get(0)).getSideType();
        if (Boolean.TRUE.equals(allSeeFlag)) {
            MessageDO payload = new MessageDO();
            payload.setTenantId(tenantId);
            payload.setAllStaffNoticeFlag(Boolean.TRUE);
            payload.setType(Integer.valueOf(2));
            payload.setAppId(receiveThirdMessageReq.getAppCode());
            if (Objects.equals(0, sideType)) {
                this.messageSendService.sendToClient(null, payload, "THIRD_MESSAGE_NOTICE");
            }
            if (Objects.equals(1, sideType)) {
                this.messageSendService.sendToClient(null, payload, "THIRD_MESSAGE_MOBILE_NOTICE");
            }
            if (Objects.equals(2, sideType)) {
                this.messageSendService.sendToClient(null, payload, "THIRD_MESSAGE_NOTICE");
                this.messageSendService.sendToClient(null, payload, "THIRD_MESSAGE_MOBILE_NOTICE");
            }
        } else {
            List distinctList = verifyUserIdList.stream().distinct().collect(Collectors.toList());
            for (String verifyUserId : distinctList) {
                MessageDO payload = new MessageDO();
                payload.setTenantId(tenantId);
                payload.setUserId(verifyUserId);
                payload.setType(Integer.valueOf(2));
                payload.setAppId(receiveThirdMessageReq.getAppCode());
                if (Objects.equals(0, sideType)) {
                    this.messageSendService.sendToClient(verifyUserId, payload, "THIRD_MESSAGE_NOTICE");
                }
                if (Objects.equals(1, sideType)) {
                    this.messageSendService.sendToClient(verifyUserId, payload, "THIRD_MESSAGE_MOBILE_NOTICE");
                }
                if (!Objects.equals(2, sideType)) continue;
                this.messageSendService.sendToClient(verifyUserId, payload, "THIRD_MESSAGE_NOTICE");
                this.messageSendService.sendToClient(verifyUserId, payload, "THIRD_MESSAGE_MOBILE_NOTICE");
            }
        }
        String sendChannel = receiveThirdMessageReq.getSendChannel();
        if (StringUtils.isNotBlank((CharSequence)sendChannel) && sendChannel.contains(Constants.MessageChannelEnum.WECOM.getFlag()) && CollectionUtils.isNotEmpty(newMessageInfoList) && StringUtils.isNotBlank((CharSequence)(userToken = this.iamService.queryIntegrationUserToken(tenantId)))) {
            ThirdMessageWecomEventDTO thirdMessageWecomEventDTO = new ThirdMessageWecomEventDTO();
            thirdMessageWecomEventDTO.setNewMessageInfoList(newMessageInfoList);
            thirdMessageWecomEventDTO.setTenantId(tenantId);
            thirdMessageWecomEventDTO.setUserToken(userToken);
            ThirdMessageWecomEvent thirdMessageWecomEvent = new ThirdMessageWecomEvent((Object)this, thirdMessageWecomEventDTO);
            this.eventPublisher.publishEvent((ApplicationEvent)thirdMessageWecomEvent);
        }
    }

    public Long queryUnreadCount(Integer clientType) {
        QueryThirdMessageListReq queryThirdMessageListReq = new QueryThirdMessageListReq();
        queryThirdMessageListReq.setClientType(clientType);
        List messageInfoList = this.queryMessageList(queryThirdMessageListReq, null);
        if (CollectionUtils.isEmpty((Collection)messageInfoList)) {
            return 0L;
        }
        return messageInfoList.stream().filter(x -> x.getIsRed().equals(true)).count();
    }

    private void queryAccountList(List<AppUserDTO> verifyUserList) {
        List accountDTOList = this.iamService.queryTenantAccountMappingList(null, null, null);
        if (CollectionUtils.isEmpty((Collection)accountDTOList)) {
            return;
        }
        Map<String, List<AccountDTO>> appCodeMap = accountDTOList.stream().collect(Collectors.groupingBy(AccountDTO::getAppId));
        for (AppUserDTO appUserDTO : verifyUserList) {
            if (!CollectionUtils.isNotEmpty((Collection)appCodeMap.get(appUserDTO.getAppCode()))) continue;
            List<AccountDTO> accountList = appCodeMap.get(appUserDTO.getAppCode());
            ArrayList accountIdList = Lists.newArrayList();
            accountList.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getAccount())) {
                    accountIdList.add(x.getAccount());
                } else if (StringUtils.isNotBlank((CharSequence)x.getCompanyId())) {
                    accountIdList.add(x.getCompanyId());
                }
            });
            appUserDTO.setAccountIdList((List)accountIdList);
        }
    }

    private List<AppUserDTO> queryVerifyUseridList(List<ThirdMessageInfo> thirdMessageInfoList) {
        thirdMessageInfoList = thirdMessageInfoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ThirdMessageInfo>(Comparator.comparing(ThirdMessageInfo::getMessageAppCode))), ArrayList::new));
        ArrayList appVerifyUserIdList = Lists.newArrayList();
        for (ThirdMessageInfo thirdMessageInfo : thirdMessageInfoList) {
            String verifyUserId = this.iamService.queryMappingEmpId(thirdMessageInfo.getMessageAppCode());
            if (!StringUtils.isNotBlank((CharSequence)verifyUserId)) continue;
            AppUserDTO appUserDTO = new AppUserDTO();
            appUserDTO.setAppCode(thirdMessageInfo.getMessageAppCode());
            appUserDTO.setAppId(thirdMessageInfo.getMessageAppId());
            appUserDTO.setVerifyUserId(verifyUserId);
            appVerifyUserIdList.add(appUserDTO);
        }
        return appVerifyUserIdList;
    }

    public PageInfoResp<ThirdMessageInfo> queryMessageListPage(QueryThirdMessageListReq queryThirdMessageListReq) {
        PageInfoResp pageInfoResp = new PageInfoResp();
        List appLinkDTOList = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
        List messageInfoList = this.queryMessageList(queryThirdMessageListReq, appLinkDTOList);
        if (CollectionUtils.isEmpty((Collection)messageInfoList)) {
            return pageInfoResp;
        }
        if (ObjectUtils.isNotEmpty((Object)queryThirdMessageListReq.getReadFlag()) && !queryThirdMessageListReq.getReadFlag().equals(0)) {
            if (queryThirdMessageListReq.getReadFlag().equals(1)) {
                messageInfoList = messageInfoList.stream().filter(x -> x.getIsRed().equals(false)).collect(Collectors.toList());
            }
            if (queryThirdMessageListReq.getReadFlag().equals(2)) {
                messageInfoList = messageInfoList.stream().filter(x -> x.getIsRed().equals(true)).collect(Collectors.toList());
            }
        }
        messageInfoList = messageInfoList.stream().sorted(Comparator.comparing(ThirdMessageInfo::getMessagePublishTime).reversed()).collect(Collectors.toList());
        int fromIndex = (queryThirdMessageListReq.getPageNum() - 1) * queryThirdMessageListReq.getPageSize();
        if (fromIndex >= messageInfoList.size() || fromIndex < 0) {
            return pageInfoResp;
        }
        int toIndex = fromIndex + queryThirdMessageListReq.getPageSize();
        if (toIndex > messageInfoList.size()) {
            toIndex = messageInfoList.size();
        }
        List messageInfoRespList = messageInfoList.subList(fromIndex, toIndex);
        List messageTypeList = this.thirdMessageTypeMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        Map<String, String> messageTypeMap = messageTypeList.stream().collect(Collectors.toMap(ThirdMessageType::getMessageTypeCode, ThirdMessageType::getMessageTypeName, (a, b) -> a));
        block0: for (ThirdMessageInfo messageInfo : messageInfoRespList) {
            messageInfo.setMessageTypeName(messageTypeMap.get(messageInfo.getMessageTypeCode()));
            for (AppLinkDTO appLinkDTO : appLinkDTOList) {
                if (!messageInfo.getMessageAppCode().equals(appLinkDTO.getCode())) continue;
                messageInfo.setMessageAppName(appLinkDTO.getName());
                messageInfo.setCallBackUrl(appLinkDTO.getCallBackUrl());
                messageInfo.setApplicationAppId(appLinkDTO.getApplicationAppId());
                messageInfo.setProtocolType(appLinkDTO.getProtocolType());
                messageInfo.setAppToken(appLinkDTO.getAppToken());
                if (Objects.isNull(messageInfo.getSideType())) {
                    messageInfo.setSideType(Integer.valueOf(0));
                }
                if (Objects.equals(0, messageInfo.getSideType())) {
                    messageInfo.setMessageUrl(this.appLinkService.parseJumpUrl(messageInfo.getMessageUrl(), appLinkDTO));
                }
                if (Objects.equals(1, messageInfo.getSideType())) {
                    messageInfo.setMobileMessageUrl(this.appLinkService.parseJumpUrl(messageInfo.getMobileMessageUrl(), appLinkDTO));
                }
                if (!Objects.equals(2, messageInfo.getSideType())) continue block0;
                messageInfo.setMessageUrl(this.appLinkService.parseJumpUrl(messageInfo.getMessageUrl(), appLinkDTO));
                messageInfo.setMobileMessageUrl(this.appLinkService.parseJumpUrl(messageInfo.getMobileMessageUrl(), appLinkDTO));
                continue block0;
            }
        }
        int total = messageInfoList.size();
        int totalPages = total % queryThirdMessageListReq.getPageSize() == 0 ? total / queryThirdMessageListReq.getPageSize() : total / queryThirdMessageListReq.getPageSize() + 1;
        pageInfoResp.setTotalPages(totalPages);
        pageInfoResp.setPageNo(queryThirdMessageListReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryThirdMessageListReq.getPageSize().intValue());
        pageInfoResp.setTotalRecords(total);
        pageInfoResp.setList(messageInfoRespList);
        return pageInfoResp;
    }

    public ThirdMessageListResp listMessage(QueryThirdMessageListReq queryThirdMessageListReq) {
        List thirdMessageInfoList;
        ArrayList<Integer> list;
        ThirdMessageListResp listResp = new ThirdMessageListResp();
        List appLinkDTOList = new ArrayList();
        List verifyUserList = new ArrayList();
        ArrayList messageInfoList = Lists.newArrayList();
        LambdaQueryWrapper condition = new LambdaQueryWrapper();
        condition.eq(ThirdMessageInfo::getTenantId, (Object)Utils.getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)queryThirdMessageListReq.getStartTimeStr())) {
            condition.ge(ThirdMessageInfo::getMessagePublishTime, (Object)DateUtils.StringToDate((String)(queryThirdMessageListReq.getStartTimeStr() + " 00:00:00")));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryThirdMessageListReq.getEndTimeStr())) {
            condition.le(ThirdMessageInfo::getMessagePublishTime, (Object)DateUtils.StringToDate((String)(queryThirdMessageListReq.getEndTimeStr() + " 23:59:59")));
        }
        if (0 == queryThirdMessageListReq.getClientType()) {
            list = new ArrayList<Integer>();
            list.add(0);
            list.add(2);
            condition.in(ThirdMessageInfo::getSideType, list);
        }
        if (1 == queryThirdMessageListReq.getClientType()) {
            list = new ArrayList();
            list.add(1);
            list.add(2);
            condition.in(ThirdMessageInfo::getSideType, list);
        }
        if (CollectionUtils.isEmpty((Collection)(thirdMessageInfoList = this.thirdMessageInfoService.list((Wrapper)condition)))) {
            listResp.setAppLinkDTOList(appLinkDTOList);
            listResp.setVerifyUserList(verifyUserList);
            listResp.setMessageInfoList((List)messageInfoList);
            return listResp;
        }
        appLinkDTOList = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
        List appIdList = appLinkDTOList.stream().map(AppLinkDTO::getApplicationAppId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        thirdMessageInfoList = thirdMessageInfoList.stream().filter(x -> appIdList.contains(x.getMessageAppId())).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)queryThirdMessageListReq.getAppId())) {
            thirdMessageInfoList = thirdMessageInfoList.stream().filter(x -> queryThirdMessageListReq.getAppId().equals(x.getMessageAppId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(verifyUserList = this.queryVerifyUseridList(thirdMessageInfoList))) {
            listResp.setAppLinkDTOList(appLinkDTOList);
            listResp.setVerifyUserList(verifyUserList);
            listResp.setMessageInfoList((List)messageInfoList);
            return listResp;
        }
        for (AppUserDTO appUserDTO : verifyUserList) {
            for (ThirdMessageInfo x2 : thirdMessageInfoList) {
                if (!x2.getMessageAppId().equals(appUserDTO.getAppId()) || !Arrays.asList(x2.getMessageOwner().split(",")).contains(appUserDTO.getVerifyUserId()) && !Arrays.asList(x2.getMessageOwner().split(",")).contains(ALL_STAFF_CAN_SEE_FLAG)) continue;
                messageInfoList.add(x2);
            }
        }
        listResp.setAppLinkDTOList(appLinkDTOList);
        listResp.setVerifyUserList(verifyUserList);
        listResp.setMessageInfoList((List)messageInfoList);
        return listResp;
    }

    public void readMessage(ReadThirdMessageReq readThirdMessageReq) {
        QueryWrapper readCondition = new QueryWrapper();
        readCondition.eq((Object)"message_app_code", (Object)readThirdMessageReq.getMessageAppCode());
        readCondition.eq((Object)"message_app_id", (Object)readThirdMessageReq.getMessageAppId());
        readCondition.eq((Object)"message_id", (Object)readThirdMessageReq.getMessageId());
        readCondition.eq((Object)"read_user", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        readCondition.eq((Object)"tenant_id", (Object)Utils.getTenantId());
        List readInfos = this.thirdMessageReadInfoService.getBaseMapper().selectList((Wrapper)readCondition);
        if (CollectionUtils.isEmpty((Collection)readInfos)) {
            String verifyUserId = this.iamService.queryMappingEmpId(readThirdMessageReq.getMessageAppCode());
            ThirdMessageReadInfo readInfo = new ThirdMessageReadInfo();
            readInfo = new ThirdMessageReadInfo();
            readInfo.setMessageAppCode(readThirdMessageReq.getMessageAppCode());
            readInfo.setMessageAppId(readThirdMessageReq.getMessageAppId());
            readInfo.setMessageId(readThirdMessageReq.getMessageId());
            readInfo.setReadUser(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            readInfo.setReadSourceUser(verifyUserId);
            readInfo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            readInfo.setTenantId(Utils.getTenantId());
            this.thirdMessageReadInfoService.save((Object)readInfo);
        }
    }

    public void deleteBatchApp(DeleteMessageConfigReq deleteMessageConfigReq) {
        if (CollectionUtils.isNotEmpty((Collection)deleteMessageConfigReq.getIdList())) {
            this.thirdSystemMessageMapper.deleteBatchIds((Collection)deleteMessageConfigReq.getIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)deleteMessageConfigReq.getPrimaryIdList())) {
            QueryWrapper condition = new QueryWrapper();
            condition.in((Object)"app_primary_id", (Collection)deleteMessageConfigReq.getPrimaryIdList());
            this.thirdSystemMessageMapper.delete((Wrapper)condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<?> syncMessageData() {
        block20: {
            String tenantsid = Utils.getTenantId();
            QueryWrapper condition = new QueryWrapper();
            condition.eq((Object)"data_get_type", (Object)2);
            condition.eq((Object)"valid_status", (Object)1);
            List thirdMessageConfigList = this.thirdSystemMessageMapper.selectList((Wrapper)condition);
            if (CollectionUtils.isEmpty((Collection)thirdMessageConfigList)) {
                return ResponseEntityWrapper.wrapperOk((Object)this.messageUtils.getMessage("error.message.third.data.updated"));
            }
            RedisLock redisLock = new RedisLock(((ThirdMessageConfig)thirdMessageConfigList.get(thirdMessageConfigList.size() - 1)).getAppPrimaryId() + tenantsid);
            try {
                if (redisLock.isLocked()) break block20;
                redisLock.lock();
                block9: for (ThirdMessageConfig config : thirdMessageConfigList) {
                    List messageList = new ArrayList();
                    Integer appAccessModel = config.getAppAccessModel();
                    String messageAppCode = config.getAppCode();
                    String appId = config.getApplicationAppId();
                    if (appAccessModel == 0) {
                        String middleSystemName = config.getMiddleSystemName();
                        String middleSystemUid = config.getMiddleSystemUid();
                        HashMap<String, String> extHeader = new HashMap<String, String>();
                        extHeader.put("digi-userToken", Utils.getUserToken());
                        extHeader.put("digi-appToken", this.envProperties.getAppToken());
                        int i = 1;
                        while (true) {
                            HashMap<String, Object> parameter = new HashMap<String, Object>();
                            parameter.put("page_no", i);
                            parameter.put("page_size", 100);
                            parameter.put("tenant_id", tenantsid);
                            try {
                                Map result = this.espService.queryByEsp(middleSystemName, middleSystemUid, EAIServiceNameEnum.MESSAGE_PULL.getServiceName(), extHeader, parameter, null, null);
                                if (Objects.isNull(result.get("message_list"))) {
                                    System.out.println("syncMessageData \u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u6d88\u606f\u6570\u636e");
                                    break;
                                }
                                messageList = (List)result.get("message_list");
                                System.out.println("syncMessageData \u6df7\u5408\u4e91\u6d88\u606f\u6570\u636e" + messageList);
                                if (CollectionUtils.isNotEmpty(messageList)) {
                                    this.handleMessageData(messageAppCode, appId, messageList);
                                }
                                if (!((Boolean)result.get("has_next")).booleanValue()) {
                                }
                            }
                            catch (Exception e) {}
                            break;
                            ++i;
                        }
                    }
                    if (appAccessModel != 1) continue;
                    int i = 1;
                    while (true) {
                        String domain = config.getDomain();
                        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
                        bodyMap.put("page_no", i);
                        bodyMap.put("page_size", 100);
                        bodyMap.put("tenant_id", tenantsid);
                        try {
                            Map jobData = this.tripartiteService.queryThirdData(domain + "/third/message/query", "", bodyMap);
                            if (null == jobData) {
                                System.out.println("syncMessageData \u975e\u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u6d88\u606f\u6570\u636e");
                                continue block9;
                            }
                            messageList = (List)jobData.get("message_list");
                            System.out.println("syncMessageData \u975e\u6df7\u5408\u4e91\u6d88\u606f\u6570\u636e" + messageList);
                            if (CollectionUtils.isNotEmpty(messageList)) {
                                this.handleMessageData(messageAppCode, appId, messageList);
                            }
                            if (!((Boolean)jobData.get("has_next")).booleanValue()) {
                            }
                        }
                        catch (Exception e) {}
                        continue block9;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            finally {
                redisLock.unlock();
            }
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.messageUtils.getMessage("error.message.third.data.updated"));
    }

    public ResponseEntity<BaseResultDTO<Integer>> readAllMessage(QueryThirdMessageListReq queryThirdMessageListReq) {
        ThirdMessageListResp listResp = this.listMessage(queryThirdMessageListReq);
        List messageInfoList = listResp.getMessageInfoList();
        List verifyUserList = listResp.getVerifyUserList();
        if (CollectionUtils.isEmpty((Collection)messageInfoList)) {
            return ResponseEntityWrapperUtil.wrapperOk((Object)0);
        }
        Map<Object, Object> verifyUserMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)verifyUserList)) {
            verifyUserMap = verifyUserList.stream().collect(Collectors.toMap(value -> value.getAppCode() + "-" + value.getAppId(), value -> value.getVerifyUserId(), (key1, key2) -> key1));
        }
        List messageIdList = messageInfoList.stream().map(ThirdMessageInfo::getMessageId).distinct().collect(Collectors.toList());
        QueryWrapper readCondition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(messageIdList)) {
            readCondition.in((Object)"message_id", messageIdList);
        }
        readCondition.eq((Object)"read_user", (Object)Utils.getUserId());
        readCondition.eq((Object)"tenant_id", (Object)Utils.getTenantId());
        List readInfoList = this.thirdMessageReadInfoService.getBaseMapper().selectList((Wrapper)readCondition);
        Map<Object, Object> readInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)readInfoList)) {
            readInfoMap = readInfoList.stream().collect(Collectors.toMap(value -> value.getMessageAppCode() + "-" + value.getMessageAppId() + "-" + value.getMessageId() + "-" + value.getReadUser(), value -> value, (key1, key2) -> key1));
        }
        int i = 0;
        for (ThirdMessageInfo messageInfo : messageInfoList) {
            String readKey = messageInfo.getMessageAppCode() + "-" + messageInfo.getMessageAppId() + "-" + messageInfo.getMessageId() + "-" + Utils.getUserId();
            ThirdMessageReadInfo readInfo = (ThirdMessageReadInfo)readInfoMap.get(readKey);
            if (null != readInfo) continue;
            String verifyUserKey = messageInfo.getMessageAppCode() + "-" + messageInfo.getMessageAppId();
            String verifyUserId = (String)verifyUserMap.get(verifyUserKey);
            readInfo = new ThirdMessageReadInfo();
            readInfo.setMessageAppCode(messageInfo.getMessageAppCode());
            readInfo.setMessageAppId(messageInfo.getMessageAppId());
            readInfo.setMessageId(messageInfo.getMessageId());
            readInfo.setReadUser(Utils.getUserId());
            readInfo.setReadSourceUser(verifyUserId);
            readInfo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            readInfo.setTenantId(Utils.getTenantId());
            this.thirdMessageReadInfoService.save((Object)readInfo);
            ++i;
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)i);
    }

    public void handleMessageData(String messageAppCode, String appId, List<Map<String, Object>> messageList) {
        ArrayList<ThirdMessageInfo> messageInfos = new ArrayList<ThirdMessageInfo>();
        QueryWrapper condition = (QueryWrapper)new QueryWrapper().eq((Object)"message_app_id", (Object)appId);
        List thirdMessageInfoList = this.thirdMessageInfoService.list((Wrapper)condition);
        HashMap existMessageMap = CollectionUtils.isNotEmpty((Collection)thirdMessageInfoList) ? thirdMessageInfoList.stream().collect(Collectors.toMap(ThirdMessageInfo::getMessageId, a -> a, (k1, k2) -> k1)) : Maps.newHashMap();
        for (Map<String, Object> map : messageList) {
            ThirdMessageInfo messageInfo = new ThirdMessageInfo();
            messageInfo.setMessageAppCode(messageAppCode);
            messageInfo.setMessageAppId(appId);
            messageInfo.setMessageId(map.get("message_id").toString());
            messageInfo.setMessageTitle(map.get("message_title").toString());
            messageInfo.setMessageUrl(map.get("message_url").toString());
            messageInfo.setMessagePublishTime(map.get("message_publish_time").toString());
            messageInfo.setMessageContent(map.get("message_content").toString());
            messageInfo.setMessageOwner(map.get("message_owner").toString());
            messageInfo.setMessageAllStaffRead(Integer.valueOf(Integer.parseInt(map.get("message_all_staff_read").toString())));
            messageInfo.setTenantId(Utils.getTenantId());
            String accountId = MapUtils.getString(map, (Object)"account_id");
            if (StringUtils.isNotBlank((CharSequence)accountId)) {
                messageInfo.setAccountId(accountId);
                messageInfo.setAccountName(MapUtils.getString(map, (Object)"account_name"));
            }
            if (existMessageMap.containsKey(messageInfo.getMessageId())) {
                ThirdMessageInfo existInfo = (ThirdMessageInfo)existMessageMap.get(messageInfo.getMessageId());
                messageInfo.setId(existInfo.getId());
                messageInfo.setModifyTime(DateUtils.getNowTime(null));
                if (Constants.MESSAGE_ALL_STAFF_FLAG.equals(messageInfo.getMessageAllStaffRead())) {
                    messageInfo.setMessageOwner(ALL_STAFF_CAN_SEE_FLAG);
                } else {
                    messageInfo.setMessageOwner(existInfo.getMessageOwner().equals(ALL_STAFF_CAN_SEE_FLAG) ? messageInfo.getMessageOwner() : existInfo.getMessageOwner() + "," + messageInfo.getMessageOwner());
                }
            } else {
                messageInfo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
                if (Constants.MESSAGE_ALL_STAFF_FLAG.equals(messageInfo.getMessageAllStaffRead())) {
                    messageInfo.setMessageOwner(ALL_STAFF_CAN_SEE_FLAG);
                }
            }
            messageInfos.add(messageInfo);
        }
        if (CollectionUtils.isNotEmpty(messageInfos)) {
            this.thirdMessageInfoService.saveOrUpdateBatch(messageInfos);
        }
    }

    public List<MessageAppNumResp> queryMessageAppList(QueryThirdMessageListReq queryThirdMessageListReq) {
        List<Object> messageAppNumRespList = Lists.newArrayList();
        List messageInfoList = this.queryMessageList(queryThirdMessageListReq, null);
        if (CollectionUtils.isEmpty((Collection)messageInfoList)) {
            return messageAppNumRespList;
        }
        Map<String, List<ThirdMessageInfo>> appIdMap = messageInfoList.stream().collect(Collectors.groupingBy(ThirdMessageInfo::getMessageAppId));
        for (Map.Entry<String, List<ThirdMessageInfo>> entry : appIdMap.entrySet()) {
            MessageAppNumResp messageAppNumResp = new MessageAppNumResp();
            String appId = entry.getKey();
            messageAppNumResp.setAppId(appId);
            List<ThirdMessageInfo> list = entry.getValue();
            messageAppNumResp.setAppName(list.get(0).getMessageAppName());
            long readNum = list.stream().filter(x -> x.getIsRed().equals(false)).count();
            messageAppNumResp.setReadNum(Long.valueOf(readNum));
            long unReadNum = list.stream().filter(x -> x.getIsRed().equals(true)).count();
            messageAppNumResp.setUnReadNum(Long.valueOf(unReadNum));
            messageAppNumResp.setSumNum(Long.valueOf(list.size()));
            Optional<ThirdMessageInfo> latest = list.stream().max(Comparator.comparing(ThirdMessageInfo::getModifyTime));
            if (latest.isPresent()) {
                messageAppNumResp.setLatestMessageContent(latest.get().getMessageContent());
                messageAppNumResp.setLatestMessageModifyTime(latest.get().getModifyTime());
            }
            messageAppNumRespList.add(messageAppNumResp);
        }
        LambdaQueryWrapper sortCondition = new LambdaQueryWrapper();
        sortCondition.eq(ThirdMessageAppSort::getUserId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        sortCondition.eq(ThirdMessageAppSort::getTenantId, (Object)Utils.getTenantId());
        sortCondition.orderByAsc(ThirdMessageAppSort::getAppSort);
        List appSortList = this.thirdMessageAppSortMapper.selectList((Wrapper)sortCondition);
        if (CollectionUtils.isNotEmpty((Collection)appSortList)) {
            Map appIdRespMap = messageAppNumRespList.stream().collect(Collectors.toMap(MessageAppNumResp::getAppId, Function.identity()));
            appSortList.forEach(x -> {
                String appId = x.getAppId();
                MessageAppNumResp messageAppNumResp = (MessageAppNumResp)appIdRespMap.get(appId);
                if (ObjectUtils.isNotEmpty((Object)messageAppNumResp)) {
                    messageAppNumResp.setAppSort(x.getAppSort());
                }
            });
        }
        messageAppNumRespList = messageAppNumRespList.stream().sorted(Comparator.comparing(MessageAppNumResp::getAppSort, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(MessageAppNumResp::getAppName, Comparator.nullsLast(Comparator.nullsLast(Comparator.naturalOrder())))).collect(Collectors.toList());
        return messageAppNumRespList;
    }

    public List<ThirdMessageType> queryMessageType() {
        return this.thirdMessageTypeMapper.selectList((Wrapper)Wrappers.emptyWrapper());
    }

    @Transactional
    public Boolean saveAppSort(List<String> appIdList) {
        LambdaQueryWrapper condition = new LambdaQueryWrapper();
        condition.eq(ThirdMessageAppSort::getUserId, (Object)Utils.getUserId());
        condition.eq(ThirdMessageAppSort::getTenantId, (Object)Utils.getTenantId());
        this.thirdMessageAppSortMapper.delete((Wrapper)condition);
        for (int i = 0; i < appIdList.size(); ++i) {
            ThirdMessageAppSort thirdMessageAppSort = new ThirdMessageAppSort();
            thirdMessageAppSort.setAppId(appIdList.get(i));
            thirdMessageAppSort.setAppSort(Integer.valueOf(i));
            thirdMessageAppSort.setUserId(Utils.getUserId());
            thirdMessageAppSort.setTenantId(Utils.getTenantId());
            this.thirdMessageAppSortMapper.insert((Object)thirdMessageAppSort);
        }
        return true;
    }

    private List<ThirdMessageInfo> queryMessageList(QueryThirdMessageListReq queryThirdMessageListReq, List<AppLinkDTO> appLinkDTOList) {
        List appIdList;
        List thirdMessageInfoList;
        ArrayList<Integer> list;
        ArrayList messageInfoList = Lists.newArrayList();
        LambdaQueryWrapper condition = new LambdaQueryWrapper();
        condition.eq(ThirdMessageInfo::getTenantId, (Object)Utils.getTenantId());
        if (StringUtils.isNotBlank((CharSequence)queryThirdMessageListReq.getKey())) {
            condition.and(x -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(ThirdMessageInfo::getMessageTitle, (Object)queryThirdMessageListReq.getKey())).or()).like(ThirdMessageInfo::getMessageContent, (Object)queryThirdMessageListReq.getKey());
            });
        }
        if (StringUtils.isNotBlank((CharSequence)queryThirdMessageListReq.getAppId())) {
            condition.eq(ThirdMessageInfo::getMessageAppId, (Object)queryThirdMessageListReq.getAppId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryThirdMessageListReq.getMessageTypeCode())) {
            condition.eq(ThirdMessageInfo::getMessageTypeCode, (Object)queryThirdMessageListReq.getMessageTypeCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryThirdMessageListReq.getStartTimeStr())) {
            condition.ge(ThirdMessageInfo::getMessagePublishTime, (Object)(queryThirdMessageListReq.getStartTimeStr() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)queryThirdMessageListReq.getEndTimeStr())) {
            condition.le(ThirdMessageInfo::getMessagePublishTime, (Object)(queryThirdMessageListReq.getEndTimeStr() + " 23:59:59"));
        }
        if (0 == queryThirdMessageListReq.getClientType()) {
            list = new ArrayList<Integer>();
            list.add(0);
            list.add(2);
            condition.in(ThirdMessageInfo::getSideType, list);
        }
        if (1 == queryThirdMessageListReq.getClientType()) {
            list = new ArrayList();
            list.add(1);
            list.add(2);
            condition.in(ThirdMessageInfo::getSideType, list);
        }
        if (CollectionUtils.isEmpty((Collection)(thirdMessageInfoList = this.thirdMessageInfoService.list((Wrapper)condition)))) {
            return messageInfoList;
        }
        if (CollectionUtils.isEmpty(appLinkDTOList)) {
            appIdList = thirdMessageInfoList.stream().map(ThirdMessageInfo::getMessageAppId).collect(Collectors.toList());
            appLinkDTOList = this.appLinkService.querySsoConfigListSync(appIdList);
        }
        appIdList = appLinkDTOList.stream().map(AppLinkDTO::getApplicationAppId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List verifyUserList = this.queryVerifyUseridList(thirdMessageInfoList = thirdMessageInfoList.stream().filter(x -> appIdList.contains(x.getMessageAppId())).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)verifyUserList)) {
            return messageInfoList;
        }
        for (AppUserDTO appUserDTO : verifyUserList) {
            for (ThirdMessageInfo x2 : thirdMessageInfoList) {
                if (!x2.getMessageAppId().equals(appUserDTO.getAppId()) || !Arrays.asList(x2.getMessageOwner().split(",")).contains(appUserDTO.getVerifyUserId()) && !Arrays.asList(x2.getMessageOwner().split(",")).contains(ALL_STAFF_CAN_SEE_FLAG)) continue;
                messageInfoList.add(x2);
            }
        }
        if (CollectionUtils.isEmpty((Collection)messageInfoList)) {
            return messageInfoList;
        }
        List readMessageInfoList = this.queryReadMessageList(verifyUserList);
        if (CollectionUtils.isEmpty((Collection)readMessageInfoList)) {
            return messageInfoList;
        }
        Map<String, String> appIdNameMap = appLinkDTOList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getApplicationAppId())).collect(Collectors.toMap(AppLinkDTO::getApplicationAppId, AppLinkDTO::getName, (a, b) -> a));
        for (ThirdMessageInfo messageInfo : messageInfoList) {
            messageInfo.setMessageAppName(appIdNameMap.get(messageInfo.getMessageAppId()));
            for (ThirdMessageReadInfo readInfo : readMessageInfoList) {
                if (!readInfo.getMessageAppId().equals(messageInfo.getMessageAppId()) || !readInfo.getMessageId().equals(messageInfo.getMessageId())) continue;
                messageInfo.setIsRed(Boolean.valueOf(false));
            }
        }
        return messageInfoList;
    }

    private List<ThirdMessageReadInfo> queryReadMessageList(List<AppUserDTO> verifyUserList) {
        QueryWrapper readCondition = new QueryWrapper();
        readCondition.in((Object)"message_app_id", (Collection)verifyUserList.stream().map(AppUserDTO::getAppId).collect(Collectors.toList()));
        readCondition.eq((Object)"read_user", (Object)Utils.getUserId());
        readCondition.eq((Object)"tenant_id", (Object)Utils.getTenantId());
        List readMessageInfoList = this.thirdMessageReadInfoService.list((Wrapper)readCondition);
        readMessageInfoList = readMessageInfoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ThirdMessageReadInfo>(Comparator.comparing(o -> o.getMessageAppId() + ";" + o.getMessageId() + ";" + o.getReadUser()))), ArrayList::new));
        return readMessageInfoList;
    }

    public MessageAppNumResp queryMessageCount(QueryThirdMessageListReq queryThirdMessageListReq) {
        MessageAppNumResp numResp = new MessageAppNumResp();
        List messageInfoList = this.queryMessageList(queryThirdMessageListReq, null);
        if (CollectionUtils.isEmpty((Collection)messageInfoList)) {
            return numResp;
        }
        long readCount = messageInfoList.stream().filter(x -> x.getIsRed().equals(false)).count();
        long unReadCount = messageInfoList.stream().filter(x -> x.getIsRed().equals(true)).count();
        numResp.setReadNum(Long.valueOf(readCount));
        numResp.setUnReadNum(Long.valueOf(unReadCount));
        numResp.setSumNum(Long.valueOf(messageInfoList.size()));
        return numResp;
    }
}

