/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.mobile.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.mobile.MobileDataSourceAuth;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.mapper.mobile.MobileDataSourceAuthMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.service.mobile.MobileDataSourceAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthListResp;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthQueryReq;
import com.digiwin.athena.semc.vo.mobile.MobileDataSourceAuthSaveReq;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MobileDataSourceAuthServiceImpl
extends ServiceImpl<MobileDataSourceAuthMapper, MobileDataSourceAuth>
implements MobileDataSourceAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileDataSourceAuthServiceImpl.class);
    @Autowired
    private MobileDataSourceAuthMapper mobileDatasourceAuthMapper;
    @Resource
    private MobileDatasourceInfoMapper mobileDatasourceInfoMapper;
    @Autowired
    private LabelSystemAuthService labelSystemAuthService;
    @Resource
    private Converter converter;

    @Transactional(rollbackFor={Exception.class})
    public Integer saveDatasourceAuth(MobileDataSourceAuthSaveReq req) {
        List dataSourceAuthList = this.selectByParam(req);
        if (CollectionUtils.isNotEmpty((Collection)dataSourceAuthList)) {
            List authIdList = dataSourceAuthList.stream().map(MobileDataSourceAuth::getId).filter(Objects::nonNull).collect(Collectors.toList());
            this.mobileDatasourceAuthMapper.deleteBatchIds(authIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getDataSourceList())) {
            for (MobileDataSourceAuthListResp dataSourceAuthReq : req.getDataSourceList()) {
                if (!dataSourceAuthReq.getIsRelated().booleanValue()) continue;
                MobileDataSourceAuth dataSourceAuth = (MobileDataSourceAuth)this.converter.convert((Object)req, MobileDataSourceAuth.class);
                dataSourceAuth.setDatasourceId(dataSourceAuthReq.getDataSourceId());
                dataSourceAuth.setTenantId(Utils.getTenantId());
                this.mobileDatasourceAuthMapper.insert((Object)dataSourceAuth);
            }
        }
        return null;
    }

    public List<MobileDataSourceAuth> selectByParam(MobileDataSourceAuthSaveReq req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != req.getAuthId()) {
            queryWrapper.eq((Object)"auth_id", (Object)req.getAuthId());
        }
        if (null != req.getAuthSid()) {
            queryWrapper.eq((Object)"auth_sid", (Object)req.getAuthSid());
        }
        if (null != req.getAuthType()) {
            queryWrapper.eq((Object)"auth_type", (Object)req.getAuthType());
        }
        return this.mobileDatasourceAuthMapper.selectList((Wrapper)queryWrapper);
    }

    public List<MobileDataSourceAuthListResp> queryAuthList(MobileDataSourceAuthQueryReq req) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"type", (Object)Constants.MobileAppJobTypeEnum.THIRD_APP_JOB.getFlag());
        condition.orderByDesc((Object)"modify_time");
        if (StringUtils.isNotBlank((CharSequence)req.getName())) {
            condition.like((Object)"name", (Object)req.getName());
        }
        List datasourceInfoList = this.mobileDatasourceInfoMapper.selectList((Wrapper)condition);
        QueryWrapper authCondition = new QueryWrapper();
        authCondition.eq((Object)"auth_id", (Object)req.getAuthId());
        authCondition.eq((Object)"auth_sid", (Object)req.getAuthSid());
        List dataSourceAuthList = this.mobileDatasourceAuthMapper.selectList((Wrapper)authCondition);
        Map labelSystemAuthMap = dataSourceAuthList.stream().collect(Collectors.toMap(MobileDataSourceAuth::getDatasourceId, Function.identity()));
        ArrayList<MobileDataSourceAuthListResp> authListRespList = new ArrayList<MobileDataSourceAuthListResp>();
        for (MobileDatasourceInfo datasourceInfo : datasourceInfoList) {
            MobileDataSourceAuthListResp sourceAuthListResp = new MobileDataSourceAuthListResp();
            sourceAuthListResp.setDataSourceId(datasourceInfo.getId());
            sourceAuthListResp.setDataSourceName(datasourceInfo.getName());
            sourceAuthListResp.setValidStatus(datasourceInfo.getStatus());
            Boolean isRelated = labelSystemAuthMap.get(datasourceInfo.getId()) != null;
            sourceAuthListResp.setIsRelated(isRelated);
            authListRespList.add(sourceAuthListResp);
        }
        return authListRespList;
    }

    public List<Long> selectUserAuth() {
        QueryWrapper condition = new QueryWrapper();
        List dataSourceAuthList = this.mobileDatasourceAuthMapper.selectList((Wrapper)this.labelSystemAuthService.getUserAuthSidCon(condition));
        List<Long> dataSourceIdList = dataSourceAuthList.stream().map(MobileDataSourceAuth::getDatasourceId).filter(Objects::nonNull).collect(Collectors.toList());
        return dataSourceIdList;
    }
}

