/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.mobile.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumn;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceClassification;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceClassificationMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.service.mobile.MobileDatasourceClassificationService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.MobileClassificatonResp;
import com.digiwin.athena.semc.vo.mobile.MobileDatasourceInfoVO;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MobileDatasourceClassificationServiceImpl
extends ServiceImpl<MobileDatasourceClassificationMapper, MobileDatasourceClassification>
implements MobileDatasourceClassificationService {
    @Resource
    private MobileDatasourceClassificationMapper mobileDatasourceClassificationMapper;
    @Resource
    private MobileDatasourceInfoMapper mobileDatasourceInfoMapper;
    @Resource
    private MobileApplicatonColumnMapper columnMapper;
    @Resource
    MobileUserAuthService mobileUserAuthService;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private Converter converter;

    public List<MobileDatasourceClassification> queryApplicationClassificationList() {
        return this.mobileDatasourceClassificationMapper.queryApplicationClassificationList(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
    }

    public List<MobileDatasourceClassification> existNameValid(Long id, String name) {
        return this.mobileDatasourceClassificationMapper.existNameValid(name, id, AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
    }

    @Transactional
    public void delApplicationClassification(Long id) {
        this.mobileDatasourceClassificationMapper.deleteById((Serializable)id);
        this.mobileDatasourceClassificationMapper.updateClassificationById(id, DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"), AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
    }

    public List<MobileClassificatonResp> getClassificationList(Boolean isAll) {
        ArrayList<MobileClassificatonResp> result = new ArrayList<MobileClassificatonResp>();
        List mobileApplicationClassifications = this.queryApplicationClassificationList();
        if (CollectionUtils.isEmpty((Collection)mobileApplicationClassifications)) {
            return result;
        }
        List<Object> appIds = new ArrayList();
        LambdaQueryWrapper columnLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)columnLambdaQueryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).isNotNull(MobileApplicatonColumn::getCustomApplicationId);
        List mobileApplicatonColumns = this.columnMapper.selectList((Wrapper)columnLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)mobileApplicatonColumns)) {
            appIds = mobileApplicatonColumns.stream().map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        }
        List classIdList = mobileApplicationClassifications.stream().map(MobileDatasourceClassification::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(MobileDatasourceInfo::getStatus, (Object)Constants.VALID_STATUS_ENABLE)).in(MobileDatasourceInfo::getClassificationId, classIdList);
        List mobileDatasourceInfos = this.mobileDatasourceInfoMapper.selectList((Wrapper)queryWrapper);
        Map<Long, List<MobileDatasourceInfo>> classIdMap = mobileDatasourceInfos.stream().collect(Collectors.groupingBy(MobileDatasourceInfo::getClassificationId));
        List mobileAppIdList = mobileDatasourceInfos.stream().filter(x -> !Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).map(MobileDatasourceInfo::getId).collect(Collectors.toList());
        List notAthenaAppList = mobileDatasourceInfos.stream().filter(x -> Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notAthenaAppList)) {
            List withPermissionList = this.mobileUserAuthService.validPermission(notAthenaAppList);
            mobileAppIdList.addAll(withPermissionList);
        }
        for (MobileDatasourceClassification mobileApplicationClassification : mobileApplicationClassifications) {
            MobileClassificatonResp mobileClassificatonResp = (MobileClassificatonResp)this.converter.convert((Object)mobileApplicationClassification, MobileClassificatonResp.class);
            ArrayList<MobileDatasourceInfoVO> mobileDatasourceInfoVOList = new ArrayList<MobileDatasourceInfoVO>();
            List<MobileDatasourceInfo> datasourceInfos = classIdMap.get(mobileApplicationClassification.getId());
            if (CollectionUtils.isNotEmpty(datasourceInfos)) {
                for (MobileDatasourceInfo mobileDatasourceInfo : datasourceInfos) {
                    if (!mobileAppIdList.contains(mobileDatasourceInfo.getId())) continue;
                    MobileDatasourceInfoVO mobileDatasourceInfoVO = (MobileDatasourceInfoVO)this.converter.convert((Object)mobileDatasourceInfo, MobileDatasourceInfoVO.class);
                    mobileDatasourceInfoVO.setClassificationName(mobileApplicationClassification.getClassificationName());
                    if (appIds.contains(mobileDatasourceInfo.getId())) {
                        mobileDatasourceInfoVO.setIsAdd(1);
                        if (!Boolean.TRUE.equals(isAll)) continue;
                    }
                    String icon = mobileDatasourceInfoVO.getIcon();
                    if (StringUtils.isEmpty((CharSequence)mobileDatasourceInfoVO.getIcon())) {
                        icon = this.envProperties.getSemcWebUrl() + "/assets/img/mobile/king/default.svg";
                    }
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                        icon = this.envProperties.getSemcWebUrl() + icon;
                    }
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                        icon = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + icon;
                    }
                    mobileDatasourceInfoVO.setIcon(icon);
                    mobileDatasourceInfoVOList.add(mobileDatasourceInfoVO);
                }
            }
            mobileClassificatonResp.setMobileCustomAppList(mobileDatasourceInfoVOList);
            result.add(mobileClassificatonResp);
        }
        return result;
    }

    public List<MobileClassificatonResp> getClassificationListNew(Boolean isAll) {
        ArrayList<MobileClassificatonResp> result = new ArrayList<MobileClassificatonResp>();
        List mobileApplicationClassifications = this.queryApplicationClassificationList();
        if (CollectionUtils.isEmpty((Collection)mobileApplicationClassifications)) {
            return result;
        }
        List<Object> appIds = new ArrayList();
        LambdaQueryWrapper columnLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)columnLambdaQueryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).isNotNull(MobileApplicatonColumn::getCustomApplicationId);
        List mobileApplicatonColumns = this.columnMapper.selectList((Wrapper)columnLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)mobileApplicatonColumns)) {
            appIds = mobileApplicatonColumns.stream().map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        }
        List classIdList = mobileApplicationClassifications.stream().map(MobileDatasourceClassification::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(MobileDatasourceInfo::getStatus, (Object)Constants.VALID_STATUS_ENABLE)).in(MobileDatasourceInfo::getClassificationId, classIdList);
        List mobileDatasourceInfos = this.mobileDatasourceInfoMapper.selectList((Wrapper)queryWrapper);
        Map<Long, List<MobileDatasourceInfo>> classIdMap = mobileDatasourceInfos.stream().collect(Collectors.groupingBy(MobileDatasourceInfo::getClassificationId));
        List mobileAppIdList = mobileDatasourceInfos.stream().filter(x -> !Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).map(MobileDatasourceInfo::getId).collect(Collectors.toList());
        List notAthenaAppList = mobileDatasourceInfos.stream().filter(x -> Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notAthenaAppList)) {
            List withPermissionList = this.mobileUserAuthService.validPermission(notAthenaAppList);
            mobileAppIdList.addAll(withPermissionList);
        }
        for (MobileDatasourceClassification mobileApplicationClassification : mobileApplicationClassifications) {
            MobileClassificatonResp mobileClassificatonResp = (MobileClassificatonResp)this.converter.convert((Object)mobileApplicationClassification, MobileClassificatonResp.class);
            ArrayList<MobileDatasourceInfoVO> mobileDatasourceInfoVOList = new ArrayList<MobileDatasourceInfoVO>();
            List<MobileDatasourceInfo> datasourceInfos = classIdMap.get(mobileApplicationClassification.getId());
            if (CollectionUtils.isNotEmpty(datasourceInfos)) {
                for (MobileDatasourceInfo mobileDatasourceInfo : datasourceInfos) {
                    if (!mobileAppIdList.contains(mobileDatasourceInfo.getId())) continue;
                    MobileDatasourceInfoVO mobileDatasourceInfoVO = (MobileDatasourceInfoVO)this.converter.convert((Object)mobileDatasourceInfo, MobileDatasourceInfoVO.class);
                    mobileDatasourceInfoVO.setClassificationName(mobileApplicationClassification.getClassificationName());
                    if (appIds.contains(mobileDatasourceInfo.getId())) {
                        mobileDatasourceInfoVO.setIsAdd(1);
                        if (!Boolean.TRUE.equals(isAll)) continue;
                    }
                    String icon = mobileDatasourceInfoVO.getIcon();
                    if (StringUtils.isEmpty((CharSequence)mobileDatasourceInfoVO.getIcon())) {
                        icon = this.envProperties.getSemcWebUrl() + "/assets/img/mobile/king/default.svg";
                    }
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                        icon = this.envProperties.getSemcWebUrl() + icon;
                    }
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                        icon = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + icon;
                    }
                    mobileDatasourceInfoVO.setIcon(icon);
                    mobileDatasourceInfoVOList.add(mobileDatasourceInfoVO);
                }
            }
            mobileClassificatonResp.setMobileCustomAppList(mobileDatasourceInfoVOList);
            result.add(mobileClassificatonResp);
        }
        return result;
    }

    public void saveClassification(MobileDatasourceClassification mobileDatasourceClassification) {
        if (ObjectUtils.isEmpty((Object)mobileDatasourceClassification.getId())) {
            this.mobileDatasourceClassificationMapper.insert((Object)mobileDatasourceClassification);
        } else {
            MobileDatasourceClassification classification = this.mobileDatasourceClassificationMapper.selectClassificationById(mobileDatasourceClassification.getId());
            classification.setClassificationName(mobileDatasourceClassification.getClassificationName());
            classification.setClassificationDescription(mobileDatasourceClassification.getClassificationDescription());
            classification.setPriority(mobileDatasourceClassification.getPriority());
            this.mobileDatasourceClassificationMapper.updateClassificationInfo(classification);
        }
    }
}

