/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.mobile.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.mobile.CustomApplicationsListPageReq;
import com.digiwin.athena.semc.dto.mobile.SaveAppcationReq;
import com.digiwin.athena.semc.dto.mobile.UpdateAppcationConfigReq;
import com.digiwin.athena.semc.dto.mobile.UpdateAppcationStatusReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceClassification;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceClassificationMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.mobile.MobileDatasourceInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationModulesDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationSimpleDTO;
import com.digiwin.athena.semc.vo.mobile.MobileDatasourceInfoVO;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MobileDatasourceInfoServiceImpl
extends ServiceImpl<MobileDatasourceInfoMapper, MobileDatasourceInfo>
implements MobileDatasourceInfoService {
    @Resource
    private MobileDatasourceInfoMapper mobileDatasourceInfoMapper;
    @Resource
    private MobileDatasourceClassificationMapper mobileApplicationClassificationMapper;
    @Autowired
    private AppLinkService appLinkService;
    @Autowired
    private IamService iamService;
    @Autowired
    EnvProperties envProperties;
    @Resource
    private MobileApplicatonColumnMapper applicatonColumnMapper;
    @Resource
    private Converter converter;

    public PageInfoResp<MobileDatasourceInfoVO> queryCustomApplicationsByPage(CustomApplicationsListPageReq customApplicationsListPageReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)customApplicationsListPageReq.getName())) {
            condition.like((Object)"name", (Object)customApplicationsListPageReq.getName());
        }
        if (ObjectUtils.isNotEmpty((Object)customApplicationsListPageReq.getStatus())) {
            condition.eq((Object)"status", (Object)customApplicationsListPageReq.getStatus());
        }
        if (ObjectUtils.isNotEmpty((Object)customApplicationsListPageReq.getType())) {
            condition.eq((Object)"type", (Object)customApplicationsListPageReq.getType());
        }
        if (ObjectUtils.isNotEmpty((Object)customApplicationsListPageReq.getDataSource()) && ObjectUtils.isNotEmpty((Object)customApplicationsListPageReq.getPrimaryId())) {
            condition.eq((Object)"application_primary_id", (Object)customApplicationsListPageReq.getPrimaryId());
            condition.eq((Object)"application_source", (Object)customApplicationsListPageReq.getDataSource());
        }
        if (ObjectUtils.isNotEmpty((Object)customApplicationsListPageReq.getClassificationIdList())) {
            condition.in((Object)"classification_id", (Collection)customApplicationsListPageReq.getClassificationIdList());
        }
        if (ObjectUtils.isNotEmpty((Object)customApplicationsListPageReq.getWorkCodeIdList())) {
            condition.in((Object)"work_code", (Collection)customApplicationsListPageReq.getWorkCodeIdList());
        }
        condition.orderByDesc((Object)"modify_time");
        condition.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        PageInfoResp pageInfoResp = new PageInfoResp();
        Page pageResult = (Page)this.mobileDatasourceInfoMapper.selectPage((IPage)new Page((long)customApplicationsListPageReq.getPageNum().intValue(), (long)customApplicationsListPageReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult == null || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageInfoResp;
        }
        List applicationsList = pageResult.getRecords();
        List classificationList = this.mobileApplicationClassificationMapper.queryApplicationClassificationList(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        Map<Long, String> idNameMap = classificationList.stream().collect(Collectors.toMap(MobileDatasourceClassification::getId, MobileDatasourceClassification::getClassificationName, (a, b) -> a));
        List appLinkListDTO = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
        Map<String, String> appLinkMap = appLinkListDTO.stream().filter(x -> Constants.APP_TYPE_BS.equals(x.getSystemType())).collect(Collectors.toList()).stream().collect(Collectors.toMap(app -> app.getPrimaryId() + "-" + app.getDataSource(), AppLinkDTO::getName, (a, b) -> a));
        Map<String, String> appCodeMap = appLinkListDTO.stream().filter(x -> Constants.APP_TYPE_BS.equals(x.getSystemType())).collect(Collectors.toList()).stream().filter(y -> !StringUtils.isEmpty((CharSequence)y.getApplicationAppId())).collect(Collectors.toMap(app -> app.getPrimaryId() + "-" + app.getDataSource(), AppLinkDTO::getApplicationAppId, (a, b) -> a));
        List mobileCustomApplicationVOList = applicationsList.stream().map(x -> {
            MobileDatasourceInfoVO mobileCustomApplicationVO = (MobileDatasourceInfoVO)this.converter.convert(x, MobileDatasourceInfoVO.class);
            if (MapUtils.isNotEmpty((Map)idNameMap)) {
                mobileCustomApplicationVO.setClassificationName((String)idNameMap.get(x.getClassificationId()));
            }
            if (Constants.MobileDataSourceTye.MOBILE_THIRD_APPLICATION.getValue().equals(x.getType())) {
                if (MapUtils.isNotEmpty((Map)appLinkMap)) {
                    List jobInfos;
                    mobileCustomApplicationVO.setApplicationSourceName((String)appLinkMap.get(x.getApplicationPrimaryId() + "-" + x.getApplicationSource()));
                    if (Constants.DEFAULT_CONFIGURED_FLAG_NO.equals(x.getIsJob()) && !CollectionUtils.isEmpty((Collection)(jobInfos = this.mobileDatasourceInfoMapper.queryWorkName((String)appCodeMap.get(x.getApplicationPrimaryId() + "-" + x.getApplicationSource()), x.getWorkCode())))) {
                        mobileCustomApplicationVO.setWorkName(((SyncJobInfo)jobInfos.get(0)).getJobName());
                    }
                }
            } else {
                mobileCustomApplicationVO.setApplicationSourceName(x.getApplicationConfig());
            }
            if (!StringUtils.isEmpty((CharSequence)mobileCustomApplicationVO.getIcon())) {
                mobileCustomApplicationVO.setIconUrl(mobileCustomApplicationVO.getIcon());
            }
            if (null != x.getIconType() && Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag().equals(x.getIconType()) && !StringUtils.isEmpty((CharSequence)x.getIcon())) {
                mobileCustomApplicationVO.setIconUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + x.getIcon());
            }
            return mobileCustomApplicationVO;
        }).collect(Collectors.toList());
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(customApplicationsListPageReq.getPageNum().intValue());
        pageInfoResp.setPageSize(customApplicationsListPageReq.getPageSize().intValue());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(mobileCustomApplicationVOList);
        return pageInfoResp;
    }

    public void updateStatus(UpdateAppcationStatusReq updateAppcationStatusReq) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"status", (Object)updateAppcationStatusReq.getStatus())).set((Object)"modify_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId())).set((Object)"modify_user_name", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserName())).set((Object)"modify_time", (Object)LocalDateTime.now());
        updateWrapper.in((Object)"id", (Collection)updateAppcationStatusReq.getIdList());
        this.update((Wrapper)updateWrapper);
    }

    @Transactional
    public void delApplicationInfo(List<Long> idList) {
        this.mobileDatasourceInfoMapper.deleteBatchIds(idList);
        this.applicatonColumnMapper.delColumnByApp(idList);
    }

    public MobileDatasourceInfoVO queryCustomApplicationDetail(Long id) {
        List collect1;
        MobileDatasourceInfoVO mobileCustomApplicationVO = new MobileDatasourceInfoVO();
        MobileDatasourceInfo mobileCustomApplication = (MobileDatasourceInfo)this.mobileDatasourceInfoMapper.selectById((Serializable)id);
        if (ObjectUtils.isEmpty((Object)mobileCustomApplication)) {
            return mobileCustomApplicationVO;
        }
        this.converter.convert((Object)mobileCustomApplication, (Object)mobileCustomApplicationVO);
        List classificationList = this.mobileApplicationClassificationMapper.queryApplicationClassificationList(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        List appLinkListDTO = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
        List collect = appLinkListDTO.stream().filter(x -> x.getDataSource().equals(mobileCustomApplication.getApplicationSource()) && x.getPrimaryId().equals(mobileCustomApplication.getApplicationPrimaryId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            mobileCustomApplicationVO.setApplicationSourceName(((AppLinkDTO)collect.get(0)).getName());
        }
        if (!CollectionUtils.isEmpty(collect1 = classificationList.stream().filter(x -> x.getId().equals(mobileCustomApplication.getClassificationId())).collect(Collectors.toList()))) {
            mobileCustomApplicationVO.setClassificationName(((MobileDatasourceClassification)collect1.get(0)).getClassificationName());
        }
        return mobileCustomApplicationVO;
    }

    @Transactional
    public void saveCustomApplication(SaveAppcationReq saveAppcationReq) {
        if (ObjectUtils.isEmpty((Object)saveAppcationReq.getId())) {
            MobileDatasourceInfo mobileCustomApplication = new MobileDatasourceInfo();
            this.buildCustomApplicationInfo(saveAppcationReq, mobileCustomApplication);
            this.mobileDatasourceInfoMapper.insert((Object)mobileCustomApplication);
        } else {
            MobileDatasourceInfo mobileCustomApplication = (MobileDatasourceInfo)this.mobileDatasourceInfoMapper.selectById((Serializable)saveAppcationReq.getId());
            this.buildCustomApplicationInfo(saveAppcationReq, mobileCustomApplication);
            this.mobileDatasourceInfoMapper.updateByIdNeedNull(mobileCustomApplication);
            if (Constants.MobileDataSourceTye.MOBILE_THIRD_APPLICATION.getValue().equals(mobileCustomApplication.getType())) {
                this.mobileDatasourceInfoMapper.updateIamDate(mobileCustomApplication);
            }
        }
    }

    public Integer countByParam(SaveAppcationReq saveAppcationReq) {
        return this.mobileDatasourceInfoMapper.countByParam(saveAppcationReq.getName(), saveAppcationReq.getId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
    }

    public List<MobileDatasourceInfo> queryDatasourceInfo(CustomApplicationsListPageReq customApplicationReq) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtils.isNotEmpty((Object)customApplicationReq.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)customApplicationReq.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)customApplicationReq.getPrimaryId())) {
            queryWrapper.eq((Object)"application_primary_id", (Object)customApplicationReq.getPrimaryId());
        }
        queryWrapper.eq((Object)"type", (Object)Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue());
        queryWrapper.orderByDesc((Object)"modify_time");
        return this.mobileDatasourceInfoMapper.selectList((Wrapper)queryWrapper);
    }

    public List<UserApplicationSimpleDTO> queryApplicationByUser() {
        return this.iamService.queryUserApplicationSimple(true, false, false);
    }

    @Deprecated
    public List<UserApplicationModulesDTO> queryModuleByApplication(PermissionUserFunctionalDTO permissionUserFunctionalDTO) {
        List applicationDTOS = this.iamService.queryUserApplication();
        List collect = applicationDTOS.stream().filter(x -> x.getId().equals(permissionUserFunctionalDTO.getId())).collect(Collectors.toList());
        List<Object> moduleList = new ArrayList<UserApplicationModulesDTO>();
        if (!CollectionUtils.isEmpty(collect) && !CollectionUtils.isEmpty((Collection)((UserApplicationDTO)collect.get(0)).getEnabledModules())) {
            moduleList = ((UserApplicationDTO)collect.get(0)).getEnabledModules().stream().filter(x -> DateUtils.strToDate((String)x.getExpiredTime()).getTime() > new Date().getTime()).collect(Collectors.toList());
        }
        return moduleList;
    }

    public List<PermissionUserFunctionalDTO> queryWorkByApplication(PermissionUserFunctionalDTO permissionUserFunctionalDTO) {
        String target;
        List userFunctionalDTOS;
        List<Object> responseList = new ArrayList<PermissionUserFunctionalDTO>();
        if (!StringUtils.isEmpty((CharSequence)permissionUserFunctionalDTO.getSid()) && !CollectionUtils.isEmpty((Collection)(userFunctionalDTOS = this.iamService.queryUserFunctional(target = "drn:iam:app:" + permissionUserFunctionalDTO.getSid(), AppAuthContextHolder.getContext().getAuthoredUser())))) {
            responseList = userFunctionalDTOS.stream().filter(x -> !StringUtils.isEmpty((CharSequence)x.getModuleId()) && x.getModuleId().equals(permissionUserFunctionalDTO.getModuleId())).collect(Collectors.toList());
            List workIdList = this.mobileDatasourceInfoMapper.selectAllWorkId(permissionUserFunctionalDTO);
            if (!CollectionUtils.isEmpty((Collection)workIdList)) {
                responseList = responseList.stream().filter(x -> !workIdList.contains(x.getId())).collect(Collectors.toList());
            }
        }
        return responseList;
    }

    public void updateConfig(UpdateAppcationConfigReq updateAppcationConfigReq) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"iam_application_id", (Object)updateAppcationConfigReq.getIamApplicationId())).set((Object)"iam_module_id", (Object)updateAppcationConfigReq.getIamModuleId())).set((Object)"iam_work_id", (Object)updateAppcationConfigReq.getIamWorkId())).set((Object)"modify_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId())).set((Object)"modify_user_name", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserName())).set((Object)"modify_time", (Object)LocalDateTime.now());
        updateWrapper.eq((Object)"id", (Object)updateAppcationConfigReq.getId());
        this.update((Wrapper)updateWrapper);
    }

    private void buildCustomApplicationInfo(SaveAppcationReq saveAppcationReq, MobileDatasourceInfo mobileCustomApplication) {
        mobileCustomApplication.setName(saveAppcationReq.getName());
        mobileCustomApplication.setIcon(saveAppcationReq.getIcon());
        mobileCustomApplication.setIconType(saveAppcationReq.getIconType());
        mobileCustomApplication.setApplicationPrimaryId(saveAppcationReq.getApplicationPrimaryId());
        mobileCustomApplication.setApplicationSource(saveAppcationReq.getApplicationSource());
        mobileCustomApplication.setType(saveAppcationReq.getType());
        mobileCustomApplication.setClassificationId(saveAppcationReq.getClassificationId());
        mobileCustomApplication.setStatus(saveAppcationReq.getStatus());
        mobileCustomApplication.setRemarks(saveAppcationReq.getRemarks());
        mobileCustomApplication.setWorkCode(saveAppcationReq.getWorkCode());
        mobileCustomApplication.setIsJob(saveAppcationReq.getIsJob());
        mobileCustomApplication.setCallBackUrl(saveAppcationReq.getCallBackUrl());
        mobileCustomApplication.setSpecialSign(saveAppcationReq.getSpecialSign());
        mobileCustomApplication.setApplicationConfig(saveAppcationReq.getApplicationConfig());
        mobileCustomApplication.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        mobileCustomApplication.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        mobileCustomApplication.setCreateUserId(Utils.getUserId());
        mobileCustomApplication.setModifyUserId(Utils.getUserId());
        mobileCustomApplication.setCreateTime(DateUtils.getNowTime((String)""));
        mobileCustomApplication.setModifyTime(DateUtils.getNowTime((String)""));
    }
}

