/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.mobile.impl;

import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.mobile.MobileLabelSystemPreQueryReq;
import com.digiwin.athena.semc.entity.mobile.MobileLabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.mapper.mobile.MobileLabelSystemPreMapper;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.mobile.MobileLabelSystemPreService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileLabelSystemPreServiceImpl
implements MobileLabelSystemPreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileLabelSystemPreServiceImpl.class);
    @Autowired
    private MobileLabelSystemPreMapper mobileLabelSystemPreMapper;
    @Resource
    private LabelSystemPreService labelSystemPreService;
    @Resource
    private TranslateService translateService;

    public List<MobileLabelSystemPre> initMobileLabelSystemPre() {
        List labelSystemPreList = this.mobileLabelSystemPreMapper.querySystemPre(Utils.getTenantId());
        List overSystemPreList = this.mobileLabelSystemPreMapper.querySystemPre("");
        ArrayList<MobileLabelSystemPre> insertPreList = new ArrayList<MobileLabelSystemPre>();
        if (CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
            insertPreList.addAll(overSystemPreList);
        } else {
            Map preListMap = labelSystemPreList.stream().collect(Collectors.toMap(MobileLabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
            for (MobileLabelSystemPre overSystemPre : overSystemPreList) {
                if (null != preListMap.get(overSystemPre.getDataCategory())) continue;
                insertPreList.add(overSystemPre);
            }
        }
        if (CollectionUtils.isNotEmpty(insertPreList)) {
            labelSystemPreList = this.batchSavePreData(insertPreList, Utils.getTenantId());
        }
        labelSystemPreList = this.mobileLabelSystemPreMapper.querySystemPre(Utils.getTenantId());
        return labelSystemPreList;
    }

    private List<MobileLabelSystemPre> batchSavePreData(List<MobileLabelSystemPre> insertPreList, String tenantId) {
        ArrayList<MobileLabelSystemPre> systemPreTenantList = new ArrayList<MobileLabelSystemPre>();
        for (MobileLabelSystemPre labelSystemPre : insertPreList) {
            labelSystemPre.setTenantId(tenantId);
            labelSystemPre.setId(null);
            labelSystemPre.setCreateTime(DateUtils.getNowTime((String)""));
            labelSystemPre.setModifyTime(DateUtils.getNowTime((String)""));
            this.mobileLabelSystemPreMapper.insert((Object)labelSystemPre);
            labelSystemPre.setId(labelSystemPre.getId());
            systemPreTenantList.add(labelSystemPre);
        }
        return systemPreTenantList;
    }

    public ResultPageBean pageQuery(MobileLabelSystemPreQueryReq req) {
        List labelSystemPreList = this.initMobileLabelSystemPre();
        if (CollectionUtils.isNotEmpty((Collection)req.getDataCategory())) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> req.getDataCategory().contains(x.getDataCategory())).collect(Collectors.toList());
        }
        if (null != req.getValidStatus()) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> req.getValidStatus().equals(x.getValidStatus())).collect(Collectors.toList());
        }
        for (MobileLabelSystemPre labelSystemPre : labelSystemPreList) {
            String name = this.translateService.translateTextCache(labelSystemPre.getName(), "");
            labelSystemPre.setName(name);
            labelSystemPre.setModifyUserId("");
            labelSystemPre.setModifyUserName("");
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> x.getName().contains(req.getName())).collect(Collectors.toList());
        }
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)labelSystemPreList.size())));
        return resultPageBean;
    }

    public List<LabelSystemPre> getAllSystemPre(MobileLabelSystemPreQueryReq req) {
        List labelSystemPreList = this.labelSystemPreService.initPreData(Constants.ClientTypeEnum.MOBILE.getValue());
        for (LabelSystemPre labelSystemPre : labelSystemPreList) {
            String name = this.translateService.translateTextCache(labelSystemPre.getName(), "");
            labelSystemPre.setName(name);
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            labelSystemPreList = labelSystemPreList.stream().filter(x -> x.getName().contains(req.getName())).collect(Collectors.toList());
        }
        return labelSystemPreList;
    }
}

