/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.mobile.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.TWAppUrlVariableEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.mobile.ApplicationColumnReq;
import com.digiwin.athena.semc.dto.mobile.ApplicationColumnReqNew;
import com.digiwin.athena.semc.dto.mobile.MobilePortalBusImageReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalBusinessInfoReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalContentCarousel;
import com.digiwin.athena.semc.dto.mobile.MobilePortalContentCarouselImage;
import com.digiwin.athena.semc.dto.mobile.MobilePortalContentNews;
import com.digiwin.athena.semc.dto.mobile.MobilePortalDividerInfoReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalHotZoneReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalImageInfoReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalTitleInfoReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobileSSOReq;
import com.digiwin.athena.semc.dto.mobile.SaveAppcationReq;
import com.digiwin.athena.semc.dto.mobile.SaveAppcationReqNew;
import com.digiwin.athena.semc.dto.portal.PortalInfoCheckResp;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumn;
import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumnNew;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceClassification;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.entity.mobile.MobileLabelSystemPre;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoAuth;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoContent;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoUse;
import com.digiwin.athena.semc.entity.mobile.MobilePortalPreview;
import com.digiwin.athena.semc.entity.mobile.MobilePortalTypeUse;
import com.digiwin.athena.semc.entity.portal.PortalContentKingKongDistrict;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.sso.MobileSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnNewMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceClassificationMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileLabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoAuthMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoUseMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalPreviewMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalTypeUserMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.machine.TopicPresetService;
import com.digiwin.athena.semc.service.mobile.MobileLabelSystemPreService;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.sso.IMobileSsoInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.BallResp;
import com.digiwin.athena.semc.vo.mobile.FullBackResp;
import com.digiwin.athena.semc.vo.mobile.MobileAppColumnResp;
import com.digiwin.athena.semc.vo.mobile.MobileDatasourceInfoVO;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoAuthResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoContentResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoItemResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoResp;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import com.fasterxml.jackson.core.type.TypeReference;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MobilePortalServiceImpl
extends ServiceImpl<MobilePortalInfoMapper, MobilePortalInfo>
implements MobilePortalService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobilePortalServiceImpl.class);
    @Autowired
    private MobilePortalInfoMapper mobilePortalInfoMapper;
    @Autowired
    private MobilePortalInfoContentMapper mobilePortalInfoContentMapper;
    @Autowired
    private MobilePortalInfoAuthMapper mobilePortalInfoAuthMapper;
    @Autowired
    private LabelSystemAuthService labelSystemAuthService;
    @Resource
    private TranslateService translateService;
    @Autowired
    private MobileLabelSystemPreService mobileLabelSystemPreService;
    @Autowired
    private IMobileSsoInfoService mobileSsoInfoService;
    @Autowired
    private MobilePortalInfoUseMapper mobilePortalInfoUseMapper;
    @Autowired
    private MobileLabelSystemPreMapper mobileLabelSystemPreMapper;
    @Autowired
    private MobilePortalPreviewMapper mobilePortalPreviewMapper;
    @Resource
    MessageUtils messageUtils;
    @Resource
    private EnvProperties envProperties;
    @Autowired
    private MobilePortalTypeUserMapper mobilePortalTypeUserMapper;
    @Resource
    private MobileApplicatonColumnMapper applicatonColumnMapper;
    @Resource
    private MobileApplicatonColumnNewMapper mobileApplicatonColumnNewMapper;
    @Resource
    private MobileDatasourceInfoMapper mobileCustomApplicationMapper;
    @Resource
    private MobileDatasourceClassificationMapper mobileDatasourceClassificationMapper;
    @Resource
    private SyncJobInfoMapper syncJobInfoMapper;
    @Autowired
    private KmService kmService;
    @Resource
    private IamService iamService;
    @Autowired
    MayCurService mayCurService;
    @Autowired
    EocService eocService;
    @Autowired
    TopicPresetService topicPresetService;
    @Autowired
    MobileUserAuthService mobileUserAuthService;
    @Resource
    private Converter converter;
    @Resource
    private MobileDatasourceClassificationMapper mobileApplicationClassificationMapper;

    public MobilePortalInfoResp getPortalInfo(Long id, Integer scene) {
        MobilePortalInfoResp result = new MobilePortalInfoResp();
        MobilePortalInfo mobilePortalInfo = (MobilePortalInfo)this.mobilePortalInfoMapper.selectOne((Wrapper)new LambdaUpdateWrapper().eq(MobilePortalInfo::getId, (Object)id));
        if (ObjectUtils.isEmpty((Object)mobilePortalInfo)) {
            return result;
        }
        if (null != mobilePortalInfo.getDefaultFlag() && 1 == mobilePortalInfo.getDefaultFlag()) {
            mobilePortalInfo.setVersionDefault(1);
        }
        this.converter.convert((Object)mobilePortalInfo, (Object)result);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MobilePortalInfoContent::getMobilePortalId, (Object)id);
        List mobilePortalInfoContents = new ArrayList();
        List mobilePortalInfoContentsSql = this.mobilePortalInfoContentMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)mobilePortalInfoContentsSql)) {
            mobilePortalInfoContents = mobilePortalInfoContentsSql;
        }
        ArrayList<MobilePortalInfoContentResp> mobilePortalInfoContentResps = new ArrayList<MobilePortalInfoContentResp>();
        HashMap ballListMap = new HashMap();
        mobilePortalInfoContents.stream().filter(x -> Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(x.getContentType())).forEach(x -> {
            BallResp ballResp = BallResp.builder().ballName(x.getContentName()).iconType(x.getIconType()).contentIcon(StringUtils.isNotEmpty((CharSequence)x.getContentIcon()) ? x.getContentIcon() : "/assets/img/mobile/king/default.svg").jumpTarget(x.getJumpTarget()).jumpType(x.getJumpType()).customApplicationId(x.getCustomApplicationId()).createUserId(x.getCreateUserId()).build();
            if (ObjectUtils.isNotEmpty((Object)x.getIconType())) {
                if (x.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                    ballResp.setIconUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + ballResp.getContentIcon());
                } else if (x.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                    ballResp.setIconUrl(this.envProperties.getSemcWebUrl() + ballResp.getContentIcon());
                }
            }
            if (ballListMap.containsKey(x.getParentId())) {
                List ballResps = (List)ballListMap.get(x.getParentId());
                ballResps.add(ballResp);
            } else {
                ArrayList<BallResp> ballResps = new ArrayList<BallResp>();
                ballResps.add(ballResp);
                ballListMap.put(x.getParentId(), ballResps);
            }
        });
        if (CollectionUtils.isEmpty(mobilePortalInfoContents)) {
            return result;
        }
        for (MobilePortalInfoContent content : mobilePortalInfoContents) {
            MobilePortalContentNews newsInfo;
            if (Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(content.getContentType())) continue;
            MobilePortalInfoContentResp mobilePortalInfoContentResp = (MobilePortalInfoContentResp)this.converter.convert((Object)content, MobilePortalInfoContentResp.class);
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(mobilePortalInfoContentResp.getContentType())) {
                if (Constants.DistrictCustomTypeEnum.TENANT_TYPE.getValue().equals(mobilePortalInfoContentResp.getCustomType())) {
                    List ballResps = (List)ballListMap.get(content.getId());
                    List ballAuthResp = this.filterPermissionBallList(ballResps);
                    mobilePortalInfoContentResp.setBallList(ballAuthResp);
                    mobilePortalInfoContentResps.add(mobilePortalInfoContentResp);
                }
                if (!Constants.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(mobilePortalInfoContentResp.getCustomType())) continue;
                mobilePortalInfoContentResps.addAll(this.buildColumnDistrict(mobilePortalInfoContentResp));
                continue;
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                MobilePortalContentCarousel carouselInfo = (MobilePortalContentCarousel)JSON.parseObject((String)content.getContentAttr(), MobilePortalContentCarousel.class);
                for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                    String icon = image.getContentIcon();
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)icon)) {
                        icon = this.envProperties.getSemcWebUrl() + icon;
                    }
                    image.setContentIcon(icon);
                }
                content.setCarouselInfo(carouselInfo);
                mobilePortalInfoContentResp.setCarouselInfo(carouselInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType()) && null != (newsInfo = (MobilePortalContentNews)JSON.parseObject((String)content.getContentAttr(), MobilePortalContentNews.class))) {
                String[] newsTypeIds;
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(Integer.valueOf(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",") && (newsTypeIds = newsInfo.getNewsTypeIdStr().split(",")).length >= 2) {
                    newsInfo.setChildrenNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[1])));
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[0])));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsInfo.getNewsTypeIdStr())));
                }
                mobilePortalInfoContentResp.setNewsInfo(newsInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = (MobilePortalTitleInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + iconUrl;
                }
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                mobilePortalInfoContentResp.setTitleInfo(titleInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = (MobilePortalDividerInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                mobilePortalInfoContentResp.setDividerInfo(dividerInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = (MobilePortalImageInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty((CharSequence)imageCompInfo.getImageId())) {
                    imageCompInfo.setImageUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + imageCompInfo.getImageId());
                }
                mobilePortalInfoContentResp.setImageCompInfo(imageCompInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = (MobilePortalBusinessInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty((Collection)businessCompInfo.getImageList())) {
                    for (MobilePortalContentCarouselImage image : businessCompInfo.getImageList()) {
                        String imageUrl = StringUtils.isEmpty((CharSequence)image.getImageId()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + image.getImageId();
                        image.setImageUrl(imageUrl);
                    }
                }
                mobilePortalInfoContentResp.setBusinessCompInfo(businessCompInfo);
            }
            mobilePortalInfoContentResps.add(mobilePortalInfoContentResp);
        }
        result.setContentList(mobilePortalInfoContentResps);
        return result;
    }

    private List<BallResp> filterPermissionBallList(List<BallResp> ballResps) {
        List notCustomApplicationIdList = ballResps.stream().filter(x -> !Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType())).map(BallResp::getCustomApplicationId).collect(Collectors.toList());
        List customApplicationIdList = ballResps.stream().filter(x -> Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType())).map(BallResp::getCustomApplicationId).collect(Collectors.toList());
        List withPermissionList = this.mobileUserAuthService.validUserAppAuth(customApplicationIdList);
        return ballResps.stream().filter(x -> notCustomApplicationIdList.contains(x.getCustomApplicationId()) || withPermissionList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
    }

    private List<MobilePortalInfoContentResp> buildColumnDistrict(MobilePortalInfoContentResp mobilePortalInfoContentResp) {
        ArrayList<MobilePortalInfoContentResp> result = new ArrayList<MobilePortalInfoContentResp>();
        String userId = Utils.getUserId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)userId)).eq(MobileApplicatonColumn::getStatus, (Object)Constants.VALID_STATUS_ENABLE)).orderByAsc(MobileApplicatonColumn::getOrderId)).orderByAsc(MobileApplicatonColumn::getId);
        List mobileApplicatonColumns = this.applicatonColumnMapper.selectList((Wrapper)queryWrapper);
        Map<Long, List<MobileApplicatonColumn>> appMap = mobileApplicatonColumns.stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getParentId())).collect(Collectors.groupingBy(MobileApplicatonColumn::getParentId));
        List customAppIds = mobileApplicatonColumns.stream().filter(x -> ObjectUtils.isNotEmpty((Object)x.getCustomApplicationId())).map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        Map<Object, Object> customAppMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customAppIds)) {
            List mobileDatasourceInfos = this.mobileCustomApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MobileDatasourceInfo::getStatus, (Object)Constants.VALID_STATUS_ENABLE)).in(MobileDatasourceInfo::getId, customAppIds));
            customAppMap = mobileDatasourceInfos.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, Function.identity()));
        }
        for (MobileApplicatonColumn mobileApplicatonColumn : mobileApplicatonColumns) {
            if (ObjectUtils.isNotEmpty((Object)mobileApplicatonColumn.getParentId()) || ObjectUtils.isNotEmpty((Object)mobileApplicatonColumn.getCustomApplicationId())) continue;
            MobilePortalInfoContentResp resp = new MobilePortalInfoContentResp();
            resp.setColumnId(mobileApplicatonColumn.getId());
            resp.setContentId(mobilePortalInfoContentResp.getContentId());
            resp.setContentType(Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal());
            resp.setParentId(mobilePortalInfoContentResp.getContentId());
            resp.setContentName(mobileApplicatonColumn.getName());
            resp.setContentUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            resp.setTitle(mobileApplicatonColumn.getName());
            resp.setIsTitleShow(mobileApplicatonColumn.getIsNameShow());
            resp.setIsNameShow(mobilePortalInfoContentResp.getIsNameShow());
            resp.setInteractionType(mobilePortalInfoContentResp.getInteractionType());
            resp.setCustomType(Constants.DistrictCustomTypeEnum.USER_TYPE.getValue());
            resp.setColumnNum(mobilePortalInfoContentResp.getColumnNum());
            resp.setLineNum(mobilePortalInfoContentResp.getLineNum());
            ArrayList<BallResp> ballRespList = new ArrayList<BallResp>();
            if (appMap.containsKey(mobileApplicatonColumn.getId())) {
                List<MobileApplicatonColumn> columns = appMap.get(mobileApplicatonColumn.getId());
                for (MobileApplicatonColumn column : columns) {
                    Long customApplicationId = column.getCustomApplicationId();
                    if (!customAppMap.containsKey(customApplicationId)) continue;
                    MobileDatasourceInfo mobileDatasourceInfo = (MobileDatasourceInfo)customAppMap.get(customApplicationId);
                    BallResp ballResp = new BallResp();
                    ballResp.setBallName(mobileDatasourceInfo.getName());
                    ballResp.setJumpType(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue());
                    ballResp.setJumpTarget(ObjectUtils.isEmpty((Object)mobileDatasourceInfo.getCallBackUrl()) ? "" : mobileDatasourceInfo.getCallBackUrl());
                    String icon = mobileDatasourceInfo.getIcon();
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                        icon = this.envProperties.getSemcWebUrl() + icon;
                    }
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                        icon = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + icon;
                    }
                    ballResp.setIconUrl(icon);
                    ballResp.setCustomApplicationId(Long.valueOf(customApplicationId));
                    ballRespList.add(ballResp);
                }
            }
            resp.setBallList(ballRespList);
            result.add(resp);
        }
        if (CollectionUtils.isEmpty(result)) {
            result.add(mobilePortalInfoContentResp);
            return result;
        }
        ArrayList ballList = Lists.newArrayList();
        result.forEach(x -> ballList.addAll(x.getBallList()));
        List withPermissionList = this.filterPermissionBallList((List)ballList);
        List customApplicationIdList = withPermissionList.stream().map(BallResp::getCustomApplicationId).collect(Collectors.toList());
        for (MobilePortalInfoContentResp portalInfoContentResp : result) {
            List resultBallList = portalInfoContentResp.getBallList().stream().filter(x -> customApplicationIdList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
            portalInfoContentResp.setBallList(resultBallList);
        }
        return result;
    }

    public List<MobilePortalInfoItemResp> selectUserPortal() {
        QueryWrapper wrapper = new QueryWrapper();
        List mobilePortalInfoAuths = this.mobilePortalInfoAuthMapper.selectList((Wrapper)this.labelSystemAuthService.getUserAuthCon(wrapper));
        MobilePortalInfo mobilePortalInfo = this.initMobileDefPortal();
        ArrayList<MobilePortalInfoItemResp> result = new ArrayList<MobilePortalInfoItemResp>();
        MobilePortalInfoItemResp defPortalItem = (MobilePortalInfoItemResp)this.converter.convert((Object)mobilePortalInfo, MobilePortalInfoItemResp.class);
        defPortalItem.setName(defPortalItem.getName());
        if (CollectionUtils.isEmpty((Collection)mobilePortalInfoAuths)) {
            result.add(defPortalItem);
            return result;
        }
        List portalIds = mobilePortalInfoAuths.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
        List portalInfoList = this.mobilePortalInfoMapper.selectBatchIds(portalIds);
        portalIds.add(mobilePortalInfo.getId());
        portalInfoList = portalInfoList.stream().filter(x -> Constants.ReleaseEnum.RELEASED.getVal().equals(x.getStatus())).filter(x -> Constants.MobilePortalTypeEnum.PORTAL.getFlag().equals(x.getPortalType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(portalInfoList)) {
            result.add(defPortalItem);
            return result;
        }
        result.add(defPortalItem);
        Collator cmp = Collator.getInstance(Locale.CHINA);
        portalInfoList.sort((a, b) -> cmp.compare(a.getName(), b.getName()));
        for (int i = 0; i < portalInfoList.size(); ++i) {
            MobilePortalInfoItemResp item = (MobilePortalInfoItemResp)this.converter.convert(portalInfoList.get(i), MobilePortalInfoItemResp.class);
            result.add(item);
        }
        return result;
    }

    @Transactional
    public MobilePortalInfoResp getPortalDetail(MobilePortalInfoResp mobilePortalInfoResp) {
        List contentRespList = mobilePortalInfoResp.getContentList();
        if (mobilePortalInfoResp.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_NO)) {
            QueryWrapper condition = new QueryWrapper();
            List portalInfoAuthList = this.mobilePortalInfoAuthMapper.selectList((Wrapper)this.labelSystemAuthService.getUserAuthCon(condition));
            List portalIds = portalInfoAuthList.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
            String recentlyMsg = "";
            if (!portalIds.contains(mobilePortalInfoResp.getId())) {
                recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
                if (mobilePortalInfoResp.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                    recentlyMsg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
                }
                mobilePortalInfoResp.setRecentlyMsg(recentlyMsg);
                return mobilePortalInfoResp;
            }
        }
        if (CollectionUtils.isEmpty((Collection)contentRespList)) {
            return mobilePortalInfoResp;
        }
        Map<Object, Object> preInfoMap = new HashMap();
        List preDataList = contentRespList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(item.getContentType()) || Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(item.getContentType()) || Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preDataList)) {
            List preIds = preDataList.stream().map(MobilePortalInfoContentResp::getContentId).collect(Collectors.toList());
            List preList = this.mobileLabelSystemPreMapper.selectBatchIds(preIds);
            preInfoMap = preList.stream().collect(Collectors.toMap(MobileLabelSystemPre::getId, Function.identity(), (a, b) -> a));
        }
        for (MobilePortalInfoContentResp content : contentRespList) {
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType()) || Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(content.getContentType()) || Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(content.getContentType())) {
                MobileLabelSystemPre mobileLabelSystemPre = (MobileLabelSystemPre)preInfoMap.get(content.getContentId());
                content.setContentName(StringUtils.isEmpty((CharSequence)content.getContentName()) ? mobileLabelSystemPre.getName() : content.getContentName());
            }
            if (!StringUtils.isNotEmpty((CharSequence)content.getContentName())) continue;
            content.setContentName(content.getContentName());
        }
        mobilePortalInfoResp.setContentList(contentRespList);
        return mobilePortalInfoResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public MobilePortalInfo initMobileDefPortal() {
        MobilePortalInfo defPortalTent = this.mobilePortalInfoMapper.queryMobileTentDefPortal();
        MobilePortalInfo defPortal = this.mobilePortalInfoMapper.queryMobileDefPortal();
        if (null != defPortalTent) {
            defPortalTent.setPortalImgId(defPortal.getPortalImgId());
            this.mobilePortalInfoMapper.updateById((Object)defPortalTent);
        } else {
            MobilePortalInfo newDefPortalTent = new MobilePortalInfo();
            BeanUtils.copyProperties((Object)defPortal, (Object)newDefPortalTent);
            newDefPortalTent.setId(null);
            this.mobilePortalInfoMapper.insert((Object)newDefPortalTent);
            defPortalTent = newDefPortalTent;
        }
        ArrayList contentTypeList = new ArrayList();
        List contentList = this.mobilePortalInfoContentMapper.queryMobiePortalCont(defPortalTent.getId(), contentTypeList);
        List labelSystemPreList = this.mobileLabelSystemPreService.initMobileLabelSystemPre();
        Map preInfoMap = labelSystemPreList.stream().collect(Collectors.toMap(MobileLabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
        RedisLock redisLock = new RedisLock("MobilePortalInfoContent:" + Utils.getTenantId());
        try {
            redisLock.lock();
            this.delMobilePortalContent(defPortalTent.getId(), null);
            HashMap<Long, Long> contentIdMap = new HashMap<Long, Long>();
            for (MobilePortalInfoContent contentInfo : contentList) {
                MobilePortalInfoContent content = new MobilePortalInfoContent();
                BeanUtils.copyProperties((Object)contentInfo, (Object)content);
                content.setId(null);
                content.setTenantId(Utils.getTenantId());
                content.setMobilePortalId(defPortalTent.getId());
                if (contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) {
                    Long parentId = (Long)contentIdMap.get(contentInfo.getParentId());
                    content.setParentId(parentId);
                }
                if (!contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) {
                    MobileLabelSystemPre systemPre = (MobileLabelSystemPre)preInfoMap.get(contentInfo.getContentType());
                    content.setContentId(systemPre == null ? null : systemPre.getId());
                }
                this.mobilePortalInfoContentMapper.insert((Object)content);
                if (contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) continue;
                contentIdMap.put(contentInfo.getId(), content.getId());
            }
        }
        catch (InterruptedException e) {
            log.error("initMobileDefPortal occur error:{}", (Object)e.getMessage());
        }
        finally {
            redisLock.unlock();
        }
        return defPortalTent;
    }

    public void delMobilePortalContent(Long portalId, List<Long> portalIdList) {
        QueryWrapper condition = new QueryWrapper();
        if (null != portalId) {
            condition.eq((Object)"mobile_portal_id", (Object)portalId);
        }
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in((Object)"mobile_portal_id", portalIdList);
        }
        this.mobilePortalInfoContentMapper.delete((Wrapper)condition);
    }

    public Boolean addUseRecord(Long portId) {
        MobilePortalInfo mobilePortalInfo = (MobilePortalInfo)this.mobilePortalInfoMapper.selectById((Serializable)portId);
        if (ObjectUtils.isEmpty((Object)mobilePortalInfo)) {
            return false;
        }
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"create_user_id", (Object)Utils.getUserId());
        this.mobilePortalInfoUseMapper.delete((Wrapper)condition);
        MobilePortalInfoUse infoUse = new MobilePortalInfoUse();
        infoUse.setMobilePortalId(portId);
        infoUse.setTenantId(Utils.getTenantId());
        int insert = this.mobilePortalInfoUseMapper.insert((Object)infoUse);
        return true;
    }

    public List<MobilePortalInfo> checkPortal(MobilePortalInfo req) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.eq((Object)"name", (Object)req.getName());
        }
        if (null != req.getPortalType()) {
            condition.eq((Object)"portal_type", (Object)req.getPortalType());
        }
        if (null != req.getId()) {
            condition.ne((Object)"id", (Object)req.getId());
        }
        return this.mobilePortalInfoMapper.selectList((Wrapper)condition);
    }

    @Transactional
    public MobilePortalInfo savePortal(MobilePortalInfo req) {
        req.setModifyTime(DateUtils.getNowTime((String)""));
        req.setModifyUserName(Utils.getUserName());
        req.setTenantId(Utils.getTenantId());
        if (null == req.getStatus()) {
            req.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        }
        if (null == req.getId()) {
            req.setCreateUserName(Utils.getUserName());
            req.setCreateTime(DateUtils.getNowTime((String)""));
            this.mobilePortalInfoMapper.insert((Object)req);
            req.setId(req.getId());
        } else {
            this.mobilePortalInfoMapper.updateById((Object)req);
        }
        this.delMobilePortalContent(req.getId(), null);
        if (CollectionUtils.isNotEmpty((Collection)req.getContentList())) {
            this.savePortalContent(req);
        }
        return req;
    }

    @Transactional
    public Integer copyPortal(MobilePortalInfo req) {
        List contentList = this.mobilePortalInfoContentMapper.queryMobiePortalCont(req.getId(), new ArrayList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MobilePortalInfoAuth::getMobilePortalId, (Object)req.getId());
        List mobilePortalAuthList = this.mobilePortalInfoAuthMapper.selectList((Wrapper)queryWrapper);
        req.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        req.setCreateUserName(Utils.getUserName());
        req.setCreateTime(DateUtils.getNowTime((String)""));
        req.setModifyUserName(Utils.getUserName());
        req.setModifyTime(DateUtils.getNowTime((String)""));
        req.setModifyUserId(Utils.getUserId());
        req.setId(null);
        String name = DateUtils.getNowTime((String)"yyyyMMddHHmmss");
        req.setName(name + "_\u590d\u5236");
        this.mobilePortalInfoMapper.insert((Object)req);
        Long newPortalID = req.getId();
        HashMap<Long, Long> contentIdMap = new HashMap<Long, Long>();
        for (MobilePortalInfoContent content : contentList) {
            Long oldContentId = content.getId();
            content.setId(null);
            content.setMobilePortalId(newPortalID);
            content.setCreateTime(DateUtils.getNowTime((String)""));
            if (null != content.getParentId() && null != contentIdMap.get(content.getParentId())) {
                content.setParentId((Long)contentIdMap.get(content.getParentId()));
            }
            this.mobilePortalInfoContentMapper.insert((Object)content);
            contentIdMap.put(oldContentId, content.getId());
        }
        for (MobilePortalInfoAuth mobilePortalAuth : mobilePortalAuthList) {
            mobilePortalAuth.setId(null);
            mobilePortalAuth.setMobilePortalId(newPortalID);
            mobilePortalAuth.setCreateTime(DateUtils.getNowTime((String)""));
            this.mobilePortalInfoAuthMapper.insert((Object)mobilePortalAuth);
        }
        return null;
    }

    public void savePortalContent(MobilePortalInfo req) {
        if (null == req.getId()) {
            return;
        }
        for (MobilePortalInfoContent content : req.getContentList()) {
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getCarouselInfo()));
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getNewsInfo()));
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getTitleInfo()));
            }
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getDividerInfo()));
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getImageCompInfo()));
            }
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getBusinessCompInfo()));
            }
            content.setMobilePortalId(req.getId());
            content.setTenantId(req.getTenantId());
            content.setParentId(Long.valueOf(0L));
            content.setId(null);
            this.mobilePortalInfoContentMapper.insert((Object)content);
            if (CollectionUtils.isEmpty((Collection)content.getBallList())) continue;
            for (MobilePortalInfoContent bill : content.getBallList()) {
                Long id = content.getId();
                bill.setIsNameShow(content.getIsNameShow());
                bill.setParentId(id);
                bill.setId(null);
                bill.setMobilePortalId(content.getMobilePortalId());
                bill.setContentId(null);
                bill.setContentName(bill.getBallName());
                bill.setContentType(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal());
                bill.setCustomApplicationId(bill.getCustomApplicationId());
                this.mobilePortalInfoContentMapper.insert((Object)bill);
            }
        }
    }

    @Transactional
    public ResultPageBean pageQuery(PortalInfoQueryReq req) {
        this.initMobileDefPortal();
        List mobilePortalInfoList = this.getListMobilePortal(req);
        for (MobilePortalInfo mobilePortalInfo : mobilePortalInfoList) {
            if (!StringUtils.isNotEmpty((CharSequence)mobilePortalInfo.getPortalImgId())) continue;
            String portalImgUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + mobilePortalInfo.getPortalImgId();
            mobilePortalInfo.setPortalImgUrl(portalImgUrl);
        }
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(mobilePortalInfoList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)mobilePortalInfoList.size())));
        return resultPageBean;
    }

    public List<MobilePortalInfo> getListMobilePortal(PortalInfoQueryReq req) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"portal_type", (Object)req.getPortalType());
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.like((Object)"name", (Object)req.getName());
        }
        if (null != req.getStatus()) {
            condition.eq((Object)"status", (Object)req.getStatus());
        }
        if (null == req.getSortType() || StringUtils.isEmpty((CharSequence)req.getOrderBy())) {
            ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByDesc((Object)"modify_time");
        }
        if (null != req.getSortType() && req.getSortType() == 1) {
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByDesc((Object)"create_time");
            }
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByAsc((Object)"create_time");
            }
        }
        if (null != req.getSortType() && req.getSortType() == 2) {
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByDesc((Object)"modify_time");
            }
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByAsc((Object)"modify_time");
            }
        }
        if (ObjectUtils.isNotEmpty((Object)req.getClientType())) {
            condition.ne((Object)"default_flag", (Object)Constants.DEFAULT_CONFIGURED_FLAG_YES);
        }
        return this.mobilePortalInfoMapper.selectList((Wrapper)condition);
    }

    @Transactional
    public Integer updateBat(PortalInfoQueryReq req) {
        req.setModifyTime(DateUtils.getNowTime((String)""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());
        this.mobilePortalInfoMapper.updateBat(req.getIdList(), req);
        return null;
    }

    @Transactional
    public void saveApplicationColumn(ApplicationColumnReq applicationColumnReq) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Long parentId = applicationColumnReq.getId();
        MobileApplicatonColumn mobileApplicatonColumn = (MobileApplicatonColumn)this.converter.convert((Object)applicationColumnReq, MobileApplicatonColumn.class);
        mobileApplicatonColumn.setStatus(ObjectUtils.isEmpty((Object)applicationColumnReq.getStatus()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getStatus());
        mobileApplicatonColumn.setIsNameShow(ObjectUtils.isEmpty((Object)applicationColumnReq.getIsNameShow()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getIsNameShow());
        if (ObjectUtils.isEmpty((Object)applicationColumnReq.getId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).isNull(MobileApplicatonColumn::getParentId);
            List mobileApplicatonColumns = this.applicatonColumnMapper.selectList((Wrapper)queryWrapper);
            int count = CollectionUtils.isEmpty((Collection)mobileApplicatonColumns) ? 0 : mobileApplicatonColumns.size();
            mobileApplicatonColumn.setOrderId(Integer.valueOf(count));
            this.applicatonColumnMapper.insert((Object)mobileApplicatonColumn);
            parentId = mobileApplicatonColumn.getId();
        } else {
            this.applicatonColumnMapper.updateById((Object)mobileApplicatonColumn);
            ((LambdaQueryWrapper)wrapper.eq(MobileApplicatonColumn::getParentId, (Object)parentId)).eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
            this.applicatonColumnMapper.delete((Wrapper)wrapper);
        }
        wrapper.clear();
        if (CollectionUtils.isEmpty((Collection)applicationColumnReq.getCustomApplication())) {
            return;
        }
        List customApplicationIds = applicationColumnReq.getCustomApplication().stream().map(SaveAppcationReq::getId).collect(Collectors.toList());
        List withPermissionList = this.mobileUserAuthService.validUserAppAuth(customApplicationIds);
        for (Long customApplicationId : customApplicationIds) {
            if (!withPermissionList.contains(customApplicationId)) continue;
            MobileApplicatonColumn mobileApplicatonColumnItem = new MobileApplicatonColumn();
            mobileApplicatonColumnItem.setParentId(parentId);
            mobileApplicatonColumnItem.setStatus(Constants.VALID_STATUS_ENABLE);
            mobileApplicatonColumnItem.setCustomApplicationId(customApplicationId);
            this.applicatonColumnMapper.insert((Object)mobileApplicatonColumnItem);
        }
    }

    @Transactional
    public void saveApplicationColumnNew(ApplicationColumnReqNew applicationColumnReq) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Long parentId = applicationColumnReq.getId();
        MobileApplicatonColumnNew mobileApplicatonColumnNew = new MobileApplicatonColumnNew();
        mobileApplicatonColumnNew.setId(applicationColumnReq.getId());
        mobileApplicatonColumnNew.setName(applicationColumnReq.getName());
        mobileApplicatonColumnNew.setStatus(applicationColumnReq.getStatus());
        mobileApplicatonColumnNew.setIsNameShow(applicationColumnReq.getIsNameShow());
        mobileApplicatonColumnNew.setParentId(applicationColumnReq.getParentId());
        mobileApplicatonColumnNew.setIsNameShow(ObjectUtils.isEmpty((Object)applicationColumnReq.getIsNameShow()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getIsNameShow());
        if (ObjectUtils.isEmpty((Object)applicationColumnReq.getId())) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).isNull(MobileApplicatonColumn::getParentId);
            List mobileApplicatonColumns = this.applicatonColumnMapper.selectList((Wrapper)queryWrapper);
            int count = CollectionUtils.isEmpty((Collection)mobileApplicatonColumns) ? 0 : mobileApplicatonColumns.size();
            mobileApplicatonColumnNew.setOrderId(Integer.valueOf(count));
            mobileApplicatonColumnNew.setStatus(ObjectUtils.isEmpty((Object)applicationColumnReq.getStatus()) ? Constants.VALID_STATUS_ENABLE : applicationColumnReq.getStatus());
            this.mobileApplicatonColumnNewMapper.insert((Object)mobileApplicatonColumnNew);
            parentId = mobileApplicatonColumnNew.getId();
        } else {
            this.mobileApplicatonColumnNewMapper.updateById((Object)mobileApplicatonColumnNew);
            ((LambdaQueryWrapper)wrapper.eq(MobileApplicatonColumnNew::getParentId, (Object)parentId)).eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
            this.mobileApplicatonColumnNewMapper.delete((Wrapper)wrapper);
        }
        wrapper.clear();
        if (CollectionUtils.isEmpty((Collection)applicationColumnReq.getCustomApplication())) {
            return;
        }
        for (SaveAppcationReqNew saveAppcationReq : applicationColumnReq.getCustomApplication()) {
            MobileApplicatonColumnNew mobileApplicatonColumnItem = new MobileApplicatonColumnNew();
            mobileApplicatonColumnItem.setParentId(parentId);
            mobileApplicatonColumnItem.setStatus(Constants.VALID_STATUS_ENABLE);
            mobileApplicatonColumnItem.setCustomApplicationId(saveAppcationReq.getId());
            mobileApplicatonColumnItem.setSource(saveAppcationReq.getSource());
            mobileApplicatonColumnItem.setModuleId(saveAppcationReq.getModuleId());
            this.mobileApplicatonColumnNewMapper.insert((Object)mobileApplicatonColumnItem);
        }
    }

    @Transactional
    public Integer delBat(PortalInfoQueryReq req) {
        this.mobilePortalInfoMapper.deleteBatchIds((Collection)req.getIdList());
        this.delMobilePortalContent(null, req.getIdList());
        this.delPortalAuth(req.getIdList());
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)req.getIdList())) {
            condition.in((Object)"mobile_portal_id", (Collection)req.getIdList());
            this.mobilePortalPreviewMapper.delete((Wrapper)condition);
        }
        return null;
    }

    public void delPortalAuth(List<Long> portalIdList) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in((Object)"mobile_portal_id", portalIdList);
        }
        this.mobilePortalInfoAuthMapper.delete((Wrapper)condition);
    }

    @Transactional
    public Integer savePortalAuth(PortalInfoAuthReq req) {
        ArrayList<Long> portalIdList = new ArrayList<Long>();
        portalIdList.add(req.getId());
        this.delPortalAuth(portalIdList);
        for (PortalInfoAuthReq.AuthVO authVO : req.getAuthList()) {
            MobilePortalInfoAuth portalInfoAuth = (MobilePortalInfoAuth)this.converter.convert((Object)authVO, MobilePortalInfoAuth.class);
            portalInfoAuth.setMobilePortalId(req.getId());
            this.mobilePortalInfoAuthMapper.insert((Object)portalInfoAuth);
        }
        return null;
    }

    public List<MobilePortalInfoAuth> selectPortalAuth(List<Long> portalIdList) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in((Object)"mobile_portal_id", portalIdList);
        }
        return this.mobilePortalInfoAuthMapper.selectList((Wrapper)condition);
    }

    public MobilePortalInfoAuthResp selectByPortalAuth(Long portalId) {
        List userDataList;
        List deptDataList;
        List roleDataList;
        MobilePortalInfoAuthResp authResp = new MobilePortalInfoAuthResp();
        ArrayList<Long> portalIdList = new ArrayList<Long>();
        portalIdList.add(portalId);
        List authList = this.selectPortalAuth(portalIdList);
        if (CollectionUtils.isEmpty((Collection)authList)) {
            return authResp;
        }
        List orgDataList = authList.stream().filter(item -> BizAuthTypeEnum.ORG.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgDataList)) {
            authResp.setOrgDataList(orgDataList);
        }
        if (CollectionUtils.isNotEmpty(roleDataList = authList.stream().filter(item -> BizAuthTypeEnum.ROLE.getValue().equals(item.getAuthType())).collect(Collectors.toList()))) {
            authResp.setRoleDataList(roleDataList);
        }
        if (CollectionUtils.isNotEmpty(deptDataList = authList.stream().filter(item -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(item.getAuthType())).collect(Collectors.toList()))) {
            authResp.setDeptDataList(deptDataList);
        }
        if (CollectionUtils.isNotEmpty(userDataList = authList.stream().filter(item -> BizAuthTypeEnum.USER.getValue().equals(item.getAuthType())).collect(Collectors.toList()))) {
            authResp.setUserDataList(userDataList);
        }
        return authResp;
    }

    public MobilePortalInfoResp getMobilePortalDetail(MobilePortalInfo portalInfo) {
        List preDataList;
        MobilePortalInfoResp portalInfoResp = (MobilePortalInfoResp)this.converter.convert((Object)portalInfo, MobilePortalInfoResp.class);
        List portalInfoContentList = this.mobilePortalInfoContentMapper.queryMobiePortalCont(portalInfo.getId(), new ArrayList());
        if (CollectionUtils.isEmpty((Collection)portalInfoContentList)) {
            return portalInfoResp;
        }
        List billDataList = portalInfoContentList.stream().filter(item -> Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(item.getContentType())).collect(Collectors.toList());
        Map<Object, Object> billListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(billDataList)) {
            billListMap = billDataList.stream().collect(Collectors.groupingBy(MobilePortalInfoContent::getParentId));
        }
        if (CollectionUtils.isEmpty(preDataList = portalInfoContentList.stream().filter(item -> !Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(item.getContentType())).collect(Collectors.toList()))) {
            return portalInfoResp;
        }
        List preIds = preDataList.stream().map(MobilePortalInfoContent::getContentId).collect(Collectors.toList());
        List preList = this.mobileLabelSystemPreMapper.selectBatchIds(preIds);
        Map preInfoMap = preList.stream().collect(Collectors.toMap(MobileLabelSystemPre::getId, Function.identity(), (a, b) -> a));
        ArrayList<MobilePortalInfoContentResp> contentList = new ArrayList<MobilePortalInfoContentResp>();
        for (MobilePortalInfoContent preData : preDataList) {
            MobilePortalInfoContentResp contentResp = (MobilePortalInfoContentResp)this.converter.convert((Object)preData, MobilePortalInfoContentResp.class);
            MobileLabelSystemPre labelSystemPre = (MobileLabelSystemPre)preInfoMap.get(preData.getContentId());
            String contentNamePre = labelSystemPre == null ? preData.getContentName() : labelSystemPre.getName();
            String contentName = this.translateService.translateTextCache(contentNamePre, "");
            preData.setContentName(contentName);
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(preData.getContentType())) {
                List billList = (List)billListMap.get(preData.getId());
                ArrayList<BallResp> ballList = new ArrayList<BallResp>();
                if (CollectionUtils.isEmpty((Collection)billList)) {
                    contentResp.setBallList(ballList);
                    contentList.add(contentResp);
                    continue;
                }
                for (MobilePortalInfoContent bill : billList) {
                    bill.setBallName(bill.getContentName());
                    BallResp ballResp = (BallResp)this.converter.convert((Object)bill, BallResp.class);
                    if (StringUtils.isNotBlank((CharSequence)bill.getContentIcon()) && ObjectUtils.isNotEmpty((Object)bill.getIconType())) {
                        if (bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                            ballResp.setIconUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + bill.getContentIcon());
                        } else if (bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                            ballResp.setIconUrl(this.envProperties.getSemcWebUrl() + bill.getContentIcon());
                        }
                    }
                    ballList.add(ballResp);
                }
                contentResp.setBallList(ballList);
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(preData.getContentType())) {
                MobilePortalContentCarousel carouselInfo = (MobilePortalContentCarousel)JSON.parseObject((String)preData.getContentAttr(), MobilePortalContentCarousel.class);
                contentResp.setCarouselInfo(carouselInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(preData.getContentType())) {
                MobilePortalContentNews newsInfo = (MobilePortalContentNews)JSON.parseObject((String)preData.getContentAttr(), MobilePortalContentNews.class);
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(Integer.valueOf(0));
                }
                contentResp.setNewsInfo(newsInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(preData.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = (MobilePortalTitleInfoReqDTO)JSON.parseObject((String)preData.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + iconUrl;
                }
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                contentResp.setTitleInfo(titleInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(preData.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = (MobilePortalDividerInfoReqDTO)JSON.parseObject((String)preData.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                contentResp.setDividerInfo(dividerInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(preData.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = (MobilePortalImageInfoReqDTO)JSON.parseObject((String)preData.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty((CharSequence)imageCompInfo.getImageId())) {
                    imageCompInfo.setImageUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + imageCompInfo.getImageId());
                }
                contentResp.setImageCompInfo(imageCompInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(preData.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = (MobilePortalBusinessInfoReqDTO)JSON.parseObject((String)preData.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty((Collection)businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        String imageUrl = StringUtils.isEmpty((CharSequence)image.getImageId()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + image.getImageId();
                        image.setImageUrl(imageUrl);
                    }
                }
                contentResp.setBusinessCompInfo(businessCompInfo);
            }
            contentList.add(contentResp);
        }
        portalInfoResp.setContentList(contentList);
        return portalInfoResp;
    }

    public MobilePortalPreview previewPortal(MobilePortalInfo req, PortalInfo portalInfo) {
        if (ObjectUtils.isNotEmpty((Object)portalInfo)) {
            return this.saveNewPreview(portalInfo);
        }
        MobilePortalInfoResp portalInfoResp = new MobilePortalInfoResp();
        if (req.getId() != null) {
            portalInfoResp = this.getMobilePortalDetail(req);
        }
        return this.savePreviewPrtal(req, portalInfoResp);
    }

    public MobilePortalPreview getPreviewPortal(Long id) {
        return (MobilePortalPreview)InterceptorIgnoreUtil.handler(() -> (MobilePortalPreview)this.mobilePortalPreviewMapper.selectById((Serializable)id));
    }

    public MobilePortalInfoResp getPreMobilePortal(Long id) {
        MobilePortalInfoResp result = new MobilePortalInfoResp();
        MobilePortalPreview mobilePortalPreview = (MobilePortalPreview)this.mobilePortalPreviewMapper.selectById((Serializable)id);
        if (mobilePortalPreview == null) {
            String recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        if (null != mobilePortalPreview.getEndTime() && mobilePortalPreview.getEndTime().before(new Date())) {
            String recentlyMsg = this.messageUtils.getMessage("error.message.choose.qr.code.invalid");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        String portalContentListJson = mobilePortalPreview.getPortalContentList();
        List mobilePortalInfoContentResps = (List)JsonUtils.jsonToObject((String)portalContentListJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.converter.convert((Object)mobilePortalPreview, (Object)result);
        if (CollectionUtils.isEmpty((Collection)mobilePortalInfoContentResps)) {
            return result;
        }
        for (MobilePortalInfoContentResp mobilePortalInfoContent : mobilePortalInfoContentResps) {
            String[] newsTypeIds;
            MobilePortalContentNews newsInfo;
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(mobilePortalInfoContent.getContentType())) {
                List ballList = this.getBallList(mobilePortalInfoContent);
                List ballAuthResp = this.filterPermissionBallList(ballList);
                ballAuthResp.forEach(item -> {
                    item.setContentIcon(StringUtils.isNotBlank((CharSequence)item.getContentIcon()) ? item.getContentIcon() : "/assets/img/mobile/king/default.svg");
                    if (ObjectUtils.isNotEmpty((Object)item.getIconType())) {
                        if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                            item.setIconUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + item.getContentIcon());
                        } else if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                            item.setIconUrl(this.envProperties.getSemcWebUrl() + item.getContentIcon());
                        }
                    }
                });
                mobilePortalInfoContent.setBallList(ballAuthResp);
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(mobilePortalInfoContent.getContentType()) && null != (newsInfo = mobilePortalInfoContent.getNewsInfo())) {
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(Integer.valueOf(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",") && (newsTypeIds = newsInfo.getNewsTypeIdStr().split(",")).length >= 2) {
                    newsInfo.setChildrenNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[1])));
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[0])));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsInfo.getNewsTypeIdStr())));
                }
                mobilePortalInfoContent.setNewsInfo(newsInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalContentCarousel carouselInfo = mobilePortalInfoContent.getCarouselInfo();
                newsTypeIds = carouselInfo.getImageList().iterator();
                while (newsTypeIds.hasNext()) {
                    MobilePortalContentCarouselImage image = (MobilePortalContentCarouselImage)newsTypeIds.next();
                    String icon = image.getContentIcon();
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)icon)) {
                        icon = this.envProperties.getSemcWebUrl() + icon;
                    }
                    image.setContentIcon(icon);
                }
                mobilePortalInfoContent.setCarouselInfo(carouselInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = mobilePortalInfoContent.getTitleInfo();
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() && StringUtils.isNotEmpty((CharSequence)iconUrl) && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                    iconUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + iconUrl;
                }
                if (null != titleInfo.getIconType() && StringUtils.isNotEmpty((CharSequence)iconUrl) && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                    iconUrl = this.envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                mobilePortalInfoContent.setTitleInfo(titleInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(mobilePortalInfoContent.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = mobilePortalInfoContent.getImageCompInfo();
                if (null != imageCompInfo && StringUtils.isNotEmpty((CharSequence)imageCompInfo.getImageId())) {
                    imageCompInfo.setImageUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + imageCompInfo.getImageId());
                }
                mobilePortalInfoContent.setImageCompInfo(imageCompInfo);
            }
            if (!Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(mobilePortalInfoContent.getContentType())) continue;
            MobilePortalBusinessInfoReqDTO businessCompInfo = mobilePortalInfoContent.getBusinessCompInfo();
            if (null != businessCompInfo && CollectionUtils.isNotEmpty((Collection)businessCompInfo.getImageList())) {
                for (MobilePortalContentCarouselImage image : businessCompInfo.getImageList()) {
                    String imageUrl = StringUtils.isEmpty((CharSequence)image.getImageId()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + image.getImageId();
                    image.setImageUrl(imageUrl);
                }
            }
            mobilePortalInfoContent.setBusinessCompInfo(businessCompInfo);
        }
        result.setContentList(mobilePortalInfoContentResps);
        return result;
    }

    private List<BallResp> getBallList(MobilePortalInfoContentResp mobilePortalInfoContent) {
        List<BallResp> ballList = mobilePortalInfoContent.getBallList();
        if (CollectionUtils.isNotEmpty((Collection)ballList)) {
            return ballList;
        }
        String contentAttr = mobilePortalInfoContent.getContentAttr();
        if (StringUtils.isBlank((CharSequence)contentAttr)) {
            return ballList;
        }
        PortalContentKingKongDistrict district = (PortalContentKingKongDistrict)JSON.parseObject((String)contentAttr, PortalContentKingKongDistrict.class);
        if (null == district) {
            return ballList;
        }
        mobilePortalInfoContent.setIsNameShow(district.getIsNameShow());
        mobilePortalInfoContent.setInteractionType(district.getInteractionType());
        mobilePortalInfoContent.setCustomType(district.getCustomType());
        mobilePortalInfoContent.setColumnNum(district.getColumnNum());
        mobilePortalInfoContent.setLineNum(district.getLineNum());
        List districtBallList = district.getBallList();
        if (CollectionUtils.isEmpty((Collection)districtBallList)) {
            return ballList;
        }
        ballList = districtBallList.stream().map(ball -> BallResp.builder().ballName(ball.getBallName()).iconType(ball.getIconType()).contentIcon(ball.getContentIcon()).iconUrl(ball.getIconUrl()).jumpType(ball.getJumpType()).jumpTarget(ball.getJumpTarget()).customApplicationId(ball.getCustomApplicationId()).build()).collect(Collectors.toList());
        mobilePortalInfoContent.setBallList(ballList);
        return ballList;
    }

    public Boolean saveMobilePortalTypeUse(MobilePortalTypeUse typeUse) {
        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
        deleteWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
        this.mobilePortalTypeUserMapper.delete((Wrapper)deleteWrapper);
        this.mobilePortalTypeUserMapper.insert((Object)typeUse);
        if (!ObjectUtils.isEmpty((Object)typeUse.getMobilePortalId())) {
            MobilePortalInfoUse mobilePortalInfoUse = new MobilePortalInfoUse();
            mobilePortalInfoUse.setMobilePortalId(typeUse.getMobilePortalId());
            MobilePortalInfo mobilePortalInfo = (MobilePortalInfo)this.mobilePortalInfoMapper.selectById((Serializable)typeUse.getMobilePortalId());
            if (ObjectUtils.isNotEmpty((Object)mobilePortalInfo)) {
                mobilePortalInfoUse.setName(mobilePortalInfo.getName());
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
            this.mobilePortalInfoUseMapper.delete((Wrapper)wrapper);
            this.mobilePortalInfoUseMapper.insert((Object)mobilePortalInfoUse);
        }
        return true;
    }

    public ResponseEntity<?> checkPortalInfo(MobilePortalInfo portalInfo) {
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(Boolean.valueOf(false));
        QueryWrapper condition = new QueryWrapper();
        List portalInfoAuthList = this.mobilePortalInfoAuthMapper.selectList((Wrapper)this.labelSystemAuthService.getUserAuthCon(condition));
        List portalIds = portalInfoAuthList.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
        if (portalIds.contains(portalInfo.getId())) {
            checkResp.setIsHavePort(Boolean.valueOf(true));
        } else {
            String msg = this.messageUtils.getMessage("error.message.not.auth");
            if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                msg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
            }
            checkResp.setErrorMsg(msg);
        }
        return ResponseEntityWrapper.wrapperOk((Object)checkResp);
    }

    public MobilePortalPreview savePreviewPrtal(MobilePortalInfo req, MobilePortalInfoResp portalInfoResp) {
        MobilePortalPreview portalPreview = new MobilePortalPreview();
        String contentListJson = "";
        if (req.getId() != null) {
            this.converter.convert((Object)portalInfoResp, (Object)portalPreview);
            contentListJson = JSON.toJSONString((Object)portalInfoResp.getContentList());
            portalPreview.setMobilePortalId(req.getId());
        } else {
            this.converter.convert((Object)req, (Object)portalPreview);
            contentListJson = JSON.toJSONString((Object)req.getContentList());
        }
        List mobilePortalInfoContentResps = (List)JsonUtils.jsonToObject((String)contentListJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        portalPreview.setContentList(mobilePortalInfoContentResps);
        portalPreview.setPortalContentList(contentListJson);
        Date endDate = DateUtils.getNewDate((Date)new Date(), (int[])new int[]{0, 0, 0, 2});
        portalPreview.setEndTime(endDate);
        portalPreview.setId(null);
        if (ObjectUtils.isNotEmpty((Object)req.getOldPortalFlag()) && Boolean.FALSE.equals(req.getOldPortalFlag())) {
            portalPreview.setVersionDefault(Integer.valueOf(1));
        } else {
            portalPreview.setVersionDefault(Integer.valueOf(0));
        }
        this.mobilePortalPreviewMapper.insert((Object)portalPreview);
        return portalPreview;
    }

    public MobilePortalPreview saveNewPreview(PortalInfo portalInfo) {
        MobilePortalPreview portalPreview = new MobilePortalPreview();
        portalPreview.setDefaultFlag(portalInfo.getDefaultFlag());
        portalPreview.setMobilePortalId(portalInfo.getId());
        portalPreview.setPortalTypeSource(portalInfo.getPortalTypeSource());
        portalPreview.setName(portalInfo.getName());
        portalPreview.setTitle(portalInfo.getTitle());
        portalPreview.setBgColor(portalInfo.getBgColor());
        portalPreview.setPortalType(portalInfo.getPortalType());
        portalPreview.setPortalDesc(portalInfo.getPortalDesc());
        portalPreview.setPortalImgId(portalInfo.getPortalImgId());
        portalPreview.setTenantId(portalInfo.getTenantId());
        portalPreview.setCreateUserName(portalInfo.getCreateUserName());
        portalPreview.setModifyUserName(portalInfo.getModifyUserName());
        String contentListJson = JSON.toJSONString((Object)portalInfo.getContentList());
        List mobilePortalInfoContentResps = (List)JsonUtils.jsonToObject((String)contentListJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        portalPreview.setContentList(mobilePortalInfoContentResps);
        portalPreview.setPortalContentList(contentListJson);
        Date endDate = DateUtils.getNewDate((Date)new Date(), (int[])new int[]{0, 0, 0, 2});
        portalPreview.setEndTime(endDate);
        portalPreview.setId(null);
        portalPreview.setVersionDefault(portalInfo.getVersionDefault());
        this.mobilePortalPreviewMapper.insert((Object)portalPreview);
        return portalPreview;
    }

    public List<MobileAppColumnResp> getApplicationColumnList() {
        String userId = Utils.getUserId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)userId)).isNull(MobileApplicatonColumn::getCustomApplicationId)).isNull(MobileApplicatonColumn::getParentId)).orderByAsc(MobileApplicatonColumn::getOrderId);
        List mobileApplicatonColumns = this.applicatonColumnMapper.selectList((Wrapper)queryWrapper);
        List<MobileAppColumnResp> result = mobileApplicatonColumns.stream().map(item -> {
            MobileAppColumnResp mobileAppColumnResp = (MobileAppColumnResp)this.converter.convert(item, MobileAppColumnResp.class);
            return mobileAppColumnResp;
        }).collect(Collectors.toList());
        return result;
    }

    public List<MobileAppColumnResp> getApplicationColumnListNew() {
        String userId = Utils.getUserId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)userId)).isNull(MobileApplicatonColumnNew::getCustomApplicationId)).isNull(MobileApplicatonColumnNew::getParentId)).orderByAsc(MobileApplicatonColumnNew::getOrderId);
        List mobileApplicatonColumns = this.mobileApplicatonColumnNewMapper.selectList((Wrapper)queryWrapper);
        List<MobileAppColumnResp> result = mobileApplicatonColumns.stream().map(item -> {
            MobileAppColumnResp mobileAppColumnResp = new MobileAppColumnResp();
            mobileAppColumnResp.setId(item.getId());
            mobileAppColumnResp.setCustomApplicationId(item.getCustomApplicationId());
            mobileAppColumnResp.setIsNameShow(item.getIsNameShow());
            mobileAppColumnResp.setName(item.getName());
            mobileAppColumnResp.setOrderId(item.getOrderId());
            mobileAppColumnResp.setParentId(item.getParentId());
            mobileAppColumnResp.setStatus(item.getStatus());
            mobileAppColumnResp.setTenantId(item.getTenantId());
            return mobileAppColumnResp;
        }).collect(Collectors.toList());
        return result;
    }

    public MobileAppColumnResp getApplicationColumnDetailNew(MobileApplicatonColumnNew mobileApplicatonColumn) {
        Long parentId = mobileApplicatonColumn.getId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(MobileApplicatonColumnNew::getParentId, (Object)parentId)).eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
        queryWrapper.orderByAsc(MobileApplicatonColumnNew::getId);
        List mobileApplicatonColumns = this.mobileApplicatonColumnNewMapper.selectList((Wrapper)queryWrapper);
        List customAppIds = mobileApplicatonColumns.stream().map(MobileApplicatonColumnNew::getCustomApplicationId).collect(Collectors.toList());
        MobileAppColumnResp mobileAppColumnResp = new MobileAppColumnResp();
        mobileAppColumnResp.setId(mobileApplicatonColumn.getId());
        mobileAppColumnResp.setCustomApplicationId(mobileApplicatonColumn.getCustomApplicationId());
        mobileAppColumnResp.setIsNameShow(mobileApplicatonColumn.getIsNameShow());
        mobileAppColumnResp.setName(mobileApplicatonColumn.getName());
        mobileAppColumnResp.setOrderId(mobileApplicatonColumn.getOrderId());
        mobileAppColumnResp.setParentId(mobileApplicatonColumn.getParentId());
        mobileAppColumnResp.setStatus(mobileApplicatonColumn.getStatus());
        mobileAppColumnResp.setTenantId(mobileApplicatonColumn.getTenantId());
        ArrayList customApps = new ArrayList();
        mobileAppColumnResp.setMobileCustomAppList(customApps);
        return mobileAppColumnResp;
    }

    public MobileAppColumnResp getApplicationColumnDetail(MobileApplicatonColumn mobileApplicatonColumn) {
        Long parentId = mobileApplicatonColumn.getId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(MobileApplicatonColumn::getParentId, (Object)parentId)).eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
        queryWrapper.orderByAsc(MobileApplicatonColumn::getId);
        List mobileApplicatonColumns = this.applicatonColumnMapper.selectList((Wrapper)queryWrapper);
        List customAppIds = mobileApplicatonColumns.stream().map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        MobileAppColumnResp mobileAppColumnResp = (MobileAppColumnResp)this.converter.convert((Object)mobileApplicatonColumn, MobileAppColumnResp.class);
        List customApps = new ArrayList();
        if (CollectionUtils.isNotEmpty(customAppIds)) {
            customApps = this.getCustomApplication(customAppIds);
        }
        mobileAppColumnResp.setMobileCustomAppList(customApps);
        return mobileAppColumnResp;
    }

    public List<MobileDatasourceInfoVO> getCustomApplication(List<Long> customAppIds) {
        ArrayList<MobileDatasourceInfoVO> result = new ArrayList<MobileDatasourceInfoVO>();
        List mobileDatasourceInfos = this.mobileCustomApplicationMapper.selectMobileList(customAppIds);
        if (CollectionUtils.isEmpty((Collection)mobileDatasourceInfos)) {
            return result;
        }
        List classificationList = this.mobileApplicationClassificationMapper.queryApplicationClassificationList(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        Map<Long, String> idNameMap = classificationList.stream().collect(Collectors.toMap(MobileDatasourceClassification::getId, MobileDatasourceClassification::getClassificationName, (a, b) -> a));
        List mobileAppIdList = mobileDatasourceInfos.stream().filter(x -> !Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).map(MobileDatasourceInfo::getId).collect(Collectors.toList());
        List notAthenaAppList = mobileDatasourceInfos.stream().filter(x -> Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notAthenaAppList)) {
            List withPermissionList = this.mobileUserAuthService.validPermission(notAthenaAppList);
            mobileAppIdList.addAll(withPermissionList);
        }
        for (MobileDatasourceInfo mobileDatasourceInfo : mobileDatasourceInfos) {
            MobileDatasourceInfoVO mobileCustomApplicationVO = (MobileDatasourceInfoVO)this.converter.convert((Object)mobileDatasourceInfo, MobileDatasourceInfoVO.class);
            if (!mobileAppIdList.contains(mobileDatasourceInfo.getId())) {
                mobileCustomApplicationVO.setAuthFlag(Boolean.valueOf(false));
            }
            if (MapUtils.isNotEmpty(idNameMap)) {
                mobileCustomApplicationVO.setClassificationName(idNameMap.get(mobileDatasourceInfo.getClassificationId()));
            }
            String icon = mobileDatasourceInfo.getIcon();
            if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                icon = this.envProperties.getSemcWebUrl() + icon;
            }
            if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                icon = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + icon;
            }
            mobileCustomApplicationVO.setIcon(icon);
            result.add(mobileCustomApplicationVO);
        }
        return result;
    }

    public List<MobileDatasourceInfoVO> getCustomApplicationNew(List<String> customAppIds) {
        if (CollectionUtils.isNotEmpty(customAppIds)) {
            // empty if block
        }
        ArrayList<MobileDatasourceInfoVO> result = new ArrayList<MobileDatasourceInfoVO>();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : customAppIds) {
            Long aLong = Long.valueOf(id);
            idList.add(aLong);
        }
        List mobileDatasourceInfos = this.mobileCustomApplicationMapper.selectMobileList(idList);
        if (CollectionUtils.isEmpty((Collection)mobileDatasourceInfos)) {
            return result;
        }
        List classificationList = this.mobileApplicationClassificationMapper.queryApplicationClassificationList(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        Map<Long, String> idNameMap = classificationList.stream().collect(Collectors.toMap(MobileDatasourceClassification::getId, MobileDatasourceClassification::getClassificationName, (a, b) -> a));
        List mobileAppIdList = mobileDatasourceInfos.stream().filter(x -> !Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).map(MobileDatasourceInfo::getId).collect(Collectors.toList());
        List notAthenaAppList = mobileDatasourceInfos.stream().filter(x -> Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notAthenaAppList)) {
            List withPermissionList = this.mobileUserAuthService.validPermission(notAthenaAppList);
            mobileAppIdList.addAll(withPermissionList);
        }
        for (MobileDatasourceInfo mobileDatasourceInfo : mobileDatasourceInfos) {
            MobileDatasourceInfoVO mobileCustomApplicationVO = (MobileDatasourceInfoVO)this.converter.convert((Object)mobileDatasourceInfo, MobileDatasourceInfoVO.class);
            if (!mobileAppIdList.contains(mobileDatasourceInfo.getId())) {
                mobileCustomApplicationVO.setAuthFlag(Boolean.valueOf(false));
            }
            if (MapUtils.isNotEmpty(idNameMap)) {
                mobileCustomApplicationVO.setClassificationName(idNameMap.get(mobileDatasourceInfo.getClassificationId()));
            }
            String icon = mobileDatasourceInfo.getIcon();
            if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                icon = this.envProperties.getSemcWebUrl() + icon;
            }
            if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                icon = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + icon;
            }
            mobileCustomApplicationVO.setIcon(icon);
            result.add(mobileCustomApplicationVO);
        }
        return result;
    }

    private String appendJobField(AppLinkDTO appLinkDTO, String workCode) {
        String cloudwebsite = appLinkDTO.getCloudwebsite();
        List appJobDTOList = this.kmService.queryAppJobList();
        if (CollectionUtils.isEmpty((Collection)appJobDTOList)) {
            return cloudwebsite;
        }
        AppJobDTO appJobDTO = appJobDTOList.stream().filter(x -> appLinkDTO.getId().equals(x.getAppCode())).findFirst().orElse(null);
        if (appJobDTO == null) {
            return cloudwebsite;
        }
        AppJobDTO.Job job = appJobDTO.getData().stream().filter(x -> workCode.equals(x.getCode())).findFirst().orElse(null);
        if (job == null) {
            return cloudwebsite;
        }
        String jobType = this.getJobTypeMap(job.getType());
        cloudwebsite = cloudwebsite + "&routerLink=/" + jobType + "&code=" + job.getCode() + "&name=" + job.getName() + "&type=" + job.getType() + "&category=" + job.getCategory() + "&ifCustom=" + job.getIfCustom();
        return cloudwebsite;
    }

    public String getJobTypeMap(String type) {
        HashMap<String, String> jobTypeMap = new HashMap<String, String>();
        jobTypeMap.put("baseDataEntry".toLowerCase(), "base-data-entry");
        jobTypeMap.put("statement".toLowerCase(), "report");
        jobTypeMap.put("manualStartProject".toLowerCase(), "add-task");
        return (String)jobTypeMap.get(type.toLowerCase());
    }

    public String packageJobUrl(String jobUrl) {
        if (StringUtils.isEmpty((CharSequence)jobUrl)) {
            return "?";
        }
        if (jobUrl.contains("?")) {
            return jobUrl;
        }
        return "?" + jobUrl;
    }

    @Transactional
    public void setColumnOrder(List<Long> columIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).in(MobileApplicatonColumn::getId, columIds);
        List columns = this.applicatonColumnMapper.selectList((Wrapper)queryWrapper);
        Map idMap = columns.stream().collect(Collectors.toMap(MobileApplicatonColumn::getId, Function.identity()));
        Integer counnt = 0;
        for (Long columId : columIds) {
            MobileApplicatonColumn mobileApplicatonColumn = (MobileApplicatonColumn)idMap.get(columId);
            mobileApplicatonColumn.setOrderId(counnt);
            this.applicatonColumnMapper.updateById((Object)mobileApplicatonColumn);
            Integer n = counnt;
            Integer n2 = counnt = Integer.valueOf(counnt + 1);
        }
    }

    @Transactional
    public void setColumnOrderNew(List<Long> columIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).in(MobileApplicatonColumnNew::getId, columIds);
        List columns = this.mobileApplicatonColumnNewMapper.selectList((Wrapper)queryWrapper);
        Map idMap = columns.stream().collect(Collectors.toMap(MobileApplicatonColumnNew::getId, Function.identity()));
        Integer counnt = 0;
        for (Long columId : columIds) {
            MobileApplicatonColumnNew mobileApplicatonColumn = (MobileApplicatonColumnNew)idMap.get(columId);
            mobileApplicatonColumn.setOrderId(counnt);
            this.mobileApplicatonColumnNewMapper.updateById((Object)mobileApplicatonColumn);
            Integer n = counnt;
            Integer n2 = counnt = Integer.valueOf(counnt + 1);
        }
    }

    @Transactional
    public void delColumn(List<Long> columnIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(MobileApplicatonColumn::getParentId, columnIds);
        this.applicatonColumnMapper.delete((Wrapper)queryWrapper);
        this.applicatonColumnMapper.deleteBatchIds(columnIds);
    }

    @Transactional
    public void delColumnNew(List<Long> columnIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(MobileApplicatonColumnNew::getParentId, columnIds);
        this.mobileApplicatonColumnNewMapper.delete((Wrapper)queryWrapper);
        this.mobileApplicatonColumnNewMapper.deleteBatchIds(columnIds);
    }

    public FullBackResp getFullCallBackUrl(MobileSSOReq mobileSSOReq) {
        Integer customApplicationId = Integer.valueOf(mobileSSOReq.getCustomApplicationId());
        LambdaQueryWrapper mobileDatasourceInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        mobileDatasourceInfoLambdaQueryWrapper.eq(MobileDatasourceInfo::getId, (Object)customApplicationId);
        MobileDatasourceInfo mobileDatasourceInfo = (MobileDatasourceInfo)this.mobileCustomApplicationMapper.selectOne((Wrapper)mobileDatasourceInfoLambdaQueryWrapper);
        FullBackResp mobileFullBack = this.getMobileFullBack(mobileDatasourceInfo);
        if (ObjectUtils.isEmpty((Object)mobileFullBack)) {
            return null;
        }
        return mobileFullBack;
    }

    public FullBackResp getMobileFullBack(MobileDatasourceInfo mobileDatasourceInfo) {
        List withPermissionList;
        FullBackResp fullBackResp = new FullBackResp();
        String mobileLinkUrl = "";
        boolean isNeedCode = false;
        if (mobileDatasourceInfo.getType().equals(Constants.MobileDataSourceTye.MOBILE_THIRD_APPLICATION.getValue())) {
            List mobileSsoInfoList = this.mobileSsoInfoService.queryMobileLinkSsoList(Long.valueOf(mobileDatasourceInfo.getApplicationPrimaryId()));
            if (CollectionUtils.isEmpty((Collection)mobileSsoInfoList)) {
                return fullBackResp;
            }
            MobileSsoInfo mobileSsoInfo = (MobileSsoInfo)mobileSsoInfoList.get(0);
            String mobileJobUrl = "";
            if (Constants.IsNeedJobEnum.NEED_CUSTOM_JOB.getValue().equals(mobileDatasourceInfo.getIsJob())) {
                mobileJobUrl = mobileDatasourceInfo.getCallBackUrl();
            } else if (StringUtils.isNotEmpty((CharSequence)mobileDatasourceInfo.getWorkCode())) {
                mobileJobUrl = this.getMobileJobUrl(mobileSsoInfo.getAppId(), mobileDatasourceInfo.getWorkCode());
            }
            mobileLinkUrl = mobileSsoInfo.getMobileLinkUrl();
            if (Constants.IsNeedJobEnum.NEED_CUSTOM_JOB.getValue().equals(mobileDatasourceInfo.getIsJob()) || StringUtils.isNotEmpty((CharSequence)mobileDatasourceInfo.getWorkCode())) {
                String[] linkParamArray = mobileSsoInfo.getMobileLinkUrl().split("\\?");
                mobileLinkUrl = linkParamArray[0] + this.packageJobUrl(mobileJobUrl) + "&" + linkParamArray[1];
            }
            fullBackResp.setAppId(mobileSsoInfo.getAppId());
            fullBackResp.setRegisterUrl(mobileSsoInfo.getCallBackUrl());
            isNeedCode = true;
        }
        if (mobileDatasourceInfo.getType().equals(Constants.MobileDataSourceTye.DIGIWIN_ATHENA_APPLICATION.getValue())) {
            List tenantAppList = this.iamService.queryTenantApps();
            String applicationPrimaryId = mobileDatasourceInfo.getApplicationPrimaryId();
            List list = tenantAppList.stream().filter(item -> applicationPrimaryId.equals(item.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                return fullBackResp;
            }
            TenantAppDTO tenantAppDTO = (TenantAppDTO)list.get(0);
            String callBackUrl = tenantAppDTO.getCloudwebsite() + "/sso-login?userToken=" + AppAuthContextHolder.getContext().getAuthoredUser().getToken();
            AppLinkDTO appLinkDTO = new AppLinkDTO();
            appLinkDTO.setId(tenantAppDTO.getId());
            appLinkDTO.setCloudwebsite(callBackUrl);
            mobileLinkUrl = this.appendJobField(appLinkDTO, mobileDatasourceInfo.getWorkCode());
        }
        if (mobileDatasourceInfo.getType().equals(Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue()) && CollectionUtils.isNotEmpty((Collection)(withPermissionList = this.mobileUserAuthService.validPermission(Collections.singletonList(mobileDatasourceInfo))))) {
            mobileLinkUrl = this.packageMobileCloudWebsite(mobileDatasourceInfo);
            fullBackResp.setIsHavePerm(Boolean.valueOf(true));
        }
        fullBackResp.setMobileCloudWebsite(mobileLinkUrl);
        fullBackResp.setIsNeedCode(Boolean.valueOf(isNeedCode));
        return fullBackResp;
    }

    public String packageMobileCloudWebsite(MobileDatasourceInfo mobileDatasourceInfo) {
        String mobileCloudWebsite = "";
        if (null == mobileDatasourceInfo.getSpecialSign()) {
            mobileCloudWebsite = this.packageMobileOtherUrl(mobileDatasourceInfo.getApplicationConfig());
            return mobileCloudWebsite;
        }
        if (mobileDatasourceInfo.getSpecialSign().equals(Constants.SpecialSignEnum.TOPIC_PRESET.getFlag())) {
            mobileCloudWebsite = this.topicPresetService.getTopicPresetUrl(mobileDatasourceInfo.getApplicationConfig());
        }
        if (mobileDatasourceInfo.getSpecialSign().equals(Constants.SpecialSignEnum.MAYCUR.getFlag())) {
            String userId = this.eocService.getEmpJobNum();
            if (StringUtils.isEmpty((CharSequence)userId)) {
                return mobileDatasourceInfo.getApplicationConfig();
            }
            long timestamp = System.currentTimeMillis();
            String ssoToken = this.mayCurService.getSsoToken(userId, this.envProperties.getMayCurSecret(), timestamp);
            mobileCloudWebsite = this.mayCurService.getHomeSsoUrl(mobileDatasourceInfo.getApplicationConfig(), this.envProperties.getMayCurEntCode(), userId, ssoToken, timestamp);
        }
        return mobileCloudWebsite;
    }

    public String packageMobileOtherUrl(String url) {
        String locale = LocaleContextHolder.getLocale().toString();
        if (url.contains(TWAppUrlVariableEnum.IAM_USER_ID.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.IAM_USER_ID.getVariableName(), Utils.getUserId());
        }
        if (url.contains(TWAppUrlVariableEnum.MOBILE_TOKEN.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.MOBILE_TOKEN.getVariableName(), Utils.getUserToken());
        }
        if (url.contains(TWAppUrlVariableEnum.COMPANY_ID.getVariableName())) {
            // empty if block
        }
        if (url.contains(TWAppUrlVariableEnum.LOCALE.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.LOCALE.getVariableName(), locale);
        }
        if (url.contains(TWAppUrlVariableEnum.PERSON_ID.getVariableName())) {
            // empty if block
        }
        if (url.contains(TWAppUrlVariableEnum.ACCESS_TOKEN.getVariableName())) {
            url = url.replace(TWAppUrlVariableEnum.ACCESS_TOKEN.getVariableName(), Utils.getUserToken());
        }
        return url;
    }

    private String getMobileJobUrl(String appId, String workCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SyncJobInfo::getAppId, (Object)appId)).eq(SyncJobInfo::getJobCode, (Object)workCode);
        List syncJobInfos = this.syncJobInfoMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)syncJobInfos)) {
            return ((SyncJobInfo)syncJobInfos.get(0)).getJobUrl();
        }
        return "";
    }

    public List<MobilePortalInfoContent> checkContentApp(List<Long> appIdList) {
        ArrayList<Integer> contentTypeList = new ArrayList<Integer>();
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.TITLE.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.PICTURE.getVal());
        contentTypeList.add(Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal());
        List mobilePortalInfoContents = this.mobilePortalInfoContentMapper.queryPortalContent(contentTypeList);
        for (MobilePortalInfoContent content : mobilePortalInfoContents) {
            MobilePortalBusinessInfoReqDTO businessCompInfo;
            MobilePortalTitleInfoReqDTO titleInfo;
            if (Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(content.getContentType()) && appIdList.contains(content.getCustomApplicationId())) {
                return mobilePortalInfoContents;
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                MobilePortalContentCarousel carouselInfo = (MobilePortalContentCarousel)JSON.parseObject((String)content.getContentAttr(), MobilePortalContentCarousel.class);
                if (null == carouselInfo || CollectionUtils.isEmpty((Collection)carouselInfo.getImageList())) continue;
                for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                    if (null == image.getJumpType() || !image.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue()) || !appIdList.contains(image.getCustomApplicationId())) continue;
                    return mobilePortalInfoContents;
                }
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType()) && null != (titleInfo = (MobilePortalTitleInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalTitleInfoReqDTO.class)) && null != titleInfo.getJumpType() && titleInfo.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue()) && appIdList.contains(titleInfo.getCustomApplicationId())) {
                return mobilePortalInfoContents;
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = (MobilePortalImageInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null == imageCompInfo || CollectionUtils.isEmpty((Collection)imageCompInfo.getHotZoneList())) continue;
                for (MobilePortalHotZoneReqDTO hotZone : imageCompInfo.getHotZoneList()) {
                    if (null == hotZone.getJumpType() || !hotZone.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue()) || !appIdList.contains(hotZone.getCustomApplicationId())) continue;
                    return mobilePortalInfoContents;
                }
            }
            if (!Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType()) || null == (businessCompInfo = (MobilePortalBusinessInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalBusinessInfoReqDTO.class)) || CollectionUtils.isEmpty((Collection)businessCompInfo.getImageList())) continue;
            for (MobilePortalContentCarouselImage image : businessCompInfo.getImageList()) {
                if (null == image.getJumpType() || !image.getJumpType().equals(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue()) || !appIdList.contains(image.getCustomApplicationId())) continue;
                return mobilePortalInfoContents;
            }
        }
        return null;
    }
}

