/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.mobile.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.entity.mobile.MobileStartSet;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.mobile.MobileStartSetMapper;
import com.digiwin.athena.semc.service.mobile.MobileStartSetService;
import com.digiwin.athena.semc.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MobileStartSetServiceImpl
extends ServiceImpl<MobileStartSetMapper, MobileStartSet>
implements MobileStartSetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileStartSetServiceImpl.class);
    @Autowired
    private MobileStartSetMapper mobileStartSetMapper;
    @Resource
    private EnvProperties envProperties;

    @Transactional
    public MobileStartSet saveStartSet(MobileStartSet startSet) {
        List startSetList = this.selectStartSetList(startSet.getDeviceType());
        if (CollectionUtils.isEmpty((Collection)startSetList)) {
            startSet.setTenantId(Utils.getTenantId());
            this.mobileStartSetMapper.insert((Object)startSet);
        } else {
            this.mobileStartSetMapper.updateById((Object)startSet);
        }
        if (StringUtils.isNotEmpty((CharSequence)startSet.getPicLocalId())) {
            startSet.setPicLocalUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + startSet.getPicLocalId());
        }
        return startSet;
    }

    public List<MobileStartSet> selectStartSetList(Integer deviceType) {
        List<MobileStartSet> startSetList = new ArrayList();
        QueryWrapper condition = new QueryWrapper();
        if (null != deviceType) {
            condition.eq((Object)"device_type", (Object)deviceType);
        }
        startSetList = this.mobileStartSetMapper.selectList((Wrapper)condition);
        for (MobileStartSet startSet : startSetList) {
            if (StringUtils.isNotEmpty((CharSequence)startSet.getPicLocalId())) {
                startSet.setPicLocalUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + startSet.getPicLocalId());
            }
            if (StringUtils.isNotEmpty((CharSequence)startSet.getPicUrl())) {
                startSet.setPicUrl(this.envProperties.getSemcWebUrl() + startSet.getPicUrl());
            }
            if (!StringUtils.isNotEmpty((CharSequence)startSet.getPicUrlTw())) continue;
            startSet.setPicUrlTw(this.envProperties.getSemcWebUrl() + startSet.getPicUrlTw());
        }
        return startSetList;
    }
}

