/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.mobile.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationModulesSimpleDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationSimpleDTO;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MobileUserAuthServiceImpl
implements MobileUserAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MobileUserAuthServiceImpl.class);
    @Resource
    private MobileDatasourceInfoMapper mobileCustomApplicationMapper;
    @Resource
    private IamService iamService;
    @Resource(name="semcAsyncExecutor")
    private Executor asyncTaskExecutor;

    public List<Long> validUserAppAuth(List<Long> customApplicationIdList) {
        if (CollectionUtils.isEmpty(customApplicationIdList)) {
            return Lists.newArrayList();
        }
        List mobileDatasourceInfoList = this.mobileCustomApplicationMapper.selectBatchIds(customApplicationIdList);
        if (CollectionUtils.isEmpty((Collection)mobileDatasourceInfoList)) {
            return Lists.newArrayList();
        }
        List<Long> mobileAppIdList = mobileDatasourceInfoList.stream().filter(x -> !Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).map(MobileDatasourceInfo::getId).collect(Collectors.toList());
        List notAthenaAppList = mobileDatasourceInfoList.stream().filter(x -> Constants.MobileDataSourceTye.DIGIWIN_NOT_ATHENA_APPLICATION.getValue().equals(x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notAthenaAppList)) {
            List withPermissionList = this.validPermission(notAthenaAppList);
            mobileAppIdList.addAll(withPermissionList);
        }
        return mobileAppIdList;
    }

    public UserAuthSystemLabelVo buildSystemIdApp(List<LabelSystemData> systemDataList) {
        UserAuthSystemLabelVo authSystemLabelVo = new UserAuthSystemLabelVo();
        List<Object> noPermSystemIdList = Lists.newArrayList();
        List<Object> permSystemIdList = Lists.newArrayList();
        authSystemLabelVo.setNoPermSystemIdList((List)noPermSystemIdList);
        authSystemLabelVo.setPermSystemIdList((List)permSystemIdList);
        if (CollectionUtils.isEmpty(systemDataList)) {
            return authSystemLabelVo;
        }
        List systemDataAppList = systemDataList.stream().filter(x -> ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(x.getDataType()) && VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(x.getAppCode()) && Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(x.getDataCategory())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(systemDataAppList)) {
            return authSystemLabelVo;
        }
        List dataSourceIdList = systemDataAppList.stream().map(LabelSystemData::getWorkCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataSourceIdList)) {
            return authSystemLabelVo;
        }
        List customApplicationIdList = dataSourceIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        List applicationIdList = this.validUserAppAuth(customApplicationIdList);
        if (CollectionUtils.isEmpty((Collection)applicationIdList)) {
            noPermSystemIdList = systemDataAppList.stream().map(LabelSystemData::getSystemId).collect(Collectors.toList());
            authSystemLabelVo.setNoPermSystemIdList((List)noPermSystemIdList);
            return authSystemLabelVo;
        }
        noPermSystemIdList = systemDataAppList.stream().filter(x -> !applicationIdList.contains(Long.parseLong(x.getWorkCode()))).map(LabelSystemData::getSystemId).collect(Collectors.toList());
        authSystemLabelVo.setNoPermSystemIdList((List)noPermSystemIdList);
        permSystemIdList = systemDataAppList.stream().filter(x -> applicationIdList.contains(Long.parseLong(x.getWorkCode()))).map(LabelSystemData::getSystemId).collect(Collectors.toList());
        authSystemLabelVo.setPermSystemIdList((List)permSystemIdList);
        return authSystemLabelVo;
    }

    public List<Long> validPermission(List<MobileDatasourceInfo> mobileAppList) {
        ArrayList withPermissionList = Lists.newArrayList();
        ArrayList hasWorkList = Lists.newArrayList();
        List userApplicationList = this.iamService.queryUserApplicationSimple(true, true, true);
        for (MobileDatasourceInfo mobileDatasourceInfo : mobileAppList) {
            List enabledModuleList;
            Map userApplicationModulesMap;
            Map userApplicationMap;
            UserApplicationSimpleDTO userApplication;
            if (ObjectUtils.isNotEmpty((Object)mobileDatasourceInfo.getSpecialSign()) && mobileDatasourceInfo.getSpecialSign().equals(Constants.SpecialSignEnum.MAYCUR.getFlag())) {
                withPermissionList.add(mobileDatasourceInfo.getId());
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)mobileDatasourceInfo.getIamApplicationId()) || StringUtils.isEmpty((CharSequence)mobileDatasourceInfo.getIamModuleId()) || CollectionUtils.isEmpty((Collection)userApplicationList) || ObjectUtils.isEmpty((Object)(userApplication = (UserApplicationSimpleDTO)(userApplicationMap = userApplicationList.stream().collect(Collectors.toMap(UserApplicationSimpleDTO::getId, Function.identity()))).get(mobileDatasourceInfo.getIamApplicationId()))) || !(userApplicationModulesMap = (enabledModuleList = userApplication.getEnabledModules()).stream().collect(Collectors.toMap(UserApplicationModulesSimpleDTO::getId, Function.identity(), (a, b) -> a))).containsKey(mobileDatasourceInfo.getIamModuleId())) continue;
            if (StringUtils.isNotEmpty((CharSequence)mobileDatasourceInfo.getIamWorkId())) {
                hasWorkList.add(mobileDatasourceInfo);
                continue;
            }
            withPermissionList.add(mobileDatasourceInfo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)hasWorkList)) {
            List<String> applicationIdList = hasWorkList.stream().map(MobileDatasourceInfo::getIamApplicationId).distinct().collect(Collectors.toList());
            HashMap applicationIdFutureMap = Maps.newHashMap((Map)Maps.newHashMapWithExpectedSize((int)applicationIdList.size()));
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            applicationIdList.forEach(x -> {
                CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
                    String target = "drn:iam:app:" + x;
                    return this.iamService.queryUserFunctional(target, authoredUser);
                }, this.asyncTaskExecutor);
                applicationIdFutureMap.put(x, future);
            });
            Collection values = applicationIdFutureMap.values();
            CompletableFuture.allOf(values.toArray(new CompletableFuture[values.size()]));
            HashMap applicationIdMap = Maps.newHashMap();
            applicationIdFutureMap.forEach((k, v) -> {
                try {
                    List permissionUserFunctionalList = (List)v.get();
                    if (CollectionUtils.isNotEmpty((Collection)permissionUserFunctionalList)) {
                        applicationIdMap.put(k, permissionUserFunctionalList);
                    }
                }
                catch (Exception e) {
                    log.error("deal query user functional result occur error", (Throwable)e);
                }
            });
            for (MobileDatasourceInfo mobileDatasourceInfo : hasWorkList) {
                String iamWorkIdTarget;
                Map userFunctionalMap;
                List permissionUserFunctionalList = (List)applicationIdMap.get(mobileDatasourceInfo.getIamApplicationId());
                if (CollectionUtils.isEmpty((Collection)permissionUserFunctionalList) || ObjectUtils.isEmpty((userFunctionalMap = permissionUserFunctionalList.stream().collect(Collectors.toMap(PermissionUserFunctionalDTO::getTarget, Function.identity(), (a, b) -> a))).get(iamWorkIdTarget = "drn:iam:app:" + mobileDatasourceInfo.getIamApplicationId() + ":" + mobileDatasourceInfo.getIamModuleId() + ":" + mobileDatasourceInfo.getIamWorkId()))) continue;
                withPermissionList.add(mobileDatasourceInfo.getId());
            }
        }
        return withPermissionList;
    }
}

