/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.module.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.module.TenantModuleDto;
import com.digiwin.athena.semc.entity.module.ModuleInfo;
import com.digiwin.athena.semc.mapper.module.ModuleInfoMapper;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.service.module.IModuleInfoService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.module.ModuleOrderVo;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModuleInfoServiceImpl
extends ServiceImpl<ModuleInfoMapper, ModuleInfo>
implements IModuleInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModuleInfoServiceImpl.class);
    @Autowired
    private KmService kmService;
    @Resource
    private Converter converter;
    private static final Map<String, String> patternMap = new HashMap();

    public List<ModuleOrderVo> queryModuleOrder(String moduleCode) {
        List kmModuleDtos = this.kmService.queryTenantModuleList((String)patternMap.get(moduleCode));
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List moduleInfos = ((ModuleInfoMapper)this.baseMapper).queryByModuleCode(moduleCode, tenantId);
        return this.convertToModuleOrderVo(kmModuleDtos, moduleInfos);
    }

    public List<ModuleInfo> queryTenantModuleOrder(String moduleCode) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        return ((ModuleInfoMapper)this.baseMapper).queryByModuleCode(moduleCode, tenantId);
    }

    @Transactional
    public Integer saveModuleOrder(List<ModuleOrderVo> moduleOrderVoList, String moduleCode) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List moduleInfos = this.convertToModuleInfo(moduleOrderVoList, moduleCode, tenantId);
        ((ModuleInfoMapper)this.baseMapper).deleteByModuleCode(moduleCode, tenantId);
        return ((ModuleInfoMapper)this.baseMapper).batchInsert(moduleInfos);
    }

    public List<ModuleOrderVo> delModuleOrder(String moduleCode) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        ((ModuleInfoMapper)this.baseMapper).deleteByModuleCode(moduleCode, tenantId);
        return this.queryModuleOrder(moduleCode);
    }

    private List<ModuleOrderVo> convertToModuleOrderVo(List<TenantModuleDto> tenantModuleDtos, List<ModuleInfo> moduleInfos) {
        ArrayList<ModuleOrderVo> moduleOrderVos = new ArrayList<ModuleOrderVo>();
        if (CollectionUtils.isNotEmpty(tenantModuleDtos)) {
            Map<String, List<TenantModuleDto>> appCodeToModuleMap = tenantModuleDtos.stream().filter(e -> BooleanUtils.isNotTrue((Boolean)e.getSubReport())).collect(Collectors.groupingBy(TenantModuleDto::getAppCode));
            Map appCodeToCustomerModuleMap = null;
            LinkedHashMap sortedDataMap = Maps.newLinkedHashMap();
            if (CollectionUtils.isNotEmpty(moduleInfos)) {
                appCodeToCustomerModuleMap = moduleInfos.stream().sorted(Comparator.comparing(ModuleInfo::getAppSort)).collect(Collectors.groupingBy(ModuleInfo::getAppCode, LinkedHashMap::new, Collectors.toList()));
                for (Map.Entry entry : appCodeToCustomerModuleMap.entrySet()) {
                    List<TenantModuleDto> remove = appCodeToModuleMap.remove(entry.getKey());
                    if (remove == null) continue;
                    sortedDataMap.put(entry.getKey(), remove);
                }
                sortedDataMap.putAll(appCodeToModuleMap);
            } else {
                if (appCodeToModuleMap.containsKey("PBD")) {
                    List<TenantModuleDto> remove = appCodeToModuleMap.remove("PBD");
                    sortedDataMap.put("PBD", remove);
                }
                Iterator<Map.Entry<String, List<TenantModuleDto>>> iterator = appCodeToModuleMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, List<TenantModuleDto>> next = iterator.next();
                    List<TenantModuleDto> value = next.getValue();
                    Optional<TenantModuleDto> first = value.stream().filter(TenantModuleDto::isCommonApp).findFirst();
                    if (!first.isPresent()) continue;
                    sortedDataMap.put(next.getKey(), value);
                    iterator.remove();
                }
                sortedDataMap.putAll(appCodeToModuleMap);
            }
            for (Map.Entry entry : sortedDataMap.entrySet()) {
                HashMap groupSortMap;
                List customerModule;
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)value)) continue;
                ModuleOrderVo moduleOrderVo = new ModuleOrderVo((String)entry.getKey(), "APP_CODE", ((TenantModuleDto)value.get(0)).getAppName(), (List)Lists.newArrayList());
                moduleOrderVos.add(moduleOrderVo);
                List groupList = moduleOrderVo.getGroupList();
                Optional<TenantModuleDto> first = value.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getGroupCode())).findFirst();
                List list = customerModule = appCodeToCustomerModuleMap != null ? (List)appCodeToCustomerModuleMap.get(key) : null;
                if (first.isPresent()) {
                    this.handleItemModule(groupList, value, customerModule);
                    continue;
                }
                HashMap groupToItemModule = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)customerModule)) {
                    groupSortMap = Maps.newHashMap();
                    for (ModuleInfo moduleInfo : customerModule) {
                        if (!StringUtils.isNotBlank((CharSequence)moduleInfo.getGroupCode())) continue;
                        Integer groupNum = (Integer)groupSortMap.get(moduleInfo.getGroupCode());
                        if (groupNum == null || groupNum.compareTo(moduleInfo.getGroupSort()) > 0) {
                            groupSortMap.put(moduleInfo.getGroupCode(), moduleInfo.getGroupSort());
                        }
                        List moduleInfoList = groupToItemModule.computeIfAbsent(moduleInfo.getGroupCode(), k -> new ArrayList());
                        moduleInfoList.add(moduleInfo);
                    }
                } else {
                    groupSortMap = null;
                }
                LinkedHashMap groupCodeToModuleMap = Maps.newLinkedHashMap();
                value.stream().sorted(this.createGroupComparator((Map)groupSortMap)).forEach(e -> {
                    List tenantModuleList = groupCodeToModuleMap.computeIfAbsent(e.getGroupCode(), k -> new ArrayList());
                    tenantModuleList.add(e);
                });
                groupCodeToModuleMap.forEach((k, v) -> {
                    if (CollectionUtils.isNotEmpty((Collection)v)) {
                        ModuleOrderVo groupModule = new ModuleOrderVo(k, "GROUP_CODE", ((TenantModuleDto)v.get(0)).getGroupName(), new ArrayList());
                        groupList.add(groupModule);
                        this.handleItemModule(groupModule.getGroupList(), v, (List)groupToItemModule.get(k));
                    }
                });
            }
        }
        return moduleOrderVos;
    }

    private Comparator<TenantModuleDto> createItemComparator(Map<String, Integer> itemSortMap) {
        if (MapUtils.isNotEmpty(itemSortMap)) {
            return Comparator.comparingInt(module -> MapUtils.getInteger((Map)itemSortMap, (Object)module.getCode(), (Integer)Integer.MAX_VALUE));
        }
        return Comparator.comparingInt(module -> Utils.toInt((String)module.getSort(), (Integer)Integer.MAX_VALUE));
    }

    private Comparator<TenantModuleDto> createGroupComparator(Map<String, Integer> groupSortMap) {
        if (MapUtils.isNotEmpty(groupSortMap)) {
            return Comparator.comparingInt(module -> MapUtils.getInteger((Map)groupSortMap, (Object)module.getGroupCode(), (Integer)Integer.MAX_VALUE));
        }
        return Comparator.comparingInt(module -> Utils.toInt((String)module.getGroupSort(), (Integer)Integer.MAX_VALUE));
    }

    private void handleItemModule(List<ModuleOrderVo> groupList, List<TenantModuleDto> value, List<ModuleInfo> customerModule) {
        value.stream().sorted(this.createItemComparator(this.createItemSortMap(customerModule))).forEach(e -> groupList.add(new ModuleOrderVo(e.getCode(), "ITEM_CODE", e.getName(), null)));
    }

    private Map<String, Integer> createItemSortMap(List<ModuleInfo> customerModule) {
        HashMap itemSortMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(customerModule)) {
            for (ModuleInfo moduleInfo : customerModule) {
                Integer itemNum = (Integer)itemSortMap.get(moduleInfo.getCode());
                if (itemNum != null && itemNum.compareTo(moduleInfo.getItemSort()) <= 0) continue;
                itemSortMap.put(moduleInfo.getCode(), moduleInfo.getItemSort());
            }
        }
        return itemSortMap;
    }

    private List<ModuleInfo> convertToModuleInfo(List<ModuleOrderVo> moduleOrderVos, String moduleCode, String tenantId) {
        ArrayList<ModuleInfo> moduleInfoList = new ArrayList<ModuleInfo>();
        int appSort = 0;
        for (ModuleOrderVo moduleOrderVo : moduleOrderVos) {
            ModuleInfo moduleInfo = new ModuleInfo();
            moduleInfo.setAppCode(moduleOrderVo.getCode());
            moduleInfo.setAppSort(Integer.valueOf(++appSort));
            moduleInfo.setModuleCode(moduleCode);
            moduleInfo.setTenantId(tenantId);
            List groupList = moduleOrderVo.getGroupList();
            if (CollectionUtils.isEmpty((Collection)groupList)) continue;
            ModuleOrderVo first = (ModuleOrderVo)groupList.get(0);
            String codeType = first.getCodeType();
            if ("GROUP_CODE".equals(codeType)) {
                int groupSort = 0;
                for (ModuleOrderVo groupVo : groupList) {
                    moduleInfo.setGroupCode(groupVo.getCode());
                    moduleInfo.setGroupSort(Integer.valueOf(++groupSort));
                    this.handleSaveItemModule(moduleInfo, moduleInfoList, groupVo.getGroupList());
                }
                continue;
            }
            this.handleSaveItemModule(moduleInfo, moduleInfoList, groupList);
        }
        return moduleInfoList;
    }

    private void handleSaveItemModule(ModuleInfo moduleInfo, List<ModuleInfo> moduleInfoList, List<ModuleOrderVo> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        int index = 0;
        for (ModuleOrderVo moduleOrderVo : itemList) {
            ModuleInfo item = new ModuleInfo();
            BeanUtils.copyProperties((Object)moduleInfo, (Object)item);
            item.setItemSort(Integer.valueOf(++index));
            item.setCode(moduleOrderVo.getCode());
            moduleInfoList.add(item);
        }
    }

    static {
        patternMap.put("DATA_ENTRY", "DATA_ENTRY");
        patternMap.put("STATEMENT", "STATEMENT");
    }
}

