/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.dto.news.SaveNewsAuthReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.event.NewsAuthBizIdSetEvent;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementAuthMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptDTO;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.news.NewsAnnouncementAuthService;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsAnnouncementAuthServiceImpl
extends ServiceImpl<NewsAnnouncementAuthMapper, NewsAnnouncementAut>
implements NewsAnnouncementAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsAnnouncementAuthServiceImpl.class);
    @Resource
    private NewsAnnouncementAuthMapper newsAnnouncementAuthMapper;
    @Resource
    private IamService iamService;
    @Resource
    private EocService eocService;
    @Resource
    private IamUserService iamUserService;

    @Transactional
    public void saveNewsAuth(SaveNewsAuthReq saveNewsAuthReq) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"news_id", (Object)saveNewsAuthReq.getNewsId());
        this.newsAnnouncementAuthMapper.delete((Wrapper)condition);
        if (Constants.NEWS_ALL_AUTH_FLAG_YES.equals(saveNewsAuthReq.getAllAuthFlag())) {
            NewsAnnouncementAut newsAnnouncementAuth = new NewsAnnouncementAut();
            newsAnnouncementAuth.setNewsId(saveNewsAuthReq.getNewsId());
            newsAnnouncementAuth.setAllAuthFlag(Constants.NEWS_ALL_AUTH_FLAG_YES);
            this.save((Object)newsAnnouncementAuth);
        } else {
            NewsAnnouncementAut newsAnnouncementAuth = new NewsAnnouncementAut();
            newsAnnouncementAuth.setNewsId(saveNewsAuthReq.getNewsId());
            newsAnnouncementAuth.setAuthId(saveNewsAuthReq.getAuthId());
            newsAnnouncementAuth.setAuthName(saveNewsAuthReq.getAuthName());
            newsAnnouncementAuth.setAuthType(saveNewsAuthReq.getAuthType());
            this.save((Object)newsAnnouncementAuth);
        }
    }

    public List<NewsAnnouncementAut> queryAuthNewsList() {
        return this.queryAuthNewsListByNewsTypeIdList(null);
    }

    public List<NewsAnnouncementAut> queryAuthNewsListByNewsTypeIdList(List<Long> newsTypeIdList) {
        LambdaQueryWrapper queryWrapper;
        Long userSid;
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(userId, tenantId, userToken);
        ArrayList authIds = Lists.newArrayList();
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getOrgSids())) {
            authIds.addAll(iamUserAuthInfo.getOrgSids());
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getRoleSids())) {
            authIds.addAll(iamUserAuthInfo.getRoleSids());
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getDeptSids())) {
            authIds.addAll(iamUserAuthInfo.getDeptSids());
        }
        if (Objects.nonNull(userSid = Long.valueOf(AppAuthContextHolder.getContext().getAuthoredUser().getSid()))) {
            authIds.add(userSid);
        }
        ArrayList authList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)authIds)) {
            Collections.sort(authIds);
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(NewsAnnouncementAut::getAuthId, (Collection)authIds);
            queryWrapper.in(CollectionUtils.isNotEmpty(newsTypeIdList), NewsAnnouncementAut::getNewsTypeId, newsTypeIdList);
            queryWrapper.select(new SFunction[]{NewsAnnouncementAut::getNewsId});
            authList.addAll(this.newsAnnouncementAuthMapper.selectList((Wrapper)queryWrapper));
        }
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementAut::getAllAuthFlag, (Object)Constants.NEWS_ALL_AUTH_FLAG_YES);
        queryWrapper.in(CollectionUtils.isNotEmpty(newsTypeIdList), NewsAnnouncementAut::getNewsTypeId, newsTypeIdList);
        queryWrapper.select(new SFunction[]{NewsAnnouncementAut::getNewsId});
        List allAuthList = this.newsAnnouncementAuthMapper.selectList((Wrapper)queryWrapper);
        authList.addAll(allAuthList);
        return authList;
    }

    public void setNewsAuthBizId(NewsAuthBizIdSetEvent event) {
        List userAuthList;
        List<NewsAnnouncementAut> deptAuthList;
        List<NewsAnnouncementAut> roleAuthList;
        List announcementAutList = event.getAnnouncementAutList();
        if (CollectionUtils.isNotEmpty((Collection)announcementAutList)) {
            this.updateExternalUserId(announcementAutList);
            return;
        }
        String tenantId = Utils.getTenantId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementAut::getAllAuthFlag, (Object)Constants.NEWS_ALL_AUTH_FLAG_NO);
        List newsAnnouncementAutList = this.newsAnnouncementAuthMapper.selectList((Wrapper)queryWrapper);
        List<NewsAnnouncementAut> orgAuthList = newsAnnouncementAutList.stream().filter(x -> BizAuthTypeEnum.ORG.getValue().equals(x.getAuthType()) && StringUtils.isBlank((CharSequence)x.getAuthBizId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgAuthList)) {
            HashMap orgSidMap = Maps.newHashMap();
            com.alibaba.fastjson.JSONArray companyFactory = this.iamService.getCompanyFactory();
            for (Object o : companyFactory) {
                this.parseAuthIdMap(o, (Map)orgSidMap);
            }
            orgAuthList.forEach(x -> {
                x.setAuthBizId((String)orgSidMap.get(x.getAuthId()));
                x.setCreateTenantId(tenantId);
            });
            this.saveOrUpdateBatch(orgAuthList);
        }
        if (CollectionUtils.isNotEmpty(roleAuthList = newsAnnouncementAutList.stream().filter(x -> BizAuthTypeEnum.ROLE.getValue().equals(x.getAuthType()) && StringUtils.isBlank((CharSequence)x.getAuthBizId())).collect(Collectors.toList()))) {
            List roleList = this.iamService.queryAllRoleList();
            Map<Long, String> roleSidMap = roleList.stream().collect(Collectors.toMap(RoleDTO::getSid, RoleDTO::getId, (a, b) -> a));
            roleAuthList.forEach(x -> {
                x.setAuthBizId((String)roleSidMap.get(x.getAuthId()));
                x.setCreateTenantId(tenantId);
            });
            this.saveOrUpdateBatch(roleAuthList);
        }
        if (CollectionUtils.isNotEmpty(deptAuthList = newsAnnouncementAutList.stream().filter(x -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(x.getAuthType()) && StringUtils.isBlank((CharSequence)x.getAuthBizId())).collect(Collectors.toList()))) {
            List deptList = this.eocService.queryTenantDeptList();
            Map<Long, String> deptSidMap = deptList.stream().collect(Collectors.toMap(UserDeptDTO::getSid, UserDeptDTO::getId, (a, b) -> a));
            deptAuthList.forEach(x -> {
                x.setAuthBizId((String)deptSidMap.get(x.getAuthId()));
                x.setCreateTenantId(tenantId);
            });
            this.saveOrUpdateBatch(deptAuthList);
        }
        if (CollectionUtils.isNotEmpty(userAuthList = newsAnnouncementAutList.stream().filter(x -> Arrays.asList(BizAuthTypeEnum.USER.getValue(), BizAuthTypeEnum.EXTERNAL_USER.getValue()).contains(x.getAuthType()) && StringUtils.isBlank((CharSequence)x.getAuthBizId())).collect(Collectors.toList()))) {
            this.updateExternalUserId(userAuthList);
        }
    }

    private void updateExternalUserId(List<NewsAnnouncementAut> userAuthList) {
        List allUserList = this.iamService.queryEnabledUserList();
        Map<Long, String> userSidMap = allUserList.stream().collect(Collectors.toMap(RoleDTO::getSid, RoleDTO::getId, (a, b) -> a));
        userAuthList.forEach(x -> {
            x.setAuthBizId((String)userSidMap.get(x.getAuthId()));
            x.setCreateTenantId(Utils.getTenantId());
        });
        InterceptorIgnoreUtil.handler(() -> this.saveOrUpdateBatch((Collection)userAuthList));
    }

    private void parseAuthIdMap(Object object, Map<Long, String> map) {
        JSONObject data = JSONObject.fromObject((Object)object);
        map.put(Long.valueOf(data.get("key").toString()), data.get("id").toString());
        if (!data.containsKey((Object)"children")) {
            return;
        }
        JSONArray children = data.getJSONArray("children");
        for (Object o : children) {
            this.parseAuthIdMap(o, map);
        }
    }
}

