/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;
import com.digiwin.athena.semc.dto.news.MyNewsFavoritePageReq;
import com.digiwin.athena.semc.dto.news.NewsCommonIdListReq;
import com.digiwin.athena.semc.dto.news.NewsCommonIdReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementFavorite;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementFavoriteMapper;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import com.digiwin.athena.semc.mq.dto.NewsCancelFavoriteMessageDTO;
import com.digiwin.athena.semc.mq.dto.NewsFavoriteMessageDTO;
import com.digiwin.athena.semc.mq.sender.RabbitMessageSender;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.cache.LockClient;
import com.digiwin.athena.semc.service.news.NewsAnnouncementFavoriteService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementReadService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementService;
import com.digiwin.athena.semc.util.DmcFileUtil;
import com.digiwin.athena.semc.util.FormatUtil;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.vo.file.FileInfoVO;
import com.digiwin.athena.semc.vo.news.MyNewsAnnouncementFavoriteVO;
import com.digiwin.athena.semc.vo.news.ValidateNewsVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NewsAnnouncementFavoriteServiceImpl
extends ServiceImpl<NewsAnnouncementFavoriteMapper, NewsAnnouncementFavorite>
implements NewsAnnouncementFavoriteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsAnnouncementFavoriteServiceImpl.class);
    private final NewsAnnouncementService newsAnnouncementService;
    private final LockClient lockClient;
    private final IamService iamService;
    private final RabbitMessageSender rabbitMessageSender;
    private final EnvProperties envProperties;
    private final DmcFileUtil dmcFileUtil;
    private final NewsAnnouncementReadService newsAnnouncementReadService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer favoriteNews(NewsCommonIdReq newsCommonIdReq) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String lockKey = FormatUtil.format((String)"newsFavorite:{}:{}:{}", (Object[])new Object[]{newsCommonIdReq.getId(), authoredUser.getTenantId(), authoredUser.getSid()});
        RLock rLock = null;
        try {
            String verifyUserId;
            boolean existNewsFavorite;
            rLock = this.lockClient.getLock(lockKey);
            boolean lockResult = rLock.tryLock(1L, 5L, TimeUnit.SECONDS);
            if (!lockResult) {
                log.info("\u672a\u83b7\u53d6\u5230\u9501");
                Integer n = 1;
                return n;
            }
            NewsAnnouncementFavorite currentNewsFavorite = this.getCurrentNewsFavorite(newsCommonIdReq.getId(), authoredUser);
            boolean bl = existNewsFavorite = currentNewsFavorite != null;
            if (existNewsFavorite) {
                log.info("\u5df2\u6536\u85cf");
                Integer n = 1;
                return n;
            }
            ValidateNewsVO validateNewsVO = this.newsAnnouncementService.validateNews(newsCommonIdReq.getId());
            if (!"1000".equals(validateNewsVO.getCode())) {
                log.warn("\u5f53\u524d\u516c\u544a\u4e0d\u5b58\u5728\uff1a{}\uff0c{}", (Object)newsCommonIdReq.getId(), (Object)validateNewsVO.getCode());
                Integer n = 2;
                return n;
            }
            NewsAnnouncement newsAnnouncement = validateNewsVO.getNewsAnnouncement();
            NewsAnnouncementFavorite newsAnnouncementFavorite = new NewsAnnouncementFavorite();
            newsAnnouncementFavorite.setNewsId(newsAnnouncement.getId());
            newsAnnouncementFavorite.setThirdNewsId(newsAnnouncement.getThirdNewsId());
            newsAnnouncementFavorite.setThirdAppId(newsAnnouncement.getThirdAppId());
            newsAnnouncementFavorite.setThirdAppCode(newsAnnouncement.getThirdAppCode());
            newsAnnouncementFavorite.setCreateUserId(authoredUser.getUserId());
            newsAnnouncementFavorite.setCreateUserSid(Long.valueOf(authoredUser.getSid()));
            newsAnnouncementFavorite.setCreateUserName(authoredUser.getUserName());
            newsAnnouncementFavorite.setThirdUserId("");
            if (ObjectUtils.isNotEmpty((Object)newsAnnouncement.getThirdNewsId()) && Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(newsAnnouncement.getNewsSource()) && StringUtils.isNotBlank((CharSequence)(verifyUserId = this.iamService.queryMappingEmpId(newsAnnouncement.getThirdAppCode())))) {
                newsAnnouncementFavorite.setThirdUserId(verifyUserId);
            }
            newsAnnouncementFavorite.setTenantId(authoredUser.getTenantId());
            newsAnnouncementFavorite.setCreateTime(new Date());
            newsAnnouncementFavorite.setModifyUserId(authoredUser.getUserId());
            newsAnnouncementFavorite.setModifyTime(new Date());
            boolean resultFlag = this.save((Object)newsAnnouncementFavorite);
            if (!resultFlag) {
                log.warn("\u6536\u85cf\u5931\u8d25");
                Integer n = 3;
                return n;
            }
            MQMessageDTO messageDTO = new MQMessageDTO();
            messageDTO.setMessageId(IdUtil.randomUUID());
            NewsFavoriteMessageDTO newsFavoriteMessageDTO = new NewsFavoriteMessageDTO();
            newsFavoriteMessageDTO.setNewsId(newsAnnouncement.getId());
            messageDTO.setMessage(JSON.toJSONString((Object)newsFavoriteMessageDTO));
            messageDTO.setMessageType(MQMessageTypeEnum.NEWS_FAVORITE.getCode());
            messageDTO.setRetryMaxCount(Integer.valueOf(3));
            this.rabbitMessageSender.sendWorkCommonMsg(messageDTO);
            Integer n = 0;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("\u6536\u85cf\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            Integer n = 3;
            return n;
        }
        finally {
            this.lockClient.unlock(rLock);
        }
    }

    private NewsAnnouncementFavorite getCurrentNewsFavorite(Long newsId, AuthoredUser authoredUser) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementFavorite::getNewsId, (Object)newsId);
        queryWrapper.eq(NewsAnnouncementFavorite::getCreateUserSid, (Object)authoredUser.getSid());
        return (NewsAnnouncementFavorite)this.getOne((Wrapper)queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer cancelFavoriteNews(NewsCommonIdListReq newsCommonIdListReq) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String idsMd5 = ((Long)newsCommonIdListReq.getIdList().get(0)).toString();
        if (newsCommonIdListReq.getIdList().size() > 1) {
            Collections.sort(newsCommonIdListReq.getIdList());
            idsMd5 = DigestUtil.md5Hex((String)StringUtils.join((Iterable)newsCommonIdListReq.getIdList(), (String)","));
        }
        String lockKey = FormatUtil.format((String)"cancelFavoriteNews:{}:{}:{}", (Object[])new Object[]{idsMd5, authoredUser.getTenantId(), authoredUser.getSid()});
        RLock rLock = null;
        try {
            rLock = this.lockClient.getLock(lockKey);
            boolean lockResult = rLock.tryLock(1L, 5L, TimeUnit.SECONDS);
            if (!lockResult) {
                log.info("\u672a\u83b7\u53d6\u5230\u9501");
                Integer n = 1;
                return n;
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(NewsAnnouncementFavorite::getNewsId, (Collection)newsCommonIdListReq.getIdList());
            queryWrapper.eq(NewsAnnouncementFavorite::getCreateUserSid, (Object)authoredUser.getSid());
            boolean removeFlag = this.remove((Wrapper)queryWrapper);
            if (!removeFlag) {
                log.info("\u5220\u9664\u6536\u85cf\u8bb0\u5f55\u5931\u8d25");
                Integer n = 1;
                return n;
            }
            MQMessageDTO messageDTO = new MQMessageDTO();
            messageDTO.setMessageId(IdUtil.randomUUID());
            NewsCancelFavoriteMessageDTO newsCancelFavoriteMessageDTO = new NewsCancelFavoriteMessageDTO();
            newsCancelFavoriteMessageDTO.setNewsIdList(newsCommonIdListReq.getIdList());
            messageDTO.setMessage(JSON.toJSONString((Object)newsCancelFavoriteMessageDTO));
            messageDTO.setMessageType(MQMessageTypeEnum.NEWS_CANCEL_FAVORITE.getCode());
            messageDTO.setRetryMaxCount(Integer.valueOf(3));
            this.rabbitMessageSender.sendWorkCommonMsg(messageDTO);
            Integer n = 0;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("\u53d6\u6d88\u6536\u85cf\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            Integer n = 2;
            return n;
        }
        finally {
            this.lockClient.unlock(rLock);
        }
    }

    public PageInfoResp<MyNewsAnnouncementFavoriteVO> myFavoriteNewsList(MyNewsFavoritePageReq myNewsFavoritePageReq) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementFavorite::getCreateUserSid, (Object)authoredUser.getSid());
        queryWrapper.orderByDesc(NewsAnnouncementFavorite::getId);
        queryWrapper.select(new SFunction[]{NewsAnnouncementFavorite::getId, NewsAnnouncementFavorite::getNewsId, NewsAnnouncementFavorite::getCreateTime});
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setPageSize(myNewsFavoritePageReq.getPageSize().intValue());
        pageInfoResp.setPageNo(myNewsFavoritePageReq.getPageNum().intValue());
        Page page = (Page)this.page((IPage)new Page((long)myNewsFavoritePageReq.getPageNum().intValue(), (long)myNewsFavoritePageReq.getPageSize().intValue()), (Wrapper)queryWrapper);
        if (page == null || ObjectUtils.isEmpty((Object)page.getRecords())) {
            return pageInfoResp;
        }
        List newsFavoriteList = page.getRecords();
        ArrayList coverImageIdList = Lists.newArrayList();
        ArrayList resultList = Lists.newArrayList();
        ArrayList zeroNewsIdReadList = Lists.newArrayList();
        Map validateNewsMap = this.newsAnnouncementService.validateNews(newsFavoriteList.stream().map(NewsAnnouncementFavorite::getNewsId).collect(Collectors.toList()));
        for (NewsAnnouncementFavorite newsFavorite : newsFavoriteList) {
            ValidateNewsVO validateNewsVO = (ValidateNewsVO)validateNewsMap.get(newsFavorite.getNewsId());
            MyNewsAnnouncementFavoriteVO myNewsAnnouncementFavoriteVO = new MyNewsAnnouncementFavoriteVO();
            myNewsAnnouncementFavoriteVO.setId(newsFavorite.getId());
            myNewsAnnouncementFavoriteVO.setFavoriteTime(DateUtil.formatDateTime((Date)newsFavorite.getCreateTime()));
            myNewsAnnouncementFavoriteVO.setNewsStatusCode(validateNewsVO.getCode());
            myNewsAnnouncementFavoriteVO.setNewsId(newsFavorite.getNewsId());
            NewsAnnouncement newsAnnouncement = validateNewsVO.getNewsAnnouncement();
            if (newsAnnouncement != null) {
                myNewsAnnouncementFavoriteVO.setNewsTitle(newsAnnouncement.getNewsTitle());
                myNewsAnnouncementFavoriteVO.setSummary(newsAnnouncement.getSummary());
                myNewsAnnouncementFavoriteVO.setNewsEffectiveTime(newsAnnouncement.getNewsEffectiveTime());
                myNewsAnnouncementFavoriteVO.setLikeCount(newsAnnouncement.getLikeCount());
                myNewsAnnouncementFavoriteVO.setReadCount(newsAnnouncement.getReadCount());
                if (newsAnnouncement.getReadCount() == null || newsAnnouncement.getReadCount() == 0) {
                    zeroNewsIdReadList.add(newsFavorite.getNewsId());
                }
                if (StringUtils.isNotBlank((CharSequence)newsAnnouncement.getDefaultImageIcon())) {
                    myNewsAnnouncementFavoriteVO.setDefaultImageIcon(this.envProperties.getSemcWebUrl() + newsAnnouncement.getDefaultImageIcon());
                }
                coverImageIdList.add(newsAnnouncement.getCoverImageId());
                myNewsAnnouncementFavoriteVO.setCoverImageId(newsAnnouncement.getCoverImageId());
            }
            resultList.add(myNewsAnnouncementFavoriteVO);
        }
        Map coverImageFileIdMap = this.dmcFileUtil.queryFileInfoList((List)coverImageIdList);
        Map readCountMap = this.newsAnnouncementReadService.queryReadCount((List)zeroNewsIdReadList);
        for (MyNewsAnnouncementFavoriteVO x : resultList) {
            if (StringUtils.isNotBlank((CharSequence)x.getCoverImageId()) && MapUtils.isNotEmpty((Map)coverImageFileIdMap)) {
                List fileList = this.newsAnnouncementService.buildDetailFileInfo(x.getCoverImageId().split(","), coverImageFileIdMap);
                x.setCoverImageInfo((FileInfoVO)fileList.get(0));
                x.setCoverImageId("");
            }
            if (x.getReadCount() != null && x.getReadCount() != 0) continue;
            Long readCount = readCountMap.getOrDefault(x.getNewsId(), 0L);
            x.setReadCount(Integer.valueOf(readCount.intValue()));
        }
        pageInfoResp.setList((List)resultList);
        pageInfoResp.setTotalRecords((int)page.getTotal());
        pageInfoResp.setTotalPages((int)page.getPages());
        return pageInfoResp;
    }

    public void handlerFavoriteNews(NewsFavoriteMessageDTO newsFavoriteMessageDTO) {
        this.updateFavoriteCount(newsFavoriteMessageDTO.getNewsId());
    }

    public void handlerCancelFavoriteNews(NewsCancelFavoriteMessageDTO newsCancelFavoriteMessageDTO) {
        newsCancelFavoriteMessageDTO.getNewsIdList().forEach(arg_0 -> this.updateFavoriteCount(arg_0));
    }

    private void updateFavoriteCount(Long newsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementFavorite::getNewsId, (Object)newsId);
        Long size = (Long)InterceptorIgnoreUtil.handler(() -> this.count((Wrapper)queryWrapper));
        if (size != null && size > -1L) {
            InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(NewsAnnouncement::getId, (Object)newsId)).set(NewsAnnouncement::getFavoriteCount, (Object)size)));
        }
    }

    @Generated
    public NewsAnnouncementFavoriteServiceImpl(NewsAnnouncementService newsAnnouncementService, LockClient lockClient, IamService iamService, RabbitMessageSender rabbitMessageSender, EnvProperties envProperties, DmcFileUtil dmcFileUtil, NewsAnnouncementReadService newsAnnouncementReadService) {
        this.newsAnnouncementService = newsAnnouncementService;
        this.lockClient = lockClient;
        this.iamService = iamService;
        this.rabbitMessageSender = rabbitMessageSender;
        this.envProperties = envProperties;
        this.dmcFileUtil = dmcFileUtil;
        this.newsAnnouncementReadService = newsAnnouncementReadService;
    }
}

