/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;
import com.digiwin.athena.semc.dto.news.NewLikeReqDTO;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementLike;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementLikeMapper;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import com.digiwin.athena.semc.mq.dto.NewsLikeMessageDTO;
import com.digiwin.athena.semc.mq.sender.RabbitMessageSender;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.cache.LockClient;
import com.digiwin.athena.semc.service.news.NewsAnnouncementLikeService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementService;
import com.digiwin.athena.semc.util.FormatUtil;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.vo.news.ValidateNewsVO;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NewsAnnouncementLikeServiceImpl
extends ServiceImpl<NewsAnnouncementLikeMapper, NewsAnnouncementLike>
implements NewsAnnouncementLikeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsAnnouncementLikeServiceImpl.class);
    private final NewsAnnouncementService newsAnnouncementService;
    private final LockClient lockClient;
    private final IamService iamService;
    private final RabbitMessageSender rabbitMessageSender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer like(NewLikeReqDTO newLikeReqDTO, boolean likeFlag) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String lockKey = FormatUtil.format((String)"newsLike:{}:{}:{}:{}", (Object[])new Object[]{newLikeReqDTO.getId(), authoredUser.getTenantId(), authoredUser.getSid(), likeFlag});
        RLock rLock = null;
        try {
            boolean resultFlag;
            Object newsAnnouncement;
            ValidateNewsVO validateNewsVO;
            boolean existNewsLike;
            rLock = this.lockClient.getLock(lockKey);
            boolean lockResult = rLock.tryLock(1L, 5L, TimeUnit.SECONDS);
            if (!lockResult) {
                log.info("\u672a\u83b7\u53d6\u5230\u9501");
                Integer n = 1;
                return n;
            }
            NewsAnnouncementLike currentNewsLike = this.getCurrentNewsLike(newLikeReqDTO.getId(), authoredUser);
            boolean bl = existNewsLike = currentNewsLike != null;
            if (likeFlag) {
                if (existNewsLike) {
                    log.info("\u5df2\u70b9\u8d5e");
                    Integer n = 1;
                    return n;
                }
            } else if (!existNewsLike) {
                log.info("\u6ca1\u6709\u70b9\u8d5e\u8bb0\u5f55");
                Integer n = 1;
                return n;
            }
            if (!"1000".equals((validateNewsVO = this.newsAnnouncementService.validateNews(newLikeReqDTO.getId())).getCode())) {
                log.warn("\u5f53\u524d\u516c\u544a\u4e0d\u5b58\u5728\uff1a{}\uff0c{}", (Object)newLikeReqDTO.getId(), (Object)validateNewsVO.getCode());
                Integer n = 2;
                return n;
            }
            if (likeFlag) {
                String verifyUserId;
                newsAnnouncement = validateNewsVO.getNewsAnnouncement();
                NewsAnnouncementLike newsAnnouncementLike = new NewsAnnouncementLike();
                newsAnnouncementLike.setNewsId(newsAnnouncement.getId());
                newsAnnouncementLike.setThirdNewsId(newsAnnouncement.getThirdNewsId());
                newsAnnouncementLike.setThirdAppId(newsAnnouncement.getThirdAppId());
                newsAnnouncementLike.setThirdAppCode(newsAnnouncement.getThirdAppCode());
                newsAnnouncementLike.setCreateUserId(authoredUser.getUserId());
                newsAnnouncementLike.setCreateUserSid(Long.valueOf(authoredUser.getSid()));
                newsAnnouncementLike.setCreateUserName(authoredUser.getUserName());
                newsAnnouncementLike.setThirdUserId("");
                if (ObjectUtils.isNotEmpty((Object)newsAnnouncement.getThirdNewsId()) && Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(newsAnnouncement.getNewsSource()) && StringUtils.isNotBlank((CharSequence)(verifyUserId = this.iamService.queryMappingEmpId(newsAnnouncement.getThirdAppCode())))) {
                    newsAnnouncementLike.setThirdUserId(verifyUserId);
                }
                newsAnnouncementLike.setTenantId(authoredUser.getTenantId());
                newsAnnouncementLike.setCreateTime(new Date());
                newsAnnouncementLike.setModifyUserId(authoredUser.getUserId());
                newsAnnouncementLike.setModifyTime(new Date());
                resultFlag = this.save((Object)newsAnnouncementLike);
            } else {
                resultFlag = (Boolean)InterceptorIgnoreUtil.handler(() -> this.removeById((Serializable)currentNewsLike.getId()));
            }
            if (!resultFlag) {
                log.warn("\u70b9\u8d5e\u6216\u53d6\u6d88\u5931\u8d25");
                newsAnnouncement = 1;
                return newsAnnouncement;
            }
            MQMessageDTO messageDTO = new MQMessageDTO();
            messageDTO.setMessageId(IdUtil.randomUUID());
            NewsLikeMessageDTO newsLikeMessageDTO = new NewsLikeMessageDTO();
            newsLikeMessageDTO.setLikeFlag(Boolean.valueOf(likeFlag));
            newsLikeMessageDTO.setAuthoredUser(authoredUser);
            newsLikeMessageDTO.setNewsAnnouncement(validateNewsVO.getNewsAnnouncement());
            messageDTO.setMessage(JSON.toJSONString((Object)newsLikeMessageDTO));
            messageDTO.setMessageType(MQMessageTypeEnum.NEWS_LIKE.getCode());
            messageDTO.setRetryMaxCount(Integer.valueOf(3));
            this.rabbitMessageSender.sendWorkCommonMsg(messageDTO);
            Integer n = 0;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("\u70b9\u8d5e\u6216\u53d6\u6d88\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            Integer n = 1;
            return n;
        }
        finally {
            this.lockClient.unlock(rLock);
        }
    }

    public void handlerLikeEvent(NewsLikeMessageDTO newsLikeMessageDTO) {
        NewsAnnouncement newsAnnouncement = newsLikeMessageDTO.getNewsAnnouncement();
        this.updateLikeCount(newsAnnouncement.getId());
    }

    private NewsAnnouncementLike getCurrentNewsLike(Long newsId, AuthoredUser authoredUser) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementLike::getNewsId, (Object)newsId);
        queryWrapper.eq(NewsAnnouncementLike::getCreateUserSid, (Object)authoredUser.getSid());
        queryWrapper.eq(NewsAnnouncementLike::getTenantId, (Object)authoredUser.getTenantId());
        return (NewsAnnouncementLike)InterceptorIgnoreUtil.handler(() -> (NewsAnnouncementLike)this.getOne((Wrapper)queryWrapper));
    }

    private void updateLikeCount(Long newsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementLike::getNewsId, (Object)newsId);
        Long size = (Long)InterceptorIgnoreUtil.handler(() -> this.count((Wrapper)queryWrapper));
        if (size != null && size > -1L) {
            InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(NewsAnnouncement::getId, (Object)newsId)).set(NewsAnnouncement::getLikeCount, (Object)size)));
        }
    }

    @Generated
    public NewsAnnouncementLikeServiceImpl(NewsAnnouncementService newsAnnouncementService, LockClient lockClient, IamService iamService, RabbitMessageSender rabbitMessageSender) {
        this.newsAnnouncementService = newsAnnouncementService;
        this.lockClient = lockClient;
        this.iamService = iamService;
        this.rabbitMessageSender = rabbitMessageSender;
    }
}

