/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.news.AnnouncementIdReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementRead;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementReadMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.news.NewsAnnouncementReadService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsAnnouncementReadServiceImpl
extends ServiceImpl<NewsAnnouncementReadMapper, NewsAnnouncementRead>
implements NewsAnnouncementReadService {
    @Resource
    private NewsAnnouncementReadMapper newsAnnouncementReadMapper;
    @Resource
    private NewsAnnouncementMapper newsAnnouncementMapper;
    @Resource
    private IamService iamService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Boolean insertNews(AnnouncementIdReq announcementIdReq) {
        Boolean respFlag;
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        RedisLock redisLock = new RedisLock("insertNews-" + tenantId + "-" + userId);
        try {
            if (!redisLock.lock()) {
                return Boolean.TRUE;
            }
        }
        catch (InterruptedException e) {
            this.log.error("obtain distributed lock error.", (Throwable)e);
            return Boolean.FALSE;
        }
        try {
            NewsAnnouncementRead readInfo = this.queryNewsAnnouncementReadInfo(announcementIdReq);
            if (ObjectUtils.isNotEmpty((Object)readInfo)) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            readInfo = new NewsAnnouncementRead();
            readInfo.setNewsId(announcementIdReq.getId());
            readInfo.setCreateUserId(userId);
            readInfo.setCreateUserSid(Long.valueOf(AppAuthContextHolder.getContext().getAuthoredUser().getSid()));
            readInfo.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            readInfo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            readInfo.setTenantId(tenantId);
            readInfo.setDelFlag(Integer.valueOf(0));
            if (ObjectUtils.isNotEmpty((Object)announcementIdReq.getThirdNewsId())) {
                String verifyUserId = this.iamService.queryMappingEmpId(announcementIdReq.getThirdAppCode());
                readInfo.setThirdUserId(verifyUserId);
                readInfo.setThirdAppId(announcementIdReq.getThirdAppId());
                readInfo.setThirdAppCode(announcementIdReq.getThirdAppCode());
                readInfo.setThirdNewsId(announcementIdReq.getThirdNewsId());
            }
            this.newsAnnouncementReadMapper.insertNewsRead(readInfo);
            this.newsAnnouncementMapper.updateReadCount(announcementIdReq.getId());
            respFlag = Boolean.TRUE;
        }
        catch (Exception e) {
            this.log.error("insert news error.", (Throwable)e);
            respFlag = Boolean.FALSE;
        }
        finally {
            redisLock.unlock();
        }
        return respFlag;
    }

    public Map<Long, Long> queryReadCount(List<Long> newsIdList) {
        if (CollectionUtils.isEmpty(newsIdList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(NewsAnnouncementRead::getNewsId, newsIdList);
        queryWrapper.select(new SFunction[]{NewsAnnouncementRead::getNewsId});
        List readList = (List)InterceptorIgnoreUtil.handler(() -> this.list((Wrapper)queryWrapper));
        if (CollectionUtils.isEmpty((Collection)readList)) {
            return Maps.newHashMap();
        }
        return readList.stream().collect(Collectors.groupingBy(NewsAnnouncementRead::getNewsId, Collectors.counting()));
    }

    private NewsAnnouncementRead queryNewsAnnouncementReadInfo(AnnouncementIdReq announcementIdReq) {
        QueryWrapper readCondition = new QueryWrapper();
        readCondition.eq((Object)"news_id", (Object)announcementIdReq.getId());
        readCondition.eq((Object)"create_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        return (NewsAnnouncementRead)this.newsAnnouncementReadMapper.selectOne((Wrapper)readCondition);
    }
}

