/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.NewsTypeConstants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.DataChangeTypeEnum;
import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;
import com.digiwin.athena.semc.common.enums.NewsAnnouncementPublishTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.news.NewsStatisticsReqDTO;
import com.digiwin.athena.semc.dto.news.QueryMobileNewsListPageReq;
import com.digiwin.athena.semc.dto.news.QueryNewsListPageReq;
import com.digiwin.athena.semc.dto.news.SaveAnnouncementReq;
import com.digiwin.athena.semc.dto.news.UpdateNewsStatusReq;
import com.digiwin.athena.semc.dto.news.WebQueryNewsListPageReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementFavorite;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementLike;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementRead;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.event.NewsAuthBizIdSetEvent;
import com.digiwin.athena.semc.event.NewsChangeEvent;
import com.digiwin.athena.semc.event.SendNoticeEvent;
import com.digiwin.athena.semc.event.dto.NewsChangeEventDTO;
import com.digiwin.athena.semc.event.dto.SendNoticeDTO;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementAuthMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementFavoriteMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementLikeMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementReadMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementTypeMapper;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import com.digiwin.athena.semc.mq.sender.RabbitMessageSender;
import com.digiwin.athena.semc.proxy.aim.dto.MessageBatchUserDTO;
import com.digiwin.athena.semc.proxy.aim.dto.MessageDTO;
import com.digiwin.athena.semc.proxy.aim.service.AimService;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptInfoDTO;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.OrgRoleUserDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserInfoDTO;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementAuthService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeAuthService;
import com.digiwin.athena.semc.service.news.ThirdNewsAnnouncementService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.DmcFileUtil;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.TransactionUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.auth.AuthVO;
import com.digiwin.athena.semc.vo.file.FileInfoVO;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementStatisticsVO;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementVO;
import com.digiwin.athena.semc.vo.news.NewsTypeAuthVO;
import com.digiwin.athena.semc.vo.news.ValidateNewsVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.linpeilie.Converter;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsAnnouncementServiceImpl
extends ServiceImpl<NewsAnnouncementMapper, NewsAnnouncement>
implements NewsAnnouncementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsAnnouncementServiceImpl.class);
    @Resource
    private NewsAnnouncementMapper newsAnnouncementMapper;
    @Resource
    private NewsAnnouncementTypeMapper newsAnnouncementTypeMapper;
    @Resource
    private NewsAnnouncementAuthMapper newsAnnouncementAuthMapper;
    @Resource
    private NewsAnnouncementAuthService newsAnnouncementAuthService;
    @Resource
    private NewsAnnouncementReadMapper newsAnnouncementReadMapper;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private DmcFileUtil dmcFileUtil;
    @Resource
    private IamService iamService;
    @Resource
    private EocService eocService;
    @Resource
    private AimService aimService;
    @Resource
    private AppLinkService appLinkService;
    @Resource
    private ThirdNewsAnnouncementService thirdNewsAnnouncementService;
    @Resource
    private NewsAnnouncementTypeAuthService newsAnnouncementTypeAuthService;
    @Resource
    private Converter converter;
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Resource
    private IamUserService iamUserService;
    @Resource
    private NewsAnnouncementLikeMapper newsAnnouncementLikeMapper;
    @Resource
    private NewsAnnouncementFavoriteMapper newsAnnouncementFavoriteMapper;
    @Resource
    private RabbitMessageSender rabbitMessageSender;
    @Resource
    private CommonConfigService commonConfigService;
    @Resource(name="semcAsyncExecutor")
    private Executor asyncTaskExecutor;
    public static final int MAX_TOPPED_COUNT = 3;

    public PageInfoResp<NewsAnnouncementVO> queryNewsListByPage(QueryNewsListPageReq queryNewsListPageReq) {
        QueryWrapper condition = new QueryWrapper();
        condition.lt((Object)"news_end_time", (Object)DateUtils.getNowTime(null));
        condition.ne((Object)"news_status", (Object)Constants.NewsAnnouncementStatusEnum.EXPIRED.getFlag());
        List expiredList = this.newsAnnouncementMapper.selectList((Wrapper)condition);
        if (CollectionUtils.isNotEmpty((Collection)expiredList)) {
            expiredList.forEach(x -> {
                x.setNewsStatus(Constants.NewsAnnouncementStatusEnum.EXPIRED.getFlag());
                x.setToppedFlag(Constants.TOPPED_FLAG_NO);
                x.setToppedTime(null);
            });
            this.updateBatchById((Collection)expiredList);
        }
        condition.clear();
        if (StringUtils.isNotBlank((CharSequence)queryNewsListPageReq.getNewsTitle())) {
            condition.like((Object)"news_title", (Object)queryNewsListPageReq.getNewsTitle());
        }
        if (ObjectUtils.isNotEmpty((Object)queryNewsListPageReq.getNewsSource())) {
            condition.eq((Object)"news_source", (Object)queryNewsListPageReq.getNewsSource());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryNewsListPageReq.getAppSourceCode())) {
            if (VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getCode().equals(queryNewsListPageReq.getAppSourceCode())) {
                condition.eq((Object)"news_source", (Object)Constants.ThirdNewsAnnouncementEnum.INSIDER_INFORMATION.getType());
            } else {
                condition.eq((Object)"news_source", (Object)Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType());
                condition.eq((Object)"third_app_code", (Object)queryNewsListPageReq.getAppSourceCode());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)queryNewsListPageReq.getNewsTypeIdList())) {
            condition.in((Object)"news_type_id", (Collection)queryNewsListPageReq.getNewsTypeIdList());
        } else {
            NewsTypeAuthVO newsTypeAuthVO = this.newsAnnouncementTypeAuthService.queryAuthRelNewsType(null);
            if (Constants.ALL_AUTH_FLAG_NO.equals(newsTypeAuthVO.getAllNewsTypeFlag())) {
                List authorizedNewsTypeIdList = newsTypeAuthVO.getAuthorizedNewsTypeIdList();
                condition.in((Object)"news_type_id", (Collection)authorizedNewsTypeIdList);
            }
        }
        if (ObjectUtils.isNotEmpty((Object)queryNewsListPageReq.getNewsStatus())) {
            if (Constants.NewsAnnouncementStatusEnum.PENDING_EFFECTIVE.getFlag().equals(queryNewsListPageReq.getNewsStatus())) {
                condition.gt((Object)"news_effective_time", (Object)DateUtils.getNowTime(null));
            } else if (Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(queryNewsListPageReq.getNewsStatus())) {
                condition.eq((Object)"news_status", (Object)queryNewsListPageReq.getNewsStatus());
                condition.le((Object)"news_effective_time", (Object)DateUtils.getNowTime(null));
                condition.ge((Object)"news_end_time", (Object)DateUtils.getNowTime(null));
            } else {
                condition.eq((Object)"news_status", (Object)queryNewsListPageReq.getNewsStatus());
            }
        }
        if (ObjectUtils.isNotEmpty((Object)queryNewsListPageReq.getNewsChannel())) {
            condition.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"news_channel", (Object)Constants.NewsChannelFlagEnum.ALL.getFlag())).or()).eq((Object)"news_channel", (Object)queryNewsListPageReq.getNewsChannel());
            });
            if (Constants.NewsChannelFlagEnum.MOBILE.getFlag().equals(queryNewsListPageReq.getNewsChannel())) {
                condition.eq((Object)"news_source", (Object)Constants.ThirdNewsAnnouncementEnum.INSIDER_INFORMATION.getType());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)queryNewsListPageReq.getEffectiveTimeStart())) {
            condition.ge((Object)"news_effective_time", (Object)queryNewsListPageReq.getEffectiveTimeStart());
        }
        if (StringUtils.isNotBlank((CharSequence)queryNewsListPageReq.getEffectiveTimeEnd())) {
            condition.le((Object)"news_effective_time", (Object)queryNewsListPageReq.getEffectiveTimeEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)queryNewsListPageReq.getEndTimeStart())) {
            condition.ge((Object)"news_end_time", (Object)queryNewsListPageReq.getEndTimeStart());
        }
        if (StringUtils.isNotBlank((CharSequence)queryNewsListPageReq.getEndTimeEnd())) {
            condition.le((Object)"news_end_time", (Object)queryNewsListPageReq.getEndTimeEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)queryNewsListPageReq.getCreateTimeStart())) {
            condition.ge((Object)"create_time", (Object)queryNewsListPageReq.getCreateTimeStart());
        }
        if (StringUtils.isNotBlank((CharSequence)queryNewsListPageReq.getCreateTimeEnd())) {
            condition.le((Object)"create_time", (Object)queryNewsListPageReq.getCreateTimeEnd());
        }
        ((QueryWrapper)condition.orderByDesc((Object)"topped_time")).orderByDesc((Object)"create_time");
        condition.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        condition.select(new String[]{"id", "news_title", "news_status", "news_effective_flag", "news_effective_time", "news_end_time", "news_type_id", "news_type_path", "summary", "news_channel", "default_image_icon", "cover_image_id", "topped_flag", "topped_time", "modified_flag", "file_id", "news_source", "third_news_id", "third_app_id", "third_app_code", "third_img_url", "third_user_ids", "third_news_html", "create_user_id", "create_time", "modify_user_id", "modify_time", "like_count"});
        PageInfoResp pageInfoResp = new PageInfoResp();
        Page pageResult = (Page)this.newsAnnouncementMapper.selectPage((IPage)new Page((long)queryNewsListPageReq.getPageNum().intValue(), (long)queryNewsListPageReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult == null || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageInfoResp;
        }
        List newsList = pageResult.getRecords();
        Map newsTypeMap = this.queryNewsTypeByNewsList(newsList);
        Map fileIdMap = this.queryFileInfoList(newsList);
        Map<Object, Object> appCodeMap = Maps.newHashMap();
        boolean flag = newsList.stream().anyMatch(x -> Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(x.getNewsSource()));
        if (flag) {
            List appLinkList = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
            appCodeMap = appLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getCode, AppLinkDTO::getName, (a, b) -> a));
        }
        ArrayList newsAnnouncementVOList = Lists.newArrayList();
        for (NewsAnnouncement x2 : newsList) {
            List fileList;
            NewsAnnouncementVO newsAnnouncementVO = (NewsAnnouncementVO)this.converter.convert((Object)x2, NewsAnnouncementVO.class);
            if (MapUtils.isNotEmpty((Map)newsTypeMap) && ObjectUtils.isNotEmpty(newsTypeMap.get(x2.getNewsTypeId()))) {
                NewsAnnouncementType newsAnnouncementType = (NewsAnnouncementType)newsTypeMap.get(x2.getNewsTypeId());
                newsAnnouncementVO.setParentNewsTypeId(newsAnnouncementType.getParentId());
                newsAnnouncementVO.setNewsTypeName(this.getNewsTypeNameByNewPath(newsTypeMap, x2));
            } else {
                this.buildOtherNewsType(newsAnnouncementVO);
            }
            if (StringUtils.isNotBlank((CharSequence)x2.getFileId()) && MapUtils.isNotEmpty((Map)fileIdMap)) {
                fileList = this.buildDetailFileInfo(x2.getFileId().split(","), fileIdMap);
                newsAnnouncementVO.setFileList(fileList);
            }
            if (StringUtils.isNotBlank((CharSequence)x2.getCoverImageId()) && MapUtils.isNotEmpty((Map)fileIdMap)) {
                fileList = this.buildDetailFileInfo(x2.getCoverImageId().split(","), fileIdMap);
                newsAnnouncementVO.setCoverImageInfo((FileInfoVO)fileList.get(0));
            }
            if (Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(x2.getNewsSource())) {
                newsAnnouncementVO.setThirdAppName((String)appCodeMap.get(x2.getThirdAppCode()));
            } else {
                newsAnnouncementVO.setThirdAppCode(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getCode());
                newsAnnouncementVO.setThirdAppName(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getName());
            }
            if (NewsAnnouncementPublishTypeEnum.NONE.getCode().equals(x2.getPublishType())) {
                newsAnnouncementVO.setPublishId("");
                newsAnnouncementVO.setPublishName("");
            }
            newsAnnouncementVOList.add(newsAnnouncementVO);
        }
        this.buildNewsReadUserList((List)newsAnnouncementVOList, false, false);
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(queryNewsListPageReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryNewsListPageReq.getPageSize().intValue());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList((List)newsAnnouncementVOList);
        return pageInfoResp;
    }

    private void buildOtherNewsType(NewsAnnouncementVO newsAnnouncementVO) {
        newsAnnouncementVO.setNewsTypeId(Long.valueOf(4L));
        newsAnnouncementVO.setParentNewsTypeId(Long.valueOf(0L));
        newsAnnouncementVO.setNewsTypeName("\u5176\u4ed6");
    }

    private void buildNewsReadUserList(List<NewsAnnouncementVO> newsAnnouncementVOList, boolean setReadUserListValue, boolean setUnReadUserListValue) {
        List autList;
        List newsIdList = newsAnnouncementVOList.stream().map(NewsAnnouncementVO::getId).collect(Collectors.toList());
        Map<Object, Object> readNewsIdMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(newsIdList)) {
            List readList = this.newsAnnouncementReadMapper.selectNewsAnnouncementReadList(newsIdList);
            readNewsIdMap = readList.stream().collect(Collectors.groupingBy(NewsAnnouncementRead::getNewsId));
        }
        List allUserList = this.iamService.queryEnabledUserList();
        Map<String, String> userNameMap = allUserList.stream().collect(Collectors.toMap(RoleDTO::getId, RoleDTO::getName, (a, b) -> a));
        List orgUserList = Lists.newArrayList();
        List roleUserList = Lists.newArrayList();
        List deptUserList = Lists.newArrayList();
        Map<Object, Object> newsIdAuthMap = Maps.newHashMap();
        List onePartyIdList = newsAnnouncementVOList.stream().filter(x -> Constants.ThirdNewsAnnouncementEnum.INSIDER_INFORMATION.getType().equals(x.getNewsSource())).map(NewsAnnouncementVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(onePartyIdList) && CollectionUtils.isNotEmpty((Collection)(autList = this.newsAnnouncementAuthMapper.selectByNewsId(onePartyIdList)))) {
            List orgSidList = autList.stream().filter(x -> BizAuthTypeEnum.ORG.getValue().equals(x.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
            orgUserList = this.iamService.queryUserByAllOrgSidList(orgSidList);
            List roleSidList = autList.stream().filter(x -> BizAuthTypeEnum.ROLE.getValue().equals(x.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
            roleUserList = this.iamService.queryUserByAllRoleSidList(roleSidList);
            List deptSidList = autList.stream().filter(x -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(x.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
            deptUserList = this.eocService.queryUserByDeptSidList(deptSidList);
            newsIdAuthMap = autList.stream().collect(Collectors.groupingBy(NewsAnnouncementAut::getNewsId));
            List authList = autList.stream().filter(x -> BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(x.getAuthType()) && StringUtils.isBlank((CharSequence)x.getAuthBizId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(authList)) {
                NewsAuthBizIdSetEvent newsAuthBizIdSetEvent = new NewsAuthBizIdSetEvent((Object)this, authList);
                this.eventPublisher.publishEvent((ApplicationEvent)newsAuthBizIdSetEvent);
            }
        }
        for (NewsAnnouncementVO x2 : newsAnnouncementVOList) {
            x2.setCreateUserName(userNameMap.get(x2.getCreateUserId()));
            x2.setModifyUserName(userNameMap.get(x2.getModifyUserId()));
            ArrayList readUserList = Lists.newArrayList();
            List<Object> unReadUserList = Lists.newArrayList();
            List<Object> shouldReadUserList = Lists.newArrayList();
            List curNewsReadList = (List)readNewsIdMap.get(x2.getId());
            List newsAuthList = (List)newsIdAuthMap.get(x2.getId());
            if (Constants.ThirdNewsAnnouncementEnum.INSIDER_INFORMATION.getType().equals(x2.getNewsSource()) && CollectionUtils.isNotEmpty((Collection)newsAuthList)) {
                if (Constants.NEWS_ALL_AUTH_FLAG_YES.equals(((NewsAnnouncementAut)newsAuthList.get(0)).getAllAuthFlag())) {
                    shouldReadUserList = allUserList.stream().map(y -> {
                        UserDTO userDTO = new UserDTO();
                        userDTO.setSid(Long.valueOf(y.getSid()));
                        userDTO.setId(y.getId());
                        userDTO.setName(y.getName());
                        return userDTO;
                    }).collect(Collectors.toList());
                    unReadUserList = this.filterReadUserList((List)readUserList, (List)shouldReadUserList, curNewsReadList);
                } else {
                    List orgSidList = newsAuthList.stream().filter(y -> BizAuthTypeEnum.ORG.getValue().equals(y.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
                    List orgList = orgUserList.stream().filter(y -> orgSidList.contains(y.getOrgSid())).collect(Collectors.toList());
                    List roleSidList = newsAuthList.stream().filter(y -> BizAuthTypeEnum.ROLE.getValue().equals(y.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
                    List roleList = roleUserList.stream().filter(y -> roleSidList.contains(y.getRoleSid())).collect(Collectors.toList());
                    List deptSidList = newsAuthList.stream().filter(y -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(y.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
                    List deptList = deptUserList.stream().filter(y -> deptSidList.contains(y.getDeptSid())).collect(Collectors.toList());
                    List userList = newsAuthList.stream().filter(y -> BizAuthTypeEnum.USER.getValue().equals(y.getAuthType()) || BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(y.getAuthType())).collect(Collectors.toList());
                    for (OrgRoleUserDTO orgRoleUserDTO : orgList) {
                        shouldReadUserList.addAll(orgRoleUserDTO.getUsers());
                    }
                    for (OrgRoleUserDTO orgRoleUserDTO : roleList) {
                        shouldReadUserList.addAll(orgRoleUserDTO.getUsers());
                    }
                    for (UserDeptInfoDTO userDeptInfoDTO : deptList) {
                        ArrayList userDTOList = Lists.newArrayList();
                        userDeptInfoDTO.getEmps().forEach(empInfo -> {
                            if (ObjectUtils.isNotEmpty((Object)empInfo.getEmpUserSid())) {
                                UserDTO userDTO = new UserDTO();
                                userDTO.setSid(empInfo.getEmpUserSid());
                                userDTO.setId(empInfo.getEmpUserId());
                                userDTO.setName(empInfo.getEmpUserName());
                                userDTOList.add(userDTO);
                            }
                        });
                        shouldReadUserList.addAll(userDTOList);
                    }
                    for (NewsAnnouncementAut newsAnnouncementAut : userList) {
                        UserDTO userDTO = new UserDTO();
                        userDTO.setSid(newsAnnouncementAut.getAuthId());
                        userDTO.setName(newsAnnouncementAut.getAuthName());
                        shouldReadUserList.add(userDTO);
                    }
                    shouldReadUserList = shouldReadUserList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserDTO>(Comparator.comparing(UserDTO::getSid))), ArrayList::new));
                    unReadUserList = this.filterReadUserList((List)readUserList, shouldReadUserList, curNewsReadList);
                }
            }
            if (Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(x2.getNewsSource())) {
                shouldReadUserList = Arrays.stream(x2.getThirdUserIds().split(",")).map(y -> {
                    UserDTO userDTO = new UserDTO();
                    userDTO.setId(y);
                    userDTO.setName(y);
                    return userDTO;
                }).collect(Collectors.toList());
                ArrayList readSidList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)curNewsReadList)) {
                    for (NewsAnnouncementRead announcementRead : curNewsReadList) {
                        UserDTO userDTO = new UserDTO();
                        userDTO.setId(announcementRead.getThirdUserId());
                        userDTO.setName(announcementRead.getThirdUserId());
                        readUserList.add(userDTO);
                        readSidList.add(announcementRead.getThirdUserId());
                    }
                }
                unReadUserList = shouldReadUserList.stream().filter(y -> !readSidList.contains(y.getId())).collect(Collectors.toList());
            }
            x2.setReadCount(Integer.valueOf(readUserList.size()));
            x2.setUnReadCount(Integer.valueOf(unReadUserList.size()));
            x2.setShouldReadCount(Integer.valueOf(shouldReadUserList.size()));
            if (setReadUserListValue) {
                x2.setReadList((List)readUserList);
            }
            if (!setUnReadUserListValue) continue;
            x2.setUnReadList((List)unReadUserList);
        }
    }

    private List<UserDTO> filterReadUserList(List<UserDTO> readUserList, List<UserDTO> shouldReadUserList, List<NewsAnnouncementRead> readList) {
        if (CollectionUtils.isEmpty(readList)) {
            return shouldReadUserList;
        }
        ArrayList readSidList = Lists.newArrayList();
        for (NewsAnnouncementRead announcementRead : readList) {
            UserDTO userDTO = new UserDTO();
            userDTO.setSid(announcementRead.getCreateUserSid());
            userDTO.setId(announcementRead.getCreateUserId());
            userDTO.setName(announcementRead.getCreateUserName());
            readUserList.add(userDTO);
            if (!ObjectUtils.isNotEmpty((Object)announcementRead.getCreateUserSid())) continue;
            readSidList.add(announcementRead.getCreateUserSid());
        }
        shouldReadUserList = shouldReadUserList.stream().filter(y -> !readSidList.contains(y.getSid())).collect(Collectors.toList());
        return shouldReadUserList;
    }

    private Map<String, Object> queryFileInfoList(List<NewsAnnouncement> newsList) {
        ArrayList fileIdList = Lists.newArrayList();
        newsList.forEach(x -> {
            if (StringUtils.isNotBlank((CharSequence)x.getFileId())) {
                fileIdList.addAll(Arrays.asList(x.getFileId().split(",")));
            }
            if (StringUtils.isNotBlank((CharSequence)x.getCoverImageId())) {
                fileIdList.add(x.getCoverImageId().trim());
            }
        });
        return this.dmcFileUtil.queryFileInfoList((List)fileIdList);
    }

    public List<FileInfoVO> buildDetailFileInfo(String[] fileIdArray, Map<String, Object> fileIdMap) {
        ArrayList fileInfoVOList = Lists.newArrayList();
        for (String fileId : fileIdArray) {
            FileInfoVO fileInfoVO = new FileInfoVO();
            fileInfoVO.setId(fileId.trim());
            fileInfoVOList.add(fileInfoVO);
            if (Objects.isNull(fileIdMap.get(fileId.trim()))) continue;
            LinkedHashMap file = (LinkedHashMap)fileIdMap.get(fileId.trim());
            fileInfoVO.setName(String.valueOf(file.get("fileName")));
            fileInfoVO.setType(String.valueOf(file.get("extension")));
            fileInfoVO.setUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + fileId.trim());
            fileInfoVO.setMobileOnlineUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/online/preview/" + fileId.trim());
            fileInfoVO.setSize(String.valueOf(file.get("size")));
            fileInfoVO.setCreateDate(String.valueOf(file.get("createDate")));
        }
        return fileInfoVOList;
    }

    public void updatePublishStatus(UpdateNewsStatusReq updateNewsStatusReq, List<NewsAnnouncement> newsAnnouncementList) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"news_status", (Object)updateNewsStatusReq.getNewsStatus())).set((Object)"modify_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId())).set((Object)"modify_time", (Object)LocalDateTime.now());
        if (Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(updateNewsStatusReq.getNewsStatus())) {
            updateWrapper.set((Object)"news_effective_time", (Object)LocalDateTime.now());
        }
        updateWrapper.in((Object)"id", (Collection)updateNewsStatusReq.getIdList());
        this.update((Wrapper)updateWrapper);
        if (Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(updateNewsStatusReq.getNewsStatus())) {
            List needSendNoticeList = newsAnnouncementList.stream().filter(x -> Constants.NUMBER_ONE.equals(x.getNoticeFlag()) && Constants.NUMBER_ZERO.equals(x.getAlreadyNoticeFlag())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(needSendNoticeList)) {
                log.info("no news need send notice");
                return;
            }
            List newsIdList = needSendNoticeList.stream().map(NewsAnnouncement::getId).collect(Collectors.toList());
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(NewsAnnouncement::getId, newsIdList)).set(NewsAnnouncement::getAlreadyNoticeFlag, (Object)Constants.NUMBER_ONE));
            List autList = this.newsAnnouncementAuthMapper.selectByNewsId(newsIdList);
            if (CollectionUtils.isEmpty((Collection)autList)) {
                log.info("all news auth list is empty. newsIdList:{}", newsIdList);
                return;
            }
            Map<Long, List<NewsAnnouncementAut>> newsIdMap = autList.stream().collect(Collectors.groupingBy(NewsAnnouncementAut::getNewsId));
            for (NewsAnnouncement newsAnnouncement : needSendNoticeList) {
                List<NewsAnnouncementAut> newsAuthList = newsIdMap.get(newsAnnouncement.getId());
                if (CollectionUtils.isEmpty(newsAuthList)) {
                    log.info("this news auth list is empty. newsId:{}", (Object)newsAnnouncement.getId());
                    continue;
                }
                boolean flag = newsAuthList.stream().anyMatch(x -> Constants.NEWS_ALL_AUTH_FLAG_YES.equals(x.getAllAuthFlag()));
                Integer allAuthFlag = flag ? Constants.NEWS_ALL_AUTH_FLAG_YES : Constants.NEWS_ALL_AUTH_FLAG_NO;
                List orgSidList = newsAuthList.stream().filter(x -> BizAuthTypeEnum.ORG.getValue().equals(x.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
                List roleSidList = newsAuthList.stream().filter(x -> BizAuthTypeEnum.ROLE.getValue().equals(x.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
                List deptSidList = newsAuthList.stream().filter(x -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(x.getAuthType())).map(NewsAnnouncementAut::getAuthId).collect(Collectors.toList());
                Map<Long, String> userSidMap = newsAuthList.stream().filter(x -> BizAuthTypeEnum.USER.getValue().equals(x.getAuthType())).collect(Collectors.toMap(NewsAnnouncementAut::getAuthId, NewsAnnouncementAut::getAuthBizId));
                Map externalSidMap = newsAuthList.stream().filter(x -> BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(x.getAuthType())).collect(Collectors.toMap(NewsAnnouncementAut::getAuthId, Function.identity()));
                this.sendNoticeEvent(newsAnnouncement.getId(), newsAnnouncement.getNewsTitle(), allAuthFlag, orgSidList, roleSidList, deptSidList, userSidMap, externalSidMap, null);
            }
        }
    }

    @Transactional
    public void updateToppedStatus(Long id, Integer toppedFlag) {
        if (toppedFlag.equals(Constants.TOPPED_FLAG_YES)) {
            QueryWrapper condition = new QueryWrapper();
            condition.eq((Object)"topped_flag", (Object)Constants.TOPPED_FLAG_YES);
            condition.orderByAsc((Object)"topped_time");
            List toppedList = this.newsAnnouncementMapper.selectList((Wrapper)condition);
            if (toppedList.size() >= 3) {
                NewsAnnouncement newsAnnouncement = (NewsAnnouncement)toppedList.get(0);
                newsAnnouncement.setToppedFlag(Constants.TOPPED_FLAG_NO);
                newsAnnouncement.setToppedTime(null);
                this.newsAnnouncementMapper.updateById((Object)newsAnnouncement);
            }
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"topped_flag", (Object)toppedFlag)).set((Object)"topped_time", (Object)LocalDateTime.now())).set((Object)"modify_user_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId())).set((Object)"modify_time", (Object)LocalDateTime.now());
            updateWrapper.eq((Object)"id", (Object)id);
            this.update((Wrapper)updateWrapper);
        } else {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"topped_flag", (Object)toppedFlag)).set((Object)"topped_time", null)).set((Object)"modify_time", (Object)LocalDateTime.now());
            updateWrapper.eq((Object)"id", (Object)id);
            this.update((Wrapper)updateWrapper);
        }
    }

    @Transactional
    public void delNews(List<Long> idList) {
        this.newsAnnouncementMapper.deleteBatchIds(idList);
        this.newsAnnouncementAuthMapper.deleteByNewsIdList(idList);
        this.newsAnnouncementReadMapper.deleteByNewsIdList(idList);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(NewsAnnouncementLike::getNewsId, idList);
        InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementLikeMapper.delete((Wrapper)queryWrapper));
    }

    public NewsAnnouncementVO queryManagerNewsDetail(Long id) {
        NewsAnnouncement newsAnnouncement = (NewsAnnouncement)this.newsAnnouncementMapper.selectById((Serializable)id);
        if (ObjectUtils.isEmpty((Object)newsAnnouncement)) {
            return null;
        }
        NewsAnnouncementVO newsAnnouncementVO = (NewsAnnouncementVO)this.converter.convert((Object)newsAnnouncement, NewsAnnouncementVO.class);
        Map newsTypeMap = this.queryNewsTypeByNewsList((List)Lists.newArrayList((Object[])new NewsAnnouncement[]{newsAnnouncement}));
        NewsAnnouncementType newsAnnouncementType = (NewsAnnouncementType)newsTypeMap.get(newsAnnouncementVO.getNewsTypeId());
        if (ObjectUtils.isEmpty((Object)newsAnnouncementType)) {
            this.buildOtherNewsType(newsAnnouncementVO);
        } else {
            newsAnnouncementVO.setParentNewsTypeId(newsAnnouncementType.getParentId());
            newsAnnouncementVO.setNewsTypeName(this.getNewsTypeNameByNewPath(newsTypeMap, newsAnnouncement));
        }
        List announcementAutList = this.newsAnnouncementAuthMapper.selectByNewsId(Collections.singletonList(id));
        if (CollectionUtils.isEmpty((Collection)announcementAutList)) {
            return newsAnnouncementVO;
        }
        if (Constants.NEWS_ALL_AUTH_FLAG_YES.equals(((NewsAnnouncementAut)announcementAutList.get(0)).getAllAuthFlag())) {
            newsAnnouncementVO.setAllAuthFlag(Constants.NEWS_ALL_AUTH_FLAG_YES);
        } else {
            newsAnnouncementVO.setAllAuthFlag(Constants.NEWS_ALL_AUTH_FLAG_NO);
            Map<Integer, List<NewsAnnouncementAut>> authTypeMap = announcementAutList.stream().collect(Collectors.groupingBy(NewsAnnouncementAut::getAuthType));
            for (Map.Entry<Integer, List<NewsAnnouncementAut>> entry : authTypeMap.entrySet()) {
                List authDTOList = entry.getValue().stream().map(NewsAnnouncementAut2 -> (AuthVO)this.converter.convert(NewsAnnouncementAut2, AuthVO.class)).collect(Collectors.toList());
                if (BizAuthTypeEnum.ORG.getValue().equals(entry.getKey())) {
                    newsAnnouncementVO.setOrgList(authDTOList);
                    continue;
                }
                if (BizAuthTypeEnum.ROLE.getValue().equals(entry.getKey())) {
                    newsAnnouncementVO.setRoleList(authDTOList);
                    continue;
                }
                if (BizAuthTypeEnum.USER.getValue().equals(entry.getKey())) {
                    newsAnnouncementVO.setUserList(authDTOList);
                    continue;
                }
                if (BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(entry.getKey())) {
                    newsAnnouncementVO.setExternalUserList(authDTOList);
                    continue;
                }
                if (!BizAuthTypeEnum.DEPARTMENT.getValue().equals(entry.getKey())) continue;
                newsAnnouncementVO.setDeptList(authDTOList);
            }
        }
        if (NewsAnnouncementPublishTypeEnum.NONE.getCode().equals(newsAnnouncementVO.getPublishType())) {
            newsAnnouncementVO.setPublishName("");
            newsAnnouncementVO.setPublishId("");
        }
        return newsAnnouncementVO;
    }

    @Transactional
    public void saveNews(SaveAnnouncementReq saveAnnouncementReq) {
        NewsAnnouncement newsAnnouncement;
        DataChangeTypeEnum dataChangeTypeEnum;
        Long oldNewsTypeId = null;
        boolean noticeFlag = Boolean.FALSE;
        if (ObjectUtils.isEmpty((Object)saveAnnouncementReq.getId())) {
            dataChangeTypeEnum = DataChangeTypeEnum.ADD;
            newsAnnouncement = new NewsAnnouncement();
            this.buildNewAnnouncement(saveAnnouncementReq, newsAnnouncement);
            if (Constants.VALID_STATUS_ENABLE.equals(saveAnnouncementReq.getNewsStatus()) && Constants.NUMBER_ONE.equals(saveAnnouncementReq.getNoticeFlag())) {
                noticeFlag = true;
            }
            this.newsAnnouncementMapper.insert((Object)newsAnnouncement);
            saveAnnouncementReq.setId(newsAnnouncement.getId());
        } else {
            dataChangeTypeEnum = DataChangeTypeEnum.EDIT;
            newsAnnouncement = (NewsAnnouncement)this.newsAnnouncementMapper.selectById((Serializable)saveAnnouncementReq.getId());
            oldNewsTypeId = newsAnnouncement.getNewsTypeId();
            if (!(newsAnnouncement.getNewsTitle().equals(saveAnnouncementReq.getNewsTitle()) && newsAnnouncement.getNewsTypeId().equals(saveAnnouncementReq.getNewsTypeId()) && newsAnnouncement.getNewsChannel().equals(saveAnnouncementReq.getNewsChannel()) && newsAnnouncement.getNewsEndTime().equals(saveAnnouncementReq.getNewsEndTime()))) {
                newsAnnouncement.setModifiedFlag(Constants.MODIFIED_FLAG_YES);
            }
            if (CollectionUtils.isEmpty((Collection)saveAnnouncementReq.getFileIdList())) {
                if (StringUtils.isNotBlank((CharSequence)newsAnnouncement.getFileId())) {
                    newsAnnouncement.setModifiedFlag(Constants.MODIFIED_FLAG_YES);
                }
            } else if (StringUtils.isBlank((CharSequence)newsAnnouncement.getFileId()) || !String.join((CharSequence)",", saveAnnouncementReq.getFileIdList()).equals(newsAnnouncement.getFileId())) {
                newsAnnouncement.setModifiedFlag(Constants.MODIFIED_FLAG_YES);
            }
            if (!newsAnnouncement.getNewsContent().contentEquals(saveAnnouncementReq.getNewsContent())) {
                newsAnnouncement.setModifiedFlag(Constants.MODIFIED_FLAG_YES);
            }
            if (newsAnnouncement.getNewsEndTime().compareTo(DateUtils.getNowTime(null)) < 0 && !newsAnnouncement.getNewsEndTime().equals(saveAnnouncementReq.getNewsEndTime())) {
                this.newsAnnouncementReadMapper.deleteByNewsIdList(Collections.singletonList(saveAnnouncementReq.getId()));
            }
            this.buildNewAnnouncement(saveAnnouncementReq, newsAnnouncement);
            if (Constants.NUMBER_ONE.equals(saveAnnouncementReq.getNoticeFlag()) && Constants.NUMBER_ZERO.equals(newsAnnouncement.getAlreadyNoticeFlag())) {
                noticeFlag = true;
            }
            this.newsAnnouncementMapper.updateById((Object)newsAnnouncement);
        }
        List externalUserList = this.saveNewsAuthInner(saveAnnouncementReq);
        Long finalOldNewsTypeId = oldNewsTypeId;
        boolean flag = noticeFlag;
        TransactionUtils.executeAfterCommit(() -> {
            NewsChangeEventDTO eventDTO = new NewsChangeEventDTO();
            eventDTO.setDataChangeType(dataChangeTypeEnum);
            eventDTO.setOldNewsTypeIdList(Collections.singletonList(finalOldNewsTypeId));
            eventDTO.setCurrentNewsTypeId(saveAnnouncementReq.getNewsTypeId());
            NewsChangeEvent newsChangeEvent = new NewsChangeEvent((Object)this, eventDTO);
            this.eventPublisher.publishEvent((ApplicationEvent)newsChangeEvent);
            if (flag) {
                List<Object> orgSidList = Lists.newArrayList();
                List<Object> roleSidList = Lists.newArrayList();
                List<Object> deptSidList = Lists.newArrayList();
                Map<Object, Object> userSidMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty((Collection)saveAnnouncementReq.getOrgList())) {
                    orgSidList = saveAnnouncementReq.getOrgList().stream().map(AuthVO::getAuthId).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty((Collection)saveAnnouncementReq.getRoleList())) {
                    roleSidList = saveAnnouncementReq.getRoleList().stream().map(AuthVO::getAuthId).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty((Collection)saveAnnouncementReq.getDeptList())) {
                    deptSidList = saveAnnouncementReq.getDeptList().stream().map(AuthVO::getAuthId).collect(Collectors.toList());
                }
                if (CollectionUtils.isNotEmpty((Collection)saveAnnouncementReq.getUserList())) {
                    userSidMap = saveAnnouncementReq.getUserList().stream().collect(Collectors.toMap(AuthVO::getAuthId, AuthVO::getAuthBizId));
                }
                this.sendNoticeEvent(saveAnnouncementReq.getId(), saveAnnouncementReq.getNewsTitle(), saveAnnouncementReq.getAllAuthFlag(), (List)orgSidList, (List)roleSidList, (List)deptSidList, (Map)userSidMap, null, externalUserList);
            }
        });
    }

    private void sendNoticeEvent(Long id, String newsTitle, Integer allAuthFlag, List<Long> orgSidList, List<Long> roleSidList, List<Long> deptSidList, Map<Long, String> userSidMap, Map<Long, NewsAnnouncementAut> externalSidMap, List<UserDTO> externalUserList) {
        SendNoticeDTO sendNoticeDTO = new SendNoticeDTO();
        sendNoticeDTO.setNewsId(id);
        sendNoticeDTO.setNewsTitle(newsTitle);
        sendNoticeDTO.setAllAuthFlag(allAuthFlag);
        sendNoticeDTO.setOrgSidList(orgSidList);
        sendNoticeDTO.setRoleSidList(roleSidList);
        sendNoticeDTO.setDeptSidList(deptSidList);
        sendNoticeDTO.setUserSidMap(userSidMap);
        sendNoticeDTO.setExternalUserSidMap(externalSidMap);
        sendNoticeDTO.setExternalUserList(externalUserList);
        SendNoticeEvent sendNoticeEvent = new SendNoticeEvent((Object)this, sendNoticeDTO);
        this.eventPublisher.publishEvent((ApplicationEvent)sendNoticeEvent);
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(NewsAnnouncement::getId, (Object)id)).set(NewsAnnouncement::getAlreadyNoticeFlag, (Object)Constants.NUMBER_ONE));
    }

    private List<UserDTO> saveNewsAuthInner(SaveAnnouncementReq saveAnnouncementReq) {
        this.newsAnnouncementAuthMapper.deleteByNewsId(saveAnnouncementReq.getId());
        ArrayList externalUserList = Lists.newArrayList();
        String tenantId = Utils.getTenantId();
        if (Constants.NEWS_ALL_AUTH_FLAG_YES.equals(saveAnnouncementReq.getAllAuthFlag())) {
            NewsAnnouncementAut newsAnnouncementAuth = new NewsAnnouncementAut();
            newsAnnouncementAuth.setNewsId(saveAnnouncementReq.getId());
            newsAnnouncementAuth.setNewsTypeId(saveAnnouncementReq.getNewsTypeId());
            newsAnnouncementAuth.setAllAuthFlag(Constants.NEWS_ALL_AUTH_FLAG_YES);
            newsAnnouncementAuth.setCreateTenantId(tenantId);
            this.newsAnnouncementAuthMapper.insert((Object)newsAnnouncementAuth);
        } else {
            ArrayList authList = new ArrayList();
            authList.addAll(CollectionUtils.isEmpty((Collection)saveAnnouncementReq.getOrgList()) ? Lists.newArrayList() : saveAnnouncementReq.getOrgList());
            authList.addAll(CollectionUtils.isEmpty((Collection)saveAnnouncementReq.getRoleList()) ? Lists.newArrayList() : saveAnnouncementReq.getRoleList());
            authList.addAll(CollectionUtils.isEmpty((Collection)saveAnnouncementReq.getDeptList()) ? Lists.newArrayList() : saveAnnouncementReq.getDeptList());
            authList.addAll(CollectionUtils.isEmpty((Collection)saveAnnouncementReq.getUserList()) ? Lists.newArrayList() : saveAnnouncementReq.getUserList());
            authList.addAll(CollectionUtils.isEmpty((Collection)saveAnnouncementReq.getExternalUserList()) ? Lists.newArrayList() : saveAnnouncementReq.getExternalUserList());
            if (CollectionUtils.isNotEmpty(authList)) {
                ArrayList newsAuthList = new ArrayList();
                authList.forEach(x -> {
                    Map map;
                    NewsAnnouncementAut newsAuth = (NewsAnnouncementAut)this.converter.convert(x, NewsAnnouncementAut.class);
                    if (BizAuthTypeEnum.EXTERNAL_USER.getValue().equals(x.getAuthType()) && MapUtils.isNotEmpty((Map)(map = this.getPersonalTenantId(x.getAuthId()))) && ObjectUtils.isNotEmpty(map.get("tenantId"))) {
                        newsAuth.setTenantId(String.valueOf(map.get("tenantId")));
                        UserDTO userDTO = new UserDTO();
                        userDTO.setTenantId(String.valueOf(map.get("tenantId")));
                        userDTO.setId(String.valueOf(map.get("userId")));
                        externalUserList.add(userDTO);
                    }
                    newsAuth.setCreateTenantId(tenantId);
                    newsAuth.setNewsId(saveAnnouncementReq.getId());
                    newsAuth.setNewsTypeId(saveAnnouncementReq.getNewsTypeId());
                    newsAuthList.add(newsAuth);
                });
                this.newsAnnouncementAuthService.saveBatch(newsAuthList);
            }
        }
        return externalUserList;
    }

    public Map<String, Object> getPersonalTenantId(Long sid) {
        UserInfoDTO userInfoDTO = this.iamService.queryUser(null, sid, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setToken(AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        return this.iamService.getTenantAuth(authoredUser, userInfoDTO.getEmail(), userInfoDTO.getTelephone(), "Athena", Integer.valueOf(0));
    }

    private void buildNewAnnouncement(SaveAnnouncementReq saveAnnouncementReq, NewsAnnouncement newsAnnouncement) {
        newsAnnouncement.setPublishType(saveAnnouncementReq.getPublishType());
        newsAnnouncement.setPublishId(saveAnnouncementReq.getPublishId());
        newsAnnouncement.setPublishName(saveAnnouncementReq.getPublishName());
        if (NewsAnnouncementPublishTypeEnum.NONE.getCode().equals(saveAnnouncementReq.getPublishType())) {
            newsAnnouncement.setPublishName("");
            newsAnnouncement.setPublishId("");
        }
        newsAnnouncement.setNewsTitle(saveAnnouncementReq.getNewsTitle());
        newsAnnouncement.setNewsTypeId(saveAnnouncementReq.getNewsTypeId());
        newsAnnouncement.setNewsTypePath(NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(saveAnnouncementReq.getParentNewsTypeId()) ? String.valueOf(saveAnnouncementReq.getNewsTypeId()) : saveAnnouncementReq.getParentNewsTypeId() + "-" + saveAnnouncementReq.getNewsTypeId());
        newsAnnouncement.setNewsStatus(saveAnnouncementReq.getNewsStatus());
        newsAnnouncement.setNewsEffectiveTime(saveAnnouncementReq.getNewsEffectiveTime());
        newsAnnouncement.setNewsEndTime(saveAnnouncementReq.getNewsEndTime());
        newsAnnouncement.setSummary(saveAnnouncementReq.getSummary());
        newsAnnouncement.setNewsChannel(saveAnnouncementReq.getNewsChannel());
        newsAnnouncement.setDefaultImageIcon(saveAnnouncementReq.getDefaultImageIcon());
        newsAnnouncement.setCoverImageId(saveAnnouncementReq.getCoverImageId());
        newsAnnouncement.setNoticeFlag(saveAnnouncementReq.getNoticeFlag());
        newsAnnouncement.setNewsContent(saveAnnouncementReq.getNewsContent());
        if (CollectionUtils.isNotEmpty((Collection)saveAnnouncementReq.getFileIdList())) {
            List fileList = saveAnnouncementReq.getFileIdList().stream().filter(ObjectUtils::isNotEmpty).collect(Collectors.toList());
            newsAnnouncement.setFileId(String.join((CharSequence)",", fileList));
        } else {
            newsAnnouncement.setFileId("");
        }
    }

    private Map<Long, NewsAnnouncementType> queryNewsTypeByNewsList(List<NewsAnnouncement> newsAnnouncementList) {
        HashSet newsTypeIdSet = Sets.newHashSet();
        for (NewsAnnouncement x : newsAnnouncementList) {
            if (StringUtils.isNotBlank((CharSequence)x.getNewsTypePath())) {
                newsTypeIdSet.addAll(Arrays.stream(x.getNewsTypePath().split("-")).map(Long::parseLong).collect(Collectors.toList()));
                continue;
            }
            newsTypeIdSet.add(x.getNewsTypeId());
        }
        List newsAnnouncementTypes = (List)InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementTypeMapper.selectBatchIds(new ArrayList(newsTypeIdSet)));
        return newsAnnouncementTypes.stream().collect(Collectors.toMap(NewsAnnouncementType::getId, Function.identity(), (a, b) -> a));
    }

    private String getNewsTypeNameByNewPath(Map<Long, NewsAnnouncementType> newsTypeMap, NewsAnnouncement newsAnnouncement) {
        String newsTypePath = StringUtils.isNotBlank((CharSequence)newsAnnouncement.getNewsTypePath()) ? newsAnnouncement.getNewsTypePath() : newsAnnouncement.getNewsTypeId().toString();
        StringBuilder newsTypeName = new StringBuilder();
        String[] split = newsTypePath.split("-");
        for (int i = 0; i < split.length; ++i) {
            long newsTypeId = Long.parseLong(split[i]);
            NewsAnnouncementType x = newsTypeMap.get(newsTypeId);
            String tempTypeName = ObjectUtils.isNotEmpty((Object)x) && StringUtils.isNotBlank((CharSequence)x.getName()) ? x.getName() : "\u5176\u4ed6";
            newsTypeName.append(tempTypeName).append("/");
        }
        if (newsTypeName.length() > 0) {
            newsTypeName.deleteCharAt(newsTypeName.length() - 1);
        }
        return newsTypeName.toString();
    }

    public PageInfoResp<NewsAnnouncementVO> queryUserNewsList(WebQueryNewsListPageReq webQueryNewsListPageReq) {
        List newsTypeIdList = webQueryNewsListPageReq.getNewsTypeIdList();
        if (webQueryNewsListPageReq.getPageNum() == null) {
            webQueryNewsListPageReq.setPageNum(Integer.valueOf(1));
        }
        if (webQueryNewsListPageReq.getPageSize() == null) {
            webQueryNewsListPageReq.setPageSize(Integer.valueOf(10));
        }
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setPageSize(webQueryNewsListPageReq.getPageSize().intValue());
        pageInfoResp.setPageNo(webQueryNewsListPageReq.getPageNum().intValue());
        List thirdNewsList = this.queryThirdNewsList(newsTypeIdList);
        List autList = this.newsAnnouncementAuthService.queryAuthNewsListByNewsTypeIdList(newsTypeIdList);
        if (CollectionUtils.isEmpty((Collection)autList) && CollectionUtils.isEmpty((Collection)thirdNewsList)) {
            return pageInfoResp;
        }
        String nowTime = DateUtils.getNowTime();
        List newsIdDistinctList = autList.stream().map(NewsAnnouncementAut::getNewsId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)thirdNewsList)) {
            newsIdDistinctList.addAll(thirdNewsList.stream().map(NewsAnnouncement::getId).distinct().collect(Collectors.toList()));
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(NewsAnnouncement::getNewsChannel, (Collection)Lists.newArrayList((Object[])new Integer[]{Constants.NewsChannelFlagEnum.ALL.getFlag(), Constants.NewsChannelFlagEnum.WEB.getFlag()}));
        queryWrapper.eq(NewsAnnouncement::getNewsStatus, (Object)Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag());
        queryWrapper.lt(NewsAnnouncement::getNewsEffectiveTime, (Object)nowTime);
        queryWrapper.gt(NewsAnnouncement::getNewsEndTime, (Object)nowTime);
        queryWrapper.in(CollectionUtils.isNotEmpty((Collection)newsTypeIdList), NewsAnnouncement::getNewsTypeId, (Collection)newsTypeIdList);
        queryWrapper.in(NewsAnnouncement::getId, newsIdDistinctList);
        queryWrapper.select(NewsAnnouncement.class, info -> !info.getColumn().equals("news_content"));
        queryWrapper.orderByDesc(NewsAnnouncement::getToppedTime);
        queryWrapper.orderByDesc(NewsAnnouncement::getNewsEffectiveTime);
        queryWrapper.orderByDesc(NewsAnnouncement::getId);
        IPage newsAnnouncementPage = (IPage)InterceptorIgnoreUtil.handler(() -> (Page)this.newsAnnouncementMapper.selectPage((IPage)new Page((long)webQueryNewsListPageReq.getPageNum().intValue(), (long)webQueryNewsListPageReq.getPageSize().intValue()), (Wrapper)queryWrapper));
        List newsAnnouncementList = newsAnnouncementPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)newsAnnouncementList)) {
            return pageInfoResp;
        }
        Map fileIdMap = this.queryFileInfoList(newsAnnouncementList);
        List newIdList = newsAnnouncementList.stream().map(NewsAnnouncement::getId).collect(Collectors.toList());
        List<Object> readNewsIdList = Lists.newArrayList();
        Map newsTypeMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(newIdList)) {
            List readList = this.newsAnnouncementReadMapper.selectNewsAnnouncementReadList(newIdList);
            readNewsIdList = readList.stream().filter(x -> Utils.getUserId().equals(x.getCreateUserId())).map(NewsAnnouncementRead::getNewsId).collect(Collectors.toList());
            newsTypeMap = this.queryNewsTypeByNewsList(newsAnnouncementList);
        }
        ArrayList newsAnnouncementVOList = Lists.newArrayList();
        Map likeNewsIdMap = this.getNewsLikeMap(newsAnnouncementList);
        for (NewsAnnouncement x2 : newsAnnouncementList) {
            List fileList;
            NewsAnnouncementVO newsAnnouncementVO = (NewsAnnouncementVO)this.converter.convert((Object)x2, NewsAnnouncementVO.class);
            if (StringUtils.isNotBlank((CharSequence)x2.getFileId()) && MapUtils.isNotEmpty((Map)fileIdMap)) {
                fileList = this.buildDetailFileInfo(x2.getFileId().split(","), fileIdMap);
                newsAnnouncementVO.setFileList(fileList);
            }
            if (StringUtils.isNotBlank((CharSequence)x2.getCoverImageId()) && MapUtils.isNotEmpty((Map)fileIdMap)) {
                fileList = this.buildDetailFileInfo(x2.getCoverImageId().split(","), fileIdMap);
                newsAnnouncementVO.setCoverImageInfo((FileInfoVO)fileList.get(0));
            }
            if (StringUtils.isNotBlank((CharSequence)x2.getDefaultImageIcon())) {
                newsAnnouncementVO.setDefaultImageIcon(this.envProperties.getSemcWebUrl() + x2.getDefaultImageIcon());
            }
            newsAnnouncementVO.setNewsTypeName(this.getNewsTypeNameByNewPath(newsTypeMap, x2));
            newsAnnouncementVO.setReadFlag(Boolean.valueOf(CollectionUtils.isNotEmpty((Collection)readNewsIdList) && readNewsIdList.contains(x2.getId())));
            newsAnnouncementVO.setLikeFlag(Boolean.valueOf(Boolean.TRUE.equals(likeNewsIdMap.get(x2.getId()))));
            newsAnnouncementVOList.add(newsAnnouncementVO);
        }
        this.buildNewsReadUserList((List)newsAnnouncementVOList, false, false);
        pageInfoResp.setList((List)newsAnnouncementVOList);
        pageInfoResp.setTotalRecords((int)newsAnnouncementPage.getTotal());
        pageInfoResp.setTotalPages((int)newsAnnouncementPage.getPages());
        return pageInfoResp;
    }

    public List<NewsAnnouncement> queryThirdNewsList(List<Long> newsTypeIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncement::getTenantId, (Object)Utils.getTenantId());
        queryWrapper.eq(NewsAnnouncement::getNewsStatus, (Object)Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag());
        queryWrapper.gt(NewsAnnouncement::getNewsEndTime, (Object)DateUtils.getNowTime());
        queryWrapper.eq(NewsAnnouncement::getNewsSource, (Object)Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType());
        if (CollectionUtils.isNotEmpty(newsTypeIdList)) {
            queryWrapper.in(NewsAnnouncement::getNewsTypeId, newsTypeIdList);
        }
        queryWrapper.select(NewsAnnouncement.class, info -> !info.getColumn().equals("news_content"));
        List thirdNewsList = (List)InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementMapper.selectList((Wrapper)queryWrapper));
        if (CollectionUtils.isNotEmpty((Collection)thirdNewsList)) {
            List newsAnnouncements = this.thirdNewsAnnouncementService.buildThirdNewSWithSSO(thirdNewsList);
            return newsAnnouncements;
        }
        return Lists.newArrayList();
    }

    public NewsAnnouncementVO queryUserNewsDetail(NewsAnnouncement newsAnnouncement, Integer callSource) {
        Long count;
        LambdaQueryWrapper queryWrapper;
        AuthoredUser authoredUser;
        List fileList;
        boolean isMobile = Integer.valueOf(0).equals(callSource) || callSource == null;
        NewsAnnouncementVO newsAnnouncementVO = (NewsAnnouncementVO)this.converter.convert((Object)newsAnnouncement, NewsAnnouncementVO.class);
        Map newsTypeMap = this.queryNewsTypeByNewsList((List)Lists.newArrayList((Object[])new NewsAnnouncement[]{newsAnnouncement}));
        newsAnnouncementVO.setNewsTypeName(this.getNewsTypeNameByNewPath(newsTypeMap, newsAnnouncement));
        Map fileIdMap = this.queryFileInfoList(Collections.singletonList(newsAnnouncement));
        if (StringUtils.isNotBlank((CharSequence)newsAnnouncement.getFileId()) && MapUtils.isNotEmpty((Map)fileIdMap)) {
            fileList = this.buildDetailFileInfo(newsAnnouncement.getFileId().split(","), fileIdMap);
            newsAnnouncementVO.setFileList(fileList);
        }
        if (StringUtils.isNotBlank((CharSequence)newsAnnouncement.getCoverImageId())) {
            fileList = this.buildDetailFileInfo(newsAnnouncement.getCoverImageId().split(","), fileIdMap);
            newsAnnouncementVO.setCoverImageInfo((FileInfoVO)fileList.get(0));
        }
        this.buildNewsReadUserList(Collections.singletonList(newsAnnouncementVO), isMobile, false);
        newsAnnouncementVO.setLikeFlag(Boolean.valueOf(false));
        if (newsAnnouncementVO.getLikeCount() != null && newsAnnouncementVO.getLikeCount() > 0) {
            authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(NewsAnnouncementLike::getNewsId, (Object)newsAnnouncement.getId());
            queryWrapper.eq(NewsAnnouncementLike::getCreateUserSid, (Object)authoredUser.getSid());
            count = this.newsAnnouncementLikeMapper.selectCount((Wrapper)queryWrapper);
            newsAnnouncementVO.setLikeFlag(Boolean.valueOf(count != null && count > 0L));
            if (isMobile) {
                newsAnnouncementVO.setLikeList((List)this.getNewLikeUserList((Long)newsAnnouncement.getId())._1);
            }
        }
        newsAnnouncementVO.setFavoriteFlag(Boolean.valueOf(false));
        if (newsAnnouncementVO.getFavoriteCount() != null && newsAnnouncementVO.getFavoriteCount() > 0) {
            authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(NewsAnnouncementFavorite::getNewsId, (Object)newsAnnouncement.getId());
            queryWrapper.eq(NewsAnnouncementFavorite::getCreateUserSid, (Object)authoredUser.getSid());
            count = this.newsAnnouncementFavoriteMapper.selectCount((Wrapper)queryWrapper);
            newsAnnouncementVO.setFavoriteFlag(Boolean.valueOf(count != null && count > 0L));
        }
        return newsAnnouncementVO;
    }

    private Tuple2<List<UserDTO>, List<NewsAnnouncementLike>> getNewLikeUserList(Long newsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncementLike::getNewsId, (Object)newsId);
        queryWrapper.orderByDesc(NewsAnnouncementLike::getId);
        List newsAnnouncementLikeList = (List)InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementLikeMapper.selectList((Wrapper)queryWrapper));
        List likeUserList = newsAnnouncementLikeList.stream().map(newsAnnouncementLike -> {
            UserDTO userDTO = new UserDTO();
            if (StringUtils.isNotBlank((CharSequence)newsAnnouncementLike.getThirdNewsId()) && StringUtils.isNotBlank((CharSequence)newsAnnouncementLike.getThirdUserId())) {
                userDTO.setId(newsAnnouncementLike.getThirdUserId());
                userDTO.setName(newsAnnouncementLike.getThirdUserId());
            } else {
                userDTO.setId(newsAnnouncementLike.getCreateUserId());
                userDTO.setName(newsAnnouncementLike.getCreateUserName());
            }
            userDTO.setSid(newsAnnouncementLike.getCreateUserSid());
            return userDTO;
        }).collect(Collectors.toList());
        return new Tuple2(likeUserList, (Object)newsAnnouncementLikeList);
    }

    public NewsAnnouncement queryUserNewsById(Long id) {
        return this.newsAnnouncementMapper.selectNewsAnnouncementById(id);
    }

    public ValidateNewsVO validateNews(Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NewsAnnouncement::getId, (Object)id);
        queryWrapper.select(NewsAnnouncement.class, info -> !info.getColumn().equals("news_content"));
        NewsAnnouncement newsAnnouncement = (NewsAnnouncement)InterceptorIgnoreUtil.handler(() -> (NewsAnnouncement)this.newsAnnouncementMapper.selectOne((Wrapper)queryWrapper));
        ValidateNewsVO validateNewsVO = new ValidateNewsVO();
        validateNewsVO.setCode("1000");
        if (ObjectUtils.isEmpty((Object)newsAnnouncement)) {
            validateNewsVO.setCode("1001");
            return validateNewsVO;
        }
        validateNewsVO.setNewsAnnouncement(newsAnnouncement);
        if (Arrays.asList(Constants.NewsAnnouncementStatusEnum.UNPUBLISHED.getFlag(), Constants.NewsAnnouncementStatusEnum.EXPIRED.getFlag()).contains(newsAnnouncement.getNewsStatus()) || LocalDateTime.now().compareTo(LocalDateTime.parse(newsAnnouncement.getNewsEndTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))) > 0) {
            validateNewsVO.setCode("1002");
            return validateNewsVO;
        }
        if (Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(newsAnnouncement.getNewsSource())) {
            return validateNewsVO;
        }
        validateNewsVO.setNewsAnnouncement(newsAnnouncement);
        LambdaQueryWrapper authQueryWrapper = new LambdaQueryWrapper();
        authQueryWrapper.eq(NewsAnnouncementAut::getNewsId, (Object)id);
        authQueryWrapper.select(new SFunction[]{NewsAnnouncementAut::getAllAuthFlag, NewsAnnouncementAut::getAuthId});
        List authList = this.newsAnnouncementAuthMapper.selectList((Wrapper)authQueryWrapper);
        boolean anyMatch = authList.stream().anyMatch(m -> Constants.NEWS_ALL_AUTH_FLAG_YES.equals(m.getAllAuthFlag()));
        if (anyMatch) {
            return validateNewsVO;
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        Long userSid = authoredUser.getSid();
        anyMatch = authList.stream().anyMatch(m -> userSid.equals(m.getAuthId()));
        if (anyMatch) {
            return validateNewsVO;
        }
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());
        if (iamUserAuthInfo == null) {
            validateNewsVO.setCode("1003");
            return validateNewsVO;
        }
        if (iamUserAuthInfo.getRoleSids() == null) {
            iamUserAuthInfo.setRoleSids((List)Lists.newArrayList());
        }
        if (iamUserAuthInfo.getOrgSids() == null) {
            iamUserAuthInfo.setOrgSids((List)Lists.newArrayList());
        }
        if (iamUserAuthInfo.getDeptSids() == null) {
            iamUserAuthInfo.setDeptSids((List)Lists.newArrayList());
        }
        for (NewsAnnouncementAut newsAnnouncementAut : authList) {
            anyMatch = iamUserAuthInfo.getRoleSids().stream().anyMatch(m -> m.equals(newsAnnouncementAut.getAuthId()));
            if (anyMatch) {
                return validateNewsVO;
            }
            anyMatch = iamUserAuthInfo.getOrgSids().stream().anyMatch(m -> m.equals(newsAnnouncementAut.getAuthId()));
            if (anyMatch) {
                return validateNewsVO;
            }
            anyMatch = iamUserAuthInfo.getDeptSids().stream().anyMatch(m -> m.equals(newsAnnouncementAut.getAuthId()));
            if (!anyMatch) continue;
            return validateNewsVO;
        }
        validateNewsVO.setCode("1003");
        return validateNewsVO;
    }

    public Map<Long, ValidateNewsVO> validateNews(List<Long> idList) {
        AuthoredUser authoredUser;
        IamUserAuthInfo iamUserAuthInfo;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(NewsAnnouncement::getId, idList);
        queryWrapper.select(NewsAnnouncement.class, info -> !info.getColumn().equals("news_content"));
        List newsList = (List)InterceptorIgnoreUtil.handler(() -> this.newsAnnouncementMapper.selectList((Wrapper)queryWrapper));
        if (CollectionUtils.isEmpty((Collection)newsList)) {
            return Maps.newHashMap();
        }
        HashMap resultMap = Maps.newHashMap();
        Map newsMap = newsList.stream().collect(Collectors.toMap(NewsAnnouncement::getId, Function.identity(), (a, b) -> a));
        LambdaQueryWrapper authQueryWrapper = new LambdaQueryWrapper();
        authQueryWrapper.in(NewsAnnouncementAut::getNewsId, idList);
        authQueryWrapper.select(new SFunction[]{NewsAnnouncementAut::getAllAuthFlag, NewsAnnouncementAut::getAuthId, NewsAnnouncementAut::getNewsId});
        List authAllList = this.newsAnnouncementAuthMapper.selectList((Wrapper)authQueryWrapper);
        Map<Object, Object> authMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)authAllList)) {
            authMap = authAllList.stream().collect(Collectors.groupingBy(NewsAnnouncementAut::getNewsId));
        }
        if ((iamUserAuthInfo = this.iamUserService.getUserAuthSids((authoredUser = AppAuthContextHolder.getContext().getAuthoredUser()).getUserId(), authoredUser.getTenantId(), authoredUser.getToken())) != null) {
            if (iamUserAuthInfo.getRoleSids() == null) {
                iamUserAuthInfo.setRoleSids((List)Lists.newArrayList());
            }
            if (iamUserAuthInfo.getOrgSids() == null) {
                iamUserAuthInfo.setOrgSids((List)Lists.newArrayList());
            }
            if (iamUserAuthInfo.getDeptSids() == null) {
                iamUserAuthInfo.setDeptSids((List)Lists.newArrayList());
            }
        }
        for (Long newId : idList) {
            NewsAnnouncement newsAnnouncement = (NewsAnnouncement)newsMap.get(newId);
            ValidateNewsVO validateNewsVO = new ValidateNewsVO();
            validateNewsVO.setNewsAnnouncement(newsAnnouncement);
            validateNewsVO.setCode("1000");
            if (newsAnnouncement == null) {
                validateNewsVO.setCode("1001");
                resultMap.put(newId, validateNewsVO);
                continue;
            }
            if (Arrays.asList(Constants.NewsAnnouncementStatusEnum.UNPUBLISHED.getFlag(), Constants.NewsAnnouncementStatusEnum.EXPIRED.getFlag()).contains(newsAnnouncement.getNewsStatus()) || LocalDateTime.now().compareTo(LocalDateTime.parse(newsAnnouncement.getNewsEndTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))) > 0) {
                validateNewsVO.setCode("1002");
                resultMap.put(newId, validateNewsVO);
                continue;
            }
            if (Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(newsAnnouncement.getNewsSource())) {
                resultMap.put(newId, validateNewsVO);
                continue;
            }
            List authList = authMap.getOrDefault(newId, Lists.newArrayList());
            boolean anyMatch = authList.stream().anyMatch(m -> Constants.NEWS_ALL_AUTH_FLAG_YES.equals(m.getAllAuthFlag()));
            if (anyMatch) {
                resultMap.put(newId, validateNewsVO);
                continue;
            }
            Long userSid = authoredUser.getSid();
            anyMatch = authList.stream().anyMatch(m -> userSid.equals(m.getAuthId()));
            if (anyMatch) {
                resultMap.put(newId, validateNewsVO);
                continue;
            }
            if (iamUserAuthInfo == null) {
                validateNewsVO.setCode("1003");
                resultMap.put(newId, validateNewsVO);
                continue;
            }
            boolean isBreak = false;
            for (NewsAnnouncementAut newsAnnouncementAut : authList) {
                anyMatch = iamUserAuthInfo.getRoleSids().stream().anyMatch(m -> m.equals(newsAnnouncementAut.getAuthId()));
                if (anyMatch) {
                    resultMap.put(newId, validateNewsVO);
                    isBreak = true;
                    break;
                }
                anyMatch = iamUserAuthInfo.getOrgSids().stream().anyMatch(m -> m.equals(newsAnnouncementAut.getAuthId()));
                if (anyMatch) {
                    resultMap.put(newId, validateNewsVO);
                    isBreak = true;
                    break;
                }
                anyMatch = iamUserAuthInfo.getDeptSids().stream().anyMatch(m -> m.equals(newsAnnouncementAut.getAuthId()));
                if (!anyMatch) continue;
                resultMap.put(newId, validateNewsVO);
                isBreak = true;
                break;
            }
            if (isBreak) continue;
            validateNewsVO.setCode("1003");
            resultMap.put(newId, validateNewsVO);
        }
        return resultMap;
    }

    public Integer queryNewsUnReadCount() {
        List autList = this.newsAnnouncementAuthService.queryAuthNewsList();
        if (CollectionUtils.isEmpty((Collection)autList)) {
            return 0;
        }
        List newsIdDistinctList = autList.stream().map(NewsAnnouncementAut::getNewsId).distinct().collect(Collectors.toList());
        List newsAnnouncementList = this.newsAnnouncementMapper.selectNewsAnnouncementIdList(Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag(), newsIdDistinctList, null, DateUtils.getNowTime(null));
        newsAnnouncementList.addAll(this.queryThirdNewsList(null));
        if (CollectionUtils.isEmpty((Collection)newsAnnouncementList)) {
            return 0;
        }
        List idList = newsAnnouncementList.stream().map(NewsAnnouncement::getId).collect(Collectors.toList());
        LambdaQueryWrapper readCondition = new LambdaQueryWrapper();
        readCondition.in(NewsAnnouncementRead::getNewsId, idList);
        readCondition.eq(BaseEntity::getCreateUserId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        Long readCount = this.newsAnnouncementReadMapper.selectCount((Wrapper)readCondition);
        if (readCount == null || readCount <= 0L) {
            return newsAnnouncementList.size();
        }
        return newsAnnouncementList.size() - readCount.intValue();
    }

    public List<JSONObject> queryNewsAppList() {
        List thirdNewsAppCodeList;
        ArrayList list = Lists.newArrayList();
        QueryWrapper condition = new QueryWrapper();
        condition.select(new String[]{"id", "news_title", "news_source", "third_news_id", "third_app_id", "third_app_code"});
        ((QueryWrapper)condition.orderByDesc((Object)"topped_time")).orderByDesc((Object)"create_time");
        condition.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        List newsAnnouncementList = this.newsAnnouncementMapper.selectList((Wrapper)condition);
        if (CollectionUtils.isEmpty((Collection)newsAnnouncementList)) {
            return list;
        }
        boolean flag = newsAnnouncementList.stream().anyMatch(x -> Constants.ThirdNewsAnnouncementEnum.INSIDER_INFORMATION.getType().equals(x.getNewsSource()));
        if (flag) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("appCode", (Object)VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getCode());
            jsonObject.put("appName", (Object)VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getName());
            list.add(jsonObject);
        }
        if (CollectionUtils.isNotEmpty(thirdNewsAppCodeList = newsAnnouncementList.stream().filter(x -> Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType().equals(x.getNewsSource()) && StringUtils.isNotBlank((CharSequence)x.getThirdAppCode())).map(NewsAnnouncement::getThirdAppCode).distinct().collect(Collectors.toList()))) {
            List appLinkList = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
            Map<String, String> appCodeMap = appLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getCode, AppLinkDTO::getName, (a, b) -> a));
            for (String appCode : thirdNewsAppCodeList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("appCode", (Object)appCode);
                jsonObject.put("appName", (Object)appCodeMap.get(appCode));
                list.add(jsonObject);
            }
        }
        return list;
    }

    public PageInfoResp<NewsAnnouncementVO> queryMobileNewsListPage(QueryMobileNewsListPageReq queryMobileNewsListPageReq) {
        List autList;
        PageInfoResp pageInfoResp = new PageInfoResp();
        ArrayList<Long> newsTypeIdList = queryMobileNewsListPageReq.getNewsTypeIdList();
        if (queryMobileNewsListPageReq.getPageNum() == null) {
            queryMobileNewsListPageReq.setPageNum(Integer.valueOf(1));
        }
        if (queryMobileNewsListPageReq.getPageSize() == null) {
            queryMobileNewsListPageReq.setPageSize(Integer.valueOf(10));
        }
        if (CollectionUtils.isEmpty((Collection)newsTypeIdList) && null != queryMobileNewsListPageReq.getNewsTypeId()) {
            newsTypeIdList = new ArrayList<Long>();
            List announcementTypeList = this.newsAnnouncementTypeMapper.queryByParentId(queryMobileNewsListPageReq.getNewsTypeId());
            if (CollectionUtils.isEmpty((Collection)announcementTypeList)) {
                newsTypeIdList.add(queryMobileNewsListPageReq.getNewsTypeId());
            } else {
                List chirenTypeIdList = announcementTypeList.stream().map(NewsAnnouncementType::getId).distinct().collect(Collectors.toList());
                newsTypeIdList.addAll(chirenTypeIdList);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(autList = this.newsAnnouncementAuthService.queryAuthNewsListByNewsTypeIdList((List)newsTypeIdList)))) {
            return pageInfoResp;
        }
        List newsIdDistinctList = autList.stream().map(NewsAnnouncementAut::getNewsId).distinct().collect(Collectors.toList());
        String currentTime = DateUtils.getNowTime(null);
        Integer count = this.newsAnnouncementMapper.queryMobileUserNewsListCount(newsIdDistinctList, queryMobileNewsListPageReq, Utils.getTenantId(), currentTime);
        if (count == 0) {
            return pageInfoResp;
        }
        Integer startNum = (queryMobileNewsListPageReq.getPageNum() - 1) * queryMobileNewsListPageReq.getPageSize();
        List newsAnnouncementList = this.newsAnnouncementMapper.queryMobileUserNewsListPage(newsIdDistinctList, queryMobileNewsListPageReq, startNum, queryMobileNewsListPageReq.getPageSize(), Utils.getTenantId(), currentTime);
        List newIdList = newsAnnouncementList.stream().map(NewsAnnouncement::getId).collect(Collectors.toList());
        List<Object> newsIdList = Lists.newArrayList();
        Map<Object, Object> newsReadMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(newIdList)) {
            List readList = this.newsAnnouncementReadMapper.selectNewsAnnouncementReadList(newIdList);
            newsReadMap = readList.stream().collect(Collectors.groupingBy(NewsAnnouncementRead::getNewsId));
            newsIdList = readList.stream().filter(x -> Utils.getUserId().equals(x.getCreateUserId())).map(NewsAnnouncementRead::getNewsId).collect(Collectors.toList());
        }
        Map likeNewsIdMap = this.getNewsLikeMap(newsAnnouncementList);
        Map fileIdMap = this.queryFileInfoList(newsAnnouncementList);
        ArrayList newsAnnouncementVOList = Lists.newArrayList();
        for (NewsAnnouncement x2 : newsAnnouncementList) {
            NewsAnnouncementVO newsAnnouncementVO = (NewsAnnouncementVO)this.converter.convert((Object)x2, NewsAnnouncementVO.class);
            if (StringUtils.isNotBlank((CharSequence)x2.getDefaultImageIcon())) {
                newsAnnouncementVO.setDefaultImageIcon(this.envProperties.getSemcWebUrl() + x2.getDefaultImageIcon());
            }
            if (StringUtils.isNotBlank((CharSequence)x2.getCoverImageId()) && MapUtils.isNotEmpty((Map)fileIdMap)) {
                List fileList = this.buildDetailFileInfo(x2.getCoverImageId().split(","), fileIdMap);
                newsAnnouncementVO.setCoverImageInfo((FileInfoVO)fileList.get(0));
            }
            newsAnnouncementVO.setReadFlag(Boolean.valueOf(CollectionUtils.isNotEmpty((Collection)newsIdList) && newsIdList.contains(x2.getId())));
            List newsAnnouncementReadList = (List)newsReadMap.get(x2.getId());
            newsAnnouncementVO.setReadCount(Integer.valueOf(CollectionUtils.isNotEmpty((Collection)newsAnnouncementReadList) ? newsAnnouncementReadList.size() : 0));
            if (NewsAnnouncementPublishTypeEnum.NONE.getCode().equals(x2.getPublishType())) {
                newsAnnouncementVO.setPublishId("");
                newsAnnouncementVO.setPublishName("");
            }
            newsAnnouncementVO.setLikeFlag(Boolean.valueOf(Boolean.TRUE.equals(likeNewsIdMap.get(x2.getId()))));
            newsAnnouncementVOList.add(newsAnnouncementVO);
        }
        int totalPages = count % queryMobileNewsListPageReq.getPageSize() == 0 ? count / queryMobileNewsListPageReq.getPageSize() : count / queryMobileNewsListPageReq.getPageSize() + 1;
        pageInfoResp.setTotalPages(totalPages);
        pageInfoResp.setPageNo(queryMobileNewsListPageReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryMobileNewsListPageReq.getPageSize().intValue());
        pageInfoResp.setTotalRecords(count.intValue());
        pageInfoResp.setList((List)newsAnnouncementVOList);
        return pageInfoResp;
    }

    private Map<Long, Boolean> getNewsLikeMap(List<NewsAnnouncement> newsAnnouncementList) {
        List likeNewsIdList = newsAnnouncementList.stream().filter(m -> m.getLikeCount() != null && m.getLikeCount() > 0).map(NewsAnnouncement::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(likeNewsIdList)) {
            return Maps.newHashMap();
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(NewsAnnouncementLike::getNewsId, likeNewsIdList);
        queryWrapper.eq(NewsAnnouncementLike::getCreateUserSid, (Object)authoredUser.getSid());
        queryWrapper.select(new SFunction[]{NewsAnnouncementLike::getNewsId});
        List newsAnnouncementLikeList = this.newsAnnouncementLikeMapper.selectList((Wrapper)queryWrapper);
        return newsAnnouncementLikeList.stream().collect(Collectors.toMap(NewsAnnouncementLike::getNewsId, n -> Boolean.TRUE));
    }

    public List<NewsAnnouncement> queryNewsListByCondition(QueryNewsListPageReq queryNewsListPageReq) {
        String currentTime = DateUtils.getNowTime(null);
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        return this.newsAnnouncementMapper.queryNewsListByCondition(currentTime, tenantId, queryNewsListPageReq.getNewsChannelList(), queryNewsListPageReq.getNewsSource());
    }

    public NewsAnnouncementStatisticsVO queryManagerNewsStatistics(NewsStatisticsReqDTO newsStatisticsReqDTO) {
        Long id = newsStatisticsReqDTO.getId();
        NewsAnnouncement newsAnnouncement = (NewsAnnouncement)this.newsAnnouncementMapper.selectById((Serializable)id);
        if (ObjectUtils.isEmpty((Object)newsAnnouncement)) {
            return null;
        }
        ArrayList newsAnnouncementVOList = Lists.newArrayList((Object[])new NewsAnnouncementVO[]{(NewsAnnouncementVO)this.converter.convert((Object)newsAnnouncement, NewsAnnouncementVO.class)});
        this.buildNewsReadUserList((List)newsAnnouncementVOList, true, true);
        NewsAnnouncementVO newsAnnouncementVO = (NewsAnnouncementVO)newsAnnouncementVOList.get(0);
        NewsAnnouncementStatisticsVO newsAnnouncementStatisticsVO = new NewsAnnouncementStatisticsVO();
        newsAnnouncementStatisticsVO.setId(id);
        newsAnnouncementStatisticsVO.setReadCount(newsAnnouncementVO.getReadCount());
        newsAnnouncementStatisticsVO.setReadList(newsAnnouncementVO.getReadList());
        newsAnnouncementStatisticsVO.setUnReadCount(newsAnnouncementVO.getUnReadCount());
        newsAnnouncementStatisticsVO.setUnReadList(newsAnnouncementVO.getUnReadList());
        newsAnnouncementStatisticsVO.setLikeCount(newsAnnouncementVO.getLikeCount());
        newsAnnouncementStatisticsVO.setLikeList((List)Lists.newArrayList());
        if (newsAnnouncementVO.getLikeCount() != null && newsAnnouncementVO.getLikeCount() > 0) {
            Tuple2 tuple2 = this.getNewLikeUserList(newsAnnouncement.getId());
            newsAnnouncementStatisticsVO.setLikeList((List)tuple2._1);
        }
        newsAnnouncementStatisticsVO.setLikeCount(Integer.valueOf(CollectionUtils.isNotEmpty((Collection)newsAnnouncementStatisticsVO.getLikeList()) ? newsAnnouncementStatisticsVO.getLikeList().size() : 0));
        return newsAnnouncementStatisticsVO;
    }

    /*
     * WARNING - void declaration
     */
    public void sendNewsNotice(SendNoticeEvent event) {
        SendNoticeDTO sendNoticeDTO = event.getSendNoticeDTO();
        List<Object> allUserIdList = Lists.newArrayList();
        List<UserDTO> externalUserList = Lists.newArrayList();
        if (Constants.NEWS_ALL_AUTH_FLAG_YES.equals(sendNoticeDTO.getAllAuthFlag())) {
            List roleList = this.iamService.queryEnabledUserList();
            allUserIdList = roleList.stream().filter(x -> Constants.NUMBER_ZERO.equals(x.getUserType())).map(RoleDTO::getId).collect(Collectors.toList());
            boolean flag = this.commonConfigService.querySendNewsNoticeOuterFlag();
            if (flag) {
                List list = roleList.stream().filter(x -> Constants.NUMBER_ONE.equals(x.getUserType())).map(RoleDTO::getSid).collect(Collectors.toList());
                externalUserList = this.queryExternalUserList(list);
            }
        } else {
            boolean flag;
            List userIdList;
            if (CollectionUtils.isNotEmpty((Collection)sendNoticeDTO.getOrgSidList())) {
                List orgUserList = this.iamService.queryUserByAllOrgSidList(sendNoticeDTO.getOrgSidList());
                for (OrgRoleUserDTO orgRoleUserDTO : orgUserList) {
                    userIdList = orgRoleUserDTO.getUsers().stream().map(UserDTO::getId).collect(Collectors.toList());
                    allUserIdList.addAll(userIdList);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)sendNoticeDTO.getRoleSidList())) {
                List roleUserList = this.iamService.queryUserByAllRoleSidList(sendNoticeDTO.getRoleSidList());
                for (OrgRoleUserDTO orgRoleUserDTO : roleUserList) {
                    userIdList = orgRoleUserDTO.getUsers().stream().map(UserDTO::getId).collect(Collectors.toList());
                    allUserIdList.addAll(userIdList);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)sendNoticeDTO.getDeptSidList())) {
                List deptUserList = this.eocService.queryUserByDeptSidList(sendNoticeDTO.getDeptSidList());
                for (UserDeptInfoDTO userDeptInfoDTO : deptUserList) {
                    userIdList = userDeptInfoDTO.getEmps().stream().map(y -> y.getEmpUserId()).collect(Collectors.toList());
                    allUserIdList.addAll(userIdList);
                }
            }
            if (MapUtils.isNotEmpty((Map)sendNoticeDTO.getUserSidMap())) {
                ArrayList sidList = Lists.newArrayList();
                for (Map.Entry entry : sendNoticeDTO.getUserSidMap().entrySet()) {
                    if (ObjectUtils.isEmpty(entry.getValue())) {
                        sidList.add(entry.getKey());
                        continue;
                    }
                    allUserIdList.add(entry.getValue());
                }
                if (CollectionUtils.isNotEmpty((Collection)sidList)) {
                    void var7_20;
                    CompletableFuture[] completableFutures = new CompletableFuture[sidList.size()];
                    boolean bl = false;
                    while (var7_20 < sidList.size()) {
                        Long sid = (Long)sidList.get((int)var7_20);
                        completableFutures[var7_20] = CompletableFuture.supplyAsync(() -> this.iamService.queryUser(null, sid, Utils.getUserToken()), this.asyncTaskExecutor);
                        ++var7_20;
                    }
                    CompletableFuture.allOf(completableFutures).join();
                    for (CompletableFuture completableFuture : completableFutures) {
                        try {
                            UserInfoDTO userInfoDTO = (UserInfoDTO)completableFuture.get();
                            allUserIdList.add(userInfoDTO.getId());
                        }
                        catch (Exception e) {
                            log.error("iamService | query user error\uff1a{}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }
            }
            if (MapUtils.isNotEmpty((Map)sendNoticeDTO.getExternalUserSidMap()) && (flag = this.commonConfigService.querySendNewsNoticeOuterFlag())) {
                ArrayList sidList = Lists.newArrayList();
                for (Map.Entry entry : sendNoticeDTO.getExternalUserSidMap().entrySet()) {
                    if (ObjectUtils.isEmpty(entry.getValue()) && StringUtils.isNotBlank((CharSequence)((NewsAnnouncementAut)entry.getValue()).getAuthBizId())) {
                        UserDTO userDTO = new UserDTO();
                        userDTO.setTenantId(((NewsAnnouncementAut)entry.getValue()).getTenantId());
                        userDTO.setId(((NewsAnnouncementAut)entry.getValue()).getAuthBizId());
                        externalUserList.add(userDTO);
                        continue;
                    }
                    sidList.add(entry.getKey());
                }
                if (CollectionUtils.isNotEmpty((Collection)sidList)) {
                    List list = this.queryExternalUserList((List)sidList);
                    externalUserList.addAll(list);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)sendNoticeDTO.getExternalUserList())) {
                externalUserList = sendNoticeDTO.getExternalUserList();
            }
        }
        Long mewsId = sendNoticeDTO.getNewsId();
        String newsTitle = sendNoticeDTO.getNewsTitle();
        if (CollectionUtils.isNotEmpty((Collection)allUserIdList)) {
            allUserIdList = allUserIdList.stream().distinct().collect(Collectors.toList());
            this.sendNewsNoticeMQ(Utils.getTenantId(), mewsId, newsTitle, allUserIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)externalUserList)) {
            Map<String, List<UserDTO>> map = externalUserList.stream().collect(Collectors.groupingBy(UserDTO::getTenantId));
            map.forEach((k, v) -> {
                List userIdList = v.stream().map(UserDTO::getId).distinct().collect(Collectors.toList());
                this.sendNewsNoticeMQ(k, mewsId, newsTitle, userIdList);
            });
        }
    }

    private void sendNewsNoticeMQ(String tenantId, Long newsId, String newsTitle, List<String> allUserIdList) {
        MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
        messageBatchUserDTO.setTenantId(tenantId);
        MessageDTO message = new MessageDTO();
        message.setType("news");
        message.setSource("semc");
        message.setNoticeOnlineUser(Boolean.TRUE);
        message.setNoticeMobileApp(Boolean.TRUE);
        message.setSendDate(LocalDateTime.now());
        message.setCreateDate(LocalDateTime.now());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)newsId);
        jsonObject.put("msg", (Object)newsTitle);
        jsonObject.put("title", (Object)"");
        message.setContent(jsonObject);
        messageBatchUserDTO.setMessage(message);
        MDC.put((String)"userToken", (String)Utils.getUserToken());
        List partList = Lists.partition(allUserIdList, (int)this.commonConfigService.querySendNewsNoticeUserCount());
        for (List userIdList : partList) {
            MQMessageDTO messageDTO = new MQMessageDTO();
            messageDTO.setMessageId(IdUtil.randomUUID());
            messageBatchUserDTO.setUserIdList(userIdList);
            messageDTO.setMessage(JSON.toJSONString((Object)messageBatchUserDTO));
            messageDTO.setMessageType(MQMessageTypeEnum.NEWS_SEND_NOTICE.getCode());
            messageDTO.setRetryMaxCount(Integer.valueOf(3));
            this.rabbitMessageSender.sendWorkCommonMsg(messageDTO);
            ThreadUtil.sleep((long)100L);
        }
    }

    private List<UserDTO> queryExternalUserList(List<Long> externalUserIdList) {
        ArrayList externalUserList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(externalUserIdList)) {
            CompletableFuture[] completableFutures = new CompletableFuture[externalUserIdList.size()];
            for (int i = 0; i < externalUserIdList.size(); ++i) {
                long sid = externalUserIdList.get(i);
                completableFutures[i] = CompletableFuture.supplyAsync(() -> this.getPersonalTenantId(Long.valueOf(sid)), this.asyncTaskExecutor);
            }
            CompletableFuture.allOf(completableFutures).join();
            for (CompletableFuture completableFuture : completableFutures) {
                try {
                    Map map = (Map)completableFuture.get();
                    if (!MapUtils.isNotEmpty((Map)map) || !ObjectUtils.isNotEmpty(map.get("tenantId")) || !ObjectUtils.isNotEmpty(map.get("userId"))) continue;
                    UserDTO userDTO = new UserDTO();
                    userDTO.setTenantId(String.valueOf(map.get("tenantId")));
                    userDTO.setId(String.valueOf(map.get("userId")));
                    externalUserList.add(userDTO);
                }
                catch (Exception e) {
                    log.error("query personal tenantId error\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return externalUserList;
    }
}

