/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.NewsTypeConstants;
import com.digiwin.athena.semc.dto.news.SaveNewsTypeAuthReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementTypeAuth;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementTypeAuthMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.cache.ICacheService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeAuthService;
import com.digiwin.athena.semc.util.FormatUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.news.NewsTypeAuthVO;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import io.vavr.Tuple2;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsAnnouncementTypeAuthServiceImpl
extends ServiceImpl<NewsAnnouncementTypeAuthMapper, NewsAnnouncementTypeAuth>
implements NewsAnnouncementTypeAuthService {
    @Resource
    private NewsAnnouncementTypeAuthMapper newsAnnouncementTypeAuthMapper;
    @Resource
    private IamUserService iamUserService;
    @Resource
    private IamService iamService;
    @Resource
    private CommonConfigService commonConfigService;
    @Resource
    private ICacheService cacheService;

    public NewsTypeAuthVO queryAuthRelNewsType(String authId) {
        List newsAnnouncementTypeAuthList;
        NewsTypeAuthVO newsTypeAuthVO = new NewsTypeAuthVO();
        if (StringUtils.isNotBlank((CharSequence)authId)) {
            LambdaQueryWrapper condition = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(NewsAnnouncementTypeAuth::getAuthId, (Object)authId);
            newsAnnouncementTypeAuthList = this.newsAnnouncementTypeAuthMapper.selectList((Wrapper)condition);
        } else {
            boolean flag = this.querySuperAdminFlag();
            if (flag) {
                newsTypeAuthVO.setAllNewsTypeFlag(Constants.ALL_AUTH_FLAG_YES);
                return newsTypeAuthVO;
            }
            newsAnnouncementTypeAuthList = this.queryUserNewsTypeList();
        }
        return this.buildNewsTypeAuthVO(newsAnnouncementTypeAuthList);
    }

    private boolean querySuperAdminFlag() {
        boolean flag;
        Tuple2 superAdminSwitchTuple2 = this.commonConfigService.querySuperAdminFlagSwitch();
        if (Boolean.TRUE.equals(superAdminSwitchTuple2._1)) {
            String cacheKey = FormatUtil.format((String)"SuperAdminFlag:{}:{}", (Object[])new Object[]{AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), AppAuthContextHolder.getContext().getAuthoredUser().getUserId()});
            String cacheValue = this.cacheService.getValue(cacheKey);
            if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
                flag = Boolean.parseBoolean(cacheValue);
            } else {
                List roleDTOList = this.iamService.queryUserRoles(Utils.getUserId(), Utils.getUserToken());
                flag = roleDTOList.stream().anyMatch(x -> x.getId().equals("superadmin"));
                this.cacheService.cache(cacheKey, Boolean.toString(flag), Duration.ofSeconds(((Integer)superAdminSwitchTuple2._2).intValue()));
            }
        } else {
            List roleDTOList = this.iamService.queryUserRoles(Utils.getUserId(), Utils.getUserToken());
            flag = roleDTOList.stream().anyMatch(x -> x.getId().equals("superadmin"));
        }
        return flag;
    }

    private NewsTypeAuthVO buildNewsTypeAuthVO(List<NewsAnnouncementTypeAuth> newsAnnouncementTypeAuthList) {
        NewsTypeAuthVO newsTypeAuthVO = new NewsTypeAuthVO();
        if (CollectionUtils.isEmpty(newsAnnouncementTypeAuthList)) {
            newsTypeAuthVO.setAuthorizedNewsTypeIdList(Collections.singletonList(NewsTypeConstants.NEWS_TYPE_OTHER_ID));
            newsTypeAuthVO.setAllNewsTypeFlag(Constants.ALL_AUTH_FLAG_NO);
            return newsTypeAuthVO;
        }
        boolean flag = newsAnnouncementTypeAuthList.stream().anyMatch(x -> Constants.ALL_AUTH_FLAG_YES.equals(x.getAllNewsTypeFlag()));
        if (flag) {
            newsTypeAuthVO.setAllNewsTypeFlag(Constants.ALL_AUTH_FLAG_YES);
        } else {
            List newsTypeIdList = newsAnnouncementTypeAuthList.stream().map(NewsAnnouncementTypeAuth::getNewsTypeId).collect(Collectors.toList());
            if (!newsTypeIdList.contains(NewsTypeConstants.NEWS_TYPE_OTHER_ID)) {
                newsTypeIdList.add(NewsTypeConstants.NEWS_TYPE_OTHER_ID);
            }
            newsTypeAuthVO.setAuthorizedNewsTypeIdList(newsTypeIdList);
            newsTypeAuthVO.setAllNewsTypeFlag(Constants.ALL_AUTH_FLAG_NO);
        }
        return newsTypeAuthVO;
    }

    @Transactional
    public void saveNewsTypeAuth(SaveNewsTypeAuthReq saveNewsTypeAuthReq) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"auth_id", (Object)saveNewsTypeAuthReq.getAuthId());
        this.newsAnnouncementTypeAuthMapper.delete((Wrapper)condition);
        if (Constants.ALL_AUTH_FLAG_YES.equals(saveNewsTypeAuthReq.getAllNewsTypeFlag())) {
            NewsAnnouncementTypeAuth newsAnnouncementTypeAuth = new NewsAnnouncementTypeAuth();
            newsAnnouncementTypeAuth.setAuthId(saveNewsTypeAuthReq.getAuthId());
            newsAnnouncementTypeAuth.setAuthName(saveNewsTypeAuthReq.getAuthName());
            newsAnnouncementTypeAuth.setAuthType(saveNewsTypeAuthReq.getAuthType());
            newsAnnouncementTypeAuth.setAllNewsTypeFlag(Constants.ALL_AUTH_FLAG_YES);
            this.save((Object)newsAnnouncementTypeAuth);
        } else {
            if (CollectionUtils.isEmpty((Collection)saveNewsTypeAuthReq.getNewsTypeIdList())) {
                return;
            }
            List newsAnnouncementTypeAuthListL = saveNewsTypeAuthReq.getNewsTypeIdList().stream().map(x -> {
                NewsAnnouncementTypeAuth newsAnnouncementTypeAuth = new NewsAnnouncementTypeAuth();
                newsAnnouncementTypeAuth.setNewsTypeId(x);
                newsAnnouncementTypeAuth.setAuthId(saveNewsTypeAuthReq.getAuthId());
                newsAnnouncementTypeAuth.setAuthName(saveNewsTypeAuthReq.getAuthName());
                newsAnnouncementTypeAuth.setAuthType(saveNewsTypeAuthReq.getAuthType());
                return newsAnnouncementTypeAuth;
            }).collect(Collectors.toList());
            List partList = Lists.partition(newsAnnouncementTypeAuthListL, (int)500);
            for (List tempList : partList) {
                this.saveBatch((Collection)tempList);
            }
        }
    }

    private List<NewsAnnouncementTypeAuth> queryUserNewsTypeList() {
        Long userSid;
        String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(userId, tenantId, userToken);
        ArrayList authIdList = Lists.newArrayList();
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getOrgSids())) {
            authIdList.addAll(iamUserAuthInfo.getOrgSids());
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getRoleSids())) {
            authIdList.addAll(iamUserAuthInfo.getRoleSids());
        }
        if (iamUserAuthInfo != null && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getDeptSids())) {
            authIdList.addAll(iamUserAuthInfo.getDeptSids());
        }
        if (ObjectUtils.isNotEmpty((Object)(userSid = Long.valueOf(AppAuthContextHolder.getContext().getAuthoredUser().getSid())))) {
            authIdList.add(userSid);
        }
        List newsAnnouncementTypeAuthList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)authIdList)) {
            Collections.sort(authIdList);
            StringBuilder authCondition = new StringBuilder("(auth_id in(" + Joiner.on((String)",").join((Iterable)authIdList) + "))");
            QueryWrapper condition = new QueryWrapper();
            condition.apply("(" + authCondition + ")", new Object[0]);
            condition.select(new String[]{"all_news_type_flag", "news_type_id"});
            newsAnnouncementTypeAuthList = this.newsAnnouncementTypeAuthMapper.selectList((Wrapper)condition);
        }
        return newsAnnouncementTypeAuthList;
    }
}

