/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.NewsTypeConstants;
import com.digiwin.athena.semc.common.enums.DataChangeTypeEnum;
import com.digiwin.athena.semc.dto.news.SaveNewsTypeReqDTO;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementTypeAuth;
import com.digiwin.athena.semc.event.NewsChangeEvent;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementAuthMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementTypeAuthMapper;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementTypeMapper;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeService;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsAnnouncementTypeServiceImpl
extends ServiceImpl<NewsAnnouncementTypeMapper, NewsAnnouncementType>
implements NewsAnnouncementTypeService {
    @Resource
    private NewsAnnouncementTypeMapper newsAnnouncementTypeMapper;
    @Resource
    private NewsAnnouncementMapper newsAnnouncementMapper;
    @Resource
    private NewsAnnouncementAuthMapper newsAnnouncementAuthMapper;
    @Resource
    private NewsAnnouncementTypeAuthMapper newsAnnouncementTypeAuthMapper;
    @Resource
    private Converter converter;

    public List<NewsAnnouncementType> queryNewsTypeListByParentId(Long id) {
        return this.newsAnnouncementTypeMapper.queryNewsTypeListByParentId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), id);
    }

    public boolean existByTypeId(Long id) {
        return (Boolean)InterceptorIgnoreUtil.handler(() -> {
            NewsAnnouncementType type = (NewsAnnouncementType)this.getById((Serializable)id);
            return type != null;
        });
    }

    @Transactional
    public void delNewsType(NewsAnnouncementType newsAnnouncementType) {
        this.newsAnnouncementTypeMapper.deleteById((Serializable)newsAnnouncementType.getId());
        if (NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(newsAnnouncementType.getParentId())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(NewsAnnouncementType::getParentId, (Object)newsAnnouncementType.getId());
            this.newsAnnouncementTypeMapper.delete((Wrapper)wrapper);
        }
        this.newsAnnouncementMapper.updateNewsTypeById(newsAnnouncementType.getId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        this.newsAnnouncementAuthMapper.updateNewsTypeById(newsAnnouncementType.getId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
        deleteWrapper.eq(NewsAnnouncementTypeAuth::getNewsTypeId, (Object)newsAnnouncementType.getId());
        this.newsAnnouncementTypeAuthMapper.delete((Wrapper)deleteWrapper);
    }

    public Boolean saveNewsType(SaveNewsTypeReqDTO saveNewsTypeReqDTO) {
        NewsAnnouncementType newsAnnouncementType = (NewsAnnouncementType)this.converter.convert((Object)saveNewsTypeReqDTO, NewsAnnouncementType.class);
        newsAnnouncementType.setLevel(NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL_PARENT_ID.equals(saveNewsTypeReqDTO.getParentId()) ? NewsTypeConstants.NEWS_TYPE_FIRST_LEVEL : NewsTypeConstants.NEWS_TYPE_SECOND_LEVEL);
        return this.saveOrUpdate((Object)newsAnnouncementType);
    }

    public void saveNewsCount(NewsChangeEvent event) {
        if (DataChangeTypeEnum.ADD.equals((Object)event.getEventDTO().getDataChangeType()) || DataChangeTypeEnum.EDIT.equals((Object)event.getEventDTO().getDataChangeType())) {
            Long oldNewsTypeId = (Long)event.getEventDTO().getOldNewsTypeIdList().get(0);
            Long currentNewsTypeId = event.getEventDTO().getCurrentNewsTypeId();
            this.updateNewsTypeCount(currentNewsTypeId);
            if (ObjectUtils.isNotEmpty((Object)oldNewsTypeId) && !oldNewsTypeId.equals(currentNewsTypeId)) {
                this.updateNewsTypeCount(oldNewsTypeId);
            }
        }
        if (DataChangeTypeEnum.DELETE.equals((Object)event.getEventDTO().getDataChangeType())) {
            List delNewsTypeIdList = event.getEventDTO().getOldNewsTypeIdList();
            delNewsTypeIdList.forEach(arg_0 -> this.updateNewsTypeCount(arg_0));
        }
    }

    private void updateNewsTypeCount(Long newsTypeId) {
        InterceptorIgnoreUtil.handler(() -> {
            LambdaQueryWrapper condition = new LambdaQueryWrapper();
            condition.eq(NewsAnnouncement::getNewsTypeId, (Object)newsTypeId);
            condition.select(new SFunction[]{NewsAnnouncement::getId, NewsAnnouncement::getNewsStatus});
            List newsAnnouncementList = this.newsAnnouncementMapper.selectList((Wrapper)condition);
            Integer totalCount = newsAnnouncementList.size();
            Long publishedCount = newsAnnouncementList.stream().filter(x -> Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag().equals(x.getNewsStatus())).count();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(NewsAnnouncementType::getNewsCount, (Object)totalCount)).set(NewsAnnouncementType::getPublishedNewsCount, (Object)publishedCount);
            updateWrapper.eq(NewsAnnouncementType::getId, (Object)newsTypeId);
            this.update((Wrapper)updateWrapper);
        });
    }
}

