/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.news.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.news.ThirdNewsAnnouncementReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.news.NewsAnnouncementMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationInstanceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.news.ThirdNewsAnnouncementService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.news.NewsAnnouncementVO;
import com.google.common.collect.Lists;
import io.github.linpeilie.Converter;
import io.vavr.Tuple3;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdNewsAnnouncementServiceImpl
implements ThirdNewsAnnouncementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdNewsAnnouncementServiceImpl.class);
    private final String END_TIME = "2099-12-31 23:59:59";
    @Resource
    private NewsAnnouncementMapper newsAnnouncementMapper;
    @Resource
    private ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    private ErpSsoInfoMapper erpSsoInfoMapper;
    @Resource
    private PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Resource
    private IamService iamService;
    @Resource
    private PreinstalledApplicationInstanceMapper instanceMapper;
    @Resource
    private Converter converter;

    public String checkNewsDateIsValid(List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs) {
        String error = "";
        for (ThirdNewsAnnouncementReq newsReq : thirdNewsAnnouncementReqs) {
            if (StringUtils.isNotBlank((CharSequence)newsReq.getSummary()) && newsReq.getSummary().length() > 300) {
                error = "\u6458\u8981\u5b57\u6570\u5df2\u8d85\u8fc7\u89c4\u5b9a\u8303\u56f4";
                return error;
            }
            if (ObjectUtils.isEmpty((Object)newsReq.getNewsEndTime())) {
                newsReq.setNewsEndTime("2099-12-31 23:59:59");
                continue;
            }
            if (!DateUtils.validateDate((String)newsReq.getNewsEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                error = "\u622a\u6b62\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e";
                return error;
            }
            String tomorrow = DateUtils.addDate((String)DateUtils.getNowTime(null), (String)"yyyy-MM-dd HH:mm:ss", (int)1, (String)"day");
            if (newsReq.getNewsEndTime().compareTo(tomorrow) >= 0) continue;
            error = "\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4+24h";
            return error;
        }
        return error;
    }

    public void saveNewsList(List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs, String appId, String appCode, String tenantId, ApplicationTypeEnum applicationType) {
        if (CollectionUtils.isEmpty(thirdNewsAnnouncementReqs)) {
            return;
        }
        for (ThirdNewsAnnouncementReq thirdNewsAnnouncementReq : thirdNewsAnnouncementReqs) {
            NewsAnnouncement newsAnnouncement = new NewsAnnouncement();
            newsAnnouncement.setThirdAppCode(appCode);
            newsAnnouncement.setTenantId(tenantId);
            newsAnnouncement.setThirdAppId(appId);
            this.buildNewsAnnouncement(newsAnnouncement, thirdNewsAnnouncementReq, applicationType);
            String thirdNewsId = thirdNewsAnnouncementReq.getThirdNewsId();
            NewsAnnouncement newsAnnouncementSql = this.newsAnnouncementMapper.selectByIdAndCode(thirdNewsId, appCode, tenantId);
            if (ObjectUtils.isEmpty((Object)newsAnnouncementSql)) {
                this.newsAnnouncementMapper.thirdInsert(newsAnnouncement);
                continue;
            }
            newsAnnouncement.setId(newsAnnouncementSql.getId());
            this.newsAnnouncementMapper.updateNewsAnnouncementById(newsAnnouncement);
        }
    }

    public String checkNewsIsValid(List<ThirdNewsAnnouncementReq> thirdNewsAnnouncementReqs) {
        String error = "";
        if (thirdNewsAnnouncementReqs.size() > 500 || thirdNewsAnnouncementReqs.size() == 0) {
            error = "\u5355\u6b21\u6700\u5c11\u4f20\u90011\u6761\u516c\u544a,\u6700\u591a\u53ea\u80fd\u4f20\u9001500\u6761\u516c\u544a";
            return "\u5355\u6b21\u6700\u5c11\u4f20\u90011\u6761\u516c\u544a,\u6700\u591a\u53ea\u80fd\u4f20\u9001500\u6761\u516c\u544a";
        }
        for (ThirdNewsAnnouncementReq thirdNewsAnnouncementReq : thirdNewsAnnouncementReqs) {
            if (ObjectUtils.isEmpty((Object)thirdNewsAnnouncementReq.getThirdNewsId())) {
                error = "\u4e09\u65b9\u516c\u544aid\u4e0d\u80fd\u4e3a\u7a7a";
                return "\u4e09\u65b9\u516c\u544aid\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((CharSequence)thirdNewsAnnouncementReq.getNewsTitle()) || thirdNewsAnnouncementReq.getNewsTitle().length() >= 50) {
                error = "\u516c\u544a\u6807\u9898\u89c4\u683c\u4e0d\u7b26\u5408";
                return "\u516c\u544a\u6807\u9898\u89c4\u683c\u4e0d\u7b26\u5408";
            }
            if (CollectionUtils.isEmpty((Collection)thirdNewsAnnouncementReq.getUserIds())) {
                error = "\u672a\u4f20\u5165\u901a\u77e5\u4eba\u5458";
                return "\u672a\u4f20\u5165\u901a\u77e5\u4eba\u5458";
            }
            if (thirdNewsAnnouncementReq.getUserIds().size() > 100) {
                error = "\u901a\u77e5\u4eba\u5458\u6700\u591a\u4e3a100\u4eba";
                return "\u901a\u77e5\u4eba\u5458\u6700\u591a\u4e3a100\u4eba";
            }
            if (StringUtils.isNotBlank((CharSequence)thirdNewsAnnouncementReq.getSummary()) && thirdNewsAnnouncementReq.getSummary().length() > 300) {
                error = "\u6458\u8981\u5b57\u6570\u5df2\u8d85\u8fc7\u89c4\u5b9a\u8303\u56f4";
                return "\u6458\u8981\u5b57\u6570\u5df2\u8d85\u8fc7\u89c4\u5b9a\u8303\u56f4";
            }
            if (!Arrays.asList(0, 1).contains(thirdNewsAnnouncementReq.getNewsStatus())) {
                error = "\u516c\u544a\u72b6\u6001\u4e0d\u5408\u6cd5";
                return "\u516c\u544a\u72b6\u6001\u4e0d\u5408\u6cd5";
            }
            if (ObjectUtils.isEmpty((Object)thirdNewsAnnouncementReq.getNewsTypeId()) || !Arrays.asList(1L, 2L, 3L, 4L).contains(thirdNewsAnnouncementReq.getNewsTypeId())) {
                error = "\u516c\u544a\u7c7b\u578b\u9519\u8bef";
                return "\u516c\u544a\u7c7b\u578b\u9519\u8bef";
            }
            if (ObjectUtils.isEmpty((Object)thirdNewsAnnouncementReq.getNewsEndTime())) {
                thirdNewsAnnouncementReq.setNewsEndTime("2099-12-31 23:59:59");
                continue;
            }
            if (!DateUtils.validateDate((String)thirdNewsAnnouncementReq.getNewsEndTime(), (String)"yyyy-MM-dd HH:mm:ss")) {
                error = "\u622a\u6b62\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e";
                return "\u622a\u6b62\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e";
            }
            String tomorrow = DateUtils.addDate((String)DateUtils.getNowTime(null), (String)"yyyy-MM-dd HH:mm:ss", (int)1, (String)"day");
            if (thirdNewsAnnouncementReq.getNewsEndTime().compareTo(tomorrow) >= 0) continue;
            error = "\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4+24h";
            return "\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4+24h";
        }
        return error;
    }

    public PageInfoResp<NewsAnnouncementVO> queryThirdNewsListByPage(QueryWrapper<NewsAnnouncement> condition, Integer pageSize, Integer pageNum) {
        PageInfoResp newsAnnouncementVOPageInfoResp = new PageInfoResp();
        newsAnnouncementVOPageInfoResp.setPageNo(pageNum.intValue());
        newsAnnouncementVOPageInfoResp.setPageSize(pageSize.intValue());
        Page newsAnnouncementPage = new Page();
        if (ObjectUtils.isEmpty(condition)) {
            ((QueryWrapper)condition.eq((Object)"news_source", (Object)1)).eq((Object)"news_status", (Object)1);
        }
        newsAnnouncementPage = (Page)this.newsAnnouncementMapper.selectPage((IPage)new Page((long)pageSize.intValue(), (long)pageNum.intValue()), condition);
        List records = newsAnnouncementPage.getRecords();
        ArrayList result = new ArrayList();
        records.forEach(x -> {
            NewsAnnouncementVO newsAnnouncementVO = (NewsAnnouncementVO)this.converter.convert(x, NewsAnnouncementVO.class);
            result.add(newsAnnouncementVO);
        });
        newsAnnouncementVOPageInfoResp.setPageSize(pageSize.intValue());
        newsAnnouncementVOPageInfoResp.setPageNo(pageNum.intValue());
        newsAnnouncementVOPageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(newsAnnouncementPage.getPages())));
        newsAnnouncementVOPageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(newsAnnouncementPage.getTotal())));
        newsAnnouncementVOPageInfoResp.setList(result);
        return newsAnnouncementVOPageInfoResp;
    }

    public Tuple3<String, String, ApplicationTypeEnum> checkAppCode(String appId, String appCode) {
        List thirdSsoInfos = this.thirdSsoInfoMapper.queryByAppCode(appId, appCode);
        List validListThird = thirdSsoInfos.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getValidStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validListThird)) {
            return new Tuple3((Object)"", (Object)((ThirdSsoInfo)validListThird.get(0)).getTenantId(), (Object)ApplicationTypeEnum.BS_APPLICATION);
        }
        List erpSsoInfos = this.erpSsoInfoMapper.queryByAppCode(appId, appCode);
        List validListErp = erpSsoInfos.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getValidStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(validListErp)) {
            return new Tuple3((Object)"", (Object)((ErpSsoInfo)validListErp.get(0)).getTenantId(), (Object)ApplicationTypeEnum.CS_APPLICATION);
        }
        List preinstalledApplications = this.preinstalledApplicationMapper.getAllByAppCode(appCode);
        ArrayList preinstalledApplicationInstances = new ArrayList();
        for (PreinstalledApplication preinstalledApplication : preinstalledApplications) {
            List instances = this.instanceMapper.selectByAppId(appId, preinstalledApplication.getId());
            if (!CollectionUtils.isNotEmpty((Collection)instances)) continue;
            preinstalledApplicationInstances.addAll(instances);
        }
        List applications = preinstalledApplicationInstances.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(applications)) {
            return new Tuple3((Object)"", (Object)((PreinstalledApplicationInstance)applications.get(0)).getTenantId(), (Object)ApplicationTypeEnum.PRESET_APPLICATION);
        }
        return new Tuple3((Object)"\u5f53\u524d\u5e94\u7528\u4e0d\u5728\u914d\u7f6e\u4e2d\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6743\u63a8\u9001\u516c\u544a", (Object)"", null);
    }

    public List<NewsAnnouncement> getThirdNewsList(NewsAnnouncement newsAnnouncement) {
        newsAnnouncement.setNewsSource(Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType());
        List list = this.newsAnnouncementMapper.selectAllNews(newsAnnouncement);
        return list;
    }

    public List<NewsAnnouncement> buildThirdNewSWithSSO(List<NewsAnnouncement> newsAnnouncements) {
        ArrayList appLinkDTOS = Lists.newArrayList();
        Map thirdAppTypeNewsMap = newsAnnouncements.stream().collect(Collectors.groupingBy(NewsAnnouncement::getThirdAppType, Collectors.toList()));
        for (Map.Entry entry : thirdAppTypeNewsMap.entrySet()) {
            List list;
            LambdaQueryWrapper queryWrapper;
            Integer appType = entry.getKey();
            List thirdAppCodeList = entry.getValue().stream().map(NewsAnnouncement::getThirdAppCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(thirdAppCodeList)) continue;
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(appType)) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(ThirdSsoInfo::getAppCode, thirdAppCodeList);
                queryWrapper.eq(ThirdSsoInfo::getValidStatus, (Object)Constants.VALID_STATUS_ENABLE);
                queryWrapper.select(new SFunction[]{ThirdSsoInfo::getAppId});
                list = this.thirdSsoInfoMapper.selectList((Wrapper)queryWrapper);
                list.forEach(m -> {
                    AppLinkDTO appLinkDTO = new AppLinkDTO();
                    appLinkDTO.setApplicationAppId(m.getAppId());
                    appLinkDTOS.add(appLinkDTO);
                });
                continue;
            }
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(appType)) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.in(ErpSsoInfo::getCode, thirdAppCodeList);
                queryWrapper.eq(ErpSsoInfo::getValidStatus, (Object)Constants.VALID_STATUS_ENABLE);
                queryWrapper.select(new SFunction[]{ErpSsoInfo::getAppId});
                list = this.erpSsoInfoMapper.selectList((Wrapper)queryWrapper);
                list.forEach(m -> {
                    AppLinkDTO appLinkDTO = new AppLinkDTO();
                    appLinkDTO.setApplicationAppId(m.getAppId());
                    appLinkDTOS.add(appLinkDTO);
                });
                continue;
            }
            if (!ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(appType)) continue;
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(PreinstalledApplication::getApplicationCode, thirdAppCodeList);
            queryWrapper.select(new SFunction[]{PreinstalledApplication::getId});
            List preinstalledApplicationList = this.preinstalledApplicationMapper.selectList((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)preinstalledApplicationList)) continue;
            List preinstalledApplicationIdList = preinstalledApplicationList.stream().map(PreinstalledApplication::getId).collect(Collectors.toList());
            LambdaQueryWrapper instanceQueryWrapper = new LambdaQueryWrapper();
            instanceQueryWrapper.in(PreinstalledApplicationInstance::getPreinstalledApplicationId, preinstalledApplicationIdList);
            instanceQueryWrapper.eq(PreinstalledApplicationInstance::getStatus, (Object)Constants.VALID_STATUS_ENABLE);
            instanceQueryWrapper.select(new SFunction[]{PreinstalledApplicationInstance::getAppId});
            List list2 = this.instanceMapper.selectList((Wrapper)instanceQueryWrapper);
            list2.forEach(m -> {
                AppLinkDTO appLinkDTO = new AppLinkDTO();
                appLinkDTO.setApplicationAppId(m.getAppId());
                appLinkDTOS.add(appLinkDTO);
            });
        }
        ArrayList<NewsAnnouncement> result = new ArrayList<NewsAnnouncement>();
        HashMap<String, String> thirdUserMap = new HashMap<String, String>();
        Map appLinkDTOMap = appLinkDTOS.stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getApplicationAppId())).collect(Collectors.toMap(AppLinkDTO::getApplicationAppId, Function.identity()));
        for (NewsAnnouncement newsAnnouncement : newsAnnouncements) {
            if (!appLinkDTOMap.containsKey(newsAnnouncement.getThirdAppId()) || !ObjectUtils.isNotEmpty(appLinkDTOMap.get(newsAnnouncement.getThirdAppId()))) continue;
            if (!thirdUserMap.containsKey(newsAnnouncement.getThirdAppId())) {
                String thirdUser = this.iamService.queryMappingEmpId(newsAnnouncement.getThirdAppCode());
                if (!StringUtils.isNotBlank((CharSequence)thirdUser)) continue;
                thirdUserMap.put(newsAnnouncement.getThirdAppId(), thirdUser);
            }
            if (!newsAnnouncement.getThirdUserIds().contains((CharSequence)thirdUserMap.get(newsAnnouncement.getThirdAppId()))) continue;
            result.add(newsAnnouncement);
        }
        return result;
    }

    private void buildNewsAnnouncement(NewsAnnouncement newsAnnouncement, ThirdNewsAnnouncementReq thirdNewsAnnouncementReq, ApplicationTypeEnum applicationType) {
        newsAnnouncement.setThirdNewsId(thirdNewsAnnouncementReq.getThirdNewsId());
        newsAnnouncement.setNewsTitle(thirdNewsAnnouncementReq.getNewsTitle());
        newsAnnouncement.setNewsStatus(thirdNewsAnnouncementReq.getNewsStatus() == null ? Constants.NewsAnnouncementStatusEnum.PUBLISHED.getFlag() : thirdNewsAnnouncementReq.getNewsStatus());
        newsAnnouncement.setNewsEndTime(thirdNewsAnnouncementReq.getNewsEndTime() == null ? "2099-12-31 23:59:59" : thirdNewsAnnouncementReq.getNewsEndTime());
        newsAnnouncement.setNewsTypeId(thirdNewsAnnouncementReq.getNewsTypeId());
        newsAnnouncement.setSummary(thirdNewsAnnouncementReq.getSummary());
        newsAnnouncement.setNewsContent(null);
        newsAnnouncement.setThirdUrl(thirdNewsAnnouncementReq.getUrl());
        newsAnnouncement.setThirdUserIds(String.join((CharSequence)",", thirdNewsAnnouncementReq.getUserIds()));
        newsAnnouncement.setNewsSource(Constants.ThirdNewsAnnouncementEnum.OUTSIDER_INFORMATION.getType());
        String dateTime = String.valueOf(LocalDateTime.now());
        newsAnnouncement.setCreateTime(dateTime);
        newsAnnouncement.setNewsEffectiveTime(dateTime);
        newsAnnouncement.setModifyTime(dateTime);
        newsAnnouncement.setThirdImgUrl(thirdNewsAnnouncementReq.getThirdImgUrl());
        newsAnnouncement.setThirdNewsHtml(thirdNewsAnnouncementReq.getThirdNewsHtml());
        newsAnnouncement.setThirdAppType(Integer.valueOf(0));
        if (applicationType != null) {
            newsAnnouncement.setThirdAppType(applicationType.getType());
        }
    }
}

