/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.open.impl;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.erpsso.AuthorizeDTO;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.open.AppAccountDTO;
import com.digiwin.athena.semc.dto.open.AppJobAccountVO;
import com.digiwin.athena.semc.dto.open.AppJobUrlReq;
import com.digiwin.athena.semc.dto.open.AppJobVO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.open.OpenAppJobService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemClickService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OpenAppJobServiceImpl
implements OpenAppJobService {
    @Resource
    private ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    private ErpSsoInfoMapper erpSsoInfoMapper;
    @Resource
    private SyncJobInfoMapper syncJobInfoMapper;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Resource
    private LabelSystemClickService labelSystemClickService;
    @Resource
    private LabelSystemDataMapper labelSystemDataMapper;
    @Resource
    private IamService iamService;
    @Resource
    private LabelSystemDataService labelSystemDataService;

    public List<AppJobAccountVO> queryAppJobAccount(List<AppLinkDTO> appCodeList) {
        if (CollectionUtils.isEmpty(appCodeList)) {
            return Collections.emptyList();
        }
        List<AppLinkDTO> collect = appCodeList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPrimaryId()) && Objects.nonNull(item.getDataSource())).collect(Collectors.toList());
        ArrayList<AppJobAccountVO> appJobAccounts = new ArrayList<AppJobAccountVO>();
        ArrayList csList = new ArrayList();
        ArrayList bsList = new ArrayList();
        ArrayList preList = new ArrayList();
        collect.forEach(item -> {
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataSource())) {
                csList.add(Long.parseLong(item.getPrimaryId()));
            } else if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataSource())) {
                bsList.add(Long.parseLong(item.getPrimaryId()));
            } else if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(item.getDataSource())) {
                preList.add(Long.parseLong(item.getPrimaryId()));
            }
        });
        this.csJobAccounts(csList, appJobAccounts);
        this.bsJobAccounts(bsList, appJobAccounts);
        this.preJobAccounts(preList, appJobAccounts);
        return appJobAccounts;
    }

    private void csJobAccounts(List<Long> csList, List<AppJobAccountVO> allAccounts) {
        if (CollectionUtils.isNotEmpty(csList)) {
            Map ssoInfoMap;
            List csAccounts;
            QuerySsoListReq csReq = new QuerySsoListReq();
            csReq.setIdList(csList);
            List erpInfoList = this.erpSsoInfoMapper.querySsoListByScope(csReq);
            if (CollectionUtils.isNotEmpty((Collection)erpInfoList) && CollectionUtils.isNotEmpty((Collection)(csAccounts = this.queryAppJobAccount((ssoInfoMap = erpInfoList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAppId())).collect(Collectors.toMap(ErpSsoInfo::getAppId, Function.identity(), (a, b) -> a))).keySet())))) {
                csAccounts.forEach(item -> {
                    ErpSsoInfo erpSsoInfo = (ErpSsoInfo)ssoInfoMap.get(item.getAppId());
                    if (Objects.nonNull(erpSsoInfo)) {
                        item.setAppCode(erpSsoInfo.getCode());
                        item.setAppName(erpSsoInfo.getName());
                    }
                });
                allAccounts.addAll(csAccounts);
            }
        }
    }

    private void bsJobAccounts(List<Long> bsList, List<AppJobAccountVO> allAccounts) {
        if (CollectionUtils.isNotEmpty(bsList)) {
            Map thirdSsoInfoMap;
            List bsAccounts;
            QuerySsoListReq bsReq = new QuerySsoListReq();
            bsReq.setIdList(bsList);
            List thirdSsoInfoList = this.thirdSsoInfoMapper.queryThirdListByScope(bsReq);
            if (CollectionUtils.isNotEmpty((Collection)thirdSsoInfoList) && CollectionUtils.isNotEmpty((Collection)(bsAccounts = this.queryAppJobAccount((thirdSsoInfoMap = thirdSsoInfoList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAppId())).collect(Collectors.toMap(ThirdSsoInfo::getAppId, Function.identity(), (a, b) -> a))).keySet())))) {
                bsAccounts.forEach(item -> {
                    ThirdSsoInfo thirdSsoInfo = (ThirdSsoInfo)thirdSsoInfoMap.get(item.getAppId());
                    if (Objects.nonNull(thirdSsoInfo)) {
                        item.setAppCode(thirdSsoInfo.getAppCode());
                        item.setAppName(thirdSsoInfo.getAppName());
                    }
                });
                allAccounts.addAll(bsAccounts);
            }
        }
    }

    private void preJobAccounts(List<Long> preList, List<AppJobAccountVO> allAccounts) {
        Map preMap;
        List preAccounts;
        List preinstalledApplications;
        if (CollectionUtils.isNotEmpty(preList) && CollectionUtils.isNotEmpty((Collection)(preinstalledApplications = this.preinstalledApplicationService.queryPreinstalledApplicationList(preList))) && CollectionUtils.isNotEmpty((Collection)(preAccounts = this.queryAppJobAccount((preMap = preinstalledApplications.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getAppId())).collect(Collectors.toMap(PreinstalledApplication::getAppId, Function.identity(), (a, b) -> a))).keySet())))) {
            preAccounts.forEach(item -> {
                PreinstalledApplication preInfo = (PreinstalledApplication)preMap.get(item.getAppId());
                if (Objects.nonNull(preInfo)) {
                    item.setAppCode(preInfo.getApplicationCode());
                    item.setAppName(preInfo.getApplicationName());
                }
            });
            allAccounts.addAll(preAccounts);
        }
    }

    private List<AppJobAccountVO> queryAppJobAccount(Collection<String> appIdList) {
        if (CollectionUtils.isEmpty(appIdList)) {
            return Collections.emptyList();
        }
        List syncJobInfos = this.syncJobInfoMapper.queryAppAccountIds(appIdList);
        if (CollectionUtils.isEmpty((Collection)syncJobInfos)) {
            return Collections.emptyList();
        }
        Map<String, List<SyncJobInfo>> collect = syncJobInfos.stream().collect(Collectors.groupingBy(SyncJobInfo::getAppId));
        ArrayList<AppJobAccountVO> result = new ArrayList<AppJobAccountVO>(collect.size());
        collect.forEach((k, v) -> {
            AppJobAccountVO appJobAccountDTO = new AppJobAccountVO();
            List appAccountList = v.stream().map(item -> new AppAccountDTO(item.getAccountId(), item.getAccountName())).collect(Collectors.toList());
            appJobAccountDTO.setAccounts(appAccountList);
            appJobAccountDTO.setAppId(k);
            result.add(appJobAccountDTO);
        });
        return result;
    }

    public List<AppJobVO> queryAppJobList(String applicationCode, Integer applicationType) {
        String appCode;
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(applicationType)) {
            ThirdSsoInfo thirdSsoInfo = this.thirdSsoInfoMapper.queryAppConfigByAppCode(applicationCode);
            if (Objects.isNull(thirdSsoInfo)) {
                return Collections.emptyList();
            }
            appCode = String.valueOf(thirdSsoInfo.getId());
        } else if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(applicationType)) {
            ErpSsoInfo erpSsoInfo = this.erpSsoInfoMapper.queryAppConfigByAppCode(applicationCode);
            if (Objects.isNull(erpSsoInfo)) {
                return Collections.emptyList();
            }
            appCode = String.valueOf(erpSsoInfo.getId());
        } else if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(applicationType)) {
            PreinstalledApplication application = this.preinstalledApplicationService.getPreByCode(applicationCode, null);
            if (Objects.isNull(application)) {
                return Collections.emptyList();
            }
            appCode = String.valueOf(application.getId());
        } else if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(applicationType)) {
            appCode = applicationCode;
        } else {
            return Collections.emptyList();
        }
        List appJobList = this.labelSystemDataService.getAppJobList(appCode, applicationType, Boolean.valueOf(true), null);
        if (CollectionUtils.isNotEmpty((Collection)appJobList)) {
            return appJobList.stream().map(AppJobVO::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public AppLinkDTO queryAppOrJobLink(AppJobUrlReq jobUrlReq) throws Exception {
        List syncJobInfos;
        LabelSystemData systemData;
        LabelSystemData labelSystemData = new LabelSystemData();
        labelSystemData.setDataType(jobUrlReq.getDataSource());
        labelSystemData.setDataCategory(Integer.valueOf(4));
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(jobUrlReq.getDataSource())) {
            ThirdSsoInfo thirdSsoInfo = this.thirdSsoInfoMapper.queryAppConfigByAppCode(jobUrlReq.getAppCode());
            if (Objects.isNull(thirdSsoInfo)) {
                return null;
            }
            labelSystemData.setAppCode(String.valueOf(thirdSsoInfo.getId()));
            labelSystemData.setAppId(thirdSsoInfo.getAppId());
        } else if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(jobUrlReq.getDataSource())) {
            ErpSsoInfo erpSsoInfo = this.erpSsoInfoMapper.queryAppConfigByAppCode(jobUrlReq.getAppCode());
            if (Objects.isNull(erpSsoInfo)) {
                return null;
            }
            labelSystemData.setAppCode(String.valueOf(erpSsoInfo.getId()));
            labelSystemData.setAppId(erpSsoInfo.getAppId());
        } else if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(jobUrlReq.getDataSource())) {
            PreinstalledApplication application = this.preinstalledApplicationService.getPreByCode(jobUrlReq.getAppCode(), null);
            if (Objects.isNull(application)) {
                return null;
            }
            labelSystemData.setAppCode(String.valueOf(application.getId()));
            labelSystemData.setAppId(application.getAppId());
        } else if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(jobUrlReq.getDataSource())) {
            labelSystemData.setAppCode(jobUrlReq.getAppCode());
            labelSystemData.setAppId(jobUrlReq.getAppCode());
        } else {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)jobUrlReq.getJobCode())) {
            labelSystemData.setIsJob(Integer.valueOf(0));
            labelSystemData.setDataCategory(Integer.valueOf(3));
            labelSystemData.setWorkCode(jobUrlReq.getJobCode());
        }
        if (Objects.nonNull(systemData = this.labelSystemDataMapper.getByInit(labelSystemData)) && Objects.equals(1, systemData.getValidStatus())) {
            labelSystemData = systemData;
        } else if (StringUtils.isNotBlank((CharSequence)labelSystemData.getWorkCode()) && !ApplicationTypeEnum.IAM_APPLICATION.getType().equals(jobUrlReq.getDataSource()) && CollectionUtils.isEmpty((Collection)(syncJobInfos = this.syncJobInfoMapper.selByCode(labelSystemData.getAppId(), labelSystemData.getWorkCode())))) {
            throw BusinessException.create((String)"job code not exist");
        }
        AppLinkDTO appLinkDTO = this.labelSystemClickService.buildCustomApp(labelSystemData);
        if (BooleanUtils.isTrue((Boolean)jobUrlReq.getAddAuthCode())) {
            this.addAuthorize(appLinkDTO);
        }
        return appLinkDTO;
    }

    private void addAuthorize(AppLinkDTO appLink) throws Exception {
        if (appLink == null) {
            return;
        }
        AuthorizeDTO authorizeDTO = this.iamService.queryAuthorizeInfo(appLink.getApplicationAppId(), appLink.getCallBackUrl());
        if (null == authorizeDTO) {
            return;
        }
        appLink.setCloudwebsite(appLink.getCloudwebsite() + "&code=" + authorizeDTO.getCode());
    }
}

