/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.open.impl;

import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.open.SystemToDoReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoReq;
import com.digiwin.athena.semc.dto.portal.TodoListResp;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.service.open.OpenThirdToDoService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemSourceService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OpenThirdToDoServiceImpl
implements OpenThirdToDoService {
    @Resource
    private LabelSystemSourceService labelSystemSourceService;
    @Resource
    private LabelSystemDataService labelSystemDataService;
    @Resource
    private LabelSystemDataMapper labelSystemDataMapper;
    @Resource
    private TodoListService todoListService;
    @Resource
    private ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    private ErpSsoInfoMapper erpSsoInfoMapper;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;

    public List<LabelSystemData> queryTodoAppList() {
        List dataIds = this.labelSystemSourceService.selectPreSystem(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal(), Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
        if (CollectionUtils.isEmpty((Collection)dataIds)) {
            return Collections.emptyList();
        }
        List labelSystemData = this.labelSystemDataService.queryDataInfoBy(dataIds, Boolean.valueOf(true));
        if (CollectionUtils.isNotEmpty((Collection)labelSystemData)) {
            HashSet<String> appCodes = new HashSet<String>();
            Iterator iterator = labelSystemData.iterator();
            while (iterator.hasNext()) {
                LabelSystemData next = (LabelSystemData)iterator.next();
                if (appCodes.add(next.getAppCode())) continue;
                iterator.remove();
            }
        }
        return labelSystemData;
    }

    public TodoListResp queryTodoList(SystemToDoReq todoListReq) {
        TodoListResp todoListResp = new TodoListResp();
        PreSystemToDoReq preSystemToDoReq = new PreSystemToDoReq();
        preSystemToDoReq.setPageNum(todoListReq.getPageNum());
        preSystemToDoReq.setPageSize(todoListReq.getPageSize());
        if (Objects.nonNull(todoListReq.getId())) {
            preSystemToDoReq.setId(todoListReq.getId());
            todoListResp = this.todoListService.selectTodoList(preSystemToDoReq);
        } else if (StringUtils.isNotBlank((CharSequence)todoListReq.getAppCode())) {
            LabelSystemData labelSystemData = new LabelSystemData();
            labelSystemData.setAppCode(todoListReq.getAppCode());
            labelSystemData.setDataCategory(Integer.valueOf(0));
            LabelSystemData systemData = this.labelSystemDataMapper.getByInit(labelSystemData);
            if (Objects.nonNull(systemData)) {
                preSystemToDoReq.setId(systemData.getId());
                todoListResp = this.todoListService.selectTodoList(preSystemToDoReq);
            }
        }
        return todoListResp;
    }

    public TodoListResp queryTodoListByCode(String applicationCode, Integer applicationType, SystemToDoReq todoListReq) {
        PreinstalledApplication application;
        todoListReq.setId(null);
        todoListReq.setAppCode(null);
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(applicationType)) {
            ThirdSsoInfo thirdSsoInfo = this.thirdSsoInfoMapper.queryAppConfigByAppCode(applicationCode);
            if (Objects.nonNull(thirdSsoInfo)) {
                todoListReq.setAppCode(String.valueOf(thirdSsoInfo.getId()));
            }
        } else if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(applicationType)) {
            ErpSsoInfo erpSsoInfo = this.erpSsoInfoMapper.queryAppConfigByAppCode(applicationCode);
            if (Objects.nonNull(erpSsoInfo)) {
                todoListReq.setAppCode(String.valueOf(erpSsoInfo.getId()));
            }
        } else if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(applicationType) && Objects.nonNull(application = this.preinstalledApplicationService.getPreByCode(applicationCode, null))) {
            todoListReq.setAppCode(String.valueOf(application.getId()));
        }
        return this.queryTodoList(todoListReq);
    }
}

