/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.common.CompanyFactory;
import com.digiwin.athena.semc.entity.machine.UserCompanyFactory;
import com.digiwin.athena.semc.mapper.portal.CompanyFactoryMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.OrgAspectDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgInfoDTO;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.portal.CloudNavigationService;
import com.digiwin.athena.semc.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CloudNavigationServiceImpl
implements CloudNavigationService {
    @Resource
    private CompanyFactoryMapper companyFactoryMapper;
    @Resource
    private IamService iamService;
    @Resource
    private TranslateService translateService;

    public List<JSONObject> getCompanyFactoryList() {
        String userId = Utils.getUserId();
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        CompanyFactory companyFactoryVo = this.getCompanyFactory(userId);
        Boolean flag = false;
        if (!ObjectUtils.isEmpty((Object)companyFactoryVo)) {
            flag = true;
        }
        com.alibaba.fastjson.JSONArray defaultOrgAspect = this.iamService.getCompanyFactory();
        Boolean finalFlag = flag;
        defaultOrgAspect.forEach(x -> {
            JSONObject data = JSONObject.fromObject((Object)x);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"id", (Object)data.get("id").toString());
            jsonObject.put((Object)"type", (Object)data.get("type").toString());
            String title = this.translateService.translateTextCache(data.get("title").toString(), "");
            jsonObject.put((Object)"title", (Object)(StringUtils.isEmpty((Object)title) ? data.get("title").toString() : title));
            if (finalFlag.booleanValue()) {
                if (StringUtils.hasText((String)companyFactoryVo.getCompany())) {
                    jsonObject.put((Object)"selected", (Object)(companyFactoryVo.getCompany().equals(jsonObject.get("id")) ? 1 : 0));
                }
            } else {
                jsonObject.put((Object)"selected", (Object)false);
            }
            if (data.containsKey((Object)"children")) {
                JSONArray children = data.getJSONArray("children");
                JSONArray jsonArray = new JSONArray();
                children.forEach(item -> {
                    JSONObject childData = (JSONObject)item;
                    JSONObject childJson = new JSONObject();
                    childJson.put((Object)"id", (Object)childData.get("id").toString());
                    childJson.put((Object)"type", (Object)childData.get("id").toString());
                    String childTitle = this.translateService.translateTextCache(childData.get("title").toString(), "");
                    childJson.put((Object)"title", (Object)(StringUtils.isEmpty((Object)childTitle) ? childData.get("title").toString() : childTitle));
                    if (Boolean.TRUE == jsonObject.get("selected")) {
                        if (finalFlag.booleanValue()) {
                            if (StringUtils.hasText((String)companyFactoryVo.getFactory())) {
                                childJson.put((Object)"selected", (Object)(companyFactoryVo.getFactory().equals(childJson.get("id")) ? 1 : 0));
                            }
                        } else {
                            childJson.put((Object)"selected", (Object)false);
                        }
                    } else {
                        childJson.put((Object)"selected", (Object)false);
                    }
                    jsonArray.add((Object)childJson);
                });
                jsonObject.put((Object)"children", (Object)jsonArray);
            }
            resultList.add(jsonObject);
        });
        return resultList;
    }

    public List<UserCompanyFactory> getCompanyFactoryList2() {
        String userId = Utils.getUserId();
        String userToken = Utils.getUserToken();
        ArrayList<UserCompanyFactory> resultList = new ArrayList<UserCompanyFactory>();
        List allOrgAspect = this.iamService.getOrgAspect();
        if (CollectionUtils.isEmpty((Collection)allOrgAspect)) {
            return resultList;
        }
        UserOrgInfoDTO userOrgInfoDTO = this.iamService.qryUserOrgInfo(userId, userToken);
        if (ObjectUtils.isEmpty((Object)userOrgInfoDTO) || CollectionUtils.isEmpty((Collection)userOrgInfoDTO.getUserInOrgs())) {
            return resultList;
        }
        Map orgAspectMap = allOrgAspect.stream().collect(Collectors.toMap(OrgAspectDTO::getSid, Function.identity(), (v1, v2) -> v1));
        List userInOrgs = userOrgInfoDTO.getUserInOrgs();
        List userCompanies = userInOrgs.stream().filter(org -> "drn:iam:orgtype:defaultOrgCatalog:company".equals(org.getOrgTypeUri())).collect(Collectors.toList());
        List userFactories = userInOrgs.stream().filter(org -> "drn:iam:orgtype:defaultOrgCatalog:factory".equals(org.getOrgTypeUri())).collect(Collectors.toList());
        HashMap<Long, List> companyToFactories = new HashMap<Long, List>();
        for (UserOrgDTO userOrgDTO : userCompanies) {
            ArrayList<UserCompanyFactory> factories = new ArrayList<UserCompanyFactory>();
            for (OrgAspectDTO org2 : allOrgAspect) {
                if (!"drn:iam:orgtype:defaultOrgCatalog:factory".equals(org2.getTypeUri()) || !userOrgDTO.getOrgSid().equals(org2.getParentSid())) continue;
                factories.add(new UserCompanyFactory(org2.getSid(), org2.getLabel(), org2.getLabel(), org2.getName()));
            }
            if (factories.isEmpty()) continue;
            companyToFactories.put(userOrgDTO.getOrgSid(), factories);
        }
        for (UserOrgDTO userOrgDTO : userFactories) {
            List factories;
            OrgAspectDTO parentOrg;
            OrgAspectDTO factoryOrg = (OrgAspectDTO)orgAspectMap.get(userOrgDTO.getOrgSid());
            if (factoryOrg == null || (parentOrg = (OrgAspectDTO)orgAspectMap.get(factoryOrg.getParentSid())) == null || !"drn:iam:orgtype:defaultOrgCatalog:company".equals(parentOrg.getTypeUri()) || !(factories = companyToFactories.computeIfAbsent(parentOrg.getSid(), k -> new ArrayList())).stream().noneMatch(f -> f.getSid().equals(factoryOrg.getSid()))) continue;
            factories.add(new UserCompanyFactory(factoryOrg.getSid(), factoryOrg.getLabel(), factoryOrg.getLabel(), factoryOrg.getName()));
        }
        for (Map.Entry entry : companyToFactories.entrySet()) {
            OrgAspectDTO companyOrg = (OrgAspectDTO)orgAspectMap.get(entry.getKey());
            if (companyOrg == null) continue;
            List factories = (List)entry.getValue();
            resultList.add(new UserCompanyFactory(companyOrg.getSid(), companyOrg.getLabel(), companyOrg.getLabel(), companyOrg.getName(), factories));
        }
        resultList.sort(Comparator.comparing(UserCompanyFactory::getId));
        resultList.forEach(company -> company.getChildren().sort(Comparator.comparing(UserCompanyFactory::getId)));
        CompanyFactory companyFactoryVo = this.getCompanyFactory(userId);
        if (!ObjectUtils.isEmpty((Object)companyFactoryVo)) {
            resultList.forEach(company -> {
                if (company.getId().equals(companyFactoryVo.getCompany())) {
                    company.setSelected(Boolean.valueOf(true));
                    company.getChildren().forEach(factory -> {
                        if (factory.getId().equals(companyFactoryVo.getFactory())) {
                            factory.setSelected(Boolean.valueOf(true));
                        }
                    });
                }
            });
        }
        return resultList;
    }

    public void saveOrUpdateCompanyOrFactory(CompanyFactory companyFactoryVO) {
        boolean flag = false;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(CompanyFactory::getTenantId, (Object)Utils.getTenantId())).eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
        CompanyFactory cfv = (CompanyFactory)this.companyFactoryMapper.selectOne((Wrapper)wrapper);
        if (null != cfv) {
            flag = true;
            companyFactoryVO.setId(cfv.getId());
        }
        if (flag) {
            this.companyFactoryMapper.updateById((Object)companyFactoryVO);
        } else {
            this.companyFactoryMapper.insert((Object)companyFactoryVO);
        }
    }

    public CompanyFactory getCompanyFactory(String createUserId) {
        if (!StringUtils.hasText((String)createUserId)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getCreateUserId, (Object)createUserId);
        return (CompanyFactory)this.companyFactoryMapper.selectOne((Wrapper)wrapper);
    }
}

