/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.BizObjectTypeEnum;
import com.digiwin.athena.semc.common.enums.BusinessSceneEnum;
import com.digiwin.athena.semc.common.enums.FolderLevelEnum;
import com.digiwin.athena.semc.common.enums.FolderTypeEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.FineReportQueryReq;
import com.digiwin.athena.semc.dto.portal.SaveReportUrlParamReq;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.common.Folder;
import com.digiwin.athena.semc.entity.portal.FineReport;
import com.digiwin.athena.semc.mapper.common.FolderMapper;
import com.digiwin.athena.semc.mapper.portal.FineReportMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptInfoDTO;
import com.digiwin.athena.semc.service.common.IBizObjAuthRelService;
import com.digiwin.athena.semc.service.portal.IFineReportService;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelVo;
import com.digiwin.athena.semc.vo.common.FolderViewVo;
import com.digiwin.athena.semc.vo.common.ReportCountVo;
import com.digiwin.athena.semc.vo.portal.FineReportVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FineReportServiceImpl
extends ServiceImpl<FineReportMapper, FineReport>
implements IFineReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineReportServiceImpl.class);
    @Resource
    private IBizObjAuthRelService bizObjAuthRelService;
    @Resource
    private EocService eocService;
    @Resource
    private FolderMapper folderMapper;
    @Resource
    private FineReportMapper fineReportMapper;
    @Resource
    private Converter converter;
    private static final int FIRST_LEVEL = 1;
    private static final int SECOND_LEVEL = 2;
    private static final int THIRD_LEVEL = 3;

    @Transactional
    public void addOrModFineReport(FineReport fineReport, List<BizObjAuthRelVo> org, List<BizObjAuthRelVo> role, List<BizObjAuthRelVo> user) {
        Long fineReportId = fineReport.getId();
        if (Objects.isNull(fineReport.getId())) {
            fineReport.setCreateUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            this.fineReportMapper.insertFineReport(fineReport);
            fineReportId = fineReport.getId();
        } else {
            this.updateById((Object)fineReport);
            this.bizObjAuthRelService.getBaseMapper().delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_obj_type", (Object)BizObjectTypeEnum.FINE_REPORT.getValue())).eq((Object)"biz_obj_id", (Object)fineReport.getId()));
        }
        ArrayList allBizObjAuthRelVoList = new ArrayList();
        allBizObjAuthRelVoList.addAll(org == null ? Lists.newArrayList() : org);
        allBizObjAuthRelVoList.addAll(role == null ? Lists.newArrayList() : role);
        allBizObjAuthRelVoList.addAll(user == null ? Lists.newArrayList() : user);
        if (CollectionUtils.isNotEmpty(allBizObjAuthRelVoList)) {
            ArrayList bizObjAuthRelList = new ArrayList();
            Long finalFineReportId = fineReportId;
            allBizObjAuthRelVoList.forEach(x -> {
                BizObjAuthRel bizObjAuthRel = (BizObjAuthRel)this.converter.convert(x, BizObjAuthRel.class);
                bizObjAuthRel.setBizObjId(String.valueOf(finalFineReportId));
                bizObjAuthRelList.add(bizObjAuthRel);
            });
            this.bizObjAuthRelService.saveBatch(bizObjAuthRelList);
        }
    }

    @Transactional
    public void delFineReport(Long id) {
        this.bizObjAuthRelService.getBaseMapper().delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_obj_type", (Object)BizObjectTypeEnum.FINE_REPORT.getValue())).eq((Object)"biz_obj_id", (Object)id));
        this.removeById((Serializable)id);
    }

    public List<FineReportVo> qryFineReport(Long folderId) {
        List folderList = this.folderMapper.qryCurrentAndChildFolderList(FolderTypeEnum.FINE_REPORT.getValue().intValue(), folderId.longValue());
        List folderIdList = folderList.stream().map(Folder::getId).collect(Collectors.toList());
        List fineReportList = this.fineReportMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"folder_id", folderIdList)).orderByAsc((Object)"report_order", (Object[])new String[]{"create_time"}));
        log.debug("FineReportService query fine report list, result:{}", (Object)JSONObject.toJSONString((Object)fineReportList));
        if (CollectionUtils.isEmpty((Collection)fineReportList)) {
            return Lists.newArrayList();
        }
        return this.buildFineReportVoList(folderList, fineReportList);
    }

    public List<FineReportVo> buildFineReportVoList(List<Folder> folderList, List<FineReport> fineReportList) {
        ArrayList resultFineReportList = Lists.newArrayList();
        Map<Long, String> folderIdMap = folderList.stream().collect(Collectors.toMap(Folder::getId, Folder::getName));
        fineReportList.forEach(x -> {
            FineReportVo fineReportVo = (FineReportVo)this.converter.convert(x, FineReportVo.class);
            fineReportVo.setFolderName((String)folderIdMap.get(x.getFolderId()));
            resultFineReportList.add(fineReportVo);
        });
        List<FineReportVo> sortedReportList = resultFineReportList.stream().sorted(Comparator.comparing(FineReportVo::getFolderName, Comparator.nullsLast(String::compareTo)).thenComparing(FineReportVo::getReportOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(FineReportVo::getCreateTime, Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
        List reportIdList = fineReportList.stream().map(FineReport::getId).collect(Collectors.toList());
        QueryWrapper cond = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_obj_type", (Object)BizObjectTypeEnum.FINE_REPORT.getValue())).in((Object)"biz_obj_id", reportIdList);
        List bizObjAuthRelList = this.bizObjAuthRelService.getBaseMapper().selectList((Wrapper)cond);
        log.debug("FineReportService query business auth relation, result:{}", (Object)JSONObject.toJSONString((Object)bizObjAuthRelList));
        if (CollectionUtils.isEmpty((Collection)bizObjAuthRelList)) {
            return sortedReportList;
        }
        Map<String, List<BizObjAuthRel>> bizObjAuthRelMap = bizObjAuthRelList.stream().collect(Collectors.groupingBy(BizObjAuthRel::getBizObjId));
        sortedReportList.forEach(x -> {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)bizObjAuthRelMap.get(String.valueOf(x.getId()))))) {
                Map<Integer, List<BizObjAuthRel>> currentBizObjAuthRelMap = ((List)bizObjAuthRelMap.get(String.valueOf(x.getId()))).stream().collect(Collectors.groupingBy(BizObjAuthRel::getAuthType));
                for (Map.Entry<Integer, List<BizObjAuthRel>> entry : currentBizObjAuthRelMap.entrySet()) {
                    List bizObjAuthRelVoList = entry.getValue().stream().map(bizObjAuthRel -> {
                        BizObjAuthRelVo bizObjAuthRelVo = (BizObjAuthRelVo)this.converter.convert(bizObjAuthRel, BizObjAuthRelVo.class);
                        return bizObjAuthRelVo;
                    }).collect(Collectors.toList());
                    if (BizAuthTypeEnum.ORG.getValue().equals(entry.getKey())) {
                        x.setOrg(bizObjAuthRelVoList);
                        continue;
                    }
                    if (BizAuthTypeEnum.ROLE.getValue().equals(entry.getKey())) {
                        x.setRole(bizObjAuthRelVoList);
                        continue;
                    }
                    if (!BizAuthTypeEnum.USER.getValue().equals(entry.getKey())) continue;
                    x.setUser(bizObjAuthRelVoList);
                }
            }
        });
        return sortedReportList;
    }

    public ResultPageBean fineReportSearch(String tenantId, FineReportQueryReq reportPageQueryReq) {
        Integer startNum = (reportPageQueryReq.getPageNum() - 1) * reportPageQueryReq.getPageSize();
        List voList = this.folderMapper.fineReportSearch(reportPageQueryReq.getQryCondition(), tenantId, startNum, reportPageQueryReq.getPageSize());
        Integer totalCount = this.folderMapper.countReportSearch(reportPageQueryReq.getQryCondition(), tenantId);
        return ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)voList, (PageInfo)PageInfo.getPageInfo((Integer)reportPageQueryReq.getPageNum(), (Integer)reportPageQueryReq.getPageSize(), (Integer)totalCount)));
    }

    public List<FineReportVo> qryCurrentUserFineReport(Long folderId, String empId) {
        ArrayList resultFineReportList = Lists.newArrayList();
        List bizObjAuthRelList = this.bizObjAuthRelService.qryBizObjAuthRel(BizObjectTypeEnum.FINE_REPORT.getValue());
        if (CollectionUtils.isEmpty((Collection)bizObjAuthRelList)) {
            return resultFineReportList;
        }
        List reportIdList = bizObjAuthRelList.stream().map(BizObjAuthRel::getBizObjId).collect(Collectors.toList());
        List folderList = this.folderMapper.qryCurrentAndChildFolderList(FolderTypeEnum.FINE_REPORT.getValue().intValue(), folderId.longValue());
        List folderIdList = folderList.stream().map(Folder::getId).collect(Collectors.toList());
        List fineReportList = this.fineReportMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"folder_id", folderIdList)).in((Object)"id", reportIdList)).orderByAsc((Object)"report_order", (Object[])new String[]{"create_time"}));
        log.debug("FineReportService query fine report list result:{}", (Object)JSONObject.toJSONString((Object)fineReportList));
        boolean existDepartment = fineReportList.stream().anyMatch(x -> x.getDepartmentConfigFlag() != null);
        Map<Object, Object> levelDeptMap = Maps.newHashMap();
        if (existDepartment) {
            List deptInfoDTOList = this.queryDeptList(empId);
            levelDeptMap = deptInfoDTOList.stream().collect(Collectors.groupingBy(UserDeptInfoDTO::getLevel));
        }
        Map<Long, String> folderIdMap = folderList.stream().collect(Collectors.toMap(Folder::getId, Folder::getName));
        for (FineReport x2 : fineReportList) {
            FineReportVo fineReportVo = (FineReportVo)this.converter.convert((Object)x2, FineReportVo.class);
            fineReportVo.setFolderName(folderIdMap.get(x2.getFolderId()));
            StringBuilder reportUrl = new StringBuilder(fineReportVo.getUrl());
            if (x2.getUserConfigFlag() != null && Constants.DEFAULT_CONFIGURED_FLAG_YES.equals(x2.getUserConfigFlag())) {
                reportUrl.append(reportUrl.toString().contains("?") ? "&" : "?").append("userId=").append(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
            }
            if (MapUtils.isNotEmpty((Map)levelDeptMap)) {
                String deptId = CollectionUtils.isNotEmpty((Collection)((Collection)levelDeptMap.get(x2.getDepartmentConfigFlag()))) ? ((UserDeptInfoDTO)((List)levelDeptMap.get(x2.getDepartmentConfigFlag())).get(0)).getDeptId() : ((UserDeptInfoDTO)((List)levelDeptMap.get(1)).get(0)).getDeptId();
                reportUrl.append(reportUrl.toString().contains("?") ? "&" : "?").append("departmentId=").append(deptId);
            }
            if (StringUtils.isNotBlank((CharSequence)x2.getFactoryConfigName())) {
                reportUrl.append(reportUrl.toString().contains("?") ? "&" : "?").append("plant=").append(x2.getFactoryConfigName());
            }
            fineReportVo.setUrl(reportUrl.toString());
            resultFineReportList.add(fineReportVo);
        }
        return resultFineReportList.stream().sorted(Comparator.comparing(FineReportVo::getFolderName, Comparator.nullsLast(String::compareTo)).thenComparing(FineReportVo::getReportOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(FineReportVo::getCreateTime, Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
    }

    private List<UserDeptInfoDTO> queryDeptList(String empId) {
        ArrayList noRepeatDeptList = Lists.newArrayList();
        List deptInfoDTOList = this.eocService.queryUserDeptList(empId);
        if (CollectionUtils.isNotEmpty((Collection)deptInfoDTOList)) {
            Map deptInfoDTOMap = deptInfoDTOList.stream().collect(Collectors.toMap(UserDeptInfoDTO::getDeptSid, Function.identity(), (a, b) -> a));
            noRepeatDeptList = Lists.newArrayList(deptInfoDTOMap.values());
            List firstLevelDeptList = noRepeatDeptList.stream().filter(x -> x.getParentDeptSid() == 0L).peek(x -> x.setLevel(Integer.valueOf(1))).collect(Collectors.toList());
            List firstLevelDeptSidList = firstLevelDeptList.stream().map(UserDeptInfoDTO::getDeptSid).collect(Collectors.toList());
            List secondLevelDeptList = noRepeatDeptList.stream().filter(x -> firstLevelDeptSidList.contains(x.getParentDeptSid())).peek(x -> x.setLevel(Integer.valueOf(2))).collect(Collectors.toList());
            List secondLevelDeptSidList = secondLevelDeptList.stream().map(UserDeptInfoDTO::getDeptSid).collect(Collectors.toList());
            List list = noRepeatDeptList.stream().filter(x -> !firstLevelDeptSidList.contains(x.getDeptSid()) && !secondLevelDeptSidList.contains(x.getDeptSid())).peek(x -> x.setLevel(Integer.valueOf(3))).collect(Collectors.toList());
        }
        return noRepeatDeptList;
    }

    public Boolean delFolderData() {
        return null;
    }

    public boolean isReportExist(int type, FineReportVo fineReportVo) {
        QueryWrapper condition = new QueryWrapper();
        if (Objects.nonNull(fineReportVo.getId())) {
            condition.ne((Object)"id", (Object)fineReportVo.getId());
        }
        if (type == 1) {
            condition.eq((Object)"name", (Object)fineReportVo.getName());
            return this.exists((Wrapper)condition);
        }
        if (type == 2) {
            condition.eq((Object)"url", (Object)fineReportVo.getUrl());
            return this.exists((Wrapper)condition);
        }
        return false;
    }

    public Integer queryMaxOrder(Long folderId, String tenantId) {
        return this.fineReportMapper.queryMaxOrder(folderId, tenantId);
    }

    public List<FolderViewVo> qryFineReportFolder(Integer scene) {
        FolderViewVo folderViewVo;
        List thirdFolderIdList;
        List bizObjAuthRelList;
        ArrayList folderRespList = Lists.newArrayList();
        List folderList = this.folderMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).orderByAsc((Object)"folder_order"));
        if (CollectionUtils.isEmpty((Collection)folderList)) {
            Folder folder = Folder.builder().name("\u62a5\u8868\u76ee\u5f55").objType(FolderTypeEnum.FINE_REPORT.getValue()).level(Integer.valueOf(1)).folderOrder(Integer.valueOf(1)).build();
            this.folderMapper.insertFolder(folder);
            FolderViewVo folderViewVo2 = (FolderViewVo)this.converter.convert((Object)folder, FolderViewVo.class);
            folderRespList.add(folderViewVo2);
            return folderRespList;
        }
        List reportCountList = this.folderMapper.queryFolderReportCount();
        Map<Long, Integer> folderIdMap = reportCountList.stream().collect(Collectors.toMap(ReportCountVo::getFolderId, ReportCountVo::getReportCount));
        Map<Object, Object> authRelReportMap = Maps.newHashMap();
        if (Objects.equals(BusinessSceneEnum.PORTAL.getValue(), scene) && CollectionUtils.isNotEmpty((Collection)(bizObjAuthRelList = this.bizObjAuthRelService.qryBizObjAuthRel(BizObjectTypeEnum.FINE_REPORT.getValue())))) {
            Set reportIdSet = bizObjAuthRelList.stream().map(BizObjAuthRel::getBizObjId).collect(Collectors.toSet());
            List reportList = this.fineReportMapper.selectBatchIds((Collection)reportIdSet);
            authRelReportMap = reportList.stream().collect(Collectors.groupingBy(FineReport::getFolderId));
        }
        List firstFolderList = folderList.stream().filter(x -> x.getParentFolderId() == null).collect(Collectors.toList());
        for (Object folder : firstFolderList) {
            int totalReportCount = this.buildTotalReportCount(folderIdMap, (Map)authRelReportMap, scene, (Folder)folder);
            List secondFolderIdList = folderList.stream().filter(arg_0 -> FineReportServiceImpl.lambda$qryFineReportFolder$13((Folder)folder, arg_0)).map(Folder::getId).collect(Collectors.toList());
            totalReportCount = this.AccumulatedTotalReportCount(folderIdMap, (Map)authRelReportMap, scene, secondFolderIdList, totalReportCount);
            thirdFolderIdList = folderList.stream().filter(x -> secondFolderIdList.contains(x.getParentFolderId())).map(Folder::getId).collect(Collectors.toList());
            totalReportCount = this.AccumulatedTotalReportCount(folderIdMap, (Map)authRelReportMap, scene, thirdFolderIdList, totalReportCount);
            folderViewVo = (FolderViewVo)this.converter.convert(folder, FolderViewVo.class);
            folderViewVo.setChildCount(Integer.valueOf(secondFolderIdList.size()));
            folderViewVo.setDataCount(Integer.valueOf(totalReportCount));
            folderRespList.add(folderViewVo);
        }
        List secondLevelList = folderList.stream().filter(x -> FolderLevelEnum.SECOND.getValue().equals(x.getLevel())).collect(Collectors.toList());
        for (Folder folder : secondLevelList) {
            int totalReportCount = this.buildTotalReportCount(folderIdMap, (Map)authRelReportMap, scene, folder);
            thirdFolderIdList = folderList.stream().filter(x -> Objects.equals(folder.getId(), x.getParentFolderId())).map(Folder::getId).collect(Collectors.toList());
            totalReportCount = this.AccumulatedTotalReportCount(folderIdMap, (Map)authRelReportMap, scene, thirdFolderIdList, totalReportCount);
            folderViewVo = (FolderViewVo)this.converter.convert((Object)folder, FolderViewVo.class);
            folderViewVo.setChildCount(Integer.valueOf(thirdFolderIdList.size()));
            folderViewVo.setDataCount(Integer.valueOf(totalReportCount));
            folderRespList.add(folderViewVo);
        }
        List thirdLevelList = folderList.stream().filter(x -> FolderLevelEnum.THIRD.getValue().equals(x.getLevel())).collect(Collectors.toList());
        for (Folder folder : thirdLevelList) {
            FolderViewVo folderViewVo3 = (FolderViewVo)this.converter.convert((Object)folder, FolderViewVo.class);
            if (Objects.equals(BusinessSceneEnum.BACK_MANAGEMENT.getValue(), scene)) {
                folderViewVo3.setDataCount(folderIdMap.get(folder.getId()));
            } else {
                folderViewVo3.setDataCount(Integer.valueOf(!Objects.isNull(authRelReportMap.get(folder.getId())) ? ((List)authRelReportMap.get(folder.getId())).size() : 0));
            }
            folderRespList.add(folderViewVo3);
        }
        List<FolderViewVo> firstFolderViewList = folderRespList.stream().filter(x -> x.getParentFolderId() == null).collect(Collectors.toList());
        this.buildTree(firstFolderViewList, (List)folderRespList);
        return firstFolderViewList;
    }

    private void buildTree(List<FolderViewVo> parentFolderList, List<FolderViewVo> allFolderList) {
        for (FolderViewVo parent : parentFolderList) {
            List childFolderList = allFolderList.stream().filter(x -> parent.getId().equals(x.getParentFolderId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(childFolderList)) continue;
            parent.setChildren(childFolderList);
            this.buildTree(childFolderList, allFolderList);
        }
    }

    private int buildTotalReportCount(Map<Long, Integer> folderIdMap, Map<Long, List<FineReport>> authRelReportMap, Integer scene, Folder folder) {
        if (Objects.equals(BusinessSceneEnum.BACK_MANAGEMENT.getValue(), scene)) {
            return MapUtils.isNotEmpty(folderIdMap) && !Objects.isNull(folderIdMap.get(folder.getId())) ? folderIdMap.get(folder.getId()) : 0;
        }
        return MapUtils.isNotEmpty(authRelReportMap) && !Objects.isNull(authRelReportMap.get(folder.getId())) ? authRelReportMap.get(folder.getId()).size() : 0;
    }

    private int AccumulatedTotalReportCount(Map<Long, Integer> folderIdMap, Map<Long, List<FineReport>> authRelReportMap, Integer scene, List<Long> folderIdList, int totalReportCount) {
        if (CollectionUtils.isEmpty(folderIdList)) {
            return totalReportCount;
        }
        for (Long id : folderIdList) {
            if (BusinessSceneEnum.BACK_MANAGEMENT.getValue().equals(scene) && !MapUtils.isEmpty(folderIdMap) && !Objects.isNull(folderIdMap.get(id))) {
                totalReportCount += folderIdMap.get(id).intValue();
            }
            if (!BusinessSceneEnum.PORTAL.getValue().equals(scene) || MapUtils.isEmpty(authRelReportMap) || Objects.isNull(authRelReportMap.get(id))) continue;
            totalReportCount += authRelReportMap.get(id).size();
        }
        return totalReportCount;
    }

    public void saveReportUrlParam(SaveReportUrlParamReq saveReportUrlParamReq) {
        this.fineReportMapper.batchUpdateParam(saveReportUrlParamReq, saveReportUrlParamReq.getIds(), AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
    }

    public FineReport queryFineReportById(Long reportId, Integer scene) {
        FineReport fineReport;
        if (BusinessSceneEnum.BACK_MANAGEMENT.getValue().equals(scene)) {
            fineReport = (FineReport)this.fineReportMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)reportId));
        } else {
            List bizObjAuthRelList = this.bizObjAuthRelService.qryBizObjAuthRel(BizObjectTypeEnum.FINE_REPORT.getValue());
            if (CollectionUtils.isEmpty((Collection)bizObjAuthRelList)) {
                return null;
            }
            boolean existFlag = bizObjAuthRelList.stream().anyMatch(x -> String.valueOf(reportId).equals(x.getBizObjId()));
            if (!existFlag) {
                return null;
            }
            fineReport = (FineReport)this.fineReportMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)reportId));
        }
        return fineReport;
    }

    public boolean exists(Wrapper<FineReport> queryWrapper) {
        Long count = this.fineReportMapper.selectCount(queryWrapper);
        return null != count && count > 0L;
    }

    private static /* synthetic */ boolean lambda$qryFineReportFolder$13(Folder folder, Folder x) {
        return Objects.equals(folder.getId(), x.getParentFolderId());
    }
}

