/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.FolderTypeEnum;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.common.ImportRecord;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.common.ImportRecordMapper;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.vo.common.ImportRecordResp;
import com.digiwin.athena.semc.vo.portal.ImportExcelVo;
import com.digiwin.athena.semc.vo.portal.ImportLabelExcelVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCBuilder;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import io.github.linpeilie.Converter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImportReportServiceImpl
extends ServiceImpl<ImportRecordMapper, ImportRecord>
implements IImportRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportReportServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Autowired
    ImportRecordMapper importRecordMapper;
    @Resource
    private Converter converter;
    public static final String DMC_FILE_PREVIEW_PATH = "/api/dmc/v2/file/intelligententry/preview/";

    public void insertImportRecord(ImportRecord importRecord) {
        this.save((Object)importRecord);
    }

    public List<ImportExcelVo> readExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(ImportExcelVo.class)).headRowNumber(Integer.valueOf(1))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = ImportReportServiceImpl.doReadSync((SyncReadListener)excelListener);
        }
        catch (Exception e) {
            log.error("FineReportServiceImpl read excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    public List<ImportLabelExcelVo> readLabelExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(ImportLabelExcelVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = ImportReportServiceImpl.doReadSync((SyncReadListener)excelListener);
        }
        catch (Exception e) {
            log.error("read label excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    private DMC buildDmc() {
        return DMCBuilder.create().build(this.envProperties.getDmcUri(), "entrance", "entrance123456", this.envProperties.getSemcAppId());
    }

    private static <T> List<T> doReadSync(SyncReadListener listener) {
        return listener.getList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShareInfo uploadExcel(File file) {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] bytes = new byte[input.available()];
            int readLine = input.read(bytes);
            if (readLine <= 0) {
                log.info("upload excel file is empty");
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(file.getName());
            fileInfo.setExtension("xlsx");
            ShareInfo shareInfo = this.uploadAndShareFile(bytes, fileInfo);
            return shareInfo;
        }
        catch (Exception e) {
            log.error("upload excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private ShareInfo uploadAndShareFile(byte[] bytes, FileInfo fileInfo) throws Exception {
        DMC instance = this.buildDmc();
        FileInfo uploadFile = instance.upload(bytes, fileInfo);
        return instance.share(uploadFile.getId());
    }

    public List<ImportRecord> queryOperatorList() {
        try {
            QueryWrapper condition = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"obj_type", (Object)FolderTypeEnum.FINE_REPORT.getValue())).eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            return this.importRecordMapper.selectList((Wrapper)condition);
        }
        catch (Exception e) {
            log.error("ImportReportServiceImpl query operator list occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PageInfoResp<ImportRecordResp> queryImportRecord(QueryImportRecordReq queryImportRecordReq, Integer sceneFlag) {
        try {
            QueryWrapper condition = new QueryWrapper();
            if (CollectionUtils.isNotEmpty((Collection)queryImportRecordReq.getUserIdList())) {
                condition.in((Object)"create_user_id", (Collection)queryImportRecordReq.getUserIdList());
            }
            if (StringUtils.isBlank((CharSequence)queryImportRecordReq.getStartTime()) || StringUtils.isBlank((CharSequence)queryImportRecordReq.getEndTime())) {
                String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
                condition.ge((Object)"create_time", (Object)DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
                condition.le((Object)"create_time", (Object)currentDate);
            } else {
                condition.ge((Object)"create_time", (Object)queryImportRecordReq.getStartTime());
                condition.le((Object)"create_time", (Object)queryImportRecordReq.getEndTime());
            }
            if (StrUtil.isNotBlank((CharSequence)queryImportRecordReq.getUserIdName())) {
                condition.and(i -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)i.like((Object)"create_user_name", (Object)queryImportRecordReq.getUserIdName());
                });
            }
            ((QueryWrapper)((QueryWrapper)condition.eq((Object)"obj_type", (Object)sceneFlag)).eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId())).orderByDesc((Object)"create_time");
            PageInfoResp pageInfoResp = new PageInfoResp();
            Page pageResult = (Page)this.importRecordMapper.selectPage((IPage)new Page((long)queryImportRecordReq.getPageNum().intValue(), (long)queryImportRecordReq.getPageSize().intValue()), (Wrapper)condition);
            if (pageResult == null || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
                return pageInfoResp;
            }
            List respList = pageResult.getRecords().stream().map(x -> {
                ImportRecordResp resp = (ImportRecordResp)this.converter.convert(x, ImportRecordResp.class);
                resp.setFileUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + x.getFileId().trim());
                return resp;
            }).collect(Collectors.toList());
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setPageNo(queryImportRecordReq.getPageNum().intValue());
            pageInfoResp.setPageSize(queryImportRecordReq.getPageSize().intValue());
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
            pageInfoResp.setList(respList);
            return pageInfoResp;
        }
        catch (Exception e) {
            log.error("ImportReportServiceImpl query import record occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

