/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationListReq;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationListResp;
import com.digiwin.athena.semc.dto.portal.KnowledgeApplicationNewDataReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.portal.KnowledgeApplicationRef;
import com.digiwin.athena.semc.mapper.common.BizObjAuthRelMapper;
import com.digiwin.athena.semc.mapper.portal.KnowledgeApplicationMapper;
import com.digiwin.athena.semc.proxy.ania.service.AniaService;
import com.digiwin.athena.semc.proxy.ania.service.model.KnowledgeAssistantDTO;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.UserDTO;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.portal.IknowledgeApplicationService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeApplicationServiceImpl
extends ServiceImpl<KnowledgeApplicationMapper, KnowledgeApplicationRef>
implements IknowledgeApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KnowledgeApplicationServiceImpl.class);
    @Autowired
    private KnowledgeApplicationMapper knowledgeApplicationMapper;
    @Resource
    private BizObjAuthRelMapper bizObjAuthRelMapper;
    @Autowired
    private AniaService aniaService;
    @Autowired
    private IamService iamService;
    @Autowired
    private EocService eocService;
    @Autowired
    private AppLinkService appLinkService;

    public ResponseBody getKnowledgeApplicationList(KnowledgeApplicationListReq req) {
        ArrayList<KnowledgeApplicationListResp> result = new ArrayList<KnowledgeApplicationListResp>();
        List list = this.knowledgeApplicationMapper.selectByPage(req.getIsEnable());
        Integer total = 0;
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ResponseBody.getInstance(result, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)total));
        }
        List kList = this.aniaService.getKnowledgeAssistants(req.getTenantId());
        HashMap<String, KnowledgeAssistantDTO> xx = new HashMap<String, KnowledgeAssistantDTO>();
        if (CollectionUtils.isNotEmpty((Collection)kList)) {
            for (KnowledgeAssistantDTO knowledgeAssistantDTO : kList) {
                xx.put(knowledgeAssistantDTO.getAssistantCode(), knowledgeAssistantDTO);
            }
        }
        Map appMap = this.getAppMap();
        list = list.stream().filter(d -> {
            String requestUp;
            boolean nameType;
            if (StringUtils.isBlank((CharSequence)req.getApplication())) {
                return true;
            }
            AppLinkDTO appLinkDTO = (AppLinkDTO)appMap.get("" + d.getApplicationType() + "@@@" + d.getApplicationId());
            if (Objects.isNull(appLinkDTO) || StringUtils.isBlank((CharSequence)appLinkDTO.getName())) {
                nameType = false;
            } else {
                String nameUp = appLinkDTO.getName().toUpperCase();
                requestUp = req.getApplication().toUpperCase();
                nameType = nameUp.contains(requestUp);
            }
            String idUp = d.getApplicationId().toUpperCase();
            requestUp = req.getApplication().toUpperCase();
            boolean idType = idUp.contains(requestUp);
            return nameType || idType;
        }).filter(d -> {
            String requestUp;
            boolean nameType;
            if (StringUtils.isBlank((CharSequence)req.getKnowledge())) {
                return true;
            }
            KnowledgeAssistantDTO assistantDTO = (KnowledgeAssistantDTO)xx.get(d.getKnowledgeId());
            if (Objects.isNull(assistantDTO) || StringUtils.isBlank((CharSequence)assistantDTO.getName())) {
                nameType = false;
            } else {
                String nameUp = assistantDTO.getName().toUpperCase();
                requestUp = req.getKnowledge().toUpperCase();
                nameType = nameUp.contains(requestUp);
            }
            String idUp = d.getKnowledgeId().toUpperCase();
            requestUp = req.getKnowledge().toUpperCase();
            boolean idType = idUp.contains(requestUp);
            return nameType || idType;
        }).collect(Collectors.toList());
        total = list.size();
        int fromIndex = (req.getPageNum() - 1) * req.getPageSize();
        if (fromIndex >= list.size() || fromIndex < 0) {
            return ResponseBody.getInstance(result, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)total));
        }
        int toIndex = fromIndex + req.getPageSize();
        if (toIndex > list.size()) {
            toIndex = list.size();
        }
        list = list.subList(fromIndex, toIndex);
        for (KnowledgeApplicationRef knowledgeApplicationRef : list) {
            KnowledgeApplicationListResp resp = new KnowledgeApplicationListResp();
            resp.setApplicationId(knowledgeApplicationRef.getApplicationId());
            resp.setAppPrimaryId(knowledgeApplicationRef.getAppPrimaryId());
            resp.setKnowledgeId(knowledgeApplicationRef.getKnowledgeId());
            resp.setApplicationSource(knowledgeApplicationRef.getApplicationSource());
            resp.setApplicationType(knowledgeApplicationRef.getApplicationType());
            String applicationName = "";
            AppLinkDTO appLinkDTO = (AppLinkDTO)appMap.get("" + knowledgeApplicationRef.getApplicationType() + "@@@" + knowledgeApplicationRef.getApplicationId());
            if (Objects.nonNull(appLinkDTO)) {
                applicationName = appLinkDTO.getName();
            }
            resp.setApplicationName(applicationName);
            String knowledgeName = "";
            KnowledgeAssistantDTO assistantDTO = (KnowledgeAssistantDTO)xx.get(knowledgeApplicationRef.getKnowledgeId());
            if (Objects.nonNull(assistantDTO)) {
                knowledgeName = assistantDTO.getName();
            }
            resp.setKnowledgeName(knowledgeName);
            resp.setId(knowledgeApplicationRef.getId());
            resp.setIsEnable(knowledgeApplicationRef.getIsEnable());
            resp.setKnowledgeDesc(knowledgeName + "\uff08" + knowledgeApplicationRef.getKnowledgeId() + "\uff09");
            resp.setApplicationDes(applicationName + "\uff08" + knowledgeApplicationRef.getApplicationId() + "\uff09");
            resp.setModifyUserDesc(knowledgeApplicationRef.getModifyUserName() + "\uff08" + knowledgeApplicationRef.getModifyUserId() + "\uff09");
            resp.setCreateUserId(knowledgeApplicationRef.getCreateUserId());
            resp.setCreateTime(knowledgeApplicationRef.getCreateTime());
            resp.setModifyTime(knowledgeApplicationRef.getModifyTime());
            resp.setModifyUserId(knowledgeApplicationRef.getModifyUserId());
            resp.setModifyUserName(knowledgeApplicationRef.getModifyUserName());
            resp.setCreateUserName(knowledgeApplicationRef.getCreateUserName());
            result.add(resp);
        }
        return ResponseBody.getInstance(result, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)total));
    }

    public void batchInsertRecord(List<KnowledgeApplicationNewDataReq> reqList) {
        ArrayList<KnowledgeApplicationRef> result = new ArrayList<KnowledgeApplicationRef>();
        for (KnowledgeApplicationNewDataReq knowledgeApplicationNewDataReq : reqList) {
            KnowledgeApplicationRef ref = new KnowledgeApplicationRef();
            ref.setApplicationSource(knowledgeApplicationNewDataReq.getApplicationSource());
            ref.setApplicationType(knowledgeApplicationNewDataReq.getApplicationType());
            ref.setApplicationId(knowledgeApplicationNewDataReq.getApplicationId());
            ref.setAppPrimaryId(knowledgeApplicationNewDataReq.getAppPrimaryId());
            ref.setKnowledgeId(knowledgeApplicationNewDataReq.getKnowledgeId());
            ref.setIsEnable(knowledgeApplicationNewDataReq.getIsEnable());
            ref.setTenantId(knowledgeApplicationNewDataReq.getTenantId());
            ref.setModifyUserName(knowledgeApplicationNewDataReq.getModifyUserName());
            ref.setCreateUserName(knowledgeApplicationNewDataReq.getCreateUserName());
            result.add(ref);
        }
        this.saveBatch(result);
        List enableList = result.stream().filter(x -> Constants.VALID_STATUS_ENABLE.equals(x.getIsEnable())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(enableList)) {
            log.info("batchInsertRecord | batch insert record authorize user app, param:{}, actionType:{}", (Object)JSONObject.toJSONString(enableList), (Object)Constants.IamAuthorizeTypeEnum.INSERT.getVal());
            this.authorizeUserApp(enableList, Constants.IamAuthorizeTypeEnum.INSERT.getVal());
        }
    }

    public void authorizeUserApp(List<KnowledgeApplicationRef> result, Integer actionType) {
        List deptSidList;
        List roleSidList;
        List authRelList = this.bizObjAuthRelMapper.queryAuthListByAppId(result);
        log.info("KnowledgeApplicationServiceImpl | query auth list by appId, param:{}, result:{}", (Object)JSONObject.toJSONString(result), (Object)JSONObject.toJSONString((Object)authRelList));
        if (CollectionUtils.isEmpty((Collection)authRelList)) {
            return;
        }
        List orgUserList = Lists.newArrayList();
        List roleUserList = Lists.newArrayList();
        List deptUserList = Lists.newArrayList();
        List orgSidList = authRelList.stream().filter(x -> BizAuthTypeEnum.ORG.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgSidList)) {
            orgUserList = this.iamService.queryUserByAllOrgSidList(orgSidList);
            log.info("KnowledgeApplicationServiceImpl | query org user by orgSidList, param:{}, result:{}", (Object)JSONObject.toJSONString(orgSidList), (Object)JSONObject.toJSONString((Object)orgUserList));
        }
        if (CollectionUtils.isNotEmpty(roleSidList = authRelList.stream().filter(x -> BizAuthTypeEnum.ROLE.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList()))) {
            roleUserList = this.iamService.queryUserByAllRoleSidList(roleSidList);
        }
        if (CollectionUtils.isNotEmpty(deptSidList = authRelList.stream().filter(x -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList()))) {
            deptUserList = this.eocService.queryUserByDeptSidList(deptSidList);
            log.info("KnowledgeApplicationServiceImpl | query user by deptSidList, param:{}, result:{}", (Object)JSONObject.toJSONString(deptSidList), (Object)JSONObject.toJSONString((Object)deptUserList));
        }
        Map<String, List<BizObjAuthRel>> appIdMap = authRelList.stream().collect(Collectors.groupingBy(x -> x.getBizObjSubType() + "-" + x.getBizObjId()));
        for (KnowledgeApplicationRef applicationRef : result) {
            List<BizObjAuthRel> appAuthRelList = appIdMap.get(applicationRef.getApplicationType() + "-" + applicationRef.getAppPrimaryId());
            if (CollectionUtils.isEmpty(appAuthRelList)) continue;
            ArrayList allUserSidList = Lists.newArrayList();
            List currentOrgSidList = appAuthRelList.stream().filter(x -> BizAuthTypeEnum.ORG.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList());
            orgUserList.forEach(x -> {
                if (currentOrgSidList.contains(x.getOrgSid())) {
                    List userSidList = x.getUsers().stream().map(UserDTO::getSid).collect(Collectors.toList());
                    allUserSidList.addAll(userSidList);
                }
            });
            List currentRoleSidList = appAuthRelList.stream().filter(x -> BizAuthTypeEnum.ROLE.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList());
            roleUserList.forEach(x -> {
                if (currentRoleSidList.contains(x.getRoleSid())) {
                    List userSidList = x.getUsers().stream().map(UserDTO::getSid).collect(Collectors.toList());
                    allUserSidList.addAll(userSidList);
                }
            });
            List currentDeptSidList = appAuthRelList.stream().filter(x -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).distinct().collect(Collectors.toList());
            deptUserList.forEach(x -> {
                if (currentDeptSidList.contains(x.getDeptSid())) {
                    ArrayList userSidList = Lists.newArrayList();
                    x.getEmps().forEach(empInfo -> {
                        if (ObjectUtils.isNotEmpty((Object)empInfo.getEmpUserSid())) {
                            userSidList.add(empInfo.getEmpUserSid());
                        }
                    });
                    allUserSidList.addAll(userSidList);
                }
            });
            List userSidList = appAuthRelList.stream().filter(x -> BizAuthTypeEnum.USER.getValue().equals(x.getAuthType())).map(BizObjAuthRel::getAuthId).collect(Collectors.toList());
            allUserSidList.addAll(userSidList);
            List partList = Lists.partition((List)allUserSidList, (int)100);
            for (List tempList : partList) {
                log.info("KnowledgeApplicationServiceImpl | start batch user authorize app, appId:{}, userSid:{}, actionType:{}", new Object[]{applicationRef.getApplicationId(), JSONObject.toJSONString((Object)tempList), actionType});
                this.iamService.batchUserAuthorizeApp(applicationRef.getKnowledgeId(), tempList, actionType);
            }
        }
    }

    private Map<String, AppLinkDTO> getAppMap() {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List appLinkListDTO = this.appLinkService.queryManageListSync(user);
        appLinkListDTO = this.filterRepeatApp(appLinkListDTO);
        HashMap<String, AppLinkDTO> result = new HashMap<String, AppLinkDTO>();
        if (CollectionUtils.isNotEmpty((Collection)appLinkListDTO)) {
            for (AppLinkDTO appLinkDTO : appLinkListDTO) {
                result.put("" + appLinkDTO.getType() + "@@@" + appLinkDTO.getCode(), appLinkDTO);
            }
        }
        return result;
    }

    private List<AppLinkDTO> filterRepeatApp(List<AppLinkDTO> appLinkListDT) {
        ArrayList<AppLinkDTO> appLinkDTOList = new ArrayList<AppLinkDTO>();
        List matchedLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType())).collect(Collectors.toList());
        Map preListMap = matchedLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getAppId, Function.identity(), (a, b) -> a));
        List iamLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        Map iamListMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity(), (a, b) -> a));
        for (AppLinkDTO appLink : appLinkListDT) {
            AppLinkDTO iamData = (AppLinkDTO)iamListMap.get(appLink.getAppId());
            if (appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != iamData) continue;
            AppLinkDTO preData = (AppLinkDTO)preListMap.get(appLink.getPrimaryId());
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != preData) {
                appLink.setName(preData.getName());
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appLink.getCode()})) continue;
            appLinkDTOList.add(appLink);
        }
        return appLinkDTOList;
    }
}

