/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.dto.portal.LabelResp;
import com.digiwin.athena.semc.dto.portal.QueryLabelReq;
import com.digiwin.athena.semc.entity.portal.Label;
import com.digiwin.athena.semc.mapper.portal.LabelMapper;
import com.digiwin.athena.semc.service.portal.ILabelService;
import com.google.common.collect.Lists;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class LabelServiceImpl
extends ServiceImpl<LabelMapper, Label>
implements ILabelService {
    @Autowired
    LabelMapper labelMapper;
    @Resource
    private Converter converter;

    public List<LabelResp> queryLabelList(QueryLabelReq queryLabelReq) {
        ArrayList labelRespList = Lists.newArrayList();
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)queryLabelReq.getLabelIdList())) {
            condition.in((Object)"id", (Collection)queryLabelReq.getLabelIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryLabelReq.getSystemFlag())) {
            condition.in((Object)"system_flag", (Collection)queryLabelReq.getSystemFlag());
        }
        if (StringUtils.isNotBlank((CharSequence)queryLabelReq.getLabelKey())) {
            condition.eq((Object)"label_key", (Object)queryLabelReq.getLabelKey());
        }
        if (queryLabelReq.getValidStatus() != null) {
            condition.eq((Object)"valid_status", (Object)queryLabelReq.getValidStatus());
        }
        condition.orderByAsc((Object)"system_flag");
        List labelList = this.labelMapper.selectList((Wrapper)condition);
        if (CollectionUtils.isEmpty((Collection)labelList)) {
            return labelRespList;
        }
        String locale = LocaleContextHolder.getLocale().toString();
        labelList.forEach(x -> {
            LabelResp labelResp = (LabelResp)this.converter.convert(x, LabelResp.class);
            if (StringUtils.isBlank((CharSequence)locale) || locale.equals("zh_TW")) {
                labelResp.setTitle(x.getTitleTw());
            } else if (locale.equals("zh_CN")) {
                labelResp.setTitle(x.getTitleCn());
            } else {
                labelResp.setTitle(x.getTitleUs());
            }
            labelResp.setTitle(StringUtils.isBlank((CharSequence)labelResp.getTitle()) ? x.getTitleTw() : labelResp.getTitle());
            labelRespList.add(labelResp);
        });
        return labelRespList;
    }

    public Label queryLabelInfo(long labelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)labelId);
        return (Label)this.labelMapper.selectOne((Wrapper)queryWrapper);
    }

    public int updateLabelStatus(Long labelId, Integer status) {
        return this.labelMapper.updateLabelStatus(labelId, status, AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
    }
}

