/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemAuth;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.portal.LabelSystemAuthMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.athena.service.atmc.AtmcService;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupRuleDTO;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptDTO;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserInfoDetailDTO;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.UserOrgInfoDTO;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.PortalLayoutCustomService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.common.UserSystemLabelVo;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LabelSystemAuthServiceImpl
extends ServiceImpl<LabelSystemAuthMapper, LabelSystemAuth>
implements LabelSystemAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemAuthServiceImpl.class);
    @Autowired
    LabelSystemAuthMapper labelSystemAuthMapper;
    @Resource
    private TranslateService translateService;
    @Resource
    private LabelSystemPreService labelSystemPreService;
    @Resource
    private LabelSystemCustomService labelSystemCustomService;
    @Autowired
    LabelSystemPreMapper labelSystemPreMapper;
    @Resource
    LabelSystemCustomMapper labelSystemCustomMapper;
    @Resource
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Resource
    LabelSystemDataMapper labelSystemDataMapper;
    @Resource
    private IamService iamService;
    @Resource
    private EocService eocService;
    @Resource
    private PortalLayoutCustomService portalLayoutCustomService;
    @Resource
    ErpSsoInfoMapper erpSsoInfoMapper;
    @Resource
    ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Resource
    PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Resource
    IPreinstalledApplicationService preinstalledApplicationService;
    @Resource
    private AtmcService atmcService;
    @Resource(name="semcAsyncExecutor")
    private Executor asyncTaskExecutor;
    @Autowired
    private MobileUserAuthService mobileUserAuthService;
    @Resource
    private IamUserService iamUserService;

    @Transactional
    public Integer saveSystemAuth(BizObjAuthRelBatchSystemReq req) {
        List authList = req.getAuthList();
        ArrayList bizObjAuthRelList = new ArrayList();
        authList.forEach(authVO -> {
            for (BizObjAuthRelBatchSystemReq.LabelVO labelVO : req.getLabelList()) {
                LabelSystemAuth bizObjAuthRel = new LabelSystemAuth();
                bizObjAuthRel.setAuthId(authVO.getAuthId());
                bizObjAuthRel.setAuthType(authVO.getAuthType());
                bizObjAuthRel.setAuthName(authVO.getAuthName());
                bizObjAuthRel.setLabelId(labelVO.getLabelId());
                bizObjAuthRel.setLabelType(labelVO.getLabelType());
                if (null != labelVO.getIsRelated() && !labelVO.getIsRelated().booleanValue()) {
                    this.delSystemAuth(authVO.getAuthId(), authVO.getAuthType(), labelVO.getLabelId(), labelVO.getLabelType());
                    continue;
                }
                List dbSystemAuthList = this.getSystemAuth(authVO.getAuthId(), authVO.getAuthType(), labelVO.getLabelId(), labelVO.getLabelType());
                if (null != labelVO.getIsRelated() && !labelVO.getIsRelated().booleanValue() || !CollectionUtils.isEmpty((Collection)dbSystemAuthList)) continue;
                bizObjAuthRelList.add(bizObjAuthRel);
            }
        });
        if (CollectionUtils.isNotEmpty(bizObjAuthRelList)) {
            this.saveBatch(bizObjAuthRelList);
        }
        return null;
    }

    public Integer saveSystemAuthAll(AuthSystemLabelReq req) {
        if (!req.getIsRelated().booleanValue()) {
            return this.labelSystemAuthMapper.delLabelAuth(req.getAuthId());
        }
        List systemVoList = this.labelSystemAuthMapper.selectByLabelList(Utils.getTenantId());
        if (CollectionUtils.isEmpty((Collection)systemVoList)) {
            return null;
        }
        List systemAuthList = this.labelSystemAuthMapper.selectByAuth(req.getAuthId());
        Map<Object, Object> systemAuthMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)systemAuthList)) {
            systemAuthMap = systemAuthList.stream().collect(Collectors.groupingBy(x -> x.getLabelType() + "-" + x.getLabelId()));
        }
        ArrayList<LabelSystemAuth> insertAuthList = new ArrayList<LabelSystemAuth>();
        for (BizObjAuthRelBatchSystemVo systemVo : systemVoList) {
            LabelSystemAuth bizObjAuthRel = new LabelSystemAuth();
            bizObjAuthRel.setAuthId(req.getAuthId());
            bizObjAuthRel.setAuthType(req.getAuthType());
            bizObjAuthRel.setAuthName(req.getAuthName());
            bizObjAuthRel.setCreateTime(DateUtils.getNowTime((String)""));
            bizObjAuthRel.setCreateUserId(Utils.getUserId());
            bizObjAuthRel.setTenantId(Utils.getTenantId());
            bizObjAuthRel.setLabelId(systemVo.getLabelId());
            bizObjAuthRel.setLabelType(systemVo.getLabelType());
            List authList = (List)systemAuthMap.get(systemVo.getLabelType() + "-" + systemVo.getLabelId());
            if (!CollectionUtils.isEmpty((Collection)authList)) continue;
            insertAuthList.add(bizObjAuthRel);
        }
        if (CollectionUtils.isNotEmpty(insertAuthList)) {
            this.labelSystemAuthMapper.batchSaveAuth(insertAuthList);
        }
        return null;
    }

    public List<LabelSystemAuth> getSystemAuth(Long authId, Integer authType, Long labelId, Integer labelType) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"auth_id", (Object)authId);
        condition.eq((Object)"auth_type", (Object)authType);
        condition.eq((Object)"label_id", (Object)labelId);
        condition.eq((Object)"label_type", (Object)labelType);
        return this.labelSystemAuthMapper.selectList((Wrapper)condition);
    }

    public void delSystemAuth(Long authId, Integer authType, Long labelId, Integer labelType) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"auth_id", (Object)authId);
        condition.eq((Object)"auth_type", (Object)authType);
        condition.eq((Object)"label_id", (Object)labelId);
        condition.eq((Object)"label_type", (Object)labelType);
        this.labelSystemAuthMapper.delete((Wrapper)condition);
    }

    public ResultPageBean pageListAuthSystem(AuthSystemLabelReq req) throws ExecutionException, InterruptedException {
        Page authLabelPageList;
        this.labelSystemPreService.initPreData(req.getClientType());
        List labelSystemAuthList = new ArrayList();
        Map<Object, Object> labelSystemAuthMap = new HashMap();
        if (null != req.getAuthId()) {
            QueryWrapper condition = new QueryWrapper();
            condition.in((Object)"auth_id", new Object[]{req.getAuthId()});
            labelSystemAuthList = this.labelSystemAuthMapper.selectList((Wrapper)condition);
            labelSystemAuthMap = labelSystemAuthList.stream().collect(Collectors.toMap(value -> value.getLabelId() + "-" + value.getLabelType(), value -> value, (key1, key2) -> key1));
        }
        List<Object> systemSourcePreList = new ArrayList();
        List<Object> systemSourceCustomList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)req.getAppCodeList())) {
            List systemSourceList = this.labelSystemSourceMapper.listSourceByData(req.getAppCodeList());
            if (CollectionUtils.isEmpty((Collection)systemSourceList)) {
                ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)systemSourceList, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)systemSourceList.size())));
                return resultPageBean;
            }
            systemSourcePreList = systemSourceList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getComponentSource())).collect(Collectors.toList());
            systemSourceCustomList = systemSourceList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(x.getComponentSource())).collect(Collectors.toList());
        }
        if (null != (authLabelPageList = this.pageListAuthLabel(req, systemSourcePreList, systemSourceCustomList)) && CollectionUtils.isNotEmpty((Collection)authLabelPageList.getRecords())) {
            List systemVoList = this.packageLabel(authLabelPageList.getRecords(), labelSystemAuthMap);
            authLabelPageList.setRecords(systemVoList);
        }
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)authLabelPageList.getRecords(), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)Integer.parseInt(authLabelPageList.getTotal() + ""))));
        return resultPageBean;
    }

    public List<BizObjAuthRelBatchSystemVo> packageLabel(List<BizObjAuthRelBatchSystemVo> authLabelList, Map<String, LabelSystemAuth> labelSystemAuthMap) throws ExecutionException, InterruptedException {
        List systemSourceList = this.labelSystemSourceMapper.listSourceByLabel(authLabelList);
        HashMap<String, String> appNameMap = new HashMap<String, String>();
        Map<Object, Object> sourceDataMap = new HashMap();
        Map<Object, Object> systemDataMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)systemSourceList)) {
            Map iamAppLinkMap;
            Map preAppMap;
            Map thirdSsoInfoAppMap;
            sourceDataMap = systemSourceList.stream().collect(Collectors.toMap(value -> value.getSystemId() + "-" + value.getComponentSource(), value -> value.getDataId(), (key1, key2) -> key1));
            List dataIdList = systemSourceList.stream().map(LabelSystemSource::getDataId).collect(Collectors.toList());
            List labelSystemDataList = this.labelSystemDataMapper.selectBatchIds(dataIdList);
            systemDataMap = labelSystemDataList.stream().collect(Collectors.toMap(LabelSystemData::getId, y -> y, (a, b) -> a));
            List csList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
            List bsList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
            List athenaList = labelSystemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            CompletableFuture<Map> erpSsoInfo = CompletableFuture.supplyAsync(() -> this.getErpInfoMap(user, csList), this.asyncTaskExecutor);
            CompletableFuture<Map> queryThirdSsoInfo = CompletableFuture.supplyAsync(() -> this.getSsoInfoMap(user, bsList), this.asyncTaskExecutor);
            CompletableFuture<Map> queryPerInstallApp = CompletableFuture.supplyAsync(() -> this.getPreInfoMap(), this.asyncTaskExecutor);
            CompletableFuture<Map> queryDefaultGroup = CompletableFuture.supplyAsync(() -> this.getAthenaInfoMap(user, athenaList), this.asyncTaskExecutor);
            CompletableFuture.allOf(erpSsoInfo, queryThirdSsoInfo, queryPerInstallApp, queryDefaultGroup);
            Map erpSsoInfoAppMap = erpSsoInfo.get();
            if (null != erpSsoInfoAppMap) {
                appNameMap.putAll(erpSsoInfoAppMap);
            }
            if (null != (thirdSsoInfoAppMap = queryThirdSsoInfo.get())) {
                appNameMap.putAll(thirdSsoInfoAppMap);
            }
            if (null != (preAppMap = queryPerInstallApp.get())) {
                appNameMap.putAll(preAppMap);
            }
            if (null != (iamAppLinkMap = queryDefaultGroup.get())) {
                appNameMap.putAll(iamAppLinkMap);
            }
            for (VirtualApplicationEnum virtualApplicationEnum : VirtualApplicationEnum.values()) {
                appNameMap.put(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType() + "_" + virtualApplicationEnum.getPrimaryId(), virtualApplicationEnum.getName());
            }
        }
        for (BizObjAuthRelBatchSystemVo authLabel : authLabelList) {
            LabelSystemData systemData;
            String key = authLabel.getLabelId() + "-" + authLabel.getLabelType();
            Boolean isRelated = labelSystemAuthMap.get(key) != null;
            authLabel.setIsRelated(isRelated);
            Long dataId = (Long)sourceDataMap.get(key);
            if (null == dataId || null == (systemData = (LabelSystemData)systemDataMap.get(dataId))) continue;
            String appName = (String)appNameMap.get(systemData.getDataType() + "_" + systemData.getAppCode());
            authLabel.setAppName(appName);
        }
        return authLabelList;
    }

    public Page<BizObjAuthRelBatchSystemVo> pageListAuthLabel(AuthSystemLabelReq req, List<LabelSystemSource> systemSourcePreList, List<LabelSystemSource> systemSourceCustomList) {
        List permSystemDataList = this.labelSystemDataMapper.queryAthenaAppList(new ArrayList(), VirtualApplicationEnum.ATHENA_APP.getPrimaryId());
        List<Object> permSystemIdList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)permSystemDataList)) {
            permSystemIdList = permSystemDataList.stream().map(LabelSystemData::getSystemId).collect(Collectors.toList());
        }
        Page relBatchSystemVoPage = new Page();
        if (CollectionUtils.isEmpty((Collection)req.getAppCodeList()) || CollectionUtils.isNotEmpty(systemSourcePreList) && CollectionUtils.isNotEmpty(systemSourceCustomList)) {
            Integer startNum = (req.getPageNum() - 1) * req.getPageSize();
            List relBatchSystemVoList = new ArrayList();
            Long totalNum = null;
            String locale = LocaleContextHolder.getLocale().toString();
            if ("zh_TW".equals(locale)) {
                relBatchSystemVoList = this.labelSystemAuthMapper.pageSelectAuthList(startNum, req.getPageSize(), null, req.getName(), Utils.getTenantId(), systemSourcePreList, systemSourceCustomList, permSystemIdList);
                totalNum = this.labelSystemAuthMapper.countAuthList(startNum, req.getPageSize(), null, req.getName(), Utils.getTenantId(), systemSourcePreList, systemSourceCustomList, permSystemIdList);
                relBatchSystemVoList.forEach(item -> {
                    if (StringUtils.isNotEmpty((CharSequence)item.getLabelNameTw())) {
                        item.setLabelName(item.getLabelNameTw());
                    }
                });
            } else {
                relBatchSystemVoList = this.labelSystemAuthMapper.pageSelectAuthList(startNum, req.getPageSize(), req.getName(), null, Utils.getTenantId(), systemSourcePreList, systemSourceCustomList, permSystemIdList);
                totalNum = this.labelSystemAuthMapper.countAuthList(startNum, req.getPageSize(), req.getName(), null, Utils.getTenantId(), systemSourcePreList, systemSourceCustomList, permSystemIdList);
            }
            relBatchSystemVoPage.setRecords(relBatchSystemVoList);
            relBatchSystemVoPage.setTotal(totalNum.longValue());
            return relBatchSystemVoPage;
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getAppCodeList()) && CollectionUtils.isNotEmpty(systemSourcePreList) && CollectionUtils.isEmpty(systemSourceCustomList)) {
            List preIdList = systemSourcePreList.stream().map(LabelSystemSource::getSystemId).collect(Collectors.toList());
            relBatchSystemVoPage = this.labelSystemPreService.pageListPre(preIdList, req);
            return relBatchSystemVoPage;
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getAppCodeList()) && CollectionUtils.isEmpty(systemSourcePreList) && CollectionUtils.isNotEmpty(systemSourceCustomList)) {
            List customIdList = systemSourceCustomList.stream().map(LabelSystemSource::getSystemId).collect(Collectors.toList());
            relBatchSystemVoPage = this.labelSystemCustomService.pageListCustom(customIdList, req, permSystemIdList);
            return relBatchSystemVoPage;
        }
        return relBatchSystemVoPage;
    }

    public Map<String, String> getPreInfoMap() {
        List preinstalledAppList = this.preinstalledApplicationMapper.selectList((Wrapper)new QueryWrapper());
        Map<String, String> preInfoMap = preinstalledAppList.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.PRESET_APPLICATION.getType() + "_" + value.getId(), value -> value.getApplicationName(), (key1, key2) -> key1));
        return preInfoMap;
    }

    public Map<String, String> getErpInfoMap(AuthoredUser user, List<LabelSystemData> csList) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        Map<String, String> erpInfoMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(csList)) {
            return erpInfoMap;
        }
        List thirdFolderIdList = csList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List erpInfoList = this.erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        erpInfoMap = erpInfoList.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.CS_APPLICATION.getType() + "_" + value.getId(), value -> value.getName(), (key1, key2) -> key1));
        return erpInfoMap;
    }

    public Map<String, String> getSsoInfoMap(AuthoredUser user, List<LabelSystemData> bsList) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        Map<String, String> thirdSsoInfoMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(bsList)) {
            return thirdSsoInfoMap;
        }
        List thirdFolderIdList = bsList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        List thirdSsoInfoList = this.thirdSsoInfoMapper.queryThirdListByScope(querySsoListReq);
        thirdSsoInfoMap = thirdSsoInfoList.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.BS_APPLICATION.getType() + "_" + value.getId(), value -> value.getAppName(), (key1, key2) -> key1));
        return thirdSsoInfoMap;
    }

    public Map<String, String> getAthenaInfoMap(AuthoredUser user, List<LabelSystemData> athenaList) {
        AppAuthContextHolder.getContext().setAuthoredUser(user);
        Map<String, String> athenaInfoMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(athenaList)) {
            return athenaInfoMap;
        }
        List allTenantApps = this.iamService.queryTenantApps();
        athenaInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> ApplicationTypeEnum.IAM_APPLICATION.getType() + "_" + value.getId(), value -> value.getName(), (key1, key2) -> key1));
        return athenaInfoMap;
    }

    public String addAppIDName(Map<Long, ErpSsoInfo> erpInfoMap, Map<Long, ThirdSsoInfo> thirdSsoInfoMap, Map<Long, PreinstalledApplication> preInfoMap, Map<String, String> athenaInfoMap, LabelSystemData systemData, Boolean type) {
        AuthoredUser user;
        List preInstalledAppList;
        Map preinstalledApplicationMap;
        PreinstalledApplication preinstalledApplication;
        ThirdSsoInfo thirdSsoInfo;
        ErpSsoInfo erpSsoInfo;
        String appName = "";
        String appCode = "";
        String appId = "";
        String systemType = "";
        String appToken = "";
        String callBackUrl = "";
        int isNeedSsoUrl = 0;
        int isFixedRefresh = 0;
        if (StringUtils.isEmpty((CharSequence)systemData.getAppCode())) {
            return appName;
        }
        if (null == systemData.getDataType()) {
            return appName;
        }
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemData.getDataType()) && null != (erpSsoInfo = erpInfoMap.get(Long.parseLong(systemData.getAppCode())))) {
            appName = erpSsoInfo.getName();
            appCode = erpSsoInfo.getCode();
            appId = erpSsoInfo.getAppId();
            systemType = "wt";
            appToken = erpSsoInfo.getAppToken();
            systemData.setProtocolType(erpSsoInfo.getProtocolType());
            callBackUrl = erpSsoInfo.getCallBackUrl();
        }
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemData.getDataType()) && (thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(systemData.getAppCode()))) != null) {
            appName = thirdSsoInfo.getAppName();
            appCode = thirdSsoInfo.getAppCode();
            appId = thirdSsoInfo.getAppId();
            systemType = "mt";
            appToken = thirdSsoInfo.getAppToken();
            systemData.setProtocolType(thirdSsoInfo.getProtocolType());
            callBackUrl = thirdSsoInfo.getCallBackUrl();
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemData.getDataType()) && null != (preinstalledApplication = (PreinstalledApplication)(preinstalledApplicationMap = (preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user = AppAuthContextHolder.getContext().getAuthoredUser())).stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a))).get(Long.parseLong(systemData.getAppCode())))) {
            appName = preinstalledApplication.getApplicationName();
            appCode = preinstalledApplication.getApplicationCode();
            PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(preinstalledApplication.getId(), "", "");
            appId = applicationInstance.getAppId();
            systemType = this.getPreSystem(preinstalledApplication);
            appToken = preinstalledApplication.getAppToken();
            systemData.setProtocolType(preinstalledApplication.getProtocolType());
            com.alibaba.fastjson.JSONObject jsonObject = Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)preinstalledApplication.getApplicationConfig())).orElse(new com.alibaba.fastjson.JSONObject());
            callBackUrl = String.format("http://www.%s.com", jsonObject.getString("applicationCode"));
            if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalledApplication.getApplicationCode())) {
                isNeedSsoUrl = 1;
                isFixedRefresh = 1;
                JSONObject instanceObject = applicationInstance.getApplicationExtConfig();
                callBackUrl = instanceObject.getString("callBackUrl");
                appId = instanceObject.getString("appId");
            }
        }
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            appName = athenaInfoMap.get(systemData.getAppCode());
            appCode = systemData.getAppCode();
        }
        systemData.setAppId(appId);
        if (type.booleanValue()) {
            systemData.setAppCode(appCode);
            systemData.setSystemType(systemType);
            systemData.setAppToken(appToken);
            systemData.setCallBackUrl(callBackUrl);
            systemData.setIsNeedSsoUrl(isNeedSsoUrl);
            systemData.setIsFixedRefresh(isFixedRefresh);
        }
        systemData.setAppName(appName);
        return appName;
    }

    public String getPreSystem(PreinstalledApplication preinstalledApplication) {
        String systemType = "";
        if (null == preinstalledApplication.getSystemType()) {
            return systemType;
        }
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue()))) {
            systemType = "mt";
        }
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue()))) {
            systemType = "wt";
        }
        return systemType;
    }

    public List<UserSystemLabelVo> queryUserLayout() {
        List<Object> userSystemLabelVoList = new ArrayList<UserSystemLabelVo>();
        QueryWrapper cond = new QueryWrapper();
        List bizObjAuthRelList = this.labelSystemAuthMapper.selectList((Wrapper)this.getUserAuthCon(cond));
        List portalLayoutCustomList = this.portalLayoutCustomService.initPortalLayout();
        if (CollectionUtils.isEmpty((Collection)portalLayoutCustomList)) {
            return userSystemLabelVoList;
        }
        Map<String, LabelSystemAuth> labelSystemAuthMap = bizObjAuthRelList.stream().collect(Collectors.toMap(value -> value.getLabelId() + "-" + value.getLabelType(), value -> value, (key1, key2) -> key1));
        userSystemLabelVoList = this.getUserSystemLabel(labelSystemAuthMap, portalLayoutCustomList);
        return userSystemLabelVoList;
    }

    public List<Long> getSystemCustom() {
        QueryWrapper cond = new QueryWrapper();
        List bizObjAuthRelList = this.labelSystemAuthMapper.selectList((Wrapper)this.getUserAuthCon(cond));
        List<Long> customIdList = bizObjAuthRelList.stream().filter(x -> Objects.equals(0, x.getLabelType())).map(LabelSystemAuth::getLabelId).collect(Collectors.toList());
        return customIdList;
    }

    public QueryWrapper getUserAuthCon(QueryWrapper cond) {
        Long userSid;
        String userId = Utils.getUserId();
        String tenantId = Utils.getTenantId();
        String userToken = Utils.getUserToken();
        IamUserAuthInfo iamUserAuthInfo = this.iamUserService.getUserAuthSids(userId, tenantId, userToken);
        StringBuilder authCond = new StringBuilder();
        if (ObjectUtils.isNotEmpty((Object)iamUserAuthInfo) && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getOrgSids())) {
            List orgSidList = iamUserAuthInfo.getOrgSids();
            authCond.append("(auth_type = 1 and auth_id in(" + Joiner.on((String)",").join((Iterable)orgSidList) + "))");
        }
        if (ObjectUtils.isNotEmpty((Object)iamUserAuthInfo) && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getRoleSids())) {
            List roleSidList = iamUserAuthInfo.getRoleSids();
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 2 and auth_id in(" + Joiner.on((String)",").join((Iterable)roleSidList) + "))");
            } else {
                authCond.append("(auth_type = 2 and auth_id in(" + Joiner.on((String)",").join((Iterable)roleSidList) + "))");
            }
        }
        if (ObjectUtils.isNotEmpty((Object)iamUserAuthInfo) && CollectionUtils.isNotEmpty((Collection)iamUserAuthInfo.getDeptSids())) {
            List deptSidList = iamUserAuthInfo.getDeptSids();
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 5 and auth_id in(" + Joiner.on((String)",").join((Iterable)deptSidList) + "))");
            } else {
                authCond.append("(auth_type = 5 and auth_id in (" + Joiner.on((String)",").join((Iterable)deptSidList) + "))");
            }
        }
        if (Objects.nonNull(userSid = Utils.getUserSid())) {
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 3 and auth_id = " + userSid + ")");
            } else {
                authCond.append("(auth_type = 3 and auth_id = " + userSid + ")");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
            cond.apply("(" + authCond + ")", new Object[0]);
        }
        return cond;
    }

    public QueryWrapper getUserAuthSidCon(QueryWrapper cond) {
        String userId = Utils.getUserId();
        String userToken = Utils.getUserToken();
        Long userSid = AppAuthContextHolder.getContext().getAuthoredUser().getSid();
        UserOrgInfoDTO userOrgInfoDTO = this.iamService.qryUserOrgInfo(userId, userToken);
        List roleDTOList = this.iamService.queryUserRoles(userId, userToken);
        UserInfoDetailDTO userInfoDetailDTO = this.eocService.queryUserInfoDetail(userId);
        StringBuilder authCond = new StringBuilder();
        if (Objects.nonNull(userOrgInfoDTO) && CollectionUtils.isNotEmpty((Collection)userOrgInfoDTO.getUserInOrgs())) {
            List orgSidList = userOrgInfoDTO.getUserInOrgs().stream().map(UserOrgDTO::getOrgSid).collect(Collectors.toList());
            authCond.append("(auth_type = 1 and auth_sid in(" + Joiner.on((String)",").join(orgSidList) + "))");
        }
        if (CollectionUtils.isNotEmpty((Collection)roleDTOList)) {
            List roleSidList = roleDTOList.stream().map(RoleDTO::getSid).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 2 and auth_sid in(" + Joiner.on((String)",").join(roleSidList) + "))");
            } else {
                authCond.append("(auth_type = 2 and auth_sid in(" + Joiner.on((String)",").join(roleSidList) + "))");
            }
        }
        if (ObjectUtils.isNotEmpty((Object)userInfoDetailDTO) && CollectionUtils.isNotEmpty((Collection)userInfoDetailDTO.getDepts())) {
            List deptSidList = userInfoDetailDTO.getDepts().stream().map(UserDeptDTO::getSid).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 5 and auth_sid in(" + Joiner.on((String)",").join(deptSidList) + "))");
            } else {
                authCond.append("(auth_type = 5 and auth_sid in (" + Joiner.on((String)",").join(deptSidList) + "))");
            }
        }
        if (Objects.nonNull(userSid)) {
            if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
                authCond.append("or (auth_type = 3 and auth_sid = " + userSid + ")");
            } else {
                authCond.append("(auth_type = 3 and auth_sid = " + userSid + ")");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)authCond.toString())) {
            cond.apply("(" + authCond + ")", new Object[0]);
        }
        return cond;
    }

    public List<UserSystemLabelVo> getUserSystemLabel(Map<String, LabelSystemAuth> labelSystemAuthMap, List<PortalLayoutCustom> portalLayoutCustomList) {
        ArrayList<UserSystemLabelVo> userSystemLabelVoList = new ArrayList<UserSystemLabelVo>();
        Map<Object, Object> systemCustomMap = new HashMap();
        List sysetemCustomIdList = portalLayoutCustomList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(x.getLabelType())).map(PortalLayoutCustom::getLabelId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sysetemCustomIdList)) {
            List systemCustomList = this.labelSystemCustomMapper.selectBatchIds(sysetemCustomIdList);
            systemCustomMap = systemCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        List systemDataList = new ArrayList();
        if (MapUtils.isNotEmpty(systemCustomMap)) {
            Set systemIdList = systemCustomMap.keySet();
            systemDataList = this.labelSystemDataMapper.queryBySystemIdList(systemIdList);
        }
        List effectSystemIdList = this.buildEffectSystemId(systemDataList);
        UserAuthSystemLabelVo authSystemLabelVo = this.mobileUserAuthService.buildSystemIdApp(systemDataList);
        this.addAuthLabelMap(labelSystemAuthMap, authSystemLabelVo);
        Map<Object, Object> systemPreMap = new HashMap();
        List sysetemPreIdList = portalLayoutCustomList.stream().filter(x -> Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(x.getLabelType())).map(PortalLayoutCustom::getLabelId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sysetemPreIdList)) {
            List labelSystemPreList = this.labelSystemPreMapper.selectBatchIds(sysetemPreIdList);
            systemPreMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));
        }
        for (PortalLayoutCustom portalLayoutCustom : portalLayoutCustomList) {
            LabelSystemPre labelSystemPre;
            String labelName;
            String key = portalLayoutCustom.getLabelId() + "-" + portalLayoutCustom.getLabelType();
            LabelSystemAuth systemAuth = labelSystemAuthMap.get(key);
            if (null == systemAuth && portalLayoutCustom.getDefaultFlag().equals(0) && Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(portalLayoutCustom.getLabelType())) continue;
            UserSystemLabelVo userSystemLabelVo = new UserSystemLabelVo();
            userSystemLabelVo.setLabelId(portalLayoutCustom.getLabelId());
            userSystemLabelVo.setLabelType(portalLayoutCustom.getLabelType());
            userSystemLabelVo.setLabelIndex(portalLayoutCustom.getLabelIndex());
            if (portalLayoutCustom.getLabelType().equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
                LabelSystemCustom labelSystemCustom = (LabelSystemCustom)systemCustomMap.get(portalLayoutCustom.getLabelId());
                if (null == labelSystemCustom || Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(labelSystemCustom.getDataCategory()) && !effectSystemIdList.contains(labelSystemCustom.getId()) || null == systemAuth && !Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(labelSystemCustom.getDataCategory())) continue;
                userSystemLabelVo.setDataCategory(labelSystemCustom.getDataCategory());
                userSystemLabelVo.setIcon(labelSystemCustom.getIcon());
                userSystemLabelVo.setShowType(labelSystemCustom.getShowType());
                labelName = this.translateService.translateTextCache(labelSystemCustom.getNameZh(), "");
                userSystemLabelVo.setLabelName(labelName);
                userSystemLabelVo.setValidStatus(labelSystemCustom.getValidStatus());
            }
            if (portalLayoutCustom.getLabelType().equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal()) && null != (labelSystemPre = (LabelSystemPre)systemPreMap.get(portalLayoutCustom.getLabelId()))) {
                userSystemLabelVo.setDataType(labelSystemPre.getDataType());
                userSystemLabelVo.setDataCategory(labelSystemPre.getDataCategory());
                labelName = this.translateService.translateTextCache(labelSystemPre.getName(), "");
                userSystemLabelVo.setLabelName(labelName);
                userSystemLabelVo.setValidStatus(labelSystemPre.getValidStatus());
            }
            if (null != userSystemLabelVo.getDataType() && userSystemLabelVo.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())) {
                userSystemLabelVoList.add(userSystemLabelVo);
                continue;
            }
            if (!Constants.VALID_STATUS_ENABLE.equals(userSystemLabelVo.getValidStatus())) continue;
            userSystemLabelVoList.add(userSystemLabelVo);
        }
        return userSystemLabelVoList;
    }

    public void addAuthLabelMap(Map<String, LabelSystemAuth> labelSystemAuthMap, UserAuthSystemLabelVo authSystemLabelVo) {
        if (CollectionUtils.isEmpty((Collection)authSystemLabelVo.getPermSystemIdList())) {
            return;
        }
        for (Long sysTemId : authSystemLabelVo.getPermSystemIdList()) {
            String key = sysTemId + "-" + Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal();
            LabelSystemAuth systemAuth = labelSystemAuthMap.get(key);
            if (null != systemAuth) continue;
            systemAuth = new LabelSystemAuth();
            systemAuth.setLabelId(sysTemId);
            systemAuth.setLabelType(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
            labelSystemAuthMap.put(key, systemAuth);
        }
    }

    private List<Long> buildEffectSystemId(List<LabelSystemData> systemDataList) {
        ArrayList effectSystemIdList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(systemDataList)) {
            return effectSystemIdList;
        }
        Map systemDataMap = systemDataList.stream().filter(x -> Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(x.getDataCategory()) && ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(x.getDataType())).collect(Collectors.toMap(LabelSystemData::getSystemId, Function.identity(), (a, b) -> a));
        if (MapUtils.isNotEmpty(systemDataMap)) {
            List groupRuleList = this.atmcService.queryGroupRule();
            List groupCodeList = groupRuleList.stream().map(GroupRuleDTO::getCode).collect(Collectors.toList());
            systemDataMap.forEach((k, v) -> {
                if (groupCodeList.contains(v.getCountCode())) {
                    effectSystemIdList.add(k);
                }
            });
        }
        List thirdSystemIdList = systemDataList.stream().filter(x -> Constants.DataCategoryEnum.BUSINESS_TODO.getVal().equals(x.getDataCategory()) && !ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(x.getDataType())).map(LabelSystemData::getSystemId).collect(Collectors.toList());
        effectSystemIdList.addAll(thirdSystemIdList);
        return effectSystemIdList;
    }

    public List<LabelSystemAuth> queryAuthListByCondition(List<Integer> authTypeList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"auth_type", authTypeList);
        return this.labelSystemAuthMapper.selectList((Wrapper)wrapper);
    }
}

