/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import cn.hutool.core.util.ObjUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.portal.QueryGroupReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.athena.service.atmc.AtmcService;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupNameLangDTO;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.portal.LabelSystemBusinessTodoService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.GroupRuleResp;
import com.digiwin.athena.semc.vo.portal.GroupRuleValueResp;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class LabelSystemBusinessTodoServiceImpl
implements LabelSystemBusinessTodoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemBusinessTodoServiceImpl.class);
    @Resource
    private AtmcService atmcService;
    @Resource
    private ESPService espService;
    @Resource
    private TripartiteService tripartiteService;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private EnvProperties envProperties;

    public List<GroupRuleResp> queryAgileGroupList(QueryGroupReq queryGroupReq) {
        List<Object> groupRuleRespList = Lists.newArrayList();
        List groupRuleList = StringUtils.isBlank((CharSequence)queryGroupReq.getGroupCode()) ? this.atmcService.queryGroupRule() : this.atmcService.queryGroupConditionRule(queryGroupReq.getGroupCode());
        if (CollectionUtils.isEmpty((Collection)groupRuleList)) {
            return groupRuleRespList;
        }
        String lang = LocaleContextHolder.getLocale().toString();
        groupRuleRespList = groupRuleList.stream().map(x -> {
            GroupRuleResp groupRuleResp = new GroupRuleResp();
            groupRuleResp.setName(x.getName());
            groupRuleResp.setCode(x.getCode());
            if ("zh_CN".equals(lang)) {
                return groupRuleResp;
            }
            if (ObjUtil.isNotNull((Object)x.getLang()) && ObjUtil.isNotNull((Object)x.getLang().getName())) {
                GroupNameLangDTO.LangDTO langDTO = x.getLang().getName();
                switch (lang) {
                    case "zh_TW": {
                        groupRuleResp.setName(langDTO.getZh_TW());
                        break;
                    }
                    case "en_US": {
                        groupRuleResp.setName(langDTO.getEn_US());
                        break;
                    }
                    default: {
                        groupRuleResp.setName(langDTO.getZh_CN());
                    }
                }
            }
            return groupRuleResp;
        }).collect(Collectors.toList());
        return groupRuleRespList;
    }

    public List<GroupRuleResp> queryThirdGroupList(QueryGroupReq queryGroupReq) {
        JSONArray jsonArray;
        ArrayList groupRuleRespList = Lists.newArrayList();
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(queryGroupReq.getDataModel())) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("locale", LocaleContextHolder.getLocale().toString());
            Map result = this.espService.queryByEsp(queryGroupReq.getMiddleSystemName(), queryGroupReq.getMiddleSystemUid(), EAIServiceNameEnum.BUSINESS_TODO_GROUP.getServiceName(), null, param, "", null);
            log.info("query third group list for data model 0. param:{}, result:{}", param, (Object)result);
            if (ObjUtil.isNull((Object)result) || Objects.isNull(result.get("group_list"))) {
                return groupRuleRespList;
            }
            jsonArray = JSONArray.fromObject(result.get("group_list"));
        } else {
            Map result = this.tripartiteService.queryThirdBusinessTodoGroupList(queryGroupReq.getRestUrl());
            if (ObjUtil.isNull((Object)result) || Objects.isNull(result.get("groupList"))) {
                return groupRuleRespList;
            }
            jsonArray = JSONArray.fromObject(result.get("groupList"));
        }
        for (Object item : jsonArray) {
            GroupRuleResp groupRuleResp = new GroupRuleResp();
            JSONObject jsonObject = (JSONObject)item;
            groupRuleResp.setCode(jsonObject.containsKey((Object)"code") ? jsonObject.getString("code") : "");
            groupRuleResp.setName(jsonObject.containsKey((Object)"name") ? jsonObject.getString("name") : "");
            if (jsonObject.containsKey((Object)"group_condition_list")) {
                JSONArray conditionList = jsonObject.getJSONArray("group_condition_list");
                ArrayList groupConditionList = Lists.newArrayList();
                for (Object o : conditionList) {
                    JSONObject jsonObjectItem = (JSONObject)o;
                    GroupRuleResp groupRuleCondition = new GroupRuleResp();
                    groupRuleCondition.setCode(jsonObjectItem.containsKey((Object)"code") ? jsonObjectItem.getString("code") : "");
                    groupRuleCondition.setName(jsonObjectItem.containsKey((Object)"name") ? jsonObjectItem.getString("name") : "");
                    groupConditionList.add(groupRuleCondition);
                }
                groupRuleResp.setGroupConditionList((List)groupConditionList);
            }
            groupRuleRespList.add(groupRuleResp);
        }
        return groupRuleRespList;
    }

    public List<GroupRuleValueResp> queryAgileGroupValueList(String clientId, LabelSystemData labelSystemData) {
        List<Object> valueRespList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)labelSystemData.getCountCode()) || StringUtils.isBlank((CharSequence)labelSystemData.getCountContentCode())) {
            return valueRespList;
        }
        ArrayList groupList = Lists.newArrayList();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"groupCode", (Object)labelSystemData.getCountCode());
        jsonObject.put((Object)"groupValue", (Object)labelSystemData.getCountContentCode());
        groupList.add(jsonObject);
        List groupValueList = this.atmcService.queryGroupTodoValue(clientId, (List)groupList);
        if (CollectionUtils.isEmpty((Collection)groupValueList)) {
            return valueRespList;
        }
        valueRespList = groupValueList.stream().filter(x -> labelSystemData.getCountCode().equals(x.getGroupCode()) && labelSystemData.getCountContentCode().equals(x.getGroupValue())).map(x -> {
            GroupRuleValueResp groupRuleResp = new GroupRuleValueResp();
            groupRuleResp.setGroupCode(x.getGroupCode());
            groupRuleResp.setGroupConditionCode(x.getGroupValue());
            groupRuleResp.setValue(x.getValue());
            groupRuleResp.setDataType(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType());
            return groupRuleResp;
        }).collect(Collectors.toList());
        return valueRespList;
    }

    public GroupRuleValueResp queryThirdGroupValueList(LabelSystemData labelSystemData) {
        JSONObject jsonObject;
        GroupRuleValueResp groupRuleValueResp = new GroupRuleValueResp();
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            HashMap<String, String> extHeader = new HashMap<String, String>();
            extHeader.put("digi-userToken", Utils.getUserToken());
            extHeader.put("digi-appToken", this.envProperties.getAppToken());
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("locale", LocaleContextHolder.getLocale().toString());
            if (StringUtils.isBlank((CharSequence)labelSystemData.getCountContentCode())) {
                param.put("group_condition_code", labelSystemData.getCountCode());
            } else {
                param.put("group_code", labelSystemData.getCountCode());
                param.put("group_condition_code", labelSystemData.getCountContentCode());
            }
            Map result = this.espService.queryByEsp(labelSystemData.getMiddleSystemName(), labelSystemData.getMiddleSystemUid(), EAIServiceNameEnum.BUSINESS_TODO_VALUE.getServiceName(), extHeader, param, "", null);
            log.info("query third group value list of data model 0 result. param:{}, result:{}", param, (Object)result);
            if (ObjUtil.isNull((Object)result) || Objects.isNull(result.get("group_value"))) {
                return groupRuleValueResp;
            }
            jsonObject = JSONObject.fromObject(result.get("group_value"));
        } else {
            Map result = this.tripartiteService.queryThirdBusinessTodoValueList(labelSystemData, this.envProperties.getAppToken());
            if (ObjUtil.isNull((Object)result) || Objects.isNull(result.get("groupValue"))) {
                return groupRuleValueResp;
            }
            jsonObject = JSONObject.fromObject(result.get("groupValue"));
        }
        groupRuleValueResp.setGroupCode(jsonObject.containsKey((Object)"group_code") ? jsonObject.getString("group_code") : "");
        groupRuleValueResp.setGroupName(jsonObject.containsKey((Object)"group_name") ? jsonObject.getString("group_name") : "");
        groupRuleValueResp.setGroupConditionCode(jsonObject.containsKey((Object)"group_condition_code") ? jsonObject.getString("group_condition_code") : "");
        groupRuleValueResp.setGroupConditionName(jsonObject.containsKey((Object)"group_condition_name") ? jsonObject.getString("group_condition_name") : "");
        groupRuleValueResp.setValue(jsonObject.containsKey((Object)"value") ? Integer.valueOf(jsonObject.getInt("value")) : null);
        groupRuleValueResp.setUrl(jsonObject.containsKey((Object)"url") ? jsonObject.getString("url") : null);
        List appLinkList = this.appLinkService.queryManageListSync(AppAuthContextHolder.getContext().getAuthoredUser());
        for (AppLinkDTO appLinkDTO : appLinkList) {
            if (!(labelSystemData.getDataType() + "-" + labelSystemData.getAppCode()).equals(appLinkDTO.getDataSource() + "-" + appLinkDTO.getPrimaryId())) continue;
            groupRuleValueResp.setAppName(appLinkDTO.getName());
            groupRuleValueResp.setAppToken(appLinkDTO.getAppToken());
            groupRuleValueResp.setCallBackUrl(appLinkDTO.getCallBackUrl());
            groupRuleValueResp.setApplicationAppId(appLinkDTO.getApplicationAppId());
            groupRuleValueResp.setProtocolType(appLinkDTO.getProtocolType());
            groupRuleValueResp.setSystemType(appLinkDTO.getSystemType());
            groupRuleValueResp.setDataType(labelSystemData.getDataType());
            String url = this.appLinkService.parseJumpUrl(jsonObject.containsKey((Object)"url") ? jsonObject.getString("url") : "", appLinkDTO);
            groupRuleValueResp.setUrl(url);
            break;
        }
        return groupRuleValueResp;
    }
}

