/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.erpsso.ErpSsoSpecialDTO;
import com.digiwin.athena.semc.dto.erpsso.ThirdSsoInfoDto;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.dto.fineReport.QueryFineReportUrlReq;
import com.digiwin.athena.semc.dto.mobile.MobileSSOReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.fineReport.FineReportUserMapping;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportTreeVO;
import com.digiwin.athena.semc.proxy.fineReport.service.FineReportProxyService;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.fineReport.FineReportAuthService;
import com.digiwin.athena.semc.service.fineReport.FineReportManageService;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemClickService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemSourceService;
import com.digiwin.athena.semc.service.portal.TripartiteApplicationService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.RsaEncryptUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.mobile.FullBackResp;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelSystemClickServiceImpl
implements LabelSystemClickService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemClickServiceImpl.class);
    @Resource
    LabelSystemSourceService labelSystemSourceService;
    @Resource
    LabelSystemDataService labelSystemDataService;
    @Autowired
    IErpSsoInfoService erpSsoInfoService;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Autowired
    private KmService kmService;
    @Resource
    private EnvProperties envProperties;
    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;
    @Autowired
    MayCurService mayCurService;
    @Autowired
    EocService eocService;
    @Autowired
    private MobilePortalService mobilePortalService;
    @Resource
    LabelSystemCustomService labelSystemCustomService;
    @Resource
    private TripartiteApplicationService tripartiteApplicationService;
    @Resource
    private FineReportManageService fineReportManageService;
    @Resource
    private FineReportAuthService fineReportAuthService;
    @Resource
    private FineReportProxyService fineReportProxyService;

    public AppLinkDTO queryCustomJumpLink(Long systemId) {
        AppLinkDTO appLinkDTO = new AppLinkDTO();
        LabelSystemCustom labelSystemCustom = (LabelSystemCustom)this.labelSystemCustomService.getById((Serializable)systemId);
        if (ObjectUtils.isEmpty((Object)labelSystemCustom)) {
            return appLinkDTO;
        }
        if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(labelSystemCustom.getDataCategory())) {
            if (StringUtils.isNotBlank((CharSequence)labelSystemCustom.getLinkParam())) {
                StringBuilder stringBuilder = Utils.buildWebLinkUrl((String)labelSystemCustom.getLinkParam());
                String linkUrl = labelSystemCustom.getLinkUrl() + "?" + stringBuilder;
                appLinkDTO.setCloudwebsite(linkUrl);
            } else {
                appLinkDTO.setCloudwebsite(labelSystemCustom.getLinkUrl());
            }
            return appLinkDTO;
        }
        if (Objects.equals(11, labelSystemCustom.getDataCategory())) {
            if (StringUtils.isNotBlank((CharSequence)labelSystemCustom.getLinkParam())) {
                StringBuilder stringBuilder = Utils.buildWebLinkUrl((String)labelSystemCustom.getLinkParam());
                String linkUrl = labelSystemCustom.getLinkUrl() + "?" + stringBuilder;
                appLinkDTO.setCloudwebsite(linkUrl);
            } else {
                appLinkDTO.setCloudwebsite(labelSystemCustom.getLinkUrl());
            }
            return appLinkDTO;
        }
        List dataIdList = this.labelSystemSourceService.selectBySystem(systemId, Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty((Collection)dataIdList)) {
            return appLinkDTO;
        }
        List systemDataList = this.labelSystemDataService.queryByIds(dataIdList);
        if (CollectionUtils.isEmpty((Collection)systemDataList)) {
            return appLinkDTO;
        }
        return this.buildCustomApp((LabelSystemData)systemDataList.get(0));
    }

    public AppLinkDTO buildCustomApp(LabelSystemData systemData) {
        AppLinkDTO appLinkDTO = new AppLinkDTO();
        Integer dataType = systemData.getDataType();
        String appCode = systemData.getAppCode();
        Integer dataCategory = systemData.getDataCategory();
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(dataType)) {
            List thirdSsoInfoList = this.thirdSsoInfoService.erpSsoInfoWithParams();
            if (CollectionUtils.isEmpty((Collection)thirdSsoInfoList)) {
                return appLinkDTO;
            }
            Map idMap = thirdSsoInfoList.stream().collect(Collectors.toMap(ThirdSsoInfoDto::getId, Function.identity()));
            ThirdSsoInfoDto thirdSsoInfoDto = (ThirdSsoInfoDto)idMap.get(Long.parseLong(appCode));
            if (thirdSsoInfoDto == null) {
                return appLinkDTO;
            }
            AppLinkDTO appLink = this.buildBSAppLinkDTO(thirdSsoInfoDto);
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                String cloudwebsite = "";
                if (thirdSsoInfoDto.getProtocolType().equals(3) || thirdSsoInfoDto.getProtocolType().equals(2)) {
                    cloudwebsite = appLink.getCloudwebsite() + systemData.getCallBackUrl();
                } else {
                    cloudwebsite = appLink.getCloudwebsite();
                    String[] linkParamArray = cloudwebsite.split("\\?");
                    systemData.setAppId(thirdSsoInfoDto.getAppId());
                    String jobUrl = this.getSsoJobUrl(systemData);
                    cloudwebsite = linkParamArray[0] + this.packageJobUrl(jobUrl) + "&" + linkParamArray[1];
                }
                appLink.setCloudwebsite(cloudwebsite);
                this.appendAccountSet(appLink, systemData);
            }
            return appLink;
        }
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(dataType)) {
            List erpSsoInfoList = this.erpSsoInfoService.erpSsoInfoWithParams();
            if (CollectionUtils.isEmpty((Collection)erpSsoInfoList)) {
                return appLinkDTO;
            }
            Map idMap = erpSsoInfoList.stream().collect(Collectors.toMap(ErpSsoInfo::getId, Function.identity()));
            ErpSsoInfo erpSsoInfo = (ErpSsoInfo)idMap.get(Long.parseLong(appCode));
            if (erpSsoInfo == null) {
                return appLinkDTO;
            }
            AppLinkDTO appLink = this.buildCSAppLinkDTO(erpSsoInfo);
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                StringBuilder cloudwebsite = new StringBuilder(appLink.getCloudwebsite());
                systemData.setAppId(erpSsoInfo.getAppId());
                JSONObject jsonObject = JSONObject.parseObject((String)this.getSsoJobUrl(systemData));
                if (null != jsonObject) {
                    for (String key : jsonObject.keySet()) {
                        Object value = jsonObject.get((Object)key);
                        cloudwebsite.append("&").append(key).append("=").append(value);
                    }
                }
                appLink.setCloudwebsite(cloudwebsite.toString());
                this.appendAccountSet(appLink, systemData);
            }
            return appLink;
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(dataType)) {
            List preApplicationList = this.appLinkService.queryPerInstallAppGroup(AppAuthContextHolder.getContext().getAuthoredUser());
            if (CollectionUtils.isEmpty((Collection)preApplicationList)) {
                return appLinkDTO;
            }
            Map idMap = preApplicationList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity()));
            AppLinkDTO preAppLink = (AppLinkDTO)idMap.get(appCode);
            if (preAppLink == null) {
                return appLinkDTO;
            }
            systemData.setAppId(preAppLink.getAppId());
            if (MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(preAppLink.getCode()) || MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preAppLink.getCode())) {
                preAppLink.setIsNeedSsoUrl(Integer.valueOf(0));
                this.getMaycurSsoUrl(preAppLink, dataCategory, systemData);
                return preAppLink;
            }
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                if (PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue().equals(preAppLink.getType())) {
                    String cloudwebsite = preAppLink.getCloudwebsite();
                    String[] linkParamArray = cloudwebsite.split("\\?");
                    cloudwebsite = linkParamArray[0] + "?" + this.getSsoJobUrl(systemData) + "&" + linkParamArray[1];
                    preAppLink.setCloudwebsite(cloudwebsite);
                } else if (PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue().equals(preAppLink.getType())) {
                    StringBuilder cloudwebsite = new StringBuilder(preAppLink.getCloudwebsite());
                    JSONObject jsonObject = JSONObject.parseObject((String)this.getSsoJobUrl(systemData));
                    if (null != jsonObject) {
                        for (String key : jsonObject.keySet()) {
                            Object value = jsonObject.get((Object)key);
                            cloudwebsite.append("&").append(key).append("=").append(value);
                        }
                    }
                    preAppLink.setCloudwebsite(cloudwebsite.toString());
                } else if (PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getValue().equals(preAppLink.getType())) {
                    if ("06".equals(preAppLink.getProductCode())) {
                        String cloudwebsite = preAppLink.getCloudwebsite();
                        JSONObject jsonObject = JSONObject.parseObject((String)this.getSsoJobUrl(systemData));
                        if (ObjectUtils.isNotEmpty((Object)jsonObject)) {
                            List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(AppAuthContextHolder.getContext().getAuthoredUser());
                            List TTAppList = preInstalledAppList.stream().filter(x -> "06".equals(x.getProductCode())).collect(Collectors.toList());
                            StringBuilder arg = new StringBuilder();
                            for (String key : jsonObject.keySet()) {
                                Object value = jsonObject.get((Object)key);
                                arg.append("&").append(key).append("=").append(value);
                            }
                            for (PreinstalledApplication x2 : TTAppList) {
                                if (!preAppLink.getPrimaryId().equals(String.valueOf(x2.getId()))) continue;
                                ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(JSONObject.parseObject((String)x2.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
                                cloudwebsite = cloudwebsite.replaceAll("&Arg=" + erpSsoSpecialDTO.getJobCode(), arg.toString());
                            }
                        }
                        preAppLink.setCloudwebsite(cloudwebsite);
                    } else if ("100".equals(preAppLink.getProductCode())) {
                        String cloudwebsite = preAppLink.getCloudwebsite();
                        JSONObject jsonObject = JSONObject.parseObject((String)this.getSsoJobUrl(systemData));
                        if (ObjectUtils.isNotEmpty((Object)jsonObject) && jsonObject.containsKey((Object)"Arg")) {
                            String value = jsonObject.getString("Arg");
                            cloudwebsite = cloudwebsite.replaceAll("azzi000", value);
                        }
                        preAppLink.setCloudwebsite(cloudwebsite);
                    } else {
                        StringBuilder cloudwebsite = new StringBuilder(preAppLink.getCloudwebsite());
                        JSONObject jsonObject = JSONObject.parseObject((String)this.getSsoJobUrl(systemData));
                        if (ObjectUtils.isNotEmpty((Object)jsonObject)) {
                            for (String key : jsonObject.keySet()) {
                                Object value = jsonObject.get((Object)key);
                                cloudwebsite.append("&").append(key).append("=").append(value);
                            }
                        }
                        preAppLink.setCloudwebsite(cloudwebsite.toString());
                    }
                } else if (PreinstalledApplicationTypeEnum.IAM_APPLICATION.getValue().equals(preAppLink.getType())) {
                    String cloudwebsite = this.appendJobField(preAppLink, systemData);
                    preAppLink.setCloudwebsite(cloudwebsite);
                }
                this.appendAccountSet(preAppLink, systemData);
            }
            return preAppLink;
        }
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(dataType)) {
            List athenaAppList = this.appLinkService.queryDefaultGroup(AppAuthContextHolder.getContext().getAuthoredUser());
            if (CollectionUtils.isEmpty((Collection)athenaAppList)) {
                return appLinkDTO;
            }
            Map idMap = athenaAppList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity()));
            AppLinkDTO athenaAppLink = (AppLinkDTO)idMap.get(appCode);
            if (athenaAppLink == null) {
                return appLinkDTO;
            }
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
                String cloudwebsite = this.appendJobField(athenaAppLink, systemData);
                athenaAppLink.setCloudwebsite(cloudwebsite);
            }
            return athenaAppLink;
        }
        if (dataType.equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && appCode.equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId())) {
            appLinkDTO.setShowType(1);
            if (null != systemData.getIsJob() && systemData.getIsJob() == 1) {
                appLinkDTO.setNeedAuthCodeFlag(Integer.valueOf(0));
                appLinkDTO.setIsHavePerm(Boolean.TRUE);
                appLinkDTO.setCloudwebsite(systemData.getCallBackUrl());
                return appLinkDTO;
            }
            MobileSSOReq mobileSSOReq = new MobileSSOReq();
            appLinkDTO.setIsHavePerm(Boolean.FALSE);
            if (StringUtils.isEmpty((CharSequence)systemData.getWorkCode())) {
                return appLinkDTO;
            }
            mobileSSOReq.setCustomApplicationId(systemData.getWorkCode());
            FullBackResp fullCallBackUrl = this.mobilePortalService.getFullCallBackUrl(mobileSSOReq);
            if (null == fullCallBackUrl) {
                return appLinkDTO;
            }
            if (!fullCallBackUrl.getIsHavePerm().booleanValue()) {
                return appLinkDTO;
            }
            appLinkDTO.setCloudwebsite(fullCallBackUrl.getMobileCloudWebsite());
            appLinkDTO.setIsHavePerm(fullCallBackUrl.getIsHavePerm());
            appLinkDTO.setNeedAuthCodeFlag(Integer.valueOf(fullCallBackUrl.getIsNeedCode() != false ? 1 : 0));
        } else if (dataType.equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && appCode.equals(VirtualApplicationEnum.FINE_REPORT_APP.getPrimaryId())) {
            appLinkDTO.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_NO);
            FineReportConfigDTO fineReportConfigDTO = this.tripartiteApplicationService.queryFineReportConfig();
            if (ObjectUtils.isEmpty((Object)fineReportConfigDTO) || StringUtils.isBlank((CharSequence)fineReportConfigDTO.getPublicKey())) {
                return appLinkDTO;
            }
            FineReportUserMapping fineReportUserMapping = this.fineReportManageService.queryCurrentUserMapping();
            if (ObjectUtils.isEmpty((Object)fineReportUserMapping)) {
                return appLinkDTO;
            }
            FineReportTreeVO fineReportTreeVO = (FineReportTreeVO)JSON.parseObject((String)systemData.getFineReportParam(), FineReportTreeVO.class);
            if (ObjectUtils.isEmpty((Object)fineReportTreeVO)) {
                return appLinkDTO;
            }
            String fineReportUrl = this.buildFineReportUrl(fineReportConfigDTO, fineReportUserMapping.getFrUserId(), fineReportTreeVO.getPath(), null);
            appLinkDTO.setCloudwebsite(fineReportUrl);
        }
        return appLinkDTO;
    }

    private String buildFineReportUrl(FineReportConfigDTO fineReportConfigDTO, String frUserId, String path, Integer deviceType) {
        String encodeToken;
        String plainText = frUserId;
        if (ObjectUtils.isNotEmpty((Object)fineReportConfigDTO.getTokenTimeoutFlag()) && Boolean.TRUE.equals(fineReportConfigDTO.getTokenTimeoutFlag())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("username", (Object)frUserId);
            jsonObject.put("issueTime", (Object)System.currentTimeMillis());
            plainText = JSON.toJSONString((Object)jsonObject);
        }
        String publicKey = fineReportConfigDTO.getPublicKey();
        String encryptToken = RsaEncryptUtil.encrypt((String)plainText, (String)publicKey);
        try {
            encodeToken = URLEncoder.encode(encryptToken, "UTF-8");
        }
        catch (Exception e) {
            log.error("URLEncoder.encode(encryptToken) occur error.encryptToken:{}", (Object)encryptToken, (Object)e);
            throw new RuntimeException(e);
        }
        String fineReportUrl = path.endsWith(".cpt") ? this.envProperties.getFineReportUrl() + "/webroot/decision/view/report?viewlet=" + path : (path.endsWith(".frm") ? this.envProperties.getFineReportUrl() + "/webroot/decision/view/form?viewlet=" + path : this.envProperties.getFineReportUrl() + "/webroot/decision/view/duchamp?viewlet=" + path);
        fineReportUrl = ObjectUtils.isNotEmpty((Object)deviceType) && Constants.MOBILE_FINE_REPORT.equals(deviceType) ? fineReportUrl + "&op=h5&ssoToken=" + encodeToken : fineReportUrl + "&ssoToken=" + encodeToken;
        return fineReportUrl;
    }

    public String getMaycurSsoUrl(AppLinkDTO appLinkDTO, Integer dataCategory, LabelSystemData systemData) {
        String ssoUrl = "";
        String userId = this.eocService.getEmpJobNum();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return "";
        }
        PreinstalledApplicationInstance preinstalledIns = this.preinstalledApplicationService.getPreINstance(Long.valueOf(Long.parseLong(appLinkDTO.getPrimaryId())), "", "");
        if (null == preinstalledIns || null == preinstalledIns.getApplicationExtConfig()) {
            return "";
        }
        String callBackUrl = preinstalledIns.getApplicationExtConfig().getString("callBackUrl");
        String appId = preinstalledIns.getApplicationExtConfig().getString("appId");
        String appSecret = preinstalledIns.getApplicationExtConfig().getString("appSecret");
        long timestamp = System.currentTimeMillis();
        String ssoToken = this.mayCurService.getSsoToken(userId, appSecret, timestamp);
        ssoUrl = this.mayCurService.getHomeSsoUrl(callBackUrl, appId, userId, ssoToken, timestamp);
        if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(dataCategory)) {
            String jobUrl = this.getSsoJobUrl(systemData);
            if (StringUtils.isNotEmpty((CharSequence)jobUrl) && MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(appLinkDTO.getCode())) {
                ssoUrl = this.mayCurService.getCloudSsoUrl(callBackUrl, appId, userId, ssoToken, jobUrl, timestamp);
            }
            if (StringUtils.isNotEmpty((CharSequence)jobUrl) && MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(appLinkDTO.getCode())) {
                ssoUrl = this.mayCurService.getJobSsoUrl(callBackUrl, appId, userId, ssoToken, jobUrl, timestamp);
            }
        }
        appLinkDTO.setCloudwebsite(ssoUrl);
        return ssoUrl;
    }

    public String packageJobUrl(String jobUrl) {
        if (StringUtils.isEmpty((CharSequence)jobUrl)) {
            return "";
        }
        if (jobUrl.contains("?")) {
            return jobUrl;
        }
        return "?" + jobUrl;
    }

    public String getSsoJobUrl(LabelSystemData systemData) {
        if (null != systemData.getIsJob() && systemData.getIsJob() == 1) {
            return systemData.getCallBackUrl();
        }
        List syncJobInfoList = this.syncJobInfoMapper.selectList((Wrapper)this.getJobCondition(systemData.getAppId(), systemData.getWorkCode()));
        if (CollectionUtils.isNotEmpty((Collection)syncJobInfoList)) {
            return ((SyncJobInfo)syncJobInfoList.get(0)).getJobUrl();
        }
        return "";
    }

    public QueryWrapper getJobCondition(String appId, String jobCode) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)jobCode)) {
            condition.eq((Object)"job_code", (Object)jobCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            condition.eq((Object)"app_id", (Object)appId);
        }
        return condition;
    }

    private String appendJobField(AppLinkDTO athenaAppLink, LabelSystemData systemData) {
        String jobType;
        String cloudwebsite = athenaAppLink.getCloudwebsite();
        List appJobDTOList = this.kmService.queryAppJobList();
        if (CollectionUtils.isEmpty((Collection)appJobDTOList)) {
            return cloudwebsite;
        }
        AppJobDTO appJobDTO = appJobDTOList.stream().filter(x -> athenaAppLink.getId().equals(x.getAppCode())).findFirst().orElse(null);
        if (appJobDTO == null) {
            return cloudwebsite;
        }
        AppJobDTO.Job job = appJobDTO.getData().stream().filter(x -> systemData.getWorkCode().equals(x.getCode())).findFirst().orElse(null);
        if (job == null) {
            return cloudwebsite;
        }
        cloudwebsite = cloudwebsite + "&code=" + job.getCode() + "&name=" + job.getName() + "&type=" + job.getType() + "&category=" + job.getCategory() + "&ifCustom=" + job.getIfCustom();
        if (StringUtils.isNotBlank((CharSequence)systemData.getJobLinkParam())) {
            StringBuilder stringBuilder = Utils.buildWebLinkUrl((String)systemData.getJobLinkParam());
            cloudwebsite = cloudwebsite + "&" + stringBuilder;
        }
        if (StringUtils.isNotEmpty((CharSequence)(jobType = this.getJobTypeMap(job.getType())))) {
            cloudwebsite = cloudwebsite.replace("sso-login", jobType);
        }
        return cloudwebsite;
    }

    public String getJobTypeMap(String type) {
        HashMap<String, String> jobTypeMap = new HashMap<String, String>();
        jobTypeMap.put("baseDataEntry".toLowerCase(), "base-data-entry");
        jobTypeMap.put("statement".toLowerCase(), "report");
        jobTypeMap.put("manualStartProject".toLowerCase(), "add-task");
        return (String)jobTypeMap.get(type.toLowerCase());
    }

    private AppLinkDTO buildBSAppLinkDTO(ThirdSsoInfoDto thirdSsoInfo) {
        AppLinkDTO appLink = new AppLinkDTO();
        appLink.setPrimaryId(String.valueOf(thirdSsoInfo.getId()));
        appLink.setId(thirdSsoInfo.getCode());
        appLink.setName(thirdSsoInfo.getName());
        appLink.setDesc(thirdSsoInfo.getAppDesc());
        appLink.setAppToken(thirdSsoInfo.getAppToken());
        appLink.setType(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue());
        appLink.setSystemType(ApplicationTypeEnum.BS_APPLICATION.getType());
        appLink.setDataSource(ApplicationTypeEnum.BS_APPLICATION.getType());
        appLink.setCloudwebsite(MapUtils.isNotEmpty((Map)thirdSsoInfo.getExt()) ? thirdSsoInfo.getExt().get("_fullpath").toString() : "");
        appLink.setApplicationAppId(thirdSsoInfo.getAppId());
        appLink.setCallBackUrl(thirdSsoInfo.getCallBackUrl());
        appLink.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
        if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(thirdSsoInfo.getUserBindFlag())) {
            appLink.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_YES);
        }
        return appLink;
    }

    private AppLinkDTO buildCSAppLinkDTO(ErpSsoInfo erpSsoInfo) {
        AppLinkDTO appLink = new AppLinkDTO();
        appLink.setPrimaryId(String.valueOf(erpSsoInfo.getId()));
        appLink.setId(erpSsoInfo.getCode());
        appLink.setName(erpSsoInfo.getName());
        appLink.setDesc(erpSsoInfo.getAppDesc());
        appLink.setAppToken(erpSsoInfo.getAppToken());
        appLink.setType(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue());
        appLink.setSystemType(ApplicationTypeEnum.CS_APPLICATION.getType());
        appLink.setDataSource(ApplicationTypeEnum.CS_APPLICATION.getType());
        appLink.setCloudwebsite(MapUtils.isNotEmpty((Map)erpSsoInfo.getExt()) ? erpSsoInfo.getExt().get("_fullpath").toString() : "");
        appLink.setApplicationAppId(erpSsoInfo.getAppId());
        appLink.setCallBackUrl(erpSsoInfo.getCallBackUrl());
        appLink.setUserBindFlag(erpSsoInfo.getUserBindFlag());
        if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(erpSsoInfo.getUserBindFlag())) {
            appLink.setNeedAuthCodeFlag(Constants.NEED_AUTH_CODE_FLAG_YES);
        }
        return appLink;
    }

    public AppLinkDTO queryCountLink(LabelSystemCountDataDTO labelSystemCountDataDTO) {
        LabelSystemCountDataDTO.JobInfo jobInfo = labelSystemCountDataDTO.getJobInfo();
        LabelSystemData systemData = new LabelSystemData();
        systemData.setDataCategory(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        systemData.setAppCode(jobInfo.getAppPrimaryId());
        systemData.setDataType(jobInfo.getDataType());
        systemData.setIsJob(jobInfo.getIsJob());
        systemData.setWorkCode(jobInfo.getWorkCode());
        systemData.setCallBackUrl(jobInfo.getCallBackUrl());
        return this.buildCustomApp(systemData);
    }

    private void appendAccountSet(AppLinkDTO appLink, LabelSystemData systemData) {
        if (Objects.nonNull(appLink) && StringUtils.isNotBlank((CharSequence)appLink.getCloudwebsite()) && Objects.nonNull(systemData)) {
            String url = appLink.getCloudwebsite();
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(systemData.getDataCategory()) && StringUtils.isNotBlank((CharSequence)systemData.getAccountId())) {
                appLink.setCloudwebsite(url + "&accountId=" + systemData.getAccountId());
            }
        }
    }

    public JSONObject queryFineReportUrl(QueryFineReportUrlReq queryFineReportUrlReq) {
        boolean matchedFlag;
        JSONObject resp = new JSONObject();
        List fineReportAuthList = this.fineReportAuthService.queryFineReportAuthList();
        if (CollectionUtils.isEmpty((Collection)fineReportAuthList)) {
            resp.put("errorCode", (Object)"1001");
            resp.put("fineReportUrl", (Object)"");
            return resp;
        }
        boolean allFlag = fineReportAuthList.stream().noneMatch(x -> Constants.ALL_AUTH_FLAG_YES.equals(x.getAllAuthFlag()));
        if (allFlag && (matchedFlag = fineReportAuthList.stream().noneMatch(x -> queryFineReportUrlReq.getReportId().equals(x.getFineReportId())))) {
            resp.put("errorCode", (Object)"1001");
            resp.put("fineReportUrl", (Object)"");
            return resp;
        }
        FineReportUserMapping fineReportUserMapping = this.fineReportManageService.queryCurrentUserMapping();
        if (ObjectUtils.isEmpty((Object)fineReportUserMapping)) {
            resp.put("errorCode", (Object)"1002");
            resp.put("fineReportUrl", (Object)"");
            return resp;
        }
        FineReportConfigDTO fineReportConfigDTO = this.tripartiteApplicationService.queryFineReportConfig();
        if (ObjectUtils.isEmpty((Object)fineReportConfigDTO)) {
            resp.put("errorCode", (Object)"1003");
            resp.put("fineReportUrl", (Object)"");
            return resp;
        }
        String path = queryFineReportUrlReq.getPath();
        if (StringUtils.isEmpty((CharSequence)path)) {
            ArrayList totalFineReportList = Lists.newArrayList();
            if (Constants.PC_FINE_REPORT.equals(queryFineReportUrlReq.getDeviceType())) {
                this.queryFineReportListByDeviceType(fineReportConfigDTO, Constants.FineReportDeviceEnum.PC_DEVICVE.getFlag(), (List)totalFineReportList);
            } else if (Constants.MOBILE_FINE_REPORT.equals(queryFineReportUrlReq.getDeviceType())) {
                List<String> deviceTypeList = Arrays.asList(Constants.FineReportDeviceEnum.PAD_DEVICVE.getFlag(), Constants.FineReportDeviceEnum.PFONE_DEVICE.getFlag());
                deviceTypeList.forEach(x -> this.queryFineReportListByDeviceType(fineReportConfigDTO, x, totalFineReportList));
            }
            FineReportTreeVO fineReportTreeVO = totalFineReportList.stream().filter(x -> queryFineReportUrlReq.getReportId().equals(x.getId())).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)fineReportTreeVO)) {
                resp.put("errorCode", (Object)"1004");
                resp.put("fineReportUrl", (Object)"");
                return resp;
            }
            path = fineReportTreeVO.getPath();
        }
        String fineReportUrl = this.buildFineReportUrl(fineReportConfigDTO, fineReportUserMapping.getFrUserId(), path, queryFineReportUrlReq.getDeviceType());
        resp.put("errorCode", (Object)"1000");
        resp.put("fineReportUrl", (Object)fineReportUrl);
        return resp;
    }

    private void queryFineReportListByDeviceType(FineReportConfigDTO fineReportConfigDTO, String deviceType, List<FineReportTreeVO> totalFineReportList) {
        List fineReportTreeList = this.fineReportProxyService.queryFineReportEntryTree(fineReportConfigDTO.getClientId(), fineReportConfigDTO.getSecret(), deviceType);
        fineReportTreeList = fineReportTreeList.stream().filter(y -> Constants.FINE_REPORT_TYPE.equals(y.getEntryType())).sorted(Comparator.comparing(FineReportTreeVO::getSortIndex)).collect(Collectors.toList());
        totalFineReportList.addAll(fineReportTreeList);
    }
}

