/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.portal.LabelSystemCountService;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class LabelSystemCountServiceImpl
implements LabelSystemCountService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemCountServiceImpl.class);
    @Resource
    private ESPService espService;
    @Resource
    private TripartiteService tripartiteService;
    @Resource
    LabelSystemDataMapper labelSystemDataMapper;
    private static final Integer CONTENT_SELECTED_FlAG = 1;

    public JSONArray queryCountConfigData(LabelSystemData labelSystemData) {
        Map result;
        String locale = LocaleContextHolder.getLocale().toString();
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("locale", locale);
            result = this.espService.queryByEsp(labelSystemData.getMiddleSystemName(), labelSystemData.getMiddleSystemUid(), EAIServiceNameEnum.COUNT_COMPONENT_LIST.getServiceName(), null, params, "", null);
        } else {
            result = this.tripartiteService.selectDataCountListPost(null, null, labelSystemData.getRestUrl() + "/third/count/queryConfigList", locale);
        }
        if (MapUtils.isEmpty((Map)result) || ObjectUtils.isEmpty(result.get("countConfigList")) && ObjectUtils.isEmpty(result.get("count_config_list"))) {
            return new JSONArray();
        }
        return ObjectUtils.isNotEmpty(result.get("countConfigList")) ? JSONArray.fromObject(result.get("countConfigList")) : JSONArray.fromObject(result.get("count_config_list"));
    }

    public Map<String, Object> queryCountContentDataByConfig(LabelSystemData labelSystemData) {
        Map<String, Object> result = Maps.newHashMap();
        String locale = LocaleContextHolder.getLocale().toString();
        String countContentInfo = labelSystemData.getCountContentCode();
        if (StringUtils.isBlank((CharSequence)labelSystemData.getCountCode()) || StringUtils.isBlank((CharSequence)countContentInfo)) {
            return result;
        }
        List countDataDTOList = JSON.parseArray((String)countContentInfo, LabelSystemCountDataDTO.class);
        List contentCodeList = countDataDTOList.stream().filter(x -> CONTENT_SELECTED_FlAG.equals(x.getSelectedFlag())).map(LabelSystemCountDataDTO::getContentCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contentCodeList)) {
            return result;
        }
        if (Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("countType", labelSystemData.getCountCode());
            params.put("countContent", contentCodeList);
            params.put("locale", locale);
            result = this.espService.queryByEsp(labelSystemData.getMiddleSystemName(), labelSystemData.getMiddleSystemUid(), EAIServiceNameEnum.COUNT_FRONT_COMPONENT_LIST.getServiceName(), null, params, "", null);
        } else {
            result = this.tripartiteService.selectDataCountListPost(labelSystemData.getCountCode(), contentCodeList, labelSystemData.getRestUrl() + "/third/count/queryContentListByConfig", locale);
        }
        if (MapUtils.isEmpty((Map)result) || ObjectUtils.isEmpty(result.get("countContentList")) && ObjectUtils.isEmpty(result.get("count_content_list"))) {
            return new HashMap<String, Object>();
        }
        JSONArray jsonArray = ObjectUtils.isNotEmpty(result.get("countContentList")) ? JSONArray.fromObject(result.get("countContentList")) : JSONArray.fromObject(result.get("count_content_list"));
        Map contentCodeMap = countDataDTOList.stream().collect(Collectors.toMap(LabelSystemCountDataDTO::getContentCode, Function.identity(), (a, b) -> a));
        for (Object item : jsonArray) {
            LabelSystemCountDataDTO labelSystemCountDataDTO;
            JSONObject jsonObject = (JSONObject)item;
            String linkStr = jsonObject.getString("count_link");
            String countCode = jsonObject.getString("count_code");
            if (StringUtils.isEmpty((CharSequence)linkStr)) {
                labelSystemCountDataDTO = (LabelSystemCountDataDTO)contentCodeMap.get(countCode);
                if (ObjectUtils.isNotEmpty((Object)labelSystemCountDataDTO) && ObjectUtils.isNotEmpty((Object)labelSystemCountDataDTO.getJobInfo()) && ObjectUtils.isNotEmpty((Object)labelSystemCountDataDTO.getJobInfo().getAppPrimaryId()) && ObjectUtils.isNotEmpty((Object)labelSystemCountDataDTO.getJobInfo().getDataType()) && (Constants.IsNeedJobEnum.NEED_CUSTOM_JOB.getValue().equals(labelSystemCountDataDTO.getJobInfo().getIsJob()) && StringUtils.isNotBlank((CharSequence)labelSystemCountDataDTO.getJobInfo().getCallBackUrl()) || Constants.IsNeedJobEnum.NOT_NEED_JOB.getValue().equals(labelSystemCountDataDTO.getJobInfo().getIsJob()) && StringUtils.isNotBlank((CharSequence)labelSystemCountDataDTO.getJobInfo().getWorkCode()))) {
                    jsonObject.put((Object)"ifLink", (Object)true);
                    continue;
                }
                jsonObject.put((Object)"ifLink", (Object)false);
                continue;
            }
            jsonObject.put((Object)"ifLink", (Object)true);
            jsonObject.put((Object)"count_link", null);
            labelSystemCountDataDTO = (LabelSystemCountDataDTO)contentCodeMap.get(countCode);
            if (!ObjectUtils.isNotEmpty((Object)labelSystemCountDataDTO)) continue;
            labelSystemCountDataDTO.setContentLink(linkStr);
            String contentInfoStr = new Gson().toJson((Object)countDataDTOList);
            labelSystemData.setCountContentCode(contentInfoStr);
            this.labelSystemDataMapper.updateById((Object)labelSystemData);
        }
        result.put("countContentList", jsonArray);
        return result;
    }
}

