/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCustomSaveReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustomImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomImportMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.mapper.portal.PortalLayoutCustomMapper;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.RelatedAppServiceWrapper;
import com.digiwin.athena.semc.service.portal.impl.SystemCustomWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemCustomQueryVO;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreQueryVO;
import com.digiwin.athena.semc.vo.portal.SystemCustomExportVo;
import com.digiwin.athena.semc.vo.portal.SystemCustomImportVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import io.github.linpeilie.Converter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class LabelSystemCustomServiceImpl
extends ServiceImpl<LabelSystemCustomMapper, LabelSystemCustom>
implements LabelSystemCustomService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemCustomServiceImpl.class);
    @Resource
    MessageUtils messageUtils;
    @Resource
    LabelSystemCustomMapper labelSystemCustomMapper;
    @Resource
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Resource
    PortalLayoutCustomMapper portalLayoutCustomMapper;
    @Resource
    LabelSystemDataMapper labelSystemDataMapper;
    @Autowired
    PortalInfoContentMapper portalInfoContentMapper;
    @Autowired
    CustomizedMenuTemplateMapper customizedMenuTemplateMapper;
    @Autowired
    MdcService mdcService;
    @Resource
    private IImportRecordService importRecordService;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private LabelSystemCustomImportMapper labelSystemCustomImportMapper;
    @Resource
    private Converter converter;
    @Autowired
    private AppLinkService appLinkService;
    @Autowired
    private LabelSystemPreService labelSystemPreService;
    @Resource
    private LabelSystemPreMapper labelSystemPreMapper;
    @Resource
    private TranslateService translateService;
    @Autowired
    private RelatedAppServiceWrapper relatedAppServiceWrapper;
    @Autowired
    private KmService kmService;
    @Resource
    private PortalInfoMapper portalInfoMapper;
    public static final int CLASSIC_ICON_COUNT = 20;

    public ResultPageBean pageQuery(LabelSystemCustomQueryReq labelSystemCustomQueryReq) {
        ResultPageBean resultPageBean;
        List ids;
        String tenantVersion = this.kmService.queryTenantVersion();
        List labelSystemCustomList = new ArrayList();
        if (!Objects.equals(1, labelSystemCustomQueryReq.getQueryCondition().getSource())) {
            if (CollectionUtils.isNotEmpty((Collection)labelSystemCustomQueryReq.getQueryCondition().getAppCodeList()) || CollectionUtils.isNotEmpty((Collection)labelSystemCustomQueryReq.getQueryCondition().getAccountIds())) {
                LabelSystemCustomQueryReq.QueryCondition queryCondition = labelSystemCustomQueryReq.getQueryCondition();
                HashMap<String, List> req = new HashMap<String, List>();
                req.put("appCodeList", queryCondition.getAppCodeList());
                req.put("accountIds", queryCondition.getAccountIds());
                List longs = this.labelSystemCustomMapper.queryCustomLabelIdByApp(queryCondition.getNameZh(), queryCondition.getDataCategory(), queryCondition.getValidStatus(), req, labelSystemCustomQueryReq.getClientType(), labelSystemCustomQueryReq.getQueryCondition().getSource(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                if (CollectionUtils.isNotEmpty((Collection)longs)) {
                    LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
                    queryPreWrapper.in(LabelSystemCustom::getId, (Collection)longs);
                    labelSystemCustomList = this.labelSystemCustomMapper.selectList((Wrapper)queryPreWrapper);
                }
            } else {
                LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
                queryPreWrapper.eq(LabelSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                queryPreWrapper.like(!StringUtils.isEmpty((CharSequence)labelSystemCustomQueryReq.getQueryCondition().getNameZh()), LabelSystemCustom::getNameZh, (Object)labelSystemCustomQueryReq.getQueryCondition().getNameZh());
                queryPreWrapper.eq(!Objects.isNull(labelSystemCustomQueryReq.getQueryCondition().getValidStatus()), LabelSystemCustom::getValidStatus, (Object)labelSystemCustomQueryReq.getQueryCondition().getValidStatus());
                queryPreWrapper.in(!CollectionUtils.isEmpty((Collection)labelSystemCustomQueryReq.getQueryCondition().getDataCategory()), LabelSystemCustom::getDataCategory, (Collection)labelSystemCustomQueryReq.getQueryCondition().getDataCategory());
                queryPreWrapper.eq(LabelSystemCustom::getClientType, (Object)labelSystemCustomQueryReq.getClientType());
                queryPreWrapper.eq(Objects.nonNull(labelSystemCustomQueryReq.getQueryCondition().getSource()), LabelSystemCustom::getSource, (Object)labelSystemCustomQueryReq.getQueryCondition().getSource());
                labelSystemCustomList = this.labelSystemCustomMapper.selectList((Wrapper)queryPreWrapper);
            }
        }
        if (!Objects.equals(0, labelSystemCustomQueryReq.getQueryCondition().getSource()) && CollectionUtils.isNotEmpty((Collection)(ids = this.getLableSysTemCustomIds(tenantVersion, labelSystemCustomQueryReq.getClientType())))) {
            List labelSystemCustoms = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)labelSystemCustomQueryReq.getQueryCondition().getAppCodeList()) || CollectionUtils.isNotEmpty((Collection)labelSystemCustomQueryReq.getQueryCondition().getAccountIds())) {
                LabelSystemCustomQueryReq.QueryCondition queryCondition = labelSystemCustomQueryReq.getQueryCondition();
                HashMap<String, List> req = new HashMap<String, List>();
                req.put("appCodeList", queryCondition.getAppCodeList());
                req.put("accountIds", queryCondition.getAccountIds());
                List longs = this.labelSystemCustomMapper.queryCustomLabelIdByApp(queryCondition.getNameZh(), queryCondition.getDataCategory(), queryCondition.getValidStatus(), req, labelSystemCustomQueryReq.getClientType(), labelSystemCustomQueryReq.getQueryCondition().getSource(), "SYSTEM_TENANT");
                List intersection = (List)CollectionUtils.intersection((Collection)ids, (Collection)longs);
                if (CollectionUtils.isNotEmpty((Collection)intersection)) {
                    labelSystemCustoms = this.labelSystemCustomMapper.selectBatchIds((Collection)intersection);
                }
            } else {
                LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
                queryPreWrapper.eq(LabelSystemCustom::getTenantId, (Object)"SYSTEM_TENANT");
                queryPreWrapper.like(!StringUtils.isEmpty((CharSequence)labelSystemCustomQueryReq.getQueryCondition().getNameZh()), LabelSystemCustom::getNameZh, (Object)labelSystemCustomQueryReq.getQueryCondition().getNameZh());
                queryPreWrapper.eq(!Objects.isNull(labelSystemCustomQueryReq.getQueryCondition().getValidStatus()), LabelSystemCustom::getValidStatus, (Object)labelSystemCustomQueryReq.getQueryCondition().getValidStatus());
                queryPreWrapper.in(!CollectionUtils.isEmpty((Collection)labelSystemCustomQueryReq.getQueryCondition().getDataCategory()), LabelSystemCustom::getDataCategory, (Collection)labelSystemCustomQueryReq.getQueryCondition().getDataCategory());
                queryPreWrapper.eq(LabelSystemCustom::getClientType, (Object)labelSystemCustomQueryReq.getClientType());
                queryPreWrapper.eq(Objects.nonNull(labelSystemCustomQueryReq.getQueryCondition().getSource()), LabelSystemCustom::getSource, (Object)labelSystemCustomQueryReq.getQueryCondition().getSource());
                queryPreWrapper.in(LabelSystemCustom::getId, (Collection)ids);
                labelSystemCustoms = this.labelSystemCustomMapper.selectList((Wrapper)queryPreWrapper);
            }
            if (CollectionUtils.isNotEmpty(labelSystemCustoms)) {
                labelSystemCustomList.addAll(labelSystemCustoms);
            }
        }
        if (!CollectionUtils.isEmpty(labelSystemCustomList)) {
            Gson gson = new Gson();
            List labelSystemSourceList = this.labelSystemSourceMapper.listByCondition(null, Integer.valueOf(0), labelSystemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList()));
            LinkedList dataSourceInfoList = new LinkedList();
            labelSystemSourceList.forEach(item -> {
                LabelSystemCustomQueryVO.DataSourceInfo dataSourceInfo = (LabelSystemCustomQueryVO.DataSourceInfo)gson.fromJson(JSON.toJSONString((Object)item), LabelSystemCustomQueryVO.DataSourceInfo.class);
                dataSourceInfoList.add(dataSourceInfo);
            });
            Map<Long, List<LabelSystemCustomQueryVO.DataSourceInfo>> map = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemCustomQueryVO.DataSourceInfo::getSystemId));
            List labelSystemCustomQueryVOList = labelSystemCustomList.stream().map(item -> {
                StringBuilder stringBuilder;
                List linkParamList;
                List dataList = (List)map.get(item.getId());
                LabelSystemCustomQueryVO labelSystemCustomQueryVO = (LabelSystemCustomQueryVO)this.converter.convert(item, LabelSystemCustomQueryVO.class);
                labelSystemCustomQueryVO.setComponentSource(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                labelSystemCustomQueryVO.setDataSourceInfo(dataList);
                if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(item.getDataCategory())) {
                    labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl());
                    if (StringUtils.isNotBlank((CharSequence)item.getLinkParam())) {
                        linkParamList = JSONArray.parseArray((String)item.getLinkParam(), LabelSystemLinkParamDTO.class);
                        labelSystemCustomQueryVO.setLinkParamList(linkParamList);
                        stringBuilder = Utils.buildWebLinkDisplayUrl((String)item.getLinkParam());
                        labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl() + "?" + stringBuilder);
                    }
                }
                if (Objects.equals(11, item.getDataCategory())) {
                    labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl());
                    if (StringUtils.isNotBlank((CharSequence)item.getLinkParam())) {
                        linkParamList = JSONArray.parseArray((String)item.getLinkParam(), LabelSystemLinkParamDTO.class);
                        labelSystemCustomQueryVO.setLinkParamList(linkParamList);
                        stringBuilder = Utils.buildWebLinkDisplayUrl((String)item.getLinkParam());
                        labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl() + "?" + stringBuilder);
                    }
                }
                return labelSystemCustomQueryVO;
            }).collect(Collectors.toList());
            if (Constants.IS_LAYOUT.equals(labelSystemCustomQueryReq.getIsLayout())) {
                this.filterPortalLayout(labelSystemCustomQueryVOList);
            }
            List LabelSystemCustomQuerySortVO = labelSystemCustomQueryVOList.stream().sorted(Comparator.comparing(LabelSystemCustomQueryVO::getModifyTime).reversed()).collect(Collectors.toList());
            List pageData = LabelSystemCustomQuerySortVO.stream().skip((long)(labelSystemCustomQueryReq.getPageNum() - 1) * labelSystemCustomQueryReq.getPageSize().longValue()).limit(labelSystemCustomQueryReq.getPageSize().intValue()).collect(Collectors.toList());
            for (LabelSystemCustomQueryVO labelSystemCustomQueryVO : pageData) {
                if (!"SYSTEM_TENANT".equals(labelSystemCustomQueryVO.getTenantId())) continue;
                labelSystemCustomQueryVO.setStatus(Integer.valueOf(1));
            }
            this.buildAppInfo(pageData);
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(pageData, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemCustomQueryReq.getPageNum(), (Integer)labelSystemCustomQueryReq.getPageSize(), (Integer)LabelSystemCustomQuerySortVO.size())));
        } else {
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemCustomList, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemCustomQueryReq.getPageNum(), (Integer)labelSystemCustomQueryReq.getPageSize(), (Integer)labelSystemCustomList.size())));
        }
        return resultPageBean;
    }

    private List<Long> getLableSysTemCustomIds(String tenantVersion, Integer clientType) {
        List isddds = this.relatedAppServiceWrapper.queryCurrTenantPortalList(tenantVersion);
        if (CollectionUtils.isEmpty((Collection)isddds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(PortalInfo::getVersion, (Object)tenantVersion)).in(CollectionUtils.isNotEmpty((Collection)isddds), PortalInfo::getPortalDesignerId, (Collection)isddds);
        queryWrapper.eq(PortalInfo::getClientType, (Object)clientType);
        List portalInfoList = (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.selectList((Wrapper)queryWrapper));
        ArrayList<Long> portalIds = new ArrayList<Long>();
        for (PortalInfo portalInfo : portalInfoList) {
            Long id = portalInfo.getId();
            portalIds.add(id);
        }
        if (CollectionUtils.isEmpty(portalIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (Objects.equals(0, clientType)) {
            lambdaQueryWrapper.in(PortalInfoContent::getContentType, new Object[]{0});
        } else {
            lambdaQueryWrapper.in(PortalInfoContent::getContentType, new Object[]{11});
        }
        ((LambdaQueryWrapper)lambdaQueryWrapper.in(PortalInfoContent::getLabelTypeSource, new Object[]{1})).in(CollectionUtils.isNotEmpty(portalIds), PortalInfoContent::getPortalId, portalIds);
        List portalInfoContents = (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoContentMapper.selectList((Wrapper)lambdaQueryWrapper));
        ArrayList<Long> contentIds = new ArrayList<Long>();
        for (PortalInfoContent portalInfoContent : portalInfoContents) {
            Long contentId = portalInfoContent.getContentId();
            contentIds.add(contentId);
        }
        if (CollectionUtils.isEmpty(contentIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper labelSystemCustomLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)labelSystemCustomLambdaQueryWrapper.in(CollectionUtils.isNotEmpty(contentIds), LabelSystemCustom::getComponentDesignerId, contentIds)).eq(LabelSystemCustom::getVersion, (Object)tenantVersion);
        List labelSystemCustoms = this.labelSystemCustomMapper.selectList((Wrapper)labelSystemCustomLambdaQueryWrapper);
        List<Long> collect = labelSystemCustoms.stream().map(e -> e.getId()).collect(Collectors.toList());
        return collect;
    }

    private void buildAppInfo(List<LabelSystemCustomQueryVO> pageData) {
        try {
            List labelSystemDataList;
            HashSet dataIds = new HashSet();
            pageData.forEach(item -> {
                if (CollectionUtils.isNotEmpty((Collection)item.getDataSourceInfo())) {
                    dataIds.add(((LabelSystemCustomQueryVO.DataSourceInfo)item.getDataSourceInfo().get(0)).getDataId());
                }
            });
            if (CollectionUtils.isNotEmpty(dataIds) && CollectionUtils.isNotEmpty((Collection)(labelSystemDataList = this.labelSystemDataMapper.selByIds(new ArrayList(dataIds))))) {
                Map<Long, LabelSystemData> labelSystemDataMap = labelSystemDataList.stream().collect(Collectors.toMap(LabelSystemData::getId, a -> a, (k1, k2) -> k1));
                List appLinkList = this.appLinkService.queryManageList(AppAuthContextHolder.getContext().getAuthoredUser());
                Map<String, AppLinkDTO> appLinkMap = appLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, value -> value, (key1, key2) -> key1));
                pageData.forEach(item -> {
                    Long dataId;
                    LabelSystemData labelSystemData;
                    if (CollectionUtils.isNotEmpty((Collection)item.getDataSourceInfo()) && Objects.nonNull(labelSystemData = (LabelSystemData)labelSystemDataMap.get(dataId = ((LabelSystemCustomQueryVO.DataSourceInfo)item.getDataSourceInfo().get(0)).getDataId()))) {
                        item.setAccountId(labelSystemData.getAccountId());
                        item.setAppSystemId(labelSystemData.getAppCode());
                        item.setDataSource(labelSystemData.getDataType());
                        AppLinkDTO appLinkDTO = (AppLinkDTO)appLinkMap.get(labelSystemData.getAppCode());
                        if (Objects.nonNull(appLinkDTO)) {
                            item.setAppCode(appLinkDTO.getCode());
                            item.setAppName(appLinkDTO.getName());
                        } else if (VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(labelSystemData.getAppCode())) {
                            item.setAppCode(VirtualApplicationEnum.ATHENA_APP.getCode());
                            item.setAppName(VirtualApplicationEnum.ATHENA_APP.getName());
                        } else if (VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getPrimaryId().equals(labelSystemData.getAppCode())) {
                            item.setAppCode(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getCode());
                            item.setAppName(VirtualApplicationEnum.ATHENA_AGILE_INTERACTION.getName());
                        } else if (VirtualApplicationEnum.FINE_REPORT_APP.getPrimaryId().equals(labelSystemData.getAppCode())) {
                            item.setAppCode(VirtualApplicationEnum.FINE_REPORT_APP.getCode());
                            item.setAppName(VirtualApplicationEnum.FINE_REPORT_APP.getName());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("LabelSystemCustomQueryVO.buildAppInfo is error", (Throwable)e);
        }
    }

    private List<LabelSystemCustomQueryVO> filterPortalLayout(List<LabelSystemCustomQueryVO> labelSystemCustomQueryVOList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PortalLayoutCustom::getLabelType, (Object)0);
        queryWrapper.eq(PortalLayoutCustom::getTenantId, (Object)Utils.getTenantId());
        queryWrapper.eq(BaseEntity::getDelFlag, (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
        List portalLayoutCustomList = this.portalLayoutCustomMapper.selectList((Wrapper)queryWrapper);
        portalLayoutCustomList.forEach(data -> labelSystemCustomQueryVOList.removeIf(e -> e.getId().equals(data.getLabelId())));
        return labelSystemCustomQueryVOList;
    }

    private List<LabelSystemPreQueryVO> filterPortalLayoutPre(List<LabelSystemPreQueryVO> labelSystemPreQueryVOList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PortalLayoutCustom::getLabelType, (Object)1);
        queryWrapper.eq(PortalLayoutCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(BaseEntity::getDelFlag, (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
        List portalLayoutCustomList = this.portalLayoutCustomMapper.selectList((Wrapper)queryWrapper);
        portalLayoutCustomList.forEach(data -> labelSystemPreQueryVOList.removeIf(e -> e.getId().equals(data.getLabelId())));
        List<LabelSystemPreQueryVO> labelSystemPreVOList = labelSystemPreQueryVOList.stream().filter(e -> !e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal()) && !e.getDataType().equals(Constants.DataTypeEnum.TYPE_CAROUSEL.getVal())).collect(Collectors.toList());
        return labelSystemPreVOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> save(LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        ResponseEntity responseEntity = this.validData(labelSystemCustomSaveReq);
        if (null != responseEntity) {
            return responseEntity;
        }
        LabelSystemCustom labelSystemCustom = (LabelSystemCustom)this.converter.convert((Object)labelSystemCustomSaveReq, LabelSystemCustom.class);
        if (CollectionUtils.isNotEmpty((Collection)labelSystemCustomSaveReq.getLinkParamList())) {
            String linkParam = JSON.toJSONString((Object)labelSystemCustomSaveReq.getLinkParamList());
            labelSystemCustom.setLinkParam(linkParam);
        }
        if (Objects.isNull(labelSystemCustomSaveReq.getId())) {
            labelSystemCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            labelSystemCustom.setValidStatus(Integer.valueOf(0));
            labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            labelSystemCustom.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            this.labelSystemCustomMapper.insert((Object)labelSystemCustom);
            if (!CollectionUtils.isEmpty((Collection)labelSystemCustomSaveReq.getDataSourceInfo())) {
                List labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream().map(item -> {
                    LabelSystemSource labelSystemSource = (LabelSystemSource)this.converter.convert(item, LabelSystemSource.class);
                    labelSystemSource.setSystemId(labelSystemCustom.getId());
                    labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    return labelSystemSource;
                }).collect(Collectors.toList());
                this.labelSystemSourceMapper.insertBatch(labelSystemSourceList);
            }
            return ResponseEntityWrapper.wrapperOk((Object)labelSystemCustom.getId());
        }
        labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        if (Objects.equals("SYSTEM_TENANT", labelSystemCustom.getTenantId())) {
            String error = this.messageUtils.getMessage("error.message.system.lable.custom.not.modify");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
        }
        this.labelSystemCustomMapper.updateById((Object)labelSystemCustom);
        if (!CollectionUtils.isEmpty((Collection)labelSystemCustomSaveReq.getDataSourceInfo())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(LabelSystemSource::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            updateWrapper.in(LabelSystemSource::getSystemId, (Collection)labelSystemCustomSaveReq.getDataSourceInfo().stream().map(LabelSystemCustomSaveReq.DataSourceInfo::getSystemId).collect(Collectors.toList()));
            this.labelSystemSourceMapper.delete((Wrapper)updateWrapper);
            List labelSystemSourceList = labelSystemCustomSaveReq.getDataSourceInfo().stream().map(item -> {
                LabelSystemSource labelSystemSource = (LabelSystemSource)this.converter.convert(item, LabelSystemSource.class);
                labelSystemSource.setSystemId(labelSystemCustomSaveReq.getId());
                labelSystemSource.setComponentSource(Integer.valueOf(0));
                labelSystemSource.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                return labelSystemSource;
            }).collect(Collectors.toList());
            this.labelSystemSourceMapper.insertItemBatch(labelSystemSourceList);
        }
        return ResponseEntityWrapper.wrapperOk((Object)labelSystemCustomSaveReq.getId());
    }

    private ResponseEntity<?> validData(LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(labelSystemCustomSaveReq.getDataCategory()) && StringUtils.isBlank((CharSequence)labelSystemCustomSaveReq.getLinkUrl())) {
            String error = String.format(this.messageUtils.getMessage("error.message.system.link.not.null"), new Object[0]);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
        }
        if (Objects.nonNull(labelSystemCustomSaveReq.getId())) {
            LambdaQueryWrapper queryWrapperById = new LambdaQueryWrapper();
            queryWrapperById.eq(LabelSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperById.eq(LabelSystemCustom::getId, (Object)labelSystemCustomSaveReq.getId());
            LabelSystemCustom labelSystemCustom = (LabelSystemCustom)this.labelSystemCustomMapper.selectOne((Wrapper)queryWrapperById);
            if (ObjectUtils.isEmpty((Object)labelSystemCustom)) {
                String error = String.format(this.messageUtils.getMessage("error.message.system.custom.not.exist"), new Object[0]);
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
            if (!labelSystemCustom.getDataCategory().equals(labelSystemCustomSaveReq.getDataCategory())) {
                String error = String.format(this.messageUtils.getMessage("error.message.system.custom.not.modify"), new Object[0]);
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
            if (Objects.equals("SYSTEM_TENANT", labelSystemCustom.getTenantId())) {
                String error = String.format(this.messageUtils.getMessage("error.message.system.lable.custom.not.modify"), new Object[0]);
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(LabelSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            List labelSystemCustomList = this.labelSystemCustomMapper.selectList((Wrapper)queryWrapper);
            if (!labelSystemCustomSaveReq.getNameZh().trim().equals(labelSystemCustom.getNameZh())) {
                for (LabelSystemCustom data : labelSystemCustomList) {
                    if (!labelSystemCustomSaveReq.getNameZh().trim().equals(data.getNameZh())) continue;
                    String error = String.format(this.messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
                }
            }
        } else {
            LambdaQueryWrapper queryZhWrapper = new LambdaQueryWrapper();
            queryZhWrapper.eq(LabelSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryZhWrapper.eq(LabelSystemCustom::getNameZh, (Object)labelSystemCustomSaveReq.getNameZh());
            List labelSystemCustomZh = this.labelSystemCustomMapper.selectList((Wrapper)queryZhWrapper);
            if (labelSystemCustomZh.size() >= 1) {
                String error = String.format(this.messageUtils.getMessage("error.message.system.custom.name.zh.exist"), labelSystemCustomSaveReq.getNameZh());
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
            LambdaQueryWrapper queryUsWrapper = new LambdaQueryWrapper();
            queryUsWrapper.eq(LabelSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryUsWrapper.eq(LabelSystemCustom::getNameUs, (Object)labelSystemCustomSaveReq.getNameUs());
            List labelSystemCustomUs = this.labelSystemCustomMapper.selectList((Wrapper)queryUsWrapper);
            if (labelSystemCustomUs.size() >= 1) {
                String error = String.format(this.messageUtils.getMessage("error.message.system.custom.name.us.exist"), labelSystemCustomSaveReq.getNameUs());
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)labelSystemCustomSaveReq.getDataSourceInfo())) {
            for (LabelSystemCustomSaveReq.DataSourceInfo item : labelSystemCustomSaveReq.getDataSourceInfo()) {
                LambdaQueryWrapper queryWrapperData = new LambdaQueryWrapper();
                queryWrapperData.eq(LabelSystemData::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                queryWrapperData.eq(LabelSystemData::getId, (Object)item.getDataId());
                LabelSystemData labelSystemData = (LabelSystemData)this.labelSystemDataMapper.selectOne((Wrapper)queryWrapperData);
                if (labelSystemData.getDataCategory().equals(labelSystemCustomSaveReq.getDataCategory())) continue;
                String error = this.messageUtils.getMessage("error.message.system.pre.dara.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, (String)error);
            }
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> delete(List<Long> idList, Integer clentType) {
        List labelSystemCustom;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LabelSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (idList.size() == 1) {
            queryWrapper.eq(LabelSystemCustom::getId, (Object)idList.get(0));
            queryWrapper.eq(LabelSystemCustom::getValidStatus, (Object)0);
            labelSystemCustom = (LabelSystemCustom)this.labelSystemCustomMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtils.isEmpty((Object)labelSystemCustom)) {
                String error = this.messageUtils.getMessage("error.message.system.custom.del.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
        } else {
            queryWrapper.in(LabelSystemCustom::getId, idList);
            labelSystemCustom = this.labelSystemCustomMapper.selectList((Wrapper)queryWrapper);
            boolean flag = labelSystemCustom.stream().anyMatch(item -> Constants.LABEL_SYSTEM_PRE_VALID_STATUS.equals(item.getValidStatus()));
            if (flag) {
                String error = this.messageUtils.getMessage("error.message.system.custom.batdel.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)error);
            }
        }
        LambdaQueryWrapper cusQueryWrapper = new LambdaQueryWrapper();
        cusQueryWrapper.in(PortalLayoutCustom::getLabelId, idList);
        cusQueryWrapper.eq(PortalLayoutCustom::getLabelType, (Object)Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
        cusQueryWrapper.eq(PortalLayoutCustom::getTenantId, (Object)Utils.getTenantId());
        cusQueryWrapper.eq(BaseEntity::getDelFlag, (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
        PortalLayoutCustom portalLayoutCustom = (PortalLayoutCustom)this.portalLayoutCustomMapper.selectOne((Wrapper)cusQueryWrapper);
        if (!ObjectUtils.isEmpty((Object)portalLayoutCustom)) {
            String error = this.messageUtils.getMessage("error.message.system.portal.layout.del");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
        }
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List contentList = this.portalInfoContentMapper.selPortalConent(tenantId, idList, Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), null);
        if (CollectionUtils.isNotEmpty((Collection)contentList)) {
            String error = this.messageUtils.getMessage("error.message.jd.portal.layout.del.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
        }
        List templateList = this.customizedMenuTemplateMapper.queryTempListByLabelId(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), idList, tenantId);
        if (CollectionUtils.isNotEmpty((Collection)templateList)) {
            String error = this.messageUtils.getMessage("error.message.jd.menu.del.error");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
        }
        try {
            List labelSystemCustoms = this.labelSystemCustomMapper.selectBatchIds(idList);
            for (LabelSystemCustom labelSystemCustom2 : labelSystemCustoms) {
                if (!labelSystemCustom2.getTenantId().equals("SYSTEM_TENANT")) continue;
                idList.remove(labelSystemCustom2.getId());
            }
            this.labelSystemCustomMapper.deleteBatchIds(idList);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(LabelSystemSource::getSystemId, idList);
            updateWrapper.eq(LabelSystemSource::getComponentSource, (Object)Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
            this.labelSystemSourceMapper.delete((Wrapper)updateWrapper);
        }
        catch (Exception e) {
            log.error("delete system.custom error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_LABEL_SYSTEM_CUSTOM, (String)this.messageUtils.getMessage("error.message.system.custom.delete-error"));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public List<LabelSystemCustom> queryCustomSystem(LabelSystemAllVo req) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)req.getDataCategoryList())) {
            condition.in((Object)"data_category", (Collection)req.getDataCategoryList());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.like((Object)"name_zh", (Object)req.getName());
        }
        condition.eq((Object)"valid_status", (Object)1);
        condition.orderByDesc((Object)"modify_time");
        return this.labelSystemCustomMapper.selectList((Wrapper)condition);
    }

    public List<SystemCustomImportVo> readExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.mdcService.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(SystemCustomImportVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = this.mdcService.doReadSync(excelListener);
        }
        catch (Exception e) {
            log.error("SystemDataImport read excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Transactional
    public ImportExcelResp importReport(List<SystemCustomImportVo> customImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        List<Object> customNameList = new ArrayList();
        Map<Object, Object> systemDataMap = new HashMap();
        List systemDataList = this.labelSystemDataMapper.selectList((Wrapper)new QueryWrapper());
        if (CollectionUtils.isNotEmpty((Collection)systemDataList)) {
            systemDataMap = systemDataList.stream().collect(Collectors.toMap(LabelSystemData::getName, Function.identity(), (a, b) -> a));
        }
        LambdaQueryWrapper labelSystemCustomLambdaQueryWrapper = new LambdaQueryWrapper();
        labelSystemCustomLambdaQueryWrapper.ne(LabelSystemCustom::getTenantId, (Object)"SYSTEM_TENANT");
        List systemCustomList = this.labelSystemCustomMapper.selectList((Wrapper)labelSystemCustomLambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)systemCustomList)) {
            customNameList = systemCustomList.stream().map(LabelSystemCustom::getNameZh).collect(Collectors.toList());
        }
        Map categoryMap = this.initCategoryMap();
        Map statusMap = this.initStatusMap();
        int successNum = 0;
        int failNum = 0;
        int iconIndex = 0;
        int classIconAppIndex = 1;
        int classIconJobIndex = 1;
        for (SystemCustomImportVo customImportVo : customImportVoList) {
            StringBuilder errorSb = this.validateData(customImportVo, customNameList, systemDataMap, categoryMap);
            if (StringUtils.isNotBlank((CharSequence)errorSb.toString())) {
                ++failNum;
                customImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            customImportVo.setFailDesc(errorSb.toString());
            LabelSystemCustom systemCustom = this.initLabelCustom(customImportVo, systemDataMap, categoryMap, statusMap, iconIndex, classIconAppIndex, classIconJobIndex);
            ++successNum;
            ++iconIndex;
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
                ++classIconJobIndex;
            }
            if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
                ++classIconAppIndex;
            }
            if (iconIndex >= 7) {
                iconIndex = 0;
            }
            if (classIconAppIndex > 20) {
                classIconAppIndex = 1;
            }
            if (classIconJobIndex <= 20) continue;
            classIconJobIndex = 1;
        }
        String nowTime = DateUtils.getNowTime((String)"yyyyMMddHHmmss");
        ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write(customImportVoList, nowTime));
        this.initDataImport(shareInfo.getFileId(), Integer.valueOf(successNum), Integer.valueOf(failNum), nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(Integer.valueOf(failNum));
        excelResp.setSuccessCount(Integer.valueOf(successNum));
        return excelResp;
    }

    public LabelSystemCustomImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        LabelSystemCustomImport importRecord = new LabelSystemCustomImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        this.labelSystemCustomImportMapper.insert((Object)importRecord);
        return importRecord;
    }

    public File write(List<SystemCustomImportVo> list, String nowTime) {
        File file = new File("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5bfc\u5165\u8bb0\u5f55_" + nowTime + ".xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file, SystemCustomImportVo.class).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)new SystemCustomWriteHandler())).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).sheet("\u81ea\u5b9a\u4e49\u7ec4\u4ef6").doWrite(list);
        return file;
    }

    public LabelSystemCustom initLabelCustom(SystemCustomImportVo customImportVo, Map<String, LabelSystemData> systemDataMap, Map<String, Integer> categoryMap, Map<String, Integer> statusMap, int iconIndex, int classIconAppIndex, int classIconJobIndex) {
        LabelSystemCustom systemCustom = new LabelSystemCustom();
        systemCustom.setNameZh(customImportVo.getNameZh());
        systemCustom.setRemark(customImportVo.getRemark());
        systemCustom.setDataCategory(categoryMap.get(customImportVo.getDataCategory()));
        systemCustom.setValidStatus(statusMap.get(customImportVo.getValidStatus()));
        systemCustom.setCreateUserName(Utils.getUserName());
        systemCustom.setModifyUserName(Utils.getUserName());
        systemCustom.setCreateUserId(Utils.getUserId());
        systemCustom.setCreateTime(DateUtils.getNowTime((String)""));
        systemCustom.setModifyTime(DateUtils.getNowTime((String)""));
        systemCustom.setModifyUserId(Utils.getUserId());
        systemCustom.setTenantId(Utils.getTenantId());
        systemCustom.setIcon(Utils.getPortCard((int)iconIndex));
        if (Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal().equals(customImportVo.getDataCategory())) {
            systemCustom.setLinkUrl(customImportVo.getDataName());
        }
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())) {
            systemCustom.setClassicsIcon("icon_tzzy_" + classIconJobIndex);
        }
        if (systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())) {
            systemCustom.setClassicsIcon("icon_tzyy_" + classIconAppIndex);
        }
        systemCustom.setClientType(Integer.valueOf(0));
        this.labelSystemCustomMapper.insert((Object)systemCustom);
        LabelSystemData systemData = systemDataMap.get(customImportVo.getDataName());
        if (null != systemData) {
            LabelSystemSource systemSource = new LabelSystemSource();
            systemSource.setSystemId(systemCustom.getId());
            systemSource.setDataId(systemData.getId());
            systemSource.setComponentSource(Integer.valueOf(0));
            systemSource.setCreateTime(DateUtils.getNowTime((String)""));
            systemSource.setTenantId(Utils.getTenantId());
            this.labelSystemSourceMapper.insert((Object)systemSource);
        }
        return systemCustom;
    }

    private StringBuilder validateData(SystemCustomImportVo customImportVo, List<String> customNameList, Map<String, LabelSystemData> systemDataMap, Map<String, Integer> categoryMap) {
        StringBuilder errorSb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)customImportVo.getNameZh())) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getNameZh()) && customImportVo.getNameZh().length() > 40) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (customNameList.contains(customImportVo.getNameZh())) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u540d\u79f0\u201d\u91cd\u590d").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getNameZh())) {
            customNameList.add(customImportVo.getNameZh());
        }
        if (StringUtils.isEmpty((CharSequence)customImportVo.getDataCategory())) {
            errorSb.append("\u201c\u7ec4\u4ef6\u5206\u7c7b\u201d\u672a\u586b\u5199").append(",");
        }
        List categoryNameList = this.initCategoryNameList();
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataCategory()) && !categoryNameList.contains(customImportVo.getDataCategory())) {
            errorSb.append("\u201c\u7ec4\u4ef6\u5206\u7c7b\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)customImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u672a\u586b\u5199").append(",");
        }
        List validStatusList = this.initValidStatusList();
        if (StringUtils.isNotEmpty((CharSequence)customImportVo.getValidStatus()) && !validStatusList.contains(customImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)customImportVo.getRemark()) && customImportVo.getRemark().length() > 100) {
            errorSb.append("\u201c\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5907\u6ce8\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)customImportVo.getDataName())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (customImportVo.getDataName().length() > 500) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (!Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal().equals(customImportVo.getDataCategory())) {
            LabelSystemData systemData;
            if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataName()) && null == systemDataMap.get(customImportVo.getDataName())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u503c\u9519\u8bef").append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataName()) && StringUtils.isNotEmpty((CharSequence)customImportVo.getDataCategory()) && null != systemDataMap.get(customImportVo.getDataName()) && !(systemData = systemDataMap.get(customImportVo.getDataName())).getDataCategory().equals(categoryMap.get(customImportVo.getDataCategory()))) {
                errorSb.append("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u7c7b\u578b\u4e0e\u5173\u8054\u6570\u636e\u6e90\u7c7b\u578b\u4e0d\u4e00\u81f4").append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)customImportVo.getDataName()) && null != systemDataMap.get(customImportVo.getDataName()) && (systemData = systemDataMap.get(customImportVo.getDataName())).getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
                errorSb.append("\u5173\u8054\u6570\u636e\u6e90\u672a\u542f\u7528").append(",");
            }
        }
        return errorSb;
    }

    public Map<String, Integer> initCategoryMap() {
        HashMap<String, Integer> categoryMap = new HashMap<String, Integer>();
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal(), Constants.DataCategoryEnum.WEB_PAGE.getVal());
        return categoryMap;
    }

    public Map<String, Integer> initStatusMap() {
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal(), Constants.VALID_STATUS_ENABLE);
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal(), Constants.VALID_STATUS_UNUSABLE);
        return statusMap;
    }

    public Map<Integer, String> initCategoryValMap() {
        HashMap<Integer, String> categoryMap = new HashMap<Integer, String>();
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_WORK.getVal(), Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_APP.getVal(), Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.WEB_PAGE.getVal(), Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal());
        return categoryMap;
    }

    public Map<Integer, String> initStatusValMap() {
        HashMap<Integer, String> statusMap = new HashMap<Integer, String>();
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_REPORT.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        return statusMap;
    }

    public List<String> initCategoryNameList() {
        ArrayList<String> categoryNameList = new ArrayList<String>();
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WEB_NAME.getVal());
        return categoryNameList;
    }

    public List<String> initValidStatusList() {
        ArrayList<String> validStatusList = new ArrayList<String>();
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        return validStatusList;
    }

    public PageInfoResp<LabelSystemCustomImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isBlank((CharSequence)queryImportRecordReq.getStartTime()) || StringUtils.isBlank((CharSequence)queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
            condition.ge((Object)"create_time", (Object)DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
            condition.le((Object)"create_time", (Object)currentDate);
        } else {
            condition.ge((Object)"create_time", (Object)queryImportRecordReq.getStartTime());
            condition.le((Object)"create_time", (Object)queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryImportRecordReq.getUserIdName())) {
            condition.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"create_user_name", (Object)queryImportRecordReq.getUserIdName())).or()).like((Object)"create_user_id", (Object)queryImportRecordReq.getUserIdName());
            });
        }
        condition.orderByDesc((Object)"create_time");
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize().intValue());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page pageResult = (Page)this.labelSystemCustomImportMapper.selectPage((IPage)new Page((long)queryImportRecordReq.getPageNum().intValue(), (long)queryImportRecordReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            pageResult.getRecords().forEach(x -> x.setFileUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + x.getFileId().trim()));
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
            pageInfoResp.setList(pageResult.getRecords());
        } else {
            pageInfoResp.setList((List)Lists.newArrayList());
        }
        return pageInfoResp;
    }

    public List<SystemCustomExportVo> exportReport() {
        ArrayList<SystemCustomExportVo> customExportVoList = new ArrayList<SystemCustomExportVo>();
        LabelSystemAllVo req = new LabelSystemAllVo();
        ArrayList<Integer> dataCategoryList = new ArrayList<Integer>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List systemCustomList = this.queryCustomList(req);
        if (CollectionUtils.isEmpty((Collection)systemCustomList)) {
            return customExportVoList;
        }
        List customIdList = systemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList());
        List systemSourcCusList = this.labelSystemSourceMapper.selBySystemIds(customIdList, Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal());
        if (CollectionUtils.isEmpty((Collection)systemSourcCusList)) {
            return customExportVoList;
        }
        Map<Long, Long> systemSourcMap = systemSourcCusList.stream().collect(Collectors.toMap(LabelSystemSource::getSystemId, LabelSystemSource::getDataId, (a, b) -> a));
        List dataIdList = systemSourcCusList.stream().map(LabelSystemSource::getDataId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataIdList)) {
            return customExportVoList;
        }
        List systemDataList = this.labelSystemDataMapper.selByIds(dataIdList);
        Map systemDataMap = systemDataList.stream().collect(Collectors.toMap(LabelSystemData::getId, Function.identity()));
        Map categoryMap = this.initCategoryValMap();
        Map statusMap = this.initStatusValMap();
        for (LabelSystemCustom systemCustom : systemCustomList) {
            LabelSystemData systemData;
            SystemCustomExportVo customExport = new SystemCustomExportVo();
            customExport.setNameZh(systemCustom.getNameZh());
            customExport.setDataCategory((String)categoryMap.get(systemCustom.getDataCategory()));
            customExport.setValidStatus((String)statusMap.get(systemCustom.getValidStatus()));
            customExport.setRemark(systemCustom.getRemark());
            Long dataId = systemSourcMap.get(systemCustom.getId());
            if (null != dataId && null != (systemData = (LabelSystemData)systemDataMap.get(dataId))) {
                customExport.setDataName(systemData.getName());
            }
            customExportVoList.add(customExport);
        }
        return customExportVoList;
    }

    public List<LabelSystemCustom> queryCustomList(LabelSystemAllVo req) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"client_type", (Object)0);
        if (CollectionUtils.isNotEmpty((Collection)req.getDataCategoryList())) {
            condition.in((Object)"data_category", (Collection)req.getDataCategoryList());
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getIdList())) {
            condition.in((Object)"id", (Collection)req.getIdList());
        }
        if (!ObjectUtils.isEmpty((Object)req.getValidStatus())) {
            condition.eq((Object)"valid_status", (Object)req.getValidStatus());
        }
        condition.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        condition.orderByDesc((Object)"modify_time");
        return this.labelSystemCustomMapper.selectList((Wrapper)condition);
    }

    public Page<BizObjAuthRelBatchSystemVo> pageListCustom(List<Long> idList, AuthSystemLabelReq req, List<Long> permSystemIdList) {
        LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
        queryPreWrapper.like(StringUtils.isNotEmpty((CharSequence)req.getName()), LabelSystemCustom::getNameZh, (Object)req.getName());
        queryPreWrapper.in(CollectionUtils.isNotEmpty(idList), LabelSystemCustom::getId, idList);
        queryPreWrapper.notIn(CollectionUtils.isNotEmpty(permSystemIdList), LabelSystemCustom::getId, permSystemIdList);
        queryPreWrapper.last("ORDER BY cast(name_zh as char character set gbk ) ASC,id desc");
        Page systemCustomPage = (Page)this.labelSystemCustomMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)queryPreWrapper);
        ArrayList<BizObjAuthRelBatchSystemVo> relBatchSystemVoList = new ArrayList<BizObjAuthRelBatchSystemVo>();
        Page relBatchSystemVoPage = new Page();
        for (LabelSystemCustom systemCustom : systemCustomPage.getRecords()) {
            BizObjAuthRelBatchSystemVo systemVo = new BizObjAuthRelBatchSystemVo();
            systemVo.setLabelId(systemCustom.getId());
            systemVo.setLabelName(systemCustom.getNameZh());
            systemVo.setLabelType(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
            relBatchSystemVoList.add(systemVo);
        }
        relBatchSystemVoPage.setRecords(relBatchSystemVoList);
        relBatchSystemVoPage.setTotal(systemCustomPage.getTotal());
        return relBatchSystemVoPage;
    }

    public List<LabelSystemData> queryAthenaAppList(List<Long> systemIds, String appCode) {
        return this.labelSystemDataMapper.queryAthenaAppList(systemIds, appCode);
    }

    public ResponseEntity<?> updateState(LabelSystemCustomSaveReq labelSystemCustomSaveReq) {
        Long id = labelSystemCustomSaveReq.getId();
        Integer validStatus = labelSystemCustomSaveReq.getValidStatus();
        LabelSystemCustom labelSystemCustom = (LabelSystemCustom)this.labelSystemCustomMapper.selectById((Serializable)id);
        if (Objects.equals(labelSystemCustom.getTenantId(), "SYSTEM_TENANT")) {
            String error = this.messageUtils.getMessage("error.message.system.lable.custom.not.modify");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
        }
        labelSystemCustom.setValidStatus(validStatus);
        this.labelSystemCustomMapper.updateById((Object)labelSystemCustom);
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> query(Integer clientType, Integer isLayout) {
        List<Object> LabelSystemCustomQuerySortVO = new ArrayList();
        List<Object> LabelSystemPreQueryVOList = new ArrayList();
        LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
        queryPreWrapper.eq(LabelSystemCustom::getClientType, (Object)clientType);
        List labelSystemCustomList = this.labelSystemCustomMapper.selectList((Wrapper)queryPreWrapper);
        String tenantVersion = this.kmService.queryTenantVersion();
        List lableSysTemCustomIds = this.getLableSysTemCustomIds(tenantVersion, clientType);
        labelSystemCustomList.removeIf(e -> e.getTenantId().equals("SYSTEM_TENANT") && !lableSysTemCustomIds.contains(e.getId()));
        if (!CollectionUtils.isEmpty((Collection)labelSystemCustomList)) {
            Gson gson = new Gson();
            List labelSystemSourceList = this.labelSystemSourceMapper.listByCondition(null, Integer.valueOf(0), labelSystemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList()));
            LinkedList dataSourceInfoList = new LinkedList();
            labelSystemSourceList.forEach(item -> {
                LabelSystemCustomQueryVO.DataSourceInfo dataSourceInfo = (LabelSystemCustomQueryVO.DataSourceInfo)gson.fromJson(JSON.toJSONString((Object)item), LabelSystemCustomQueryVO.DataSourceInfo.class);
                dataSourceInfoList.add(dataSourceInfo);
            });
            Map<Long, List<LabelSystemCustomQueryVO.DataSourceInfo>> map = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemCustomQueryVO.DataSourceInfo::getSystemId));
            List labelSystemCustomQueryVOList = labelSystemCustomList.stream().map(item -> {
                List dataList = (List)map.get(item.getId());
                LabelSystemCustomQueryVO labelSystemCustomQueryVO = (LabelSystemCustomQueryVO)this.converter.convert(item, LabelSystemCustomQueryVO.class);
                labelSystemCustomQueryVO.setComponentSource(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal());
                labelSystemCustomQueryVO.setDataSourceInfo(dataList);
                if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(item.getDataCategory())) {
                    labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl());
                    if (StringUtils.isNotBlank((CharSequence)item.getLinkParam())) {
                        List linkParamList = JSONArray.parseArray((String)item.getLinkParam(), LabelSystemLinkParamDTO.class);
                        labelSystemCustomQueryVO.setLinkParamList(linkParamList);
                        StringBuilder stringBuilder = Utils.buildWebLinkDisplayUrl((String)item.getLinkParam());
                        labelSystemCustomQueryVO.setLinkUrlFull(item.getLinkUrl() + "?" + stringBuilder);
                    }
                }
                return labelSystemCustomQueryVO;
            }).collect(Collectors.toList());
            LabelSystemCustomQuerySortVO = labelSystemCustomQueryVOList.stream().sorted(Comparator.comparing(LabelSystemCustomQueryVO::getModifyTime).reversed()).collect(Collectors.toList());
            this.buildAppInfo(LabelSystemCustomQuerySortVO);
        }
        List isvLabelSystemCustomQueryVOList = LabelSystemCustomQuerySortVO.stream().filter(e -> e.getTenantId().equals("SYSTEM_TENANT")).collect(Collectors.toList());
        List tenantLabelSystemCustomQueryVOList = LabelSystemCustomQuerySortVO.stream().filter(e -> !e.getTenantId().equals("SYSTEM_TENANT")).collect(Collectors.toList());
        if (0 == clientType) {
            this.labelSystemPreService.initPreData(Integer.valueOf(0));
            LambdaQueryWrapper queryPreWrapper1 = new LambdaQueryWrapper();
            queryPreWrapper1.eq(LabelSystemPre::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            String locale = LocaleContextHolder.getLocale().toString();
            queryPreWrapper1.eq(LabelSystemPre::getClientType, (Object)clientType);
            List labelSystemPreList = (List)InterceptorIgnoreUtil.handler(() -> this.labelSystemPreMapper.selectList((Wrapper)queryPreWrapper1));
            if (CollectionUtils.isNotEmpty((Collection)labelSystemPreList)) {
                Gson gson = new Gson();
                List labelSystemSourceList = this.labelSystemSourceMapper.listByCondition(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), Integer.valueOf(1), labelSystemPreList.stream().map(LabelSystemPre::getId).collect(Collectors.toList()));
                LinkedList dataSourceInfoList = new LinkedList();
                labelSystemSourceList.forEach(item -> {
                    LabelSystemPreQueryVO.DataSourceInfo dataSourceInfo = (LabelSystemPreQueryVO.DataSourceInfo)gson.fromJson(JSON.toJSONString((Object)item), LabelSystemPreQueryVO.DataSourceInfo.class);
                    dataSourceInfoList.add(dataSourceInfo);
                });
                Map<Long, List<LabelSystemPreQueryVO.DataSourceInfo>> map = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemPreQueryVO.DataSourceInfo::getSystemId));
                LabelSystemPreQueryVOList = labelSystemPreList.stream().map(item -> {
                    LabelSystemPreQueryVO labelSystemPreQueryVO = (LabelSystemPreQueryVO)this.converter.convert(item, LabelSystemPreQueryVO.class);
                    List dataList = (List)map.get(item.getId());
                    if ("zh_TW".equals(locale) && StringUtils.isNotEmpty((CharSequence)item.getNameTw())) {
                        labelSystemPreQueryVO.setName(item.getNameTw());
                    }
                    if (Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal().equals(item.getDataCategory())) {
                        labelSystemPreQueryVO.setModifyUserId("");
                        labelSystemPreQueryVO.setModifyTime("");
                    }
                    labelSystemPreQueryVO.setComponentSource(Integer.valueOf(1));
                    labelSystemPreQueryVO.setDataSourceInfo(dataList);
                    return labelSystemPreQueryVO;
                }).collect(Collectors.toList());
                if (Constants.IS_LAYOUT.equals(isLayout)) {
                    LabelSystemPreQueryVOList = this.filterPortalLayoutPre(LabelSystemPreQueryVOList);
                }
            }
        } else {
            List labelSystemPreList = this.labelSystemPreService.initMobileLabelSystemPre();
            for (LabelSystemPre labelSystemPre : labelSystemPreList) {
                String name = this.translateService.translateTextCache(labelSystemPre.getName(), "");
                labelSystemPre.setName(name);
                labelSystemPre.setModifyUserId("");
                labelSystemPre.setModifyUserName("");
            }
            LabelSystemPreQueryVOList = labelSystemPreList.stream().map(item -> {
                LabelSystemPreQueryVO labelSystemPreQueryVO = (LabelSystemPreQueryVO)this.converter.convert(item, LabelSystemPreQueryVO.class);
                return labelSystemPreQueryVO;
            }).collect(Collectors.toList());
        }
        HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
        data.put("isvLabelSystemCustomQueryVOList", isvLabelSystemCustomQueryVOList);
        data.put("tenantLabelSystemCustomQueryVOList", tenantLabelSystemCustomQueryVOList);
        data.put("labelSystemPreQueryVOList", LabelSystemPreQueryVOList);
        return ResponseEntityWrapper.wrapperOk(data);
    }
}

