/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.VirtualApplicationEnum;
import com.digiwin.athena.semc.dto.erpsso.ErpSsoSpecialDTO;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.dto.mobile.CustomApplicationsListPageReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemCountDataDTO;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.LabelSystemLinkParamDTO;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemDataImport;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataImportMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationInstanceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.mapper.sso.ErpSsoInfoMapper;
import com.digiwin.athena.semc.mapper.sso.ThirdSsoInfoMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportTreeVO;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.service.applink.AppLinkService;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import com.digiwin.athena.semc.service.bench.ThirdJobConfigService;
import com.digiwin.athena.semc.service.mobile.MobileDatasourceInfoService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.impl.SystemDataWriteHandler;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.FormatUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemDataAppVo;
import com.digiwin.athena.semc.vo.portal.SystemDataExportVo;
import com.digiwin.athena.semc.vo.portal.SystemDataImportVo;
import com.digiwin.athena.semc.vo.portal.SystemDataJobExportVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.google.common.collect.Lists;
import io.github.linpeilie.Converter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LabelSystemDataServiceImpl
extends ServiceImpl<LabelSystemDataMapper, LabelSystemData>
implements LabelSystemDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemDataServiceImpl.class);
    @Autowired
    LabelSystemDataMapper labelSystemDataMapper;
    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Autowired
    ThirdSsoInfoMapper thirdSsoInfoMapper;
    @Autowired
    ErpSsoInfoMapper erpSsoInfoMapper;
    @Autowired
    PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Autowired
    PreinstalledApplicationInstanceMapper preinstalledApplicationInstanceMapper;
    @Resource
    private IamService iamService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private KmService kmService;
    @Resource
    private SyncJobInfoService syncJobInfoService;
    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Autowired
    ThirdJobConfigService thirdJobConfigService;
    @Autowired
    MdcService mdcService;
    @Autowired
    private AppLinkService appLinkService;
    @Resource
    private IImportRecordService importRecordService;
    @Autowired
    LabelSystemDataImportMapper labelSystemDataImportMapper;
    @Resource
    private EnvProperties envProperties;
    @Autowired
    TodoListMapper todoListMapper;
    @Resource
    EocService eocService;
    @Resource
    private MobileDatasourceInfoService mobileDatasourceInfoService;
    @Resource
    private Converter converter;

    public PageInfoResp<LabelSystemData> queryDataList(QueryLabelSystemReq req) {
        PageInfoResp pageInfoResp = new PageInfoResp();
        Integer startNum = (req.getPageNum() - 1) * req.getPageSize();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List systemDataList = this.labelSystemDataMapper.selectByPage(req.getAppCodeList(), req, startNum, req.getPageSize(), tenantId);
        if (CollectionUtils.isEmpty((Collection)systemDataList)) {
            return pageInfoResp;
        }
        LabelSystemDataAppVo systemDataAppVo = this.getSsoAppMap(systemDataList);
        Map erpInfoMap = systemDataAppVo.getErpInfoMap();
        Map thirdSsoInfoMap = systemDataAppVo.getThirdSsoInfoMap();
        Map athenaInfoMap = systemDataAppVo.getAthenaInfoMap();
        List appJobDTOList = new ArrayList();
        List systemDataKMList = systemDataList.stream().filter(x -> Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(x.getDataCategory())).filter(x -> x.getDataType().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(systemDataKMList)) {
            appJobDTOList = this.kmService.queryAppJobList();
        }
        List systemDataAppList = systemDataList.stream().filter(x -> VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(x.getAppCode())).filter(x -> x.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())).collect(Collectors.toList());
        Map<Object, Object> datasourceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(systemDataAppList)) {
            CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
            customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
            List datasourceInfoList = this.mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
            datasourceMap = datasourceInfoList.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, y -> y, (a, b) -> a));
        }
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        Map preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        for (LabelSystemData systemData : systemDataList) {
            if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
                String name = VirtualApplicationEnum.parseNameById((String)systemData.getAppCode());
                systemData.setAppName(name);
            } else {
                String appName = this.addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, systemData, Boolean.valueOf(false), preinstalledApplicationMap);
                systemData.setAppName(appName);
            }
            if (StringUtils.isNotEmpty((CharSequence)systemData.getWorkCode())) {
                systemData.setWorkName(this.getWorkName(systemData, appJobDTOList, datasourceMap));
            }
            if (Constants.DataCategoryEnum.CATEGORY_COUNT.getVal().equals(systemData.getDataCategory()) && StringUtils.isNotBlank((CharSequence)systemData.getCountContentCode())) {
                List countDataDTOList = JSONArray.parseArray((String)systemData.getCountContentCode(), LabelSystemCountDataDTO.class);
                systemData.setCountContentCode(null);
                systemData.setCountContentList(countDataDTOList);
            }
            if (StringUtils.isNotBlank((CharSequence)systemData.getJobLinkParam())) {
                List linkParamList = JSONArray.parseArray((String)systemData.getJobLinkParam(), LabelSystemLinkParamDTO.class);
                systemData.setLinkParamList(linkParamList);
            }
            if (!StringUtils.isNotBlank((CharSequence)systemData.getFineReportParam())) continue;
            FineReportTreeVO fineReportTreeVO = (FineReportTreeVO)JSON.parseObject((String)systemData.getFineReportParam(), FineReportTreeVO.class);
            systemData.setFineReportInfo(fineReportTreeVO);
        }
        int totalCount = this.labelSystemDataMapper.selectCountBy(req.getAppCodeList(), req, tenantId);
        int totalPages = totalCount % req.getPageSize() == 0 ? totalCount / req.getPageSize() : totalCount / req.getPageSize() + 1;
        pageInfoResp.setTotalPages(totalPages);
        pageInfoResp.setPageNo(req.getPageNum().intValue());
        pageInfoResp.setPageSize(req.getPageSize().intValue());
        pageInfoResp.setTotalRecords(totalCount);
        pageInfoResp.setList(systemDataList);
        return pageInfoResp;
    }

    public String getKmJobName(String appCode, String workCode, List<AppJobDTO> appJobDTOList) {
        if (CollectionUtils.isEmpty(appJobDTOList)) {
            return "";
        }
        AppJobDTO appJobDTO = appJobDTOList.stream().filter(x -> appCode.equals(x.getAppCode())).findFirst().orElse(null);
        if (appJobDTO == null) {
            return "";
        }
        AppJobDTO.Job job = appJobDTO.getData().stream().filter(x -> workCode.equals(x.getCode())).findFirst().orElse(null);
        if (job == null) {
            return "";
        }
        return job.getName();
    }

    public String getWorkName(LabelSystemData systemData, List<AppJobDTO> appJobDTOList, Map<Long, MobileDatasourceInfo> datasourceMap) {
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            return this.getKmJobName(systemData.getAppCode(), systemData.getWorkCode(), appJobDTOList);
        }
        if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType()) && VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(systemData.getAppCode())) {
            MobileDatasourceInfo datasourceInfo = datasourceMap.get(Long.parseLong(systemData.getWorkCode()));
            String jobName = datasourceInfo == null ? "" : datasourceInfo.getName();
            return jobName;
        }
        List syncJobInfoList = this.syncJobInfoMapper.selectList((Wrapper)this.getJobCondition(systemData.getAppId(), systemData.getWorkCode()));
        if (CollectionUtils.isNotEmpty((Collection)syncJobInfoList)) {
            return ((SyncJobInfo)syncJobInfoList.get(0)).getJobName();
        }
        return "";
    }

    public QueryWrapper getJobCondition(String appId, String jobCode) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)jobCode)) {
            condition.eq((Object)"job_code", (Object)jobCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            condition.eq((Object)"app_id", (Object)appId);
        }
        return condition;
    }

    public String addAppIDName(Map<Long, ErpSsoInfo> erpInfoMap, Map<Long, ThirdSsoInfo> thirdSsoInfoMap, Map<String, TenantAppDTO> athenaInfoMap, LabelSystemData systemData, Boolean type, Map<Long, PreinstalledApplication> preinstalledApplicationMap) {
        PreinstalledApplication preinstalledApplication;
        ThirdSsoInfo thirdSsoInfo;
        ErpSsoInfo erpSsoInfo;
        String appName = "";
        String appCode = "";
        String appId = "";
        String systemType = "";
        String appToken = "";
        String callBackUrl = "";
        int isNeedSsoUrl = 0;
        int isFixedRefresh = 0;
        if (StringUtils.isEmpty((CharSequence)systemData.getAppCode())) {
            return appName;
        }
        if (null == systemData.getDataType()) {
            return appName;
        }
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemData.getDataType()) && null != (erpSsoInfo = erpInfoMap.get(Long.parseLong(systemData.getAppCode())))) {
            appName = erpSsoInfo == null ? "" : erpSsoInfo.getName();
            appCode = erpSsoInfo == null ? "" : erpSsoInfo.getCode();
            appId = erpSsoInfo == null ? "" : erpSsoInfo.getAppId();
            systemType = "wt";
            appToken = erpSsoInfo.getAppToken();
            systemData.setProtocolType(erpSsoInfo.getProtocolType());
            callBackUrl = erpSsoInfo.getCallBackUrl();
        }
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemData.getDataType()) && (thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(systemData.getAppCode()))) != null) {
            appName = thirdSsoInfo.getAppName();
            appCode = thirdSsoInfo.getAppCode();
            appId = thirdSsoInfo.getAppId();
            systemType = "mt";
            appToken = thirdSsoInfo.getAppToken();
            systemData.setProtocolType(thirdSsoInfo.getProtocolType());
            callBackUrl = thirdSsoInfo.getCallBackUrl();
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemData.getDataType()) && null != (preinstalledApplication = preinstalledApplicationMap.get(Long.parseLong(systemData.getAppCode())))) {
            appName = preinstalledApplication.getApplicationName();
            appCode = preinstalledApplication.getApplicationCode();
            appId = preinstalledApplication.getAppId();
            systemType = this.getPreSystem(preinstalledApplication);
            appToken = preinstalledApplication.getAppToken();
            systemData.setProtocolType(preinstalledApplication.getProtocolType());
            com.alibaba.fastjson.JSONObject jsonObject = Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)preinstalledApplication.getApplicationConfig())).orElse(new com.alibaba.fastjson.JSONObject());
            callBackUrl = String.format("http://www.%s.com", jsonObject.getString("applicationCode"));
            if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalledApplication.getApplicationCode())) {
                isNeedSsoUrl = 1;
                isFixedRefresh = 1;
                PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(preinstalledApplication.getId(), "", "");
                if (null != applicationInstance && null != applicationInstance.getApplicationExtConfig()) {
                    JSONObject instanceObject = applicationInstance.getApplicationExtConfig();
                    callBackUrl = instanceObject.getString("callBackUrl");
                    appId = instanceObject.getString("appId");
                }
            }
            if ("06".equals(preinstalledApplication.getProductCode()) || "100".equals(preinstalledApplication.getProductCode())) {
                isNeedSsoUrl = 1;
            }
        }
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType())) {
            TenantAppDTO appDTO = athenaInfoMap.get(systemData.getAppCode());
            appName = appDTO == null ? "" : appDTO.getName();
            appCode = systemData.getAppCode();
        }
        if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
            appCode = VirtualApplicationEnum.parseCodeById((String)systemData.getAppCode());
            appName = VirtualApplicationEnum.parseNameById((String)systemData.getAppCode());
        }
        systemData.setAppId(appId);
        if (type.booleanValue()) {
            systemData.setAppCode(appCode);
            systemData.setSystemType(systemType);
            systemData.setAppToken(appToken);
            systemData.setCallBackUrl(callBackUrl);
            systemData.setIsNeedSsoUrl(isNeedSsoUrl);
            systemData.setIsFixedRefresh(isFixedRefresh);
        }
        systemData.setAppName(appName);
        return appName;
    }

    public static boolean canConvertToLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getPreSystem(PreinstalledApplication preinstalledApplication) {
        String systemType = "";
        if (null == preinstalledApplication.getSystemType()) {
            return systemType;
        }
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue()))) {
            systemType = "mt";
        }
        if (preinstalledApplication.getSystemType().equals(Integer.parseInt(PreinstalledApplicationTypeEnum.CS_APPLICATION.getValue()))) {
            systemType = "wt";
        }
        return systemType;
    }

    public Map<String, TenantAppDTO> getAthenaInfoMap(List<LabelSystemData> athenaList) {
        Map<String, TenantAppDTO> athenaInfoMap = new HashMap<String, TenantAppDTO>();
        if (CollectionUtils.isEmpty(athenaList)) {
            return athenaInfoMap;
        }
        List allTenantApps = this.iamService.queryTenantApps();
        athenaInfoMap = allTenantApps.stream().collect(Collectors.toMap(value -> value.getId(), value -> value, (key1, key2) -> key1));
        return athenaInfoMap;
    }

    public Map<Long, PreinstalledApplication> getPreInfoMap() {
        List preinstalledAppList = this.preinstalledApplicationMapper.selectList((Wrapper)new QueryWrapper());
        Map<Long, PreinstalledApplication> preInfoMap = preinstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        return preInfoMap;
    }

    public Map<Long, ErpSsoInfo> getErpInfoMap(List<LabelSystemData> csList, LabelSystemDataAppVo systemDataAppVo) {
        Map<Long, Object> erpInfoMap = new HashMap<Long, ErpSsoInfo>();
        if (CollectionUtils.isEmpty(csList)) {
            return erpInfoMap;
        }
        List thirdFolderIdList = csList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        systemDataAppVo.setErpSystemId(idList);
        List erpInfoList = this.erpSsoInfoMapper.querySsoListByScope(querySsoListReq);
        erpInfoMap = erpInfoList.stream().collect(Collectors.toMap(ErpSsoInfo::getId, Function.identity(), (a, b) -> a));
        return erpInfoMap;
    }

    public Map<Long, ThirdSsoInfo> getSsoInfoMap(List<LabelSystemData> bsList, LabelSystemDataAppVo systemDataAppVo) {
        Map<Long, Object> thirdSsoInfoMap = new HashMap<Long, ThirdSsoInfo>();
        if (CollectionUtils.isEmpty(bsList)) {
            return thirdSsoInfoMap;
        }
        List thirdFolderIdList = bsList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
        QuerySsoListReq querySsoListReq = new QuerySsoListReq();
        List idList = thirdFolderIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        querySsoListReq.setIdList(idList);
        systemDataAppVo.setBsSystemId(idList);
        List thirdSsoInfoList = this.thirdSsoInfoMapper.queryThirdListByScope(querySsoListReq);
        thirdSsoInfoMap = thirdSsoInfoList.stream().collect(Collectors.toMap(ThirdSsoInfo::getId, Function.identity(), (a, b) -> a));
        return thirdSsoInfoMap;
    }

    @Transactional
    public ResponseEntity<?> updateValidStatus(QueryLabelSystemReq req) {
        ResponseEntity checkResp;
        LabelSystemData systemData = (LabelSystemData)this.labelSystemDataMapper.selectById((Serializable)req.getId());
        if (null == systemData) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_FAILED, (String)"the data source does not exist");
        }
        systemData.setId(req.getId());
        systemData.setValidStatus(req.getValidStatus());
        systemData.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        if (Constants.VALID_STATUS_ENABLE.equals(req.getValidStatus()) && null != (checkResp = this.checkSystemData(systemData))) {
            return checkResp;
        }
        if (Constants.VALID_STATUS_UNUSABLE.equals(req.getValidStatus())) {
            ArrayList<Long> dataIds = new ArrayList<Long>();
            dataIds.add(req.getId());
            List systemSourceList = this.labelSystemSourceMapper.selByDataIds(dataIds, null);
            if (CollectionUtils.isNotEmpty((Collection)systemSourceList)) {
                String error = this.messageUtils.getMessage("error.message.system.data.stop");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
        }
        this.labelSystemDataMapper.updateById((Object)systemData);
        return ResponseEntityWrapper.wrapperOk();
    }

    @Transactional
    public ResponseEntity<?> delData(QueryLabelSystemReq req) {
        List valIdDataList = new ArrayList();
        req.setValidStatus(Constants.VALID_STATUS_ENABLE);
        req.setPageNum(Constants.pageNum);
        req.setPageSize(Constants.pageSize);
        Page systemDataListPage = this.selectByParam(req);
        if (null != systemDataListPage) {
            valIdDataList = systemDataListPage.getRecords();
        }
        if (CollectionUtils.isNotEmpty(valIdDataList) && req.getIds().size() == 1) {
            String error = this.messageUtils.getMessage("error.message.system.data.delete");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        if (CollectionUtils.isNotEmpty(valIdDataList)) {
            String error = this.messageUtils.getMessage("error.message.system.data.delete.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
        }
        this.labelSystemDataMapper.deleteBatchIds((Collection)req.getIds());
        this.labelSystemSourceMapper.delByDataIds(req.getIds());
        return ResponseEntityWrapper.wrapperOk();
    }

    @Transactional
    public ResponseEntity<?> saveData(LabelSystemData req) {
        ResponseEntity checkResp = this.checkSystemData(req);
        if (null != checkResp) {
            return checkResp;
        }
        req.setName(req.getName().trim());
        if (CollectionUtils.isNotEmpty((Collection)req.getLinkParamList())) {
            String linkParam = JSON.toJSONString((Object)req.getLinkParamList());
            req.setJobLinkParam(linkParam);
        } else {
            req.setJobLinkParam("");
        }
        if (ObjectUtils.isNotEmpty((Object)req.getFineReportInfo())) {
            String fineReportParam = JSON.toJSONString((Object)req.getFineReportInfo());
            req.setFineReportParam(fineReportParam);
        } else {
            req.setFineReportParam("");
        }
        int isExistData = this.labelSystemDataMapper.countByParam(req.getName(), req.getId(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        if (isExistData > 0) {
            String error = this.messageUtils.getMessage("error.message.system.data.name.exist");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (null != req.getId() && null != req.getValidStatus() && Constants.VALID_STATUS_UNUSABLE.equals(req.getValidStatus())) {
            ArrayList<Long> dataIds = new ArrayList<Long>();
            dataIds.add(req.getId());
            List systemSourceList = this.labelSystemSourceMapper.selByDataIds(dataIds, null);
            if (CollectionUtils.isNotEmpty((Collection)systemSourceList)) {
                String error = this.messageUtils.getMessage("error.message.system.data.stop");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
        }
        req.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
        if (CollectionUtils.isNotEmpty((Collection)req.getCountContentList())) {
            String contentInfo = JSON.toJSONString((Object)req.getCountContentList());
            req.setCountContentCode(contentInfo);
        }
        if (req.getId() == null) {
            req.setCreateUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
            this.labelSystemDataMapper.insert((Object)req);
        } else {
            String error;
            LabelSystemData systemData = (LabelSystemData)this.labelSystemDataMapper.selectById((Serializable)req.getId());
            if (ObjectUtils.isEmpty((Object)systemData)) {
                error = this.messageUtils.getMessage("error.message.system.data.not.exist");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
            if (!systemData.getAppCode().equals(req.getAppCode()) || !systemData.getDataCategory().equals(req.getDataCategory())) {
                error = this.messageUtils.getMessage("error.message.system.data.not.modify");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
            }
            this.labelSystemDataMapper.updateById((Object)req);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public List<LabelSystemData> queryByIds(List<Long> ids) {
        return this.labelSystemDataMapper.selectBatchIds(ids);
    }

    public List<String> getDataNameList(Integer dataType, String appCode) {
        return this.labelSystemDataMapper.getDataNameList(dataType, appCode);
    }

    public List<LabelSystemData> queryDataInfoBy(List<Long> ids, Boolean isCount) {
        List<Object> systemDataList = new ArrayList<LabelSystemData>();
        if (CollectionUtils.isEmpty(ids)) {
            return systemDataList;
        }
        systemDataList = this.labelSystemDataMapper.selectBatchIds(ids);
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        Map preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        List appLinkListDTO = this.appLinkService.queryAllAuthorizedList(String.valueOf(user.getSid()));
        for (AppLinkDTO dto : appLinkListDTO) {
            if (!LabelSystemDataServiceImpl.canConvertToLong((String)dto.getPrimaryId()) || preinstalledApplicationMap.get(Long.parseLong(dto.getPrimaryId())) == null) continue;
            dto.setType("3");
        }
        systemDataList = systemDataList.stream().filter(x -> appLinkListDTO.stream().map(y -> y.getPrimaryId() + "-" + y.getType()).collect(Collectors.toList()).contains(x.getAppCode() + "-" + x.getDataType())).collect(Collectors.toList());
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        List csList = systemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map erpInfoMap = this.getErpInfoMap(csList, systemDataAppVo);
        List bsList = systemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.getSsoInfoMap(bsList, systemDataAppVo);
        ArrayList<String> appIdList = new ArrayList<String>();
        ArrayList<String> userIdList = new ArrayList<String>();
        for (LabelSystemData labelSystemData : systemDataList) {
            HashMap hashMap = new HashMap();
            String appName = this.addAppIDName(erpInfoMap, thirdSsoInfoMap, hashMap, labelSystemData, Boolean.valueOf(true), preinstalledApplicationMap);
            labelSystemData.setAppName(appName);
            String verifyUserId = "";
            if (isCount.booleanValue() && StringUtils.isNotEmpty((CharSequence)(verifyUserId = MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(labelSystemData.getAppCode()) ? this.eocService.getEmpJobNum() : this.iamService.queryMappingEmpId(labelSystemData.getAppCode()))) && !userIdList.contains(verifyUserId)) {
                userIdList.add(verifyUserId);
            }
            if (!StringUtils.isNotEmpty((CharSequence)verifyUserId) || !StringUtils.isNotEmpty((CharSequence)labelSystemData.getAppId()) || appIdList.contains(labelSystemData.getAppId())) continue;
            appIdList.add(labelSystemData.getAppId());
        }
        if (isCount.booleanValue()) {
            Map<Object, Object> todoNumMap = new HashMap();
            if (CollectionUtils.isNotEmpty(userIdList) && CollectionUtils.isNotEmpty(appIdList)) {
                List list = this.todoListMapper.queryToDoNum(appIdList, userIdList);
                todoNumMap = list.stream().collect(Collectors.toMap(TodoList::getAppId, TodoList::getToDoNum, (a, b) -> a));
            }
            for (LabelSystemData labelSystemData : systemDataList) {
                if (!StringUtils.isNotEmpty((CharSequence)labelSystemData.getAppId())) continue;
                Integer todoNum = (Integer)todoNumMap.get(labelSystemData.getAppId());
                labelSystemData.setToDoNum(Integer.valueOf(todoNum == null ? 0 : todoNum));
            }
        }
        return systemDataList;
    }

    public LabelSystemDataDto getSystemDataSso(Long id) {
        AuthoredUser user;
        List preInstalledAppList;
        Map preinstalledApplicationMap;
        PreinstalledApplication preinstalled;
        ThirdSsoInfo thirdSsoInfo;
        ErpSsoInfo erpSsoInfo;
        LabelSystemDataDto labelSystemDataDto = new LabelSystemDataDto();
        LabelSystemData labelSystemData = (LabelSystemData)this.labelSystemDataMapper.selectById((Serializable)id);
        if (null == labelSystemData) {
            return null;
        }
        this.converter.convert((Object)labelSystemData, (Object)labelSystemDataDto);
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemData.getDataType()) && null != (erpSsoInfo = (ErpSsoInfo)this.erpSsoInfoMapper.selectById((Serializable)((Object)labelSystemData.getAppCode())))) {
            labelSystemDataDto.setAppId(erpSsoInfo.getAppId());
            labelSystemDataDto.setAppCode(erpSsoInfo.getCode());
            labelSystemDataDto.setAppName(erpSsoInfo.getName());
            labelSystemDataDto.setAppToken(erpSsoInfo.getAppToken());
            labelSystemDataDto.setUserBindFlag(erpSsoInfo.getUserBindFlag());
            labelSystemDataDto.setProtocolType(erpSsoInfo.getProtocolType());
            labelSystemDataDto.setCasServerUrl(erpSsoInfo.getCasServerUrl());
        }
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemData.getDataType()) && null != (thirdSsoInfo = (ThirdSsoInfo)this.thirdSsoInfoMapper.selectById((Serializable)((Object)labelSystemData.getAppCode())))) {
            labelSystemDataDto.setAppId(thirdSsoInfo.getAppId());
            labelSystemDataDto.setAppCode(thirdSsoInfo.getAppCode());
            labelSystemDataDto.setAppName(thirdSsoInfo.getAppName());
            labelSystemDataDto.setAppToken(thirdSsoInfo.getAppToken());
            labelSystemDataDto.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
            labelSystemDataDto.setProtocolType(thirdSsoInfo.getProtocolType());
            labelSystemDataDto.setCasServerUrl(thirdSsoInfo.getCasServerUrl());
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(labelSystemData.getDataType()) && null != (preinstalled = (PreinstalledApplication)(preinstalledApplicationMap = (preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user = AppAuthContextHolder.getContext().getAuthoredUser())).stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a))).get(Long.parseLong(labelSystemData.getAppCode())))) {
            labelSystemDataDto.setAppId(preinstalled.getAppId());
            labelSystemDataDto.setAppCode(preinstalled.getApplicationCode());
            labelSystemDataDto.setAppName(preinstalled.getApplicationName());
            labelSystemDataDto.setAppSecret(preinstalled.getAppSecret());
            labelSystemDataDto.setAppToken(preinstalled.getAppToken());
            labelSystemDataDto.setUserBindFlag(preinstalled.getUserBindFlag());
            if (StringUtils.isNotEmpty((CharSequence)preinstalled.getApplicationConfig())) {
                ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)preinstalled.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
                labelSystemDataDto.setCallBackUrl(erpSsoSpecialDTO == null ? "" : erpSsoSpecialDTO.getCallBackUrl());
            }
            if (MaycurCodeEnum.MAYCUR_CLOUD.getType().equals(preinstalled.getApplicationCode()) || MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preinstalled.getApplicationCode())) {
                PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(preinstalled.getId(), "", "");
                JSONObject jsonObject = applicationInstance.getApplicationExtConfig();
                String callBackUrl = jsonObject.getString("callBackUrl");
                String appId = jsonObject.getString("appId");
                String appSecret = jsonObject.getString("appSecret");
                labelSystemDataDto.setAppId(appId);
                labelSystemDataDto.setAppSecret(appSecret);
                labelSystemDataDto.setCallBackUrl(callBackUrl);
            }
            labelSystemDataDto.setProtocolType(preinstalled.getProtocolType());
            labelSystemDataDto.setCasServerUrl(preinstalled.getCasServerUrl());
        }
        return labelSystemDataDto;
    }

    public List<AppJobDTO.Job> getAppJobList(String appCode, Integer dataSource, Boolean isToGet, Integer type) {
        List<Object> jobListDTOList = new ArrayList<AppJobDTO.Job>();
        if (dataSource.equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
            List appJobListDTOList = this.kmService.queryAppJobList();
            if (CollectionUtils.isEmpty((Collection)appJobListDTOList)) {
                return jobListDTOList;
            }
            Map appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
            if (null != appJobListMap && null != appJobListMap.get(appCode)) {
                jobListDTOList = ((AppJobDTO)appJobListMap.get(appCode)).getData();
            }
        } else if (dataSource.equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && appCode.equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId())) {
            CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
            customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
            List datasourceInfoList = this.mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
            jobListDTOList = this.packageAppJob(datasourceInfoList);
        } else {
            Map ssoInfoMap = this.getSSoInfo(Long.valueOf(Long.parseLong(appCode)), dataSource);
            if (null != ssoInfoMap && StringUtils.isNotEmpty((CharSequence)((CharSequence)ssoInfoMap.get("appId")))) {
                List<Object> jobInfoList = new ArrayList();
                String appIdCode = (String)ssoInfoMap.get("appIdCode");
                ArrayList accountIdList = Lists.newArrayList();
                if (isToGet.booleanValue()) {
                    jobInfoList = this.thirdJobConfigService.getThirdJobList(appCode, dataSource, (String)ssoInfoMap.get("appToken"), (String)ssoInfoMap.get("appId"), appIdCode);
                    if (CollectionUtils.isNotEmpty((Collection)accountIdList)) {
                        jobInfoList = jobInfoList.stream().filter(x -> accountIdList.contains(x.getAccountId())).collect(Collectors.toList());
                    }
                }
                if (CollectionUtils.isEmpty(jobInfoList)) {
                    jobInfoList = this.syncJobInfoService.selectJobList((String)ssoInfoMap.get("appId"), (List)accountIdList);
                }
                if (null != type && Constants.JobWorkTypeEnum.MOBILE_JOB.getValue().equals(type)) {
                    jobInfoList = jobInfoList.stream().filter(item -> ObjectUtils.isNotEmpty((Object)item.getMobileJobUrl())).collect(Collectors.toList());
                }
                jobListDTOList = this.praseAppJob(jobInfoList, isToGet);
            }
        }
        return jobListDTOList;
    }

    public List<AppJobDTO.Job> packageAppJob(List<MobileDatasourceInfo> datasourceInfoList) {
        ArrayList<AppJobDTO.Job> appjobList = new ArrayList<AppJobDTO.Job>();
        if (CollectionUtils.isEmpty(datasourceInfoList)) {
            return appjobList;
        }
        for (MobileDatasourceInfo jobInfo : datasourceInfoList) {
            AppJobDTO.Job job = new AppJobDTO.Job();
            job.setName(jobInfo.getName());
            job.setCode(jobInfo.getId() + "");
            appjobList.add(job);
        }
        return appjobList;
    }

    public Map<String, String> getSSoInfo(Long id, Integer dataSource) {
        AuthoredUser user;
        List preInstalledAppList;
        Map preinstalledApplicationMap;
        PreinstalledApplication preinstalled;
        ThirdSsoInfo thirdSsoInfo;
        ErpSsoInfo erpSsoInfo;
        HashMap<String, String> ssoInfoMap = new HashMap<String, String>();
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(dataSource) && null != (erpSsoInfo = (ErpSsoInfo)this.erpSsoInfoMapper.selectById((Serializable)id))) {
            ssoInfoMap.put("appId", erpSsoInfo.getAppId());
            ssoInfoMap.put("appIdCode", erpSsoInfo.getCode());
            ssoInfoMap.put("appToken", erpSsoInfo.getAppToken());
        }
        if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(dataSource) && null != (thirdSsoInfo = (ThirdSsoInfo)this.thirdSsoInfoMapper.selectById((Serializable)id))) {
            ssoInfoMap.put("appId", thirdSsoInfo.getAppId());
            ssoInfoMap.put("appIdCode", thirdSsoInfo.getAppCode());
            ssoInfoMap.put("appToken", thirdSsoInfo.getAppToken());
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(dataSource) && null != (preinstalled = (PreinstalledApplication)(preinstalledApplicationMap = (preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user = AppAuthContextHolder.getContext().getAuthoredUser())).stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a))).get(id))) {
            ssoInfoMap.put("appId", preinstalled.getAppId());
            ssoInfoMap.put("appIdCode", preinstalled.getApplicationCode());
            ssoInfoMap.put("appToken", preinstalled.getAppToken());
        }
        return ssoInfoMap;
    }

    public LabelSystemDataAppVo getSsoAppMap(List<LabelSystemData> systemDataList) {
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        List csList = systemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map erpInfoMap = this.getErpInfoMap(csList, systemDataAppVo);
        systemDataAppVo.setErpInfoMap(erpInfoMap);
        List bsList = systemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.getSsoInfoMap(bsList, systemDataAppVo);
        systemDataAppVo.setThirdSsoInfoMap(thirdSsoInfoMap);
        Map preInfoMap = this.getPreInfoMap();
        systemDataAppVo.setPreInfoMap(preInfoMap);
        List athenaList = systemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map athenaInfoMap = this.getAthenaInfoMap(athenaList);
        systemDataAppVo.setAthenaInfoMap(athenaInfoMap);
        return systemDataAppVo;
    }

    public LabelSystemDataAppVo getSsoAppMapTemp(List<LabelSystemData> systemDataList) {
        LabelSystemDataAppVo systemDataAppVo = new LabelSystemDataAppVo();
        List csList = systemDataList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map erpInfoMap = this.getErpInfoMap(csList, systemDataAppVo);
        systemDataAppVo.setErpInfoMap(erpInfoMap);
        List bsList = systemDataList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.getSsoInfoMap(bsList, systemDataAppVo);
        systemDataAppVo.setThirdSsoInfoMap(thirdSsoInfoMap);
        List preList = systemDataList.stream().filter(item -> ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map<Object, Object> preInstanceListMap = new HashMap();
        Map<Object, Object> preAppMap = new HashMap();
        if (CollectionUtils.isNotEmpty(preList)) {
            List applicationIdList = preList.stream().map(LabelSystemData::getAppCode).collect(Collectors.toList());
            List preInstanceList = this.preinstalledApplicationInstanceMapper.getPreInsBy(systemDataList.get(0).getTenantId(), applicationIdList, null);
            if (CollectionUtils.isNotEmpty((Collection)preInstanceList)) {
                preInstanceListMap = preInstanceList.stream().collect(Collectors.toMap(PreinstalledApplicationInstance::getPreinstalledApplicationId, Function.identity(), (a, b) -> a));
            }
            List preAppList = this.preinstalledApplicationMapper.selectBatchIds(applicationIdList);
            preAppMap = preAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        }
        List athenaList = systemDataList.stream().filter(item -> ApplicationTypeEnum.IAM_APPLICATION.getType().equals(item.getDataType())).collect(Collectors.toList());
        Map athenaInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(athenaList)) {
            athenaInfoMap = this.getAthenaInfoMap(athenaList);
        }
        HashMap<Long, LabelSystemDataDto> systemAppNameMap = new HashMap<Long, LabelSystemDataDto>();
        for (LabelSystemData systemData : systemDataList) {
            TenantAppDTO appDTO;
            ThirdSsoInfo thirdSsoInfo;
            ErpSsoInfo erpSsoInfo;
            LabelSystemDataDto labelSystemDataDto = new LabelSystemDataDto();
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(systemData.getDataType()) && null != (erpSsoInfo = (ErpSsoInfo)erpInfoMap.get(Long.parseLong(systemData.getAppCode())))) {
                labelSystemDataDto.setAppId(erpSsoInfo.getAppId());
                labelSystemDataDto.setAppCode(erpSsoInfo.getCode());
                labelSystemDataDto.setAppName(erpSsoInfo.getName());
                labelSystemDataDto.setAppToken(erpSsoInfo.getAppToken());
                labelSystemDataDto.setUserBindFlag(erpSsoInfo.getUserBindFlag());
                labelSystemDataDto.setProtocolType(erpSsoInfo.getProtocolType());
                labelSystemDataDto.setCasServerUrl(erpSsoInfo.getCasServerUrl());
            }
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(systemData.getDataType()) && null != (thirdSsoInfo = (ThirdSsoInfo)thirdSsoInfoMap.get(Long.parseLong(systemData.getAppCode())))) {
                labelSystemDataDto.setAppId(thirdSsoInfo.getAppId());
                labelSystemDataDto.setAppCode(thirdSsoInfo.getAppCode());
                labelSystemDataDto.setAppName(thirdSsoInfo.getAppName());
                labelSystemDataDto.setAppToken(thirdSsoInfo.getAppToken());
                labelSystemDataDto.setUserBindFlag(thirdSsoInfo.getUserBindFlag());
                labelSystemDataDto.setProtocolType(thirdSsoInfo.getProtocolType());
                labelSystemDataDto.setCasServerUrl(thirdSsoInfo.getCasServerUrl());
            }
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(systemData.getDataType())) {
                PreinstalledApplication preinstalledApplication;
                PreinstalledApplicationInstance preInstance = (PreinstalledApplicationInstance)preInstanceListMap.get(Long.parseLong(systemData.getAppCode()));
                if (null != preInstance) {
                    labelSystemDataDto.setAppId(preInstance.getAppId());
                    labelSystemDataDto.setAppSecret(preInstance.getAppSecret());
                }
                if (null != (preinstalledApplication = (PreinstalledApplication)preAppMap.get(Long.parseLong(systemData.getAppCode())))) {
                    labelSystemDataDto.setAppCode(preinstalledApplication.getApplicationCode());
                    labelSystemDataDto.setAppName(preinstalledApplication.getApplicationName());
                }
            }
            if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(systemData.getDataType()) && null != (appDTO = (TenantAppDTO)athenaInfoMap.get(systemData.getAppCode()))) {
                labelSystemDataDto.setAppCode(appDTO.getId());
                labelSystemDataDto.setAppName(appDTO.getName());
            }
            if (ApplicationTypeEnum.VIRTUAL_APPLICATION.getType().equals(systemData.getDataType())) {
                String code = VirtualApplicationEnum.parseCodeById((String)systemData.getAppCode());
                labelSystemDataDto.setAppCode(code);
                String name = VirtualApplicationEnum.parseNameById((String)systemData.getAppCode());
                labelSystemDataDto.setAppName(name);
            }
            systemAppNameMap.put(systemData.getId(), labelSystemDataDto);
        }
        systemDataAppVo.setSystemAppNameMap(systemAppNameMap);
        return systemDataAppVo;
    }

    public List<AppJobDTO.Job> praseAppJob(List<SyncJobInfo> jobInfoList, Boolean isToGet) {
        ArrayList<AppJobDTO.Job> jobListDTOList = new ArrayList<AppJobDTO.Job>();
        if (isToGet.booleanValue()) {
            Map<String, List<SyncJobInfo>> nameMap = jobInfoList.stream().collect(Collectors.groupingBy(SyncJobInfo::getJobName));
            nameMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    v.forEach(x -> {
                        if (StringUtils.isNotBlank((CharSequence)x.getAccountId())) {
                            x.setJobName(FormatUtil.format((String)"{}({})", (Object[])new Object[]{x.getJobName(), x.getAccountId()}));
                        }
                    });
                }
            });
        }
        for (SyncJobInfo jobInfo : jobInfoList) {
            AppJobDTO.Job job = new AppJobDTO.Job();
            String name = jobInfo.getJobName();
            if (isToGet.booleanValue() && StringUtils.isNotEmpty((CharSequence)jobInfo.getVersion())) {
                name = name + "-" + jobInfo.getVersion();
            }
            job.setName(name);
            job.setCode(jobInfo.getJobCode());
            job.setAccountId(jobInfo.getAccountId());
            job.setAccountName(jobInfo.getAccountName());
            jobListDTOList.add(job);
        }
        return jobListDTOList;
    }

    public ResponseEntity<?> checkSystemData(LabelSystemData labelSystemData) {
        PreinstalledApplication preinstalledApplication;
        String error = "";
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getName())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the data source name cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getName().trim())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the data source name cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getAppCode())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the source application cannot be empty");
        }
        if (null == labelSystemData.getDataCategory()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"the data source classification cannot be empty");
        }
        if (null == labelSystemData.getDataType()) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"The source application source cannot be empty");
        }
        if (StringUtils.isEmpty((CharSequence)labelSystemData.getWorkCode()) && Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(labelSystemData.getDataCategory()) && ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType())) {
            error = this.messageUtils.getMessage("error.message.system.data.job.empty");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (!ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType()) && null != labelSystemData.getDataModel() && Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemData.getDataModel())) {
            if (StringUtils.isEmpty((CharSequence)labelSystemData.getMiddleSystemName())) {
                error = this.messageUtils.getMessage("error.message.system.data.middleSystemName.empty");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            if (StringUtils.isEmpty((CharSequence)labelSystemData.getMiddleSystemUid())) {
                error = this.messageUtils.getMessage("error.message.system.data.middleSystemUid.empty");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
        }
        if (!ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType()) && null != labelSystemData.getDataModel() && Constants.DataModelEnum.MODEL_CLOUD.getVal().equals(labelSystemData.getDataModel()) && StringUtils.isEmpty((CharSequence)labelSystemData.getRestUrl())) {
            error = this.messageUtils.getMessage("error.message.system.data.restUrl.empty");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (ApplicationTypeEnum.IAM_APPLICATION.getType().equals(labelSystemData.getDataType()) && !Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(labelSystemData.getDataCategory()) && !Constants.DataCategoryEnum.CATEGORY_APP.getVal().equals(labelSystemData.getDataCategory())) {
            error = this.messageUtils.getMessage("error.message.system.data.dataType.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemData.getDataType()) && StringUtils.isNotEmpty((CharSequence)labelSystemData.getCallBackUrl()) && Utils.jsonParamValid((String)labelSystemData.getCallBackUrl())) {
            error = this.messageUtils.getMessage("error.message.system.data.callBackUrl.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(labelSystemData.getDataType()) && ObjectUtils.isNotEmpty((Object)(preinstalledApplication = (PreinstalledApplication)this.preinstalledApplicationMapper.selectById((Serializable)((Object)labelSystemData.getAppCode())))) && Constants.APP_TYPE_CS.equals(preinstalledApplication.getSystemType()) && Utils.jsonParamValid((String)labelSystemData.getCallBackUrl())) {
            error = this.messageUtils.getMessage("error.message.system.data.callBackUrl.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
        }
        if (Constants.DataCategoryEnum.CATEGORY_COUNT.getVal().equals(labelSystemData.getDataCategory()) && CollectionUtils.isNotEmpty((Collection)labelSystemData.getCountContentList())) {
            for (LabelSystemCountDataDTO labelSystemCountDataDTO : labelSystemData.getCountContentList()) {
                LabelSystemCountDataDTO.JobInfo jobInfo = labelSystemCountDataDTO.getJobInfo();
                if (ObjectUtils.isEmpty((Object)jobInfo) || !ApplicationTypeEnum.CS_APPLICATION.getType().equals(jobInfo.getDataType()) || !StringUtils.isNotEmpty((CharSequence)jobInfo.getCallBackUrl()) || !Utils.jsonParamValid((String)jobInfo.getCallBackUrl())) continue;
                error = this.messageUtils.getMessage("error.message.system.data.callBackUrl.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
        }
        return null;
    }

    public Page<LabelSystemData> selectByParam(QueryLabelSystemReq req) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        queryWrapper.orderByDesc((Object)"modify_time");
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        if (CollectionUtils.isNotEmpty((Collection)req.getDataCategoryList())) {
            queryWrapper.in((Object)"data_category", (Collection)req.getDataCategoryList());
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getAppCodeList())) {
            queryWrapper.in((Object)"app_code", (Collection)req.getAppCodeList());
        }
        if (null != req.getValidStatus()) {
            queryWrapper.eq((Object)"valid_status", (Object)req.getValidStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            queryWrapper.like((Object)"name", (Object)req.getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)req.getIds())) {
            queryWrapper.in((Object)"id", (Collection)req.getIds());
        }
        Page systemDataPage = (Page)this.labelSystemDataMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)queryWrapper);
        return systemDataPage;
    }

    public List<SystemDataImportVo> readExcel(String fileId) {
        List excelVoList;
        DMC dmcInstance = this.mdcService.buildDmc();
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)input).build();
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(SystemDataImportVo.class)).headRowNumber(Integer.valueOf(2))).registerReadListener((ReadListener)excelListener)).build()});
            excelReader.finish();
            excelVoList = this.mdcService.doReadSync(excelListener);
        }
        catch (Exception e) {
            log.error("SystemDataImport read excel occur error", (Throwable)e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Transactional
    public ImportExcelResp importReport(List<SystemDataImportVo> dataImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        List<Object> nameList = new ArrayList();
        List systemDataList = this.labelSystemDataMapper.selectList((Wrapper)new QueryWrapper());
        if (CollectionUtils.isNotEmpty((Collection)systemDataList)) {
            nameList = systemDataList.stream().map(LabelSystemData::getName).collect(Collectors.toList());
        }
        ArrayList nameIamList = new ArrayList();
        Map nameAppMap = this.queryAppList(nameIamList);
        List appJobListDTOList = this.kmService.queryAppJobList();
        ArrayList<LabelSystemData> systemDataListAdd = new ArrayList<LabelSystemData>();
        Map categoryMap = this.initCategoryMap();
        Map statusMap = this.initStatusMap();
        CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
        customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
        List datasourceInfoList = this.mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
        Map<String, MobileDatasourceInfo> datasourceMap = datasourceInfoList.stream().collect(Collectors.toMap(MobileDatasourceInfo::getName, y -> y, (a, b) -> a));
        int successNum = 0;
        int failNum = 0;
        for (SystemDataImportVo dataImportVo : dataImportVoList) {
            StringBuilder errorSb = this.validateData(dataImportVo, nameList, nameAppMap, appJobListDTOList, nameIamList, datasourceMap);
            if (StringUtils.isNotBlank((CharSequence)errorSb.toString())) {
                ++failNum;
                dataImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            dataImportVo.setFailDesc(errorSb.toString());
            nameList.add(dataImportVo.getName());
            LabelSystemData labelSystemData = this.initLabelSystemData(dataImportVo, categoryMap, statusMap, nameAppMap, appJobListDTOList, datasourceMap);
            systemDataListAdd.add(labelSystemData);
            ++successNum;
        }
        if (CollectionUtils.isNotEmpty(systemDataListAdd)) {
            this.saveBatch(systemDataListAdd);
        }
        String nowTime = DateUtils.getNowTime((String)"yyyyMMddHHmmss");
        ShareInfo shareInfo = this.importRecordService.uploadExcel(this.write(dataImportVoList, nowTime));
        this.initDataImport(shareInfo.getFileId(), Integer.valueOf(successNum), Integer.valueOf(failNum), nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        String resultCode = successNum > 0 && failNum == 0 ? "2001" : (successNum > 0 && failNum > 0 ? "2002" : (successNum == 0 && failNum > 0 ? "2003" : "2003"));
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(Integer.valueOf(failNum));
        excelResp.setSuccessCount(Integer.valueOf(successNum));
        return excelResp;
    }

    public LabelSystemDataImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        LabelSystemDataImport dataImport = new LabelSystemDataImport();
        dataImport.setFileId(fileId);
        dataImport.setSuccessCount(successCount);
        dataImport.setFailCount(failCount);
        dataImport.setCreateUserName(Utils.getUserName());
        dataImport.setCreateUserId(Utils.getUserId());
        dataImport.setCreateTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        dataImport.setModifyTime(DateUtils.getDateFormat((String)nowTime, (String)"yyyyMMddHHmmss", (String)"yyyy-MM-dd HH:mm:ss"));
        dataImport.setModifyUserId(Utils.getUserId());
        dataImport.setTenantId(Utils.getTenantId());
        this.labelSystemDataImportMapper.insert((Object)dataImport);
        return dataImport;
    }

    public File write(List<SystemDataImportVo> list, String nowTime) {
        File file = new File("\u6570\u636e\u6e90\u5bfc\u5165\u8bb0\u5f55_" + nowTime + ".xlsx");
        ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((File)file, SystemDataImportVo.class).relativeHeadRowIndex(Integer.valueOf(1))).registerWriteHandler((WriteHandler)Utils.initHorizontalCell())).registerWriteHandler((WriteHandler)new SystemDataWriteHandler())).sheet("\u6570\u636e\u6e90\u914d\u7f6e").doWrite(list);
        return file;
    }

    public LabelSystemData initLabelSystemData(SystemDataImportVo dataImportVo, Map<String, Integer> categoryMap, Map<String, Integer> statusMap, Map<String, List<AppLinkDTO>> nameAppMap, List<AppJobDTO> appJobListDTOList, Map<String, MobileDatasourceInfo> datasourceMap) {
        LabelSystemData labelSystemData = new LabelSystemData();
        labelSystemData.setName(dataImportVo.getName());
        labelSystemData.setRemark(dataImportVo.getRemark());
        labelSystemData.setDataCategory(categoryMap.get(dataImportVo.getCategory()));
        labelSystemData.setValidStatus(statusMap.get(dataImportVo.getValidStatus()));
        List<AppLinkDTO> appLinkList = nameAppMap.get(dataImportVo.getAppName());
        AppLinkDTO appLinkDTO = null;
        if (CollectionUtils.isNotEmpty(appLinkList)) {
            appLinkDTO = appLinkList.get(0);
            labelSystemData.setDataType(appLinkDTO.getDataSource());
            labelSystemData.setAppCode(appLinkDTO.getPrimaryId());
        }
        if (dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            if (dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())) {
                MobileDatasourceInfo datasourceInfo;
                List jobInfoList;
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
                    Map appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
                    AppJobDTO appJobDTO = (AppJobDTO)appJobListMap.get(appLinkDTO.getPrimaryId());
                    List jobList = appJobDTO.getData();
                    Map appCodeJobMap = jobList.stream().collect(Collectors.toMap(AppJobDTO.Job::getCode, Function.identity(), (a, b) -> a));
                    AppJobDTO.Job job = (AppJobDTO.Job)appCodeJobMap.get(dataImportVo.getJobVal());
                    if (null == job) {
                        Map appNameJobMap = jobList.stream().collect(Collectors.toMap(AppJobDTO.Job::getName, Function.identity(), (a, b) -> a));
                        job = (AppJobDTO.Job)appNameJobMap.get(dataImportVo.getJobVal());
                    }
                    String jobCode = job == null ? "" : job.getCode();
                    labelSystemData.setWorkCode(jobCode);
                    labelSystemData.setIsJob(Integer.valueOf(0));
                }
                if (null != appLinkDTO && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()) && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && CollectionUtils.isNotEmpty((Collection)(jobInfoList = this.syncJobInfoMapper.selByNameCode(appLinkDTO.getAppId(), dataImportVo.getJobVal())))) {
                    labelSystemData.setWorkCode(((SyncJobInfo)jobInfoList.get(0)).getJobCode());
                    labelSystemData.setAccountId(((SyncJobInfo)jobInfoList.get(0)).getAccountId());
                    labelSystemData.setIsJob(Integer.valueOf(0));
                }
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && appLinkDTO.getPrimaryId().equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId()) && null != (datasourceInfo = datasourceMap.get(dataImportVo.getJobVal()))) {
                    labelSystemData.setWorkCode(datasourceInfo.getId() + "");
                    labelSystemData.setIsJob(Integer.valueOf(0));
                }
            }
            if (dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal())) {
                labelSystemData.setIsJob(Integer.valueOf(1));
                labelSystemData.setCallBackUrl(dataImportVo.getJobVal());
            }
        }
        labelSystemData.setCreateUserName(Utils.getUserName());
        labelSystemData.setModifyUserName(Utils.getUserName());
        labelSystemData.setCreateUserId(Utils.getUserId());
        labelSystemData.setCreateTime(DateUtils.getNowTime((String)""));
        labelSystemData.setModifyTime(DateUtils.getNowTime((String)""));
        labelSystemData.setModifyUserId(Utils.getUserId());
        labelSystemData.setTenantId(Utils.getTenantId());
        return labelSystemData;
    }

    public Map<String, List<AppLinkDTO>> queryAppList(List<String> nameIamList) {
        HashMap<String, List<AppLinkDTO>> nameAppMap = new HashMap<String, List<AppLinkDTO>>();
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List appLinkList = this.appLinkService.queryManageList(user);
        appLinkList = this.filterRepeatApp(appLinkList, nameIamList);
        for (AppLinkDTO appLink : appLinkList) {
            String key = appLink.getName();
            ArrayList<AppLinkDTO> appList = new ArrayList<AppLinkDTO>();
            appList.add(appLink);
            if (!nameAppMap.containsKey(key)) {
                nameAppMap.put(key, new ArrayList(appList));
                continue;
            }
            ((List)nameAppMap.get(key)).addAll(appList);
        }
        ArrayList<AppLinkDTO> appLinkDTOList = new ArrayList<AppLinkDTO>();
        AppLinkDTO athenaAppLinkDTO = Utils.initAthenaApp();
        appLinkDTOList.add(athenaAppLinkDTO);
        nameAppMap.put(athenaAppLinkDTO.getName(), appLinkDTOList);
        return nameAppMap;
    }

    public List<AppLinkDTO> filterRepeatApp(List<AppLinkDTO> appLinkListDT, List<String> nameIamList) {
        ArrayList<AppLinkDTO> appLinkDTOList = new ArrayList<AppLinkDTO>();
        List matchedLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType())).collect(Collectors.toList());
        Map preListMap = matchedLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getAppId, Function.identity(), (a, b) -> a));
        List iamLinkList = appLinkListDT.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(iamLinkList)) {
            List<Object> namesIamList = iamLinkList.stream().map(AppLinkDTO::getName).collect(Collectors.toList());
            namesIamList = nameIamList;
        }
        Map iamListMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getPrimaryId, Function.identity(), (a, b) -> a));
        for (AppLinkDTO appLink : appLinkListDT) {
            AppLinkDTO iamData = (AppLinkDTO)iamListMap.get(appLink.getApplicationAppId());
            if (appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != iamData) continue;
            AppLinkDTO preData = (AppLinkDTO)preListMap.get(appLink.getPrimaryId());
            if (!appLink.getDataSource().equals(ApplicationTypeEnum.PRESET_APPLICATION.getType()) && null != preData) {
                appLink.setName(preData.getName());
            }
            appLinkDTOList.add(appLink);
        }
        return appLinkDTOList;
    }

    private StringBuilder validateData(SystemDataImportVo dataImportVo, List<String> nameList, Map<String, List<AppLinkDTO>> nameAppMap, List<AppJobDTO> appJobListDTOList, List<String> nameIamList, Map<String, MobileDatasourceInfo> datasourceMap) {
        StringBuilder errorSb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getName())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getName()) && dataImportVo.getName().length() > 500) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (nameList.contains(dataImportVo.getName())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u540d\u79f0\u201d\u91cd\u540d").append(",");
        }
        AppLinkDTO appLinkDTO = null;
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getAppName())) {
            errorSb.append("\u201c\u6e90\u5e94\u7528\u201d\u672a\u586b\u5199").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getAppName())) {
            List<AppLinkDTO> appLinkList = nameAppMap.get(dataImportVo.getAppName());
            if (CollectionUtils.isEmpty(appLinkList)) {
                errorSb.append("\u201c\u6e90\u5e94\u7528\u201d\u503c\u9519\u8bef").append(",");
            }
            if (CollectionUtils.isNotEmpty(appLinkList) && appLinkList.size() > 1) {
                errorSb.append("\u201c\u6e90\u5e94\u7528\u201d\u540d\u79f0\u91cd\u540d").append(",");
            }
            if (CollectionUtils.isEmpty(appLinkList) && !nameIamList.contains(dataImportVo.getAppName())) {
                errorSb.append("\u79df\u6237\u672a\u6388\u6743\u6b64\u6e90\u5e94\u7528\u6743\u9650").append(",");
            }
            if (CollectionUtils.isNotEmpty(appLinkList) && appLinkList.size() == 1) {
                appLinkDTO = appLinkList.get(0);
            }
        }
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getCategory())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u672a\u586b\u5199").append(",");
        }
        List categoryNameList = this.initCategoryNameList();
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getCategory()) && !categoryNameList.contains(dataImportVo.getCategory())) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getAppName()) && dataImportVo.getAppName().equals(VirtualApplicationEnum.ATHENA_APP.getName()) && StringUtils.isNotEmpty((CharSequence)dataImportVo.getCategory()) && !dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            errorSb.append("\u6e90\u5e94\u7528\u4e3a\u201c\u9f0e\u6377\u96c5\u5178\u5a1cAPP\u201d\u65f6\uff0c\u4ec5\u652f\u6301\u201c\u4f5c\u4e1a\u96c6\u6210\u201d").append(",");
        }
        if (StringUtils.isEmpty((CharSequence)dataImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u672a\u586b\u5199").append(",");
        }
        List validStatusList = this.initValidStatusList();
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getValidStatus()) && !validStatusList.contains(dataImportVo.getValidStatus())) {
            errorSb.append("\u201c\u72b6\u6001\u201d\u503c\u9519\u8bef").append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)dataImportVo.getRemark()) && dataImportVo.getRemark().length() > 100) {
            errorSb.append("\u201c\u6570\u636e\u6e90\u5907\u6ce8\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getCategory()) && !dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType()) && StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c" + dataImportVo.getCategory() + "\u201d\uff0c\u201c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u201d\u3001\u201c\u4f5c\u4e1a\u503c\u201d\u4e0d\u9700\u8981\u586b\u5199").append(",");
            } else if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c" + dataImportVo.getCategory() + "\u201d\uff0c\u201c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u201d\u4e0d\u9700\u8981\u586b\u5199").append(",");
            } else if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c" + dataImportVo.getCategory() + "\u201d\uff0c\u201c\u4f5c\u4e1a\u503c\u201d\u4e0d\u9700\u8981\u586b\u5199").append(",");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getCategory()) && dataImportVo.getCategory().equals(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal())) {
            if (StringUtils.isEmpty((CharSequence)dataImportVo.getJobVal()) && StringUtils.isEmpty((CharSequence)dataImportVo.getJobType())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c\u4f5c\u4e1a\u96c6\u6210\u201d\uff0c\u201c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u201d\u3001\u201c\u4f5c\u4e1a\u503c\u201d\u90fd\u672a\u586b\u5199").append(",");
                return errorSb;
            }
            if (StringUtils.isEmpty((CharSequence)dataImportVo.getJobType())) {
                errorSb.append("\u201c\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c\u4f5c\u4e1a\u96c6\u6210\u201d\uff0c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u672a\u586b\u5199").append(",");
            }
            List jobTypeList = this.initJobTypeList();
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType()) && !jobTypeList.contains(dataImportVo.getJobType())) {
                errorSb.append("\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u503c\u9519\u8bef").append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getAppName()) && dataImportVo.getAppName().equals(VirtualApplicationEnum.ATHENA_APP.getName()) && StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType()) && !dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())) {
                errorSb.append("\u6e90\u5e94\u7528\u4e3a\u201c\u9f0e\u6377\u96c5\u5178\u5a1cAPP\u201d\u65f6\uff0c\u4f5c\u4e1a\u586b\u5199\u65b9\u5f0f\u4ec5\u652f\u6301\u201c\u4f5c\u4e1a\u540d\u79f0\u201d").append(",");
            }
            if (StringUtils.isEmpty((CharSequence)dataImportVo.getJobVal())) {
                errorSb.append("\u6570\u636e\u6e90\u5206\u7c7b\u201d\u9009\u62e9\u4e86\u201c\u4f5c\u4e1a\u96c6\u6210\u201d\uff0c\u4f5c\u4e1a\u503c\u672a\u586b\u5199").append(",");
                return errorSb;
            }
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal()) && dataImportVo.getJobVal().length() > 500) {
                errorSb.append("\u201c\u4f5c\u4e1a\u503c\u201d\u5185\u5bb9\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\u9650\u5236").append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobType()) && StringUtils.isNotEmpty((CharSequence)dataImportVo.getJobVal()) && dataImportVo.getJobType().equals(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal())) {
                MobileDatasourceInfo datasourceInfo;
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())) {
                    Map appJobListMap = appJobListDTOList.stream().collect(Collectors.toMap(AppJobDTO::getAppCode, Function.identity(), (a, b) -> a));
                    AppJobDTO appJobDTO = (AppJobDTO)appJobListMap.get(appLinkDTO.getPrimaryId());
                    if (null == appJobListMap || null == appJobDTO) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                    List jobList = appJobDTO.getData();
                    if (CollectionUtils.isEmpty((Collection)jobList)) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                    List jobCodeList = jobList.stream().map(AppJobDTO.Job::getCode).collect(Collectors.toList());
                    List jobNameList = jobList.stream().map(AppJobDTO.Job::getName).collect(Collectors.toList());
                    if (!jobNameList.contains(dataImportVo.getJobVal()) && !jobCodeList.contains(dataImportVo.getJobVal())) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                }
                if (null != appLinkDTO && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType()) && !appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())) {
                    List jobInfoList = this.syncJobInfoMapper.selByNameCode(appLinkDTO.getAppId(), dataImportVo.getJobVal());
                    if (CollectionUtils.isEmpty((Collection)jobInfoList)) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                        return errorSb;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)jobInfoList) && jobInfoList.size() > 1) {
                        errorSb.append("\u4f5c\u4e1a\u503c\u91cd\u590d").append(",");
                        return errorSb;
                    }
                }
                if (null != appLinkDTO && appLinkDTO.getDataSource().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType()) && appLinkDTO.getPrimaryId().equals(VirtualApplicationEnum.ATHENA_APP.getPrimaryId()) && null == (datasourceInfo = datasourceMap.get(dataImportVo.getJobVal()))) {
                    errorSb.append("\u4f5c\u4e1a\u503c\u9519\u8bef").append(",");
                    return errorSb;
                }
            }
        }
        return errorSb;
    }

    public Map<String, Integer> initCategoryMap() {
        HashMap<String, Integer> categoryMap = new HashMap<String, Integer>();
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryMap.put(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal(), Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        return categoryMap;
    }

    public Map<String, Integer> initStatusMap() {
        HashMap<String, Integer> statusMap = new HashMap<String, Integer>();
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal(), Constants.VALID_STATUS_ENABLE);
        statusMap.put(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal(), Constants.VALID_STATUS_UNUSABLE);
        return statusMap;
    }

    public Map<Integer, String> initCategoryValMap() {
        HashMap<Integer, String> categoryMap = new HashMap<Integer, String>();
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_WORK.getVal(), Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryMap.put(Constants.DataCategoryEnum.CATEGORY_APP.getVal(), Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryMap;
    }

    public Map<Integer, String> initStatusValMap() {
        HashMap<Integer, String> statusMap = new HashMap<Integer, String>();
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_TODO.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        statusMap.put(Constants.DataCategoryEnum.CATEGORY_REPORT.getVal(), Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        return statusMap;
    }

    public List<String> initCategoryNameList() {
        ArrayList<String> categoryNameList = new ArrayList<String>();
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_TODO_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_WORK_NAME.getVal());
        categoryNameList.add(Constants.DataCategoryNameEnum.CATEGORY_APP_NAME.getVal());
        return categoryNameList;
    }

    public List<String> initValidStatusList() {
        ArrayList<String> validStatusList = new ArrayList<String>();
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_ON.getVal());
        validStatusList.add(Constants.ValidStatusNameEnum.VALID_STATUS_OFF.getVal());
        return validStatusList;
    }

    public List<String> initJobTypeList() {
        ArrayList<String> jobTypeList = new ArrayList<String>();
        jobTypeList.add(Constants.JobTypeEnum.JOB_TYPE_NAME.getVal());
        jobTypeList.add(Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal());
        return jobTypeList;
    }

    public PageInfoResp<LabelSystemDataImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isBlank((CharSequence)queryImportRecordReq.getStartTime()) || StringUtils.isBlank((CharSequence)queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss");
            condition.ge((Object)"create_time", (Object)DateUtils.addDate((String)currentDate, (String)"yyyy-MM-dd HH:mm:ss", (int)-1, (String)"year"));
            condition.le((Object)"create_time", (Object)currentDate);
        } else {
            condition.ge((Object)"create_time", (Object)queryImportRecordReq.getStartTime());
            condition.le((Object)"create_time", (Object)queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryImportRecordReq.getUserIdName())) {
            condition.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"create_user_name", (Object)queryImportRecordReq.getUserIdName())).or()).like((Object)"create_user_id", (Object)queryImportRecordReq.getUserIdName());
            });
        }
        condition.orderByDesc((Object)"create_time");
        PageInfoResp pageInfoResp = new PageInfoResp();
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum().intValue());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize().intValue());
        pageInfoResp.setTotalPages(0);
        pageInfoResp.setTotalRecords(0);
        Page pageResult = (Page)this.labelSystemDataImportMapper.selectPage((IPage)new Page((long)queryImportRecordReq.getPageNum().intValue(), (long)queryImportRecordReq.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult != null && CollectionUtils.isNotEmpty((Collection)pageResult.getRecords())) {
            pageResult.getRecords().forEach(m -> m.setFileUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + m.getFileId().trim()));
            pageInfoResp.setList(pageResult.getRecords());
            pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
            pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        } else {
            pageInfoResp.setList((List)Lists.newArrayList());
        }
        return pageInfoResp;
    }

    public List<SystemDataExportVo> exportReport() {
        ArrayList excelVoList = Lists.newArrayList();
        List systemDataList = this.getExportData();
        if (CollectionUtils.isEmpty((Collection)systemDataList)) {
            return excelVoList;
        }
        Map categoryMap = this.initCategoryValMap();
        Map statusMap = this.initStatusValMap();
        LabelSystemDataAppVo systemDataAppVo = this.getSsoAppMap(systemDataList);
        Map erpInfoMap = systemDataAppVo.getErpInfoMap();
        Map thirdSsoInfoMap = systemDataAppVo.getThirdSsoInfoMap();
        Map athenaInfoMap = systemDataAppVo.getAthenaInfoMap();
        List appJobListDTOList = this.kmService.queryAppJobList();
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List preInstalledAppList = this.preinstalledApplicationService.queryPreinstalledAppList(user);
        Map preinstalledApplicationMap = preInstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        List systemDataAppList = systemDataList.stream().filter(x -> VirtualApplicationEnum.ATHENA_APP.getPrimaryId().equals(x.getAppCode())).filter(x -> x.getDataType().equals(ApplicationTypeEnum.VIRTUAL_APPLICATION.getType())).collect(Collectors.toList());
        Map<Object, Object> datasourceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(systemDataAppList)) {
            CustomApplicationsListPageReq customApplicationReq = new CustomApplicationsListPageReq();
            customApplicationReq.setStatus(Constants.VALID_STATUS_ENABLE);
            List datasourceInfoList = this.mobileDatasourceInfoService.queryDatasourceInfo(customApplicationReq);
            datasourceMap = datasourceInfoList.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, y -> y, (a, b) -> a));
        }
        for (LabelSystemData systemData : systemDataList) {
            SystemDataExportVo dataExportVo = new SystemDataExportVo();
            dataExportVo.setName(systemData.getName());
            dataExportVo.setRemark(systemData.getRemark());
            dataExportVo.setCategory((String)categoryMap.get(systemData.getDataCategory()));
            dataExportVo.setValidStatus((String)statusMap.get(systemData.getValidStatus()));
            String appName = this.addAppIDName(erpInfoMap, thirdSsoInfoMap, athenaInfoMap, systemData, Boolean.valueOf(false), preinstalledApplicationMap);
            dataExportVo.setAppName(appName);
            String jobType = "";
            String jobVal = "";
            if (Constants.DataCategoryEnum.CATEGORY_WORK.getVal().equals(systemData.getDataCategory())) {
                if (null != systemData.getIsJob() && systemData.getIsJob() == 1) {
                    jobType = Constants.JobTypeEnum.JOB_TYPE_CALLBACK.getVal();
                    jobVal = systemData.getCallBackUrl();
                } else {
                    jobType = Constants.JobTypeEnum.JOB_TYPE_NAME.getVal();
                    if (StringUtils.isNotEmpty((CharSequence)systemData.getWorkCode())) {
                        jobVal = this.getWorkName(systemData, appJobListDTOList, datasourceMap);
                    }
                }
            }
            dataExportVo.setJobType(jobType);
            dataExportVo.setJobVal(jobVal);
            excelVoList.add(dataExportVo);
        }
        return excelVoList;
    }

    public Map<String, String> getWorkCodeMap(String appId) {
        HashMap<String, String> appWorkMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return appWorkMap;
        }
        List syncJobInfoList = this.syncJobInfoMapper.selectList((Wrapper)this.getJobCondition(appId, ""));
        if (CollectionUtils.isNotEmpty((Collection)syncJobInfoList)) {
            for (SyncJobInfo syncJobInfo : syncJobInfoList) {
                String key = syncJobInfo.getAppId() + "-" + syncJobInfo.getJobCode();
                appWorkMap.put(key, syncJobInfo.getJobName());
            }
        }
        return appWorkMap;
    }

    public List<LabelSystemData> getExportData() {
        QueryWrapper condition = new QueryWrapper();
        ArrayList<Integer> categoryList = new ArrayList<Integer>();
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        categoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        condition.in((Object)"data_category", categoryList);
        condition.orderByDesc((Object)"modify_time");
        return this.labelSystemDataMapper.selectList((Wrapper)condition);
    }

    public List<SystemDataJobExportVo> exportJobList() {
        AppLinkDTO appLinkDTO;
        ArrayList<SystemDataJobExportVo> dataJobExportVoList = new ArrayList<SystemDataJobExportVo>();
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        List appLinkListDTO = this.appLinkService.queryManageList(user);
        ArrayList nameIamList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)(appLinkListDTO = this.filterRepeatApp(appLinkListDTO, nameIamList)))) {
            return dataJobExportVoList;
        }
        Map<Object, Object> codeIamMap = new HashMap();
        List iamLinkList = appLinkListDTO.stream().filter(x -> x.getDataSource().equals(ApplicationTypeEnum.IAM_APPLICATION.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(iamLinkList)) {
            codeIamMap = iamLinkList.stream().collect(Collectors.toMap(AppLinkDTO::getCode, Function.identity(), (a, b) -> a));
        }
        List ssoAppIdList = appLinkListDTO.stream().map(AppLinkDTO::getApplicationAppId).collect(Collectors.toList());
        List syncJobInfoList = this.syncJobInfoMapper.selByAppId(ssoAppIdList);
        Map appInfoMap = appLinkListDTO.stream().collect(Collectors.toMap(AppLinkDTO::getApplicationAppId, Function.identity(), (a, b) -> a));
        List appJobListDTOList = this.kmService.queryAppJobList();
        for (AppJobDTO appJobListDTO : appJobListDTOList) {
            appLinkDTO = (AppLinkDTO)codeIamMap.get(appJobListDTO.getAppCode());
            if (null == appLinkDTO) continue;
            List jobList = appJobListDTO.getData();
            for (AppJobDTO.Job job : jobList) {
                SystemDataJobExportVo jobExportVo = new SystemDataJobExportVo();
                jobExportVo.setAppName(appLinkDTO.getName());
                jobExportVo.setJobName(job.getName());
                jobExportVo.setJobId(job.getCode());
                dataJobExportVoList.add(jobExportVo);
            }
        }
        for (SyncJobInfo syncJobInfo : syncJobInfoList) {
            appLinkDTO = (AppLinkDTO)appInfoMap.get(syncJobInfo.getAppId());
            if (null == appLinkDTO) continue;
            SystemDataJobExportVo jobExportVo = new SystemDataJobExportVo();
            jobExportVo.setAppName(appLinkDTO.getName());
            jobExportVo.setJobName(syncJobInfo.getJobName());
            jobExportVo.setJobId(syncJobInfo.getJobCode());
            dataJobExportVoList.add(jobExportVo);
        }
        Collator comparator = Collator.getInstance(Locale.CHINA);
        Collections.sort(dataJobExportVoList, (o1, o2) -> comparator.compare(o1.getAppName(), o2.getAppName()));
        return dataJobExportVoList;
    }

    public List<LabelSystemData> getDataByWork(Integer dataType, String appCode, List<String> workCodeList) {
        return this.labelSystemDataMapper.getDataByWork(dataType, appCode, workCodeList);
    }

    public List<LabelSystemData> querySystemDataBySystemId(Integer componentSource, List<Long> systemId, String tenantId) {
        return this.labelSystemDataMapper.querySystemDataBySystemId(componentSource, systemId, tenantId);
    }
}

