/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.ServiceException;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataSourceUpdateReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreQueryReq;
import com.digiwin.athena.semc.dto.portal.LabelSystemUpdateValidReq;
import com.digiwin.athena.semc.dto.portal.PortalContentCarouselImage;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.entity.portal.PortalContentCarousel;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import com.digiwin.athena.semc.mapper.bench.JobBenchCustomMapper;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.mapper.portal.PortalLayoutCustomMapper;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.RelatedAppServiceWrapper;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreCustomVo;
import com.digiwin.athena.semc.vo.portal.LabelSystemPreQueryVO;
import com.digiwin.athena.semc.vo.portal.ValidLabelRelVO;
import com.google.gson.Gson;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ObjectUtils;

@Service
public class LabelSystemPreServiceImpl
extends ServiceImpl<LabelSystemPreMapper, LabelSystemPre>
implements LabelSystemPreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemPreServiceImpl.class);
    @Autowired
    private RelatedAppServiceWrapper relatedAppServiceWrapper;
    @Autowired
    MessageUtils messageUtils;
    @Autowired
    LabelSystemPreMapper labelSystemPreMapper;
    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Autowired
    LabelSystemDataMapper labelSystemDataMapper;
    @Autowired
    LabelSystemCustomMapper labelSystemCustomMapper;
    @Autowired
    PortalLayoutCustomMapper portalLayoutCustomMapper;
    @Autowired
    TransactionTemplate transactionTemplate;
    @Autowired
    JobBenchCustomMapper jobBenchCustomMapper;
    @Autowired
    PortalInfoContentMapper portalInfoContentMapper;
    @Autowired
    CustomizedMenuTemplateMapper customizedMenuTemplateMapper;
    @Resource
    private TranslateService translateService;
    @Resource
    private Converter converter;
    @Resource
    private PortalInfoMapper portalInfoMapper;
    @Autowired
    private KmService kmService;

    public ResultPageBean pageQuery(LabelSystemPreQueryReq labelSystemPreQueryReq) {
        ResultPageBean resultPageBean;
        if (Objects.isNull(labelSystemPreQueryReq.getClientType())) {
            labelSystemPreQueryReq.setClientType(Integer.valueOf(0));
        }
        if (0 == labelSystemPreQueryReq.getClientType()) {
            try {
                this.initPreData(Integer.valueOf(0));
                LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
                queryPreWrapper.eq(LabelSystemPre::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                String locale = LocaleContextHolder.getLocale().toString();
                if ("zh_TW".equals(locale)) {
                    queryPreWrapper.like(!StringUtils.isEmpty((CharSequence)labelSystemPreQueryReq.getQueryCondition().getName()), LabelSystemPre::getNameTw, (Object)labelSystemPreQueryReq.getQueryCondition().getName());
                } else {
                    queryPreWrapper.like(!StringUtils.isEmpty((CharSequence)labelSystemPreQueryReq.getQueryCondition().getName()), LabelSystemPre::getName, (Object)labelSystemPreQueryReq.getQueryCondition().getName());
                }
                queryPreWrapper.eq(!Objects.isNull(labelSystemPreQueryReq.getQueryCondition().getValidStatus()), LabelSystemPre::getValidStatus, (Object)labelSystemPreQueryReq.getQueryCondition().getValidStatus());
                queryPreWrapper.in(!CollectionUtils.isEmpty((Collection)labelSystemPreQueryReq.getQueryCondition().getDataCategory()), LabelSystemPre::getDataCategory, (Collection)labelSystemPreQueryReq.getQueryCondition().getDataCategory());
                queryPreWrapper.eq(LabelSystemPre::getClientType, (Object)labelSystemPreQueryReq.getClientType());
                LinkedList labelSystemPreQueryEmptyList = new LinkedList();
                List labelSystemPreList = this.labelSystemPreMapper.selectList((Wrapper)queryPreWrapper);
                if (!StringUtils.isEmpty((CharSequence)labelSystemPreQueryReq.getQueryCondition().getName()) && CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
                    return ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreQueryEmptyList, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)labelSystemPreQueryEmptyList.size())));
                }
                if (!Objects.isNull(labelSystemPreQueryReq.getQueryCondition().getValidStatus()) && CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
                    return ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreQueryEmptyList, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)labelSystemPreQueryEmptyList.size())));
                }
                if (!CollectionUtils.isEmpty((Collection)labelSystemPreQueryReq.getQueryCondition().getDataCategory()) && CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
                    return ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreQueryEmptyList, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)labelSystemPreQueryEmptyList.size())));
                }
                if (CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
                    List labelSystemPreQueryVOList = labelSystemPreList.stream().map(item -> {
                        LabelSystemPreQueryVO labelSystemPreQueryVO = (LabelSystemPreQueryVO)this.converter.convert(item, LabelSystemPreQueryVO.class);
                        labelSystemPreQueryVO.setComponentSource(Integer.valueOf(1));
                        if (Constants.IsUseDataNum.USE_DATA_TRUE.getVal().equals(item.getIsUseData()) && Constants.IsEnableTrueNum.ENABLE_TRUE.getVal().equals(item.getIsEnableTrue())) {
                            labelSystemPreQueryVO.setModifyUserId("");
                            labelSystemPreQueryVO.setModifyTime("");
                        }
                        return labelSystemPreQueryVO;
                    }).collect(Collectors.toList());
                    resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreQueryVOList, (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)labelSystemPreQueryVOList.size())));
                }
                Gson gson = new Gson();
                List labelSystemSourceList = this.labelSystemSourceMapper.listByCondition(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), Integer.valueOf(1), labelSystemPreList.stream().map(LabelSystemPre::getId).collect(Collectors.toList()));
                LinkedList dataSourceInfoList = new LinkedList();
                labelSystemSourceList.forEach(item -> {
                    LabelSystemPreQueryVO.DataSourceInfo dataSourceInfo = (LabelSystemPreQueryVO.DataSourceInfo)gson.fromJson(JSON.toJSONString((Object)item), LabelSystemPreQueryVO.DataSourceInfo.class);
                    dataSourceInfoList.add(dataSourceInfo);
                });
                Map<Long, List<LabelSystemPreQueryVO.DataSourceInfo>> map = dataSourceInfoList.stream().collect(Collectors.groupingBy(LabelSystemPreQueryVO.DataSourceInfo::getSystemId));
                List labelSystemPreQueryVOList = labelSystemPreList.stream().map(item -> {
                    LabelSystemPreQueryVO labelSystemPreQueryVO = (LabelSystemPreQueryVO)this.converter.convert(item, LabelSystemPreQueryVO.class);
                    List dataList = (List)map.get(item.getId());
                    if ("zh_TW".equals(locale) && StringUtils.isNotEmpty((CharSequence)item.getNameTw())) {
                        labelSystemPreQueryVO.setName(item.getNameTw());
                    }
                    if (Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal().equals(item.getDataCategory())) {
                        labelSystemPreQueryVO.setModifyUserId("");
                        labelSystemPreQueryVO.setModifyTime("");
                    }
                    labelSystemPreQueryVO.setComponentSource(Integer.valueOf(1));
                    labelSystemPreQueryVO.setDataSourceInfo(dataList);
                    return labelSystemPreQueryVO;
                }).collect(Collectors.toList());
                if (Constants.IS_LAYOUT.equals(labelSystemPreQueryReq.getIsLayout())) {
                    labelSystemPreQueryVOList = this.filterPortalLayout(labelSystemPreQueryVOList);
                }
                List labelSystemPreQuerySortVO = labelSystemPreQueryVOList.stream().sorted(Comparator.comparing(LabelSystemPreQueryVO::getModifyTime).reversed()).collect(Collectors.toList());
                resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreQuerySortVO.stream().skip((long)(labelSystemPreQueryReq.getPageNum() - 1) * labelSystemPreQueryReq.getPageSize().longValue()).limit(labelSystemPreQueryReq.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)labelSystemPreQuerySortVO.size())));
            }
            catch (BizException bizException) {
                return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.LABEL_SYSTEM_PRE, (String)this.messageUtils.getMessage("error.message.system.pre.open-error")));
            }
            catch (Exception e) {
                log.error("Query System Pre Error", (Throwable)e);
                resultPageBean = ResultPageBean.sysException((ServiceException)new ServiceException(ErrorCodeConstant.LABEL_SYSTEM_PRE, this.messageUtils.getMessage("error.message.system.pre.open-error")));
            }
        } else {
            List labelSystemPreList = this.initMobileLabelSystemPre();
            if (CollectionUtils.isNotEmpty((Collection)labelSystemPreQueryReq.getQueryCondition().getDataCategory())) {
                labelSystemPreList = labelSystemPreList.stream().filter(x -> labelSystemPreQueryReq.getQueryCondition().getDataCategory().contains(x.getDataCategory())).collect(Collectors.toList());
            }
            if (null != labelSystemPreQueryReq.getQueryCondition().getValidStatus()) {
                labelSystemPreList = labelSystemPreList.stream().filter(x -> labelSystemPreQueryReq.getQueryCondition().getValidStatus().equals(x.getValidStatus())).collect(Collectors.toList());
            }
            for (LabelSystemPre labelSystemPre : labelSystemPreList) {
                String name = this.translateService.translateTextCache(labelSystemPre.getName(), "");
                labelSystemPre.setName(name);
                labelSystemPre.setModifyUserId("");
                labelSystemPre.setModifyUserName("");
            }
            if (StringUtils.isNotEmpty((CharSequence)labelSystemPreQueryReq.getQueryCondition().getName())) {
                labelSystemPreList = labelSystemPreList.stream().filter(x -> x.getName().contains(labelSystemPreQueryReq.getQueryCondition().getName())).collect(Collectors.toList());
            }
            List labelSystemPreQueryVOS = labelSystemPreList.stream().map(item -> {
                LabelSystemPreQueryVO labelSystemPreQueryVO = (LabelSystemPreQueryVO)this.converter.convert(item, LabelSystemPreQueryVO.class);
                return labelSystemPreQueryVO;
            }).collect(Collectors.toList());
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(labelSystemPreQueryVOS.stream().skip((long)(labelSystemPreQueryReq.getPageNum() - 1) * labelSystemPreQueryReq.getPageSize().longValue()).limit(labelSystemPreQueryReq.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)labelSystemPreQueryReq.getPageNum(), (Integer)labelSystemPreQueryReq.getPageSize(), (Integer)labelSystemPreList.size())));
        }
        return resultPageBean;
    }

    public List<LabelSystemPre> initMobileLabelSystemPre() {
        LambdaQueryWrapper labelSystemPreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)labelSystemPreLambdaQueryWrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId())).eq(LabelSystemPre::getClientType, (Object)1);
        List labelSystemPreList = this.labelSystemPreMapper.selectList((Wrapper)labelSystemPreLambdaQueryWrapper);
        List overSystemPreList = (List)InterceptorIgnoreUtil.handler(() -> this.labelSystemPreMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(LabelSystemPre::getClientType, (Object)1)));
        ArrayList<LabelSystemPre> insertPreList = new ArrayList<LabelSystemPre>();
        if (CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
            insertPreList.addAll(overSystemPreList);
        } else {
            Map preListMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
            for (LabelSystemPre overSystemPre : overSystemPreList) {
                if (null != preListMap.get(overSystemPre.getDataCategory())) continue;
                insertPreList.add(overSystemPre);
            }
        }
        if (CollectionUtils.isNotEmpty(insertPreList)) {
            labelSystemPreList = this.batchSavePreData(insertPreList, Utils.getTenantId());
        }
        labelSystemPreList = this.labelSystemPreMapper.selectList((Wrapper)labelSystemPreLambdaQueryWrapper);
        return labelSystemPreList;
    }

    private List<LabelSystemPreQueryVO> filterPortalLayout(List<LabelSystemPreQueryVO> labelSystemPreQueryVOList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PortalLayoutCustom::getLabelType, (Object)1);
        queryWrapper.eq(PortalLayoutCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(BaseEntity::getDelFlag, (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
        List portalLayoutCustomList = this.portalLayoutCustomMapper.selectList((Wrapper)queryWrapper);
        portalLayoutCustomList.forEach(data -> labelSystemPreQueryVOList.removeIf(e -> e.getId().equals(data.getLabelId())));
        List<LabelSystemPreQueryVO> labelSystemPreVOList = labelSystemPreQueryVOList.stream().filter(e -> !e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal()) && !e.getDataType().equals(Constants.DataTypeEnum.TYPE_CAROUSEL.getVal())).collect(Collectors.toList());
        return labelSystemPreVOList;
    }

    @Transactional
    public ResponseEntity<?> updateDataSource(LabelSystemDataSourceUpdateReq labelSystemUpdateReq) {
        Map<Long, List<LabelSystemDataSourceUpdateReq.DataSourceInfo>> dataSourceMap = labelSystemUpdateReq.getDataSourceInfo().stream().collect(Collectors.groupingBy(LabelSystemDataSourceUpdateReq.DataSourceInfo::getSystemId));
        for (LabelSystemDataSourceUpdateReq.DataSourceInfo item : labelSystemUpdateReq.getDataSourceInfo()) {
            LambdaQueryWrapper queryWrapper;
            if (null == item.getDataId()) continue;
            LambdaQueryWrapper queryWrapperData = new LambdaQueryWrapper();
            queryWrapperData.eq(LabelSystemData::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapperData.eq(LabelSystemData::getId, (Object)item.getDataId());
            LabelSystemData labelSystemData = (LabelSystemData)this.labelSystemDataMapper.selectOne((Wrapper)queryWrapperData);
            if (1 == item.getComponentSource()) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(LabelSystemPre::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                queryWrapper.eq(LabelSystemPre::getId, (Object)item.getSystemId());
                LabelSystemPre labelSystemPre = (LabelSystemPre)this.labelSystemPreMapper.selectOne((Wrapper)queryWrapper);
                if (labelSystemData.getDataCategory().equals(labelSystemPre.getDataCategory())) continue;
                String error = this.messageUtils.getMessage("error.message.system.pre.dara.fail");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, (String)error);
            }
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(LabelSystemCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            queryWrapper.eq(LabelSystemCustom::getId, (Object)item.getSystemId());
            LabelSystemCustom labelSystemCustom = (LabelSystemCustom)this.labelSystemCustomMapper.selectOne((Wrapper)queryWrapper);
            if (labelSystemData.getDataCategory().equals(labelSystemCustom.getDataCategory())) continue;
            String error = this.messageUtils.getMessage("error.message.system.pre.dara.fail");
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, (String)error);
        }
        try {
            if (CollectionUtils.isNotEmpty((Collection)labelSystemUpdateReq.getDataSourceInfo())) {
                this.initUserName((LabelSystemDataSourceUpdateReq.DataSourceInfo)labelSystemUpdateReq.getDataSourceInfo().get(0));
            }
            dataSourceMap.forEach((key, value) -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(LabelSystemSource::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                updateWrapper.in(LabelSystemSource::getSystemId, (Collection)value.stream().map(LabelSystemDataSourceUpdateReq.DataSourceInfo::getSystemId).collect(Collectors.toList()));
                this.transactionTemplate.executeWithoutResult((Consumer)new /* Unavailable Anonymous Inner Class!! */);
            });
        }
        catch (Exception e) {
            log.error("update dataSource error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_DATA_SOURCE, (String)this.messageUtils.getMessage("error.message.data.source.update-error"));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public void initUserName(LabelSystemDataSourceUpdateReq.DataSourceInfo dataSourceInfo) {
        String userName = AppAuthContextHolder.getContext().getAuthoredUser().getUserName();
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
            LabelSystemCustom labelSystemCustom = new LabelSystemCustom();
            labelSystemCustom.setId(dataSourceInfo.getSystemId());
            labelSystemCustom.setModifyUserName(userName);
            this.labelSystemCustomMapper.updateById((Object)labelSystemCustom);
        }
        if (dataSourceInfo.getComponentSource().equals(Constants.LabelTypeEnum.SYSTEM_PRE.getVal())) {
            LabelSystemPre labelSystemPre = new LabelSystemPre();
            labelSystemPre.setId(dataSourceInfo.getSystemId());
            labelSystemPre.setModifyUserName(userName);
            this.labelSystemPreMapper.updateById((Object)labelSystemPre);
        }
    }

    public ValidLabelRelVO validLabelRel(LabelSystemUpdateValidReq labelSystemUpdateValidReq) {
        List jobBenchCustomList;
        List templateList;
        List contentList;
        ValidLabelRelVO validLabelRelVO = new ValidLabelRelVO();
        if (Constants.VALID_STATUS_ENABLE.equals(labelSystemUpdateValidReq.getValidStatus()) || Constants.LabelTypeEnum.SYSTEM_PRE.getVal().equals(labelSystemUpdateValidReq.getComponentSource())) {
            return validLabelRelVO;
        }
        PortalLayoutCustom portalLayoutCustom = this.queryRelSimplePortal(labelSystemUpdateValidReq.getId(), labelSystemUpdateValidReq.getComponentSource());
        if (!ObjectUtils.isEmpty((Object)portalLayoutCustom)) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            validLabelRelVO.setSimpleRelFlag(Boolean.TRUE);
        }
        if (CollectionUtils.isNotEmpty((Collection)(contentList = this.queryRelClassicalPortal(labelSystemUpdateValidReq.getId(), labelSystemUpdateValidReq.getComponentSource())))) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            List portalNameList = contentList.stream().map(PortalInfoContent::getName).distinct().collect(Collectors.toList());
            validLabelRelVO.setClassicalNameList(portalNameList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(templateList = this.queryRelCustomMenu(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), labelSystemUpdateValidReq.getId())))) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            List templateNameList = templateList.stream().map(CustomizedMenuTemplate::getTemplateName).collect(Collectors.toList());
            validLabelRelVO.setMenuNameList(templateNameList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(jobBenchCustomList = this.queryRelJobBench(labelSystemUpdateValidReq.getId())))) {
            validLabelRelVO.setSuccessFlag(Boolean.FALSE);
            List jobBenchNameList = jobBenchCustomList.stream().map(JobBenchCustom::getNameZh).distinct().collect(Collectors.toList());
            validLabelRelVO.setJobBenchNameList(jobBenchNameList);
        }
        if (Objects.equals(1, labelSystemUpdateValidReq.getClientType())) {
            ArrayList<Long> systemIdList = new ArrayList<Long>();
            systemIdList.add(labelSystemUpdateValidReq.getId());
            List portalInfoContentList = this.portalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList, Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal(), null);
            if (CollectionUtils.isNotEmpty((Collection)portalInfoContentList)) {
                validLabelRelVO.setSuccessFlag(Boolean.FALSE);
                List portalNameList = portalInfoContentList.stream().map(PortalInfoContent::getName).distinct().collect(Collectors.toList());
                validLabelRelVO.setClassicalNameList(portalNameList);
            }
        }
        return validLabelRelVO;
    }

    public ResponseEntity<?> updateValidStatus(Long id, Integer validStatus, Integer componentSource, Integer clientType) {
        try {
            LabelSystemCustom labelSystemCustom;
            if (componentSource.equals(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal())) {
                List jsonObjectList;
                labelSystemCustom = (LabelSystemCustom)this.labelSystemCustomMapper.selectById((Serializable)id);
                if (ObjectUtils.isEmpty((Object)labelSystemCustom)) {
                    String error = String.format(this.messageUtils.getMessage("error.message.system.custom.not.exist"), new Object[0]);
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
                }
                if (Constants.VALID_STATUS_UNUSABLE.equals(validStatus)) {
                    PortalLayoutCustom portalLayoutCustom = this.queryRelSimplePortal(id, componentSource);
                    if (!ObjectUtils.isEmpty((Object)portalLayoutCustom)) {
                        String error = this.messageUtils.getMessage("error.message.system.portal.layout.exist");
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
                    }
                    List contentList = this.queryRelClassicalPortal(id, componentSource);
                    if (CollectionUtils.isNotEmpty((Collection)contentList)) {
                        String error = this.messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
                    }
                    List templateList = this.queryRelCustomMenu(Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal(), id);
                    if (CollectionUtils.isNotEmpty((Collection)templateList)) {
                        String error = this.messageUtils.getMessage("error.message.jd.menu.stop.error");
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
                    }
                    List jobBenchCustomList = this.queryRelJobBench(id);
                    if (CollectionUtils.isNotEmpty((Collection)jobBenchCustomList)) {
                        String error = this.messageUtils.getMessage("error.message.job.system.data.stop.error");
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
                    }
                    if (Objects.equals(1, clientType)) {
                        ArrayList<Long> systemIdList = new ArrayList<Long>();
                        systemIdList.add(id);
                        List portalInfoContentList = this.portalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList, Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal(), null);
                        if (CollectionUtils.isNotEmpty((Collection)portalInfoContentList)) {
                            String error = this.messageUtils.getMessage("error.message.jd.portal.layout.stop.error");
                            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)error);
                        }
                    }
                }
                if (Constants.VALID_STATUS_ENABLE.equals(validStatus) && !Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(labelSystemCustom.getDataCategory()) && !Objects.equals(11, labelSystemCustom.getDataCategory()) && CollectionUtils.isEmpty((Collection)(jsonObjectList = this.labelSystemSourceMapper.listBySystemId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), id, componentSource)))) {
                    String error = this.messageUtils.getMessage("error.message.system.pre.incomplete.fail");
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
                }
            }
            if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(componentSource)) {
                LabelSystemPre labelSystemPre = (LabelSystemPre)this.labelSystemPreMapper.selectById((Serializable)id);
                labelSystemPre.setValidStatus(validStatus);
                labelSystemPre.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                this.labelSystemPreMapper.updateById((Object)labelSystemPre);
            } else {
                labelSystemCustom = (LabelSystemCustom)this.labelSystemCustomMapper.selectById((Serializable)id);
                if (Objects.equals(labelSystemCustom.getTenantId(), "SYSTEM_TENANT")) {
                    String error = this.messageUtils.getMessage("error.message.system.lable.custom.not.modify");
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)error);
                }
                labelSystemCustom.setValidStatus(validStatus);
                labelSystemCustom.setModifyUserName(AppAuthContextHolder.getContext().getAuthoredUser().getUserName());
                this.labelSystemCustomMapper.updateById((Object)labelSystemCustom);
            }
        }
        catch (Exception e) {
            log.error("update validStatus error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.UPDATE_SYSTEM_VALID_STATUS, (String)this.messageUtils.getMessage("error.message.valid.status.update-error"));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    private List<CustomizedMenuTemplate> queryRelCustomMenu(Integer LabelType, Long id) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        return this.customizedMenuTemplateMapper.queryTempListByLabelId(LabelType, Collections.singletonList(id), tenantId);
    }

    private List<JobBenchCustom> queryRelJobBench(Long id) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(id);
        return this.jobBenchCustomMapper.selectBySystem(idList);
    }

    private List<PortalInfoContent> queryRelClassicalPortal(Long id, Integer componentSource) {
        ArrayList<Long> systemIdList = new ArrayList<Long>();
        systemIdList.add(id);
        ArrayList<PortalInfoContent> contentList = this.portalInfoContentMapper.selPortalConent(Utils.getTenantId(), systemIdList, componentSource, null);
        if (CollectionUtils.isEmpty((Collection)contentList)) {
            contentList = new ArrayList<PortalInfoContent>();
        }
        if (!Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal().equals(componentSource)) {
            return contentList;
        }
        List contentAttrList = this.portalInfoContentMapper.selPortalConent(Utils.getTenantId(), new ArrayList(), null, Constants.DataTypeEnum.TYPE_CAROUSEL.getVal());
        if (CollectionUtils.isEmpty((Collection)contentAttrList)) {
            return contentList;
        }
        List contentCarList = this.filterWebCarousel(contentAttrList, id);
        if (CollectionUtils.isNotEmpty((Collection)contentCarList)) {
            contentList.addAll(contentCarList);
        }
        return contentList;
    }

    private PortalLayoutCustom queryRelSimplePortal(Long id, Integer componentSource) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PortalLayoutCustom::getLabelId, (Object)id);
        queryWrapper.eq(PortalLayoutCustom::getLabelType, (Object)componentSource);
        queryWrapper.eq(PortalLayoutCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        queryWrapper.eq(BaseEntity::getDelFlag, (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
        return (PortalLayoutCustom)this.portalLayoutCustomMapper.selectOne((Wrapper)queryWrapper);
    }

    public List<PortalInfoContent> filterWebCarousel(List<PortalInfoContent> contentAttrList, Long systemId) {
        ArrayList<PortalInfoContent> contentAttrPortList = new ArrayList<PortalInfoContent>();
        for (PortalInfoContent contentAttr : contentAttrList) {
            PortalContentCarousel carouselInfo;
            if (StringUtils.isEmpty((CharSequence)contentAttr.getContentAttr()) || null == (carouselInfo = (PortalContentCarousel)JSON.parseObject((String)contentAttr.getContentAttr(), PortalContentCarousel.class)) || CollectionUtils.isEmpty((Collection)carouselInfo.getImageList())) continue;
            Boolean isLink = false;
            for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                if (null == image.getJumpType() || StringUtils.isEmpty((CharSequence)image.getJumpValue()) || !Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType()) || !image.getJumpValue().equals(systemId + "")) continue;
                isLink = true;
                break;
            }
            if (!isLink.booleanValue()) continue;
            contentAttrPortList.add(contentAttr);
        }
        return contentAttrPortList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public List<LabelSystemPre> initPreData(Integer clientType) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List labelSystemPreList = this.getInitData(tenantId, clientType);
        RedisLock redisLock = new RedisLock("LabelSystemPre:" + tenantId);
        List overSystemPreList = this.getInitData("", clientType);
        List<LabelSystemPre> insertPreList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)labelSystemPreList)) {
            insertPreList = overSystemPreList;
        } else {
            Map<Object, Object> preListMap = MapUtil.newHashMap();
            if (Constants.ClientTypeEnum.PC.getValue().equals(clientType)) {
                preListMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
            } else if (Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType)) {
                preListMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
            }
            for (LabelSystemPre overSystemPre : overSystemPreList) {
                if (Constants.ClientTypeEnum.PC.getValue().equals(clientType) && null == preListMap.get(overSystemPre.getDataType())) {
                    insertPreList.add(overSystemPre);
                    continue;
                }
                if (!Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType) || null != preListMap.get(overSystemPre.getDataCategory())) continue;
                insertPreList.add(overSystemPre);
            }
        }
        try {
            if (CollectionUtils.isEmpty(insertPreList) || !redisLock.lock()) {
                return this.getInitData(tenantId, clientType);
            }
        }
        catch (InterruptedException e) {
            return labelSystemPreList;
        }
        try {
            labelSystemPreList = this.batchSavePreData(insertPreList, tenantId);
            List e = labelSystemPreList = this.getInitData(tenantId, clientType);
            return e;
        }
        catch (Exception e) {
            log.error("LabelSystemPre initPreData error", (Throwable)e);
        }
        finally {
            redisLock.unlock();
        }
        return labelSystemPreList;
    }

    public LabelSystemPre getPreSystemID(Integer dataType) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(LabelSystemPre::getTenantId, (Object)tenantId);
        queryWrapper.eq(LabelSystemPre::getDataType, (Object)dataType);
        queryWrapper.eq(LabelSystemPre::getClientType, (Object)Constants.ClientTypeEnum.PC.getValue());
        List labelSystemPreList = this.labelSystemPreMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)labelSystemPreList)) {
            return (LabelSystemPre)labelSystemPreList.get(0);
        }
        return null;
    }

    public LabelSystemPreCustomVo queryAllSystem(LabelSystemAllVo req) {
        LabelSystemPreCustomVo preCustomVo = this.queryAllSystemLabel(req);
        if (CollectionUtils.isNotEmpty((Collection)preCustomVo.getPresetList())) {
            List presetList = preCustomVo.getPresetList().stream().filter(e -> !Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal().equals(e.getDataType())).collect(Collectors.toList());
            preCustomVo.setPresetList(presetList);
        }
        return preCustomVo;
    }

    public List<LabelSystemPre> initDefPortal(List<Integer> dataCategoryList, Integer clientType) {
        List preList = this.initPreData(clientType);
        if (CollectionUtils.isNotEmpty(dataCategoryList)) {
            preList = preList.stream().filter(item -> dataCategoryList.contains(item.getDataType())).collect(Collectors.toList());
        }
        return preList;
    }

    public List<LabelSystemPre> batchSavePreData(List<LabelSystemPre> labelSystemPreList, String tenantId) {
        ArrayList<LabelSystemPre> systemPreTenantList = new ArrayList<LabelSystemPre>();
        for (LabelSystemPre labelSystemPre : labelSystemPreList) {
            labelSystemPre.setTenantId(tenantId);
            labelSystemPre.setId(null);
            labelSystemPre.setCreateTime(DateUtils.getNowTime((String)""));
            labelSystemPre.setModifyTime(DateUtils.getNowTime((String)""));
            this.labelSystemPreMapper.insert((Object)labelSystemPre);
            labelSystemPre.setId(labelSystemPre.getId());
            systemPreTenantList.add(labelSystemPre);
        }
        return systemPreTenantList;
    }

    public List<LabelSystemPre> getInitData(String tenantId, Integer clientType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)clientType)) {
            queryWrapper.eq((Object)"client_type", (Object)clientType);
        }
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        } else {
            queryWrapper.isNull((Object)"tenant_id");
        }
        List labelSystemPreList = this.labelSystemPreMapper.selectList((Wrapper)queryWrapper);
        return labelSystemPreList;
    }

    @Transactional
    public Integer editToDoData(LabelSystemPre req) {
        if (StringUtils.isNotEmpty((CharSequence)req.getTenantId())) {
            List preSystemList = this.getInitData(req.getTenantId(), Constants.ClientTypeEnum.PC.getValue());
            List toDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(toDoList)) {
                return null;
            }
            LabelSystemPre systemPreTenant = (LabelSystemPre)toDoList.get(0);
            systemPreTenant.setName("\u5f85\u529e");
            systemPreTenant.setValidStatus(Constants.VALID_STATUS_ENABLE);
            systemPreTenant.setDataCategory(Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal());
            systemPreTenant.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_TRUE.getVal());
            systemPreTenant.setIsUseData(Constants.IsUseDataNum.USE_DATA_FALSE.getVal());
            this.labelSystemPreMapper.updateById((Object)systemPreTenant);
            List thirdToDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal())).collect(Collectors.toList());
            Long thirdToDoID = null;
            if (CollectionUtils.isNotEmpty(thirdToDoList)) {
                thirdToDoID = ((LabelSystemPre)thirdToDoList.get(0)).getId();
            }
            if (CollectionUtils.isEmpty(thirdToDoList)) {
                LabelSystemPre systemThridToDo = new LabelSystemPre();
                systemThridToDo.setName("\u4e09\u65b9\u5f85\u529e");
                systemThridToDo.setDataCategory(Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
                systemThridToDo.setDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                systemThridToDo.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_FALSE.getVal());
                systemThridToDo.setIsUseData(Constants.IsUseDataNum.USE_DATA_TRUE.getVal());
                systemThridToDo.setTenantId(req.getTenantId());
                systemThridToDo.setValidStatus(((LabelSystemPre)toDoList.get(0)).getValidStatus());
                systemThridToDo.setCreateTime(systemPreTenant.getCreateTime());
                systemThridToDo.setCreateUserId(systemPreTenant.getCreateUserId());
                systemThridToDo.setCreateUserName(systemPreTenant.getCreateUserName());
                systemThridToDo.setModifyTime(systemPreTenant.getModifyTime());
                systemThridToDo.setModifyUserName(systemPreTenant.getModifyUserName());
                systemThridToDo.setModifyUserId(systemPreTenant.getModifyUserId());
                this.labelSystemPreMapper.insert((Object)systemThridToDo);
                thirdToDoID = systemThridToDo.getId();
            }
            this.labelSystemSourceMapper.delBySystemId(thirdToDoID, ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            List systemSourceList = this.labelSystemSourceMapper.queryByCountDataId(systemPreTenant.getId(), ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            if (CollectionUtils.isEmpty((Collection)systemSourceList)) {
                return null;
            }
            for (LabelSystemSource systemSource : systemSourceList) {
                systemSource.setSystemId(thirdToDoID);
                systemSource.setId(null);
                this.labelSystemSourceMapper.insert((Object)systemSource);
            }
            return null;
        }
        List tenantIdList = this.labelSystemPreMapper.queryPreSystemTenant();
        for (String tenantId : tenantIdList) {
            List preSystemList = this.getInitData(tenantId, Constants.ClientTypeEnum.PC.getValue());
            List toDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())).collect(Collectors.toList());
            List thirdToDoList = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(toDoList)) continue;
            Long toDoID = ((LabelSystemPre)toDoList.get(0)).getId();
            LabelSystemPre systemPreTenant = (LabelSystemPre)toDoList.get(0);
            systemPreTenant.setName("\u5f85\u529e");
            systemPreTenant.setValidStatus(Constants.VALID_STATUS_ENABLE);
            systemPreTenant.setDataCategory(Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal());
            systemPreTenant.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_TRUE.getVal());
            systemPreTenant.setIsUseData(Constants.IsUseDataNum.USE_DATA_FALSE.getVal());
            this.labelSystemPreMapper.updateById((Object)systemPreTenant);
            Long thirdToDoID = null;
            if (CollectionUtils.isNotEmpty(thirdToDoList)) {
                thirdToDoID = ((LabelSystemPre)thirdToDoList.get(0)).getId();
            }
            if (CollectionUtils.isEmpty(thirdToDoList)) {
                LabelSystemPre thirdToDoPre = this.labelSystemPreMapper.getInitByDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                if (null == thirdToDoPre) {
                    LabelSystemPre systemPreNoTen = new LabelSystemPre();
                    systemPreNoTen.setTenantId(null);
                    systemPreNoTen.setName("\u4e09\u65b9\u5f85\u529e");
                    systemPreNoTen.setDataCategory(Constants.DataCategoryEnum.CATEGORY_TODO.getVal());
                    systemPreNoTen.setDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
                    systemPreNoTen.setValidStatus(Constants.VALID_STATUS_UNUSABLE);
                    systemPreNoTen.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_FALSE.getVal());
                    systemPreNoTen.setIsUseData(Constants.IsUseDataNum.USE_DATA_TRUE.getVal());
                    this.labelSystemPreMapper.insert((Object)systemPreNoTen);
                    thirdToDoPre = systemPreNoTen;
                }
                thirdToDoPre.setTenantId(tenantId);
                thirdToDoPre.setId(null);
                thirdToDoPre.setValidStatus(((LabelSystemPre)toDoList.get(0)).getValidStatus());
                thirdToDoPre.setCreateTime(((LabelSystemPre)toDoList.get(0)).getCreateTime());
                thirdToDoPre.setCreateUserId(((LabelSystemPre)toDoList.get(0)).getCreateUserId());
                thirdToDoPre.setCreateUserName(((LabelSystemPre)toDoList.get(0)).getCreateUserName());
                thirdToDoPre.setModifyTime(((LabelSystemPre)toDoList.get(0)).getModifyTime());
                thirdToDoPre.setModifyUserName(((LabelSystemPre)toDoList.get(0)).getModifyUserName());
                thirdToDoPre.setModifyUserId(((LabelSystemPre)toDoList.get(0)).getModifyUserId());
                this.labelSystemPreMapper.insert((Object)thirdToDoPre);
                thirdToDoID = thirdToDoPre.getId();
            }
            if (null == toDoID || null == thirdToDoID) continue;
            this.labelSystemSourceMapper.delBySystemId(thirdToDoID, ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            List systemSourceList = this.labelSystemSourceMapper.queryByCountDataId(systemPreTenant.getId(), ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
            if (CollectionUtils.isEmpty((Collection)systemSourceList)) continue;
            for (LabelSystemSource systemSource : systemSourceList) {
                systemSource.setSystemId(thirdToDoID);
                systemSource.setId(null);
                this.labelSystemSourceMapper.insert((Object)systemSource);
            }
            this.labelSystemSourceMapper.delBySystemId(toDoID, ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode());
        }
        List preSystemList = this.getInitData("", Constants.ClientTypeEnum.PC.getValue());
        List toDoListAll = preSystemList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(toDoListAll)) {
            return null;
        }
        LabelSystemPre systemPreAll = (LabelSystemPre)toDoListAll.get(0);
        systemPreAll.setName("\u5f85\u529e");
        systemPreAll.setValidStatus(Constants.VALID_STATUS_ENABLE);
        systemPreAll.setDataCategory(Constants.DataCategoryEnum.CATEGORY_CURRENCY.getVal());
        systemPreAll.setIsEnableTrue(Constants.IsEnableTrueNum.ENABLE_TRUE.getVal());
        systemPreAll.setIsUseData(Constants.IsUseDataNum.USE_DATA_FALSE.getVal());
        this.labelSystemPreMapper.updateById((Object)systemPreAll);
        return null;
    }

    public Page<BizObjAuthRelBatchSystemVo> pageListPre(List<Long> idList, AuthSystemLabelReq req) {
        LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
        String locale = LocaleContextHolder.getLocale().toString();
        if ("zh_TW".equals(locale)) {
            queryPreWrapper.like(StringUtils.isNotEmpty((CharSequence)req.getName()), LabelSystemPre::getNameTw, (Object)req.getName());
        } else {
            queryPreWrapper.like(StringUtils.isNotEmpty((CharSequence)req.getName()), LabelSystemPre::getName, (Object)req.getName());
        }
        queryPreWrapper.in(CollectionUtils.isNotEmpty(idList), LabelSystemPre::getId, idList);
        queryPreWrapper.last("ORDER BY cast(name as char character set gbk ) ASC,id desc");
        Page systemPrePage = (Page)this.labelSystemPreMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)queryPreWrapper);
        ArrayList<BizObjAuthRelBatchSystemVo> relBatchSystemVoList = new ArrayList<BizObjAuthRelBatchSystemVo>();
        Page relBatchSystemVoPage = new Page();
        for (LabelSystemPre systemPre : systemPrePage.getRecords()) {
            BizObjAuthRelBatchSystemVo systemVo = new BizObjAuthRelBatchSystemVo();
            systemVo.setLabelId(systemPre.getId());
            if ("zh_TW".equals(locale) && StringUtils.isNotEmpty((CharSequence)systemPre.getNameTw())) {
                systemVo.setLabelName(systemPre.getNameTw());
            }
            systemVo.setLabelName(systemPre.getName());
            systemVo.setLabelType(Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
            relBatchSystemVoList.add(systemVo);
        }
        relBatchSystemVoPage.setRecords(relBatchSystemVoList);
        relBatchSystemVoPage.setTotal(systemPrePage.getTotal());
        return relBatchSystemVoPage;
    }

    public LabelSystemPreCustomVo queryAllSystemLabel(LabelSystemAllVo req) {
        List preLabelList;
        List labelSystemCustoms;
        String tenantVersion = this.kmService.queryTenantVersion();
        LabelSystemPreCustomVo preCustomVo = new LabelSystemPreCustomVo();
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        HashSet<String> tenantIds = new HashSet<String>(Arrays.asList(tenantId, "SYSTEM_TENANT"));
        tenantIds.remove("SYSTEM_TENANT");
        List customList = this.labelSystemPreMapper.queryCustomSystem(tenantIds, req.getName(), req.getDataCategoryList(), req.getClientType());
        for (LabelSystemAllVo labelSystemAllVo : customList) {
            labelSystemAllVo.setLabelTypeSource(Integer.valueOf(0));
        }
        preCustomVo.setCustomList(customList);
        ArrayList<LabelSystemAllVo> isvcustomList = new ArrayList<LabelSystemAllVo>();
        Set ids = this.getLableSysTemCustomIds(tenantVersion, req.getClientType());
        if (CollectionUtils.isNotEmpty((Collection)ids) && CollectionUtils.isNotEmpty((Collection)(labelSystemCustoms = this.labelSystemCustomMapper.selectBatchIds((Collection)ids)))) {
            for (LabelSystemCustom labelSystemCustom : labelSystemCustoms) {
                LabelSystemAllVo labelSystemAllVo = new LabelSystemAllVo();
                labelSystemAllVo.setId(labelSystemCustom.getComponentDesignerId());
                labelSystemAllVo.setName(labelSystemCustom.getNameZh());
                labelSystemAllVo.setDataCategory(labelSystemCustom.getDataCategory());
                labelSystemAllVo.setDataType(null);
                labelSystemAllVo.setClientType(labelSystemCustom.getClientType());
                labelSystemAllVo.setClassicsIcon(labelSystemCustom.getClassicsIcon());
                labelSystemAllVo.setIcon(labelSystemCustom.getIcon());
                labelSystemAllVo.setContentType(Integer.valueOf(0));
                labelSystemAllVo.setContentConfig(labelSystemCustom.getContentConfig());
                labelSystemAllVo.setModifyTime(labelSystemCustom.getModifyTime());
                labelSystemAllVo.setLabelTypeSource(Integer.valueOf(1));
                isvcustomList.add(labelSystemAllVo);
            }
        }
        preCustomVo.setIsvList(isvcustomList);
        ArrayList<LabelSystemAllVo> allCustomList = new ArrayList<LabelSystemAllVo>();
        if (CollectionUtils.isNotEmpty((Collection)preCustomVo.getCustomList())) {
            allCustomList.addAll(preCustomVo.getCustomList());
        }
        if (CollectionUtils.isNotEmpty((Collection)preCustomVo.getIsvList())) {
            allCustomList.addAll(isvcustomList);
        }
        preCustomVo.setAllCustomList(allCustomList);
        String locale = LocaleContextHolder.getLocale().toString();
        if ("zh_TW".equals(locale)) {
            preLabelList = this.labelSystemPreMapper.queryPreSystem(tenantId, null, req.getName(), req.getPreDateTypeList(), req.getClientType());
            preLabelList.forEach(item -> {
                if (StringUtils.isNotEmpty((CharSequence)item.getNameTw())) {
                    item.setName(item.getNameTw());
                }
            });
        } else {
            preLabelList = this.labelSystemPreMapper.queryPreSystem(tenantId, req.getName(), null, req.getPreDateTypeList(), req.getClientType());
        }
        preCustomVo.setPresetList(preLabelList);
        return preCustomVo;
    }

    private Set<Long> getLableSysTemCustomIds(String tenantVersion, Integer clientType) {
        List isddds = this.relatedAppServiceWrapper.queryCurrTenantPortalList(tenantVersion);
        if (CollectionUtils.isEmpty((Collection)isddds)) {
            return Collections.emptySet();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(PortalInfo::getVersion, (Object)tenantVersion)).in(CollectionUtils.isNotEmpty((Collection)isddds), PortalInfo::getPortalDesignerId, (Collection)isddds);
        queryWrapper.eq(PortalInfo::getClientType, (Object)clientType);
        List portalInfoList = (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.selectList((Wrapper)queryWrapper));
        ArrayList<Long> portalIds = new ArrayList<Long>();
        for (PortalInfo portalInfo : portalInfoList) {
            Long id = portalInfo.getId();
            portalIds.add(id);
        }
        if (CollectionUtils.isEmpty(portalIds)) {
            return Collections.emptySet();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (Objects.equals(0, clientType)) {
            lambdaQueryWrapper.in(PortalInfoContent::getContentType, new Object[]{0});
        } else {
            lambdaQueryWrapper.in(PortalInfoContent::getContentType, new Object[]{11});
        }
        ((LambdaQueryWrapper)lambdaQueryWrapper.in(PortalInfoContent::getLabelTypeSource, new Object[]{1})).in(CollectionUtils.isNotEmpty(portalIds), PortalInfoContent::getPortalId, portalIds);
        List portalInfoContents = (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoContentMapper.selectList((Wrapper)lambdaQueryWrapper));
        ArrayList<Long> contentIds = new ArrayList<Long>();
        for (PortalInfoContent portalInfoContent : portalInfoContents) {
            Long contentId = portalInfoContent.getContentId();
            contentIds.add(contentId);
        }
        if (CollectionUtils.isEmpty(contentIds)) {
            return Collections.emptySet();
        }
        LambdaQueryWrapper labelSystemCustomLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)labelSystemCustomLambdaQueryWrapper.in(CollectionUtils.isNotEmpty(contentIds), LabelSystemCustom::getComponentDesignerId, contentIds)).eq(LabelSystemCustom::getVersion, (Object)tenantVersion);
        List labelSystemCustoms = this.labelSystemCustomMapper.selectList((Wrapper)labelSystemCustomLambdaQueryWrapper);
        Set<Long> collect = labelSystemCustoms.stream().map(e -> e.getId()).collect(Collectors.toSet());
        return collect;
    }

    static /* synthetic */ Converter access$000(LabelSystemPreServiceImpl x0) {
        return x0.converter;
    }
}

