/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.SaveSystemReq;
import com.digiwin.athena.semc.entity.portal.LabelSystem;
import com.digiwin.athena.semc.mapper.portal.LabelSystemMapper;
import com.digiwin.athena.semc.service.portal.ILabelSystemService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LabelSystemServiceImpl
extends ServiceImpl<LabelSystemMapper, LabelSystem>
implements ILabelSystemService {
    @Autowired
    LabelSystemMapper labelSystemMapper;

    @Transactional
    public Long saveLabelSystem(SaveSystemReq saveSystemReq) {
        List updateSystemList;
        List addSystemList;
        List delSystemList = saveSystemReq.getDelSystemList();
        if (CollectionUtils.isNotEmpty((Collection)delSystemList)) {
            List idList = delSystemList.stream().map(SaveSystemReq.SystemReq::getId).collect(Collectors.toList());
            this.labelSystemMapper.deleteBatchIds(idList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(addSystemList = saveSystemReq.getAddSystemList()))) {
            ArrayList systemList = Lists.newArrayList();
            addSystemList.forEach(x -> {
                LabelSystem labelSystem = new LabelSystem();
                labelSystem.setLabelId(saveSystemReq.getLabelId());
                labelSystem.setTabFlag(saveSystemReq.getTabFlag());
                labelSystem.setTabName(Constants.SystemTabEnum.parseNameByCode((String)saveSystemReq.getTabFlag()));
                labelSystem.setMiddleSystemName(x.getMiddleSystemName());
                labelSystem.setMiddleSystemUid(x.getMiddleSystemUid());
                labelSystem.setSystemName(x.getSystemName());
                systemList.add(labelSystem);
            });
            this.saveBatch((Collection)systemList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(updateSystemList = saveSystemReq.getUpdateSystemList()))) {
            ArrayList systemList = Lists.newArrayList();
            updateSystemList.forEach(x -> {
                LabelSystem labelSystem = new LabelSystem();
                labelSystem.setId(x.getId());
                labelSystem.setMiddleSystemName(x.getMiddleSystemName());
                labelSystem.setMiddleSystemUid(x.getMiddleSystemUid());
                labelSystem.setSystemName(x.getSystemName());
                systemList.add(labelSystem);
            });
            this.updateBatchById((Collection)systemList);
        }
        return saveSystemReq.getLabelId();
    }

    public List<LabelSystem> querySystemList(Long labelId, String tabFlag) {
        QueryWrapper condition = new QueryWrapper();
        if (labelId != null) {
            condition.eq((Object)"label_id", (Object)labelId);
        }
        if (StringUtils.isNotBlank((CharSequence)tabFlag)) {
            condition.eq((Object)"tab_flag", (Object)tabFlag);
        }
        return this.labelSystemMapper.selectList((Wrapper)condition);
    }
}

