/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.mapper.portal.LabelSystemSourceMapper;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.LabelSystemSourceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelSystemSourceServiceImpl
extends ServiceImpl<LabelSystemSourceMapper, LabelSystemSource>
implements LabelSystemSourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelSystemSourceServiceImpl.class);
    @Autowired
    LabelSystemSourceMapper labelSystemSourceMapper;
    @Autowired
    LabelSystemPreService labelSystemPreService;

    public List<Long> selectBySystem(Long systemId, Integer componentSource) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(systemId != null, LabelSystemSource::getSystemId, (Object)systemId);
        queryWrapper.eq(componentSource != null, LabelSystemSource::getComponentSource, (Object)componentSource);
        queryWrapper.select(new SFunction[]{LabelSystemSource::getDataId});
        List systemSourceList = this.labelSystemSourceMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)systemSourceList)) {
            return new ArrayList<Long>();
        }
        List<Long> dataIdList = systemSourceList.stream().map(LabelSystemSource::getDataId).distinct().collect(Collectors.toList());
        return dataIdList;
    }

    public List<Long> selectPreSystem(Integer dataType, Integer componentSource) {
        LabelSystemPre systemPre = this.labelSystemPreService.getPreSystemID(dataType);
        if (null == systemPre) {
            return new ArrayList<Long>();
        }
        return this.selectBySystem(systemPre.getId(), componentSource);
    }
}

