/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.AddLogoReq;
import com.digiwin.athena.semc.dto.portal.LogoReq;
import com.digiwin.athena.semc.entity.common.PlatformConfig;
import com.digiwin.athena.semc.entity.portal.Logo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.common.PlatformConfigMapper;
import com.digiwin.athena.semc.mapper.portal.LogoMapper;
import com.digiwin.athena.semc.service.portal.ILogoService;
import io.github.linpeilie.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogoServiceImpl
extends ServiceImpl<LogoMapper, Logo>
implements ILogoService {
    @Autowired
    LogoMapper logoMapper;
    @Autowired
    PlatformConfigMapper platformConfigMapper;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private Converter converter;

    public int addLogoPic(AddLogoReq req) {
        Logo logo = new Logo();
        logo.setPicUrl(req.getPicUrl());
        return this.logoMapper.insert((Object)logo);
    }

    public String queryLogoByCondition(Integer sceneFlag) {
        Logo logo = new Logo();
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"scene_flag", (Object)sceneFlag);
        List logoList = this.logoMapper.selectList((Wrapper)condition);
        if (CollectionUtils.isEmpty((Collection)logoList)) {
            return "";
        }
        if (sceneFlag.equals(Constants.SceneFlagEnum.LOGIN_BEFORE_PAGE.getFlag())) {
            logo = (Logo)logoList.get(0);
        } else if (sceneFlag.equals(Constants.SceneFlagEnum.LOGIN_AFTER_PAGE.getFlag())) {
            boolean noTenantFlag = logoList.stream().allMatch(x -> StringUtils.isBlank((CharSequence)x.getTenantId()));
            if (noTenantFlag) {
                logo = (Logo)logoList.get(0);
            } else {
                String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
                List tempLogoList = logoList.stream().filter(x -> tenantId.equals(x.getTenantId())).collect(Collectors.toList());
                logo = (Logo)tempLogoList.get(0);
            }
        }
        String locale = LocaleContextHolder.getLocale().toString();
        if (StringUtils.isBlank((CharSequence)locale) || locale.equals("zh_CN")) {
            return logo.getPicUrl();
        }
        if (locale.equals("zh_TW")) {
            return logo.getPicUrlTw();
        }
        return logo.getPicUrlUs();
    }

    @Transactional
    public int saveSett(LogoReq req) {
        List logoList = this.selectByParam(new ArrayList(), AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), this.getIsShowSet());
        if (CollectionUtils.isNotEmpty((Collection)logoList)) {
            List logoIdList = logoList.stream().map(Logo::getId).collect(Collectors.toList());
            this.logoMapper.deleteBatchIds(logoIdList);
        }
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Logo homeLogo = (Logo)this.converter.convert((Object)req, Logo.class);
        homeLogo.setPicUrl(req.getLoginPicId());
        homeLogo.setPicUrlTw(req.getLoginPicIdTw());
        homeLogo.setPicUrlUs(req.getLoginPicIdUs());
        homeLogo.setTenantId(tenantId);
        homeLogo.setSceneFlag(Constants.SceneFlagEnum.LOGIN_AFTER_LOGO.getFlag());
        this.logoMapper.insert((Object)homeLogo);
        Logo titleLogo = (Logo)this.converter.convert((Object)req, Logo.class);
        titleLogo.setPicUrl(req.getTitlePicId());
        titleLogo.setPicUrlTw(req.getTitlePicIdTw());
        titleLogo.setPicUrlUs(req.getTitlePicIdUs());
        titleLogo.setTenantId(tenantId);
        titleLogo.setSceneFlag(Constants.SceneFlagEnum.LOGIN_AFTER_TITLE.getFlag());
        this.logoMapper.insert((Object)titleLogo);
        return 0;
    }

    public LogoReq getSett() {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        List logoList = this.selectByParam(new ArrayList(), tenantId, this.getIsShowSet());
        LogoReq logoReq = new LogoReq();
        if (CollectionUtils.isEmpty((Collection)logoList)) {
            logoList = this.selectDefSett();
        }
        if (CollectionUtils.isEmpty((Collection)logoList)) {
            return logoReq;
        }
        for (Logo logo : logoList) {
            String logoFileUrl = StringUtils.isEmpty((CharSequence)logo.getPicUrl()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + logo.getPicUrl();
            String loginPicUrlTw = StringUtils.isEmpty((CharSequence)logo.getPicUrlTw()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + logo.getPicUrlTw();
            String loginPicUrlUs = StringUtils.isEmpty((CharSequence)logo.getPicUrlUs()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + logo.getPicUrlUs();
            String logoPicId = logo.getPicUrl();
            String logoPicIdTw = logo.getPicUrlTw();
            String logoPicIdUs = logo.getPicUrlUs();
            if (logo.getSceneFlag().equals(Constants.SceneFlagEnum.LOGIN_AFTER_LOGO.getFlag())) {
                logoReq.setLoginPicId(logoPicId);
                logoReq.setLoginPicIdTw(logoPicIdTw);
                logoReq.setLoginPicIdUs(logoPicIdUs);
                logoReq.setLoginPicUrl(logoFileUrl);
                logoReq.setLoginPicUrlTw(loginPicUrlTw);
                logoReq.setLoginPicUrlUs(loginPicUrlUs);
                logoReq.setJumpStatus(logo.getJumpStatus());
                logoReq.setJumpStatusTw(logo.getJumpStatusTw());
                logoReq.setJumpStatusUs(logo.getJumpStatusUs());
                logoReq.setWebSiteAddr(logo.getWebSiteAddr());
                logoReq.setWebSiteAddrTw(logo.getWebSiteAddrTw());
                logoReq.setWebSiteAddrUs(logo.getWebSiteAddrUs());
            }
            if (!logo.getSceneFlag().equals(Constants.SceneFlagEnum.LOGIN_AFTER_TITLE.getFlag())) continue;
            logoReq.setTitlePicId(logoPicId);
            logoReq.setTitlePicIdTw(logoPicIdTw);
            logoReq.setTitlePicIdUs(logoPicIdUs);
            logoReq.setTitlePicUrl(logoFileUrl);
            logoReq.setTitlePicUrlTw(loginPicUrlTw);
            logoReq.setTitlePicUrlUs(loginPicUrlUs);
            logoReq.setTitle(logo.getTitle());
            logoReq.setTitleTw(logo.getTitleTw());
            logoReq.setTitleUs(logo.getTitleUs());
        }
        return logoReq;
    }

    public LogoReq querySettInfo() {
        String locale = LocaleContextHolder.getLocale().toString();
        LogoReq logoReq = this.getSett();
        if (StringUtils.isBlank((CharSequence)locale) || locale.equals("zh_CN")) {
            return logoReq;
        }
        if (locale.equals("zh_TW")) {
            logoReq.setJumpStatus(logoReq.getJumpStatusTw());
            logoReq.setWebSiteAddr(logoReq.getWebSiteAddrTw());
            logoReq.setTitle(logoReq.getTitleTw());
            logoReq.setLoginPicUrl(logoReq.getLoginPicUrlTw());
            logoReq.setTitlePicUrl(logoReq.getTitlePicUrlTw());
        } else {
            logoReq.setJumpStatus(logoReq.getJumpStatusUs());
            logoReq.setWebSiteAddr(logoReq.getWebSiteAddrUs());
            logoReq.setTitle(logoReq.getTitleUs());
            logoReq.setLoginPicUrl(logoReq.getLoginPicUrlUs());
            logoReq.setTitlePicUrl(logoReq.getTitlePicUrlUs());
        }
        return logoReq;
    }

    public String getIsShowSet() {
        String channel = Constants.ChannelEnum.GROUND.getVal();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_show_set_log", (Object)Constants.SystemFlagEnum.DEFAULT);
        List platformConfigList = this.platformConfigMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)platformConfigList)) {
            channel = ((PlatformConfig)platformConfigList.get(0)).getChannel();
        }
        return channel;
    }

    public PlatformConfig getPlatformConfig(String channel) {
        if (StringUtils.isEmpty((CharSequence)channel)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"channel", (Object)channel);
        PlatformConfig platformConfig = (PlatformConfig)this.platformConfigMapper.selectOne((Wrapper)queryWrapper);
        return platformConfig;
    }

    public LogoReq queryLoginLogo(String locale, String channel) {
        ArrayList<Integer> sceneFlagList = new ArrayList<Integer>();
        sceneFlagList.add(Constants.SceneFlagEnum.HOME_LOGIN_LOGO.getFlag());
        sceneFlagList.add(Constants.SceneFlagEnum.HOME_LOGIN_TITLE_LOGO.getFlag());
        if (StringUtils.isEmpty((CharSequence)channel)) {
            channel = Constants.ChannelEnum.PLATFORM.getVal();
        }
        List logoList = this.selectByParam(sceneFlagList, "", channel);
        LogoReq logoReq = new LogoReq();
        if (CollectionUtils.isEmpty((Collection)logoList)) {
            return logoReq;
        }
        for (Logo logo : logoList) {
            String loginPicUrlUs;
            String logoFileUrl = StringUtils.isEmpty((CharSequence)logo.getPicUrl()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + logo.getPicUrl();
            String loginPicUrlTw = StringUtils.isEmpty((CharSequence)logo.getPicUrlTw()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + logo.getPicUrlTw();
            String string = loginPicUrlUs = StringUtils.isEmpty((CharSequence)logo.getPicUrlUs()) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + logo.getPicUrlUs();
            if (logo.getSceneFlag().equals(Constants.SceneFlagEnum.HOME_LOGIN_LOGO.getFlag())) {
                logoReq.setLoginPicUrl(logoFileUrl);
                logoReq.setLoginPicUrlTw(loginPicUrlTw);
                logoReq.setLoginPicUrlUs(loginPicUrlUs);
            }
            if (!logo.getSceneFlag().equals(Constants.SceneFlagEnum.HOME_LOGIN_TITLE_LOGO.getFlag())) continue;
            logoReq.setTitlePicUrl(logoFileUrl);
            logoReq.setTitlePicUrlTw(loginPicUrlTw);
            logoReq.setTitlePicUrlUs(loginPicUrlUs);
            logoReq.setTitle(logo.getTitle());
            logoReq.setTitleTw(logo.getTitleTw());
            logoReq.setTitleUs(logo.getTitleUs());
        }
        if (StringUtils.isNotEmpty((CharSequence)locale) && locale.equals("zh_TW")) {
            logoReq.setTitlePicUrl(logoReq.getTitlePicUrlTw());
            logoReq.setLoginPicUrl(logoReq.getLoginPicUrlTw());
            logoReq.setTitle(logoReq.getTitleTw());
        } else if (StringUtils.isNotEmpty((CharSequence)locale) && locale.equals("en_US")) {
            logoReq.setTitlePicUrl(logoReq.getTitlePicUrlUs());
            logoReq.setLoginPicUrl(logoReq.getLoginPicUrlUs());
            logoReq.setTitle(logoReq.getTitleUs());
        }
        return logoReq;
    }

    public List<Logo> selectDefSett() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"scene_flag", (Object)Constants.SceneFlagEnum.LOGIN_AFTER_TITLE.getFlag());
        queryWrapper.isNull((Object)"tenant_id");
        List logoList = this.logoMapper.selectList((Wrapper)queryWrapper);
        return logoList;
    }

    public List<Logo> selectByParam(List<Integer> sceneFlagList, String tenantId, String channel) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isEmpty(sceneFlagList)) {
            sceneFlagList.add(Constants.SceneFlagEnum.LOGIN_AFTER_TITLE.getFlag());
            sceneFlagList.add(Constants.SceneFlagEnum.LOGIN_AFTER_LOGO.getFlag());
        }
        queryWrapper.in((Object)"scene_flag", sceneFlagList);
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        }
        if (StringUtils.isNotEmpty((CharSequence)channel)) {
            queryWrapper.eq((Object)"channel", (Object)channel);
        }
        List logoList = this.logoMapper.selectList((Wrapper)queryWrapper);
        return logoList;
    }
}

