/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.athena.appcore.util.Md5Utils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingDeleteReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingReq;
import com.digiwin.athena.semc.dto.message.EmailCompanyMappingSaveOrUpdateReq;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.message.EmailCompanyMapping;
import com.digiwin.athena.semc.mapper.message.EmailCompanyMappingMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.service.portal.MessageEmailConfigService;
import io.github.linpeilie.Converter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MessageEmailConfigServiceImpl
implements MessageEmailConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageEmailConfigServiceImpl.class);
    @Resource
    IamService iamService;
    @Resource
    RestTemplate restTemplate;
    @Resource
    EmailCompanyMappingMapper emailCompanyMappingMapper;
    @Resource
    private Converter converter;

    public ResponseEntity<?> listMailMessageConfig(EmailCompanyMappingReq emailCompanyMappingReq) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotEmpty((CharSequence)emailCompanyMappingReq.getCompanyName()), EmailCompanyMapping::getCompanyName, (Object)emailCompanyMappingReq.getCompanyName());
        List listMailMessageConfig = this.emailCompanyMappingMapper.selectList((Wrapper)queryWrapper);
        return ResponseEntityWrapper.wrapperOk(listMailMessageConfig.stream().sorted(Comparator.comparing(BaseEntity::getModifyTime).reversed()).collect(Collectors.toList()));
    }

    public ResponseEntity<?> saveOrUpdate(EmailCompanyMappingSaveOrUpdateReq saveReq) {
        List listMailMessageConfig = this.emailCompanyMappingMapper.selectList((Wrapper)new LambdaQueryWrapper());
        EmailCompanyMapping emailCompanyMappings = (EmailCompanyMapping)this.converter.convert((Object)saveReq, EmailCompanyMapping.class);
        if (ObjectUtils.isEmpty((Object)saveReq.getId())) {
            for (EmailCompanyMapping emailCompanyMapping : listMailMessageConfig) {
                if (emailCompanyMapping.getCompanyName().equals(saveReq.getCompanyName())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.COMPANY_NAME_REPEAT, (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u53ef\u91cd\u540d!");
                }
                if (emailCompanyMapping.getEmailSuffix().equals(saveReq.getEmailSuffix())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.EMAIL_SUFFIX, (String)"\u90ae\u7bb1\u540e\u7f00\u4e0d\u53ef\u91cd\u540d!");
                }
                if (emailCompanyMapping.getCorpId().equals(saveReq.getCorpId())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.CORP_ID, (String)"corpid\u4e0d\u53ef\u91cd\u540d!");
                }
                if (!emailCompanyMapping.getCorpSecret().equals(saveReq.getCorpSecret())) continue;
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.CORP_SECRET, (String)"corpsecret\u4e0d\u53ef\u91cd\u540d!");
            }
            if (listMailMessageConfig.size() == Constants.EMAIL_COUNT.intValue()) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.ZHIQI_EMAIL_COUNT, (String)"\u65b0\u5efa\u5931\u8d25,\u6700\u591a\u65b0\u5efa30\u6761!");
            }
            this.emailCompanyMappingMapper.insert((Object)emailCompanyMappings);
        } else {
            List listMailMessageConfigFilter = listMailMessageConfig.stream().filter(item -> !item.getId().equals(saveReq.getId())).collect(Collectors.toList());
            for (EmailCompanyMapping emailCompanyMapping : listMailMessageConfigFilter) {
                if (emailCompanyMapping.getCompanyName().equals(saveReq.getCompanyName())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.COMPANY_NAME_REPEAT, (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u53ef\u91cd\u540d!");
                }
                if (emailCompanyMapping.getEmailSuffix().equals(saveReq.getEmailSuffix())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.EMAIL_SUFFIX, (String)"\u90ae\u7bb1\u540e\u7f00\u4e0d\u53ef\u91cd\u540d!");
                }
                if (emailCompanyMapping.getCorpId().equals(saveReq.getCorpId())) {
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.CORP_ID, (String)"corpid\u4e0d\u53ef\u91cd\u540d!");
                }
                if (!emailCompanyMapping.getCorpSecret().equals(saveReq.getCorpSecret())) continue;
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.CORP_SECRET, (String)"corpsecret\u4e0d\u53ef\u91cd\u540d!");
            }
            this.emailCompanyMappingMapper.updateById((Object)emailCompanyMappings);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> delete(EmailCompanyMappingDeleteReq deleteReq) {
        return ResponseEntityWrapper.wrapperOk((Object)this.emailCompanyMappingMapper.deleteBatchIds((Collection)deleteReq.getIdList()));
    }

    public ResponseEntity<?> getUnreadCount() {
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(EmailCompanyMapping::getEmailSuffix, this.iamService.getIamEmail().get(1));
            EmailCompanyMapping emailCompanyMapping = (EmailCompanyMapping)this.emailCompanyMappingMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtils.isEmpty((Object)emailCompanyMapping)) {
                return ResponseEntityWrapper.wrapperOk((Object)0);
            }
            String token = null;
            String uuid = UUID.randomUUID().toString();
            long ts = System.currentTimeMillis();
            String sign = Md5Utils.encodeMd5((String)(emailCompanyMapping.getCorpId() + "_" + uuid + "_" + ts + "_" + emailCompanyMapping.getCorpSecret())).toLowerCase();
            String urlToken = "http://open.global-mail.cn/token?corpId=" + emailCompanyMapping.getCorpId() + "&uuid=" + uuid + "&ts=" + ts + "&sign=" + sign;
            HashMap<String, String> mapToken = new HashMap<String, String>();
            mapToken.put("corp_id", emailCompanyMapping.getCorpId());
            mapToken.put("secret", emailCompanyMapping.getCorpSecret());
            HttpEntity requestEntity = new HttpEntity(mapToken, (MultiValueMap)new HttpHeaders());
            ResponseEntity response = this.restTemplate.exchange(urlToken, HttpMethod.GET, requestEntity, Map.class, new Object[0]);
            if (null != response.getBody()) {
                Map map = (Map)((Map)response.getBody()).get("data");
                token = map.get("accessToken").toString();
                log.info("\u83b7\u53d6\u5230\u7684token, token:{}", (Object)token);
            }
            HashMap mapBody = new HashMap();
            mapBody.put("username", this.iamService.getIamEmail().get(0));
            String signs = Md5Utils.encodeMd5((String)(JSON.toJSONString(mapBody) + "_" + emailCompanyMapping.getCorpId() + "_" + uuid + "_" + ts + "_" + token + "_" + emailCompanyMapping.getCorpSecret())).toLowerCase();
            String url = "http://open.global-mail.cn/api/mailbox/getUnreadSumOfInbox?access_token=" + token + "&corpid=" + emailCompanyMapping.getCorpId() + "&uuid=" + uuid + "&ts=" + ts + "&sign=" + signs;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity(mapBody, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, Map.class, new Object[0]);
            log.info("\u83b7\u53d6\u5230\u7684 resp:{}", (Object)JSON.toJSONString((Object)responseEntity.getBody()));
            if (null == responseEntity.getBody()) {
                return ResponseEntityWrapper.wrapperOk((Object)0);
            }
            Map map = (Map)((Map)responseEntity.getBody()).get("data");
            if (null == map) {
                return ResponseEntityWrapper.wrapperOk((Object)0);
            }
            log.info("\u83b7\u53d6\u5230\u7684\u672a\u8bfb\u90ae\u4ef6\u6570, sum:{}", (Object)map.get("sum").toString());
            return ResponseEntityWrapper.wrapperOk((Object)map.get("sum").toString());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u672a\u8bfb\u90ae\u4ef6\u6570\u9519\u8bef", (Throwable)e);
            return ResponseEntityWrapper.wrapperOk((Object)0);
        }
    }
}

