/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.common.enums.IfNotIntegerEnum;
import com.digiwin.athena.semc.common.enums.SourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.NewsPageQueryResp;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryReq;
import com.digiwin.athena.semc.entity.portal.News;
import com.digiwin.athena.semc.mapper.portal.NewsMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.NewsService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsServiceImpl
extends ServiceImpl<NewsMapper, News>
implements NewsService {
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Resource
    private ESPService espService;
    @Autowired
    TripartiteService tripartiteService;

    public List<News> handleEspResult(Map<String, Object> result, NoticePageQueryReq.EaiSysInfo eaiSysInfo, NewsPageQueryResp newsPageQueryResp, String qryCondition) {
        Object espNewsList = result.get("news_list");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"app_name", (Object)eaiSysInfo.getAppName());
        queryWrapper.eq((Object)"news_user", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        ArrayList filteredNewsList = Lists.newArrayList();
        if (Objects.isNull(espNewsList)) {
            newsPageQueryResp.setRed(false);
            newsPageQueryResp.setTotalUnreadCount(Integer.valueOf(0));
            newsPageQueryResp.setTotalResults(Integer.valueOf(0));
        } else {
            Integer totalResults = result.get("total_results") == null ? 0 : Integer.parseInt(result.get("total_results").toString());
            newsPageQueryResp.setTotalResults(totalResults);
            List existNewsList = this.list((Wrapper)queryWrapper);
            Map<Object, Object> existsNewsMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)existNewsList)) {
                existsNewsMap = existNewsList.stream().collect(Collectors.toMap(News::getExternalNewsId, a -> a, (k1, k2) -> k1));
            }
            ArrayList insertNewsList = Lists.newArrayList();
            JSONArray array = JSONArray.fromObject((Object)espNewsList);
            for (Object json : array) {
                News news = (News)JSONObject.parseObject((String)json.toString(), News.class);
                if (existsNewsMap.containsKey(news.getExternalNewsId())) {
                    BeanUtils.copyProperties((Object)existsNewsMap.get(news.getExternalNewsId()), (Object)news);
                    news.setIsNew(IfNotIntegerEnum.NO.getValue());
                } else {
                    news.setNewsSource(SourceEnum.EXTERNAL.getSource());
                    news.setAppName(eaiSysInfo.getAppName());
                    news.setNewsUser(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    news.setIsRead(IfNotIntegerEnum.NO.getValue());
                    news.setIsNew(IfNotIntegerEnum.YES.getValue());
                    insertNewsList.add(news);
                }
                if (IfNotIntegerEnum.NO.getValue().equals(news.getIsRead())) {
                    newsPageQueryResp.setRed(true);
                    newsPageQueryResp.setTotalUnreadCount(Integer.valueOf(newsPageQueryResp.getTotalUnreadCount() + 1));
                }
                if (StringUtils.isEmpty((CharSequence)qryCondition) || StringUtils.isNotEmpty((CharSequence)qryCondition) && news.getNewsTitle().contains(qryCondition)) {
                    filteredNewsList.add(news);
                }
                news.setEaiSysName(eaiSysInfo.getEaiSysName());
                news.setEaiSysUid(eaiSysInfo.getEaiSysUid());
                news.setAppToken(eaiSysInfo.getAppToken());
                news.setAppName(eaiSysInfo.getAppName());
            }
            if (CollectionUtils.isNotEmpty((Collection)insertNewsList)) {
                this.saveBatch((Collection)insertNewsList);
            }
        }
        return filteredNewsList;
    }

    public ResultPageBean pageQueryNews(LabelSystemPreReq noticePageQueryReq) {
        LabelSystemDataDto labelSystemDataDto = this.labelSystemDataService.getSystemDataSso(noticePageQueryReq.getId());
        if (null == labelSystemDataDto) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728"));
        }
        Map result = Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemDataDto.getDataModel()) ? this.espService.queryByEsp(labelSystemDataDto.getMiddleSystemName(), labelSystemDataDto.getMiddleSystemUid(), EAIServiceNameEnum.NEWS.getServiceName(), null, null, noticePageQueryReq.getQryCondition(), PageInfo.getPageInfo((Integer)noticePageQueryReq.getPageNum(), (Integer)noticePageQueryReq.getPageSize())) : this.tripartiteService.selectDataPagePost(labelSystemDataDto.getRestUrl(), noticePageQueryReq, labelSystemDataDto.getAppToken());
        NoticePageQueryReq.EaiSysInfo eaiSys = new NoticePageQueryReq.EaiSysInfo();
        eaiSys.setAppName(labelSystemDataDto.getAppCode());
        eaiSys.setAppToken(labelSystemDataDto.getAppToken());
        eaiSys.setUserBindFlag(labelSystemDataDto.getUserBindFlag());
        NewsPageQueryResp newsPageQueryResp = new NewsPageQueryResp();
        List newsList = this.handleEspResult(result, eaiSys, newsPageQueryResp, noticePageQueryReq.getQryCondition());
        newsList.forEach(x -> x.setNewsUrl(this.getNewsUrl(x, eaiSys, AppAuthContextHolder.getContext().getAuthoredUser(), labelSystemDataDto)));
        newsPageQueryResp.setNewsList(newsList);
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)newsPageQueryResp, (PageInfo)PageInfo.getPageInfo((Integer)noticePageQueryReq.getPageNum(), (Integer)noticePageQueryReq.getPageSize(), (Integer)newsPageQueryResp.getTotalResults())));
        return resultPageBean;
    }

    private String getNewsUrl(News news, NoticePageQueryReq.EaiSysInfo eaiSys, AuthoredUser user, LabelSystemDataDto labelSystemDataDto) {
        String tenantId = user.getTenantId();
        String newsUrl = null;
        if (labelSystemDataDto == null || 1 == labelSystemDataDto.getProtocolType()) {
            newsUrl = news.getNewsUrl() + (news.getNewsUrl().contains("?") ? "&" : "?") + "appToken=" + eaiSys.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + eaiSys.getUserBindFlag();
        }
        if (null != labelSystemDataDto && 2 == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemDataDto.getDataType())) {
            newsUrl = news.getNewsUrl();
        }
        if (null != labelSystemDataDto && 2 == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemDataDto.getDataType())) {
            newsUrl = labelSystemDataDto.getRestUrl();
        }
        return newsUrl;
    }
}

