/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.common.enums.IfNotIntegerEnum;
import com.digiwin.athena.semc.common.enums.SourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryReq;
import com.digiwin.athena.semc.dto.portal.NoticePageQueryResp;
import com.digiwin.athena.semc.entity.portal.Notice;
import com.digiwin.athena.semc.mapper.portal.NoticeMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.NoticeService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeServiceImpl
extends ServiceImpl<NoticeMapper, Notice>
implements NoticeService {
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Resource
    private ESPService espService;
    @Autowired
    TripartiteService tripartiteService;

    public List<Notice> handleEspResult(Map<String, Object> result, NoticePageQueryReq.EaiSysInfo eaiSysInfo, String qryCondition, NoticePageQueryResp noticePageQueryResp) {
        Object espNoticeList = result.get("notice_list");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"app_name", (Object)eaiSysInfo.getAppName());
        queryWrapper.eq((Object)"notice_user", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        queryWrapper.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        ArrayList filteredNoticeList = Lists.newArrayList();
        if (Objects.isNull(espNoticeList)) {
            noticePageQueryResp.setRed(false);
            noticePageQueryResp.setTotalUnreadCount(Integer.valueOf(0));
            noticePageQueryResp.setTotalResults(Integer.valueOf(0));
        } else {
            Integer totalResults = result.get("total_results") == null ? 0 : Integer.parseInt(result.get("total_results").toString());
            noticePageQueryResp.setTotalResults(totalResults);
            List existNoticeList = this.list((Wrapper)queryWrapper);
            Map<Object, Object> existNoticeMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)existNoticeList)) {
                existNoticeMap = existNoticeList.stream().collect(Collectors.toMap(Notice::getExternalNoticeId, a -> a, (k1, k2) -> k1));
            }
            ArrayList insertNoticeList = Lists.newArrayList();
            JSONArray array = JSONArray.fromObject((Object)espNoticeList);
            for (Object json : array) {
                Notice notice = (Notice)JSONObject.parseObject((String)json.toString(), Notice.class);
                if (existNoticeMap.containsKey(notice.getExternalNoticeId())) {
                    BeanUtils.copyProperties((Object)existNoticeMap.get(notice.getExternalNoticeId()), (Object)notice);
                    notice.setIsNew(IfNotIntegerEnum.NO.getValue());
                } else {
                    notice.setNoticeSource(SourceEnum.EXTERNAL.getSource());
                    notice.setAppName(eaiSysInfo.getAppName());
                    notice.setNoticeUser(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    notice.setIsRead(IfNotIntegerEnum.NO.getValue());
                    notice.setIsNew(IfNotIntegerEnum.YES.getValue());
                    insertNoticeList.add(notice);
                }
                if (IfNotIntegerEnum.NO.getValue().equals(notice.getIsRead())) {
                    noticePageQueryResp.setRed(true);
                    noticePageQueryResp.setTotalUnreadCount(Integer.valueOf(noticePageQueryResp.getTotalUnreadCount() + 1));
                }
                if (StringUtils.isEmpty((CharSequence)qryCondition) || StringUtils.isNotEmpty((CharSequence)qryCondition) && notice.getNoticeTitle().contains(qryCondition)) {
                    filteredNoticeList.add(notice);
                }
                notice.setEaiSysName(eaiSysInfo.getEaiSysName());
                notice.setEaiSysUid(eaiSysInfo.getEaiSysUid());
                notice.setAppToken(eaiSysInfo.getAppToken());
                notice.setAppName(eaiSysInfo.getAppName());
            }
            if (CollectionUtils.isNotEmpty((Collection)insertNoticeList)) {
                this.saveBatch((Collection)insertNoticeList);
            }
        }
        return filteredNoticeList;
    }

    public ResultPageBean pageQueryNotice(LabelSystemPreReq noticePageQueryReq) {
        LabelSystemDataDto labelSystemDataDto = this.labelSystemDataService.getSystemDataSso(noticePageQueryReq.getId());
        if (null == labelSystemDataDto) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728"));
        }
        HashMap<String, String> extHeader = new HashMap<String, String>();
        extHeader.put("digi-userToken", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        Map result = Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemDataDto.getDataModel()) ? this.espService.queryByEsp(labelSystemDataDto.getMiddleSystemName(), labelSystemDataDto.getMiddleSystemUid(), EAIServiceNameEnum.NOTICE.getServiceName(), extHeader, null, noticePageQueryReq.getQryCondition(), PageInfo.getPageInfo((Integer)noticePageQueryReq.getPageNum(), (Integer)noticePageQueryReq.getPageSize())) : this.tripartiteService.selectDataPagePost(labelSystemDataDto.getRestUrl(), noticePageQueryReq, labelSystemDataDto.getAppToken());
        NoticePageQueryReq.EaiSysInfo eaiSys = new NoticePageQueryReq.EaiSysInfo();
        eaiSys.setAppName(labelSystemDataDto.getAppCode());
        eaiSys.setAppToken(labelSystemDataDto.getAppToken());
        eaiSys.setUserBindFlag(labelSystemDataDto.getUserBindFlag());
        NoticePageQueryResp noticePageQueryResp = new NoticePageQueryResp();
        List noticeList = this.handleEspResult(result, eaiSys, noticePageQueryReq.getQryCondition(), noticePageQueryResp);
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        noticeList.forEach(x -> x.setNoticeUrl(x.getNoticeUrl() + (x.getNoticeUrl().contains("?") ? "&" : "?") + "appToken=" + eaiSys.getAppToken() + "&tenantId=" + tenantId + "&bindMode=" + eaiSys.getUserBindFlag()));
        noticePageQueryResp.setNoticeList(noticeList);
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)noticePageQueryResp, (PageInfo)PageInfo.getPageInfo((Integer)noticePageQueryReq.getPageNum(), (Integer)noticePageQueryReq.getPageSize(), (Integer)noticePageQueryResp.getTotalResults())));
        return resultPageBean;
    }
}

