/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.BizAuthTypeEnum;
import com.digiwin.athena.semc.common.enums.ComponentSourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.mobile.MobilePortalBusImageReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalBusinessInfoReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalContentCarousel;
import com.digiwin.athena.semc.dto.mobile.MobilePortalContentCarouselImage;
import com.digiwin.athena.semc.dto.mobile.MobilePortalContentNews;
import com.digiwin.athena.semc.dto.mobile.MobilePortalDividerInfoReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalImageInfoReqDTO;
import com.digiwin.athena.semc.dto.mobile.MobilePortalTitleInfoReqDTO;
import com.digiwin.athena.semc.dto.portal.AddUseRecordRequest;
import com.digiwin.athena.semc.dto.portal.PortalContentCarouselImage;
import com.digiwin.athena.semc.dto.portal.PortalInfoCheckResp;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.dto.portal.PortalSelectOptionRespDTO;
import com.digiwin.athena.semc.dto.portal.UserPortalInfoRequest;
import com.digiwin.athena.semc.dto.portal.WebLinkPermissionDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.common.PlatformInitConfig;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuWork;
import com.digiwin.athena.semc.entity.mobile.MobileApplicatonColumn;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoAuth;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoContent;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoUse;
import com.digiwin.athena.semc.entity.mobile.MobilePortalPreview;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.entity.portal.LabelSystemAuth;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.PortalContentCarousel;
import com.digiwin.athena.semc.entity.portal.PortalContentKingKongDistrict;
import com.digiwin.athena.semc.entity.portal.PortalContentKingKongDistrictBall;
import com.digiwin.athena.semc.entity.portal.PortalDeployMessage;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoAuth;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.portal.PortalInfoUse;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.common.PlatformInitConfigMapper;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuTemplateMapper;
import com.digiwin.athena.semc.mapper.menu.CustomizedMenuWorkMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileApplicatonColumnMapper;
import com.digiwin.athena.semc.mapper.mobile.MobileDatasourceInfoMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoAuthMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalInfoUseMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalPreviewMapper;
import com.digiwin.athena.semc.mapper.mobile.MobilePortalTypeUserMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemAuthMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemCustomMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoAuthMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoContentMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoMapper;
import com.digiwin.athena.semc.mapper.portal.PortalInfoUseMapper;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.menu.CustomizedMenuWorkService;
import com.digiwin.athena.semc.service.mobile.MobilePortalService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.news.NewsAnnouncementAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemAuthService;
import com.digiwin.athena.semc.service.portal.LabelSystemClickService;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.PortalDeployMessageService;
import com.digiwin.athena.semc.service.portal.PortalInfoService;
import com.digiwin.athena.semc.service.portal.RelatedAppServiceWrapper;
import com.digiwin.athena.semc.service.portal.WorkbenchImageService;
import com.digiwin.athena.semc.service.workbench.constant.PublishSourceEnum;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.InterceptorIgnoreUtil;
import com.digiwin.athena.semc.util.ResponseEntityWrapperUtil;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.menu.CustomizedMenuWorkResp;
import com.digiwin.athena.semc.vo.mobile.MobilePortalInfoContentResp;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthReq;
import com.digiwin.athena.semc.vo.portal.PortalInfoAuthResp;
import com.digiwin.athena.semc.vo.portal.PortalUserAuthResp;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PortalInfoServiceImpl
extends ServiceImpl<PortalInfoMapper, PortalInfo>
implements PortalInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalInfoServiceImpl.class);
    @Resource
    MessageUtils messageUtils;
    @Resource
    PortalInfoMapper portalInfoMapper;
    @Autowired
    MobilePortalInfoMapper mobilePortalInfoMapper;
    @Autowired
    MobilePortalPreviewMapper mobilePortalPreviewMapper;
    @Resource
    PortalInfoContentMapper portalInfoContentMapper;
    @Resource
    PortalInfoAuthMapper portalInfoAuthMapper;
    @Resource
    private EnvProperties envProperties;
    @Resource
    LabelSystemPreService labelSystemPreService;
    @Resource
    LabelSystemAuthService labelSystemAuthService;
    @Resource
    PortalInfoUseMapper portalInfoUseMapper;
    @Resource
    private TranslateService translateService;
    @Autowired
    LabelSystemPreMapper labelSystemPreMapper;
    @Autowired
    LabelSystemCustomMapper labelSystemCustomMapper;
    @Resource
    LabelSystemDataMapper labelSystemDataMapper;
    @Resource
    private MobileUserAuthService mobileUserAuthService;
    @Resource
    private PlatformInitConfigMapper platformInitConfigMapper;
    @Autowired
    LabelSystemAuthMapper labelSystemAuthMapper;
    @Resource
    private NewsAnnouncementAuthService newsAnnouncementAuthService;
    @Resource
    private MobilePortalService mobilePortalService;
    @Resource
    private Converter converter;
    @Autowired
    private KmService kmService;
    @Autowired
    private RelatedAppServiceWrapper relatedAppServiceWrapper;
    @Autowired
    private WorkbenchImageService workbenchImageService;
    @Autowired
    private MobilePortalInfoContentMapper mobilePortalInfoContentMapper;
    @Autowired
    private MobilePortalInfoAuthMapper mobilePortalInfoAuthMapper;
    @Resource
    private CustomizedMenuWorkService customizedMenuWorkService;
    @Resource
    private CustomizedMenuWorkMapper customizedMenuWorkMapper;
    @Resource
    private CustomizedMenuTemplateMapper customizedMenuTemplateMapper;
    @Resource
    private MobilePortalInfoUseMapper mobilePortalInfoUseMapper;
    @Autowired
    private MobilePortalTypeUserMapper mobilePortalTypeUserMapper;
    @Autowired
    private PortalDeployMessageService portalDeployMessageService;
    @Resource
    private MobileApplicatonColumnMapper applicatonColumnMapper;
    @Resource
    private MobileDatasourceInfoMapper mobileCustomApplicationMapper;
    @Resource
    private LabelSystemClickService labelSystemClickService;

    public List<PortalInfo> checkPortal(PortalInfo req) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"client_type", (Object)req.getClientType());
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.eq((Object)"name", (Object)req.getName());
        }
        if (null != req.getId()) {
            condition.ne((Object)"id", (Object)req.getId());
        }
        if (Constants.ClientTypeTypeEnum.MOBILE.getFlag().equals(req.getClientType()) && null != req.getPortalType()) {
            condition.eq((Object)"portal_type", (Object)req.getPortalType());
        }
        return this.portalInfoMapper.selectList((Wrapper)condition);
    }

    public boolean checkISVPortal(List<Long> portalIds) {
        return (Boolean)InterceptorIgnoreUtil.handler(() -> ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PortalInfo::getId, (Collection)portalIds)).eq(PortalInfo::getPublishSource, (Object)PublishSourceEnum.ISV.name())).exists());
    }

    @Transactional
    public Integer savePortal(PortalInfo req) {
        req.setModifyTime(DateUtils.getNowTime((String)""));
        req.setTenantId(Utils.getTenantId());
        req.setModifyUserName(Utils.getUserName());
        if (null == req.getStatus()) {
            req.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        }
        if (null == req.getId()) {
            req.setPublishSource(PublishSourceEnum.TENANT.name());
            req.setCreateTime(DateUtils.getNowTime((String)""));
            req.setCreateUserName(Utils.getUserName());
            this.portalInfoMapper.insert((Object)req);
        } else {
            this.portalInfoMapper.updateById((Object)req);
            PortalInfo dbPort = (PortalInfo)this.portalInfoMapper.selectById((Serializable)req.getId());
            req.setDefaultFlag(dbPort.getDefaultFlag());
        }
        this.delPortalContent(req.getId(), null);
        if (CollectionUtils.isNotEmpty((Collection)req.getContentList())) {
            this.savePortalContent(req);
        }
        return null;
    }

    public void savePortalContent(PortalInfo req) {
        if (null == req.getId()) {
            return;
        }
        if (1 == req.getClientType()) {
            this.savePortalContentForMobile(req);
            return;
        }
        for (PortalInfoContent content : req.getContentList()) {
            if (null != content.getDataType() && Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(content.getDataType()) && null != content.getCarouselInfo()) {
                content.setContentAttr(JSON.toJSONString((Object)content.getCarouselInfo()));
            }
            content.setPortalId(req.getId());
            content.setTenantId(req.getTenantId());
            this.portalInfoContentMapper.insert((Object)content);
        }
    }

    private void savePortalContentForMobile(PortalInfo req) {
        for (PortalInfoContent content : req.getContentList()) {
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            if (Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(content.getContentType())) {
                content.setContentAttr(JSON.toJSONString((Object)content.getContentConfig()));
            }
            content.setPortalId(req.getId());
            content.setTenantId(req.getTenantId());
            content.setParentId(Long.valueOf(0L));
            content.setId(null);
            this.portalInfoContentMapper.insert((Object)content);
        }
    }

    public void delPortalContent(Long portalId, List<Long> portalIdList) {
        QueryWrapper condition = new QueryWrapper();
        if (null != portalId) {
            condition.eq((Object)"portal_id", (Object)portalId);
        }
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in((Object)"portal_id", portalIdList);
        }
        InterceptorIgnoreUtil.handler(() -> this.portalInfoContentMapper.delete((Wrapper)condition));
    }

    public List<PortalInfoContent> selPortalContent(Long portalId) {
        QueryWrapper condition = new QueryWrapper();
        if (null != portalId) {
            condition.eq((Object)"portal_id", (Object)portalId);
        }
        return (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoContentMapper.selectList((Wrapper)condition));
    }

    public ResultPageBean pageQuery(PortalInfoQueryReq req) {
        List portalInfoList;
        String tenantVersion = this.kmService.queryTenantVersion();
        if (Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag().equals(req.getPortalType())) {
            portalInfoList = this.getListPortal(req);
            List listMobilePortalList = this.mobilePortalService.getListMobilePortal(req);
            for (Object mobilePortalInfo : listMobilePortalList) {
                PortalInfo pcPortalInfo = PortalInfoServiceImpl.mobilePortalConvertToPortal((MobilePortalInfo)mobilePortalInfo);
                portalInfoList.add(pcPortalInfo);
            }
        } else {
            this.initDefPortal(req.getClientType());
            req.setVersion(tenantVersion);
            portalInfoList = this.getListPortal(req);
            boolean flag = portalInfoList.stream().anyMatch(x -> PublishSourceEnum.ISV.name().equals(x.getPublishSource()));
            if (flag) {
                List desPortalIds = this.relatedAppServiceWrapper.queryCurrTenantPortalList(tenantVersion);
                portalInfoList.removeIf(portalInfo -> PublishSourceEnum.ISV.name().equals(portalInfo.getPublishSource()) && !desPortalIds.contains(portalInfo.getPortalDesignerId()));
                portalInfoList.forEach(x -> {
                    if (PublishSourceEnum.ISV.name().equals(x.getPublishSource())) {
                        x.setPortalTypeSource(Constants.LabelOrPoralSourceEnum.ISV.getFlag());
                    }
                });
            }
            if (Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
                List listMobilePortalList = this.mobilePortalService.getListMobilePortal(req);
                for (MobilePortalInfo mobilePortalInfo : listMobilePortalList) {
                    PortalInfo pcPortalInfo = PortalInfoServiceImpl.mobilePortalConvertToPortal((MobilePortalInfo)mobilePortalInfo);
                    portalInfoList.add(pcPortalInfo);
                }
            }
        }
        for (PortalInfo portalInfo2 : portalInfoList) {
            if (!StringUtils.isNotEmpty((CharSequence)portalInfo2.getPortalImgId())) continue;
            String portalImgUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + portalInfo2.getPortalImgId();
            portalInfo2.setPortalImgUrl(portalImgUrl);
        }
        List collect2 = portalInfoList.stream().filter(e -> PublishSourceEnum.ISV.name().equals(e.getPublishSource())).collect(Collectors.toList());
        Set collect = collect2.stream().map(e -> e.getPortalDesignerId()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(collect)) {
            LambdaQueryWrapper portalDeployMessageLambdaQueryWrapper = new LambdaQueryWrapper();
            LambdaQueryWrapper in = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)portalDeployMessageLambdaQueryWrapper.eq(PortalDeployMessage::getSource, (Object)1)).in(CollectionUtils.isNotEmpty(collect), PortalDeployMessage::getPortalId, collect)).eq(PortalDeployMessage::getVersion, (Object)tenantVersion)).eq(PortalDeployMessage::getUserSid, (Object)Utils.getUserSid())).eq(PortalDeployMessage::getClientType, (Object)req.getClientType());
            List portalDeployMessages = (List)InterceptorIgnoreUtil.handler(() -> this.portalDeployMessageService.getBaseMapper().selectList((Wrapper)in));
            if (CollectionUtils.isEmpty((Collection)portalDeployMessages)) {
                for (PortalInfo portalInfo3 : collect2) {
                    portalInfo3.setChanged(1);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)portalDeployMessages)) {
                Set collect1 = portalDeployMessages.stream().map(e -> e.getPortalId()).collect(Collectors.toSet());
                for (PortalInfo portalInfo4 : collect2) {
                    if (collect1.contains(portalInfo4.getPortalDesignerId())) continue;
                    portalInfo4.setChanged(1);
                }
            }
        }
        ResultPageBean resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance(portalInfoList.stream().skip((long)(req.getPageNum() - 1) * req.getPageSize().longValue()).limit(req.getPageSize().intValue()).collect(Collectors.toList()), (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)portalInfoList.size())));
        return resultPageBean;
    }

    private static PortalInfo mobilePortalConvertToPortal(MobilePortalInfo mobilePortalInfo) {
        PortalInfo pcPortalInfo = new PortalInfo();
        pcPortalInfo.setId(mobilePortalInfo.getId());
        pcPortalInfo.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        pcPortalInfo.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        pcPortalInfo.setPortalType(mobilePortalInfo.getPortalType());
        pcPortalInfo.setTitle(mobilePortalInfo.getTitle());
        pcPortalInfo.setBgColor(mobilePortalInfo.getBgColor());
        pcPortalInfo.setPortalDesignerId(null);
        pcPortalInfo.setWorkbenchAppCode(null);
        pcPortalInfo.setParentId(Long.valueOf(0L));
        pcPortalInfo.setTemplateId(null);
        pcPortalInfo.setDefaultFlag(mobilePortalInfo.getDefaultFlag());
        pcPortalInfo.setName(mobilePortalInfo.getName());
        pcPortalInfo.setPortalDesc(mobilePortalInfo.getPortalDesc());
        pcPortalInfo.setMenuTemplateId(null);
        pcPortalInfo.setStatus(mobilePortalInfo.getStatus());
        pcPortalInfo.setPortalContent(mobilePortalInfo.getPortalContent());
        pcPortalInfo.setPortalImgId(mobilePortalInfo.getPortalImgId());
        pcPortalInfo.setTenantId(mobilePortalInfo.getTenantId());
        pcPortalInfo.setCreateUserName(mobilePortalInfo.getName());
        pcPortalInfo.setCreateTime(mobilePortalInfo.getCreateTime());
        pcPortalInfo.setModifyUserName(mobilePortalInfo.getModifyUserName());
        pcPortalInfo.setModifyTime(mobilePortalInfo.getModifyTime());
        pcPortalInfo.setModifyUserId(mobilePortalInfo.getModifyUserId());
        pcPortalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
        pcPortalInfo.setOldPortalFlag(Boolean.TRUE);
        return pcPortalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortalInfo initDefPortal(Integer clientType) {
        RedisLock redisLock = new RedisLock(String.format("LOCK:TEMPLATENO:%s", Utils.getTenantId()));
        String tenantId = Utils.getTenantId();
        PortalInfo defPortalTent = (PortalInfo)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.queryTentDefPortal(tenantId, clientType));
        try {
            if (!redisLock.lock()) {
                return defPortalTent;
            }
        }
        catch (InterruptedException e) {
            return defPortalTent;
        }
        try {
            List portalInfoContentList;
            PortalInfo defaultPortal = this.portalInfoMapper.queryDefaultPortal(clientType);
            if (null != defPortalTent) {
                defPortalTent.setPortalImgId(defaultPortal.getPortalImgId());
                defPortalTent.setPortalContent(defaultPortal.getPortalContent());
                defPortalTent.setTemplateId(null);
                this.portalInfoMapper.updateById((Object)defPortalTent);
            } else {
                PortalInfo newDefPortalTent = new PortalInfo();
                BeanUtils.copyProperties((Object)defaultPortal, (Object)newDefPortalTent);
                newDefPortalTent.setTemplateId(null);
                newDefPortalTent.setId(null);
                this.portalInfoMapper.insert((Object)newDefPortalTent);
                defPortalTent = newDefPortalTent;
            }
            if (Constants.ClientTypeEnum.PC.getValue().equals(clientType)) {
                portalInfoContentList = this.portalInfoContentMapper.queryPortalCont(defaultPortal.getId(), Collections.singletonList(Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal()));
                List dataTypeList = portalInfoContentList.stream().map(PortalInfoContent::getDataType).collect(Collectors.toList());
                List preSystemList = this.labelSystemPreService.initDefPortal(dataTypeList, clientType);
                Map preInfoMap = preSystemList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
                this.delPortalContent(defPortalTent.getId(), null);
                for (PortalInfoContent contentInfo : portalInfoContentList) {
                    contentInfo.setId(null);
                    contentInfo.setTenantId(Utils.getTenantId());
                    contentInfo.setPortalId(defPortalTent.getId());
                    contentInfo.setContentId(((LabelSystemPre)preInfoMap.get(contentInfo.getDataType())).getId());
                    this.portalInfoContentMapper.insert((Object)contentInfo);
                }
            } else {
                portalInfoContentList = this.portalInfoContentMapper.queryPortalCont(defaultPortal.getId(), (List)Lists.newArrayList());
                List preSystemList = this.labelSystemPreService.initDefPortal((List)Lists.newArrayList(), clientType);
                Map preInfoMap = preSystemList.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
                this.delPortalContent(defPortalTent.getId(), null);
                for (PortalInfoContent contentInfo : portalInfoContentList) {
                    PortalInfoContent content = new PortalInfoContent();
                    BeanUtils.copyProperties((Object)contentInfo, (Object)content);
                    content.setId(null);
                    content.setTenantId(Utils.getTenantId());
                    content.setPortalId(defPortalTent.getId());
                    if (!contentInfo.getContentType().equals(Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal())) {
                        LabelSystemPre systemPre = (LabelSystemPre)preInfoMap.get(contentInfo.getContentType());
                        content.setContentId(systemPre == null ? null : systemPre.getId());
                    }
                    this.portalInfoContentMapper.insert((Object)content);
                }
            }
        }
        catch (Exception e) {
            log.error("initDefPortal  error", (Throwable)e);
        }
        finally {
            redisLock.unlock();
        }
        return defPortalTent;
    }

    public List<PortalInfo> getListPortal(PortalInfoQueryReq req) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"client_type", (Object)req.getClientType());
        if (StringUtils.isNotEmpty((CharSequence)req.getName())) {
            condition.like((Object)"name", (Object)req.getName());
        }
        if (null != req.getStatus()) {
            condition.eq((Object)"status", (Object)req.getStatus());
        }
        if (ObjectUtils.isNotEmpty((Object)req.getPortalType())) {
            condition.eq((Object)"portal_type", (Object)req.getPortalType());
        }
        condition.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.isNull((Object)"version")).or()).eq((Object)"version", (Object)req.getVersion());
        });
        HashSet<String> tenantIds = new HashSet<String>(Arrays.asList(Utils.getTenantId(), "SYSTEM_TENANT"));
        condition.in((Object)"tenant_id", tenantIds);
        if (null == req.getSortType() || StringUtils.isEmpty((CharSequence)req.getOrderBy())) {
            ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByDesc((Object)"modify_time");
        }
        if (null != req.getSortType() && req.getSortType() == 1) {
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByDesc((Object)"create_time");
            }
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByAsc((Object)"create_time");
            }
        }
        if (null != req.getSortType() && req.getSortType() == 2) {
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("desc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByDesc((Object)"modify_time");
            }
            if (StringUtils.isNotEmpty((CharSequence)req.getOrderBy()) && req.getOrderBy().equals("asc")) {
                ((QueryWrapper)condition.orderByDesc((Object)"default_flag")).orderByAsc((Object)"modify_time");
            }
        }
        return (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.selectList((Wrapper)condition));
    }

    @Transactional
    public Integer updateBat(PortalInfoQueryReq req) {
        req.setModifyTime(DateUtils.getNowTime((String)""));
        req.setModifyUserId(Utils.getUserId());
        req.setModifyUserName(Utils.getUserName());
        if (CollectionUtils.isNotEmpty((Collection)req.getIdList())) {
            this.portalInfoMapper.updateBat(req.getIdList(), req);
        } else if (CollectionUtils.isNotEmpty((Collection)req.getMobileIdReqList())) {
            List newPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.FALSE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newPortalIdList)) {
                this.portalInfoMapper.updateBat(newPortalIdList, req);
            }
            List oldPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.TRUE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            req.setIdList(oldPortalIdList);
            if (CollectionUtils.isNotEmpty(oldPortalIdList)) {
                this.mobilePortalService.updateBat(req);
            }
        }
        return null;
    }

    @Transactional
    public Integer delBat(PortalInfoQueryReq req) {
        if (CollectionUtils.isNotEmpty((Collection)req.getIdList())) {
            this.portalInfoMapper.deleteBatchIds((Collection)req.getIdList());
            this.delPortalContent(null, req.getIdList());
            this.delPortalAuth(req.getIdList());
        } else if (CollectionUtils.isNotEmpty((Collection)req.getMobileIdReqList())) {
            List newPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.FALSE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newPortalIdList)) {
                this.portalInfoMapper.deleteBatchIds(newPortalIdList);
                this.delPortalContent(null, newPortalIdList);
                this.delPortalAuth(newPortalIdList);
                QueryWrapper condition = new QueryWrapper();
                condition.in((Object)"mobile_portal_id", (Collection)req.getIdList());
                this.mobilePortalPreviewMapper.delete((Wrapper)condition);
            }
            List oldPortalIdList = req.getMobileIdReqList().stream().filter(x -> Boolean.TRUE.equals(x.getOldPortalFlag())).map(PortalInfoQueryReq.MobileIdReq::getId).collect(Collectors.toList());
            req.setIdList(oldPortalIdList);
            if (CollectionUtils.isNotEmpty(oldPortalIdList)) {
                this.mobilePortalService.delBat(req);
            }
        }
        return null;
    }

    @Transactional
    public Integer savePortalAuth(PortalInfoAuthReq req) {
        ArrayList<Long> portalIdList = new ArrayList<Long>();
        portalIdList.add(req.getId());
        this.delPortalAuth(portalIdList);
        for (PortalInfoAuthReq.AuthVO authVO : req.getAuthList()) {
            PortalInfoAuth portalInfoAuth = (PortalInfoAuth)this.converter.convert((Object)authVO, PortalInfoAuth.class);
            portalInfoAuth.setPortalId(req.getId());
            portalInfoAuth.setClientType(req.getClientType());
            portalInfoAuth.setPortalTypeSource(req.getPortalTypeSource());
            this.portalInfoAuthMapper.insert((Object)portalInfoAuth);
        }
        return null;
    }

    public PortalInfoAuthResp selectByPortalAuth(Long portalId) {
        List userDataList;
        List deptDataList;
        List roleDataList;
        PortalInfoAuthResp authResp = new PortalInfoAuthResp();
        ArrayList<Long> portalIdList = new ArrayList<Long>();
        portalIdList.add(portalId);
        List authList = this.selectPortalAuth(portalIdList);
        if (CollectionUtils.isEmpty((Collection)authList)) {
            return authResp;
        }
        List orgDataList = authList.stream().filter(item -> BizAuthTypeEnum.ORG.getValue().equals(item.getAuthType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgDataList)) {
            authResp.setOrgDataList(orgDataList);
        }
        if (CollectionUtils.isNotEmpty(roleDataList = authList.stream().filter(item -> BizAuthTypeEnum.ROLE.getValue().equals(item.getAuthType())).collect(Collectors.toList()))) {
            authResp.setRoleDataList(roleDataList);
        }
        if (CollectionUtils.isNotEmpty(deptDataList = authList.stream().filter(item -> BizAuthTypeEnum.DEPARTMENT.getValue().equals(item.getAuthType())).collect(Collectors.toList()))) {
            authResp.setDeptDataList(deptDataList);
        }
        if (CollectionUtils.isNotEmpty(userDataList = authList.stream().filter(item -> BizAuthTypeEnum.USER.getValue().equals(item.getAuthType())).collect(Collectors.toList()))) {
            authResp.setUserDataList(userDataList);
        }
        return authResp;
    }

    public List<PortalInfoAuth> selectPortalAuth(List<Long> portalIdList) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in((Object)"portal_id", portalIdList);
        }
        return this.portalInfoAuthMapper.selectList((Wrapper)condition);
    }

    public void delPortalAuth(List<Long> portalIdList) {
        QueryWrapper condition = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(portalIdList)) {
            condition.in((Object)"portal_id", portalIdList);
        }
        this.portalInfoAuthMapper.delete((Wrapper)condition);
    }

    public PortalInfoUse getUserUsePortal(Integer clientType) {
        QueryWrapper condition = new QueryWrapper();
        condition.orderByDesc((Object)"id");
        condition.eq((Object)"create_user_id", (Object)Utils.getUserId());
        condition.eq((Object)"client_type", (Object)clientType);
        List useList = this.portalInfoUseMapper.selectList((Wrapper)condition);
        if (CollectionUtils.isNotEmpty((Collection)useList)) {
            return (PortalInfoUse)useList.get(0);
        }
        return null;
    }

    public List<PortalUserAuthResp> selectUserPortal(Integer clientType) {
        boolean mobile;
        MobilePortalInfoUse mobilePortalInfoUse;
        QueryWrapper condition = new QueryWrapper();
        QueryWrapper wrapper = this.labelSystemAuthService.getUserAuthCon(condition);
        wrapper.eq((Object)"client_type", (Object)clientType);
        List portalInfoAuthList = this.portalInfoAuthMapper.selectList((Wrapper)wrapper);
        List mobilePortalInfoAuths = new ArrayList();
        if (Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType)) {
            mobilePortalInfoAuths = this.mobilePortalInfoAuthMapper.selectList((Wrapper)this.labelSystemAuthService.getUserAuthCon(new QueryWrapper()));
        }
        PortalInfo defPortalTent = this.initDefPortal(clientType);
        ArrayList<PortalUserAuthResp> userAuthRespList = new ArrayList<PortalUserAuthResp>();
        PortalUserAuthResp defPortal = (PortalUserAuthResp)this.converter.convert((Object)defPortalTent, PortalUserAuthResp.class);
        String name = this.translateService.translateTextCache(defPortalTent.getName(), "");
        defPortal.setName(name);
        if (null != defPortal && Constants.GENERAL_MENU_TEMPLATE_ID.equals(defPortal.getMenuTemplateId())) {
            defPortal.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        }
        String version = this.kmService.queryTenantVersionWithDefault();
        String recentlyMsg = "";
        PortalInfoUse usePortal = this.getUserUsePortal(clientType);
        if (usePortal == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType) && (mobilePortalInfoUse = (MobilePortalInfoUse)this.mobilePortalInfoUseMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId()))) != null) {
            usePortal = new PortalInfoUse();
            usePortal.setId(mobilePortalInfoUse.getId());
            usePortal.setTenantId(mobilePortalInfoUse.getTenantId());
            usePortal.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
            usePortal.setPortalId(mobilePortalInfoUse.getMobilePortalId());
            usePortal.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        }
        PortalInfo usePortalInfo = null;
        if (null != usePortal) {
            LambdaQueryWrapper queryWrapper;
            if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(usePortal.getPortalTypeSource())) {
                queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getPortalDesignerId, (Object)usePortal.getPortalId())).eq(PortalInfo::getVersion, (Object)version);
                usePortalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
            } else {
                MobilePortalInfo mobilePortalInfo;
                queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getId, (Object)usePortal.getPortalId())).eq(PortalInfo::getClientType, (Object)clientType);
                usePortalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
                if (usePortalInfo == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType) && (mobilePortalInfo = (MobilePortalInfo)this.mobilePortalInfoMapper.selectById((Serializable)usePortal.getPortalId())) != null) {
                    usePortalInfo = new PortalInfo();
                    BeanUtils.copyProperties((Object)mobilePortalInfo, (Object)usePortalInfo);
                    usePortalInfo.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                    usePortalInfo.setMenuTypeSource(Constants.MenuTypeSourceEnum.TENANT.getFlag());
                    usePortalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
                    usePortalInfo.setVersionDefault(Integer.valueOf(0));
                }
            }
            if (null == usePortalInfo || usePortalInfo.getStatus().equals(Constants.ReleaseEnum.NO_RELEASE.getVal())) {
                recentlyMsg = this.messageUtils.getMessage("error.message.use.portal.recovery");
                defPortal.setRecentlyMsg(recentlyMsg);
            }
        }
        boolean pc = Constants.ClientTypeEnum.PC.getValue().equals(clientType) && CollectionUtils.isEmpty((Collection)portalInfoAuthList);
        boolean bl = mobile = Constants.ClientTypeEnum.MOBILE.getValue().equals(clientType) && CollectionUtils.isEmpty((Collection)portalInfoAuthList) && CollectionUtils.isEmpty(mobilePortalInfoAuths);
        if (pc || mobile) {
            defPortal.setIsRecently(Boolean.valueOf(true));
            if (null != usePortalInfo && !usePortalInfo.getId().equals(defPortalTent.getId())) {
                defPortal.setRecentlyMsg(this.messageUtils.getMessage("error.message.use.portal.recovery"));
            }
            userAuthRespList.add(defPortal);
            return userAuthRespList;
        }
        List isvPortalIds = portalInfoAuthList.stream().filter(r -> Constants.PortalTypeSourceEnum.ISV.getFlag().equals(r.getPortalTypeSource())).map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(isvPortalIds)) {
            List desPortalIds = this.relatedAppServiceWrapper.queryCurrTenantPortalList(version);
            List authIsvPortalIds = isvPortalIds.stream().filter(desPortalIds::contains).collect(Collectors.toList());
            List deleteIsvPortalIds = isvPortalIds.stream().filter(r -> !desPortalIds.contains(r)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(deleteIsvPortalIds)) {
                this.delPortalAuth(deleteIsvPortalIds);
            }
            isvPortalIds = authIsvPortalIds;
        }
        List tenantPortalIds = portalInfoAuthList.stream().filter(r -> !Constants.PortalTypeSourceEnum.ISV.getFlag().equals(r.getPortalTypeSource())).map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
        List<Object> portalInfoList = new ArrayList();
        if (CollectionUtils.isNotEmpty(isvPortalIds)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(PortalInfo::getPortalDesignerId, isvPortalIds)).eq(PortalInfo::getVersion, (Object)version);
            portalInfoList.addAll((Collection)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.selectList((Wrapper)queryWrapper)));
        }
        if (CollectionUtils.isNotEmpty(tenantPortalIds)) {
            portalInfoList.addAll((Collection)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.selectBatchIds((Collection)tenantPortalIds)));
        }
        if (CollectionUtils.isNotEmpty(mobilePortalInfoAuths)) {
            List mobilePortalIds = mobilePortalInfoAuths.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
            List mobilePortalInfoList = this.mobilePortalInfoMapper.selectBatchIds(mobilePortalIds).stream().map(x -> {
                PortalInfo portalInfo = new PortalInfo();
                BeanUtils.copyProperties((Object)x, (Object)portalInfo);
                portalInfo.setOldPortalFlag(Boolean.valueOf(true));
                portalInfo.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                portalInfo.setMenuTypeSource(Constants.MenuTypeSourceEnum.TENANT.getFlag());
                portalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
                return portalInfo;
            }).collect(Collectors.toList());
            portalInfoList.addAll(mobilePortalInfoList);
        }
        List portalIds = portalInfoList.stream().map(PortalInfo::getId).collect(Collectors.toList());
        portalIds.add(defPortalTent.getId());
        if (null != usePortalInfo && !portalIds.contains(usePortalInfo.getId())) {
            recentlyMsg = this.messageUtils.getMessage("error.message.use.portal.recovery");
        }
        if (CollectionUtils.isEmpty(portalInfoList = portalInfoList.stream().filter(x -> Constants.ReleaseEnum.RELEASED.getVal().equals(x.getStatus()) && Constants.MobilePortalTypeEnum.PORTAL.getFlag().equals(x.getPortalType())).collect(Collectors.toList()))) {
            defPortal.setRecentlyMsg(recentlyMsg);
            defPortal.setIsRecently(Boolean.valueOf(true));
            userAuthRespList.add(defPortal);
            return userAuthRespList;
        }
        List relPortalIds = portalInfoList.stream().map(PortalInfo::getId).collect(Collectors.toList());
        defPortal.setRecentlyMsg(recentlyMsg);
        defPortal.setIsRecently(Boolean.valueOf(false));
        if (null != usePortalInfo && usePortalInfo.getId().equals(defPortal.getId())) {
            defPortal.setIsRecently(Boolean.valueOf(true));
        }
        userAuthRespList.add(defPortal);
        portalInfoList.forEach(x -> x.setName(this.translateService.translateTextCache(x.getName(), "")));
        Collator cmp = Collator.getInstance(Locale.CHINA);
        portalInfoList.sort((a, b) -> cmp.compare(a.getName(), b.getName()));
        for (int i = 0; i < portalInfoList.size(); ++i) {
            PortalInfo portalInfo = (PortalInfo)portalInfoList.get(i);
            PortalUserAuthResp userPortal = new PortalUserAuthResp();
            BeanUtils.copyProperties((Object)portalInfo, (Object)userPortal);
            userPortal.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            if ("SYSTEM_TENANT".equals(portalInfo.getTenantId())) {
                userPortal.setId(portalInfo.getPortalDesignerId());
                userPortal.setPortalTypeSource(Constants.PortalTypeSourceEnum.ISV.getFlag());
            }
            userPortal.setRecentlyMsg(recentlyMsg);
            userPortal.setIsRecently(Boolean.valueOf(false));
            if (null == usePortalInfo && i == 0) {
                userPortal.setIsRecently(Boolean.valueOf(true));
            }
            if (null != userPortal && Constants.GENERAL_MENU_TEMPLATE_ID.equals(userPortal.getMenuTemplateId())) {
                userPortal.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
            }
            if (null != usePortalInfo && i == 0 && !relPortalIds.contains(usePortalInfo.getId()) && !usePortalInfo.getId().equals(defPortal.getId())) {
                userPortal.setIsRecently(Boolean.valueOf(true));
            }
            if (null != usePortalInfo && usePortalInfo.getId().equals(((PortalInfo)portalInfoList.get(i)).getId()) && !usePortalInfo.getId().equals(defPortal.getId())) {
                userPortal.setIsRecently(Boolean.valueOf(true));
            }
            if (!((PortalInfo)portalInfoList.get(i)).getStatus().equals(Constants.ReleaseEnum.RELEASED.getVal())) continue;
            userAuthRespList.add(userPortal);
        }
        List isvuserAuthRespList = userAuthRespList.stream().filter(e -> Objects.equals(1, e.getPortalTypeSource())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(isvuserAuthRespList)) {
            Set collect = isvuserAuthRespList.stream().map(e -> e.getId()).collect(Collectors.toSet());
            LambdaQueryWrapper portalDeployMessageLambdaQueryWrapper = new LambdaQueryWrapper();
            LambdaQueryWrapper in = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)portalDeployMessageLambdaQueryWrapper.eq(PortalDeployMessage::getSource, (Object)2)).in(CollectionUtils.isNotEmpty(collect), PortalDeployMessage::getPortalId, collect)).eq(PortalDeployMessage::getVersion, (Object)version)).eq(PortalDeployMessage::getUserSid, (Object)Utils.getUserSid())).eq(PortalDeployMessage::getClientType, (Object)clientType);
            List portalDeployMessages = (List)InterceptorIgnoreUtil.handler(() -> this.portalDeployMessageService.getBaseMapper().selectList((Wrapper)in));
            if (CollectionUtils.isEmpty((Collection)portalDeployMessages)) {
                for (PortalUserAuthResp portalUserAuthResp : isvuserAuthRespList) {
                    if (!Objects.equals(1, portalUserAuthResp.getPortalTypeSource())) continue;
                    portalUserAuthResp.setChanged(Integer.valueOf(1));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)portalDeployMessages)) {
                Set collect1 = portalDeployMessages.stream().map(e -> e.getPortalId()).collect(Collectors.toSet());
                for (PortalUserAuthResp portalUserAuthResp : isvuserAuthRespList) {
                    if (!Objects.equals(1, portalUserAuthResp.getPortalTypeSource()) || collect1.contains(portalUserAuthResp.getId())) continue;
                    portalUserAuthResp.setChanged(Integer.valueOf(1));
                }
            }
        }
        return userAuthRespList;
    }

    @Transactional
    public ResponseEntity<?> getPortalInfo(PortalInfo portalInfo) {
        List isvCustomIds;
        List portalInfoContentList;
        QueryWrapper wrapper;
        if (portalInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_YES)) {
            portalInfo = this.initDefPortal(portalInfo.getClientType());
        }
        if (Constants.GENERAL_MENU_TEMPLATE_ID.equals(portalInfo.getMenuTemplateId())) {
            portalInfo.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        }
        if (portalInfo.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_NO)) {
            QueryWrapper condition = new QueryWrapper();
            wrapper = this.labelSystemAuthService.getUserAuthCon(condition);
            wrapper.eq((Object)"client_type", (Object)portalInfo.getClientType());
            List portalInfoAuthList = this.portalInfoAuthMapper.selectList((Wrapper)wrapper);
            List portalIds = portalInfoAuthList.stream().map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
            String recentlyMsg = "";
            if (!portalIds.contains(portalInfo.getId()) && !portalIds.contains(portalInfo.getPortalDesignerId())) {
                recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
                portalInfo.setRecentlyMsg(recentlyMsg);
                return ResponseEntityWrapper.wrapperOk((Object)portalInfo);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(portalInfoContentList = this.selPortalContent(portalInfo.getId())))) {
            return ResponseEntityWrapper.wrapperOk((Object)portalInfo);
        }
        wrapper = new LambdaQueryWrapper();
        wrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, (Object)Constants.ClientTypeTypeEnum.PC.getFlag());
        List systemPres = (List)InterceptorIgnoreUtil.handler(() -> this.lambda$getPortalInfo$38((LambdaQueryWrapper)wrapper));
        Map preIdMap = systemPres.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        ArrayList customList = new ArrayList();
        Map<Object, Object> tenantCustomInfoMap = new HashMap();
        Map<Object, Object> isvCustomInfoMap = new HashMap();
        List tenantCustomIds = this.buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.TENANT);
        if (CollectionUtils.isNotEmpty((Collection)tenantCustomIds)) {
            List tenantCustomList = this.labelSystemCustomMapper.selectBatchIds((Collection)tenantCustomIds);
            tenantCustomInfoMap = tenantCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
            customList.addAll(tenantCustomList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(isvCustomIds = this.buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.ISV)))) {
            String tenantVersion = this.kmService.queryTenantVersionWithDefault();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(LabelSystemCustom::getComponentDesignerId, (Collection)isvCustomIds);
            queryWrapper.eq(LabelSystemCustom::getVersion, (Object)tenantVersion);
            List isvCustomList = this.labelSystemCustomMapper.selectList((Wrapper)queryWrapper);
            isvCustomInfoMap = isvCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getComponentDesignerId, Function.identity(), (a, b) -> a));
            customList.addAll(isvCustomList);
        }
        Map<Object, Object> customInfoMap = new HashMap();
        UserAuthSystemLabelVo authSystemLabelVo = new UserAuthSystemLabelVo();
        if (CollectionUtils.isNotEmpty(customList)) {
            customInfoMap = customList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
            HashSet<Object> customIdSet = new HashSet<Object>(customInfoMap.keySet());
            List systemDataList = this.labelSystemDataMapper.queryBySystemIdList(customIdSet);
            authSystemLabelVo = this.mobileUserAuthService.buildSystemIdApp(systemDataList);
        }
        Map linkMap = this.getWebLinkPermMap();
        for (PortalInfoContent content : portalInfoContentList) {
            if (null != content.getDataType() && Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(content.getDataType())) {
                PortalContentCarousel carouselInfo = (PortalContentCarousel)JSON.parseObject((String)content.getContentAttr(), PortalContentCarousel.class);
                if (null == carouselInfo || CollectionUtils.isEmpty((Collection)carouselInfo.getImageList())) continue;
                for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                    LabelSystemCustom systemCustom;
                    String iconUrl = image.getContentIcon();
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                        iconUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + iconUrl;
                    }
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                        iconUrl = this.envProperties.getSemcWebUrl() + iconUrl;
                    }
                    image.setImageUrl(iconUrl);
                    String linkKey = image.getJumpType() + "-" + image.getJumpTarget();
                    image.setIsNeedCheckPerm((Integer)linkMap.get(linkKey));
                    if (!Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType()) || null == (systemCustom = Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(image.getJumpSource()) ? (LabelSystemCustom)isvCustomInfoMap.get(image.getJumpValue()) : (LabelSystemCustom)tenantCustomInfoMap.get(Long.parseLong(image.getJumpValue())))) continue;
                    image.setJumpName(systemCustom.getNameZh());
                }
                content.setCarouselInfo(carouselInfo);
            }
            if (Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(content.getContentType())) {
                LabelSystemPre labelSystemPre = (LabelSystemPre)preIdMap.get(content.getDataType());
                Long contentId = Optional.ofNullable(labelSystemPre).map(LabelSystemPre::getId).orElse(null);
                if (contentId != null) {
                    content.setContentId(contentId);
                    content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                }
                content.setDataType(labelSystemPre == null ? null : labelSystemPre.getDataType());
                content.setDataCategory(labelSystemPre == null ? null : labelSystemPre.getDataCategory());
                content.setContentName(StringUtils.isEmpty((CharSequence)content.getContentName()) ? (labelSystemPre == null ? "" : labelSystemPre.getName()) : content.getContentName());
            }
            if (Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(content.getContentType())) {
                LabelSystemCustom systemCustom;
                content.setContentConfig((Object)content.getContentAttr());
                if (authSystemLabelVo.getNoPermSystemIdList().contains(content.getContentId()) || (systemCustom = Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(content.getLabelTypeSource()) ? (LabelSystemCustom)isvCustomInfoMap.get(content.getContentId()) : (LabelSystemCustom)tenantCustomInfoMap.get(content.getContentId())) == null) continue;
                content.setDataCategory(systemCustom.getDataCategory());
                content.setClassicsIcon(systemCustom.getClassicsIcon());
                content.setContentName(StringUtils.isEmpty((CharSequence)content.getContentName()) ? systemCustom.getNameZh() : content.getContentName());
                content.setWebLinkUrl(systemCustom.getLinkUrl());
                if (Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(systemCustom.getDataCategory()) && StringUtils.isNotBlank((CharSequence)systemCustom.getLinkParam())) {
                    StringBuilder stringBuilder = Utils.buildWebLinkUrl((String)systemCustom.getLinkParam());
                    String linkUrl = systemCustom.getLinkUrl() + "?" + stringBuilder;
                    content.setWebLinkUrl(linkUrl);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)content.getContentName())) continue;
            String name = this.translateService.translateTextCache(content.getContentName(), "");
            content.setContentName(name);
        }
        portalInfo.setContentList(portalInfoContentList);
        return ResponseEntityWrapper.wrapperOk((Object)portalInfo);
    }

    public Map<String, Integer> getWebLinkPermMap() {
        HashMap<String, Integer> linkMap = new HashMap<String, Integer>();
        List optionRespDTOS = this.queryLinkList(null);
        for (PortalSelectOptionRespDTO optionRespDTO : optionRespDTOS) {
            String linkKey = optionRespDTO.getType() + "-";
            linkMap.put(linkKey, optionRespDTO.getIsNeedCheckPerm());
            if (!CollectionUtils.isNotEmpty((Collection)optionRespDTO.getChildrenList())) continue;
            for (PortalSelectOptionRespDTO optionChildrenDTO : optionRespDTO.getChildrenList()) {
                linkKey = optionRespDTO.getType() + "-" + optionChildrenDTO.getType();
                linkMap.put(linkKey, optionChildrenDTO.getIsNeedCheckPerm());
            }
        }
        return linkMap;
    }

    @Transactional
    public void addUseRecord(Long portId, Integer clientType, Integer portalTypeSource) {
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"create_user_id", (Object)Utils.getUserId());
        condition.eq((Object)"client_type", (Object)clientType);
        this.portalInfoUseMapper.delete((Wrapper)condition);
        PortalInfoUse infoUse = new PortalInfoUse();
        infoUse.setCreateUserId(Utils.getUserId());
        infoUse.setPortalId(portId);
        infoUse.setTenantId(Utils.getTenantId());
        infoUse.setClientType(clientType);
        infoUse.setPortalTypeSource(portalTypeSource);
        this.portalInfoUseMapper.insert((Object)infoUse);
    }

    @Transactional
    public void addUseRecordByMobile(AddUseRecordRequest req) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
        this.mobilePortalInfoUseMapper.delete((Wrapper)wrapper);
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"create_user_id", (Object)Utils.getUserId());
        condition.eq((Object)"client_type", (Object)req.getClientType());
        this.portalInfoUseMapper.delete((Wrapper)condition);
        PortalInfoUse infoUse = new PortalInfoUse();
        infoUse.setCreateUserId(Utils.getUserId());
        infoUse.setPortalId(req.getId());
        infoUse.setTenantId(Utils.getTenantId());
        infoUse.setClientType(req.getClientType());
        infoUse.setPortalTypeSource(req.getPortalTypeSource());
        this.portalInfoUseMapper.insert((Object)infoUse);
    }

    public List<Long> getPortalSystemId(List<PortalInfoContent> portalInfoContentList, Integer labelTypeSource) {
        ArrayList<Long> systemIdList = new ArrayList<Long>();
        for (PortalInfoContent contentAttr : portalInfoContentList) {
            PortalContentCarousel carouselInfo;
            if (null == contentAttr.getDataType() || !Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(contentAttr.getDataType()) || StringUtils.isEmpty((CharSequence)contentAttr.getContentAttr()) || null == (carouselInfo = (PortalContentCarousel)JSON.parseObject((String)contentAttr.getContentAttr(), PortalContentCarousel.class)) || CollectionUtils.isEmpty((Collection)carouselInfo.getImageList())) continue;
            for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                if (null == image.getJumpType() || StringUtils.isEmpty((CharSequence)image.getJumpValue()) || !labelTypeSource.equals(image.getJumpSource()) || !Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType())) continue;
                systemIdList.add(Long.parseLong(image.getJumpValue()));
            }
        }
        return systemIdList;
    }

    public ResponseEntity<?> getPortalDetail(PortalInfo portalInfo) {
        PortalInfo portalInfoResp = new PortalInfo();
        if (Constants.ClientTypeEnum.PC.getValue().equals(portalInfo.getClientType())) {
            portalInfoResp = this.getPcPortalDetail(portalInfo);
        } else if (Constants.ClientTypeEnum.MOBILE.getValue().equals(portalInfo.getClientType())) {
            portalInfoResp = this.getMobilePortalDetail(portalInfo);
        }
        return ResponseEntityWrapper.wrapperOk((Object)portalInfoResp);
    }

    public PortalInfo getPcPortalDetail(PortalInfo portalInfo) {
        List isvCustomIds;
        List portalInfoContentList;
        if (Constants.GENERAL_MENU_TEMPLATE_ID.equals(portalInfo.getMenuTemplateId())) {
            portalInfo.setMenuGeneralFlag(Constants.GENERAL_MENU_FLAG_YES);
        }
        if (CollectionUtils.isEmpty((Collection)(portalInfoContentList = this.portalInfoContentMapper.queryPortalCont(portalInfo.getId(), new ArrayList())))) {
            return portalInfo;
        }
        Map<Object, Object> preInfoMap = new HashMap();
        List preDataList = portalInfoContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(item.getContentType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preDataList)) {
            List preIds = preDataList.stream().map(PortalInfoContent::getContentId).collect(Collectors.toList());
            List preList = this.labelSystemPreMapper.selectBatchIds(preIds);
            preInfoMap = preList.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));
        }
        List dataTypeList = portalInfoContentList.stream().filter(x -> Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(x.getLabelTypeSource()) && Constants.PrtalContentTypeEnum.LABEL_SYSTEM_PRE.getVal().equals(x.getContentType())).map(PortalInfoContent::getDataType).collect(Collectors.toList());
        Map<Object, Object> dataCategoryMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(dataTypeList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(LabelSystemPre::getClientType, (Object)portalInfo.getClientType());
            queryWrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId());
            queryWrapper.in(LabelSystemPre::getDataType, dataTypeList);
            List labelSystemPreList = this.labelSystemPreMapper.selectList((Wrapper)queryWrapper);
            dataCategoryMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a));
        }
        List customList = Lists.newArrayList();
        List tenantCustomIds = this.buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.TENANT);
        if (CollectionUtils.isNotEmpty((Collection)tenantCustomIds)) {
            customList = this.labelSystemCustomMapper.selectBatchIds((Collection)tenantCustomIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(isvCustomIds = this.buildCustomIdList(portalInfoContentList, Constants.LabelOrPoralSourceEnum.ISV)))) {
            String tenantVersion = this.kmService.queryTenantVersion();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(LabelSystemCustom::getComponentDesignerId, (Collection)isvCustomIds);
            wrapper.eq(LabelSystemCustom::getVersion, (Object)tenantVersion);
            List isvCustomList = (List)InterceptorIgnoreUtil.handler(() -> this.labelSystemCustomMapper.selectList((Wrapper)wrapper));
            customList.addAll(isvCustomList);
        }
        Map customInfoMap = customList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        for (PortalInfoContent content : portalInfoContentList) {
            if (null != content.getDataType() && Constants.DataTypeEnum.TYPE_CAROUSEL.getVal().equals(content.getDataType())) {
                PortalContentCarousel carouselInfo = (PortalContentCarousel)JSON.parseObject((String)content.getContentAttr(), PortalContentCarousel.class);
                if (null == carouselInfo || CollectionUtils.isEmpty((Collection)carouselInfo.getImageList())) continue;
                for (PortalContentCarouselImage image : carouselInfo.getImageList()) {
                    LabelSystemCustom systemCustom;
                    String iconUrl = image.getContentIcon();
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                        iconUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + iconUrl;
                    }
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                        iconUrl = this.envProperties.getSemcWebUrl() + iconUrl;
                    }
                    image.setImageUrl(iconUrl);
                    if (!Constants.WebLinkTypeEnum.APP.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.JOB.getVal().equals(image.getJumpType()) && !Constants.WebLinkTypeEnum.BUSINESS_TODO.getVal().equals(image.getJumpType()) || null == (systemCustom = (LabelSystemCustom)customInfoMap.get(Long.parseLong(image.getJumpValue())))) continue;
                    image.setJumpName(systemCustom.getNameZh());
                }
                content.setCarouselInfo(carouselInfo);
            }
            if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(content.getContentType())) {
                LabelSystemPre labelSystemPre = (LabelSystemPre)preInfoMap.get(content.getContentId());
                if (Constants.LabelOrPoralSourceEnum.TENANT.getFlag().equals(content.getLabelTypeSource())) {
                    labelSystemPre = (LabelSystemPre)preInfoMap.get(content.getContentId());
                } else if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(content.getLabelTypeSource())) {
                    labelSystemPre = (LabelSystemPre)dataCategoryMap.get(content.getDataType());
                }
                content.setDataType(labelSystemPre == null ? null : labelSystemPre.getDataType());
                content.setContentId(labelSystemPre == null ? content.getContentId() : labelSystemPre.getId());
            }
            if (!ComponentSourceEnum.LABEL_SYSTEM_CUSTOM.getCode().equals(content.getContentType())) continue;
            content.setContentConfig((Object)content.getContentAttr());
            LabelSystemCustom systemCustom = (LabelSystemCustom)customInfoMap.get(content.getContentId());
            if (systemCustom == null) continue;
            content.setContentName(StringUtils.isEmpty((CharSequence)content.getContentName()) ? systemCustom.getNameZh() : content.getContentName());
            content.setClassicsIcon(systemCustom.getClassicsIcon());
            content.setDataCategory(systemCustom.getDataCategory());
            content.setWebLinkUrl(systemCustom.getLinkUrl());
            if (!Constants.DataCategoryEnum.WEB_PAGE.getVal().equals(systemCustom.getDataCategory()) || !StringUtils.isNotBlank((CharSequence)systemCustom.getLinkParam())) continue;
            StringBuilder stringBuilder = Utils.buildWebLinkUrl((String)systemCustom.getLinkParam());
            String linkUrl = systemCustom.getLinkUrl() + "?" + stringBuilder;
            content.setWebLinkUrl(linkUrl);
        }
        portalInfo.setContentList(portalInfoContentList);
        return portalInfo;
    }

    public PortalInfo getMobilePortalDetail(PortalInfo portalInfo) {
        List portalInfoContentList = this.portalInfoContentMapper.queryPortalCont(portalInfo.getId(), new ArrayList());
        if (CollectionUtils.isEmpty((Collection)portalInfoContentList)) {
            return portalInfo;
        }
        List preIds = portalInfoContentList.stream().map(PortalInfoContent::getContentId).collect(Collectors.toList());
        List preList = this.labelSystemPreMapper.selectBatchIds(preIds);
        Map preInfoMap = preList.stream().collect(Collectors.toMap(LabelSystemPre::getId, Function.identity(), (a, b) -> a));
        List dataCategoryList = portalInfoContentList.stream().filter(x -> Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(x.getLabelTypeSource())).map(PortalInfoContent::getContentType).collect(Collectors.toList());
        Map<Object, Object> dataCategoryMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(dataCategoryList)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(LabelSystemPre::getClientType, (Object)portalInfo.getClientType());
            queryWrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId());
            queryWrapper.in(LabelSystemPre::getDataCategory, dataCategoryList);
            List labelSystemPreList = this.labelSystemPreMapper.selectList((Wrapper)queryWrapper);
            dataCategoryMap = labelSystemPreList.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
        }
        for (PortalInfoContent portalInfoContent : portalInfoContentList) {
            LabelSystemPre labelSystemPre = new LabelSystemPre();
            if (Constants.LabelOrPoralSourceEnum.TENANT.getFlag().equals(portalInfoContent.getLabelTypeSource())) {
                labelSystemPre = (LabelSystemPre)preInfoMap.get(portalInfoContent.getContentId());
            } else if (Constants.LabelOrPoralSourceEnum.ISV.getFlag().equals(portalInfoContent.getLabelTypeSource())) {
                labelSystemPre = (LabelSystemPre)dataCategoryMap.get(portalInfoContent.getContentType());
            }
            String contentNamePre = labelSystemPre == null ? portalInfoContent.getContentName() : labelSystemPre.getName();
            String contentName = this.translateService.translateTextCache(contentNamePre, "");
            portalInfoContent.setContentName(contentName);
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(portalInfoContent.getContentType())) {
                PortalContentKingKongDistrict kingKongDistrict = (PortalContentKingKongDistrict)JSON.parseObject((String)portalInfoContent.getContentAttr(), PortalContentKingKongDistrict.class);
                for (PortalContentKingKongDistrictBall bill : kingKongDistrict.getBallList()) {
                    if (!StringUtils.isNotBlank((CharSequence)bill.getContentIcon()) || !ObjectUtils.isNotEmpty((Object)bill.getIconType())) continue;
                    if (bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                        bill.setIconUrl(this.buildUrl(bill.getContentIcon(), portalInfoContent.getLabelTypeSource(), bill.getIconUrl()));
                        continue;
                    }
                    if (!bill.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) continue;
                    bill.setIconUrl(this.envProperties.getSemcWebUrl() + bill.getContentIcon());
                }
                portalInfoContent.setContentConfig((Object)kingKongDistrict);
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalContentCarousel carouselInfo = (MobilePortalContentCarousel)JSON.parseObject((String)portalInfoContent.getContentAttr(), MobilePortalContentCarousel.class);
                portalInfoContent.setContentConfig((Object)carouselInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalContentNews newsInfo = (MobilePortalContentNews)JSON.parseObject((String)portalInfoContent.getContentAttr(), MobilePortalContentNews.class);
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(Integer.valueOf(0));
                }
                portalInfoContent.setContentConfig((Object)newsInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = (MobilePortalTitleInfoReqDTO)JSON.parseObject((String)portalInfoContent.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                String iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.buildUrl(iconUrl, portalInfoContent.getLabelTypeSource(), titleInfo.getIconUrl());
                }
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.envProperties.getSemcWebUrl() + iconUrl;
                }
                titleInfo.setIconUrl(iconUrl);
                portalInfoContent.setContentConfig((Object)titleInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = (MobilePortalDividerInfoReqDTO)JSON.parseObject((String)portalInfoContent.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                portalInfoContent.setContentConfig((Object)dividerInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = (MobilePortalImageInfoReqDTO)JSON.parseObject((String)portalInfoContent.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty((CharSequence)imageCompInfo.getImageId())) {
                    imageCompInfo.setImageUrl(this.buildUrl(imageCompInfo.getImageId(), portalInfoContent.getLabelTypeSource(), imageCompInfo.getImageUrl()));
                }
                portalInfoContent.setContentConfig((Object)imageCompInfo);
            }
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(portalInfoContent.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = (MobilePortalBusinessInfoReqDTO)JSON.parseObject((String)portalInfoContent.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty((Collection)businessCompInfo.getImageList())) {
                    for (MobilePortalBusImageReqDTO image : businessCompInfo.getImageList()) {
                        image.setImageUrl(this.buildUrl(image.getImageId(), portalInfoContent.getLabelTypeSource(), image.getImageUrl()));
                    }
                }
                portalInfoContent.setContentConfig((Object)businessCompInfo);
            }
            if (!Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(portalInfoContent.getContentType())) continue;
            portalInfoContent.setContentConfig(JSON.parseObject((String)portalInfoContent.getContentAttr(), Object.class));
        }
        portalInfo.setContentList(portalInfoContentList);
        return portalInfo;
    }

    private String buildUrl(String fileId, Integer labelTypeSource, String fullUrl) {
        String url;
        String string = url = StringUtils.isEmpty((CharSequence)fileId) ? "" : this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + fileId;
        if (Constants.LabelTypeSourceEnum.ISV.getFlag().equals(labelTypeSource) && StringUtils.isNotBlank((CharSequence)fullUrl) && fullUrl.startsWith("https://")) {
            url = fullUrl;
        }
        return url;
    }

    public PortalInfoUse getUserPortal() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PortalInfoUse::getTenantId, (Object)Utils.getTenantId())).eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId())).eq(PortalInfoUse::getClientType, (Object)1);
        PortalInfoUse portalInfoUse = (PortalInfoUse)this.portalInfoUseMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.nonNull(portalInfoUse)) {
            Long portalId = portalInfoUse.getPortalId();
            PortalInfo portalInfo = null;
            if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(portalInfoUse.getPortalTypeSource())) {
                portalInfo = this.queryPortalInfoByDesignerId(portalId);
            } else {
                LambdaQueryWrapper portalInfoLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getId, (Object)portalId)).eq(PortalInfo::getClientType, (Object)Constants.ClientTypeTypeEnum.MOBILE.getFlag());
                portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)portalInfoLambdaQueryWrapper));
            }
            if (Objects.nonNull(portalInfo)) {
                portalInfoUse.setVersionDefault(portalInfo.getVersionDefault());
                portalInfoUse.setName(portalInfo.getName());
            } else {
                MobilePortalInfo mobilePortalInfo = (MobilePortalInfo)InterceptorIgnoreUtil.handler(() -> (MobilePortalInfo)this.mobilePortalInfoMapper.selectById((Serializable)portalId));
                if (Objects.nonNull(mobilePortalInfo)) {
                    portalInfoUse.setVersionDefault(Integer.valueOf(0));
                    portalInfoUse.setName(mobilePortalInfo.getName());
                } else {
                    return null;
                }
            }
            String tenantVersion = this.kmService.queryTenantVersionWithDefault();
            if (Objects.equals(1, portalInfoUse.getPortalTypeSource()) && Objects.nonNull(portalInfo) && Objects.nonNull(portalInfo.getPortalDesignerId())) {
                LambdaQueryWrapper portalDeployMessageLambdaQueryWrapper = new LambdaQueryWrapper();
                LambdaQueryWrapper in = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)portalDeployMessageLambdaQueryWrapper.eq(PortalDeployMessage::getPortalId, (Object)portalInfo.getPortalDesignerId())).eq(PortalDeployMessage::getVersion, (Object)tenantVersion)).eq(PortalDeployMessage::getUserSid, (Object)Utils.getUserSid())).eq(PortalDeployMessage::getClientType, (Object)1);
                List portalDeployMessages = (List)InterceptorIgnoreUtil.handler(() -> this.portalDeployMessageService.getBaseMapper().selectList((Wrapper)in));
                if (CollectionUtils.isEmpty((Collection)portalDeployMessages)) {
                    portalInfoUse.setChanged(Integer.valueOf(1));
                } else {
                    portalInfoUse.setChanged(Integer.valueOf(0));
                }
            }
            return portalInfoUse;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getCreateUserId, (Object)Utils.getUserId());
        MobilePortalInfoUse mobilePortalInfoUse = (MobilePortalInfoUse)this.mobilePortalInfoUseMapper.selectOne((Wrapper)lambdaQueryWrapper);
        if (mobilePortalInfoUse != null) {
            portalInfoUse = new PortalInfoUse();
            portalInfoUse.setId(mobilePortalInfoUse.getId());
            portalInfoUse.setTenantId(mobilePortalInfoUse.getTenantId());
            portalInfoUse.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
            portalInfoUse.setPortalId(mobilePortalInfoUse.getMobilePortalId());
            portalInfoUse.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            portalInfoUse.setVersionDefault(Integer.valueOf(0));
            MobilePortalInfo portalInfo = (MobilePortalInfo)InterceptorIgnoreUtil.handler(() -> (MobilePortalInfo)this.mobilePortalInfoMapper.selectById((Serializable)mobilePortalInfoUse.getMobilePortalId()));
            if (Objects.nonNull(portalInfo)) {
                portalInfoUse.setName(portalInfo.getName());
            } else {
                return null;
            }
        }
        return portalInfoUse;
    }

    public PortalInfo getDefaultPortal() {
        LambdaQueryWrapper portalInfoLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)portalInfoLambdaQueryWrapper.eq(PortalInfo::getDefaultFlag, (Object)1)).eq(PortalInfo::getClientType, (Object)1)).eq(PortalInfo::getTenantId, (Object)Utils.getTenantId());
        PortalInfo portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)portalInfoLambdaQueryWrapper));
        if (Objects.isNull(portalInfo)) {
            portalInfo = this.initDefPortal(Constants.ClientTypeEnum.MOBILE.getValue());
        }
        return portalInfo;
    }

    private List<Long> buildCustomIdList(List<PortalInfoContent> portalInfoContentList, Constants.LabelOrPoralSourceEnum tenant) {
        List tenantCustomIdsFormAttr = this.getPortalSystemId(portalInfoContentList, tenant.getFlag());
        List<Long> tenantCustomIds = portalInfoContentList.stream().filter(item -> Constants.PrtalContentTypeEnum.LABEL_SYSTEM_CUSTOM.getVal().equals(item.getContentType()) && tenant.getFlag().equals(item.getLabelTypeSource())).map(PortalInfoContent::getContentId).collect(Collectors.toList());
        tenantCustomIds.addAll(tenantCustomIdsFormAttr);
        return tenantCustomIds;
    }

    public PortalInfo getTempPortal(Long id) {
        PortalInfo portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.getPortalById(id));
        return portalInfo;
    }

    public ResponseEntity<?> checkPortalInfo(PortalInfo portalInfo) {
        PortalInfoCheckResp checkResp = new PortalInfoCheckResp();
        checkResp.setIsHavePort(Boolean.valueOf(false));
        QueryWrapper condition = new QueryWrapper();
        QueryWrapper wrapper = this.labelSystemAuthService.getUserAuthCon(condition);
        wrapper.eq((Object)"client_type", (Object)portalInfo.getClientType());
        List portalInfoAuthList = this.portalInfoAuthMapper.selectList((Wrapper)wrapper);
        List portalIds = portalInfoAuthList.stream().map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
        if (portalIds.contains(portalInfo.getId()) || portalIds.contains(portalInfo.getPortalDesignerId())) {
            checkResp.setIsHavePort(Boolean.valueOf(true));
        } else {
            String msg = this.messageUtils.getMessage("error.message.not.auth");
            if (portalInfo.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                msg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
            }
            checkResp.setErrorMsg(msg);
        }
        return ResponseEntityWrapper.wrapperOk((Object)checkResp);
    }

    public List<PortalInfo> queryPortalByMenuTempId(List<Long> menuTempIdList) {
        QueryWrapper portalInfoWrapper = new QueryWrapper();
        portalInfoWrapper.in((Object)"menu_template_id", menuTempIdList);
        portalInfoWrapper.select(new String[]{"id", "menu_template_id"});
        List portalInfoList = this.portalInfoMapper.selectList((Wrapper)portalInfoWrapper);
        return portalInfoList;
    }

    public List<PortalSelectOptionRespDTO> queryLinkList(Integer isvDesign) {
        List<Object> optionRespDTOS = new ArrayList<PortalSelectOptionRespDTO>();
        QueryWrapper platformWrapper = new QueryWrapper();
        platformWrapper.eq((Object)"scene_code", (Object)Constants.SceneCodeEnum.PORTAL_SELECT_OPTION.getCode());
        PlatformInitConfig platformInitConfig = (PlatformInitConfig)this.platformInitConfigMapper.selectOne((Wrapper)platformWrapper);
        if (null == platformInitConfig) {
            return optionRespDTOS;
        }
        optionRespDTOS = JSON.parseArray((String)platformInitConfig.getConfigValue(), PortalSelectOptionRespDTO.class);
        if (ObjectUtil.equals((Object)isvDesign, (Object)Constants.LabelOrPoralSourceEnum.ISV.getFlag())) {
            return optionRespDTOS.stream().filter(e -> Constants.WebLinkTypeEnum.getTenantDesign().contains(e.getType())).collect(Collectors.toList());
        }
        return optionRespDTOS;
    }

    public WebLinkPermissionDTO checkLinkPerm(WebLinkPermissionDTO req) {
        if (req.getType().equals(Constants.WebLinkTypeEnum.JOB_BENCH.getVal()) || req.getType().equals(Constants.WebLinkTypeEnum.CALENDAR.getVal()) || req.getType().equals(Constants.WebLinkTypeEnum.APP.getVal()) || req.getType().equals(Constants.WebLinkTypeEnum.JOB.getVal())) {
            Integer labelType = Constants.LabelTypeEnum.SYSTEM_CUSTOM.getVal();
            if (req.getType().equals(Constants.WebLinkTypeEnum.JOB_BENCH.getVal()) || req.getType().equals(Constants.WebLinkTypeEnum.CALENDAR.getVal())) {
                labelType = Constants.LabelTypeEnum.SYSTEM_PRE.getVal();
                req.setJumpValue(this.getPreSystemId(req.getType()) + "");
            }
            if (StringUtils.isEmpty((CharSequence)req.getJumpValue())) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
            QueryWrapper condition = new QueryWrapper();
            List bizObjAuthRelList = this.labelSystemAuthMapper.selectList((Wrapper)this.labelSystemAuthService.getUserAuthCon(condition));
            Map<String, LabelSystemAuth> labelSystemAuthMap = bizObjAuthRelList.stream().collect(Collectors.toMap(value -> value.getLabelId() + "-" + value.getLabelType(), value -> value, (key1, key2) -> key1));
            String authKey = req.getJumpValue() + "-" + labelType;
            if (null == labelSystemAuthMap) {
                req.setIsHavePerm(Boolean.FALSE);
            }
            if (null == labelSystemAuthMap.get(authKey)) {
                req.setIsHavePerm(Boolean.FALSE);
            }
        }
        if (req.getType().equals(Constants.WebLinkTypeEnum.NEWS_ONE.getVal())) {
            if (StringUtils.isEmpty((CharSequence)req.getJumpValue())) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
            List autList = this.newsAnnouncementAuthService.queryAuthNewsListByNewsTypeIdList(new ArrayList());
            if (CollectionUtils.isEmpty((Collection)autList)) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
            List newsIdDistinctList = autList.stream().map(NewsAnnouncementAut::getNewsId).distinct().collect(Collectors.toList());
            if (!newsIdDistinctList.contains(Long.parseLong(req.getJumpValue()))) {
                req.setIsHavePerm(Boolean.FALSE);
                return req;
            }
        }
        return req;
    }

    public Long getPreSystemId(Integer type) {
        List preSystemList;
        Map preInfoMap;
        ArrayList<Integer> dataTypeList = new ArrayList<Integer>();
        if (type.equals(Constants.WebLinkTypeEnum.JOB_BENCH.getVal())) {
            dataTypeList.add(Constants.DataTypeEnum.TYPE_JOB.getVal());
            type = Constants.DataTypeEnum.TYPE_JOB.getVal();
        }
        if (type.equals(Constants.WebLinkTypeEnum.CALENDAR.getVal())) {
            dataTypeList.add(Constants.DataTypeEnum.TYPE_CALENDAR.getVal());
            type = Constants.DataTypeEnum.TYPE_CALENDAR.getVal();
        }
        if (null == (preInfoMap = (preSystemList = this.labelSystemPreService.initDefPortal(dataTypeList, Constants.ClientTypeEnum.PC.getValue())).stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a))) || null == preInfoMap.get(type)) {
            return null;
        }
        return ((LabelSystemPre)preInfoMap.get(type)).getId();
    }

    public PortalInfo queryPortalInfoByDesignerId(Long designerId) {
        String tenantVersion = this.kmService.queryTenantVersionWithDefault();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PortalInfo::getPortalDesignerId, (Object)designerId);
        queryWrapper.eq(PortalInfo::getVersion, (Object)tenantVersion);
        List portalInfoList = (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoMapper.selectList((Wrapper)queryWrapper));
        if (CollectionUtils.isNotEmpty((Collection)portalInfoList)) {
            return (PortalInfo)portalInfoList.get(0);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<?> copyPortal(Long portalId, Boolean oldPortalFlag) {
        Long newPortalId = null;
        if (Boolean.TRUE.equals(oldPortalFlag)) {
            MobilePortalInfo mobilePortalInfo = (MobilePortalInfo)this.mobilePortalService.getById((Serializable)portalId);
            if (null == mobilePortalInfo) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)recentlyMsg);
            }
            newPortalId = this.copyPortalOfOldPortalMobile(portalId, mobilePortalInfo);
        } else {
            PortalInfo portalInfo = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectById((Serializable)portalId));
            if (null == portalInfo) {
                String recentlyMsg = this.messageUtils.getMessage("error.message.choose.portal.recovery");
                return ResponseEntityWrapperUtil.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)recentlyMsg);
            }
            newPortalId = "SYSTEM_TENANT".equals(portalInfo.getTenantId()) ? this.copyPortalOfIsvPortal(portalId, portalInfo) : this.copyPortalOfTenantPortal(portalId, portalInfo);
        }
        return ResponseEntityWrapperUtil.wrapperOk((Object)newPortalId);
    }

    private Long copyPortalOfIsvPortal(Long portalId, PortalInfo portalInfo) {
        if (Constants.ClientTypeTypeEnum.PC.getFlag().equals(portalInfo.getClientType())) {
            return this.copyPortalOfPortalPc(Constants.PortalTypeSourceEnum.ISV, portalId, portalInfo);
        }
        return this.copyPortalOfPortalMobile(Constants.PortalTypeSourceEnum.ISV, portalId, portalInfo, Constants.ClientTypeTypeEnum.MOBILE);
    }

    private Long copyPortalOfTenantPortal(Long portalId, PortalInfo portalInfo) {
        if (Constants.ClientTypeTypeEnum.PC.getFlag().equals(portalInfo.getClientType())) {
            return this.copyPortalOfPortalPc(Constants.PortalTypeSourceEnum.TENANT, portalId, portalInfo);
        }
        return this.copyPortalOfPortalMobile(Constants.PortalTypeSourceEnum.TENANT, portalId, portalInfo, Constants.ClientTypeTypeEnum.MOBILE);
    }

    private Long copyPortalOfPortalPc(Constants.PortalTypeSourceEnum portalTypeSourceEnum, Long oldPortalId, PortalInfo portalInfo) {
        Long templateId = null;
        if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
            templateId = this.copyIsvMenu(portalInfo.getName(), portalInfo.getMenuTemplateId());
            if (null != templateId) {
                portalInfo.setMenuTemplateId(templateId);
            } else {
                portalInfo.setMenuTemplateId(null);
            }
            portalInfo.setMenuTypeSource(Constants.SourceEnum.TENANT.getFlag());
        }
        Long newPortalId = this.copyPortalOfPortalMobile(portalTypeSourceEnum, oldPortalId, portalInfo, Constants.ClientTypeTypeEnum.PC);
        if (templateId != null) {
            CustomizedMenuTemplate template = new CustomizedMenuTemplate();
            template.setId(templateId);
            template.setPortalId(newPortalId);
            InterceptorIgnoreUtil.handler(() -> this.customizedMenuTemplateMapper.updateById((Object)template));
        }
        return newPortalId;
    }

    private Long copyIsvMenu(String name, Long menuDesignerId) {
        if (null == menuDesignerId) {
            return null;
        }
        String tenantVersion = this.kmService.queryTenantVersionWithDefault();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(CustomizedMenuTemplate::getMenuDesignerId, (Object)menuDesignerId)).eq(CustomizedMenuTemplate::getVersion, (Object)tenantVersion);
        CustomizedMenuTemplate template = (CustomizedMenuTemplate)InterceptorIgnoreUtil.handler(() -> (CustomizedMenuTemplate)this.customizedMenuTemplateMapper.selectOne((Wrapper)wrapper));
        if (ObjectUtils.isEmpty((Object)template)) {
            return null;
        }
        Long oldMenuTemplateId = template.getId();
        template.setId(null);
        template.setMenuDesignerId(null);
        template.setWorkbenchAppCode(null);
        template.setVersion(null);
        template.setCompileVersion(null);
        template.setPublishSource(template.getPublishSource());
        template.setTemplateStatus(Constants.ReleaseEnum.RELEASED.getVal());
        template.setCreateUserName(Utils.getUserName());
        template.setCreateTime(DateUtils.getNowTime((String)""));
        template.setModifyUserName(Utils.getUserName());
        template.setModifyTime(DateUtils.getNowTime((String)""));
        template.setModifyUserId(Utils.getUserId());
        int length = name.length();
        if (length > 27) {
            name = name.substring(0, 27);
        }
        template.setTemplateName(name + "-\u83dc\u5355");
        template.setTemplateNameTw(name + "-\u83dc\u5355");
        this.customizedMenuTemplateMapper.insert((Object)template);
        Long newMenuTemplateId = template.getId();
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"template_id", (Object)oldMenuTemplateId);
        condition.orderByAsc((Object)"menu_order");
        condition.orderByAsc((Object)"id");
        List menuList = (List)InterceptorIgnoreUtil.handler(() -> this.customizedMenuWorkMapper.selectList((Wrapper)condition));
        Map menuWorkMap = menuList.stream().collect(Collectors.toMap(CustomizedMenuWork::getId, Function.identity(), (a, b) -> a));
        List menuWorkRespList = this.customizedMenuWorkService.queryManageMenu(oldMenuTemplateId);
        for (CustomizedMenuWorkResp menuWorkResp : menuWorkRespList) {
            this.copyIsvMenuWork(menuWorkMap, menuWorkResp, newMenuTemplateId, null);
        }
        return newMenuTemplateId;
    }

    private void copyIsvMenuWork(Map<Long, CustomizedMenuWork> menuWorkMap, CustomizedMenuWorkResp menuWorkResp, Long newMenuTemplateId, Long parentId) {
        CustomizedMenuWork menuWork = menuWorkMap.get(menuWorkResp.getId());
        menuWork.setId(null);
        menuWork.setTemplateId(newMenuTemplateId);
        menuWork.setParentId(parentId);
        menuWork.setTenantId(Utils.getTenantId());
        menuWork.setCreateUserId(Utils.getUserId());
        menuWork.setCreateTime(DateUtils.getNowTime((String)""));
        menuWork.setModifyTime(DateUtils.getNowTime((String)""));
        menuWork.setModifyUserId(Utils.getUserId());
        this.customizedMenuWorkService.save((Object)menuWork);
        if (CollectionUtils.isNotEmpty((Collection)menuWorkResp.getChildren())) {
            for (CustomizedMenuWorkResp child : menuWorkResp.getChildren()) {
                this.copyIsvMenuWork(menuWorkMap, child, newMenuTemplateId, menuWork.getId());
            }
        }
    }

    private Long copyPortalOfPortalMobile(Constants.PortalTypeSourceEnum portalTypeSourceEnum, Long oldPortalId, PortalInfo portalInfo, Constants.ClientTypeTypeEnum clientTypeEnum) {
        portalInfo.setId(null);
        if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
            portalInfo.setPortalDesignerId(null);
            portalInfo.setWorkbenchAppCode(null);
            portalInfo.setVersion(null);
            portalInfo.setCompileVersion(null);
            portalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
        }
        portalInfo.setTenantId(Utils.getTenantId());
        portalInfo.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        portalInfo.setCreateUserName(Utils.getUserName());
        portalInfo.setCreateTime(DateUtils.getNowTime((String)""));
        portalInfo.setModifyUserName(Utils.getUserName());
        portalInfo.setModifyTime(DateUtils.getNowTime((String)""));
        portalInfo.setModifyUserId(Utils.getUserId());
        String name = portalInfo.getName();
        int length = name.length();
        if (length > 12) {
            name = name.substring(0, 12);
        }
        name = name + "_" + DateUtils.getNowTime((String)"yyyyMMddHHmmss_\u590d\u5236");
        portalInfo.setName(name);
        this.portalInfoMapper.insert((Object)portalInfo);
        Long newPortalId = portalInfo.getId();
        LambdaQueryWrapper contentWrapper = new LambdaQueryWrapper();
        contentWrapper.eq(PortalInfoContent::getPortalId, (Object)oldPortalId);
        List contentList = (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoContentMapper.selectList((Wrapper)contentWrapper));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, (Object)clientTypeEnum.getFlag());
        List systemPres = (List)InterceptorIgnoreUtil.handler(() -> this.labelSystemPreMapper.selectList((Wrapper)wrapper));
        Map preIdMap = null;
        preIdMap = Constants.ClientTypeTypeEnum.PC == clientTypeEnum ? systemPres.stream().collect(Collectors.toMap(LabelSystemPre::getDataType, Function.identity(), (a, b) -> a)) : systemPres.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
        for (PortalInfoContent content : contentList) {
            content.setId(null);
            if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
                Long contetnId;
                if (Constants.ClientTypeTypeEnum.PC == clientTypeEnum) {
                    Long contentId;
                    if (ComponentSourceEnum.LABEL_SYSTEM_PRE.getCode().equals(content.getContentType()) && (contentId = (Long)Optional.ofNullable(preIdMap.get(content.getDataType())).map(LabelSystemPre::getId).orElse(null)) != null) {
                        content.setContentId(contentId);
                        content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                    }
                } else if (Constants.PrtalMobileContentTypeEnum.isPreContent((Integer)content.getContentType()) && (contetnId = (Long)Optional.ofNullable(preIdMap.get(content.getContentType())).map(LabelSystemPre::getId).orElse(null)) != null) {
                    content.setContentId(contetnId);
                    content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                }
            }
            content.setTenantId(Utils.getTenantId());
            content.setPortalId(newPortalId);
            content.setCreateTime(DateUtils.getNowTime((String)""));
            this.portalInfoContentMapper.insert((Object)content);
        }
        LambdaQueryWrapper authWrapper = new LambdaQueryWrapper();
        authWrapper.eq(PortalInfoAuth::getPortalId, (Object)oldPortalId);
        List portalAuthList = (List)InterceptorIgnoreUtil.handler(() -> this.portalInfoAuthMapper.selectList((Wrapper)authWrapper));
        for (PortalInfoAuth auth : portalAuthList) {
            auth.setId(null);
            if (Constants.PortalTypeSourceEnum.ISV == portalTypeSourceEnum) {
                auth.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            }
            auth.setTenantId(Utils.getTenantId());
            auth.setPortalId(newPortalId);
            auth.setCreateTime(DateUtils.getNowTime((String)""));
            this.portalInfoAuthMapper.insert((Object)auth);
        }
        return newPortalId;
    }

    private Long copyPortalOfOldPortalMobile(Long oldPortalId, MobilePortalInfo mobilePortalInfo) {
        PortalInfo pcPortalInfo = new PortalInfo();
        pcPortalInfo.setId(null);
        pcPortalInfo.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
        pcPortalInfo.setClientType(Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        pcPortalInfo.setPortalType(mobilePortalInfo.getPortalType());
        pcPortalInfo.setTitle(mobilePortalInfo.getTitle());
        pcPortalInfo.setBgColor(mobilePortalInfo.getBgColor());
        pcPortalInfo.setPortalDesignerId(null);
        pcPortalInfo.setWorkbenchAppCode(null);
        pcPortalInfo.setParentId(Long.valueOf(0L));
        pcPortalInfo.setTemplateId(null);
        pcPortalInfo.setDefaultFlag(mobilePortalInfo.getDefaultFlag());
        pcPortalInfo.setName(mobilePortalInfo.getName());
        pcPortalInfo.setPortalDesc(mobilePortalInfo.getPortalDesc());
        pcPortalInfo.setMenuTemplateId(null);
        pcPortalInfo.setStatus(Constants.ReleaseEnum.NO_RELEASE.getVal());
        pcPortalInfo.setPortalContent(mobilePortalInfo.getPortalContent());
        pcPortalInfo.setPortalImgId(mobilePortalInfo.getPortalImgId());
        pcPortalInfo.setTenantId(mobilePortalInfo.getTenantId());
        pcPortalInfo.setCreateUserName(Utils.getUserName());
        pcPortalInfo.setCreateTime(DateUtils.getNowTime((String)""));
        pcPortalInfo.setModifyUserName(Utils.getUserName());
        pcPortalInfo.setModifyTime(DateUtils.getNowTime((String)""));
        pcPortalInfo.setModifyUserId(Utils.getUserId());
        pcPortalInfo.setPublishSource(PublishSourceEnum.TENANT.name());
        String name = mobilePortalInfo.getName();
        int length = name.length();
        if (length > 12) {
            name = name.substring(0, 12);
        }
        name = name + "_" + DateUtils.getNowTime((String)"yyyyMMddHHmmss") + "_\u590d\u5236";
        pcPortalInfo.setName(name);
        pcPortalInfo.setVersionDefault(Integer.valueOf(0));
        this.portalInfoMapper.insert((Object)pcPortalInfo);
        List contentList = this.mobilePortalInfoContentMapper.queryMobiePortalCont(oldPortalId, new ArrayList());
        ArrayList excludeContentId = new ArrayList();
        Long newPortalId = pcPortalInfo.getId();
        List districList = contentList.stream().filter(r -> Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(r.getContentType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(districList)) {
            for (MobilePortalInfoContent content : districList) {
                PortalContentKingKongDistrict kingKongDistrict = new PortalContentKingKongDistrict();
                kingKongDistrict.setIsNameShow(content.getIsNameShow());
                kingKongDistrict.setInteractionType(content.getInteractionType());
                kingKongDistrict.setCustomType(content.getCustomType());
                kingKongDistrict.setColumnNum(content.getColumnNum());
                kingKongDistrict.setLineNum(content.getLineNum());
                List child = contentList.stream().filter(r -> content.getId().equals(r.getParentId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(child)) {
                    kingKongDistrict.setBallList(child.stream().map(r -> {
                        excludeContentId.add(r.getId());
                        PortalContentKingKongDistrictBall ball = new PortalContentKingKongDistrictBall();
                        ball.setBallName(r.getContentName());
                        ball.setIconType(r.getIconType());
                        ball.setContentIcon(r.getContentIcon());
                        ball.setIconUrl(r.getIconUrl());
                        ball.setJumpType(r.getJumpType());
                        ball.setJumpTarget(r.getJumpTarget());
                        ball.setCustomApplicationId(r.getCustomApplicationId());
                        return ball;
                    }).collect(Collectors.toList()));
                }
                content.setContentAttr(JSON.toJSONString((Object)kingKongDistrict));
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, (Object)Constants.ClientTypeTypeEnum.MOBILE.getFlag());
        Map<Integer, Long> preIdMap = ((List)InterceptorIgnoreUtil.handler(() -> this.labelSystemPreMapper.selectList((Wrapper)wrapper))).stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, LabelSystemPre::getId, (key1, key2) -> key2));
        for (MobilePortalInfoContent content : contentList) {
            if (excludeContentId.contains(content.getId())) continue;
            PortalInfoContent pcContent = new PortalInfoContent();
            pcContent.setId(null);
            pcContent.setParentId(Long.valueOf(0L));
            pcContent.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
            pcContent.setPortalId(newPortalId);
            pcContent.setContentId(preIdMap.get(content.getContentType()));
            pcContent.setContentType(content.getContentType());
            pcContent.setContentName(content.getContentName());
            pcContent.setTenantId(content.getTenantId());
            pcContent.setContentUuid(content.getContentUuid());
            pcContent.setContentAttr(content.getContentAttr());
            pcContent.setCreateTime(DateUtils.getNowTime((String)""));
            this.portalInfoContentMapper.insert((Object)pcContent);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MobilePortalInfoAuth::getMobilePortalId, (Object)oldPortalId);
        List mobilePortalAuthList = (List)InterceptorIgnoreUtil.handler(() -> this.mobilePortalInfoAuthMapper.selectList((Wrapper)queryWrapper));
        for (MobilePortalInfoAuth mobilePortalAuth : mobilePortalAuthList) {
            PortalInfoAuth auth = new PortalInfoAuth();
            auth.setId(null);
            auth.setAuthId(mobilePortalAuth.getAuthId());
            auth.setAuthName(mobilePortalAuth.getAuthName());
            auth.setAuthType(mobilePortalAuth.getAuthType());
            auth.setTenantId(mobilePortalInfo.getTenantId());
            auth.setPortalId(newPortalId);
            auth.setPortalTypeSource(Constants.PortalTypeSourceEnum.TENANT.getFlag());
            auth.setCreateTime(DateUtils.getNowTime((String)""));
            this.portalInfoAuthMapper.insert((Object)auth);
        }
        return newPortalId;
    }

    public PortalInfo getUserMobilePortalInfo(UserPortalInfoRequest req) {
        LambdaQueryWrapper queryWrapper;
        PortalInfo result = new PortalInfo();
        List<Object> portalInfoContents = new ArrayList();
        String version = this.kmService.queryTenantVersionWithDefault();
        if (Constants.PortalTypeSourceEnum.ISV.getFlag().equals(req.getPortalTypeSource())) {
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getPortalDesignerId, (Object)req.getId())).eq(PortalInfo::getVersion, (Object)version);
            result = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
            if (result != null) {
                portalInfoContents = this.portalInfoContentMapper.queryPortalCont(result.getId(), new ArrayList());
            }
        } else {
            MobilePortalInfo mobilePortalInfo;
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PortalInfo::getId, (Object)req.getId())).eq(PortalInfo::getClientType, (Object)req.getClientType());
            result = (PortalInfo)InterceptorIgnoreUtil.handler(() -> (PortalInfo)this.portalInfoMapper.selectOne((Wrapper)queryWrapper));
            if (result != null) {
                portalInfoContents = this.portalInfoContentMapper.queryPortalCont(result.getId(), new ArrayList());
            }
            if (result == null && Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType()) && (mobilePortalInfo = (MobilePortalInfo)this.mobilePortalInfoMapper.selectById((Serializable)req.getId())) != null) {
                result = new PortalInfo();
                BeanUtils.copyProperties((Object)mobilePortalInfo, (Object)result);
                result.setClientType(Constants.ClientTypeEnum.MOBILE.getValue());
                result.setMenuTypeSource(Constants.MenuTypeSourceEnum.TENANT.getFlag());
                result.setPublishSource(PublishSourceEnum.TENANT.name());
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(MobilePortalInfoContent::getMobilePortalId, (Object)mobilePortalInfo.getId());
                List mobilePortalInfoContentsSql = this.mobilePortalInfoContentMapper.selectList((Wrapper)wrapper);
                Map<Long, List<MobilePortalInfoContent>> ballMap = mobilePortalInfoContentsSql.stream().filter(x -> Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(x.getContentType())).collect(Collectors.groupingBy(MobilePortalInfoContent::getParentId));
                portalInfoContents = mobilePortalInfoContentsSql.stream().filter(x -> !Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(x.getContentType())).map(r -> {
                    PortalInfoContent portalInfoContent = new PortalInfoContent();
                    BeanUtils.copyProperties((Object)r, (Object)portalInfoContent);
                    portalInfoContent.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
                    if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(r.getContentType())) {
                        PortalContentKingKongDistrict district = new PortalContentKingKongDistrict();
                        district.setIsNameShow(r.getIsNameShow());
                        district.setInteractionType(r.getInteractionType());
                        district.setCustomType(r.getCustomType());
                        district.setColumnNum(r.getColumnNum());
                        district.setLineNum(r.getLineNum());
                        List ballList = (List)ballMap.get(r.getId());
                        if (CollectionUtils.isNotEmpty((Collection)ballList)) {
                            district.setBallList(ballList.stream().map(content -> {
                                PortalContentKingKongDistrictBall ball = new PortalContentKingKongDistrictBall();
                                ball.setBallName(content.getContentName());
                                ball.setIconType(content.getIconType());
                                ball.setContentIcon(content.getContentIcon());
                                ball.setJumpType(content.getJumpType());
                                ball.setJumpTarget(content.getJumpTarget());
                                ball.setCustomApplicationId(content.getCustomApplicationId());
                                if (ObjectUtils.isNotEmpty((Object)content.getIconType())) {
                                    if (content.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                                        ball.setIconUrl(this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + ball.getContentIcon());
                                    } else if (content.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                                        ball.setIconUrl(this.envProperties.getSemcWebUrl() + ball.getContentIcon());
                                    }
                                }
                                return ball;
                            }).collect(Collectors.toList()));
                        }
                        portalInfoContent.setContentAttr(JSON.toJSONString((Object)district));
                    }
                    return portalInfoContent;
                }).collect(Collectors.toList());
            }
        }
        if (ObjectUtils.isEmpty((Object)result)) {
            return result;
        }
        if (CollectionUtils.isEmpty(portalInfoContents)) {
            return result;
        }
        ArrayList<PortalInfoContent> resultContentList = new ArrayList<PortalInfoContent>();
        for (PortalInfoContent content : portalInfoContents) {
            MobilePortalContentNews newsInfo;
            if (Constants.PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(content.getContentType())) continue;
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType())) {
                PortalContentKingKongDistrict district = (PortalContentKingKongDistrict)JSON.parseObject((String)content.getContentAttr(), PortalContentKingKongDistrict.class);
                if (Constants.DistrictCustomTypeEnum.TENANT_TYPE.getValue().equals(district.getCustomType())) {
                    List ballList = district.getBallList();
                    List ballAuth = this.filterPermissionBallList(ballList);
                    ballAuth.forEach(ball -> {
                        if (ObjectUtils.isNotEmpty((Object)ball.getIconType())) {
                            if (ball.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                                ball.setIconUrl(this.buildUrl(ball.getContentIcon(), content.getLabelTypeSource(), ball.getIconUrl()));
                            } else if (ball.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                                ball.setIconUrl(this.envProperties.getSemcWebUrl() + ball.getContentIcon());
                            }
                        }
                    });
                    district.setBallList(ballAuth);
                    content.setContentAttr(JSON.toJSONString((Object)district));
                    resultContentList.add(content);
                }
                if (!Constants.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(district.getCustomType())) continue;
                resultContentList.addAll(this.buildColumnDistrict(content));
                continue;
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(content.getContentType())) {
                MobilePortalContentCarousel carouselInfo = (MobilePortalContentCarousel)JSON.parseObject((String)content.getContentAttr(), MobilePortalContentCarousel.class);
                for (MobilePortalContentCarouselImage image : carouselInfo.getImageList()) {
                    String icon = image.getContentIcon();
                    if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)icon)) {
                        icon = this.envProperties.getSemcWebUrl() + icon;
                    }
                    image.setContentIcon(icon);
                }
                content.setContentAttr(JSON.toJSONString((Object)carouselInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(content.getContentType()) && null != (newsInfo = (MobilePortalContentNews)JSON.parseObject((String)content.getContentAttr(), MobilePortalContentNews.class))) {
                String[] newsTypeIds;
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(Integer.valueOf(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",") && (newsTypeIds = newsInfo.getNewsTypeIdStr().split(",")).length >= 2) {
                    newsInfo.setChildrenNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[1])));
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[0])));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsInfo.getNewsTypeIdStr())));
                }
                content.setContentAttr(JSON.toJSONString((Object)newsInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(content.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = (MobilePortalTitleInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                Object iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.buildUrl((String)iconUrl, content.getLabelTypeSource(), titleInfo.getIconUrl());
                }
                if (null != titleInfo.getIconType() && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
                    iconUrl = this.envProperties.getSemcWebUrl() + (String)iconUrl;
                }
                titleInfo.setIconUrl((String)iconUrl);
                content.setContentAttr(JSON.toJSONString((Object)titleInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(content.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = (MobilePortalDividerInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                content.setContentAttr(JSON.toJSONString((Object)dividerInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(content.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = (MobilePortalImageInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty((CharSequence)imageCompInfo.getImageId())) {
                    imageCompInfo.setImageUrl(this.buildUrl(imageCompInfo.getImageId(), content.getLabelTypeSource(), imageCompInfo.getImageUrl()));
                }
                content.setContentAttr(JSON.toJSONString((Object)imageCompInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(content.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = (MobilePortalBusinessInfoReqDTO)JSON.parseObject((String)content.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty((Collection)businessCompInfo.getImageList())) {
                    for (MobilePortalContentCarouselImage image : businessCompInfo.getImageList()) {
                        image.setImageUrl(this.buildUrl(image.getImageId(), content.getLabelTypeSource(), image.getImageUrl()));
                    }
                }
                content.setContentAttr(JSON.toJSONString((Object)businessCompInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(content.getContentType())) {
                Map contentInfo = Optional.ofNullable(JSON.parseObject((String)content.getContentAttr(), Map.class)).orElse(new HashMap());
                if (Constants.LabelTypeSourceEnum.TENANT.getFlag().equals(content.getLabelTypeSource())) {
                    AppLinkDTO appLinkDTO = this.labelSystemClickService.queryCustomJumpLink(content.getContentId());
                    if (null != appLinkDTO && appLinkDTO.getIsHavePerm().booleanValue()) {
                        contentInfo.put("cloudwebsite", appLinkDTO.getCloudwebsite());
                    }
                } else {
                    contentInfo.put("cloudwebsite", this.envProperties.getHomePageUrl());
                }
                content.setContentAttr(JSON.toJSONString((Object)contentInfo));
            }
            resultContentList.add(content);
        }
        result.setContentList(resultContentList);
        return result;
    }

    private List<PortalContentKingKongDistrictBall> filterPermissionBallList(List<PortalContentKingKongDistrictBall> ballResps) {
        List notCustomApplicationIdList = ballResps.stream().filter(x -> !Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType())).map(PortalContentKingKongDistrictBall::getCustomApplicationId).collect(Collectors.toList());
        List customApplicationIdList = ballResps.stream().filter(x -> Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue().equals(x.getJumpType())).map(PortalContentKingKongDistrictBall::getCustomApplicationId).collect(Collectors.toList());
        List withPermissionList = this.mobileUserAuthService.validUserAppAuth(customApplicationIdList);
        return ballResps.stream().filter(x -> notCustomApplicationIdList.contains(x.getCustomApplicationId()) || withPermissionList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
    }

    private List<PortalInfoContent> buildColumnDistrict(PortalInfoContent mobileContent) {
        ArrayList<PortalInfoContent> result = new ArrayList<PortalInfoContent>();
        String userId = Utils.getUserId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getCreateUserId, (Object)userId)).eq(MobileApplicatonColumn::getStatus, (Object)Constants.VALID_STATUS_ENABLE)).orderByAsc(MobileApplicatonColumn::getOrderId)).orderByAsc(MobileApplicatonColumn::getId);
        List mobileApplicatonColumns = this.applicatonColumnMapper.selectList((Wrapper)queryWrapper);
        Map<Long, List<MobileApplicatonColumn>> appMap = mobileApplicatonColumns.stream().filter(x -> !ObjectUtils.isEmpty((Object)x.getParentId())).collect(Collectors.groupingBy(MobileApplicatonColumn::getParentId));
        List customAppIds = mobileApplicatonColumns.stream().filter(x -> ObjectUtils.isNotEmpty((Object)x.getCustomApplicationId())).map(MobileApplicatonColumn::getCustomApplicationId).collect(Collectors.toList());
        Map<Object, Object> customAppMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customAppIds)) {
            List mobileDatasourceInfos = this.mobileCustomApplicationMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MobileDatasourceInfo::getStatus, (Object)Constants.VALID_STATUS_ENABLE)).in(MobileDatasourceInfo::getId, customAppIds));
            customAppMap = mobileDatasourceInfos.stream().collect(Collectors.toMap(MobileDatasourceInfo::getId, Function.identity()));
        }
        for (MobileApplicatonColumn mobileApplicatonColumn : mobileApplicatonColumns) {
            if (ObjectUtils.isNotEmpty((Object)mobileApplicatonColumn.getParentId()) || ObjectUtils.isNotEmpty((Object)mobileApplicatonColumn.getCustomApplicationId())) continue;
            PortalInfoContent resp = new PortalInfoContent();
            resp.setColumnId(mobileApplicatonColumn.getId());
            resp.setContentId(mobileContent.getContentId());
            resp.setContentType(Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal());
            resp.setContentName(mobileApplicatonColumn.getName());
            resp.setContentUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            resp.setTitle(mobileApplicatonColumn.getName());
            resp.setIsTitleShow(mobileApplicatonColumn.getIsNameShow());
            PortalContentKingKongDistrict district = new PortalContentKingKongDistrict();
            PortalContentKingKongDistrict mobileDistrict = (PortalContentKingKongDistrict)JSON.parseObject((String)mobileContent.getContentAttr(), PortalContentKingKongDistrict.class);
            resp.setIsNameShow(mobileDistrict.getIsNameShow());
            district.setIsNameShow(mobileDistrict.getIsNameShow());
            district.setInteractionType(mobileDistrict.getInteractionType());
            district.setCustomType(Constants.DistrictCustomTypeEnum.USER_TYPE.getValue());
            district.setColumnNum(mobileDistrict.getColumnNum());
            district.setLineNum(mobileDistrict.getLineNum());
            ArrayList<PortalContentKingKongDistrictBall> ballRespList = new ArrayList<PortalContentKingKongDistrictBall>();
            if (appMap.containsKey(mobileApplicatonColumn.getId())) {
                List<MobileApplicatonColumn> columns = appMap.get(mobileApplicatonColumn.getId());
                for (MobileApplicatonColumn column : columns) {
                    Long customApplicationId = column.getCustomApplicationId();
                    if (!customAppMap.containsKey(customApplicationId)) continue;
                    MobileDatasourceInfo mobileDatasourceInfo = (MobileDatasourceInfo)customAppMap.get(customApplicationId);
                    PortalContentKingKongDistrictBall ballResp = new PortalContentKingKongDistrictBall();
                    ballResp.setBallName(mobileDatasourceInfo.getName());
                    ballResp.setJumpType(Constants.BallJumpTypeEnum.SSO_CONFIGURATION.getValue());
                    ballResp.setJumpTarget(ObjectUtils.isEmpty((Object)mobileDatasourceInfo.getCallBackUrl()) ? "" : mobileDatasourceInfo.getCallBackUrl());
                    String icon = mobileDatasourceInfo.getIcon();
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                        icon = this.envProperties.getSemcWebUrl() + icon;
                    }
                    if (null != mobileDatasourceInfo.getIconType() && mobileDatasourceInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                        icon = this.envProperties.getDmcUri() + "/api/dmc/v2/file/intelligententry/preview/" + icon;
                    }
                    ballResp.setIconUrl(icon);
                    ballResp.setCustomApplicationId(customApplicationId);
                    ballRespList.add(ballResp);
                }
            }
            district.setBallList(ballRespList);
            resp.setContentAttr(JSON.toJSONString((Object)district));
            result.add(resp);
        }
        if (CollectionUtils.isEmpty(result)) {
            result.add(mobileContent);
            return result;
        }
        ArrayList ballList = new ArrayList();
        result.forEach(x -> {
            PortalContentKingKongDistrict mobileDistrict = (PortalContentKingKongDistrict)JSON.parseObject((String)x.getContentAttr(), PortalContentKingKongDistrict.class);
            ballList.addAll(mobileDistrict.getBallList());
        });
        List withPermissionList = this.filterPermissionBallList(ballList);
        List customApplicationIdList = withPermissionList.stream().map(PortalContentKingKongDistrictBall::getCustomApplicationId).collect(Collectors.toList());
        for (PortalInfoContent content : result) {
            PortalContentKingKongDistrict mobileDistrict = (PortalContentKingKongDistrict)JSON.parseObject((String)content.getContentAttr(), PortalContentKingKongDistrict.class);
            List resultBallList = mobileDistrict.getBallList().stream().filter(x -> customApplicationIdList.contains(x.getCustomApplicationId())).collect(Collectors.toList());
            mobileDistrict.setBallList(resultBallList);
            content.setContentAttr(JSON.toJSONString((Object)mobileDistrict));
        }
        return result;
    }

    public PortalInfo getUserMobilePortalDetail(PortalInfo req) {
        List contentRespList = req.getContentList();
        if (CollectionUtils.isEmpty((Collection)contentRespList)) {
            return req;
        }
        if (req.getDefaultFlag().equals(Constants.DEFAULT_CONFIGURED_FLAG_NO)) {
            QueryWrapper condition = new QueryWrapper();
            QueryWrapper wrapper = this.labelSystemAuthService.getUserAuthCon(condition);
            wrapper.eq((Object)"client_type", (Object)req.getClientType());
            List portalInfoAuthList = this.portalInfoAuthMapper.selectList((Wrapper)wrapper);
            List mobilePortalInfoAuths = new ArrayList();
            if (Constants.ClientTypeEnum.MOBILE.getValue().equals(req.getClientType())) {
                mobilePortalInfoAuths = this.mobilePortalInfoAuthMapper.selectList((Wrapper)this.labelSystemAuthService.getUserAuthCon(new QueryWrapper()));
            }
            List portalIds = portalInfoAuthList.stream().map(PortalInfoAuth::getPortalId).collect(Collectors.toList());
            List mobilePortalIds = mobilePortalInfoAuths.stream().map(MobilePortalInfoAuth::getMobilePortalId).collect(Collectors.toList());
            portalIds.addAll(mobilePortalIds);
            String recentlyMsg = "";
            if (!portalIds.contains(req.getId()) && !portalIds.contains(req.getPortalDesignerId())) {
                recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
                if (req.getPortalType().equals(Constants.MobilePortalTypeEnum.CUSTOM_PORTAL.getFlag())) {
                    recentlyMsg = this.messageUtils.getMessage("error.message.mobile.portal.custom.del");
                }
                req.setRecentlyMsg(recentlyMsg);
                return req;
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LabelSystemPre::getTenantId, (Object)Utils.getTenantId());
        wrapper.eq(LabelSystemPre::getClientType, (Object)Constants.ClientTypeEnum.MOBILE.getValue());
        List systemPres = (List)InterceptorIgnoreUtil.handler(() -> this.labelSystemPreMapper.selectList((Wrapper)wrapper));
        Map systemPreMap = systemPres.stream().collect(Collectors.toMap(LabelSystemPre::getDataCategory, Function.identity(), (a, b) -> a));
        for (PortalInfoContent content : contentRespList) {
            Long contetnId;
            if (Constants.PrtalMobileContentTypeEnum.isPreContent((Integer)content.getContentType()) && (contetnId = (Long)Optional.ofNullable(systemPreMap.get(content.getContentType())).map(LabelSystemPre::getId).orElse(null)) != null) {
                content.setContentId(contetnId);
                content.setLabelTypeSource(Constants.LabelTypeSourceEnum.TENANT.getFlag());
            }
            if (!Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(content.getContentType()) && !Constants.PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(content.getContentType()) && !Constants.PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(content.getContentType())) continue;
            LabelSystemPre labelSystemPre = (LabelSystemPre)systemPreMap.get(content.getContentType());
            content.setContentName(StringUtils.isEmpty((CharSequence)content.getContentName()) ? labelSystemPre.getName() : content.getContentName());
        }
        req.setContentList(contentRespList);
        return req;
    }

    public PortalInfo getPreMobilePortal(Long id) {
        PortalInfo result = new PortalInfo();
        MobilePortalPreview mobilePortalPreview = (MobilePortalPreview)InterceptorIgnoreUtil.handler(() -> (MobilePortalPreview)this.mobilePortalPreviewMapper.selectById((Serializable)id));
        if (mobilePortalPreview == null) {
            String recentlyMsg = this.messageUtils.getMessage("error.message.not.auth");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        if (null != mobilePortalPreview.getEndTime() && mobilePortalPreview.getEndTime().before(new Date())) {
            String recentlyMsg = this.messageUtils.getMessage("error.message.choose.qr.code.invalid");
            result.setRecentlyMsg(recentlyMsg);
            return result;
        }
        BeanUtils.copyProperties((Object)mobilePortalPreview, (Object)result);
        String portalContentListJson = mobilePortalPreview.getPortalContentList();
        List mobilePortalInfoContentResps = (List)JsonUtils.jsonToObject((String)portalContentListJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isEmpty((Collection)mobilePortalInfoContentResps)) {
            return result;
        }
        ArrayList<PortalInfoContent> contentList = new ArrayList<PortalInfoContent>();
        for (MobilePortalInfoContentResp contentResp : mobilePortalInfoContentResps) {
            String[] newsTypeIds;
            MobilePortalContentNews newsInfo;
            PortalInfoContent portalInfoContent = new PortalInfoContent();
            BeanUtils.copyProperties((Object)contentResp, (Object)portalInfoContent);
            portalInfoContent.setLabelTypeSource(contentResp.getLabelTypeSource());
            contentList.add(portalInfoContent);
            if (Constants.PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(contentResp.getContentType())) {
                PortalContentKingKongDistrict district = this.buildDistrict(portalInfoContent, contentResp);
                List ballList = district.getBallList();
                List ballAuthResp = this.filterPermissionBallList(ballList);
                ballAuthResp.forEach(item -> {
                    item.setContentIcon(StringUtils.isNotBlank((CharSequence)item.getContentIcon()) ? item.getContentIcon() : "/assets/img/mobile/king/default.svg");
                    if (ObjectUtils.isNotEmpty((Object)item.getIconType())) {
                        if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                            item.setIconUrl(this.buildUrl(item.getContentIcon(), contentResp.getLabelTypeSource(), item.getIconUrl()));
                        } else if (item.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                            item.setIconUrl(this.envProperties.getSemcWebUrl() + item.getContentIcon());
                        }
                    }
                });
                portalInfoContent.setContentAttr(JSON.toJSONString((Object)district));
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(contentResp.getContentType()) && null != (newsInfo = (MobilePortalContentNews)JSON.parseObject((String)contentResp.getContentAttr(), MobilePortalContentNews.class))) {
                if (newsInfo.getNewsLikeCountFlag() == null) {
                    newsInfo.setNewsLikeCountFlag(Integer.valueOf(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && newsInfo.getNewsTypeIdStr().contains(",") && (newsTypeIds = newsInfo.getNewsTypeIdStr().split(",")).length >= 2) {
                    newsInfo.setChildrenNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[1])));
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsTypeIds[0])));
                }
                if (StringUtils.isNotEmpty((CharSequence)newsInfo.getNewsTypeIdStr()) && !newsInfo.getNewsTypeIdStr().contains(",")) {
                    newsInfo.setNewsTypeId(Integer.valueOf(Integer.parseInt(newsInfo.getNewsTypeIdStr())));
                }
                portalInfoContent.setContentAttr(JSON.toJSONString((Object)newsInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(contentResp.getContentType())) {
                MobilePortalContentCarousel carouselInfo = (MobilePortalContentCarousel)JSON.parseObject((String)contentResp.getContentAttr(), MobilePortalContentCarousel.class);
                if (Objects.isNull(carouselInfo)) continue;
                if (CollectionUtils.isNotEmpty((Collection)carouselInfo.getImageList())) {
                    newsTypeIds = carouselInfo.getImageList().iterator();
                    while (newsTypeIds.hasNext()) {
                        MobilePortalContentCarouselImage image = (MobilePortalContentCarouselImage)newsTypeIds.next();
                        String icon = image.getContentIcon();
                        if (null != image.getImgType() && image.getImgType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag()) && StringUtils.isNotEmpty((CharSequence)icon)) {
                            icon = this.envProperties.getSemcWebUrl() + icon;
                        }
                        image.setContentIcon(icon);
                    }
                }
                portalInfoContent.setContentAttr(JSON.toJSONString((Object)carouselInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.TITLE.getVal().equals(contentResp.getContentType())) {
                MobilePortalTitleInfoReqDTO titleInfo = (MobilePortalTitleInfoReqDTO)JSON.parseObject((String)contentResp.getContentAttr(), MobilePortalTitleInfoReqDTO.class);
                Object iconUrl = titleInfo.getIcon();
                if (null != titleInfo.getIconType() && StringUtils.isNotEmpty((CharSequence)iconUrl) && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_CUSTOM.getFlag())) {
                    iconUrl = this.buildUrl((String)iconUrl, contentResp.getLabelTypeSource(), titleInfo.getIconUrl());
                }
                if (null != titleInfo.getIconType() && StringUtils.isNotEmpty((CharSequence)iconUrl) && titleInfo.getIconType().equals(Constants.MobileIconTypeEnum.ICON_LIB.getFlag())) {
                    iconUrl = this.envProperties.getSemcWebUrl() + (String)iconUrl;
                }
                titleInfo.setIconUrl((String)iconUrl);
                portalInfoContent.setContentAttr(JSON.toJSONString((Object)titleInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(contentResp.getContentType())) {
                MobilePortalDividerInfoReqDTO dividerInfo = (MobilePortalDividerInfoReqDTO)JSON.parseObject((String)contentResp.getContentAttr(), MobilePortalDividerInfoReqDTO.class);
                portalInfoContent.setContentAttr(JSON.toJSONString((Object)dividerInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.PICTURE.getVal().equals(contentResp.getContentType())) {
                MobilePortalImageInfoReqDTO imageCompInfo = (MobilePortalImageInfoReqDTO)JSON.parseObject((String)contentResp.getContentAttr(), MobilePortalImageInfoReqDTO.class);
                if (null != imageCompInfo && StringUtils.isNotEmpty((CharSequence)imageCompInfo.getImageId())) {
                    imageCompInfo.setImageUrl(this.buildUrl(imageCompInfo.getImageId(), contentResp.getLabelTypeSource(), imageCompInfo.getImageUrl()));
                }
                portalInfoContent.setContentAttr(JSON.toJSONString((Object)imageCompInfo));
            }
            if (Constants.PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(contentResp.getContentType())) {
                MobilePortalBusinessInfoReqDTO businessCompInfo = (MobilePortalBusinessInfoReqDTO)JSON.parseObject((String)contentResp.getContentAttr(), MobilePortalBusinessInfoReqDTO.class);
                if (null != businessCompInfo && CollectionUtils.isNotEmpty((Collection)businessCompInfo.getImageList())) {
                    for (MobilePortalContentCarouselImage image : businessCompInfo.getImageList()) {
                        image.setImageUrl(this.buildUrl(image.getImageId(), contentResp.getLabelTypeSource(), image.getImageUrl()));
                    }
                }
                portalInfoContent.setContentAttr(JSON.toJSONString((Object)businessCompInfo));
            }
            if (!Constants.PrtalMobileContentTypeEnum.H5_LINK.getVal().equals(contentResp.getContentType())) continue;
            Map contentInfo = Optional.ofNullable(JSON.parseObject((String)contentResp.getContentAttr(), Map.class)).orElse(new HashMap());
            if (Constants.LabelTypeSourceEnum.TENANT.getFlag().equals(contentResp.getLabelTypeSource())) {
                AppLinkDTO appLinkDTO = this.labelSystemClickService.queryCustomJumpLink(contentResp.getContentId());
                if (null != appLinkDTO && appLinkDTO.getIsHavePerm().booleanValue()) {
                    contentInfo.put("cloudwebsite", appLinkDTO.getCloudwebsite());
                }
            } else {
                contentInfo.put("cloudwebsite", this.envProperties.getHomePageUrl());
            }
            portalInfoContent.setContentAttr(JSON.toJSONString((Object)contentInfo));
        }
        result.setContentList(contentList);
        return result;
    }

    private PortalContentKingKongDistrict buildDistrict(PortalInfoContent portalInfoContent, MobilePortalInfoContentResp contentResp) {
        PortalContentKingKongDistrict district = (PortalContentKingKongDistrict)JSON.parseObject((String)portalInfoContent.getContentAttr(), PortalContentKingKongDistrict.class);
        if (null == district) {
            district = new PortalContentKingKongDistrict();
            district.setIsNameShow(contentResp.getIsNameShow());
            district.setInteractionType(contentResp.getInteractionType());
            district.setCustomType(contentResp.getCustomType());
            district.setColumnNum(contentResp.getColumnNum());
            district.setLineNum(contentResp.getLineNum());
            List ballList = contentResp.getBallList();
            if (CollectionUtils.isEmpty((Collection)ballList)) {
                return district;
            }
            List balls = ballList.stream().map(ball -> PortalContentKingKongDistrictBall.builder().ballName(ball.getBallName()).jumpType(ball.getJumpType()).jumpTarget(ball.getJumpTarget()).contentIcon(ball.getContentIcon()).iconType(ball.getIconType()).iconUrl(ball.getIconUrl()).customApplicationId(ball.getCustomApplicationId()).build()).collect(Collectors.toList());
            district.setBallList(balls);
            return district;
        }
        return district;
    }

    private /* synthetic */ List lambda$getPortalInfo$38(LambdaQueryWrapper wrapper) {
        return this.labelSystemPreMapper.selectList((Wrapper)wrapper);
    }
}

