/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResultBean;
import com.digiwin.athena.semc.dto.portal.PortalLayoutCustomReq;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import com.digiwin.athena.semc.mapper.portal.LabelSystemPreMapper;
import com.digiwin.athena.semc.mapper.portal.PortalLayoutCustomMapper;
import com.digiwin.athena.semc.service.portal.LabelSystemPreService;
import com.digiwin.athena.semc.service.portal.PortalLayoutCustomService;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomCustomResultVO;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalLayoutCustomServiceImpl
extends ServiceImpl<PortalLayoutCustomMapper, PortalLayoutCustom>
implements PortalLayoutCustomService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalLayoutCustomServiceImpl.class);
    @Resource
    MessageUtils messageUtils;
    @Resource
    PortalLayoutCustomMapper portalLayoutCustomMapper;
    @Resource
    LabelSystemPreService labelSystemPreService;
    @Resource
    LabelSystemPreMapper labelSystemPreMapper;

    public ResultBean queryPortalLayout() {
        ResultBean resultBean = new ResultBean();
        LinkedList resultList = new LinkedList();
        this.initPortalLayout();
        List portalLayoutCustomPreQueryVOList = this.portalLayoutCustomMapper.listPre(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        String locale = LocaleContextHolder.getLocale().toString();
        if ("zh_TW".equals(locale)) {
            portalLayoutCustomPreQueryVOList.forEach(item -> {
                if (StringUtils.isNotEmpty((String)item.getNameTw())) {
                    item.setName(item.getNameTw());
                }
            });
        }
        List portalLayoutCustomCustomQueryVOList = this.portalLayoutCustomMapper.listCustom(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        resultList.addAll(portalLayoutCustomPreQueryVOList);
        resultList.addAll(portalLayoutCustomCustomQueryVOList);
        List resultSerialList = JSON.parseArray((String)JSON.toJSONString(resultList), PortalLayoutCustomCustomResultVO.class);
        resultBean.setResponse(resultSerialList.stream().sorted(Comparator.comparing(PortalLayoutCustomCustomResultVO::getLabelIndex)).collect(Collectors.toList()));
        return resultBean;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> save(PortalLayoutCustomReq portalLayoutCustomReq) {
        LinkedList<PortalLayoutCustomVO> portalLayoutCustomList = new LinkedList<PortalLayoutCustomVO>();
        try {
            List saveList = portalLayoutCustomReq.getPortalLayoutInfo().stream().filter(e -> Objects.isNull(e.getPortalLayoutId())).collect(Collectors.toList());
            List<PortalLayoutCustomReq.PortalLayoutCustomInfo> updateList = portalLayoutCustomReq.getPortalLayoutInfo().stream().filter(e -> Objects.nonNull(e.getPortalLayoutId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(saveList)) {
                LambdaQueryWrapper queryValidWrapper = new LambdaQueryWrapper();
                queryValidWrapper.eq(PortalLayoutCustom::getTenantId, (Object)Utils.getTenantId());
                queryValidWrapper.eq(BaseEntity::getDelFlag, (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
                List portalLayoutCustomSum = this.portalLayoutCustomMapper.selectList((Wrapper)queryValidWrapper);
                if (portalLayoutCustomSum.size() + saveList.size() > Constants.COMPONENT_SIZE) {
                    String error = this.messageUtils.getMessage("error.message.system.portal.num.fail");
                    return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_PORTAL_LABEL, (String)error);
                }
                for (PortalLayoutCustomReq.PortalLayoutCustomInfo data2 : saveList) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(PortalLayoutCustom::getTenantId, (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    queryWrapper.eq(PortalLayoutCustom::getLabelType, (Object)data2.getComponentSource());
                    queryWrapper.eq(PortalLayoutCustom::getLabelId, (Object)data2.getId());
                    queryWrapper.eq(BaseEntity::getDelFlag, (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
                    List portalLayoutCustomValid = this.portalLayoutCustomMapper.selectList((Wrapper)queryWrapper);
                    if (!CollectionUtils.isEmpty((Collection)portalLayoutCustomValid)) {
                        String error = String.format(this.messageUtils.getMessage("error.message.system.portal.type.exist.fail"), data2.getId(), data2.getComponentSource());
                        return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_PORTAL_LABEL, (String)error);
                    }
                    PortalLayoutCustomVO portalLayoutCustom = new PortalLayoutCustomVO();
                    portalLayoutCustom.setDefaultFlag(Integer.valueOf(0));
                    if (Constants.COMPONENTSOURCE_TYPE.equals(data2.getComponentSource())) {
                        LambdaQueryWrapper queryPreWrapper = new LambdaQueryWrapper();
                        queryPreWrapper.eq(LabelSystemPre::getId, (Object)data2.getId());
                        LabelSystemPre labelSystemPre = (LabelSystemPre)this.labelSystemPreMapper.selectOne((Wrapper)queryPreWrapper);
                        if (Constants.DataTypeEnum.TYPE_TODO.getVal().equals(labelSystemPre.getDataType())) {
                            portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
                        }
                        if (Constants.DataTypeEnum.TYPE_INFO.getVal().equals(labelSystemPre.getDataType())) {
                            portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
                        }
                        if (Constants.DataTypeEnum.TYPE_COLLECT.getVal().equals(labelSystemPre.getDataType())) {
                            portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
                        }
                        if (Constants.DataTypeEnum.TYPE_USE.getVal().equals(labelSystemPre.getDataType())) {
                            portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
                        }
                    }
                    portalLayoutCustom.setLabelType(data2.getComponentSource());
                    portalLayoutCustom.setLabelId(data2.getId());
                    portalLayoutCustom.setLabelIndex(data2.getLabelIndex());
                    portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    portalLayoutCustom.setCreateUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    portalLayoutCustomList.add(portalLayoutCustom);
                }
                this.portalLayoutCustomMapper.insertBatch(portalLayoutCustomList);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                updateList.forEach(data -> {
                    PortalLayoutCustom portalLayoutCustom = new PortalLayoutCustom();
                    portalLayoutCustom.setId(data.getPortalLayoutId());
                    portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                    portalLayoutCustom.setLabelIndex(data.getLabelIndex());
                    portalLayoutCustom.setModifyUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
                    this.portalLayoutCustomMapper.updateByCondition(portalLayoutCustom);
                });
            }
        }
        catch (Exception e2) {
            log.error("save portal.layout.custom error", (Throwable)e2);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_PORTAL_LABEL, (String)this.messageUtils.getMessage("error.message.portal.layout.save-error"));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> delete(Long id) {
        try {
            PortalLayoutCustom portalLayoutCustom = (PortalLayoutCustom)this.portalLayoutCustomMapper.selectById((Serializable)id);
            if (null == portalLayoutCustom) {
                String error = this.messageUtils.getMessage("error.message.portal.not.exist.error");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            if (!portalLayoutCustom.getTenantId().equals(Utils.getTenantId())) {
                String error = this.messageUtils.getMessage("error.message.portal.tenant.id.error");
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)error);
            }
            portalLayoutCustom.setDelFlag(Constants.DEFAULT_CONFIGURED_FLAG_YES);
            this.portalLayoutCustomMapper.updateById((Object)portalLayoutCustom);
        }
        catch (Exception e) {
            log.error("del portal.layout.custom error", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SAVE_PORTAL_LABEL, (String)this.messageUtils.getMessage("error.message.portal.layout.delete-error"));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    public List<PortalLayoutCustom> initPortalLayout() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"label_index");
        queryWrapper.eq((Object)"tenant_id", (Object)Utils.getTenantId());
        List portalLayoutCustomList = this.portalLayoutCustomMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)portalLayoutCustomList)) {
            portalLayoutCustomList = portalLayoutCustomList.stream().filter(item -> Constants.DEFAULT_CONFIGURED_FLAG_NO.equals(item.getDelFlag())).collect(Collectors.toList());
            return portalLayoutCustomList;
        }
        List labelSystemPreList = this.labelSystemPreService.initPreData(Constants.ClientTypeEnum.PC.getValue());
        List portalLayoutCustomPreList = labelSystemPreList.stream().filter(e -> e.getDataType().equals(Constants.DataTypeEnum.TYPE_TODO.getVal()) || e.getDataType().equals(Constants.DataTypeEnum.TYPE_USE.getVal()) || e.getDataType().equals(Constants.DataTypeEnum.TYPE_COLLECT.getVal()) || e.getDataType().equals(Constants.DataTypeEnum.TYPE_INFO.getVal())).map(item -> {
            PortalLayoutCustomVO portalLayoutCustom = new PortalLayoutCustomVO();
            if (Constants.DataTypeEnum.TYPE_TODO.getVal().equals(item.getDataType())) {
                portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                portalLayoutCustom.setLabelId(item.getId());
                portalLayoutCustom.setLabelIndex(Integer.valueOf(1));
                portalLayoutCustom.setLabelType(Integer.valueOf(1));
                portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
            }
            if (Constants.DataTypeEnum.TYPE_INFO.getVal().equals(item.getDataType())) {
                portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                portalLayoutCustom.setLabelId(item.getId());
                portalLayoutCustom.setLabelIndex(Integer.valueOf(2));
                portalLayoutCustom.setLabelType(Integer.valueOf(1));
                portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
            }
            if (Constants.DataTypeEnum.TYPE_COLLECT.getVal().equals(item.getDataType())) {
                portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                portalLayoutCustom.setLabelId(item.getId());
                portalLayoutCustom.setLabelIndex(Integer.valueOf(3));
                portalLayoutCustom.setLabelType(Integer.valueOf(1));
                portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
            }
            if (Constants.DataTypeEnum.TYPE_USE.getVal().equals(item.getDataType())) {
                portalLayoutCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
                portalLayoutCustom.setLabelId(item.getId());
                portalLayoutCustom.setLabelIndex(Integer.valueOf(4));
                portalLayoutCustom.setLabelType(Integer.valueOf(1));
                portalLayoutCustom.setDefaultFlag(Integer.valueOf(1));
            }
            return portalLayoutCustom;
        }).collect(Collectors.toList());
        this.portalLayoutCustomMapper.insertBatch(portalLayoutCustomPreList);
        queryWrapper.eq((Object)"del_flag", (Object)Constants.DEFAULT_CONFIGURED_FLAG_NO);
        portalLayoutCustomList = this.portalLayoutCustomMapper.selectList((Wrapper)queryWrapper);
        return portalLayoutCustomList;
    }
}

