/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.VisitPortalReq;
import com.digiwin.athena.semc.entity.portal.PortalVisit;
import com.digiwin.athena.semc.mapper.portal.PortalVisitMapper;
import com.digiwin.athena.semc.service.portal.PortalVisitService;
import com.digiwin.athena.semc.util.Utils;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Repository;

@Repository
public class PortalVisitServiceImpl
extends ServiceImpl<PortalVisitMapper, PortalVisit>
implements PortalVisitService {
    @Resource
    PortalVisitMapper portalVisitMapper;

    public List<PortalVisit> queryPortalVisitList(Integer clientType, Integer visitType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PortalVisit::getClientType, (Object)clientType);
        queryWrapper.eq(PortalVisit::getVisitType, (Object)visitType);
        if (Constants.VisitTypeEnum.ATHENA_PORTAL.getValue().equals(visitType)) {
            queryWrapper.eq(PortalVisit::getUserId, (Object)Utils.getUserId());
        } else {
            queryWrapper.isNull(PortalVisit::getUserId);
        }
        queryWrapper.orderByDesc(PortalVisit::getVisitTime);
        return this.portalVisitMapper.selectList((Wrapper)queryWrapper);
    }

    public void recordVisit(VisitPortalReq visitPortalReq) {
        List portalVisitList = this.queryPortalVisitList(visitPortalReq.getClientType(), visitPortalReq.getVisitType());
        PortalVisit portalVisit = portalVisitList.stream().filter(x -> x.getVisitEleId().equals(visitPortalReq.getDesignerPortalId())).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)portalVisit)) {
            portalVisit = new PortalVisit();
            portalVisit.setVisitEleId(visitPortalReq.getDesignerPortalId());
            portalVisit.setClientType(visitPortalReq.getClientType());
            portalVisit.setVisitType(visitPortalReq.getVisitType());
            portalVisit.setVisitTime(LocalDateTime.now());
            portalVisit.setTenantId(Utils.getTenantId());
            if (Constants.VisitTypeEnum.ATHENA_PORTAL.getValue().equals(visitPortalReq.getVisitType())) {
                portalVisit.setUserId(Utils.getUserId());
            }
            this.portalVisitMapper.insert((Object)portalVisit);
        } else {
            portalVisit.setVisitTime(LocalDateTime.now());
            this.portalVisitMapper.updateById((Object)portalVisit);
        }
    }
}

