/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.PreinstalledApplicationTypeEnum;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.dto.erpsso.ThirdSsoInfoDto;
import com.digiwin.athena.semc.dto.portal.PreinstalledApplicationConfigUpdateDto;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationInstanceMapper;
import com.digiwin.athena.semc.mapper.portal.PreinstalledApplicationMapper;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PreinstalledApplicationServiceImpl
implements IPreinstalledApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreinstalledApplicationServiceImpl.class);
    @Resource
    private PreinstalledApplicationMapper preinstalledApplicationMapper;
    @Resource
    private PreinstalledApplicationInstanceMapper preinstalledApplicationInstanceMapper;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;

    public List<PreinstalledApplication> queryPreinstalledAppList(AuthoredUser user) {
        List<PreinstalledApplication> preinstalledApplicationList = this.preinstalledApplicationMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        List instanceList = this.preinstalledApplicationInstanceMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)instanceList)) {
            this.insertInstance(user, (List)preinstalledApplicationList);
        } else {
            List instancePreIdList = instanceList.stream().map(PreinstalledApplicationInstance::getPreinstalledApplicationId).collect(Collectors.toList());
            List newAppList = preinstalledApplicationList.stream().filter(x -> !instancePreIdList.contains(x.getId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newAppList)) {
                this.insertInstance(user, newAppList);
                instanceList = this.preinstalledApplicationInstanceMapper.selectList((Wrapper)queryWrapper);
            }
            List noValidIdList = instanceList.stream().filter(x -> Constants.VALID_STATUS_UNUSABLE.equals(x.getStatus())).map(PreinstalledApplicationInstance::getPreinstalledApplicationId).collect(Collectors.toList());
            preinstalledApplicationList = preinstalledApplicationList.stream().filter(x -> !noValidIdList.contains(x.getId())).collect(Collectors.toList());
            Map applicationIdMap = instanceList.stream().collect(Collectors.toMap(PreinstalledApplicationInstance::getPreinstalledApplicationId, Function.identity(), (a, b) -> a));
            preinstalledApplicationList.forEach(x -> {
                PreinstalledApplicationInstance instance = (PreinstalledApplicationInstance)applicationIdMap.get(x.getId());
                if (instance != null) {
                    x.setUserBindFlag(instance.getUserBindFlag());
                    x.setAppSid(x.getAppSid() == null ? instance.getAppSid() : x.getAppSid());
                    x.setAppId(StringUtils.isEmpty((CharSequence)x.getAppId()) ? instance.getAppId() : x.getAppId());
                    x.setAppSecret(StringUtils.isEmpty((CharSequence)x.getAppSecret()) ? instance.getAppSecret() : x.getAppSecret());
                }
            });
        }
        preinstalledApplicationList.sort(Comparator.comparing(PreinstalledApplication::getApplicationName));
        return preinstalledApplicationList;
    }

    private void insertInstance(AuthoredUser user, List<PreinstalledApplication> preinstalledApplicationList) {
        ArrayList instanceList = Lists.newArrayList();
        preinstalledApplicationList.forEach(x -> {
            PreinstalledApplicationInstance instance = new PreinstalledApplicationInstance();
            instance.setId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
            instance.setPreinstalledApplicationId(x.getId());
            instance.setUserBindFlag(x.getUserBindFlag());
            instance.setLinkDisplayFlag(Constants.LinkDisplayFlagEnum.YES.getFlag());
            instance.setStatus(Constants.VALID_STATUS_ENABLE);
            instance.setCreateUserId(user.getUserId());
            instance.setModifyUserId(user.getUserId());
            instance.setTenantId(user.getTenantId());
            if (Arrays.asList(Constants.BindFlagEnum.AUTO.getFlag(), Constants.BindFlagEnum.HAND.getFlag()).contains(x.getUserBindFlag())) {
                RegisterDTO registerReq = new RegisterDTO();
                registerReq.setName(x.getApplicationCode());
                registerReq.setDescription(x.getApplicationDescription());
                registerReq.setAppToken(x.getAppToken());
                if (PreinstalledApplicationTypeEnum.BS_APPLICATION.getValue().equals(x.getApplicationType())) {
                    ThirdSsoInfoDto thirdSsoInfoDto = (ThirdSsoInfoDto)Optional.ofNullable(JSON.toJavaObject((JSON)JSONObject.parseObject((String)x.getApplicationConfig()), ThirdSsoInfoDto.class)).orElse(new ThirdSsoInfoDto());
                    registerReq.setCallbackUrl(thirdSsoInfoDto.getCallBackUrl());
                } else {
                    registerReq.setCallbackUrl(String.format("http://www.%s.com", x.getApplicationCode()));
                }
                try {
                    RegisterDTO registerResp = this.thirdSsoInfoService.registerApp(registerReq);
                    instance.setAppSid(registerResp.getSid());
                    x.setAppSid(registerResp.getSid());
                    instance.setAppId(registerResp.getId());
                    x.setAppId(registerResp.getId());
                    instance.setAppSecret(registerResp.getSecret());
                    x.setAppSecret(registerResp.getSecret());
                }
                catch (Exception e) {
                    log.error("PreinstalledApplicationServiceImpl invoke iam error error, registerReq:{}", (Object)registerReq, (Object)e);
                }
            }
            instanceList.add(instance);
        });
        if (CollectionUtils.isNotEmpty((Collection)instanceList)) {
            this.preinstalledApplicationInstanceMapper.batchInsertInstance((List)instanceList);
        }
    }

    public JSONObject queryPreinstalledAppDetail(AuthoredUser user, String applicationType, long preinstalledApplicationId) {
        PreinstalledApplication preinstalledApplication = (PreinstalledApplication)this.preinstalledApplicationMapper.selectById((Serializable)Long.valueOf(preinstalledApplicationId));
        JSONObject jsonObject = JSONObject.parseObject((String)preinstalledApplication.getApplicationConfig());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"preinstalled_application_id", (Object)preinstalledApplicationId);
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        PreinstalledApplicationInstance preinstalledApplicationInstance = (PreinstalledApplicationInstance)this.preinstalledApplicationInstanceMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.nonNull(preinstalledApplicationInstance)) {
            jsonObject.put("appSid", (Object)preinstalledApplicationInstance.getAppSid());
            jsonObject.put("appId", (Object)preinstalledApplicationInstance.getAppId());
            jsonObject.put("appSecret", (Object)preinstalledApplicationInstance.getAppSecret());
        }
        if (PreinstalledApplicationTypeEnum.SPECIAL_APPLICATION.getType().equals(applicationType) && Objects.nonNull(preinstalledApplicationInstance) && Objects.nonNull(preinstalledApplicationInstance.getApplicationExtConfig())) {
            Iterator keys = preinstalledApplicationInstance.getApplicationExtConfig().keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                jsonObject.put(key, preinstalledApplicationInstance.getApplicationExtConfig().get(key));
            }
        }
        return jsonObject;
    }

    public void updatePreinstalledAppConfig(AuthoredUser user, PreinstalledApplicationConfigUpdateDto preinstalledApplicationConfigUpdateDto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"preinstalled_application_id", preinstalledApplicationConfigUpdateDto.getPreinstalledApplicationId().get(0));
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        PreinstalledApplicationInstance instance = this.buildInstance(preinstalledApplicationConfigUpdateDto, user);
        this.preinstalledApplicationInstanceMapper.updatePreinstalledApplicationInstance(instance);
    }

    private PreinstalledApplicationInstance buildInstance(PreinstalledApplicationConfigUpdateDto preinstalledApplicationConfigUpdateDto, AuthoredUser user) {
        PreinstalledApplicationInstance instance = new PreinstalledApplicationInstance();
        instance.setPreinstalledApplicationId((Long)preinstalledApplicationConfigUpdateDto.getPreinstalledApplicationId().get(0));
        instance.setApplicationExtConfig(preinstalledApplicationConfigUpdateDto.getConfig());
        instance.setUserBindFlag(preinstalledApplicationConfigUpdateDto.getUserBindFlag());
        instance.setStatus(preinstalledApplicationConfigUpdateDto.getStatus());
        instance.setTenantId(user.getTenantId());
        instance.setModifyUserId(user.getUserId());
        return instance;
    }

    public List<PreinstalledApplication> queryPreinstalledApplicationList(List<Long> idList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", idList);
        return this.preinstalledApplicationMapper.selectList((Wrapper)queryWrapper);
    }

    public void updateAppInfo(List<Long> ssoIdList, Integer userBindFlag, Integer linkDisplayFlag) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        this.preinstalledApplicationMapper.updateAppInfo(ssoIdList, userBindFlag, linkDisplayFlag, tenantId);
    }

    public PreinstalledApplication getPreByCode(String applicationCode, String appId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)applicationCode)) {
            queryWrapper.eq((Object)"application_code", (Object)applicationCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        return (PreinstalledApplication)this.preinstalledApplicationMapper.selectOne((Wrapper)queryWrapper);
    }

    public PreinstalledApplicationInstance getPreINstance(Long preinstalledId, String extConfig, String appId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != preinstalledId) {
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(preinstalledId);
            queryWrapper.in((Object)"preinstalled_application_id", idList);
        }
        if (StringUtils.isNotEmpty((CharSequence)extConfig)) {
            queryWrapper.like((Object)"application_ext_config", (Object)extConfig);
        }
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        queryWrapper.eq((Object)"tenant_id", (Object)user.getTenantId());
        List applicationInstanceList = this.preinstalledApplicationInstanceMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)applicationInstanceList)) {
            return null;
        }
        return (PreinstalledApplicationInstance)applicationInstanceList.get(0);
    }

    public Map<Long, PreinstalledApplication> getPreInfoMap() {
        List preinstalledAppList = this.preinstalledApplicationMapper.selectList((Wrapper)new QueryWrapper());
        Map<Long, PreinstalledApplication> preInfoMap = preinstalledAppList.stream().collect(Collectors.toMap(PreinstalledApplication::getId, Function.identity(), (a, b) -> a));
        return preInfoMap;
    }

    public PreinstalledApplication getPreApp(Long id) {
        return (PreinstalledApplication)this.preinstalledApplicationMapper.selectById((Serializable)id);
    }

    public Integer delApplicationInstance(List<Long> idList) {
        return this.preinstalledApplicationInstanceMapper.deleteBatchIds(idList);
    }
}

