/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.BizException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.ResponseBody;
import com.digiwin.athena.semc.common.ResultPageBean;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.common.enums.ProtocolTypeEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.entity.portal.Report;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.portal.ReportMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.ReportService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reportService")
public class ReportServiceImpl
extends ServiceImpl<ReportMapper, Report>
implements ReportService {
    @Resource
    private ESPService espService;
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Autowired
    TripartiteService tripartiteService;
    @Resource
    EnvProperties envProperties;

    public ResultPageBean pageQueryReport(LabelSystemPreReq req) {
        String reportUrl;
        JSONObject jsonObject;
        int i;
        ArrayList list;
        JSONArray array;
        Integer totalResults;
        ResultPageBean resultPageBean = ResultPageBean.success(null);
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Long tenantSid = AppAuthContextHolder.getContext().getAuthoredUser().getTenantSid();
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        LabelSystemDataDto labelSystemDataDto = this.labelSystemDataService.getSystemDataSso(req.getId());
        if (null == labelSystemDataDto) {
            return ResultPageBean.bizException((BizException)BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_ILLEGAL_ERROR, (String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728"));
        }
        String appToken = StringUtils.isBlank((CharSequence)labelSystemDataDto.getAppToken()) ? this.envProperties.getAppToken() : labelSystemDataDto.getAppToken();
        Map result = new HashMap();
        HashMap<String, String> extHeader = new HashMap<String, String>();
        extHeader.put("digi-userToken", token);
        extHeader.put("digi-appToken", appToken);
        result = Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemDataDto.getDataModel()) ? this.espService.queryByEsp(labelSystemDataDto.getMiddleSystemName(), labelSystemDataDto.getMiddleSystemUid(), EAIServiceNameEnum.REPORT.getServiceName(), extHeader, null, req.getQryCondition(), PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize())) : this.tripartiteService.selectDataPagePost(labelSystemDataDto.getRestUrl(), req, appToken);
        if (ProtocolTypeEnum.OAUTH.getType() == labelSystemDataDto.getProtocolType() && Objects.nonNull(result.get("report_info_list"))) {
            totalResults = Integer.parseInt(result.get("total_results").toString());
            array = JSONArray.fromObject(result.get("report_info_list"));
            list = Lists.newArrayList();
            for (i = 0; i < array.size(); ++i) {
                jsonObject = array.getJSONObject(i);
                reportUrl = jsonObject.getString("report_url");
                jsonObject.put((Object)"report_url", (Object)(reportUrl + (reportUrl.contains("?") ? "&" : "?") + "appToken=" + appToken + "&tenantId=" + tenantId + "&bindMode=" + labelSystemDataDto.getUserBindFlag()));
                list.add(jsonObject);
            }
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)list, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)totalResults)));
        }
        if (ProtocolTypeEnum.CAS.getType() == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemDataDto.getDataType()) && Objects.nonNull(result.get("report_info_list"))) {
            totalResults = Integer.parseInt(result.get("total_results").toString());
            array = JSONArray.fromObject(result.get("report_info_list"));
            list = Lists.newArrayList();
            for (i = 0; i < array.size(); ++i) {
                jsonObject = array.getJSONObject(i);
                reportUrl = jsonObject.getString("report_url");
                jsonObject.put((Object)"report_url", (Object)reportUrl);
                list.add(jsonObject);
            }
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)list, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)totalResults)));
        }
        if (ProtocolTypeEnum.CAS.getType() == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemDataDto.getDataType()) && Objects.nonNull(result.get("report_info_list"))) {
            totalResults = Integer.parseInt(result.get("total_results").toString());
            array = JSONArray.fromObject(result.get("report_info_list"));
            list = Lists.newArrayList();
            for (i = 0; i < array.size(); ++i) {
                jsonObject = array.getJSONObject(i);
                jsonObject.put((Object)"report_url", (Object)labelSystemDataDto.getCasServerUrl());
                list.add(jsonObject);
            }
            resultPageBean = ResultPageBean.success((ResponseBody)ResponseBody.getInstance((Object)list, (PageInfo)PageInfo.getPageInfo((Integer)req.getPageNum(), (Integer)req.getPageSize(), (Integer)totalResults)));
        }
        return resultPageBean;
    }
}

