/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.ThirdTodoConfig;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.mapper.portal.ThirdTodoConfigMapper;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.ThirdTodoConfigService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdTodoConfigServiceImpl
extends ServiceImpl<ThirdTodoConfigMapper, ThirdTodoConfig>
implements ThirdTodoConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThirdTodoConfigServiceImpl.class);
    @Autowired
    private ThirdTodoConfigMapper thirdTodoConfigMapper;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Autowired
    IErpSsoInfoService erpSsoInfoService;
    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;

    public Integer saveThirdToDo(ThirdTodoConfig req) {
        req.setModifyUserId(Utils.getUserId());
        req.setModifyTime(DateUtils.getNowTime((String)""));
        if (null == req.getId()) {
            this.thirdTodoConfigMapper.insert((Object)req);
        } else {
            this.thirdTodoConfigMapper.updateById((Object)req);
        }
        return null;
    }

    public Integer delThirdToDo(DeleteMessageConfigReq req) {
        return this.thirdTodoConfigMapper.deleteBatchIds((Collection)req.getIdList());
    }

    public PageInfoResp<ThirdTodoConfig> queryConfigPage(QueryThirdMessageConfigReq req) {
        QueryWrapper condition = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)req.getAppPrimaryId())) {
            condition.eq((Object)"app_primary_id", (Object)req.getAppPrimaryId());
        }
        if (req.getAppSource() != null) {
            condition.eq((Object)"app_source", (Object)req.getAppSource());
        }
        if (req.getValidStatus() != null) {
            condition.eq((Object)"valid_status", (Object)req.getValidStatus());
        }
        if (req.getDataGetType() != null) {
            condition.eq((Object)"data_get_type", (Object)req.getDataGetType());
        }
        condition.orderByDesc((Object)"modify_time");
        condition.eq((Object)"tenant_id", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        PageInfoResp pageInfoResp = new PageInfoResp();
        Page pageResult = (Page)this.thirdTodoConfigMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)condition);
        if (pageResult == null || CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return pageInfoResp;
        }
        List toDoConfigList = pageResult.getRecords();
        this.packageAppCodeName(toDoConfigList);
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(req.getPageNum().intValue());
        pageInfoResp.setPageSize(req.getPageSize().intValue());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(toDoConfigList);
        return pageInfoResp;
    }

    public void packageAppCodeName(List<ThirdTodoConfig> toDoConfigList) {
        List csList = toDoConfigList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List csIdList = csList.stream().map(ThirdTodoConfig::getAppPrimaryId).collect(Collectors.toList());
        Map erpInfoMap = this.erpSsoInfoService.getErpInfoMap(csIdList);
        List bsList = toDoConfigList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List bsIdList = bsList.stream().map(ThirdTodoConfig::getAppPrimaryId).collect(Collectors.toList());
        Map thirdSsoInfoMap = this.thirdSsoInfoService.getSsoInfoMap(bsIdList);
        Map preInfoMap = this.preinstalledApplicationService.getPreInfoMap();
        for (ThirdTodoConfig toDoConfig : toDoConfigList) {
            PreinstalledApplication preinstalledApplication;
            ThirdSsoInfo thirdSsoInfo;
            ErpSsoInfo erpSsoInfo;
            String appName = "";
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(toDoConfig.getAppSource()) && null != (erpSsoInfo = (ErpSsoInfo)erpInfoMap.get(Long.parseLong(toDoConfig.getAppPrimaryId())))) {
                appName = erpSsoInfo.getName();
            }
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(toDoConfig.getAppSource()) && (thirdSsoInfo = (ThirdSsoInfo)thirdSsoInfoMap.get(Long.parseLong(toDoConfig.getAppPrimaryId()))) != null) {
                appName = thirdSsoInfo.getAppName();
            }
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(toDoConfig.getAppSource()) && null != (preinstalledApplication = (PreinstalledApplication)preInfoMap.get(Long.parseLong(toDoConfig.getAppPrimaryId())))) {
                appName = preinstalledApplication.getApplicationName();
            }
            toDoConfig.setAppName(appName);
        }
    }

    public boolean validConfigExist(ThirdTodoConfig req) {
        ThirdTodoConfig config;
        QueryWrapper condition = new QueryWrapper();
        condition.eq((Object)"app_source", (Object)req.getAppSource());
        condition.eq((Object)"app_primary_id", (Object)req.getAppPrimaryId());
        if (req.getId() != null) {
            condition.ne((Object)"id", (Object)req.getId());
        }
        return null != (config = (ThirdTodoConfig)this.thirdTodoConfigMapper.selectOne((Wrapper)condition));
    }

    public ThirdTodoConfig getToDoConfigBy(String appCode, String appId) {
        return this.thirdTodoConfigMapper.getToDoConfigBy(appCode, appId);
    }
}

