/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.TodoAppSort;
import com.digiwin.athena.semc.mapper.portal.TodoAppSortMapper;
import com.digiwin.athena.semc.service.portal.TodoAppSortService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TodoAppSortServiceImpl
extends ServiceImpl<TodoAppSortMapper, TodoAppSort>
implements TodoAppSortService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TodoAppSortServiceImpl.class);

    public List<TodoAppSort> getCurrentUserAppSort() {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoAppSort::getUserId, (Object)authoredUser.getUserId());
        queryWrapper.eq(TodoAppSort::getTenantId, (Object)authoredUser.getTenantId());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        list.sort(Comparator.comparingInt(TodoAppSort::getAppSort));
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean save(List<String> appIdList) {
        if (CollectionUtils.isEmpty(appIdList)) {
            return false;
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String userId = authoredUser.getUserId();
        String tenantId = authoredUser.getTenantId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoAppSort::getUserId, (Object)userId);
        queryWrapper.eq(TodoAppSort::getTenantId, (Object)tenantId);
        this.remove((Wrapper)queryWrapper);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)appIdList.size());
        for (int i = 0; i < appIdList.size(); ++i) {
            TodoAppSort todoAppSort = new TodoAppSort();
            todoAppSort.setAppId(appIdList.get(i));
            todoAppSort.setAppSort(Integer.valueOf(i));
            todoAppSort.setUserId(userId);
            todoAppSort.setTenantId(tenantId);
            todoAppSort.setCreateTime(DateUtil.now());
            list.add(todoAppSort);
        }
        this.saveBatch((Collection)list);
        return true;
    }

    public List<LabelSystemData> sortLabelSystemData(List<LabelSystemData> labelSystemDataList) {
        labelSystemDataList.sort(Comparator.comparing(LabelSystemData::getAppName));
        List appSortList = this.getCurrentUserAppSort();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)appSortList)) {
            return labelSystemDataList;
        }
        ArrayList appSortLSDList = Lists.newArrayList();
        TreeSet appSortAppIdSet = Sets.newTreeSet();
        Map labelSystemDataMap = labelSystemDataList.stream().collect(Collectors.toMap(LabelSystemData::getAppId, Function.identity(), (a, b) -> a));
        appSortList.forEach(m -> {
            LabelSystemData labelSystemData = (LabelSystemData)labelSystemDataMap.get(m.getAppId());
            if (null != labelSystemData) {
                appSortLSDList.add(labelSystemData);
                appSortAppIdSet.add(m.getAppId());
            }
        });
        ArrayList resultList = Lists.newArrayList();
        resultList.addAll(appSortLSDList);
        for (LabelSystemData labelSystemData : labelSystemDataList) {
            if (StringUtils.isBlank((CharSequence)labelSystemData.getAppId()) || appSortAppIdSet.contains(labelSystemData.getAppId())) continue;
            resultList.add(labelSystemData);
        }
        return resultList;
    }
}

