/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.common.enums.IfNotIntegerEnum;
import com.digiwin.athena.semc.common.enums.MaycurCodeEnum;
import com.digiwin.athena.semc.common.enums.MaycurCulomnEnum;
import com.digiwin.athena.semc.common.enums.MaycurTaskActionTypeEnum;
import com.digiwin.athena.semc.common.enums.ProtocolTypeEnum;
import com.digiwin.athena.semc.common.enums.SourceEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.erpsso.ErpSsoSpecialDTO;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoCountReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoSearchAppReq;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoUpdateReq;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.dto.portal.ReimburseReq;
import com.digiwin.athena.semc.dto.portal.TodoCountResp;
import com.digiwin.athena.semc.dto.portal.TodoFieldDto;
import com.digiwin.athena.semc.dto.portal.TodoListDto;
import com.digiwin.athena.semc.dto.portal.TodoListReq;
import com.digiwin.athena.semc.dto.portal.TodoListResp;
import com.digiwin.athena.semc.dto.portal.TodoReceiveDto;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import com.digiwin.athena.semc.entity.portal.ThirdTodoConfig;
import com.digiwin.athena.semc.entity.portal.TodoField;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.portal.TodoRead;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.mapper.portal.TodoFieldMapper;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.mapper.portal.TodoReadMapper;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.AccountDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.AppUserDTO;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.LabelSystemSourceService;
import com.digiwin.athena.semc.service.portal.ThirdTodoConfigService;
import com.digiwin.athena.semc.service.portal.TodoAppSortService;
import com.digiwin.athena.semc.service.portal.TodoFieldService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.maycur.MaycurCalloutParamsReq;
import com.digiwin.athena.semc.vo.maycur.MaycurTodoNoticeReq;
import com.digiwin.athena.semc.vo.portal.ReimburseUrlVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.linpeilie.Converter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TodoListServiceImpl
extends ServiceImpl<TodoListMapper, TodoList>
implements TodoListService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TodoListServiceImpl.class);
    @Resource
    private TodoFieldMapper todoFieldMapper;
    @Resource
    private TodoListMapper todoListMapper;
    @Resource
    private TodoReadMapper todoReadMapper;
    @Autowired
    private TodoFieldService todoFieldService;
    @Autowired
    LabelSystemDataService labelSystemDataService;
    @Autowired
    TripartiteService tripartiteService;
    @Autowired
    ThirdTodoConfigService thirdTodoConfigService;
    @Resource
    private LabelSystemDataMapper labelSystemDataMapper;
    @Resource
    private ESPService espService;
    @Resource
    private MessageUtils messageUtils;
    @Resource
    private IamService iamService;
    @Resource
    private MessageSendService messageSendService;
    @Resource
    MayCurService mayCurService;
    @Resource
    EocService eocService;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;
    @Resource
    private Converter converter;
    @Autowired
    private LabelSystemSourceService labelSystemSourceService;
    @Autowired
    private TodoAppSortService todoAppSortService;

    @Transactional
    public TodoListResp handleEspResult(AuthoredUser user, TodoListReq.EaiSys eaiSys, Map<String, Object> result, String qryCondition, LabelSystemDataDto labelSystemDataDto) {
        TodoListResp todoListResp = new TodoListResp();
        if (Objects.isNull(result.get("to_do_list"))) {
            todoListResp.setRed(false);
            todoListResp.setTotalUnreadCount(Integer.valueOf(0));
            todoListResp.setTotalResults(Integer.valueOf(0));
        } else {
            Integer totalResults = result.get("total_results") == null ? 0 : Integer.parseInt(result.get("total_results").toString());
            todoListResp.setTotalResults(totalResults);
            List existsTodoList = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"to_do_user", (Object)user.getUserId())).eq((Object)"tenant_id", (Object)user.getTenantId())).eq((Object)"app_name", (Object)eaiSys.getAppName()));
            HashMap existsTodoMap = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)existsTodoList) ? existsTodoList.stream().collect(Collectors.toMap(TodoList::getToDoId, a -> a, (k1, k2) -> k1)) : Maps.newHashMap();
            ArrayList insertTodoList = Lists.newArrayList();
            ArrayList resultTodoList = Lists.newArrayList();
            JSONArray.fromObject((Object)result.get("to_do_list")).stream().forEach(todoJson -> {
                TodoList todo = (TodoList)com.alibaba.fastjson.JSONObject.parseObject((String)todoJson.toString(), TodoList.class);
                todo.setToDoUrl(this.getToDoUrl(todo.getToDoUrl(), user, labelSystemDataDto));
                if (existsTodoMap.containsKey(todo.getToDoId())) {
                    TodoList dbTodoList = (TodoList)existsTodoMap.get(todo.getToDoId());
                    String todoUrl = todo.getToDoUrl();
                    String todoData = todo.getToDoData();
                    BeanUtils.copyProperties((Object)dbTodoList, (Object)todo);
                    todo.setToDoUrl(todoUrl);
                    todo.setToDoData(todoData);
                } else {
                    todo.setIsCompleted(IfNotIntegerEnum.NO.getValue());
                    todo.setToDoSource(SourceEnum.EXTERNAL.getSource());
                    todo.setAppName(eaiSys.getAppName());
                    todo.setToDoUser(user.getUserId());
                    todo.setIsRead(IfNotIntegerEnum.NO.getValue());
                    todo.setToDoSource(SourceEnum.EXTERNAL.getSource());
                    todo.setToDoData(com.alibaba.fastjson.JSONObject.parseObject((String)todoJson.toString()).getString("to_do_data"));
                    insertTodoList.add(todo);
                }
                if (IfNotIntegerEnum.NO.getValue().equals(todo.getIsRead())) {
                    todoListResp.setRed(true);
                    todoListResp.setTotalUnreadCount(Integer.valueOf(todoListResp.getTotalUnreadCount() + 1));
                }
                if (StringUtils.isNotEmpty((CharSequence)qryCondition) && todo.getToDoData().toLowerCase().contains(qryCondition.toLowerCase())) {
                    resultTodoList.add(todo);
                }
                if (StringUtils.isEmpty((CharSequence)qryCondition)) {
                    resultTodoList.add(todo);
                }
            });
            todoListResp.setTodoList((List)resultTodoList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)insertTodoList)) {
                this.saveBatch((Collection)insertTodoList);
            }
        }
        JSONArray fieldList = JSONArray.fromObject((Object)result.get("display_field_list"));
        ArrayList todoFieldList = Lists.newArrayList();
        fieldList.stream().forEach(field -> {
            TodoField todoField = (TodoField)com.alibaba.fastjson.JSONObject.parseObject((String)field.toString(), TodoField.class);
            todoField.setToDoUser(user.getUserId());
            todoField.setAppName(eaiSys.getAppName());
            todoFieldList.add(todoField);
        });
        todoListResp.setTodoFieldList((List)todoFieldList);
        boolean exists = this.exists((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"to_do_user", (Object)user.getUserId())).eq((Object)"tenant_id", (Object)user.getTenantId())).eq((Object)"app_name", (Object)eaiSys.getAppName()));
        if (!exists) {
            this.todoFieldService.saveBatch((Collection)todoFieldList);
        }
        return todoListResp;
    }

    private String getToDoUrl(String todoUrl, AuthoredUser user, LabelSystemDataDto labelSystemDataDto) {
        String toDoUrl = null;
        if (labelSystemDataDto != null && ProtocolTypeEnum.OAUTH.getType().equals(labelSystemDataDto.getProtocolType())) {
            toDoUrl = todoUrl + (todoUrl.contains("?") ? "&" : "?") + "appToken=" + labelSystemDataDto.getAppToken() + "&appCode=" + labelSystemDataDto.getAppCode() + "&tenantId=" + user.getTenantId() + "&bindMode=" + labelSystemDataDto.getUserBindFlag() + "&appId=" + labelSystemDataDto.getAppId();
        }
        if (labelSystemDataDto != null && ProtocolTypeEnum.CAS.getType() == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.CS_APPLICATION.getType().equals(labelSystemDataDto.getDataType())) {
            toDoUrl = todoUrl;
        }
        if (labelSystemDataDto != null && ProtocolTypeEnum.CAS.getType() == labelSystemDataDto.getProtocolType() && ApplicationTypeEnum.BS_APPLICATION.getType().equals(labelSystemDataDto.getDataType())) {
            toDoUrl = labelSystemDataDto.getCasServerUrl();
        }
        return toDoUrl;
    }

    public TodoListResp localSearch(AuthoredUser user, TodoListReq.EaiSys eaiSys, String condition) {
        TodoListResp todoListResp = new TodoListResp();
        List todoFieldList = this.todoFieldMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"to_do_user", (Object)user.getUserId())).eq((Object)"tenant_id", (Object)user.getTenantId())).eq((Object)"app_name", (Object)eaiSys.getAppName()));
        List existsTodoList = this.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"to_do_user", (Object)user.getUserId())).eq((Object)"tenant_id", (Object)user.getTenantId())).eq((Object)"app_name", (Object)eaiSys.getAppName())).like((Object)"to_do_data", (Object)condition));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)existsTodoList)) {
            todoListResp.setTodoList(existsTodoList);
        }
        todoListResp.setTodoFieldList(todoFieldList);
        return todoListResp;
    }

    public TodoListResp pageQueryTodo(LabelSystemPreReq todoListReq) {
        TodoListResp todoListResp = new TodoListResp();
        String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        LabelSystemDataDto labelSystemDataDto = this.labelSystemDataService.getSystemDataSso(todoListReq.getId());
        if (null == labelSystemDataDto) {
            todoListResp.setResultCode("3001");
            return todoListResp;
        }
        String appToken = StringUtils.isBlank((CharSequence)labelSystemDataDto.getAppToken()) ? this.envProperties.getAppToken() : labelSystemDataDto.getAppToken();
        Map result = new HashMap();
        HashMap<String, String> extHeader = new HashMap<String, String>();
        extHeader.put("digi-userToken", token);
        extHeader.put("digi-appToken", appToken);
        result = Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal().equals(labelSystemDataDto.getDataModel()) ? this.espService.queryByEsp(labelSystemDataDto.getMiddleSystemName(), labelSystemDataDto.getMiddleSystemUid(), EAIServiceNameEnum.TODOLIST.getServiceName(), extHeader, null, todoListReq.getQryCondition(), PageInfo.getPageInfo((Integer)todoListReq.getPageNum(), (Integer)todoListReq.getPageSize())) : this.tripartiteService.selectDataPagePost(labelSystemDataDto.getRestUrl(), todoListReq, appToken);
        if (Objects.isNull(result.get("display_field_list"))) {
            log.error(this.messageUtils.getMessage("error.message.todo.field-missing-error"));
            todoListResp.setResultCode("3001");
            return todoListResp;
        }
        TodoListReq.EaiSys eaiSys = new TodoListReq.EaiSys();
        eaiSys.setAppName(labelSystemDataDto.getAppName());
        eaiSys.setAppToken(appToken);
        eaiSys.setUserBindFlag(labelSystemDataDto.getUserBindFlag());
        todoListResp = this.handleEspResult(AppAuthContextHolder.getContext().getAuthoredUser(), eaiSys, result, todoListReq.getQryCondition(), labelSystemDataDto);
        return todoListResp;
    }

    public TodoListResp selectTodoList(PreSystemToDoReq req) {
        String verifyUserId;
        TodoListResp todoListResp = new TodoListResp();
        todoListResp.setTodoList(new ArrayList());
        todoListResp.setTodoFieldList(new ArrayList());
        LabelSystemDataDto labelSystemDataDto = this.labelSystemDataService.getSystemDataSso(req.getId());
        if (null == labelSystemDataDto) {
            return todoListResp;
        }
        if (!labelSystemDataDto.getAppId().equals(req.getAppId())) {
            log.info("\u4e09\u65b9\u5f85\u529e\u5217\u8868\u8bf7\u6c42\u548c\u67e5\u8be2\u7684\u5e94\u7528id\u4e0d\u4e00\u81f4\uff1a{}\uff0c{}", (Object)req.getAppId(), (Object)labelSystemDataDto.getAppId());
        }
        req.setAppId(labelSystemDataDto.getAppId());
        String tokenId = null;
        if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(labelSystemDataDto.getAppCode())) {
            Map map;
            String userId = this.eocService.getEmpJobNum();
            if (StringUtils.isEmpty((CharSequence)userId)) {
                return todoListResp;
            }
            verifyUserId = userId;
            ResponseEntity response = this.mayCurService.getTokenId(labelSystemDataDto, userId);
            if (null != response && null != response.getBody() && null != (map = (Map)((Map)response.getBody()).get("data"))) {
                tokenId = map.get("tokenId").toString();
            }
            if (StringUtils.isNotEmpty(tokenId)) {
                List map2 = new LinkedList();
                LinkedList totalMapData = new LinkedList();
                int pageNum = -1;
                do {
                    if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(map2 = this.mayCurService.listMayCurData(tokenId, ++pageNum, labelSystemDataDto))) continue;
                    totalMapData.addAll(map2);
                } while (map2.size() == 500);
                LinkedList todoFieldList = new LinkedList();
                this.assembleData(totalMapData, labelSystemDataDto, todoFieldList, userId);
                todoListResp.setTodoFieldList(todoFieldList);
            }
        } else {
            verifyUserId = this.iamService.queryMappingEmpId(labelSystemDataDto.getAppCode());
            log.info("\u4e09\u65b9\u5f85\u529e\u5730\u7aef\u8d26\u53f7\uff1a{}\uff0c{}", (Object)labelSystemDataDto.getAppCode(), (Object)verifyUserId);
            if (StringUtils.isEmpty((CharSequence)verifyUserId)) {
                return todoListResp;
            }
            todoListResp.setTodoFieldList(this.selectFieldBy(req.getAppId()));
        }
        Page todoDataPage = this.selectByPage(req, verifyUserId);
        List todoLists = todoDataPage.getRecords();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)todoLists)) {
            return todoListResp;
        }
        this.packageRead(todoLists, req, verifyUserId, labelSystemDataDto);
        todoListResp.setTodoList(todoLists);
        todoListResp.setTotalResults(Integer.valueOf(Integer.parseInt(todoDataPage.getTotal() + "")));
        return todoListResp;
    }

    private void queryAccountList(List<AppUserDTO> userDTOList) {
        List accountDTOList = this.iamService.queryTenantAccountMappingList(null, null, null);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)accountDTOList)) {
            return;
        }
        Map<String, List<AccountDTO>> accountMap = accountDTOList.stream().collect(Collectors.groupingBy(AccountDTO::getAppId));
        for (AppUserDTO appUserDTO : userDTOList) {
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountMap.get(appUserDTO.getAppCode()))) continue;
            List<AccountDTO> accountList = accountMap.get(appUserDTO.getAppCode());
            ArrayList accountIdList = Lists.newArrayList();
            accountList.forEach(x -> {
                if (StringUtils.isNotBlank((CharSequence)x.getAccount())) {
                    accountIdList.add(x.getAccount());
                } else if (StringUtils.isNotBlank((CharSequence)x.getCompanyId())) {
                    accountIdList.add(x.getCompanyId());
                }
            });
            appUserDTO.setAccountIdList((List)accountIdList);
        }
    }

    private void assembleData(List<Map<String, Object>> map, LabelSystemDataDto labelSystemDataDto, List<TodoField> todoFieldList, String userId) {
        List<Object> todoLists = new LinkedList();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList updateToDoIdList = new ArrayList();
        ArrayList addToDoIdList = new ArrayList();
        int count = 0;
        for (Map<String, Object> item2 : map) {
            String status = "APPROVING".equals(item2.get("status").toString()) ? "\u5ba1\u6279\u4e2d" : "\u5f85\u62a5\u9500\u4eba\u786e\u8ba4";
            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(true).fluentPut("type", (Object)item2.get("type").toString()).fluentPut("businessCode", (Object)item2.get("businessCode").toString()).fluentPut("name", (Object)item2.get("name").toString()).fluentPut("reimUserName", (Object)item2.get("reimUserName").toString()).fluentPut("coverName(departmentName)", (Object)(item2.get("coverName").toString() + "(" + item2.get("departmentName").toString() + ")")).fluentPut("submittedAt", (Object)df.format(item2.get("submittedAt"))).fluentPut("status", (Object)status);
            ++count;
            TodoList todoList = new TodoList();
            todoList.setToDoSource(Integer.valueOf(2));
            todoList.setAppName(labelSystemDataDto.getAppName());
            todoList.setAppId(labelSystemDataDto.getAppId());
            todoList.setToDoUser(userId);
            todoList.setToDoData(JSON.toJSONString((Object)jsonObject));
            todoList.setToDoId(item2.get("businessCode").toString());
            todoList.setToDoUrl(labelSystemDataDto.getCallBackUrl() + item2.get("url").toString());
            todoList.setMobileUrl(labelSystemDataDto.getCallBackUrl() + item2.get("url").toString());
            todoList.setMobileMainTitle(item2.get("name").toString());
            todoList.setMobileSubTitle(df.format(item2.get("submittedAt")));
            todoList.setSubmittedAt(DateUtils.strToDate((String)todoList.getMobileSubTitle()));
            String submitterEmployeeId = "";
            String submitterName = "";
            if (null != item2.get("submitterEmployeeId")) {
                submitterEmployeeId = item2.get("submitterEmployeeId").toString();
            }
            if (null != item2.get("submitterName")) {
                submitterName = item2.get("submitterName").toString();
            }
            todoList.setMobileLabel("\u5de5\u53f7:" + submitterEmployeeId + ";\u540d\u79f0:" + submitterName + ";\u7533\u8bf7\u91d1\u989d:" + item2.get("amount"));
            todoLists.add(todoList);
            int i = 0;
            if (count != 1) continue;
            for (Map.Entry entry : jsonObject.entrySet()) {
                TodoField todoField = new TodoField();
                todoField.setAppName(labelSystemDataDto.getAppName());
                todoField.setAppId(labelSystemDataDto.getAppId());
                todoField.setToDoUser(userId);
                todoField.setDisplayOrder(Integer.valueOf(i++));
                todoField.setDisplayName(MaycurCulomnEnum.getDesc((String)((String)entry.getKey())));
                todoField.setBindingDataKey((String)entry.getKey());
                todoFieldList.add(todoField);
            }
        }
        todoLists = todoLists.stream().sorted(Comparator.comparing(TodoList::getSubmittedAt).reversed()).collect(Collectors.toList());
        List deTodoList = this.delTodoList(userId, labelSystemDataDto.getAppId(), todoLists, updateToDoIdList, addToDoIdList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)deTodoList)) {
            List toDoIds = deTodoList.stream().map(TodoList::getId).collect(Collectors.toList());
            this.todoListMapper.deleteBatchIds(toDoIds);
        }
        LinkedList<TodoList> updateToDoLists = new LinkedList<TodoList>();
        LinkedList<TodoList> addToDoLists = new LinkedList<TodoList>();
        for (TodoList todoList : todoLists) {
            if (updateToDoIdList.contains(todoList.getToDoId())) {
                updateToDoLists.add(todoList);
            }
            if (!addToDoIdList.contains(todoList.getToDoId())) continue;
            addToDoLists.add(todoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateToDoLists)) {
            updateToDoLists.forEach(item -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(TodoList::getAppId, (Object)item.getAppId());
                updateWrapper.eq(TodoList::getToDoId, (Object)item.getToDoId());
                updateWrapper.eq(TodoList::getToDoUser, (Object)item.getToDoUser());
                this.update(item, (Wrapper)updateWrapper);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(addToDoLists)) {
            this.saveBatch(addToDoLists);
        }
        LambdaQueryWrapper queryTodoFieldWrapper = new LambdaQueryWrapper();
        queryTodoFieldWrapper.eq(TodoField::getAppId, (Object)labelSystemDataDto.getAppId());
        this.todoFieldService.remove((Wrapper)queryTodoFieldWrapper);
        this.todoFieldService.saveBatch(todoFieldList);
    }

    public List<TodoList> delTodoList(String userId, String appId, List<TodoList> mayTodoLists, List<String> updateToDoIdList, List<String> addToDoIdList) {
        List mayToDoIds;
        ArrayList<TodoList> deTodoList = new ArrayList<TodoList>();
        ArrayList<String> toDoUserList = new ArrayList<String>();
        List<Object> dbToDoIds = new ArrayList();
        toDoUserList.add(userId);
        List dbTodoList = this.selectToDoBy(appId, "", toDoUserList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dbTodoList)) {
            dbToDoIds = dbTodoList.stream().map(TodoList::getToDoId).collect(Collectors.toList());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(mayToDoIds = mayTodoLists.stream().map(TodoList::getToDoId).collect(Collectors.toList()))) {
            return dbTodoList;
        }
        for (TodoList dbTodo : dbTodoList) {
            if (mayToDoIds.contains(dbTodo.getToDoId())) continue;
            deTodoList.add(dbTodo);
        }
        for (TodoList mayTodo : mayTodoLists) {
            if (dbToDoIds.contains(mayTodo.getToDoId())) {
                updateToDoIdList.add(mayTodo.getToDoId());
                continue;
            }
            addToDoIdList.add(mayTodo.getToDoId());
        }
        return deTodoList;
    }

    public void packageRead(List<TodoList> todoLists, PreSystemToDoReq req, String verifyUserId, LabelSystemDataDto labelSystemDataDto) {
        List todoReadList = this.selectToDoReadBy(req, verifyUserId);
        List toDoReadIdList = todoReadList.stream().map(TodoRead::getToDoId).collect(Collectors.toList());
        for (TodoList todo : todoLists) {
            todo.setIsRead(IfNotIntegerEnum.NO.getValue());
            if (toDoReadIdList.contains(todo.getToDoId())) {
                todo.setIsRead(IfNotIntegerEnum.YES.getValue());
            }
            if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(labelSystemDataDto.getAppCode())) continue;
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            if (StringUtils.isNotEmpty((CharSequence)todo.getToDoUrl())) {
                String toDoUrl = this.getToDoUrl(todo.getToDoUrl(), user, labelSystemDataDto);
                todo.setToDoUrl(toDoUrl);
            }
            if (!StringUtils.isNotEmpty((CharSequence)todo.getMobileUrl())) continue;
            String mobileUrl = this.getToDoUrl(todo.getMobileUrl(), user, labelSystemDataDto);
            todo.setMobileUrl(mobileUrl);
        }
    }

    public List<TodoField> selectFieldBy(String appId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        return this.todoFieldMapper.selectList((Wrapper)queryWrapper);
    }

    public List<TodoRead> selectToDoReadBy(PreSystemToDoReq req, String verifyUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)req.getAppId())) {
            queryWrapper.eq((Object)"app_id", (Object)req.getAppId());
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyUserId)) {
            queryWrapper.eq((Object)"to_do_user", (Object)verifyUserId);
        }
        return this.todoReadMapper.selectList((Wrapper)queryWrapper);
    }

    public List<TodoList> selectToDoBy(String appId, String toDoId, List<String> toDoUserList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        if (StringUtils.isNotEmpty((CharSequence)toDoId)) {
            queryWrapper.eq((Object)"to_do_id", (Object)toDoId);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(toDoUserList)) {
            queryWrapper.in((Object)"to_do_user", toDoUserList);
        }
        return this.todoListMapper.selectList((Wrapper)queryWrapper);
    }

    public List<TodoList> selectToDoBy(String appId, String toDoId, List<String> toDoUserList, Integer dataCategory, String verifyUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        if (StringUtils.isNotEmpty((CharSequence)toDoId)) {
            queryWrapper.eq((Object)"to_do_id", (Object)toDoId);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(toDoUserList)) {
            queryWrapper.in((Object)"to_do_user", toDoUserList);
        }
        if (null != dataCategory && dataCategory == 0 && StringUtils.isNotEmpty((CharSequence)verifyUserId)) {
            queryWrapper.eq((Object)"to_do_user", (Object)verifyUserId);
        }
        if (null != dataCategory && dataCategory == 1 && StringUtils.isNotEmpty((CharSequence)verifyUserId)) {
            queryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"to_do_user", (Object)verifyUserId)).or()).eq((Object)"founder", (Object)verifyUserId);
            });
        }
        return this.todoListMapper.selectList((Wrapper)queryWrapper);
    }

    public QueryWrapper getToDoWrapepr(String appId, List<String> toDoIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(toDoIds)) {
            queryWrapper.in((Object)"to_do_id", toDoIds);
        }
        return queryWrapper;
    }

    public QueryWrapper getToDoWrapeprByUserId(String appId, List<String> toDoIds, String verifyUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(toDoIds)) {
            queryWrapper.in((Object)"to_do_id", toDoIds);
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyUserId)) {
            queryWrapper.eq((Object)"to_do_user", (Object)verifyUserId);
        }
        return queryWrapper;
    }

    public Page<TodoList> selectByPage(PreSystemToDoReq req, String verifyUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"id");
        if (StringUtils.isNotEmpty((CharSequence)req.getAppId())) {
            queryWrapper.eq((Object)"app_id", (Object)req.getAppId());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getQryCondition())) {
            queryWrapper.like((Object)"to_do_data", (Object)req.getQryCondition());
        }
        if (0 == req.getDataCategory()) {
            queryWrapper.eq((Object)"is_completed", (Object)0);
            queryWrapper.eq((Object)"to_do_user", (Object)verifyUserId);
        }
        if (1 == req.getDataCategory()) {
            queryWrapper.eq((Object)"is_completed", (Object)1);
            queryWrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)x.eq((Object)"to_do_user", (Object)verifyUserId);
            });
        }
        Page todoDataPage = (Page)this.todoListMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)queryWrapper);
        return todoDataPage;
    }

    public ResponseEntity<?> getTodoListUrl(ReimburseReq reimburseReq) {
        String ssoUrl;
        ReimburseUrlVO reimburseUrlVO = new ReimburseUrlVO();
        TodoList todoList = (TodoList)this.todoListMapper.selectById((Serializable)reimburseReq.getId());
        if (ObjectUtils.isEmpty((Object)todoList)) {
            return ResponseEntityWrapper.wrapperOk((Object)reimburseUrlVO);
        }
        long timestamp = System.currentTimeMillis();
        PreinstalledApplicationInstance applicationInstance = this.preinstalledApplicationService.getPreINstance(null, todoList.getAppId(), "");
        if (ObjectUtils.isEmpty((Object)applicationInstance)) {
            applicationInstance = this.preinstalledApplicationService.getPreINstance(null, "", todoList.getAppId());
        }
        if (ObjectUtils.isEmpty((Object)applicationInstance)) {
            return ResponseEntityWrapper.wrapperOk((Object)reimburseUrlVO);
        }
        PreinstalledApplication preApplication = this.preinstalledApplicationService.getPreApp(applicationInstance.getPreinstalledApplicationId());
        if (ObjectUtils.isEmpty((Object)preApplication)) {
            return ResponseEntityWrapper.wrapperOk((Object)reimburseUrlVO);
        }
        if ("06".equals(preApplication.getProductCode())) {
            ssoUrl = this.getTIPTOPUrl(applicationInstance, preApplication, todoList.getToDoUrl());
            String toDoUrl = this.getOtherArg(todoList.getToDoUrl());
            todoList.setToDoUrl(toDoUrl);
            ssoUrl = this.packageSsoUrl(ssoUrl, todoList.getToDoUrl());
            reimburseUrlVO.setToDoUrl(ssoUrl);
            reimburseUrlVO.setToDoMobileUrl(ssoUrl);
        }
        if ("100".equals(preApplication.getProductCode())) {
            ssoUrl = this.getT100Url(applicationInstance, preApplication);
            ssoUrl = this.packageSsoUrl(ssoUrl, todoList.getToDoUrl());
            reimburseUrlVO.setToDoUrl(ssoUrl);
            reimburseUrlVO.setToDoMobileUrl(ssoUrl);
        }
        if (MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(preApplication.getApplicationCode())) {
            String userId = this.eocService.getEmpJobNum();
            if (StringUtils.isEmpty((CharSequence)userId)) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.NO_USER_ID, (String)"\u65e0\u5bf9\u5e94\u5de5\u53f7");
            }
            JSONObject jsonObject = applicationInstance.getApplicationExtConfig();
            String appId = jsonObject.getString("appId");
            String appSecret = jsonObject.getString("appSecret");
            String ssoToken = this.mayCurService.getSsoToken(userId, appSecret, timestamp);
            String ssoUrl2 = this.mayCurService.getReplaceExistUrl(todoList.getToDoUrl(), appId, userId, timestamp, ssoToken);
            reimburseUrlVO.setToDoUrl(ssoUrl2);
            reimburseUrlVO.setToDoMobileUrl(ssoUrl2);
        }
        return ResponseEntityWrapper.wrapperOk((Object)reimburseUrlVO);
    }

    public String packageSsoUrl(String ssoUrl, String toDoUrl) {
        if (StringUtils.isEmpty((CharSequence)toDoUrl)) {
            return ssoUrl;
        }
        if (toDoUrl.startsWith("&")) {
            ssoUrl = ssoUrl + toDoUrl;
        }
        if (!toDoUrl.startsWith("&")) {
            ssoUrl = ssoUrl + "&" + toDoUrl;
        }
        return ssoUrl;
    }

    public String getTIPTOPUrl(PreinstalledApplicationInstance applicationInstance, PreinstalledApplication preApplication, String toDoUrl) {
        String ssoUrl = "";
        JSONObject jsonObject = applicationInstance.getApplicationExtConfig();
        ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)preApplication.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
        String ip = Optional.ofNullable(jsonObject).map(object -> object.getString("ip")).orElse("");
        String loginUserId = this.iamService.queryMappingEmpId(preApplication.getApplicationCode());
        String tokenKey = Utils.encryptionTokenKey((String)erpSsoSpecialDTO.getSystemCode(), (String)loginUserId);
        ssoUrl = erpSsoSpecialDTO.getProtocolHeader() + ip + "?Arg=" + erpSsoSpecialDTO.getArg() + "&Arg=" + loginUserId + "&Arg=" + tokenKey + "&" + this.getOperCenter(toDoUrl) + "&" + this.getJoCode(toDoUrl) + "&Arg=" + LocaleContextHolder.getLocale();
        return ssoUrl;
    }

    public String getJoCode(String toDoUrl) {
        String jobCode = "";
        if (toDoUrl.contains("&") && toDoUrl.startsWith("") && toDoUrl.split("&").length > 2) {
            jobCode = toDoUrl.split("&")[1];
        }
        return jobCode;
    }

    public String getOperCenter(String toDoUrl) {
        String operCenter = "";
        if (toDoUrl.contains("&") && toDoUrl.startsWith("") && toDoUrl.split("&").length > 3) {
            operCenter = toDoUrl.split("&")[2];
        }
        return operCenter;
    }

    public String getOtherArg(String toDoUrl) {
        String resp = "";
        String[] argList = toDoUrl.split("&");
        for (int i = 0; i < argList.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)argList[i]) || i <= 2) continue;
            resp = resp + "&" + argList[i];
        }
        return resp;
    }

    public String getT100Url(PreinstalledApplicationInstance applicationInstance, PreinstalledApplication preApplication) {
        String ssoUrl = "";
        JSONObject jsonObject = applicationInstance.getApplicationExtConfig();
        ErpSsoSpecialDTO erpSsoSpecialDTO = (ErpSsoSpecialDTO)Optional.ofNullable(com.alibaba.fastjson.JSONObject.parseObject((String)preApplication.getApplicationConfig(), ErpSsoSpecialDTO.class)).orElse(new ErpSsoSpecialDTO());
        String protocolHeader = Optional.ofNullable(jsonObject).map(object -> object.getString("protocolHeader")).orElse("");
        String ip = Optional.ofNullable(jsonObject).map(object -> object.getString("ip")).orElse("");
        String companyCode = Optional.ofNullable(jsonObject).map(object -> object.getString("companyCode")).orElse("");
        String environment = StringUtils.isNotBlank((CharSequence)erpSsoSpecialDTO.getEnvironment()) ? "/w" + erpSsoSpecialDTO.getEnvironment() : "";
        String linkStr = protocolHeader + ip + environment + "/wa/r/app/gdc_azzi000?Arg=" + companyCode + "&Arg=" + erpSsoSpecialDTO.getArg() + "&Arg=QVRIRU5B&Arg=";
        String loginUserId = this.iamService.queryMappingEmpId(preApplication.getApplicationCode());
        String hashKey = DateUtils.getNowTime((String)"yyyyMMddHHmmss") + "athenaAb1234PWd28682266T100frank" + loginUserId;
        String encoderHashKey = Base64.getEncoder().encodeToString(hashKey.getBytes(StandardCharsets.UTF_8));
        encoderHashKey = encoderHashKey.replaceAll("\\+", "_plus_");
        ssoUrl = linkStr + encoderHashKey;
        return ssoUrl;
    }

    @Transactional
    public Integer toDoReceive(TodoReceiveDto receiveDto) {
        List delToDoList;
        ArrayList todoList = Lists.newArrayList();
        ArrayList<String> verifyUserldList = new ArrayList<String>();
        ArrayList<String> todoIds = new ArrayList<String>();
        for (TodoListDto todoDto : receiveDto.getToDoList()) {
            if (StringUtils.isEmpty((CharSequence)todoDto.getToDoOwner()) || StringUtils.isEmpty((CharSequence)todoDto.getToDoId())) continue;
            if (!verifyUserldList.contains(todoDto.getToDoOwner())) {
                verifyUserldList.add(todoDto.getToDoOwner());
            }
            TodoList toDo = (TodoList)this.converter.convert((Object)todoDto, TodoList.class);
            toDo.setAppIdCode(receiveDto.getAppIdCode());
            toDo.setAppId(receiveDto.getAppCode());
            toDo.setMobileUrl(todoDto.getToDoMobileUrl());
            toDo.setToDoUser(todoDto.getToDoOwner());
            todoList.add(toDo);
            todoIds.add(todoDto.getToDoId());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)todoList)) {
            return null;
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(todoIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(delToDoList = this.todoListMapper.selectList((Wrapper)this.getToDoWrapepr(receiveDto.getAppCode(), todoIds))))) {
            List delIdList = delToDoList.stream().map(TodoList::getId).collect(Collectors.toList());
            this.todoListMapper.deleteBatchIds(delIdList);
        }
        this.saveBatch((Collection)todoList);
        QueryWrapper delFieldWrapper = new QueryWrapper();
        delFieldWrapper.eq((Object)"app_id", (Object)receiveDto.getAppCode());
        this.todoFieldMapper.delete((Wrapper)delFieldWrapper);
        ArrayList todoFieldList = Lists.newArrayList();
        for (TodoFieldDto toDoField : receiveDto.getDisplayFieldList()) {
            TodoField field = (TodoField)this.converter.convert((Object)toDoField, TodoField.class);
            field.setAppId(receiveDto.getAppCode());
            todoFieldList.add(field);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)todoFieldList)) {
            this.todoFieldService.saveBatch((Collection)todoFieldList);
        }
        this.pushToUser(receiveDto.getAppCode(), verifyUserldList);
        return null;
    }

    @Transactional
    public Integer approvalsNotice(MaycurTodoNoticeReq req) {
        MaycurCalloutParamsReq calloutParamsReq = req.getCalloutParams();
        if (!MaycurTaskActionTypeEnum.PROCESSING.getType().equals(calloutParamsReq.getTaskActionType())) {
            List todoLists = this.selectToDoBy("", calloutParamsReq.getFormCode(), calloutParamsReq.getTaskAssignee());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)todoLists)) {
                return null;
            }
            List todoIdList = todoLists.stream().map(TodoList::getId).collect(Collectors.toList());
            this.todoListMapper.deleteBatchIds(todoIdList);
            PreinstalledApplication preApp = this.preinstalledApplicationService.getPreByCode(MaycurCodeEnum.MAYCUR_APPROVALS.getType(), "");
            if (null == preApp) {
                return null;
            }
            this.pushToUser(preApp.getAppId(), calloutParamsReq.getTaskAssignee());
        }
        return null;
    }

    public void pushToUser(String appCode, List<String> verifyUserldList) {
        for (String verifyUserld : verifyUserldList) {
            try {
                MessageDO payload = new MessageDO();
                payload.setAppId(appCode);
                payload.setUserId(verifyUserld);
                payload.setType(Constants.VALID_STATUS_UNUSABLE);
                this.messageSendService.sendToClient(verifyUserld, payload, "SEMC_TODO_USER");
            }
            catch (Exception e) {
                log.info("\u3010pushToUser-sendToClient\u53d1\u9001MQTT\u5f02\u5e38\u3011verifyUserld\uff1a{},error\uff1a{}", (Object)verifyUserld, (Object)e);
            }
        }
    }

    public TodoCountResp selectTodoCount(PreSystemToDoCountReq req) {
        TodoCountResp resp = new TodoCountResp();
        resp.setToDoNum(Integer.valueOf(0));
        resp.setToDoneNum(Integer.valueOf(0));
        resp.setToSumNum(Integer.valueOf(0));
        String verifyUserId = MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(req.getAppCode()) ? this.eocService.getEmpJobNum() : this.iamService.queryMappingEmpId(req.getAppCode());
        if (StringUtils.isBlank((CharSequence)verifyUserId)) {
            return resp;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)req.getAppId()), TodoList::getAppId, (Object)req.getAppId());
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)req.getQryCondition()), TodoList::getToDoData, (Object)req.getQryCondition());
        List todoLists = this.todoListMapper.selectList((Wrapper)queryWrapper);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)todoLists)) {
            return resp;
        }
        long toDoNum = todoLists.stream().filter(m -> Integer.valueOf(0).equals(m.getIsCompleted()) && verifyUserId.equals(m.getToDoUser())).count();
        resp.setToDoNum(Integer.valueOf((int)toDoNum));
        long toDoneNum = todoLists.stream().filter(m -> Integer.valueOf(1).equals(m.getIsCompleted()) && verifyUserId.equals(m.getToDoUser())).count();
        resp.setToDoneNum(Integer.valueOf((int)toDoneNum));
        resp.setToSumNum(Integer.valueOf(resp.getToDoNum() + resp.getToDoneNum()));
        return resp;
    }

    public com.alibaba.fastjson.JSONObject queryToDoCount(List<LabelSystemData> systemDataList) {
        List mkSystemDataList;
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        List userDTOList = Lists.newArrayList();
        List commonSystemDataList = systemDataList.stream().filter(x -> !Arrays.asList(MaycurCodeEnum.MAYCUR_CLOUD.getType(), MaycurCodeEnum.MAYCUR_APPROVALS.getType()).contains(x.getAppCode())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonSystemDataList)) {
            userDTOList = this.queryVerifyUseridList(commonSystemDataList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mkSystemDataList = systemDataList.stream().filter(x -> MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(x.getAppCode())).collect(Collectors.toList()))) {
            String userId = this.eocService.getEmpJobNum();
            List mkUserDTOList = mkSystemDataList.stream().map(x -> {
                AppUserDTO appUserDTO = new AppUserDTO();
                appUserDTO.setAppId(x.getAppId());
                appUserDTO.setVerifyUserId(userId);
                return appUserDTO;
            }).collect(Collectors.toList());
            userDTOList.addAll(mkUserDTOList);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)userDTOList)) {
            jsonObject.put("toDoCount", (Object)0);
            jsonObject.put("unReadCount", (Object)0);
            return jsonObject;
        }
        List todoList = this.todoListMapper.queryToDoListByUserId(userDTOList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)todoList)) {
            jsonObject.put("toDoCount", (Object)0);
            jsonObject.put("unReadCount", (Object)0);
            return jsonObject;
        }
        jsonObject.put("toDoCount", (Object)todoList.size());
        List todoReadList = this.todoReadMapper.queryToDoReadByUserId(userDTOList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)todoReadList)) {
            jsonObject.put("unReadCount", (Object)todoList.size());
            return jsonObject;
        }
        todoReadList = todoReadList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TodoRead>(Comparator.comparing(o -> o.getAppId() + ";" + o.getToDoId() + ";" + o.getToDoUser()))), ArrayList::new));
        List allTodoIdList = todoList.stream().map(TodoList::getToDoId).collect(Collectors.toList());
        List readTodoIdList = todoReadList.stream().map(TodoRead::getToDoId).collect(Collectors.toList());
        List respList = allTodoIdList.stream().filter(readTodoIdList::contains).collect(Collectors.toList());
        jsonObject.put("unReadCount", (Object)Math.max(allTodoIdList.size() - respList.size(), 0));
        return jsonObject;
    }

    private List<AppUserDTO> queryVerifyUseridList(List<LabelSystemData> commonSystemDataList) {
        commonSystemDataList = commonSystemDataList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getAppCode())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LabelSystemData>(Comparator.comparing(LabelSystemData::getAppCode))), ArrayList::new));
        ArrayList appVerifyUserIdList = Lists.newArrayList();
        commonSystemDataList.forEach(x -> {
            String verifyUserId = this.iamService.queryMappingEmpId(x.getAppCode());
            if (StringUtils.isNotBlank((CharSequence)verifyUserId)) {
                AppUserDTO appUserDTO = new AppUserDTO();
                appUserDTO.setAppCode(x.getAppCode());
                appUserDTO.setAppId(x.getAppId());
                appUserDTO.setVerifyUserId(verifyUserId);
                appVerifyUserIdList.add(appUserDTO);
            }
        });
        return appVerifyUserIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<?> syncThirdTodoData(PreSystemToDoUpdateReq req) {
        List todoList = new ArrayList();
        ArrayList todoLists = new ArrayList();
        List todoFieldList = new ArrayList();
        String tenantId = Utils.getTenantId();
        String token = Utils.getUserToken();
        String appId = req.getAppId();
        LabelSystemData labelSystemData = (LabelSystemData)this.labelSystemDataMapper.selectById((Serializable)req.getId());
        if (null == labelSystemData) {
            return ResponseEntityWrapper.wrapperOk((Object)this.messageUtils.getMessage("error.message.third.data.updated"));
        }
        QueryWrapper condition2 = new QueryWrapper();
        condition2.eq((Object)"app_primary_id", (Object)labelSystemData.getAppCode());
        condition2.eq((Object)"app_source", (Object)labelSystemData.getDataType());
        List thirdTodoConfigList = this.thirdTodoConfigService.getBaseMapper().selectList((Wrapper)condition2);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)thirdTodoConfigList)) {
            return ResponseEntityWrapper.wrapperOk((Object)this.messageUtils.getMessage("error.message.third.data.updated"));
        }
        ThirdTodoConfig thirdTodoConfig = (ThirdTodoConfig)thirdTodoConfigList.get(0);
        if (thirdTodoConfig.getValidStatus() == 0 || thirdTodoConfig.getAppAccessModel() == null) {
            return ResponseEntityWrapper.wrapperOk((Object)this.messageUtils.getMessage("error.message.third.data.updated"));
        }
        RedisLock redisLock = new RedisLock(appId + tenantId);
        try {
            if (!redisLock.lock()) {
                return ResponseEntityWrapper.wrapperOk();
            }
        }
        catch (InterruptedException e) {
            return ResponseEntityWrapper.wrapperOk();
        }
        try {
            List result;
            log.info("syncThirdTodoData start  appId:{}", (Object)appId);
            if (thirdTodoConfig.getAppAccessModel() == 0) {
                String middleSystemName = thirdTodoConfig.getMiddleSystemName();
                String middleSystemUid = thirdTodoConfig.getMiddleSystemUid();
                HashMap<String, String> extHeader = new HashMap<String, String>();
                extHeader.put("digi-userToken", token);
                extHeader.put("digi-appToken", this.envProperties.getAppToken());
                int i = 1;
                while (true) {
                    HashMap<String, Object> parameter = new HashMap<String, Object>();
                    parameter.put("page_no", i);
                    parameter.put("page_size", Constants.TODO_MAX_SIZE);
                    parameter.put("tenant_id", tenantId);
                    result = this.espService.queryByEsp(middleSystemName, middleSystemUid, EAIServiceNameEnum.TO_DO_LIST_QUERY.getServiceName(), extHeader, parameter, null, null);
                    if (Objects.isNull(result.get("to_do_list"))) {
                        log.info("syncThirdTodoData \u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u5f85\u529e\u6570\u636e");
                        break;
                    }
                    todoList = (List)result.get("to_do_list");
                    todoFieldList = (List)result.get("display_field_list");
                    log.info("syncThirdTodoData  \u6df7\u5408\u4e91\u5f85\u529e\u6570\u636e:{}", todoList);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(todoList)) {
                        todoLists.addAll(todoList);
                    }
                    if (!((Boolean)result.get("has_next")).booleanValue()) break;
                    ++i;
                }
            }
            if (thirdTodoConfig.getAppAccessModel() == 1) {
                int i = 1;
                while (true) {
                    String domain = thirdTodoConfig.getDomain();
                    HashMap<String, Object> bodyMap = new HashMap<String, Object>();
                    bodyMap.put("page_no", i);
                    bodyMap.put("page_size", Constants.TODO_MAX_SIZE);
                    bodyMap.put("tenant_id", tenantId);
                    Map jobData = this.tripartiteService.queryThirdData(domain + "/tenant/semc/todo/queryAll", "", bodyMap);
                    if (null == jobData) {
                        log.info("syncThirdTodoData \u975e\u6df7\u5408\u4e91\u672a\u67e5\u8be2\u5230\u5f85\u529e\u6570\u636e");
                        break;
                    }
                    todoList = (List)jobData.get("to_do_list");
                    todoFieldList = (List)jobData.get("display_field_list");
                    log.info("syncThirdTodoData \u975e\u6df7\u5408\u4e91\u5f85\u529e\u6570\u636e:{}", todoList);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(todoList)) {
                        todoLists.addAll(todoList);
                    }
                    if (!((Boolean)jobData.get("has_next")).booleanValue()) break;
                    ++i;
                }
            }
            String verifyUserId = "";
            LabelSystemDataDto labelSystemDataDto = this.labelSystemDataService.getSystemDataSso(req.getId());
            if (null != labelSystemDataDto) {
                verifyUserId = this.iamService.queryMappingEmpId(labelSystemDataDto.getAppCode());
            }
            this.handleTodoData(todoLists, todoFieldList, appId, verifyUserId);
            List todoReadList = this.todoReadMapper.selectList((Wrapper)this.getToDoReadWrapepr(appId, verifyUserId));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)todoReadList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(todoLists)) {
                for (TodoRead todoRead : todoReadList) {
                    result = todoLists.stream().filter(it -> it.get("to_do_id").toString().equals(todoRead.getToDoId()) && it.get("to_do_owner").toString().equals(todoRead.getToDoUser())).collect(Collectors.toList());
                    if (result.size() != 0) continue;
                    QueryWrapper deleteWrapper = new QueryWrapper();
                    deleteWrapper.eq((Object)"app_id", (Object)appId);
                    deleteWrapper.eq((Object)"to_do_id", (Object)todoRead.getToDoId());
                    deleteWrapper.eq((Object)"to_do_user", (Object)todoRead.getToDoUser());
                    this.todoFieldMapper.delete((Wrapper)deleteWrapper);
                }
            }
        }
        catch (Exception e) {
            log.error("syncThirdTodoData error  e:{}", (Throwable)e);
            ResponseEntity responseEntity = ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.SYSTEM_ERROR, (String)this.messageUtils.getMessage("error.message.third.data.updated.error"));
            return responseEntity;
        }
        finally {
            redisLock.unlock();
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.messageUtils.getMessage("error.message.third.data.updated"));
    }

    public QueryWrapper getToDoFieldWrapepr(String appId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        return queryWrapper;
    }

    public QueryWrapper getToDoReadWrapepr(String appId, String verifyUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyUserId)) {
            queryWrapper.eq((Object)"to_do_user", (Object)verifyUserId);
        }
        return queryWrapper;
    }

    public void handleTodoData(List<Map<String, Object>> todoList, List<Map<String, Object>> todoFieldList, String appId, String verifyUserId) {
        List batchEntities;
        ArrayList<TodoList> todoListDtos = new ArrayList<TodoList>();
        ArrayList<TodoField> todoFieldListDtos = new ArrayList<TodoField>();
        ArrayList<TodoList> todoAllList = new ArrayList<TodoList>();
        for (Map<String, Object> map : todoList) {
            TodoList todo = new TodoList();
            String todoId = map.get("to_do_id").toString();
            String todoUser = "";
            if (map.get("to_do_owner") != null) {
                todoUser = map.get("to_do_owner").toString();
            }
            if (StringUtils.isEmpty((CharSequence)todoId) || StringUtils.isEmpty((CharSequence)todoUser)) continue;
            todo.setToDoSource(Integer.valueOf(2));
            todo.setAppName("");
            todo.setAppId(appId);
            todo.setToDoId(todoId);
            String toDoUrl = map.get("to_do_url") == null ? "" : map.get("to_do_url").toString();
            todo.setToDoUrl(toDoUrl);
            String mobileUrl = map.get("to_do_mobile_url") == null ? "" : map.get("to_do_mobile_url").toString();
            todo.setMobileUrl(mobileUrl);
            todo.setToDoUser(todoUser);
            String toDoData = map.get("to_do_data") == null ? "" : map.get("to_do_data").toString();
            todo.setToDoData(toDoData);
            todo.setIsCompleted(Integer.valueOf(0));
            todo.setIsRead(Integer.valueOf(0));
            String mobileMainTitle = map.get("mobile_main_title") == null ? "" : map.get("mobile_main_title").toString();
            todo.setMobileMainTitle(mobileMainTitle);
            String mobileSubTitle = map.get("mobile_sub_title") == null ? "" : map.get("mobile_sub_title").toString();
            todo.setMobileSubTitle(mobileSubTitle);
            String mobileLabel = map.get("mobile_label") == null ? "" : map.get("mobile_label").toString();
            todo.setMobileLabel(mobileLabel);
            todo.setTenantId("");
            todo.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            todoAllList.add(todo);
            if (!StringUtils.isEmpty((CharSequence)verifyUserId) && !todoUser.equals(verifyUserId)) continue;
            todoListDtos.add(todo);
        }
        for (Map<String, Object> fieldmap : todoFieldList) {
            TodoField field = new TodoField();
            field.setAppId(appId);
            String displayName = fieldmap.get("display_name") == null ? "" : fieldmap.get("display_name").toString();
            field.setDisplayName(displayName);
            Integer displayOrder = fieldmap.get("display_order") == null ? null : Integer.valueOf(Integer.parseInt(fieldmap.get("display_order").toString()));
            field.setDisplayOrder(displayOrder);
            String bindingDataKey = fieldmap.get("binding_data_key") == null ? "" : fieldmap.get("binding_data_key").toString();
            field.setBindingDataKey(bindingDataKey);
            field.setCreateTime(DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"));
            todoFieldListDtos.add(field);
        }
        this.todoListMapper.delete((Wrapper)this.getToDoWrapeprByUserId(appId, new ArrayList(), verifyUserId));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(todoListDtos)) {
            if (todoListDtos.size() > 1000) {
                for (int i = 0; i < todoListDtos.size(); i += 1000) {
                    batchEntities = todoListDtos.subList(i, Math.min(i + 1000, todoListDtos.size()));
                    this.saveBatch(batchEntities);
                }
            } else {
                this.saveBatch(todoListDtos);
            }
        } else if (StringUtils.isEmpty((CharSequence)verifyUserId) && org.apache.commons.collections.CollectionUtils.isNotEmpty(todoAllList)) {
            if (todoAllList.size() > 1000) {
                for (int i = 0; i < todoAllList.size(); i += 1000) {
                    batchEntities = todoAllList.subList(i, Math.min(i + 1000, todoAllList.size()));
                    this.saveBatch(batchEntities);
                }
            } else {
                this.saveBatch(todoAllList);
            }
        }
        this.todoFieldMapper.delete((Wrapper)this.getToDoFieldWrapepr(appId));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(todoFieldListDtos)) {
            this.todoFieldService.saveBatch(todoFieldListDtos);
        }
    }

    public void pushNoticeToUser(String appCode, List<String> verifyUserldList) {
        for (String verifyUserld : verifyUserldList) {
            try {
                MessageDO payload = new MessageDO();
                payload.setAppId(appCode);
                payload.setUserId(verifyUserld);
                payload.setType(Constants.VALID_STATUS_UNUSABLE);
                this.messageSendService.sendToClient(verifyUserld, payload, "SEMC_TODO_USER");
            }
            catch (Exception e) {
                log.info("\u3010pushToUser-sendToClient\u53d1\u9001MQTT\u5f02\u5e38\u3011verifyUserld\uff1a{},error\uff1a{}", (Object)verifyUserld, (Object)e);
            }
        }
    }

    public String getVerifyUserId(String appCode) {
        String verifyUserId = "";
        verifyUserId = MaycurCodeEnum.MAYCUR_APPROVALS.getType().equals(appCode) ? this.eocService.getEmpJobNum() : this.iamService.queryMappingEmpId(appCode);
        return verifyUserId;
    }

    public List<LabelSystemData> searchTodoApp(PreSystemToDoSearchAppReq req) {
        QueryLabelSystemReq querySystemReq = new QueryLabelSystemReq();
        querySystemReq.setDataType(Constants.DataTypeEnum.TYPE_THIRD_TODO.getVal());
        boolean isEmptyQuery = StringUtils.isBlank((CharSequence)req.getQryCondition());
        List dataIds = this.labelSystemSourceService.selectPreSystem(querySystemReq.getDataType(), Constants.LabelTypeEnum.SYSTEM_PRE.getVal());
        List oneLabelSystemDataList = this.labelSystemDataService.queryDataInfoBy(dataIds, Boolean.valueOf(isEmptyQuery));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)oneLabelSystemDataList)) {
            log.info("\u4e09\u65b9\u5f85\u529e\u641c\u7d22\u5e94\u7528\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        List<LabelSystemData> labelSystemDataList = new ArrayList();
        if (isEmptyQuery) {
            labelSystemDataList = oneLabelSystemDataList;
        } else {
            Map oneLabelSystemDataMap = oneLabelSystemDataList.stream().collect(Collectors.toMap(LabelSystemData::getAppId, Function.identity(), (a, b) -> a));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(TodoList::getAppId, oneLabelSystemDataMap.keySet());
            queryWrapper.like(StringUtils.isNotBlank((CharSequence)req.getQryCondition()), TodoList::getToDoData, (Object)req.getQryCondition());
            queryWrapper.groupBy(TodoList::getAppId);
            List todoLists = this.todoListMapper.selectList((Wrapper)queryWrapper);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)todoLists)) {
                log.info("\u4e09\u65b9\u5f85\u529e\u641c\u7d22\u5e94\u7528\u7ed3\u679c\u4e3a\u7a7a");
                return Lists.newArrayList();
            }
            for (TodoList todoList : todoLists) {
                LabelSystemData labelSystemData = (LabelSystemData)oneLabelSystemDataMap.get(todoList.getAppId());
                if (labelSystemData == null) continue;
                labelSystemDataList.add(labelSystemData);
            }
            for (LabelSystemData labelSystemData : labelSystemDataList) {
                PreSystemToDoCountReq countReq = new PreSystemToDoCountReq();
                countReq.setAppId(labelSystemData.getAppId());
                countReq.setAppName(labelSystemData.getAppCode());
                countReq.setAppCode(labelSystemData.getAppCode());
                countReq.setId(labelSystemData.getId());
                countReq.setQryCondition(req.getQryCondition());
                TodoCountResp todoCountResp = this.selectTodoCount(countReq);
                labelSystemData.setToDoNum(todoCountResp.getToDoNum());
                labelSystemData.setToDoneNum(todoCountResp.getToDoneNum());
                labelSystemData.setToSumNum(todoCountResp.getToSumNum());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(labelSystemDataList)) {
                Iterator iterator = labelSystemDataList.iterator();
                while (iterator.hasNext()) {
                    LabelSystemData next = (LabelSystemData)iterator.next();
                    if (!Objects.equals(0, next.getToDoNum()) || !Objects.equals(0, next.getToDoneNum()) || !Objects.equals(0, next.getToSumNum())) continue;
                    iterator.remove();
                }
            }
        }
        List labelSystemData = this.todoAppSortService.sortLabelSystemData(labelSystemDataList);
        if (CollectionUtils.isEmpty((Collection)labelSystemData)) {
            return Collections.emptyList();
        }
        List distinctLabelSystemDatas = labelSystemData.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LabelSystemData>(Comparator.comparing(LabelSystemData::getAppCode))), ArrayList::new));
        return distinctLabelSystemDatas;
    }

    public boolean exists(Wrapper<TodoField> queryWrapper) {
        Long count = this.todoFieldMapper.selectCount(queryWrapper);
        return null != count && count > 0L;
    }
}

