/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.configuration.mqtt.MqttGateway;
import com.digiwin.athena.semc.configuration.mqtt.MqttProperties;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.vo.portal.NoticeVO;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TodoNoticeMq {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TodoNoticeMq.class);
    @Resource
    private MqttGateway mqttGateway;
    @Resource
    private MqttProperties mqttConfiguration;
    @Resource
    private TodoListMapper todoListMapper;

    public void sendMessageToMqtt(NoticeVO noticeVO, List<TodoList> todoList) {
        try {
            String topic = this.mqttConfiguration.getClientId() + "/" + this.mqttConfiguration.getServerName() + "/" + "SEMC_TODO_USER";
            log.info("\u3010sendMessageToMqtt-\u5f85\u529e\u901a\u77e5\u7528\u6237\u3011topic:{}", (Object)topic);
            for (TodoList todo : todoList) {
                MessageDO payload = new MessageDO();
                payload.setUserId(todo.getToDoUser());
                payload.setAppId(noticeVO.getAppId());
                payload.setAppName(noticeVO.getAppName());
                payload.setType(Constants.VALID_STATUS_UNUSABLE);
                String message = JSON.toJSONString((Object)payload);
                this.mqttGateway.sendToMqtt(topic, 2, message);
                log.info("\u3010sendMessageToMqtt-\u5f85\u529e\u901a\u77e5\u7528\u6237\u6210\u529f\u3011topic:{}", (Object)topic);
            }
        }
        catch (Exception e) {
            log.info("\u3010sendMessageMq-\u5f85\u529e\u901a\u77e5\u7528\u6237\u6210\u529f\u3011e:{}", (Throwable)e);
        }
    }

    public List<TodoList> selectToDoBy(String appId, String toDoId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            queryWrapper.eq((Object)"app_id", (Object)appId);
        }
        if (StringUtils.isNotEmpty((CharSequence)toDoId)) {
            queryWrapper.eq((Object)"to_do_id", (Object)toDoId);
        }
        return this.todoListMapper.selectList((Wrapper)queryWrapper);
    }
}

