/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.semc.common.ErrorCodeConstant;
import com.digiwin.athena.semc.dto.portal.NoticeReq;
import com.digiwin.athena.semc.entity.portal.SyncToDoRecord;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.portal.TodoRead;
import com.digiwin.athena.semc.mapper.portal.SyncToDoRecordMapper;
import com.digiwin.athena.semc.service.cache.RedisLock;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.service.portal.TodoNoticeService;
import com.digiwin.athena.semc.service.portal.TodoReadService;
import com.digiwin.athena.semc.service.portal.impl.TodoNoticeMq;
import com.digiwin.athena.semc.util.AESUtils;
import com.digiwin.athena.semc.vo.portal.NoticeVO;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class TodoNoticeServiceImpl
implements TodoNoticeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TodoNoticeServiceImpl.class);
    @Resource
    private TodoListService todoListService;
    @Resource
    private TodoReadService todoReadService;
    @Resource
    TodoNoticeMq todoNoticeMq;
    @Resource
    private SyncToDoRecordMapper syncToDoRecordMapper;

    @Transactional(rollbackFor={Exception.class})
    public ResponseEntity<?> notice(NoticeReq noticeReq) {
        log.info("notice param:{}", (Object)JSON.toJSONString((Object)noticeReq));
        String bodyJsonStr = noticeReq.getBodyJsonStr();
        if (StringUtils.isEmpty((String)bodyJsonStr)) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing bodyJsonStr parameter");
        }
        String jsonBodyDecrypt = AESUtils.aesDecrypt((String)bodyJsonStr, (String)"Wr3t3568aXaH91T30000fMK3ZpOyv4");
        NoticeVO noticeVO = (NoticeVO)JSON.parseObject((String)jsonBodyDecrypt, NoticeVO.class);
        return this.noticeToDo(noticeVO, JSON.toJSONString((Object)noticeReq), Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<?> noticeToDo(NoticeVO noticeVO, String reqJson, Boolean isToWeb) {
        if (StringUtils.isEmpty((String)noticeVO.getBizId())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing bodyJsonStr parameter");
        }
        if (StringUtils.isEmpty((String)noticeVO.getAppId())) {
            return ResponseEntityWrapper.wrapperFail((int)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)"missing bodyJsonStr parameter");
        }
        SyncToDoRecord toDoRecord = new SyncToDoRecord();
        toDoRecord.setAppId(noticeVO.getAppId());
        toDoRecord.setToDoId(noticeVO.getBizId());
        toDoRecord.setDataModel(Integer.valueOf(1));
        toDoRecord.setReqJson(reqJson);
        toDoRecord.setSyncType(Integer.valueOf(0));
        toDoRecord.setSyncStatus(Integer.valueOf(0));
        List todoListDb = this.todoNoticeMq.selectToDoBy(noticeVO.getAppId(), noticeVO.getBizId());
        RedisLock redisLock = new RedisLock("thirdTodoNotice:" + noticeVO.getBizId());
        try {
            if (!redisLock.lock()) {
                return ResponseEntityWrapper.wrapperOk();
            }
        }
        catch (InterruptedException e) {
            return ResponseEntityWrapper.wrapperOk();
        }
        try {
            LambdaUpdateWrapper updateTodoListWrapper = new LambdaUpdateWrapper();
            updateTodoListWrapper.eq(TodoList::getAppId, (Object)noticeVO.getAppId());
            updateTodoListWrapper.eq(TodoList::getToDoId, (Object)noticeVO.getBizId());
            this.todoListService.remove((Wrapper)updateTodoListWrapper);
            LambdaUpdateWrapper updateTodoReadWrapper = new LambdaUpdateWrapper();
            updateTodoReadWrapper.eq(TodoRead::getAppId, (Object)noticeVO.getAppId());
            updateTodoReadWrapper.eq(TodoRead::getToDoId, (Object)noticeVO.getBizId());
            this.todoReadService.remove((Wrapper)updateTodoReadWrapper);
            if (isToWeb.booleanValue()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (Exception e) {
            log.error("notice third.todo.notice   error", (Throwable)e);
            toDoRecord.setSyncStatus(Integer.valueOf(1));
            toDoRecord.setRespJson(e.getMessage());
        }
        finally {
            redisLock.unlock();
        }
        this.syncToDoRecordMapper.addRecord(toDoRecord);
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> noticeBat(NoticeVO noticeReqList) {
        for (String bizId : noticeReqList.getBizIdList()) {
            noticeReqList.setBizId(bizId);
            this.noticeToDo(noticeReqList, JSON.toJSONString((Object)bizId), Boolean.valueOf(false));
        }
        return ResponseEntityWrapper.wrapperOk();
    }
}

