/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.configuration.mqtt.MqttGateway;
import com.digiwin.athena.semc.configuration.mqtt.MqttProperties;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.portal.TodosRefreshSet;
import com.digiwin.athena.semc.mapper.portal.TodosRefreshSetMapper;
import com.digiwin.athena.semc.service.portal.TodosRefreshSetService;
import com.digiwin.athena.semc.util.DateUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TodosRefreshSetServiceImpl
extends ServiceImpl<TodosRefreshSetMapper, TodosRefreshSet>
implements TodosRefreshSetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TodosRefreshSetServiceImpl.class);
    @Autowired
    private MqttGateway mqttGateway;
    @Autowired
    private MqttProperties mqttConfiguration;
    @Autowired
    private TodosRefreshSetMapper todosRefreshSetMapper;

    public TodosRefreshSet getRefreshSet(String tenantId) {
        return this.todosRefreshSetMapper.selByTenantId(tenantId);
    }

    @Transactional
    public int saveRefreshSet(TodosRefreshSet refreshSet) {
        TodosRefreshSet refreshSetDb = this.todosRefreshSetMapper.selByTenantId(refreshSet.getTenantId());
        if (null == refreshSetDb) {
            this.sendTodoMQ(refreshSet.getTenantId());
            return this.todosRefreshSetMapper.insert((Object)refreshSet);
        }
        refreshSetDb.setTodoDetailTime(refreshSet.getTodoDetailTime());
        refreshSetDb.setTabsTime(refreshSet.getTabsTime());
        refreshSetDb.setModifyUserId(refreshSet.getModifyUserId());
        refreshSetDb.setModifyTime(DateUtils.getNowTime((String)""));
        refreshSetDb.setIsOpen(refreshSet.getIsOpen());
        int i = this.todosRefreshSetMapper.updateById((Object)refreshSetDb);
        this.sendTodoMQ(refreshSetDb.getTenantId());
        return i;
    }

    public void sendTodoMQ(String tenantId) {
        try {
            String topic = this.mqttConfiguration.getClientId() + "/" + this.mqttConfiguration.getServerName() + "/" + "SEMC_TODO_TENANT" + "/" + tenantId;
            log.info("\u3010saveRefreshSet-\u901a\u77e5\u79df\u6237\u8bbe\u7f6e\u53d8\u66f4\u901a\u77e5\u5f00\u59cb\u3011topic:{},message:{}", (Object)topic, (Object)tenantId);
            MessageDO payload = new MessageDO();
            payload.setTenantId(tenantId);
            payload.setType(Constants.PRESCRIBED_ROUTE);
            String message = JSONObject.toJSONString((Object)payload);
            this.mqttGateway.sendToMqtt(topic, 2, message);
            log.info("\u3010saveRefreshSet-\u901a\u77e5\u79df\u6237\u8bbe\u7f6e\u53d8\u66f4\u901a\u77e5\u6210\u529f\u3011topic:{},message:{}", (Object)topic, (Object)tenantId);
        }
        catch (Exception e) {
            log.info("\u3010saveRefreshSet-\u901a\u77e5\u79df\u6237\u8bbe\u7f6e\u53d8\u66f4\u901a\u77e5\u5f02\u5e38\u3011TenantId:{},e:{}", (Object)tenantId, (Object)e);
        }
    }
}

