/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.semc.service.portal.impl;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import com.digiwin.athena.semc.entity.portal.TripartiteApplication;
import com.digiwin.athena.semc.mapper.portal.TripartiteApplicationMapper;
import com.digiwin.athena.semc.service.cache.CommonConfigService;
import com.digiwin.athena.semc.service.portal.TripartiteApplicationService;
import com.digiwin.athena.semc.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TripartiteApplicationServiceImpl
extends ServiceImpl<TripartiteApplicationMapper, TripartiteApplication>
implements TripartiteApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TripartiteApplicationServiceImpl.class);
    @Resource
    TripartiteApplicationMapper tripartiteApplicationMapper;
    @Resource
    CommonConfigService commonConfigService;

    public List<TripartiteApplication> queryTripartiteAppList() {
        List applicationList = this.tripartiteApplicationMapper.selectList((Wrapper)Wrappers.emptyWrapper());
        List baseApplicationList = applicationList.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getTenantId())).collect(Collectors.toList());
        List<TripartiteApplication> tenantApplicationList = applicationList.stream().filter(x -> Utils.getTenantId().equals(x.getTenantId())).collect(Collectors.toList());
        List tenantApplicationCodeList = tenantApplicationList.stream().map(TripartiteApplication::getApplicationCode).collect(Collectors.toList());
        List<TripartiteApplication> needInitializeList = baseApplicationList.stream().filter(x -> !tenantApplicationCodeList.contains(x.getApplicationCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needInitializeList)) {
            needInitializeList.forEach(x -> {
                x.setId(null);
                x.setTenantId(Utils.getTenantId());
                this.tripartiteApplicationMapper.insert(x);
                tenantApplicationList.add((TripartiteApplication)x);
            });
        }
        return tenantApplicationList;
    }

    public FineReportConfigDTO queryFineReportConfig() {
        FineReportConfigDTO fineReportConfigDTO = this.commonConfigService.queryFineReportConfigCache(Utils.getTenantId());
        if (ObjectUtils.isEmpty((Object)fineReportConfigDTO)) {
            LambdaQueryWrapper condition = new LambdaQueryWrapper();
            condition.eq(TripartiteApplication::getTenantId, (Object)Utils.getTenantId());
            List tripartiteApplicationList = this.tripartiteApplicationMapper.selectList((Wrapper)condition);
            if (CollectionUtils.isEmpty((Collection)tripartiteApplicationList)) {
                return null;
            }
            TripartiteApplication tripartiteApplication = (TripartiteApplication)tripartiteApplicationList.get(0);
            fineReportConfigDTO = (FineReportConfigDTO)JSON.parseObject((String)tripartiteApplication.getApplicationConfig(), FineReportConfigDTO.class);
            this.commonConfigService.setFineReportConfigCache(fineReportConfigDTO, Utils.getTenantId());
        }
        return fineReportConfigDTO;
    }
}

